/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.templates.res;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateError;
import org.mvel2.templates.TemplateRuntime;
import org.mvel2.templates.res.Node;
import org.mvel2.templates.util.TemplateOutputStream;
import org.mvel2.templates.util.TemplateTools;

public class CompiledIncludeNode
extends Node {
    private Serializable cIncludeExpression;
    private Serializable cPreExpression;
    private long fileDateStamp;
    private CompiledTemplate cFileCache;
    private ParserContext context;

    public CompiledIncludeNode(int begin, String name, char[] template, int start, int end, ParserContext context2) {
        this.begin = begin;
        this.name = name;
        this.contents = template;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        this.context = context2;
        int mark = TemplateTools.captureToEOS(this.contents, this.cStart);
        this.cIncludeExpression = MVEL.compileExpression(this.contents, this.cStart, mark - this.cStart, context2);
        if (mark != this.contents.length) {
            this.cPreExpression = MVEL.compileExpression(this.contents, ++mark, this.cEnd - mark, context2);
        }
    }

    @Override
    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file2 = MVEL.executeExpression((Object)this.cIncludeExpression, ctx, factory, String.class);
        if (this.cPreExpression != null) {
            MVEL.executeExpression((Object)this.cPreExpression, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(this.readFile(runtime, file2, ctx, factory), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(this.readFile(runtime, file2, ctx, factory), ctx, factory)));
    }

    private String readFile(TemplateRuntime runtime, String fileName, Object ctx, VariableResolverFactory factory) {
        File file2 = new File(String.valueOf(runtime.getRelPath().peek()) + "/" + fileName);
        if (this.fileDateStamp == 0L || this.fileDateStamp != file2.lastModified()) {
            this.fileDateStamp = file2.lastModified();
            this.cFileCache = TemplateCompiler.compileTemplate(CompiledIncludeNode.readInFile(runtime, file2), this.context);
        }
        return String.valueOf(TemplateRuntime.execute(this.cFileCache, ctx, factory));
    }

    @Override
    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    public static String readInFile(TemplateRuntime runtime, File file2) {
        FileInputStream instream = null;
        BufferedReader in = null;
        StringBuilder appender = new StringBuilder();
        try {
            String currentLine;
            instream = CompiledIncludeNode.openInputStream(file2);
            runtime.getRelPath().push(file2.getParent());
            in = new BufferedReader(new InputStreamReader((InputStream)instream, "UTF-8"));
            while ((currentLine = in.readLine()) != null) {
                appender.append(currentLine);
            }
            runtime.getRelPath().pop();
            String string = appender.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + file2.getPath() + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + file2.getPath() + "' (stacktrace nested)", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new TemplateError("cannot close the reader on template file '" + file2.getPath() + "'.");
                }
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    throw new TemplateError("cannot close the stream on template file '" + file2.getPath() + "'.");
                }
            }
        }
    }

    private static FileInputStream openInputStream(File file2) throws IOException {
        if (file2 == null) {
            throw new FileNotFoundException("file parameter is null");
        }
        if (file2.exists()) {
            if (file2.isDirectory()) {
                throw new IOException("File '" + file2 + "' exists but is a directory");
            }
            if (!file2.canRead()) {
                throw new IOException("File '" + file2 + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file2 + "' does not exist");
        }
        return new FileInputStream(file2);
    }
}

