/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.localization;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.localization.Messages;
import org.islandoftex.arara.core.localization.BrazilianLanguage;
import org.islandoftex.arara.core.localization.DutchLanguage;
import org.islandoftex.arara.core.localization.GermanLanguage;
import org.islandoftex.arara.core.localization.ItalianLanguage;
import org.islandoftex.arara.core.localization.NorfolkLanguage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/islandoftex/arara/core/localization/LanguageController;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "Lorg/islandoftex/arara/api/localization/Messages;", "messages", "getMessages$annotations", "getMessages", "()Lorg/islandoftex/arara/api/localization/Messages;", "setLocale", "", "locale", "Ljava/util/Locale;", "core"})
public final class LanguageController {
    @NotNull
    public static final LanguageController INSTANCE = new LanguageController();
    private static final Logger logger = LoggerFactory.getLogger(LanguageController.class);
    @NotNull
    private static Messages messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);

    private LanguageController() {
    }

    @NotNull
    public static final Messages getMessages() {
        return messages;
    }

    @JvmStatic
    public static /* synthetic */ void getMessages$annotations() {
    }

    @JvmStatic
    public static final void setLocale(@NotNull Locale locale) {
        Messages messages;
        Intrinsics.checkNotNullParameter(locale, "locale");
        Locale locale2 = locale;
        if (Intrinsics.areEqual(locale2, Locale.GERMAN)) {
            messages = new GermanLanguage();
        } else if (Intrinsics.areEqual(locale2, Locale.ITALIAN)) {
            messages = new ItalianLanguage();
        } else if (Intrinsics.areEqual(locale2, Locale.forLanguageTag("nl"))) {
            messages = new DutchLanguage();
        } else if (Intrinsics.areEqual(locale2, Locale.forLanguageTag("pt-BR"))) {
            messages = new BrazilianLanguage();
        } else if (Intrinsics.areEqual(locale2, Locale.forLanguageTag("en-QN"))) {
            messages = new NorfolkLanguage();
        } else if (Intrinsics.areEqual(locale2, Locale.ENGLISH)) {
            messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);
        } else {
            logger.warn("Language " + locale.getDisplayLanguage() + " not available; defaulting to English.");
            messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);
        }
        LanguageController.messages = messages;
    }
}

