/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAudioBuffer;

public final class SoftFilter {
    public static final int FILTERTYPE_LP6 = 0;
    public static final int FILTERTYPE_LP12 = 1;
    public static final int FILTERTYPE_HP12 = 17;
    public static final int FILTERTYPE_BP12 = 33;
    public static final int FILTERTYPE_NP12 = 49;
    public static final int FILTERTYPE_LP24 = 3;
    public static final int FILTERTYPE_HP24 = 19;
    private int filtertype = 0;
    private final float samplerate;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float xx1;
    private float xx2;
    private float yy1;
    private float yy2;
    private float a0;
    private float a1;
    private float a2;
    private float b1;
    private float b2;
    private float q;
    private float gain = 1.0f;
    private float wet = 0.0f;
    private float last_wet = 0.0f;
    private float last_a0;
    private float last_a1;
    private float last_a2;
    private float last_b1;
    private float last_b2;
    private float last_q;
    private float last_gain;
    private boolean last_set = false;
    private double cutoff = 44100.0;
    private double resonancedB = 0.0;
    private boolean dirty = true;

    public SoftFilter(float f) {
        this.samplerate = f;
        this.dirty = true;
    }

    public void setFrequency(double d) {
        if (this.cutoff == d) {
            return;
        }
        this.cutoff = d;
        this.dirty = true;
    }

    public void setResonance(double d) {
        if (this.resonancedB == d) {
            return;
        }
        this.resonancedB = d;
        this.dirty = true;
    }

    public void reset() {
        this.dirty = true;
        this.last_set = false;
        this.x1 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.y2 = 0.0f;
        this.xx1 = 0.0f;
        this.xx2 = 0.0f;
        this.yy1 = 0.0f;
        this.yy2 = 0.0f;
        this.wet = 0.0f;
        this.gain = 1.0f;
        this.a0 = 0.0f;
        this.a1 = 0.0f;
        this.a2 = 0.0f;
        this.b1 = 0.0f;
        this.b2 = 0.0f;
    }

    public void setFilterType(int n) {
        this.filtertype = n;
    }

    public void processAudio(SoftAudioBuffer softAudioBuffer) {
        if (this.filtertype == 0) {
            this.filter1(softAudioBuffer);
        }
        if (this.filtertype == 1) {
            this.filter2(softAudioBuffer);
        }
        if (this.filtertype == 17) {
            this.filter2(softAudioBuffer);
        }
        if (this.filtertype == 33) {
            this.filter2(softAudioBuffer);
        }
        if (this.filtertype == 49) {
            this.filter2(softAudioBuffer);
        }
        if (this.filtertype == 3) {
            this.filter4(softAudioBuffer);
        }
        if (this.filtertype == 19) {
            this.filter4(softAudioBuffer);
        }
    }

    public void filter4(SoftAudioBuffer softAudioBuffer) {
        float[] fArray = softAudioBuffer.array();
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            int n = fArray.length;
            float f = this.last_a0;
            float f2 = this.last_a1;
            float f3 = this.last_a2;
            float f4 = this.last_b1;
            float f5 = this.last_b2;
            float f6 = this.last_gain;
            float f7 = this.last_wet;
            float f8 = (this.a0 - this.last_a0) / (float)n;
            float f9 = (this.a1 - this.last_a1) / (float)n;
            float f10 = (this.a2 - this.last_a2) / (float)n;
            float f11 = (this.b1 - this.last_b1) / (float)n;
            float f12 = (this.b2 - this.last_b2) / (float)n;
            float f13 = (this.gain - this.last_gain) / (float)n;
            float f14 = (this.wet - this.last_wet) / (float)n;
            float f15 = this.x1;
            float f16 = this.x2;
            float f17 = this.y1;
            float f18 = this.y2;
            float f19 = this.xx1;
            float f20 = this.xx2;
            float f21 = this.yy1;
            float f22 = this.yy2;
            if (f14 != 0.0f) {
                for (int i = 0; i < n; ++i) {
                    float f23 = fArray[i];
                    float f24 = (f += f8) * f23 + (f2 += f9) * f15 + (f3 += f10) * f16 - (f4 += f11) * f17 - (f5 += f12) * f18;
                    float f25 = f24 * (f6 += f13) * (f7 += f14) + f23 * (1.0f - f7);
                    f16 = f15;
                    f15 = f23;
                    f18 = f17;
                    f17 = f24;
                    float f26 = f * f25 + f2 * f19 + f3 * f20 - f4 * f21 - f5 * f22;
                    fArray[i] = f26 * f6 * f7 + f25 * (1.0f - f7);
                    f20 = f19;
                    f19 = f25;
                    f22 = f21;
                    f21 = f26;
                }
            } else if (f8 == 0.0f && f9 == 0.0f && f10 == 0.0f && f11 == 0.0f && f12 == 0.0f) {
                for (int i = 0; i < n; ++i) {
                    float f27 = fArray[i];
                    float f28 = f * f27 + f2 * f15 + f3 * f16 - f4 * f17 - f5 * f18;
                    float f29 = f28 * f6 * f7 + f27 * (1.0f - f7);
                    f16 = f15;
                    f15 = f27;
                    f18 = f17;
                    f17 = f28;
                    float f30 = f * f29 + f2 * f19 + f3 * f20 - f4 * f21 - f5 * f22;
                    fArray[i] = f30 * f6 * f7 + f29 * (1.0f - f7);
                    f20 = f19;
                    f19 = f29;
                    f22 = f21;
                    f21 = f30;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    float f31 = fArray[i];
                    float f32 = (f += f8) * f31 + (f2 += f9) * f15 + (f3 += f10) * f16 - (f4 += f11) * f17 - (f5 += f12) * f18;
                    float f33 = f32 * (f6 += f13) * f7 + f31 * (1.0f - f7);
                    f16 = f15;
                    f15 = f31;
                    f18 = f17;
                    f17 = f32;
                    float f34 = f * f33 + f2 * f19 + f3 * f20 - f4 * f21 - f5 * f22;
                    fArray[i] = f34 * f6 * f7 + f33 * (1.0f - f7);
                    f20 = f19;
                    f19 = f33;
                    f22 = f21;
                    f21 = f34;
                }
            }
            if ((double)Math.abs(f15) < 1.0E-8) {
                f15 = 0.0f;
            }
            if ((double)Math.abs(f16) < 1.0E-8) {
                f16 = 0.0f;
            }
            if ((double)Math.abs(f17) < 1.0E-8) {
                f17 = 0.0f;
            }
            if ((double)Math.abs(f18) < 1.0E-8) {
                f18 = 0.0f;
            }
            this.x1 = f15;
            this.x2 = f16;
            this.y1 = f17;
            this.y2 = f18;
            this.xx1 = f19;
            this.xx2 = f20;
            this.yy1 = f21;
            this.yy2 = f22;
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    private double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) * 0.5;
    }

    public void filter2calc() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = this.resonancedB;
        if (d14 < 0.0) {
            d14 = 0.0;
        }
        if (d14 > 30.0) {
            d14 = 30.0;
        }
        if (this.filtertype == 3 || this.filtertype == 19) {
            d14 *= 0.6;
        }
        if (this.filtertype == 33) {
            this.wet = 1.0f;
            d13 = this.cutoff / (double)this.samplerate;
            if (d13 > 0.45) {
                d13 = 0.45;
            }
            d12 = Math.PI * Math.pow(10.0, -(d14 / 20.0));
            d11 = Math.PI * 2 * d13;
            d10 = Math.cos(d11);
            d9 = Math.sin(d11);
            d7 = d8 = d9 * this.sinh(Math.log(2.0) * d12 * d11 / (d9 * 2.0));
            d6 = 0.0;
            d5 = -d8;
            d4 = 1.0 + d8;
            d3 = -2.0 * d10;
            d2 = 1.0 - d8;
            d = 1.0 / d4;
            this.b1 = (float)(d3 * d);
            this.b2 = (float)(d2 * d);
            this.a0 = (float)(d7 * d);
            this.a1 = (float)(d6 * d);
            this.a2 = (float)(d5 * d);
        }
        if (this.filtertype == 49) {
            this.wet = 1.0f;
            d13 = this.cutoff / (double)this.samplerate;
            if (d13 > 0.45) {
                d13 = 0.45;
            }
            d12 = Math.PI * Math.pow(10.0, -(d14 / 20.0));
            d11 = Math.PI * 2 * d13;
            d10 = Math.cos(d11);
            d9 = Math.sin(d11);
            d8 = d9 * this.sinh(Math.log(2.0) * d12 * d11 / (d9 * 2.0));
            d7 = 1.0;
            d6 = -2.0 * d10;
            d5 = 1.0;
            d4 = 1.0 + d8;
            d3 = -2.0 * d10;
            d2 = 1.0 - d8;
            d = 1.0 / d4;
            this.b1 = (float)(d3 * d);
            this.b2 = (float)(d2 * d);
            this.a0 = (float)(d7 * d);
            this.a1 = (float)(d6 * d);
            this.a2 = (float)(d5 * d);
        }
        if (this.filtertype == 1 || this.filtertype == 3) {
            d13 = this.cutoff / (double)this.samplerate;
            if (d13 > 0.45) {
                if (this.wet == 0.0f) {
                    this.wet = d14 < 1.0E-5 ? 0.0f : 1.0f;
                }
                d13 = 0.45;
            } else {
                this.wet = 1.0f;
            }
            d12 = 1.0 / Math.tan(Math.PI * d13);
            d11 = d12 * d12;
            d10 = Math.pow(10.0, -(d14 / 20.0));
            d9 = Math.sqrt(2.0) * d10;
            d8 = 1.0 / (1.0 + d9 * d12 + d11);
            d7 = 2.0 * d8;
            d6 = d8;
            d5 = 2.0 * d8 * (1.0 - d11);
            d4 = d8 * (1.0 - d9 * d12 + d11);
            this.a0 = (float)d8;
            this.a1 = (float)d7;
            this.a2 = (float)d6;
            this.b1 = (float)d5;
            this.b2 = (float)d4;
        }
        if (this.filtertype == 17 || this.filtertype == 19) {
            d13 = this.cutoff / (double)this.samplerate;
            if (d13 > 0.45) {
                d13 = 0.45;
            }
            if (d13 < 1.0E-4) {
                d13 = 1.0E-4;
            }
            this.wet = 1.0f;
            d12 = Math.tan(Math.PI * d13);
            d11 = d12 * d12;
            d10 = Math.pow(10.0, -(d14 / 20.0));
            d9 = Math.sqrt(2.0) * d10;
            d8 = 1.0 / (1.0 + d9 * d12 + d11);
            d7 = -2.0 * d8;
            d6 = d8;
            d5 = 2.0 * d8 * (d11 - 1.0);
            d4 = d8 * (1.0 - d9 * d12 + d11);
            this.a0 = (float)d8;
            this.a1 = (float)d7;
            this.a2 = (float)d6;
            this.b1 = (float)d5;
            this.b2 = (float)d4;
        }
    }

    public void filter2(SoftAudioBuffer softAudioBuffer) {
        float[] fArray = softAudioBuffer.array();
        if (this.dirty) {
            this.filter2calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_a1 = this.a1;
            this.last_a2 = this.a2;
            this.last_b1 = this.b1;
            this.last_b2 = this.b2;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            int n = fArray.length;
            float f = this.last_a0;
            float f2 = this.last_a1;
            float f3 = this.last_a2;
            float f4 = this.last_b1;
            float f5 = this.last_b2;
            float f6 = this.last_gain;
            float f7 = this.last_wet;
            float f8 = (this.a0 - this.last_a0) / (float)n;
            float f9 = (this.a1 - this.last_a1) / (float)n;
            float f10 = (this.a2 - this.last_a2) / (float)n;
            float f11 = (this.b1 - this.last_b1) / (float)n;
            float f12 = (this.b2 - this.last_b2) / (float)n;
            float f13 = (this.gain - this.last_gain) / (float)n;
            float f14 = (this.wet - this.last_wet) / (float)n;
            float f15 = this.x1;
            float f16 = this.x2;
            float f17 = this.y1;
            float f18 = this.y2;
            if (f14 != 0.0f) {
                for (int i = 0; i < n; ++i) {
                    float f19 = fArray[i];
                    float f20 = (f += f8) * f19 + (f2 += f9) * f15 + (f3 += f10) * f16 - (f4 += f11) * f17 - (f5 += f12) * f18;
                    fArray[i] = f20 * (f6 += f13) * (f7 += f14) + f19 * (1.0f - f7);
                    f16 = f15;
                    f15 = f19;
                    f18 = f17;
                    f17 = f20;
                }
            } else if (f8 == 0.0f && f9 == 0.0f && f10 == 0.0f && f11 == 0.0f && f12 == 0.0f) {
                for (int i = 0; i < n; ++i) {
                    float f21 = fArray[i];
                    float f22 = f * f21 + f2 * f15 + f3 * f16 - f4 * f17 - f5 * f18;
                    fArray[i] = f22 * f6;
                    f16 = f15;
                    f15 = f21;
                    f18 = f17;
                    f17 = f22;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    float f23 = fArray[i];
                    float f24 = (f += f8) * f23 + (f2 += f9) * f15 + (f3 += f10) * f16 - (f4 += f11) * f17 - (f5 += f12) * f18;
                    fArray[i] = f24 * (f6 += f13);
                    f16 = f15;
                    f15 = f23;
                    f18 = f17;
                    f17 = f24;
                }
            }
            if ((double)Math.abs(f15) < 1.0E-8) {
                f15 = 0.0f;
            }
            if ((double)Math.abs(f16) < 1.0E-8) {
                f16 = 0.0f;
            }
            if ((double)Math.abs(f17) < 1.0E-8) {
                f17 = 0.0f;
            }
            if ((double)Math.abs(f18) < 1.0E-8) {
                f18 = 0.0f;
            }
            this.x1 = f15;
            this.x2 = f16;
            this.y1 = f17;
            this.y2 = f18;
        }
        this.last_a0 = this.a0;
        this.last_a1 = this.a1;
        this.last_a2 = this.a2;
        this.last_b1 = this.b1;
        this.last_b2 = this.b2;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }

    public void filter1calc() {
        double d;
        if (this.cutoff < 120.0) {
            this.cutoff = 120.0;
        }
        if ((d = 7.3303828583761845 * this.cutoff / (double)this.samplerate) > 1.0) {
            d = 1.0;
        }
        this.a0 = (float)(Math.sqrt(1.0 - Math.cos(d)) * Math.sqrt(1.5707963267948966));
        if (this.resonancedB < 0.0) {
            this.resonancedB = 0.0;
        }
        if (this.resonancedB > 20.0) {
            this.resonancedB = 20.0;
        }
        this.q = (float)(Math.sqrt(0.5) * Math.pow(10.0, -(this.resonancedB / 20.0)));
        this.gain = (float)Math.pow(10.0, -this.resonancedB / 40.0);
        if (this.wet == 0.0f && (this.resonancedB > 1.0E-5 || d < 0.9999999)) {
            this.wet = 1.0f;
        }
    }

    public void filter1(SoftAudioBuffer softAudioBuffer) {
        if (this.dirty) {
            this.filter1calc();
            this.dirty = false;
        }
        if (!this.last_set) {
            this.last_a0 = this.a0;
            this.last_q = this.q;
            this.last_gain = this.gain;
            this.last_wet = this.wet;
            this.last_set = true;
        }
        if (this.wet > 0.0f || this.last_wet > 0.0f) {
            float[] fArray = softAudioBuffer.array();
            int n = fArray.length;
            float f = this.last_a0;
            float f2 = this.last_q;
            float f3 = this.last_gain;
            float f4 = this.last_wet;
            float f5 = (this.a0 - this.last_a0) / (float)n;
            float f6 = (this.q - this.last_q) / (float)n;
            float f7 = (this.gain - this.last_gain) / (float)n;
            float f8 = (this.wet - this.last_wet) / (float)n;
            float f9 = this.y2;
            float f10 = this.y1;
            if (f8 != 0.0f) {
                for (int i = 0; i < n; ++i) {
                    float f11 = 1.0f - (f2 += f6) * (f += f5);
                    f10 = f11 * f10 + f * (fArray[i] - f9);
                    f9 = f11 * f9 + f * f10;
                    fArray[i] = f9 * (f3 += f7) * (f4 += f8) + fArray[i] * (1.0f - f4);
                }
            } else if (f5 == 0.0f && f6 == 0.0f) {
                float f12 = 1.0f - f2 * f;
                for (int i = 0; i < n; ++i) {
                    f10 = f12 * f10 + f * (fArray[i] - f9);
                    f9 = f12 * f9 + f * f10;
                    fArray[i] = f9 * f3;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    float f13 = 1.0f - (f2 += f6) * (f += f5);
                    f10 = f13 * f10 + f * (fArray[i] - f9);
                    f9 = f13 * f9 + f * f10;
                    fArray[i] = f9 * (f3 += f7);
                }
            }
            if ((double)Math.abs(f9) < 1.0E-8) {
                f9 = 0.0f;
            }
            if ((double)Math.abs(f10) < 1.0E-8) {
                f10 = 0.0f;
            }
            this.y2 = f9;
            this.y1 = f10;
        }
        this.last_a0 = this.a0;
        this.last_q = this.q;
        this.last_gain = this.gain;
        this.last_wet = this.wet;
    }
}

