/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.config.ConfigNameConstants;
import org.apache.solr.handler.dataimport.config.ConfigParseUtil;
import org.apache.solr.handler.dataimport.config.DIHConfiguration;
import org.apache.solr.handler.dataimport.config.EntityField;
import org.apache.solr.schema.SchemaField;
import org.w3c.dom.Element;

public class Entity {
    private final String name;
    private final String pk;
    private final String pkMappingFromSchema;
    private final String dataSourceName;
    private final String processorName;
    private final Entity parentEntity;
    private final boolean docRoot;
    private final boolean child;
    private final List<Entity> children;
    private final List<EntityField> fields;
    private final Map<String, Set<EntityField>> colNameVsField;
    private final Map<String, String> allAttributes;
    private final List<Map<String, String>> allFieldAttributes;
    private final DIHConfiguration config;

    /*
     * WARNING - void declaration
     */
    public Entity(boolean docRootFound, Element element, DataImporter di, DIHConfiguration config, Entity parent) {
        void var15_20;
        SchemaField schemaField;
        this.parentEntity = parent;
        this.config = config;
        String modName = ConfigParseUtil.getStringAttribute(element, "name", null);
        if (modName == null) {
            throw new DataImportHandlerException(500, "Entity must have a name.");
        }
        if (modName.indexOf(".") != -1) {
            throw new DataImportHandlerException(500, "Entity name must not have period (.): '" + modName);
        }
        if (ConfigNameConstants.RESERVED_WORDS.contains(modName)) {
            throw new DataImportHandlerException(500, "Entity name : '" + modName + "' is a reserved keyword. Reserved words are: " + ConfigNameConstants.RESERVED_WORDS);
        }
        this.name = modName;
        this.pk = ConfigParseUtil.getStringAttribute(element, "pk", null);
        this.processorName = ConfigParseUtil.getStringAttribute(element, "processor", null);
        this.dataSourceName = ConfigParseUtil.getStringAttribute(element, "dataSource", null);
        String rawDocRootValue = ConfigParseUtil.getStringAttribute(element, "rootEntity", null);
        this.docRoot = !docRootFound && !"false".equals(rawDocRootValue);
        String childValue = ConfigParseUtil.getStringAttribute(element, "child", null);
        this.child = "true".equals(childValue);
        HashMap<String, String> modAttributes = ConfigParseUtil.getAllAttributes(element);
        modAttributes.put("dataSource", this.dataSourceName);
        this.allAttributes = Collections.unmodifiableMap(modAttributes);
        List<Element> n = ConfigParseUtil.getChildNodes(element, "field");
        ArrayList<EntityField> modFields = new ArrayList<EntityField>(n.size());
        HashMap modColNameVsField = new HashMap();
        ArrayList<Map<String, String>> modAllFieldAttributes = new ArrayList<Map<String, String>>();
        for (Element element2 : n) {
            HashSet<EntityField> fieldSet;
            EntityField.Builder builder = new EntityField.Builder(element2);
            if (config.getSchema() != null) {
                if (builder.getNameOrColumn() != null && builder.getNameOrColumn().contains("${")) {
                    builder.dynamicName = true;
                } else {
                    SchemaField schemaField2 = config.getSchemaField(builder.getNameOrColumn());
                    if (schemaField2 != null) {
                        builder.name = schemaField2.getName();
                        builder.multiValued = schemaField2.multiValued();
                        builder.allAttributes.put("multiValued", Boolean.toString(schemaField2.multiValued()));
                        builder.allAttributes.put("type", schemaField2.getType().getTypeName());
                        builder.allAttributes.put("indexed", Boolean.toString(schemaField2.indexed()));
                        builder.allAttributes.put("stored", Boolean.toString(schemaField2.stored()));
                        builder.allAttributes.put("defaultValue", schemaField2.getDefaultValue());
                    } else {
                        builder.toWrite = false;
                    }
                }
            }
            if ((fieldSet = (HashSet<EntityField>)modColNameVsField.get(builder.column)) == null) {
                fieldSet = new HashSet<EntityField>();
                modColNameVsField.put(builder.column, fieldSet);
            }
            builder.allAttributes.put("boost", Float.toString(builder.boost));
            builder.allAttributes.put("toWrite", Boolean.toString(builder.toWrite));
            modAllFieldAttributes.add(builder.allAttributes);
            builder.entity = this;
            EntityField field = new EntityField(builder);
            fieldSet.add(field);
            modFields.add(field);
        }
        HashMap modColNameVsField1 = new HashMap();
        for (Map.Entry entry : modColNameVsField.entrySet()) {
            if (((Set)entry.getValue()).size() <= 0) continue;
            modColNameVsField1.put((String)entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.colNameVsField = Collections.unmodifiableMap(modColNameVsField1);
        this.fields = Collections.unmodifiableList(modFields);
        this.allFieldAttributes = Collections.unmodifiableList(modAllFieldAttributes);
        Object var15_17 = null;
        if (config.getSchema() != null && (schemaField = config.getSchema().getUniqueKeyField()) != null) {
            String string = schemaField.getName();
            for (EntityField field : this.fields) {
                if (!field.getName().equals(string)) continue;
                String string2 = field.getColumn();
                break;
            }
        }
        this.pkMappingFromSchema = var15_20;
        n = ConfigParseUtil.getChildNodes(element, "entity");
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Element elem : n) {
            arrayList.add(new Entity(docRootFound || this.docRoot, elem, di, config, this));
        }
        this.children = Collections.unmodifiableList(arrayList);
    }

    public String getPk() {
        return this.pk == null ? this.pkMappingFromSchema : this.pk;
    }

    public String getSchemaPk() {
        return this.pkMappingFromSchema != null ? this.pkMappingFromSchema : this.pk;
    }

    public String getName() {
        return this.name;
    }

    public String getPkMappingFromSchema() {
        return this.pkMappingFromSchema;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public Entity getParentEntity() {
        return this.parentEntity;
    }

    public boolean isDocRoot() {
        return this.docRoot;
    }

    public List<Entity> getChildren() {
        return this.children;
    }

    public List<EntityField> getFields() {
        return this.fields;
    }

    public Map<String, Set<EntityField>> getColNameVsField() {
        return this.colNameVsField;
    }

    public Map<String, String> getAllAttributes() {
        return this.allAttributes;
    }

    public List<Map<String, String>> getAllFieldsList() {
        return this.allFieldAttributes;
    }

    public boolean isChild() {
        return this.child;
    }
}

