/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import org.springframework.boot.actuate.autoconfigure.health.HealthContributorRegistryHealthIndicatorRegistryAdapter;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.autoconfigure.health.ReactiveHealthContributorRegistryReactiveHealthIndicatorRegistryAdapter;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={HealthIndicatorProperties.class})
class LegacyHealthEndpointCompatibilityConfiguration {
    LegacyHealthEndpointCompatibilityConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    HealthAggregator healthAggregator(HealthIndicatorProperties healthIndicatorProperties) {
        OrderedHealthAggregator aggregator = new OrderedHealthAggregator();
        if (!CollectionUtils.isEmpty(healthIndicatorProperties.getOrder())) {
            aggregator.setStatusOrder(healthIndicatorProperties.getOrder());
        }
        return aggregator;
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthIndicatorRegistry.class})
    HealthContributorRegistryHealthIndicatorRegistryAdapter healthIndicatorRegistry(HealthContributorRegistry healthContributorRegistry) {
        return new HealthContributorRegistryHealthIndicatorRegistryAdapter(healthContributorRegistry);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Mono.class})
    static class LegacyReactiveHealthEndpointCompatibilityConfiguration {
        LegacyReactiveHealthEndpointCompatibilityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveHealthIndicatorRegistry.class})
        ReactiveHealthContributorRegistryReactiveHealthIndicatorRegistryAdapter reactiveHealthIndicatorRegistry(ReactiveHealthContributorRegistry reactiveHealthContributorRegistry) {
            return new ReactiveHealthContributorRegistryReactiveHealthIndicatorRegistryAdapter(reactiveHealthContributorRegistry);
        }
    }
}

