/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.BooleanStreamEqualFunction;
import org.apache.solr.analytics.function.mapping.BooleanValueEqualFunction;
import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.function.mapping.StreamEqualFunction;
import org.apache.solr.analytics.function.mapping.ValueEqualFunction;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class EqualFunction {
    public static final String name = "equal";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The equal function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream paramA = params[0];
        AnalyticsValueStream paramB = params[1];
        if (paramA instanceof BooleanValueStream && paramB instanceof BooleanValueStream) {
            if (paramA instanceof BooleanValue) {
                if (paramB instanceof BooleanValue) {
                    return new BooleanValueEqualFunction((BooleanValue)paramA, (BooleanValue)paramB);
                }
                return new BooleanStreamEqualFunction((BooleanValue)paramA, (BooleanValueStream)paramB);
            }
            if (paramB instanceof BooleanValue) {
                return new BooleanStreamEqualFunction((BooleanValue)paramB, (BooleanValueStream)paramA);
            }
        } else {
            if (paramA instanceof DoubleValueStream && paramB instanceof DoubleValueStream) {
                return ComparisonFunction.createComparisonFunction(name, val -> val == 0, params);
            }
            if (paramA instanceof AnalyticsValue) {
                if (paramB instanceof AnalyticsValue) {
                    return new ValueEqualFunction((AnalyticsValue)paramA, (AnalyticsValue)paramB);
                }
                return new StreamEqualFunction((AnalyticsValue)paramA, paramB);
            }
            if (paramB instanceof AnalyticsValue) {
                return new StreamEqualFunction((AnalyticsValue)paramB, paramA);
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The equal function requires that at least 1 parameter be single-valued.");
    };
}

