/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.langdetect.LanguageDetectorModelLoader;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class LanguageDetectorTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learned language detector";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < documents";
    }

    @Override
    public void run(String[] args) {
        if (0 == args.length) {
            System.out.println(this.getHelp());
        } else {
            LanguageDetectorModel model = (LanguageDetectorModel)new LanguageDetectorModelLoader().load(new File(args[0]));
            LanguageDetectorME langDetectME = new LanguageDetectorME(model);
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "doc");
            perfMon.start();
            try {
                String document;
                ParagraphStream documentStream = new ParagraphStream(new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding()));
                while ((document = (String)documentStream.read()) != null) {
                    Language lang = langDetectME.predictLanguage(document);
                    LanguageSample sample = new LanguageSample(lang, document);
                    System.out.println(sample.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

