/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;

class SubQueryAugmenter
extends DocTransformer {
    private final String name;
    private final SolrParams baseSubParams;
    private final String prefix;
    private final String separator;
    private final SolrClient server;
    private final String coreName;

    public SubQueryAugmenter(SolrClient server, String coreName, String name, String prefix, SolrParams baseSubParams, String separator) {
        this.name = name;
        this.prefix = prefix;
        this.baseSubParams = baseSubParams;
        this.separator = separator;
        this.server = server;
        this.coreName = coreName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        return false;
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        SolrParams docWithDeprefixed = SolrParams.wrapDefaults((SolrParams)new DocRowParams(doc, this.prefix, this.separator), (SolrParams)this.baseSubParams);
        try {
            QueryResponse rsp = this.server.query(this.coreName, docWithDeprefixed);
            SolrDocumentList docList = rsp.getResults();
            doc.setField(this.getName(), (Object)new Result(docList));
        }
        catch (Exception e) {
            String docString = doc.toString();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "while invoking " + this.name + ":[subquery" + (this.coreName != null ? "fromIndex=" + this.coreName : "") + "] on doc=" + docString.substring(0, Math.min(100, docString.length())), e.getCause());
        }
    }

    static final class DocRowParams
    extends SolrParams {
        private final SolrDocument doc;
        private final String prefixDotRowDot;
        private final String separator;

        public DocRowParams(SolrDocument doc, String prefix, String separator) {
            this.doc = doc;
            this.prefixDotRowDot = "row.";
            this.separator = separator;
        }

        public String[] getParams(String param) {
            Collection<Object> vals = this.mapToDocField(param);
            if (vals != null) {
                StringBuilder rez = new StringBuilder();
                Iterator<Object> iterator = vals.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    rez.append(this.convertFieldValue(object));
                    if (!iterator.hasNext()) continue;
                    rez.append(this.separator);
                }
                return new String[]{rez.toString()};
            }
            return null;
        }

        public String get(String param) {
            String[] aVal = this.getParams(param);
            if (aVal != null) {
                assert (aVal.length == 1) : "that's how getParams is written";
                return aVal[0];
            }
            return null;
        }

        protected Collection<Object> mapToDocField(String param) {
            if (param.startsWith(this.prefixDotRowDot)) {
                String docFieldName = param.substring(this.prefixDotRowDot.length());
                Collection vals = this.doc.getFieldValues(docFieldName);
                if (vals == null || vals.isEmpty()) {
                    return null;
                }
                return vals;
            }
            return null;
        }

        protected String convertFieldValue(Object val) {
            if (val instanceof IndexableField) {
                IndexableField f = (IndexableField)val;
                return f.stringValue();
            }
            return val.toString();
        }

        public Iterator<String> getParameterNamesIterator() {
            final Iterator fieldNames = this.doc.getFieldNames().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return fieldNames.hasNext();
                }

                @Override
                public String next() {
                    String fieldName = (String)fieldNames.next();
                    return prefixDotRowDot + fieldName;
                }
            };
        }
    }

    private static final class Result
    extends ResultContext {
        private final SolrDocumentList docList;
        final SolrReturnFields justWantAllFields = new SolrReturnFields();

        private Result(SolrDocumentList docList) {
            this.docList = docList;
        }

        @Override
        public ReturnFields getReturnFields() {
            return this.justWantAllFields;
        }

        @Override
        public Iterator<SolrDocument> getProcessedDocuments() {
            return this.docList.iterator();
        }

        @Override
        public boolean wantsScores() {
            return this.justWantAllFields.wantsScore();
        }

        @Override
        public DocList getDocList() {
            return new DocSlice((int)this.docList.getStart(), this.docList.size(), new int[]{}, new float[this.docList.size()], (int)this.docList.getNumFound(), this.docList.getMaxScore() == null ? Float.NaN : this.docList.getMaxScore().floatValue(), this.docList.getNumFoundExact() != false ? TotalHits.Relation.EQUAL_TO : TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
        }

        @Override
        public SolrIndexSearcher getSearcher() {
            return null;
        }

        @Override
        public SolrQueryRequest getRequest() {
            return null;
        }

        @Override
        public Query getQuery() {
            return null;
        }
    }
}

