/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.EnumSet;
import java.util.Objects;
import schemacrawler.schema.IdentifiedEnum;

public class EnumUtility {
    public static <E extends Enum<E>> E enumValue(String value, E defaultValue) {
        Object enumValue;
        Objects.requireNonNull(defaultValue, "No default value provided");
        if (value == null) {
            enumValue = defaultValue;
        } else {
            try {
                Class<?> enumClass = defaultValue.getClass();
                if (enumClass.getEnclosingClass() != null) {
                    enumClass = enumClass.getEnclosingClass();
                }
                enumValue = Enum.valueOf(enumClass, value);
            }
            catch (Exception e) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    public static <E extends Enum<E>> E enumValueFromId(int value, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        try {
            Class<?> enumClass = defaultValue.getClass();
            for (Enum enumValue : EnumSet.allOf(enumClass)) {
                if (((IdentifiedEnum)((Object)enumValue)).id() != value) continue;
                return (E)enumValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    private EnumUtility() {
    }
}

