/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.lint;

import java.nio.file.Path;
import java.util.function.Supplier;
import schemacrawler.tools.command.lint.LintCommand;
import schemacrawler.tools.command.lint.options.LintOptions;
import schemacrawler.tools.command.lint.options.LintOptionsBuilder;
import schemacrawler.tools.command.lint.options.LintReportOutputFormat;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandOptions;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.lint.LintDispatch;
import schemacrawler.tools.lint.LinterHelp;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public class LintCommandProvider
extends BaseCommandProvider {
    public static final String DESCRIPTION_HEADER = "Find lints (non-adherence to coding standards and conventions) in the database schema";

    public LintCommandProvider() {
        super(new CommandDescription("lint", DESCRIPTION_HEADER));
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"lint", (String)"** Find lints (non-adherence to coding standards and conventions) in the database schema", () -> new String[]{"For more information, see https://www.schemacrawler.com/lint.html %n"}, (Supplier)new LinterHelp());
        pluginCommand.addOption("linter-configs", Path.class, new String[]{"Path to the SchemaCrawler linter configuration file"}).addOption("lint-dispatch", LintDispatch.class, new String[]{"Specifies how to fail if a linter threshold is exceeded%nOptional, defaults to none%nCorresponds to the configuration file setting: schemacrawler.lint.lintdispatch"}).addOption("run-all-linters", Boolean.TYPE, new String[]{"Whether to run all linters, including running the ones that are not explicitly configured with their default settings%nOptional, defaults to true%nCorresponds to the configuration file setting: schemacrawler.lint.runalllinters"});
        return pluginCommand;
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = this.getCommandLineCommand();
        pluginCommand.addOption("output-format", LintReportOutputFormat.class, new String[]{"Supported lint report output formats", "<output-format> is one of ${COMPLETION-CANDIDATES}", "Optional, inferred from the extension of the output file"});
        return pluginCommand;
    }

    public LintCommand newSchemaCrawlerCommand(String command, Config config) {
        LintOptions lintOptions = LintOptionsBuilder.builder().fromConfig(config).toOptions();
        LintCommand scCommand = new LintCommand();
        scCommand.setCommandOptions((CommandOptions)lintOptions);
        return scCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, LintReportOutputFormat::isSupportedFormat);
    }
}

