/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.schema.ConnectionInfo;
import us.fatehi.utility.Utility;

final class ImmutableConnectionInfo
implements ConnectionInfo {
    private static final long serialVersionUID = 6996782514772490150L;
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final String connectionUrl;
    private final String userName;
    private final String driverName;
    private final String driverVersion;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;

    ImmutableConnectionInfo(String databaseProductName, String databaseProductVersion, String connectionUrl, String userName, String driverName, String driverVersion, int driverMajorVersion, int driverMinorVersion, int jdbcMajorVersion, int jdbcMinorVersion) {
        this.databaseProductName = Utility.requireNotBlank((String)databaseProductName, (String)"No database product name provided");
        this.databaseProductVersion = Utility.requireNotBlank((String)databaseProductVersion, (String)"No database product version provided");
        this.connectionUrl = Utility.requireNotBlank((String)connectionUrl, (String)"No database connection URL provided");
        this.userName = userName;
        this.driverName = Utility.requireNotBlank((String)driverName, (String)"No database driver name provided");
        this.driverVersion = Utility.requireNotBlank((String)driverVersion, (String)"No database driver version provided");
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
        this.jdbcMajorVersion = jdbcMajorVersion;
        this.jdbcMinorVersion = jdbcMinorVersion;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        return String.format("Connected to %n%s %s %nusing JDBC driver %n%s %s%nwith %n\"%s\"", this.databaseProductName, this.databaseProductVersion, this.driverName, this.driverVersion, this.connectionUrl);
    }
}

