/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.UChange;

public class UTranslate
implements UChange {
    private final double dx;
    private final double dy;

    public String toString() {
        return "translate dx=" + this.dx + " dy=" + this.dy;
    }

    public static UTranslate none() {
        return new UTranslate(0.0, 0.0);
    }

    public UTranslate(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public static UTranslate dx(double dx) {
        return new UTranslate(dx, 0.0);
    }

    public static UTranslate dy(double dy) {
        return new UTranslate(0.0, dy);
    }

    public UTranslate(Point2D p) {
        this(p.getX(), p.getY());
    }

    public UTranslate() {
        this(0.0, 0.0);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public boolean isAlmostSame(UTranslate other) {
        return this.dx == other.dx || this.dy == other.dy;
    }

    public Point2D getTranslated(Point2D p) {
        if (p == null) {
            return null;
        }
        return new Point2D.Double(p.getX() + this.dx, p.getY() + this.dy);
    }

    public Dimension2D getTranslated(Dimension2D dim) {
        return new Dimension2DDouble(dim.getWidth() + this.dx, dim.getHeight() + this.dy);
    }

    public UTranslate scaled(double scale) {
        return new UTranslate(this.dx * scale, this.dy * scale);
    }

    public UTranslate compose(UTranslate other) {
        return new UTranslate(this.dx + other.dx, this.dy + other.dy);
    }

    public UTranslate reverse() {
        return new UTranslate(-this.dx, -this.dy);
    }

    public Rectangle2D apply(Rectangle2D rect) {
        return new Rectangle2D.Double(rect.getX() + this.dx, rect.getY() + this.dy, rect.getWidth(), rect.getHeight());
    }

    public UTranslate multiplyBy(double v) {
        return new UTranslate(this.dx * v, this.dy * v);
    }

    public UTranslate sym() {
        return new UTranslate(this.dy, this.dx);
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.dx, this.dy);
    }
}

