/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TimingNote {
    private final TimeTick when;
    private final Player player;
    private final Display note;
    private final Position position;
    private final ISkinParam skinParam;
    private final Style style;

    public TimingNote(TimeTick when, Player player, Display note, Position position, ISkinParam skinParam, Style style) {
        this.style = style;
        this.note = note;
        this.player = player;
        this.when = when;
        this.skinParam = skinParam;
        this.position = position;
    }

    public void drawU(UGraphic ug) {
        if (this.position == Position.BOTTOM) {
            ug = ug.apply(UTranslate.dy(this.getMarginY() / 2.0));
        }
        this.createOpale().drawU(ug);
    }

    private Opale createOpale() {
        HColor noteBackgroundColor;
        HColor borderColor;
        double shadowing;
        FontConfiguration fc;
        UStroke stroke = new UStroke();
        if (UseStyle.useBetaStyle()) {
            fc = FontConfiguration.create(this.skinParam, this.style);
            shadowing = this.style.value(PName.Shadowing).asDouble();
            borderColor = this.style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
            noteBackgroundColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
            stroke = this.style.getStroke();
        } else {
            shadowing = this.skinParam.shadowing(null) ? 4.0 : 0.0;
            fc = FontConfiguration.create(this.skinParam, FontParam.NOTE, null);
            Rose rose = new Rose();
            noteBackgroundColor = rose.getHtmlColor(this.skinParam, ColorParam.noteBackground);
            borderColor = rose.getHtmlColor(this.skinParam, ColorParam.noteBorder);
        }
        Sheet sheet = Parser.build(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(this.note);
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, stroke);
        return opale;
    }

    public double getHeight(StringBounder stringBounder) {
        return this.createOpale().calculateDimension(stringBounder).getHeight() + this.getMarginY();
    }

    private double getMarginY() {
        return 10.0;
    }

    public TimeTick getWhen() {
        return this.when;
    }

    public final Position getPosition() {
        return this.position;
    }
}

