/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImagePort
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImagePort(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, parent, bibliotekon, FontParam.BOUNDARY);
        this.sname = sname;
    }

    private StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.boundary);
    }

    private boolean upPosition() {
        Point2D clusterCenter = this.parent.getClusterPosition().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double sp = 12.0;
        return new Dimension2DDouble(sp, sp);
    }

    @Override
    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    private void drawSymbol(UGraphic ug) {
        URectangle rect = new URectangle(12.0, 12.0);
        ug.draw(rect);
    }

    @Override
    public final void drawU(UGraphic ug) {
        HColor borderColor;
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            if (backcolor == null) {
                backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            }
        } else {
            borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder);
            if (backcolor == null) {
                backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
            }
        }
        ug = ug.apply(backcolor);
        ug = ug.apply(this.getUStroke()).apply(borderColor.bg());
        this.drawSymbol(ug);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

