/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class ActorStickMan
extends AbstractTextBlock
implements TextBlock {
    private final double armsY = 8.0;
    private final double armsLenght = 13.0;
    private final double bodyLenght = 27.0;
    private final double legsX = 13.0;
    private final double legsY = 15.0;
    private final double headDiam = 16.0;
    private final SymbolContext symbolContext;
    private final boolean actorBusiness;

    ActorStickMan(SymbolContext symbolContext, boolean actorBusiness) {
        this.symbolContext = symbolContext;
        this.actorBusiness = actorBusiness;
    }

    @Override
    public void drawU(UGraphic ug) {
        double startX = Math.max(13.0, 13.0) - 8.0 + this.thickness();
        UEllipse head = new UEllipse(16.0, 16.0);
        double centerX = startX + 8.0;
        UPath path = new UPath();
        path.moveTo(0.0, 0.0);
        path.lineTo(0.0, 27.0);
        path.moveTo(-13.0, 8.0);
        path.lineTo(13.0, 8.0);
        path.moveTo(0.0, 27.0);
        path.lineTo(-13.0, 42.0);
        path.moveTo(0.0, 27.0);
        path.lineTo(13.0, 42.0);
        if (this.symbolContext.getDeltaShadow() != 0.0) {
            head.setDeltaShadow(this.symbolContext.getDeltaShadow());
            path.setDeltaShadow(this.symbolContext.getDeltaShadow());
        }
        ug = this.symbolContext.apply(ug);
        ug.apply(new UTranslate(startX, this.thickness())).draw(head);
        if (this.actorBusiness) {
            this.specialBusiness(ug.apply(new UTranslate(startX + 8.0, this.thickness() + 8.0)));
        }
        ug.apply(new UTranslate(centerX, 16.0 + this.thickness())).apply(new HColorNone().bg()).draw(path);
    }

    private void specialBusiness(UGraphic ug) {
        double alpha = 1.030835089459151;
        Point2D p1 = this.getOnCircle(1.8162332528565992);
        Point2D p2 = this.getOnCircle(-0.24543692606170264);
        ug = ug.apply(new UTranslate(p1));
        ug.draw(new ULine(p2.getX() - p1.getX(), p2.getY() - p1.getY()));
    }

    private Point2D getOnCircle(double alpha) {
        double x = 8.0 * Math.cos(alpha);
        double y = 8.0 * Math.sin(alpha);
        return new Point2D.Double(x, y);
    }

    private double thickness() {
        return this.symbolContext.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return Math.max(13.0, 13.0) * 2.0 + 2.0 * this.thickness();
    }

    public double getPreferredHeight() {
        return 58.0 + 2.0 * this.thickness() + this.symbolContext.getDeltaShadow() + 1.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

