/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.openiconic.SvgCommandNumber;

public class SvgPosition {
    private final SvgCommandNumber x;
    private final SvgCommandNumber y;

    public SvgPosition() {
        this(new SvgCommandNumber("0"), new SvgCommandNumber("0"));
    }

    public SvgPosition(SvgCommandNumber x, SvgCommandNumber y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return this.x.toSvg() + "," + this.y.toSvg();
    }

    public SvgPosition(double x, double y) {
        this.x = new SvgCommandNumber(x);
        this.y = new SvgCommandNumber(y);
    }

    public SvgCommandNumber getX() {
        return this.x;
    }

    public SvgCommandNumber getY() {
        return this.y;
    }

    public double getXDouble() {
        return this.x.getDouble();
    }

    public double getYDouble() {
        return this.y.getDouble();
    }

    public SvgPosition add(SvgPosition other) {
        return new SvgPosition(this.x.add(other.x), this.y.add(other.y));
    }

    public SvgPosition getMirror(SvgPosition tobeMirrored) {
        double centerX = this.getXDouble();
        double centerY = this.getYDouble();
        double x = 2.0 * centerX - tobeMirrored.getXDouble();
        double y = 2.0 * centerY - tobeMirrored.getYDouble();
        return new SvgPosition(x, y);
    }

    public Point2D affine(AffineTransform at) {
        return at.transform(new Point2D.Double(this.getXDouble(), this.getYDouble()), null);
    }
}

