/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtileRoot;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileGroup
extends AbstractGtileRoot {
    private final double diffYY2 = 20.0;
    private final Gtile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HColor borderColor;
    private final HColor backColor;
    private final double shadowing;
    private final UStroke stroke;
    private final USymbol type;
    private final double roundCorner;

    public final StyleSignatureBasic getDefaultStyleDefinitionPartition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.partition);
    }

    private double suppWidth(StringBounder stringBounder) {
        Dimension2D orig = this.inner.calculateDimension(stringBounder);
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        Dimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20.0, dimHeaderNote.getWidth() + 20.0) - orig.getWidth();
        return suppWidth;
    }

    public GtileGroup(Gtile inner, Display title, Display displayNote, HColor arrowColor, HColor backColor, HColor titleColor, ISkinParam skinParam, HColor borderColor, USymbol type, double roundCorner) {
        super(inner.getStringBounder(), skinParam);
        this.roundCorner = roundCorner;
        this.type = type;
        this.backColor = backColor == null ? HColorUtils.WHITE : backColor;
        this.inner = inner;
        this.borderColor = borderColor == null ? HColorUtils.BLACK : borderColor;
        Style style = this.getDefaultStyleDefinitionPartition().getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.name = title == null ? TextBlockUtils.empty(0.0, 0.0) : title.create(fc, HorizontalAlignment.LEFT, skinParam);
        this.headerNote = Display.isNull(displayNote) ? TextBlockUtils.empty(0.0, 0.0) : new FloatingNote(displayNote, skinParam);
        UStroke thickness = skinParam.getThickness(LineParam.partitionBorder, null);
        this.stroke = thickness == null ? new UStroke(2.0) : thickness;
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.inner.getSwimlane(point);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D orig = this.inner.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(orig, 18.0, this.suppHeight(stringBounder));
    }

    private double suppHeight(StringBounder stringBounder) {
        Dimension2D dimTitle = this.name.calculateDimension(stringBounder);
        return dimTitle.getHeight() + 30.0;
    }

    private UTranslate getTranslate() {
        return new UTranslate(9.0, this.suppHeight(this.getStringBounder()) - 10.0);
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        return this.inner.getCoord(name).compose(this.getTranslate());
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        Dimension2D dimTotal = this.calculateDimension(this.stringBounder);
        SymbolContext symbolContext = new SymbolContext(this.backColor, this.borderColor).withShadow(this.shadowing).withStroke(this.stroke).withCorner(this.roundCorner, 0.0);
        HorizontalAlignment align = this.inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        this.type.asBig(this.name, align, TextBlockUtils.empty(0.0, 0.0), dimTotal.getWidth(), dimTotal.getHeight(), symbolContext, this.skinParam().getStereotypeAlignment()).drawU(ug);
        this.inner.drawU(ug.apply(this.getTranslate()));
    }
}

