/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.config.MVConfig;
import mediathek.config.StandardLocations;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.messages.RestartDownloadEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.tool.FileSpecifier;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVFilmSize;
import mediathek.tool.MessageBus;
import mediathek.tool.datum.Datum;
import okhttp3.HttpUrl;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class DatenDownload
implements Comparable<DatenDownload> {
    public static final byte QUELLE_ALLE = -1;
    public static final byte QUELLE_BUTTON = 1;
    public static final byte QUELLE_DOWNLOAD = 2;
    public static final byte QUELLE_ABO = 3;
    public static final String QUELLE_ALLE_TXT = "Alle";
    public static final String QUELLE_BUTTON_TXT = "Button";
    public static final String QUELLE_DOWNLOAD_TXT = "Download";
    public static final String QUELLE_ABO_TXT = "Abo";
    public static final byte ART_DOWNLOAD = 1;
    public static final byte ART_PROGRAMM = 2;
    public static final String ART_DOWNLOAD_TXT = "direkter Download";
    public static final String ART_PROGRAMM_TXT = "Programm";
    public static final int DOWNLOAD_NR = 0;
    public static final int DOWNLOAD_FILM_NR = 1;
    public static final int DOWNLOAD_ABO = 2;
    public static final int DOWNLOAD_SENDER = 3;
    public static final int DOWNLOAD_THEMA = 4;
    public static final int DOWNLOAD_TITEL = 5;
    public static final int DOWNLOAD_BUTTON_START = 6;
    public static final int DOWNLOAD_BUTTON_DEL = 7;
    public static final int DOWNLOAD_PROGRESS = 8;
    public static final int DOWNLOAD_RESTZEIT = 9;
    public static final int DOWNLOAD_BANDBREITE = 10;
    public static final int DOWNLOAD_GROESSE = 11;
    public static final int DOWNLOAD_DATUM = 12;
    public static final int DOWNLOAD_ZEIT = 13;
    public static final int DOWNLOAD_DAUER = 14;
    public static final int DOWNLOAD_HD = 15;
    public static final int DOWNLOAD_UT = 16;
    public static final int DOWNLOAD_UNTERBROCHEN = 17;
    public static final int DOWNLOAD_GEO = 18;
    public static final int DOWNLOAD_FILM_URL = 19;
    public static final int DOWNLOAD_HISTORY_URL = 20;
    public static final int DOWNLOAD_URL = 21;
    public static final int DOWNLOAD_URL_RTMP = 22;
    public static final int DOWNLOAD_URL_SUBTITLE = 23;
    public static final int DOWNLOAD_PROGRAMMSET = 24;
    public static final int DOWNLOAD_PROGRAMM = 25;
    public static final int DOWNLOAD_PROGRAMM_AUFRUF = 26;
    public static final int DOWNLOAD_PROGRAMM_AUFRUF_ARRAY = 27;
    public static final int DOWNLOAD_PROGRAMM_RESTART = 28;
    public static final int DOWNLOAD_ZIEL_DATEINAME = 29;
    public static final int DOWNLOAD_ZIEL_PFAD = 30;
    public static final int DOWNLOAD_ZIEL_PFAD_DATEINAME = 31;
    public static final int DOWNLOAD_ART = 32;
    public static final int DOWNLOAD_QUELLE = 33;
    public static final int DOWNLOAD_ZURUECKGESTELLT = 34;
    public static final int DOWNLOAD_INFODATEI = 35;
    public static final int DOWNLOAD_SPOTLIGHT = 36;
    public static final int DOWNLOAD_SUBTITLE = 37;
    public static final int DOWNLOAD_PROGRAMM_DOWNLOADMANAGER = 38;
    public static final int DOWNLOAD_REF = 39;
    public static final String TAG = "Downlad";
    public static final int MAX_ELEM = 40;
    private static final String[] XML_NAMES = new String[]{"Nr", "Filmnr", "Abo", "Sender", "Thema", "Titel", "Button-Start", "Button-Del", "Fortschritt", "Restzeit", "Geschwindigkeit", "Groesse", "Datum", "Zeit", "Dauer", "HD", "UT", "Pause", "Geo", "Film-URL", "History-URL", "URL", "URL-rtmp", "URL-Untertitel", "Programmset", "Programm", "Programmaufruf_", "Programmaufruf", "Restart", "Dateiname", "Pfad", "Pfad-Dateiname", "Art", "Quelle", "Zurueckgestellt", "Infodatei", "Spotlight", "Untertitel", "Remote-Download", "Ref"};
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final FastDateFormat sdf_datum_zeit = FastDateFormat.getInstance("dd.MM.yyyyHH:mm:ss");
    private static final FastDateFormat sdf_datum = FastDateFormat.getInstance("dd.MM.yyyy");
    private static final Logger logger = LogManager.getLogger(DatenDownload.class);
    public static boolean[] spaltenAnzeigen = new boolean[40];
    public String[] arr;
    public Datum datumFilm = new Datum(0L);
    public DatenFilm film;
    public MVFilmSize mVFilmSize = new MVFilmSize();
    public Start start;
    public DatenPset pSet;
    public DatenAbo abo;
    public int nr;
    public byte quelle = (byte)-1;
    public byte art = 1;
    private String websiteUrl = "";

    public DatenDownload() {
        this.initialize();
    }

    public DatenDownload(DatenPset pSet, DatenFilm film, byte quelle, DatenAbo abo, String name, String pfad, String aufloesung) {
        this.initialize();
        this.film = film;
        this.pSet = pSet;
        this.abo = abo;
        this.arr[1] = Integer.toString(film.getFilmNr());
        this.arr[3] = film.getSender();
        this.arr[4] = film.getThema();
        this.arr[5] = film.getTitle();
        this.arr[19] = film.getUrl();
        this.arr[23] = film.getUrlSubtitle();
        this.arr[12] = film.getSendeDatum();
        this.arr[13] = film.getSendeZeit();
        this.arr[14] = film.getDauer();
        this.arr[15] = film.isHighQuality() ? "1" : "0";
        this.arr[16] = film.hasSubtitle() ? "1" : "0";
        this.arr[33] = String.valueOf(quelle);
        this.arr[20] = film.getUrl();
        this.arr[21] = aufloesung.isEmpty() ? film.getUrlFuerAufloesung(FilmResolution.Enum.fromLegacyString(pSet.arr[15])) : film.getUrlFuerAufloesung(FilmResolution.Enum.fromLegacyString(aufloesung));
        this.arr[35] = pSet.arr[19];
        this.arr[37] = pSet.arr[21];
        this.arr[36] = pSet.arr[20];
        this.arr[18] = film.getGeo().orElse("");
        this.websiteUrl = film.getWebsiteLink();
        this.setGroesse("");
        this.aufrufBauen(pSet, film, abo, name, pfad);
        this.init();
    }

    public static DatenDownload getFromConfig(XMLStreamReader parser) throws XMLStreamException {
        int event;
        DatenDownload dl = new DatenDownload();
        int maxElem = dl.arr.length;
        for (int i = 0; i < maxElem; ++i) {
            if (dl.arr[i] != null) continue;
            dl.arr[i] = "";
        }
        block1: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(TAG))) {
            if (event != 1) continue;
            for (int i = 0; i < maxElem; ++i) {
                if (!parser.getLocalName().equals(XML_NAMES[i])) continue;
                dl.arr[i] = parser.getElementText();
                continue block1;
            }
        }
        dl.init();
        return dl;
    }

    public static boolean anzeigen(int i) {
        if (spaltenAnzeigen == null) {
            return true;
        }
        return spaltenAnzeigen[i];
    }

    public void startDownload() {
        this.start = new Start();
        try (SeenHistoryController historyController = new SeenHistoryController();){
            historyController.markSeen(this.film);
        }
        MessageBus.getMessageBus().publishAsync(new StartEvent());
    }

    public static void startenDownloads(ArrayList<DatenDownload> downloads) {
        try (SeenHistoryController historyController = new SeenHistoryController();){
            for (DatenDownload d : downloads) {
                d.start = new Start();
                historyController.markSeen(d.film);
            }
        }
        MessageBus.getMessageBus().publishAsync(new StartEvent());
    }

    public static String getTextBandbreite(long b) {
        if (b > 1000000L) {
            Object s2 = String.valueOf(b / 1000L);
            if (((String)s2).length() >= 4) {
                s2 = ((String)s2).substring(0, ((String)s2).length() - 3) + "," + ((String)s2).substring(((String)s2).length() - 3);
            }
            return (String)s2 + " MB/s";
        }
        if (b > 1000L) {
            return b / 1000L + " kB/s";
        }
        if (b > 1L) {
            return b + " B/s";
        }
        return "";
    }

    private String getDMY(DMYTag tag, String datum) {
        String ret = "";
        if (!datum.isEmpty()) {
            try {
                if (datum.length() == 10) {
                    switch (tag) {
                        case DAY: {
                            ret = datum.substring(0, 2);
                            break;
                        }
                        case MONTH: {
                            ret = datum.substring(3, 5);
                            break;
                        }
                        case YEAR: {
                            ret = datum.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Datum: {}", (Object)datum, (Object)ex);
            }
        }
        return ret;
    }

    private String getHMS(HMSTag tag, String zeit) {
        String ret = "";
        if (!zeit.isEmpty()) {
            try {
                if (zeit.length() == 8) {
                    switch (tag) {
                        case HOUR: {
                            ret = zeit.substring(0, 2);
                            break;
                        }
                        case MINUTE: {
                            ret = zeit.substring(3, 5);
                            break;
                        }
                        case SECOND: {
                            ret = zeit.substring(6);
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Zeit: {}", (Object)zeit, (Object)ex);
            }
        }
        return ret;
    }

    private static String datumDrehen(String datum) {
        Object ret = "";
        if (!datum.isEmpty()) {
            try {
                if (datum.length() == 10) {
                    Object tmp = datum.substring(6);
                    tmp = (String)tmp + "." + datum.substring(3, 5);
                    ret = tmp = (String)tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                logger.error("Datum: {}", (Object)datum, (Object)ex);
            }
        }
        return ret;
    }

    private static String datumDatumZeitReinigen(String datum) {
        String ret = StringUtils.replace(datum, ":", "");
        ret = StringUtils.replace(ret, ".", "");
        return ret;
    }

    public void writeConfigEntry(XMLStreamWriter writer) {
        int xmlMax = this.arr.length;
        try {
            writer.writeStartElement(TAG);
            writer.writeCharacters("\n");
            for (int i = 0; i < xmlMax; ++i) {
                if (this.arr[i].isEmpty()) continue;
                writer.writeCharacters("\t");
                writer.writeStartElement(XML_NAMES[i]);
                writer.writeCharacters(this.arr[i]);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            writer.writeEndElement();
            writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            logger.error("writeConfigEntry", (Throwable)ex);
        }
    }

    public void setGroesseFromFilm() {
        if (this.film != null) {
            if (this.film.getUrl().equals(this.arr[21])) {
                this.mVFilmSize.setSize(this.film.getSize());
            } else {
                this.mVFilmSize.setSize(0L);
            }
        }
    }

    public void setGroesse(@NotNull String groesse) {
        if (this.film != null) {
            if (!groesse.isEmpty()) {
                this.mVFilmSize.setSize(groesse);
            } else {
                this.mVFilmSize.setSize(this.film.getDateigroesse(this.arr[21]));
            }
        }
    }

    public final void init() {
        this.datumFilm = this.getDatumForObject();
        try {
            this.art = Byte.parseByte(this.arr[32]);
            this.quelle = Byte.parseByte(this.arr[33]);
        }
        catch (Exception ex) {
            logger.error("Art: {}, Quelle: {}", (Object)this.arr[32], (Object)this.arr[33], (Object)ex);
            this.art = (byte)2;
            this.quelle = 1;
        }
        if (this.film == null) {
            this.arr[15] = "0";
            this.arr[16] = "0";
        }
    }

    public boolean istZurueckgestellt() {
        return this.arr[34].equals(Boolean.TRUE.toString());
    }

    public void zurueckstellen() {
        if (this.start != null && this.start.status > 1) {
            return;
        }
        this.arr[34] = Boolean.TRUE.toString();
        this.resetDownload();
    }

    public boolean isInterrupted() {
        return !this.isFinished() && this.arr[17].equals(Boolean.TRUE.toString());
    }

    public void interrupt() {
        this.arr[17] = Boolean.TRUE.toString();
    }

    public void interruptRestart() {
        this.arr[17] = Boolean.FALSE.toString();
        MessageBus.getMessageBus().publishAsync(new RestartDownloadEvent());
    }

    public boolean notStarted() {
        return this.start == null;
    }

    public boolean isWaiting() {
        return this.start != null && this.start.status == 1;
    }

    public boolean isFinished() {
        return this.start != null && this.start.status == 3;
    }

    public boolean runNotFinished() {
        return this.start != null && this.start.status < 3;
    }

    public boolean running() {
        return this.start != null && this.start.status == 2;
    }

    public void resetDownload() {
        this.mVFilmSize.reset();
        this.start = null;
    }

    public DatenDownload getCopy() {
        DatenDownload ret = new DatenDownload();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.datumFilm = this.datumFilm;
        ret.film = this.film;
        ret.mVFilmSize = this.mVFilmSize;
        ret.start = this.start;
        ret.pSet = this.pSet;
        ret.abo = this.abo;
        ret.nr = this.nr;
        ret.quelle = this.quelle;
        ret.art = this.art;
        return ret;
    }

    public void aufMichKopieren(DatenDownload datenDownload) {
        System.arraycopy(datenDownload.arr, 0, this.arr, 0, this.arr.length);
        this.datumFilm = datenDownload.datumFilm;
        this.film = datenDownload.film;
        this.mVFilmSize = datenDownload.mVFilmSize;
        this.start = datenDownload.start;
        this.pSet = datenDownload.pSet;
        this.abo = datenDownload.abo;
        this.nr = datenDownload.nr;
        this.quelle = datenDownload.quelle;
        this.art = datenDownload.art;
    }

    public boolean isFromAbo() {
        return !this.arr[2].isEmpty();
    }

    public boolean isRestart() {
        if (this.arr[28].isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[28]);
    }

    public boolean isDownloadManager() {
        if (this.arr[38].isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[38]);
    }

    public boolean isInfoFile() {
        if (this.arr[35].isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[35]);
    }

    public boolean isSubtitle() {
        if (this.arr[37].isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[37]);
    }

    public boolean isSpotlight() {
        if (this.arr[36].isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[36]);
    }

    public String getTextRestzeit() {
        if (this.start != null && this.start.status < 3 && this.start.status >= 2 && this.start.restSekunden > 0L) {
            if (this.start.restSekunden > 300L) {
                return Math.round((double)this.start.restSekunden / 60.0) + " Min.";
            }
            if (this.start.restSekunden > 230L) {
                return "5 Min.";
            }
            if (this.start.restSekunden > 170L) {
                return "4 Min.";
            }
            if (this.start.restSekunden > 110L) {
                return "3 Min.";
            }
            if (this.start.restSekunden > 60L) {
                return "2 Min.";
            }
            if (this.start.restSekunden > 30L) {
                return "1 Min.";
            }
            if (this.start.restSekunden > 20L) {
                return "30 s";
            }
            if (this.start.restSekunden > 10L) {
                return "20 s";
            }
            return "10 s";
        }
        return "";
    }

    public String getTextBandbreite() {
        if (this.start != null && this.start.status >= 2) {
            return DatenDownload.getTextBandbreite(this.start.bandbreite);
        }
        return "";
    }

    public boolean checkAufrufBauen() {
        return this.pSet != null && this.film != null;
    }

    public void aufrufBauen() {
        this.aufrufBauen(this.pSet, this.film, this.abo, this.arr[29], this.arr[30]);
    }

    private void aufrufBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        try {
            DatenProg programm = pSet.getProgUrl(this.arr[21]);
            pSet.arr[5] = StringUtils.replace(pSet.arr[5], "%n", "");
            pSet.arr[5] = StringUtils.replace(pSet.arr[5], "%p", "");
            pSet.arr[4] = StringUtils.replace(pSet.arr[4], "%n", "");
            pSet.arr[4] = StringUtils.replace(pSet.arr[4], "%p", "");
            for (DatenProg prog : pSet.getListeProg()) {
                prog.arr[1] = StringUtils.replace(prog.arr[1], "%n", "");
                prog.arr[1] = StringUtils.replace(prog.arr[1], "%p", "");
            }
            this.arr[24] = pSet.arr[0];
            this.art = (byte)(pSet.checkDownloadDirekt(this.arr[21]) && pSet.progsContainPath() ? 1 : 2);
            this.arr[32] = String.valueOf(this.art);
            if (this.art == 1) {
                this.arr[25] = ART_DOWNLOAD_TXT;
            } else {
                String string = this.arr[25] = programm != null ? programm.arr[0] : "Unknown";
            }
            if (programm != null) {
                this.arr[28] = String.valueOf(programm.isRestart());
                this.arr[38] = String.valueOf(programm.isDownloadManager());
                this.dateinamePfadBauen(pSet, film, abo, nname, ppfad);
                this.programmaufrufBauen(programm);
            }
        }
        catch (Exception ex) {
            logger.error("aufrufBauen", (Throwable)ex);
        }
    }

    private void programmaufrufBauen(DatenProg programm) {
        if (this.art == 1) {
            this.arr[26] = "";
            this.arr[27] = "";
        } else {
            String befehlsString = programm.getProgrammAufruf();
            this.arr[26] = befehlsString = this.replaceExec(befehlsString);
            String progArray = programm.getProgrammAufrufArray();
            this.arr[27] = progArray = this.replaceExec(progArray);
        }
    }

    private String replaceExec(String befehlsString) {
        befehlsString = StringUtils.replace(befehlsString, "**", this.arr[31]);
        befehlsString = StringUtils.replace(befehlsString, "%f", this.arr[21]);
        befehlsString = StringUtils.replace(befehlsString, "%F", this.arr[22]);
        befehlsString = StringUtils.replace(befehlsString, "%a", this.arr[30]);
        befehlsString = StringUtils.replace(befehlsString, "%b", this.arr[29]);
        befehlsString = StringUtils.replace(befehlsString, "%w", this.websiteUrl);
        return befehlsString;
    }

    private void dateinamePfadBauen(DatenPset pSet, DatenFilm film, DatenAbo abo, String nname, String ppfad) {
        String path;
        Object name;
        if (!pSet.progsContainPath()) {
            this.arr[29] = "";
            this.arr[30] = "";
            return;
        }
        if (!nname.isEmpty()) {
            name = nname;
        } else {
            name = pSet.getZielDateiname(this.arr[21]);
            this.arr[29] = name;
            if (((String)name).isEmpty()) {
                name = this.getHeute_yyyyMMdd() + "_" + this.arr[4] + "-" + this.arr[5] + ".mp4";
            }
            name = this.replaceString((String)name, film);
            String suff = "";
            if (((String)name).contains(".")) {
                suff = ((String)name).substring(((String)name).lastIndexOf(46));
                if (suff.length() <= 4 && suff.length() > 1) {
                    name = ((String)name).substring(0, ((String)name).lastIndexOf(46));
                } else {
                    suff = "";
                }
            }
            name = mediathek.tool.FilenameUtils.replaceLeerDateiname((String)name, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
            if (((String)(name = (String)name + suff)).length() > 8) {
                String suf1 = ((String)name).substring(((String)name).length() - 8, ((String)name).length() - 4);
                String suf2 = ((String)name).substring(((String)name).length() - 4);
                if (suf1.startsWith(".") && suf2.startsWith(".") && suf1.equalsIgnoreCase(suf2)) {
                    name = ((String)name).substring(0, ((String)name).length() - 4);
                }
            }
            if (Boolean.parseBoolean(pSet.arr[11])) {
                int laenge = 25;
                if (!pSet.arr[13].isEmpty()) {
                    laenge = Integer.parseInt(pSet.arr[13]);
                }
                name = GuiFunktionen.cutName((String)name, laenge);
            }
        }
        if (!ppfad.isEmpty()) {
            path = ppfad;
        } else {
            path = pSet.getZielPfad().isEmpty() ? StandardLocations.getStandardDownloadPath() : pSet.getZielPfad();
            if (abo != null) {
                this.arr[2] = abo.getName();
                if (Boolean.parseBoolean(pSet.arr[6])) {
                    path = GuiFunktionen.addsPfad(path, mediathek.tool.FilenameUtils.removeIllegalCharacters(abo.getZielpfad(), true));
                }
            } else if (Boolean.parseBoolean(pSet.arr[6])) {
                path = GuiFunktionen.addsPfad(path, mediathek.tool.FilenameUtils.replaceLeerDateiname(this.arr[4], true, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII))));
            }
            path = this.replaceString(path, film);
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            path = StandardLocations.getStandardDownloadPath();
        }
        if (((String)name).isEmpty()) {
            name = this.getHeute_yyyyMMdd() + "_" + this.arr[4] + "-" + this.arr[5] + ".mp4";
        }
        FileSpecifier fileSpecifier = new FileSpecifier(path, (String)name);
        fileSpecifier.checkLength();
        this.arr[29] = fileSpecifier.getFileName();
        this.arr[30] = fileSpecifier.getPath();
        this.arr[31] = GuiFunktionen.addsPfad(fileSpecifier.getPath(), fileSpecifier.getFileName());
    }

    private String replaceString(String replStr, DatenFilm film) {
        int laenge = -1;
        if (Boolean.parseBoolean(this.pSet.arr[12])) {
            laenge = 10;
            if (!this.pSet.arr[14].isEmpty()) {
                laenge = Integer.parseInt(this.pSet.arr[14]);
            }
        }
        replStr = StringUtils.replace(replStr, "%t", this.getField(film.getThema(), laenge));
        replStr = StringUtils.replace(replStr, "%T", this.getField(film.getTitle(), laenge));
        replStr = StringUtils.replace(replStr, "%s", this.getField(film.getSender(), laenge));
        String downloadUrl = this.arr[21];
        if (downloadUrl.endsWith(".m3u8") && downloadUrl.contains(".at")) {
            String field = this.getField(GuiFunktionen.getDateiName(downloadUrl), laenge);
            HttpUrl url = HttpUrl.parse(downloadUrl);
            if (url != null) {
                List<String> segments = url.pathSegments();
                String segment = segments.get(segments.size() - 2);
                field = this.getField(GuiFunktionen.getDateiName(segment), laenge);
                field = FilenameUtils.removeExtension(field);
            }
            replStr = StringUtils.replace(replStr, "%N", field);
        } else {
            replStr = StringUtils.replace(replStr, "%N", this.getField(GuiFunktionen.getDateiName(downloadUrl), laenge));
        }
        replStr = StringUtils.replace(replStr, "%D", film.getSendeDatum().isEmpty() ? this.getHeute_yyyyMMdd() : DatenDownload.datumDatumZeitReinigen(DatenDownload.datumDrehen(film.getSendeDatum())));
        replStr = StringUtils.replace(replStr, "%d", film.getSendeZeit().isEmpty() ? this.getJetzt_HHMMSS() : DatenDownload.datumDatumZeitReinigen(film.getSendeZeit()));
        replStr = StringUtils.replace(replStr, "%H", this.getHeute_yyyyMMdd());
        replStr = StringUtils.replace(replStr, "%h", this.getJetzt_HHMMSS());
        replStr = StringUtils.replace(replStr, "%1", this.getDMY(DMYTag.DAY, film.getSendeDatum().isEmpty() ? this.getHeute_yyyy_MM_dd() : film.getSendeDatum()));
        replStr = StringUtils.replace(replStr, "%2", this.getDMY(DMYTag.MONTH, film.getSendeDatum().isEmpty() ? this.getHeute_yyyy_MM_dd() : film.getSendeDatum()));
        replStr = StringUtils.replace(replStr, "%3", this.getDMY(DMYTag.YEAR, film.getSendeDatum().isEmpty() ? this.getHeute_yyyy_MM_dd() : film.getSendeDatum()));
        replStr = StringUtils.replace(replStr, "%4", this.getHMS(HMSTag.HOUR, film.getSendeZeit().isEmpty() ? this.getJetzt_HH_MM_SS() : film.getSendeZeit()));
        replStr = StringUtils.replace(replStr, "%5", this.getHMS(HMSTag.MINUTE, film.getSendeZeit().isEmpty() ? this.getJetzt_HH_MM_SS() : film.getSendeZeit()));
        replStr = StringUtils.replace(replStr, "%6", this.getHMS(HMSTag.SECOND, film.getSendeZeit().isEmpty() ? this.getJetzt_HH_MM_SS() : film.getSendeZeit()));
        replStr = StringUtils.replace(replStr, "%i", String.valueOf(film.getFilmNr()));
        String res = "";
        if (this.arr[21].equals(film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL))) {
            res = "H";
        } else if (this.arr[21].equals(film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY))) {
            res = "HD";
        } else if (this.arr[21].equals(film.getUrlFuerAufloesung(FilmResolution.Enum.LOW))) {
            res = "L";
        }
        replStr = StringUtils.replace(replStr, "%q", res);
        replStr = StringUtils.replace(replStr, "%S", GuiFunktionen.getSuffixFromUrl(downloadUrl));
        replStr = StringUtils.replace(replStr, "%Z", this.getHash(downloadUrl));
        replStr = StringUtils.replace(replStr, "%z", this.getHash(downloadUrl) + "." + GuiFunktionen.getSuffixFromUrl(downloadUrl));
        return replStr;
    }

    private String getHash(String pfad) {
        int h2 = Math.abs(pfad.hashCode());
        StringBuilder hh = new StringBuilder(Integer.toString(h2));
        while (hh.length() < 10) {
            hh.insert(0, '0');
        }
        return hh.toString();
    }

    private String getField(String name, int length) {
        name = mediathek.tool.FilenameUtils.replaceLeerDateiname(name, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
        if (length < 0) {
            return name;
        }
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        return name;
    }

    private String getJetzt_HHMMSS() {
        return FastDateFormat.getInstance("HHmmss").format(new Date());
    }

    private String getJetzt_HH_MM_SS() {
        return FastDateFormat.getInstance("HH:mm:ss").format(new Date());
    }

    private String getHeute_yyyyMMdd() {
        return FastDateFormat.getInstance("yyyyMMdd").format(new Date());
    }

    private String getHeute_yyyy_MM_dd() {
        return sdf_datum.format(new Date());
    }

    private void initialize() {
        this.arr = new String[40];
        Arrays.fill(this.arr, "");
        this.arr[34] = Boolean.FALSE.toString();
        this.arr[17] = Boolean.FALSE.toString();
    }

    public Datum getDatumForObject() {
        Datum tmp = new Datum(0L);
        if (!this.arr[12].isEmpty()) {
            try {
                if (!this.arr[13].isEmpty()) {
                    tmp.setTime(sdf_datum_zeit.parse(this.arr[12] + this.arr[13]).getTime());
                } else {
                    tmp.setTime(sdf_datum.parse(this.arr[12]).getTime());
                }
            }
            catch (Exception ex) {
                logger.error("Datum: {}, Zeit: {}", (Object)this.arr[12], (Object)this.arr[13], (Object)ex);
            }
        }
        return tmp;
    }

    public String getFileNameWithoutSuffix() {
        return GuiFunktionen.getFileNameWithoutSuffix(this.arr[31]);
    }

    @Override
    public int compareTo(DatenDownload arg0) {
        int ret = sorter.compare(this.arr[3], arg0.arr[3]);
        if (ret == 0) {
            return sorter.compare(this.arr[4], arg0.arr[4]);
        }
        return ret;
    }

    private static enum DMYTag {
        DAY,
        MONTH,
        YEAR;

    }

    private static enum HMSTag {
        HOUR,
        MINUTE,
        SECOND;

    }
}

