/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class SpreadsheetGridView
extends TableView<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    private String stylesheet;

    public SpreadsheetGridView(SpreadsheetHandle handle) {
        this.handle = handle;
    }

    @Override
    public String getUserAgentStylesheet() {
        if (this.stylesheet == null) {
            this.stylesheet = SpreadsheetView.class.getResource("spreadsheet.css").toExternalForm();
        }
        return this.stylesheet;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new GridViewSkin(this.handle);
    }

    public GridViewSkin getGridViewSkin() {
        return this.handle.getCellsViewSkin();
    }

    @Override
    public boolean resizeColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, double delta) {
        boolean returnedValue = super.resizeColumn(tc, delta);
        if (returnedValue) {
            Event.fireEvent(this.handle.getView(), new SpreadsheetView.ColumnWidthEvent(this.getColumns().indexOf(tc), tc.getWidth()));
        }
        return returnedValue;
    }
}

