/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DelegatingDynamicMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

@JRubyClass(name={"Method"})
public class RubyMethod
extends AbstractRubyMethod {
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime2) {
        RubyClass methodClass = runtime2.defineClass("Method", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        methodClass.setClassIndex(ClassIndex.METHOD);
        methodClass.setReifiedClass(RubyMethod.class);
        methodClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, CacheEntry entry, IRubyObject receiver2) {
        Ruby runtime2 = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime2, runtime2.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.entry = entry;
        newMethod.method = entry.method;
        newMethod.sourceModule = entry.sourceModule;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, args2, block);
    }

    @Override
    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getSignature().arityValue());
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this.equals(other));
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, other, Block.NULL_BLOCK);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyMethod)) {
            return false;
        }
        if (this.method instanceof ProcMethod) {
            return ((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod());
        }
        if (this.getMetaClass() != ((RubyBasicObject)other).getMetaClass()) {
            return false;
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return this.receiver == otherMethod.receiver && this.originModule == otherMethod.originModule && (this.isSerialMatch(otherMethod.method) || this.isMethodMissingMatch(otherMethod.getMethod().getRealMethod()));
    }

    private boolean isMethodMissingMatch(DynamicMethod other) {
        return this.method.getRealMethod() instanceof RubyModule.RespondToMissingMethod && ((RubyModule.RespondToMissingMethod)this.method.getRealMethod()).equals(other);
    }

    private boolean isSerialMatch(DynamicMethod otherMethod) {
        return this.method.getRealMethod().getSerialNumber() == otherMethod.getRealMethod().getSerialNumber();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCodeImpl());
    }

    @Override
    public int hashCode() {
        return (int)this.hashCodeImpl();
    }

    private long hashCodeImpl() {
        return (long)this.receiver.hashCode() * this.method.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        RubyMethod newMethod = RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry, this.receiver);
        newMethod.setMetaClass(this.getMetaClass());
        return newMethod;
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Signature signature = this.method.getSignature();
        ArgumentDescriptor[] argsDesc = this.method instanceof IRMethodArgs ? ((IRMethodArgs)((Object)this.method)).getArgumentDescriptors() : Helpers.methodToArgumentDescriptors(this.method);
        int line = this.getLine();
        MethodBlockBody body = new MethodBlockBody(runtime2.getStaticScopeFactory().getDummyScope(), signature, this.entry, argsDesc, this.receiver, this.originModule, this.originName, this.getFilename(), line == -1 ? -1 : line - 1);
        Block b2 = MethodBlockBody.createMethodBlock(body);
        return RubyProc.newProc(runtime2, b2, Block.Type.LAMBDA);
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        RubyString str = RubyString.newString(runtime2, "#<");
        String sharp = "#";
        str.catString(this.getType().getName()).catString(": ");
        RubyModule mklass = this.originModule;
        RubyModule definedClass = this.method instanceof AliasMethod || this.method instanceof DelegatingDynamicMethod ? this.method.getRealMethod().getDefinedClass() : this.method.getDefinedClass();
        if (definedClass.isIncluded()) {
            definedClass = definedClass.getMetaClass();
        }
        if (mklass.isSingleton()) {
            RubyBasicObject attached = ((MetaClass)mklass).getAttached();
            if (this.receiver == null) {
                str.cat19(RubyMethod.inspect(context, mklass).convertToString());
            } else if (this.receiver == attached) {
                str.cat19(RubyMethod.inspect(context, attached).convertToString());
                sharp = ".";
            } else {
                str.cat19(RubyMethod.inspect(context, this.receiver).convertToString());
                str.catString("(");
                str.cat19(RubyMethod.inspect(context, attached).convertToString());
                str.catString(")");
                sharp = ".";
            }
        } else {
            str.catString(mklass.getName());
            if (definedClass != mklass) {
                str.catString("(");
                str.catString(definedClass.getName());
                str.catString(")");
            }
        }
        str.catString(sharp);
        str.catString(this.methodName);
        if (!this.methodName.equals(this.method.getName())) {
            str.catString("(");
            str.catString(this.method.getName());
            str.catString(")");
        }
        if (this.method.isNotImplemented()) {
            str.catString(" (not-implemented)");
        }
        str.catString(">");
        return str;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @Override
    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime2.newArray((IRubyObject)runtime2.newString(filename2), (IRubyObject)runtime2.newFixnum(this.getLine()));
        }
        return context.nil;
    }

    @Override
    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getFile();
        }
        return null;
    }

    @Override
    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @Override
    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context.runtime, this);
    }

    @JRubyMethod(optional=1)
    public IRubyObject curry(ThreadContext context, IRubyObject[] args2) {
        return this.to_proc(context).callMethod(context, "curry", args2);
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        return this.super_method(context, this.receiver, this.sourceModule.getSuperClass());
    }

    @Override
    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        if (this.method instanceof AliasMethod) {
            return context.runtime.newSymbol(((AliasMethod)this.method).getOldName());
        }
        return this.name(context);
    }
}

