/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.utils.Attributes;

public class SupportedColumnTypeWrapper
implements Comparable<SupportedColumnTypeWrapper> {
    private static final List<Class> SIMPLE_TYPES_ORDER = Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, BigInteger.class, BigDecimal.class, Byte.class, Short.class, Character.class);
    private final Class<?> type;

    public SupportedColumnTypeWrapper(Class type) {
        this.type = type;
    }

    public static List<SupportedColumnTypeWrapper> buildOrderedSupportedTypesList(GraphModel graphModel) {
        TimeRepresentation timeRepresentation = graphModel.getConfiguration().getTimeRepresentation();
        return SupportedColumnTypeWrapper.buildOrderedSupportedTypesList(timeRepresentation);
    }

    public static List<SupportedColumnTypeWrapper> buildOrderedSupportedTypesList(TimeRepresentation timeRepresentation) {
        ArrayList<SupportedColumnTypeWrapper> supportedTypesWrappers = new ArrayList<SupportedColumnTypeWrapper>();
        for (Class type : AttributeUtils.getSupportedTypes()) {
            if (type.equals(Map.class) || type.equals(List.class) || type.equals(Set.class) || !AttributeUtils.isStandardizedType((Class)type) || !Attributes.isTypeAvailable((Class)type, (TimeRepresentation)timeRepresentation)) continue;
            supportedTypesWrappers.add(new SupportedColumnTypeWrapper(type));
        }
        Collections.sort(supportedTypesWrappers);
        return supportedTypesWrappers;
    }

    public String toString() {
        if (AttributeUtils.isArrayType(this.type)) {
            return String.format("%s list", this.type.getComponentType().getSimpleName());
        }
        return this.type.getSimpleName();
    }

    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportedColumnTypeWrapper other = (SupportedColumnTypeWrapper)obj;
        return this.type == other.type || this.type != null && this.type.equals(other.type);
    }

    @Override
    public int compareTo(SupportedColumnTypeWrapper other) {
        boolean isDynamicOther;
        boolean isArrayOther;
        boolean isArray = this.type.isArray();
        if (isArray != (isArrayOther = other.type.isArray())) {
            if (isArray) {
                return 1;
            }
            return -1;
        }
        boolean isDynamic = AttributeUtils.isDynamicType(this.type);
        if (isDynamic != (isDynamicOther = AttributeUtils.isDynamicType(other.type))) {
            if (isDynamic) {
                return 1;
            }
            return -1;
        }
        int i1 = SIMPLE_TYPES_ORDER.indexOf(this.type);
        int i2 = SIMPLE_TYPES_ORDER.indexOf(other.type);
        if (i1 != -1 && i2 != -1) {
            return i1 - i2;
        }
        return this.type.getSimpleName().compareTo(other.type.getSimpleName());
    }
}

