/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.swing;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.gephi.lib.gleem.linalg.MathUtil;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionManager;
import org.gephi.visualization.apiimpl.GraphContextMenu;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.apiimpl.VizEventManager;
import org.gephi.visualization.opengl.AbstractEngine;
import org.gephi.visualization.selection.Rectangle;
import org.gephi.visualization.swing.GLAbstractListener;

public class StandardGraphIO
implements GraphIO,
VizArchitecture {
    protected GLAbstractListener graphDrawable;
    protected Component graphComponent;
    protected AbstractEngine engine;
    protected VizEventManager vizEventManager;
    protected VizController vizController;
    protected GraphLimits limits;
    protected AWTMouseAdapter mouseEventsAdapter;
    protected float[] rightButtonMoving = new float[]{-1.0f, 0.0f, 0.0f};
    protected float[] leftButtonMoving = new float[]{-1.0f, 0.0f, 0.0f};
    protected float[] middleButtonMoving = new float[]{-1.0f, 0.0f, 0.0f};
    protected float[] mousePosition = new float[2];
    protected float[] mousePosition3d = new float[2];
    protected float[] mouseDrag3d = new float[2];
    protected float[] mouseDrag = new float[2];
    protected float[] startDrag2d = new float[2];
    protected boolean draggingEnable = true;
    protected boolean dragging = false;
    protected boolean pressing = false;

    @Override
    public void initArchitecture() {
        this.graphDrawable = (GLAbstractListener)VizController.getInstance().getDrawable();
        this.graphComponent = this.graphDrawable.graphComponent;
        this.engine = VizController.getInstance().getEngine();
        this.vizEventManager = VizController.getInstance().getVizEventManager();
        this.vizController = VizController.getInstance();
        this.limits = VizController.getInstance().getLimits();
    }

    @Override
    public void startMouseListening() {
        this.stopMouseListening();
        if (this.graphDrawable.window != null) {
            this.graphDrawable.window.addMouseListener((MouseListener)this);
        } else {
            this.mouseEventsAdapter = new AWTMouseAdapter((MouseListener)this, (NativeSurfaceHolder)this.graphDrawable.drawable);
            this.mouseEventsAdapter.addTo(this.graphDrawable.graphComponent);
        }
    }

    @Override
    public void stopMouseListening() {
        if (this.graphDrawable.window != null) {
            this.graphDrawable.window.removeMouseListener((MouseListener)this);
        } else if (this.mouseEventsAdapter != null) {
            this.mouseEventsAdapter.removeFrom(this.graphDrawable.graphComponent);
            this.mouseEventsAdapter = null;
        }
    }

    public void mousePressed(com.jogamp.newt.event.MouseEvent e) {
        float x = e.getX();
        float y = this.graphDrawable.viewport.get(3) - e.getY() - 1;
        if (e.getButton() == 3) {
            if (this.vizController.getVizConfig().isCameraControlEnable()) {
                this.rightButtonMoving[0] = x;
                this.rightButtonMoving[1] = y;
                this.graphComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            this.vizEventManager.mouseRightPress();
        } else if (e.getButton() == 1) {
            this.leftButtonMoving[0] = x;
            this.leftButtonMoving[1] = y;
            this.pressing = true;
            this.vizEventManager.mouseLeftPress();
        }
    }

    public void mouseReleased(com.jogamp.newt.event.MouseEvent e) {
        float globalScale = this.graphDrawable.getGlobalScale();
        float x = e.getX();
        float y = this.graphDrawable.viewport.get(3) - e.getY() - 1;
        this.rightButtonMoving[0] = -1.0f;
        this.leftButtonMoving[0] = -1.0f;
        this.middleButtonMoving[0] = -1.0f;
        this.mousePosition[0] = x;
        this.mousePosition[1] = y;
        double[] marker = this.graphDrawable.draggingMarker;
        this.mousePosition3d[0] = (float)(((double)x - (double)this.graphDrawable.viewport.get(2) / 2.0) / -marker[0]) + this.graphDrawable.cameraTarget[0] / globalScale;
        this.mousePosition3d[1] = (float)(((double)y - (double)this.graphDrawable.viewport.get(3) / 2.0) / -marker[1]) + this.graphDrawable.cameraTarget[1] / globalScale;
        if (this.dragging) {
            this.dragging = false;
            this.engine.getScheduler().requireStopDrag();
            this.vizEventManager.stopDrag();
        } else {
            this.graphComponent.setCursor(Cursor.getDefaultCursor());
        }
        this.pressing = false;
        this.vizEventManager.mouseReleased();
    }

    public void mouseEntered(com.jogamp.newt.event.MouseEvent e) {
        this.dragging = false;
    }

    public void mouseExited(com.jogamp.newt.event.MouseEvent e) {
    }

    public void mouseMoved(com.jogamp.newt.event.MouseEvent e) {
        float globalScale = this.graphDrawable.getGlobalScale();
        float x = e.getX();
        float y = this.graphDrawable.viewport.get(3) - e.getY() - 1;
        if (this.mousePosition[0] != x || this.mousePosition[1] != y) {
            this.mousePosition[0] = x;
            this.mousePosition[1] = y;
            double[] marker = this.graphDrawable.draggingMarker;
            this.mousePosition3d[0] = (float)(((double)x - (double)this.graphDrawable.viewport.get(2) / 2.0) / -marker[0]) + this.graphDrawable.cameraTarget[0] / globalScale;
            this.mousePosition3d[1] = (float)(((double)y - (double)this.graphDrawable.viewport.get(3) / 2.0) / -marker[1]) + this.graphDrawable.cameraTarget[1] / globalScale;
            if (this.vizController.getVizConfig().isSelectionEnable()) {
                this.engine.getScheduler().requireUpdateSelection();
            }
            this.vizEventManager.mouseMove();
        }
    }

    public void mouseClicked(com.jogamp.newt.event.MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                if (this.vizController.getVizConfig().isSelectionEnable() && this.engine.isRectangleSelection()) {
                    Rectangle r = (Rectangle)this.engine.getCurrentSelectionArea();
                    boolean ctrl = (e.getModifiers() & 0x80) != 0 || (e.getModifiers() & 2) != 0 || (e.getModifiers() & 4) != 0;
                    r.setCtrl(ctrl);
                }
                this.engine.getScheduler().requireMouseClick();
                this.vizEventManager.mouseLeftClick();
                break;
            }
            case 3: {
                if (this.vizController.getVizConfig().isContextMenu()) {
                    GraphContextMenu popupMenu = new GraphContextMenu();
                    float globalScale = this.graphDrawable.getGlobalScale();
                    int x = (int)(this.mousePosition[0] / globalScale);
                    int y = (int)(((float)this.graphDrawable.viewport.get(3) - this.mousePosition[1]) / globalScale);
                    popupMenu.getMenu().show(this.graphDrawable.getGraphComponent(), x, y);
                }
                this.vizEventManager.mouseRightClick();
                break;
            }
            case 2: {
                this.vizEventManager.mouseMiddleClick();
                break;
            }
        }
    }

    public void mouseDragged(com.jogamp.newt.event.MouseEvent e) {
        float globalScale = this.graphDrawable.getGlobalScale();
        float x = e.getX();
        float y = this.graphDrawable.viewport.get(3) - e.getY() - 1;
        if (this.rightButtonMoving[0] != -1.0f) {
            float proche = this.graphDrawable.cameraTarget[2] - this.graphDrawable.cameraLocation[2];
            this.graphDrawable.cameraTarget[0] = this.graphDrawable.cameraTarget[0] + (x - this.rightButtonMoving[0]) * (proche /= 300.0f);
            this.graphDrawable.cameraTarget[1] = this.graphDrawable.cameraTarget[1] + (y - this.rightButtonMoving[1]) * proche;
            this.graphDrawable.cameraLocation[0] = this.graphDrawable.cameraLocation[0] + (x - this.rightButtonMoving[0]) * proche;
            this.graphDrawable.cameraLocation[1] = this.graphDrawable.cameraLocation[1] + (y - this.rightButtonMoving[1]) * proche;
            this.rightButtonMoving[0] = x;
            this.rightButtonMoving[1] = y;
            this.engine.getScheduler().requireUpdateVisible();
        }
        if (this.leftButtonMoving[0] != -1.0f) {
            this.mousePosition[0] = (int)x;
            this.mousePosition[1] = (int)y;
            double[] marker = this.graphDrawable.draggingMarker;
            this.mousePosition3d[0] = (float)(((double)x - (double)this.graphDrawable.viewport.get(2) / 2.0) / -marker[0]) + this.graphDrawable.cameraTarget[0] / globalScale;
            this.mousePosition3d[1] = (float)(((double)y - (double)this.graphDrawable.viewport.get(3) / 2.0) / -marker[1]) + this.graphDrawable.cameraTarget[1] / globalScale;
            this.mouseDrag3d[0] = this.mousePosition3d[0];
            this.mouseDrag3d[1] = this.mousePosition3d[1];
            if (this.vizController.getVizConfig().isSelectionEnable() && this.engine.isRectangleSelection()) {
                if (!this.dragging) {
                    this.dragging = true;
                    Rectangle rectangle = (Rectangle)this.engine.getCurrentSelectionArea();
                    rectangle.start(this.mousePosition, this.mousePosition3d);
                }
                this.engine.getScheduler().requireUpdateSelection();
            } else if (this.vizController.getVizConfig().isDraggingEnable()) {
                if (!this.dragging) {
                    this.dragging = true;
                    this.engine.getScheduler().requireStartDrag();
                }
                this.engine.getScheduler().requireDrag();
            } else if (this.vizController.getVizConfig().isMouseSelectionUpdateWhileDragging()) {
                this.engine.getScheduler().requireDrag();
            } else {
                if (!this.dragging) {
                    this.dragging = true;
                    this.startDrag2d[0] = x;
                    this.startDrag2d[1] = y;
                    this.vizEventManager.startDrag();
                }
                this.mouseDrag[0] = x - this.startDrag2d[0];
                this.mouseDrag[1] = y - this.startDrag2d[1];
                this.vizEventManager.drag();
            }
            this.leftButtonMoving[0] = x;
            this.leftButtonMoving[1] = y;
        }
    }

    public void mouseWheelMoved(com.jogamp.newt.event.MouseEvent e) {
        boolean ctrl;
        float scroll = e.getRotation()[1];
        if (scroll == 0.0f || !this.vizController.getVizConfig().isCameraControlEnable()) {
            return;
        }
        boolean bl = ctrl = (e.getModifiers() & 0x80) != 0 || (e.getModifiers() & 2) != 0 || (e.getModifiers() & 4) != 0;
        if (ctrl) {
            SelectionManager manager = VizController.getInstance().getSelectionManager();
            if (!manager.isRectangleSelection()) {
                int s = manager.getMouseSelectionDiameter();
                s = (int)((float)s + scroll * 2.0f);
                s = Math.min(1000, s);
                s = Math.max(1, s);
                manager.setMouseSelectionDiameter(s);
            }
            return;
        }
        float globalScale = this.graphDrawable.getGlobalScale();
        float way = scroll / Math.abs(scroll);
        float[] cameraLocation = this.graphDrawable.getCameraLocation();
        float[] cameraTarget = this.graphDrawable.getCameraTarget();
        float markerX = (float)this.graphDrawable.getDraggingMarkerX();
        float markerY = (float)this.graphDrawable.getDraggingMarkerY();
        float mouseX = (float)(((double)this.mousePosition[0] - (double)this.graphDrawable.viewport.get(2) / 2.0) / (double)(-markerX)) + cameraTarget[0] / globalScale;
        float mouseY = (float)(((double)this.mousePosition[1] - (double)this.graphDrawable.viewport.get(3) / 2.0) / (double)(-markerY)) + cameraTarget[1] / globalScale;
        mouseX = MathUtil.clamp(mouseX, this.limits.getMinXoctree(), this.limits.getMaxXoctree());
        mouseY = MathUtil.clamp(mouseY, this.limits.getMinYoctree(), this.limits.getMaxYoctree());
        Vec3f targetVector = new Vec3f((mouseX *= globalScale) - cameraTarget[0], (mouseY *= globalScale) - cameraTarget[1], 0.0f);
        Vec3f locationVector = new Vec3f(mouseX - cameraLocation[0], mouseY - cameraLocation[1], -cameraLocation[2]);
        float distance = (float)Math.sqrt(locationVector.x() * locationVector.x() + locationVector.y() * locationVector.y() + locationVector.z() * locationVector.z());
        float distanceRatio = MathUtil.clamp(2.0f * distance / 10000.0f, 0.0f, 2.0f);
        float coeff = (float)(Math.exp(distanceRatio - 2.0f) * 2.2 - 0.295);
        float step = way * (10.0f + 1000.0f * coeff);
        if (way == -1.0f) {
            step *= 3.0f;
        }
        float stepRatio = step / distance;
        targetVector.scale(stepRatio);
        locationVector.scale(stepRatio);
        if (cameraLocation[2] + locationVector.z() >= 1.0f && cameraLocation[2] + locationVector.z() <= this.graphDrawable.farDistance - this.graphDrawable.nearDistance) {
            cameraLocation[0] = cameraLocation[0] + locationVector.x();
            cameraLocation[1] = cameraLocation[1] + locationVector.y();
            cameraLocation[2] = cameraLocation[2] + locationVector.z();
            cameraTarget[0] = cameraTarget[0] + targetVector.x();
            cameraTarget[1] = cameraTarget[1] + targetVector.y();
        }
        this.engine.getScheduler().requireUpdateVisible();
    }

    @Override
    public void setCameraDistance(float distance) {
        float[] cameraLocation = this.graphDrawable.getCameraLocation();
        float[] cameraTarget = this.graphDrawable.getCameraTarget();
        Vec3f camVect = new Vec3f(cameraTarget[0] - cameraLocation[0], cameraTarget[1] - cameraLocation[1], cameraTarget[2] - cameraLocation[2]);
        float diff = camVect.length() - distance;
        if (Math.abs(diff) > 1.0f) {
            camVect.normalize();
            cameraLocation[0] = cameraLocation[0] + camVect.x() * diff;
            cameraLocation[1] = cameraLocation[1] + camVect.y() * diff;
            cameraLocation[2] = cameraLocation[2] + camVect.z() * diff;
            cameraLocation[2] = Math.max(0.5f, cameraLocation[2]);
            this.engine.getScheduler().requireUpdateVisible();
        }
    }

    @Override
    public float[] getMousePosition3d() {
        return this.mousePosition3d;
    }

    @Override
    public void trigger() {
        if (this.pressing) {
            this.vizEventManager.mouseLeftPressing();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public float[] getMousePosition() {
        return this.mousePosition;
    }

    @Override
    public float[] getMouseDrag() {
        return this.mouseDrag;
    }

    @Override
    public float[] getMouseDrag3d() {
        return this.mouseDrag3d;
    }

    @Override
    public void centerOnZero() {
        this.graphDrawable.cameraLocation[0] = 0.0f;
        this.graphDrawable.cameraLocation[1] = 0.0f;
        this.graphDrawable.cameraLocation[2] = 100.0f;
        this.graphDrawable.cameraTarget[0] = 0.0f;
        this.graphDrawable.cameraTarget[1] = 0.0f;
        this.graphDrawable.cameraTarget[2] = 0.0f;
        this.engine.getScheduler().requireUpdateVisible();
    }

    @Override
    public void centerOnGraph() {
        float graphWidth = Math.abs(this.limits.getMaxXoctree() - this.limits.getMinXoctree());
        float graphHeight = Math.abs(this.limits.getMaxYoctree() - this.limits.getMinYoctree());
        float currentDistanceGraphRatioX = Math.abs((float)this.graphDrawable.viewport.get(2) / (float)this.graphDrawable.getDraggingMarkerX()) / this.graphDrawable.cameraLocation[2];
        float currentDistanceGraphRatioY = Math.abs((float)this.graphDrawable.viewport.get(3) / (float)this.graphDrawable.getDraggingMarkerY()) / this.graphDrawable.cameraLocation[2];
        float newCameraLocationX = graphWidth / currentDistanceGraphRatioX;
        float newCameraLocationY = graphHeight / currentDistanceGraphRatioY;
        float newCameraLocation = Math.max(newCameraLocationX, newCameraLocationY);
        this.graphDrawable.cameraLocation[0] = this.limits.getMinXoctree() + graphWidth / 2.0f;
        this.graphDrawable.cameraLocation[1] = this.limits.getMinYoctree() + graphHeight / 2.0f;
        this.graphDrawable.cameraLocation[2] = newCameraLocation;
        this.graphDrawable.cameraTarget[0] = this.graphDrawable.cameraLocation[0];
        this.graphDrawable.cameraTarget[1] = this.graphDrawable.cameraLocation[1];
        this.graphDrawable.cameraTarget[2] = 0.0f;
        this.engine.getScheduler().requireUpdateVisible();
    }

    @Override
    public void centerOnCoordinate(float x, float y, float z) {
        this.graphDrawable.cameraTarget[0] = x;
        this.graphDrawable.cameraTarget[1] = y;
        this.graphDrawable.cameraTarget[2] = z;
        this.graphDrawable.cameraLocation[0] = x;
        this.graphDrawable.cameraLocation[1] = y;
        this.graphDrawable.cameraLocation[2] = z + 100.0f;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    private com.jogamp.newt.event.MouseEvent convertMouseEvent(MouseEvent me) {
        float[] fArray;
        Object object = me.getSource();
        long l = me.getWhen();
        int n = me.getModifiers();
        int n2 = me.getX();
        int n3 = me.getY();
        short s = (short)me.getClickCount();
        short s2 = (short)me.getButton();
        if (me instanceof MouseWheelEvent) {
            float[] fArray2 = new float[2];
            fArray2[0] = 0.0f;
            fArray = fArray2;
            fArray2[1] = -((MouseWheelEvent)me).getUnitsToScroll();
        } else {
            fArray = null;
        }
        return new com.jogamp.newt.event.MouseEvent(0, object, l, n, n2, n3, s, s2, fArray, 1.0f);
    }

    private class MouseEventsWrapper
    extends MouseAdapter {
        private MouseEventsWrapper() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            StandardGraphIO.this.mousePressed(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            StandardGraphIO.this.mouseReleased(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            StandardGraphIO.this.mouseEntered(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            StandardGraphIO.this.mouseExited(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            StandardGraphIO.this.mouseMoved(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StandardGraphIO.this.mouseClicked(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            StandardGraphIO.this.mouseDragged(StandardGraphIO.this.convertMouseEvent(e));
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            StandardGraphIO.this.mouseWheelMoved(StandardGraphIO.this.convertMouseEvent(e));
        }
    }
}

