#############################################################################
##
#W  spheresizecycles.g            GAP4 Package `RCWA'             Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing sphere size
##  cycles for groups with orbits with bounded sphere sizes, where the
##  orbit growth sequence gets periodic.
##
##  The list 'cyclist' contains lists for each group, with entries
##  as follows:
##
##  cyclist[i][1]: number of group in the database
##  cyclist[i][2]: list of lists of the form [<orbit representative>,
##                 <sphere size cycle>]
##   
##  *** Note that the data may contain errors. ***
##
#############################################################################

return
[[29,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [30,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [34,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [36,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [37,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [38,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [40,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [43,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [47,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [55,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [57,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[58,[[10,fail]]],
 [60,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],
 [61,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[63,[[4,fail]]],[64,[[10,fail]]],
 [65,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[66,[[4,fail]]],
 [102,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [103,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [104,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [109,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [111,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [115,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [116,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [117,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [118,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [119,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [122,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[123,[[6,fail]]],
 [124,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[125,[[6,fail]]],[127,[[0,fail]]],
 [128,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [132,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[133,[[0,fail]]],
 [201,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [204,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [206,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [207,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [224,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [225,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [233,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [234,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [235,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [238,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [240,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [244,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [245,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [248,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [249,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [250,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [292,[[8,[3,3,4]],[20,[3,3,4]],[32,[3,3,4]],[44,[3,3,4]],[56,[3,3,4]],
     [68,[3,3,4]],[80,[3,3,4]],[92,[3,3,4]],[104,[3,3,4]],[116,[3,3,4]]] 
  ],
 [294,[[4,[3,3,4]],[16,[3,3,4]],[28,[3,3,4]],[40,[3,3,4]],[52,[3,3,4]],
     [64,[3,3,4]],[76,[3,3,4]],[88,[3,3,4]],[100,[3,3,4]],[112,[3,3,4]]] 
  ],
 [295,[[4,[3,3,4]],[16,[3,3,4]],[28,[3,3,4]],[40,[3,3,4]],[52,[3,3,4]],
     [64,[3,3,4]],[76,[3,3,4]],[88,[3,3,4]],[100,[3,3,4]],[112,[3,3,4]]] 
  ],
 [305,[[8,[3,3,4]],[20,[3,3,4]],[32,[3,3,4]],[44,[3,3,4]],[56,[3,3,4]],
     [68,[3,3,4]],[80,[3,3,4]],[92,[3,3,4]],[104,[3,3,4]],[116,[3,3,4]]] 
  ],
 [309,[[0,[3,3,4]],[12,[3,3,4]],[24,[3,3,4]],[36,[3,3,4]],[48,[3,3,4]],
     [60,[3,3,4]],[72,[3,3,4]],[84,[3,3,4]],[96,[3,3,4]],[108,[3,3,4]]]]
  ,
 [310,[[0,[3,3,4]],[12,[3,3,4]],[24,[3,3,4]],[36,[3,3,4]],[48,[3,3,4]],
     [60,[3,3,4]],[72,[3,3,4]],[84,[3,3,4]],[96,[3,3,4]],[108,[3,3,4]]]]
  ,[314,[[0,fail]]],[315,[[4,fail]]],[316,[[4,fail]]],[317,[[0,fail]]],
 [318,[[8,fail]]],[319,[[4,fail]]],[320,[[0,fail]]],[321,[[8,fail]]],
 [322,[[8,fail]]],[323,[[8,fail]]],[324,[[4,fail]]],[325,[[0,fail]]],
 [354,[[8,[3,3,4]],[20,[3,3,4]],[32,[3,3,4]],[44,[3,3,4]],[56,[3,3,4]],
     [68,[3,3,4]],[80,[3,3,4]],[92,[3,3,4]],[104,[3,3,4]],[116,[3,3,4]]] 
  ],
 [356,[[4,[2,2,3]],[16,[2,2,3]],[28,[2,2,3]],[40,[2,2,3]],[52,[2,2,3]],
     [64,[2,2,3]],[76,[2,2,3]],[88,[2,2,3]],[100,[2,2,3]],[112,[2,2,3]]] 
  ],
 [357,[[4,[3,3,4]],[16,[3,3,4]],[28,[3,3,4]],[40,[3,3,4]],[52,[3,3,4]],
     [64,[3,3,4]],[76,[3,3,4]],[88,[3,3,4]],[100,[3,3,4]],[112,[3,3,4]]] 
  ],
 [367,[[8,[2,2,3]],[20,[2,2,3]],[32,[2,2,3]],[44,[2,2,3]],[56,[2,2,3]],
     [68,[2,2,3]],[80,[2,2,3]],[92,[2,2,3]],[104,[2,2,3]],[116,[2,2,3]]] 
  ],
 [371,[[0,[2,2,3]],[12,[2,2,3]],[24,[2,2,3]],[36,[2,2,3]],[48,[2,2,3]],
     [60,[2,2,3]],[72,[2,2,3]],[84,[2,2,3]],[96,[2,2,3]],[108,[2,2,3]]]]
  ,
 [372,[[0,[3,3,4]],[12,[3,3,4]],[24,[3,3,4]],[36,[3,3,4]],[48,[3,3,4]],
     [60,[3,3,4]],[72,[3,3,4]],[84,[3,3,4]],[96,[3,3,4]],[108,[3,3,4]]]]
  ,[376,[[0,fail]]],[377,[[4,fail]]],[378,[[4,fail]]],[379,[[0,fail]]],
 [380,[[8,fail]]],[381,[[4,fail]]],[382,[[0,fail]]],[383,[[8,fail]]],
 [384,[[8,fail]]],[385,[[8,fail]]],[386,[[4,fail]]],[387,[[0,fail]]],
 [388,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [393,[[0,[2]],[4,[2]],[8,[2]],[12,[2]],[16,[2]],[20,[2]],[24,[2]],
     [28,[2]],[32,[2]],[36,[2]]]],
 [404,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [407,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [422,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [450,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [452,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [453,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [470,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [471,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [479,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [480,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [481,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [484,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [486,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [490,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [491,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [494,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [495,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [496,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [534,[[8,[2,2,3]],[20,[2,2,3]],[32,[2,2,3]],[44,[2,2,3]],[56,[2,2,3]],
     [68,[2,2,3]],[80,[2,2,3]],[92,[2,2,3]],[104,[2,2,3]],[116,[2,2,3]]] 
  ],
 [536,[[4,[3,3,4]],[16,[3,3,4]],[28,[3,3,4]],[40,[3,3,4]],[52,[3,3,4]],
     [64,[3,3,4]],[76,[3,3,4]],[88,[3,3,4]],[100,[3,3,4]],[112,[3,3,4]]] 
  ],
 [537,[[4,[2,2,3]],[16,[2,2,3]],[28,[2,2,3]],[40,[2,2,3]],[52,[2,2,3]],
     [64,[2,2,3]],[76,[2,2,3]],[88,[2,2,3]],[100,[2,2,3]],[112,[2,2,3]]] 
  ],
 [547,[[8,[3,3,4]],[20,[3,3,4]],[32,[3,3,4]],[44,[3,3,4]],[56,[3,3,4]],
     [68,[3,3,4]],[80,[3,3,4]],[92,[3,3,4]],[104,[3,3,4]],[116,[3,3,4]]] 
  ],
 [551,[[0,[3,3,4]],[12,[3,3,4]],[24,[3,3,4]],[36,[3,3,4]],[48,[3,3,4]],
     [60,[3,3,4]],[72,[3,3,4]],[84,[3,3,4]],[96,[3,3,4]],[108,[3,3,4]]]]
  ,
 [552,[[0,[2,2,3]],[12,[2,2,3]],[24,[2,2,3]],[36,[2,2,3]],[48,[2,2,3]],
     [60,[2,2,3]],[72,[2,2,3]],[84,[2,2,3]],[96,[2,2,3]],[108,[2,2,3]]]]
  ,[556,[[0,fail]]],[557,[[4,fail]]],[558,[[4,fail]]],[559,[[0,fail]]],
 [560,[[8,fail]]],[561,[[4,fail]]],[562,[[0,fail]]],[563,[[8,fail]]],
 [564,[[8,fail]]],[565,[[8,fail]]],[566,[[4,fail]]],[567,[[0,fail]]],
 [569,[[2,[2]],[6,[2]],[10,[2]],[14,[2]],[18,[2]],[22,[2]],[26,[2]],
     [30,[2]],[34,[2]],[38,[2]]]],
 [581,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [584,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [599,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [649,[[8,[2,2,3]],[20,[2,2,3]],[32,[2,2,3]],[44,[2,2,3]],[56,[2,2,3]],
     [68,[2,2,3]],[80,[2,2,3]],[92,[2,2,3]],[104,[2,2,3]],[116,[2,2,3]]] 
  ],
 [651,[[4,[2,2,3]],[16,[2,2,3]],[28,[2,2,3]],[40,[2,2,3]],[52,[2,2,3]],
     [64,[2,2,3]],[76,[2,2,3]],[88,[2,2,3]],[100,[2,2,3]],[112,[2,2,3]]] 
  ],
 [652,[[4,[2,2,3]],[16,[2,2,3]],[28,[2,2,3]],[40,[2,2,3]],[52,[2,2,3]],
     [64,[2,2,3]],[76,[2,2,3]],[88,[2,2,3]],[100,[2,2,3]],[112,[2,2,3]]] 
  ],
 [662,[[8,[2,2,3]],[20,[2,2,3]],[32,[2,2,3]],[44,[2,2,3]],[56,[2,2,3]],
     [68,[2,2,3]],[80,[2,2,3]],[92,[2,2,3]],[104,[2,2,3]],[116,[2,2,3]]] 
  ],
 [666,[[0,[2,2,3]],[12,[2,2,3]],[24,[2,2,3]],[36,[2,2,3]],[48,[2,2,3]],
     [60,[2,2,3]],[72,[2,2,3]],[84,[2,2,3]],[96,[2,2,3]],[108,[2,2,3]]]]
  ,
 [667,[[0,[2,2,3]],[12,[2,2,3]],[24,[2,2,3]],[36,[2,2,3]],[48,[2,2,3]],
     [60,[2,2,3]],[72,[2,2,3]],[84,[2,2,3]],[96,[2,2,3]],[108,[2,2,3]]]]
  ,[671,[[0,fail]]],[672,[[4,fail]]],[673,[[4,fail]]],[674,[[0,fail]]],
 [675,[[8,fail]]],[676,[[4,fail]]],[677,[[0,fail]]],[678,[[8,fail]]],
 [679,[[8,fail]]],[680,[[8,fail]]],[681,[[4,fail]]],[682,[[0,fail]]],
 [694,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [697,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [712,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [749,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [752,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [767,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [814,[[8,[1,1,2,2,2]],[28,[1,1,2,2,2]],[38,[1,1,2,2,2]],[58,[1,1,2,2,2]],
     [68,[1,1,2,2,2]],[88,[1,1,2,2,2]],[98,[1,1,2,2,2]],[118,[1,1,2,2,2]],
     [128,[1,1,2,2,2]],[148,[1,1,2,2,2]]]],
 [827,[[8,[1,1,2,2,2]],[28,[1,1,2,2,2]],[38,[1,1,2,2,2]],[58,[1,1,2,2,2]],
     [68,[1,1,2,2,2]],[88,[1,1,2,2,2]],[98,[1,1,2,2,2]],[118,[1,1,2,2,2]],
     [128,[1,1,2,2,2]],[148,[1,1,2,2,2]]]],
 [831,[[8,[1,1,2]],[38,[1,1,2]],[68,[1,1,2]],[98,[1,1,2]],[128,[1,1,2]],
     [158,[1,1,2]],[188,[1,1,2]],[218,[1,1,2]],[248,[1,1,2]]]],
 [832,[[8,[2]],[38,[2]],[68,[2]],[98,[2]],[128,[2]],[158,[2]],[188,[2]],
     [218,[2]],[248,[2]]]],[836,[[12,fail]]],[839,[[12,fail]]],
 [869,[[12,[1,1,2]],[42,[1,1,2]],[72,[1,1,2]],[102,[1,1,2]],[132,[1,1,2]],
     [162,[1,1,2]],[192,[1,1,2]],[222,[1,1,2]],[252,[1,1,2]]]],
 [870,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [884,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [885,[[12,[1,1,2]],[42,[1,1,2]],[72,[1,1,2]],[102,[1,1,2]],[132,[1,1,2]],
     [162,[1,1,2]],[192,[1,1,2]],[222,[1,1,2]],[252,[1,1,2]]]],
 [890,[[16,fail]]],[891,[[16,fail]]],[895,[[6,fail]]],[900,[[6,fail]]],
 [919,[[0,[1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,2]],
     [32,[1,1,1,1,1,1,2]],[50,[1,1,1,1,1,1,2]],[56,[1,1,1,1,1,1,2]],
     [62,[1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,2]],[86,[1,1,1,1,1,1,2]],
     [92,[1,1,1,1,1,1,2]]]],
 [921,[[0,[1]],[16,[2]],[22,[1]],[30,[1]],[46,[2]],[52,[1]],[60,[1]],
     [76,[2]],[82,[1]],[90,[1]]]],
 [922,[[0,[1,1,2]],[16,[2,3,3]],[22,[1,1,2]],[30,[1,1,2]],[46,[2,3,3]],
     [52,[1,1,2]],[60,[1,1,2]],[76,[2,3,3]],[82,[1,1,2]],[90,[1,1,2]]]],
 [932,[[0,[1,1,2,2,2]],[20,[1,1,2,2,2]],[26,[1,1,2,2,2]],[32,[1,1,2,2,2]],
     [50,[1,1,2,2,2]],[56,[1,1,2,2,2]],[62,[1,1,2,2,2]],[80,[1,1,2,2,2]],
     [86,[1,1,2,2,2]],[92,[1,1,2,2,2]]]],
 [936,[[6,[2]],[12,[1,1,2]],[36,[2]],[42,[1,1,2]],[66,[2]],[72,[1,1,2]],
     [96,[2]],[102,[1,1,2]],[126,[2]],[132,[1,1,2]]]],
 [937,[[6,[1,1,2]],[12,[2]],[36,[1,1,2]],[42,[2]],[66,[1,1,2]],[72,[2]],
     [96,[1,1,2]],[102,[2]],[126,[1,1,2]],[132,[2]]]],[941,[[12,fail]]],
 [942,[[16,fail]]],[943,[[16,fail]]],[944,[[12,fail]]],[947,[[6,fail]]],
 [948,[[2,fail]]],[950,[[2,fail]]],[952,[[6,fail]]],
 [970,[[16,[2]],[46,[2]],[76,[2]],[106,[2]],[136,[2]],[166,[2]],
     [196,[2]],[226,[2]]]],
 [972,[[16,[2]],[46,[2]],[76,[2]],[106,[2]],[136,[2]],[166,[2]],
     [196,[2]],[226,[2]]]],
 [973,[[16,[1,1,2]],[46,[1,1,2]],[76,[1,1,2]],[106,[1,1,2]],[136,[1,1,2]],
     [166,[1,1,2]],[196,[1,1,2]],[226,[1,1,2]]]],
 [983,[[16,[1,1,2]],[46,[1,1,2]],[76,[1,1,2]],[106,[1,1,2]],[136,[1,1,2]],
     [166,[1,1,2]],[196,[1,1,2]],[226,[1,1,2]]]],[996,[[20,fail]]],
 [997,[[10,fail]]],[1000,[[20,fail]]],[1002,[[10,fail]]],
 [1020,[[4,[1,1,2]],[20,[2,3,3]],[26,[1,1,2]],[34,[1,1,2]],[50,[2,3,3]],
     [56,[1,1,2]],[64,[1,1,2]],[80,[2,3,3]],[86,[1,1,2]],[94,[1,1,2]]]],
 [1022,[[10,[2]],[16,[1,1,2]],[40,[2]],[46,[1,1,2]],[70,[2]],
     [76,[1,1,2]],[100,[2]],[106,[1,1,2]],[130,[2]],[136,[1,1,2]]]],
 [1023,[[10,[1,1,2]],[16,[2]],[40,[1,1,2]],[46,[2]],[70,[1,1,2]],
     [76,[2]],[100,[1,1,2]],[106,[2]],[130,[1,1,2]],[136,[2]]]],
 [1033,[[4,[1]],[20,[2]],[26,[1]],[34,[1]],[50,[2]],[56,[1]],[64,[1]],
     [80,[2]],[86,[1]],[94,[1]]]],
 [1037,[[0,[1,1,2]],[6,[2,3,3]],[24,[1,1,2]],[30,[1,1,2]],[36,[2,3,3]],
     [54,[1,1,2]],[60,[1,1,2]],[66,[2,3,3]],[84,[1,1,2]],[90,[1,1,2]]]],
 [1038,[[0,[1]],[6,[2]],[24,[1]],[30,[1]],[36,[2]],[54,[1]],[60,[1]],
     [66,[2]],[84,[1]],[90,[1]]]],[1043,[[16,fail]]],[1044,[[16,fail]]],
 [1046,[[20,fail]]],[1047,[[10,fail]]],[1048,[[6,fail]]],[1050,[[20,fail]]],
 [1052,[[10,fail]]],[1053,[[6,fail]]],
 [1071,[[0,[1]],[12,[1,1,2]],[16,[1]],[22,[1]],[30,[1]],[42,[1,1,2]],
     [46,[1]],[52,[1]],[60,[1]],[72,[1,1,2]]]],
 [1072,[[0,[1,1,2]],[12,[1]],[16,[1,1,2]],[22,[1,1,2]],[30,[1,1,2]],
     [42,[1]],[46,[1,1,2]],[52,[1,1,2]],[60,[1,1,2]],[72,[1]]]],
 [1086,[[2,[1,1,2]],[6,[1,1,2]],[12,[1]],[20,[1,1,2]],[32,[1,1,2]],
     [36,[1,1,2]],[42,[1]],[50,[1,1,2]],[62,[1,1,2]],[66,[1,1,2]]]],
 [1087,[[2,[1]],[6,[1]],[12,[1,1,2]],[20,[1]],[32,[1]],[36,[1]],
     [42,[1,1,2]],[50,[1]],[62,[1]],[66,[1]]]],[1092,[[16,fail]]],
 [1093,[[16,fail]]],[1097,[[6,fail]]],[1102,[[6,fail]]],
 [1117,[[20,[1,1,2]],[50,[1,1,2]],[80,[1,1,2]],[110,[1,1,2]],[140,[1,1,2]],
     [170,[1,1,2]],[200,[1,1,2]],[230,[1,1,2]]]],
 [1130,[[20,[2]],[50,[2]],[80,[2]],[110,[2]],[140,[2]],[170,[2]],
     [200,[2]],[230,[2]]]],
 [1134,[[0,[1,1,2,2,2]],[20,[1,1,2,2,2]],[30,[1,1,2,2,2]],[50,[1,1,2,2,2]],
     [60,[1,1,2,2,2]],[80,[1,1,2,2,2]],[90,[1,1,2,2,2]],[110,[1,1,2,2,2]],
     [120,[1,1,2,2,2]],[140,[1,1,2,2,2]]]],
 [1135,[[0,[1,1,2,2,2]],[20,[1,1,2,2,2]],[30,[1,1,2,2,2]],[50,[1,1,2,2,2]],
     [60,[1,1,2,2,2]],[80,[1,1,2,2,2]],[90,[1,1,2,2,2]],[110,[1,1,2,2,2]],
     [120,[1,1,2,2,2]],[140,[1,1,2,2,2]]]],[1146,[[14,fail]]],
 [1148,[[14,fail]]],
 [1164,[[14,[1,1,2]],[20,[2]],[44,[1,1,2]],[50,[2]],[74,[1,1,2]],
     [80,[2]],[104,[1,1,2]],[110,[2]],[134,[1,1,2]],[140,[2]]]],
 [1166,[[4,[1,1,2]],[10,[2,3,3]],[28,[1,1,2]],[34,[1,1,2]],[40,[2,3,3]],
     [58,[1,1,2]],[64,[1,1,2]],[70,[2,3,3]],[88,[1,1,2]],[94,[1,1,2]]]],
 [1167,[[4,[1]],[10,[2]],[28,[1]],[34,[1]],[40,[2]],[58,[1]],[64,[1]],
     [70,[2]],[88,[1]],[94,[1]]]],
 [1177,[[14,[2]],[20,[1,1,2]],[44,[2]],[50,[1,1,2]],[74,[2]],
     [80,[1,1,2]],[104,[2]],[110,[1,1,2]],[134,[2]],[140,[1,1,2]]]],
 [1181,[[0,[1,1,1,1,1,1,2]],[8,[1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,2]],
     [30,[1,1,1,1,1,1,2]],[38,[1,1,1,1,1,1,2]],[54,[1,1,1,1,1,1,2]],
     [60,[1,1,1,1,1,1,2]],[68,[1,1,1,1,1,1,2]],[84,[1,1,1,1,1,1,2]],
     [90,[1,1,1,1,1,1,2]]]],
 [1182,[[0,[1,1,2,2,2]],[8,[1,1,2,2,2]],[24,[1,1,2,2,2]],[30,[1,1,2,2,2]],
     [38,[1,1,2,2,2]],[54,[1,1,2,2,2]],[60,[1,1,2,2,2]],[68,[1,1,2,2,2]],
     [84,[1,1,2,2,2]],[90,[1,1,2,2,2]]]],[1186,[[0,fail]]],
 [1189,[[0,fail]]],[1190,[[20,fail]]],[1191,[[10,fail]]],[1193,[[14,fail]]],
 [1194,[[20,fail]]],[1195,[[14,fail]]],[1196,[[10,fail]]],
 [1210,[[4,[1,1,2]],[16,[1]],[20,[1,1,2]],[26,[1,1,2]],[34,[1,1,2]],
     [46,[1]],[50,[1,1,2]],[56,[1,1,2]],[64,[1,1,2]],[76,[1]]]],
 [1212,[[6,[1,1,2]],[10,[1,1,2]],[16,[1]],[24,[1,1,2]],[36,[1,1,2]],
     [40,[1,1,2]],[46,[1]],[54,[1,1,2]],[66,[1,1,2]],[70,[1,1,2]]]],
 [1213,[[6,[1]],[10,[1]],[16,[1,1,2]],[24,[1]],[36,[1]],[40,[1]],
     [46,[1,1,2]],[54,[1]],[66,[1]],[70,[1]]]],
 [1223,[[4,[1]],[16,[1,1,2]],[20,[1]],[26,[1]],[34,[1]],[46,[1,1,2]],
     [50,[1]],[56,[1]],[64,[1]],[76,[1,1,2]]]],[1236,[[20,fail]]],
 [1237,[[10,fail]]],[1240,[[20,fail]]],[1242,[[10,fail]]],
 [1257,[[6,[4,5,5]],[22,[4,5,5]],[36,[4,5,5]],[52,[4,5,5]],[66,[4,5,5]],
     [82,[4,5,5]],[96,[4,5,5]],[112,[4,5,5]],[126,[4,5,5]],[142,[4,5,5]] 
    ]],
 [1258,[[6,[4,5,5]],[22,[4,5,5]],[36,[4,5,5]],[52,[4,5,5]],[66,[4,5,5]],
     [82,[4,5,5]],[96,[4,5,5]],[112,[4,5,5]],[126,[4,5,5]],[142,[4,5,5]] 
    ]],
 [1294,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1295,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1303,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1304,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1305,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1308,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1310,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1314,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1315,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1318,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1319,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1320,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1344,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1345,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1346,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1351,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1353,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1357,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1358,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1359,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1360,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1361,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1364,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[1365,[[6,fail]]],
 [1366,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[1367,[[6,fail]]],[1369,[[0,fail]]],
 [1370,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [1374,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[1375,[[0,fail]]],
 [1386,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1387,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1388,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1393,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1395,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1399,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1400,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1401,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1402,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1403,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],[1406,[[6,fail]]],[1407,[[6,fail]]],
 [1408,[[6,fail]]],[1409,[[6,fail]]],[1411,[[0,fail]]],[1412,[[0,fail]]],
 [1416,[[0,fail]]],[1417,[[0,fail]]],
 [1420,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1421,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1429,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1430,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1431,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1434,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1436,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1440,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1441,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1444,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1445,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1446,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1467,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1468,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1469,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1474,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1476,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1480,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1481,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1482,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1483,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1484,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],[1487,[[6,fail]]],[1488,[[6,fail]]],
 [1489,[[6,fail]]],[1490,[[6,fail]]],[1492,[[0,fail]]],[1493,[[0,fail]]],
 [1497,[[0,fail]]],[1498,[[0,fail]]],
 [1506,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1507,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1508,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1513,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1515,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1519,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1520,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1521,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1522,[[0,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[18,[1,1,2]],[24,[1,1,2]],
     [30,[1,1,2]],[36,[1,1,2]],[42,[1,1,2]],[48,[1,1,2]],[54,[1,1,2]]]],
 [1523,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],[1526,[[6,fail]]],
 [1527,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[1528,[[6,fail]]],
 [1529,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [1531,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[1532,[[0,fail]]],[1536,[[0,fail]]],
 [1537,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [1539,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1540,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1541,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1542,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1543,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1544,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1545,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1549,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1550,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1551,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1552,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1554,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1555,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1556,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1568,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1571,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1572,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1573,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1576,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1577,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1578,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1579,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1580,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1583,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1586,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1587,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1589,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1591,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1592,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1593,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1594,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1605,[[0,[3]],[8,[3]],[14,[3]],[20,[3]],[26,[3]],[32,[3]],[38,[3]],
     [44,[3]],[50,[3]],[56,[3]]]],
 [1608,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1609,[[0,[3]],[8,[3]],[14,[3]],[20,[3]],[26,[3]],[32,[3]],[38,[3]],
     [44,[3]],[50,[3]],[56,[3]]]],
 [1610,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1615,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1617,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1618,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1619,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1621,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1624,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1628,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1636,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1638,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[1639,[[10,fail]]],
 [1641,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],
 [1642,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[1644,[[4,fail]]],[1645,[[10,fail]]],
 [1646,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[1647,[[4,fail]]],
 [1650,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1652,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1653,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1654,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1656,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1659,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1663,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1671,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[1673,[[10,fail]]],[1674,[[10,fail]]],
 [1676,[[10,fail]]],[1677,[[4,fail]]],[1679,[[4,fail]]],[1680,[[10,fail]]],
 [1681,[[4,fail]]],[1682,[[4,fail]]],
 [1684,[[0,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [1689,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1697,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1699,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1700,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1701,[[2,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [1702,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1704,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1706,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[1709,[[14,fail]]],
 [1710,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],
 [1712,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],[1713,[[8,fail]]],
 [1714,[[14,fail]]],
 [1715,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],[1717,[[8,fail]]],
 [1718,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1719,[[4,[4]],[10,[4]],[16,[4]],[22,[4]],[28,[4]],[34,[4]],[40,[4]],
     [46,[4]],[52,[4]],[58,[4]]]],
 [1720,[[4,[2,3,3]],[10,[2,3,3]],[16,[2,3,3]],[22,[2,3,3]],[28,[2,3,3]],
     [34,[2,3,3]],[40,[2,3,3]],[46,[2,3,3]],[52,[2,3,3]],[58,[2,3,3]]]],
 [1725,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1726,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1727,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1729,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1731,[[0,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [1734,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1735,[[0,[2,2,4]],[8,[2,3,3]],[14,[2,3,3]],[20,[2,3,3]],[26,[2,3,3]],
     [32,[2,3,3]],[38,[2,3,3]],[44,[2,3,3]],[50,[2,3,3]],[56,[2,3,3]]]],
 [1743,[[20,fail]]],[1746,[[26,fail]]],[1747,[[20,fail]]],[1748,[[26,fail]]],
 [1754,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1762,[[0,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [1764,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1765,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1766,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1767,[[2,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [1769,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[1771,[[14,fail]]],[1774,[[14,fail]]],
 [1775,[[14,fail]]],[1777,[[8,fail]]],[1778,[[8,fail]]],[1779,[[14,fail]]],
 [1780,[[8,fail]]],[1782,[[8,fail]]],
 [1784,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1788,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1789,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1790,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1793,[[4,[2,2,4]],[10,[2,2,4]],[16,[2,2,4]],[22,[2,2,4]],[28,[2,2,4]],
     [34,[2,2,4]],[40,[2,2,4]],[46,[2,2,4]],[52,[2,2,4]],[58,[2,2,4]]]],
 [1796,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1797,[[0,[2,2,4]],[6,[2,2,4]],[12,[2,2,4]],[18,[2,2,4]],[24,[2,2,4]],
     [30,[2,2,4]],[36,[2,2,4]],[42,[2,2,4]],[48,[2,2,4]],[54,[2,2,4]]]],
 [1798,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[1803,[[16,fail]]],[1804,[[16,fail]]],
 [1807,[[22,fail]]],[1812,[[22,fail]]],
 [1814,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1818,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1819,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1820,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [1823,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1826,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1827,[[0,[4]],[6,[4]],[12,[4]],[18,[4]],[24,[4]],[30,[4]],[36,[4]],
     [42,[4]],[48,[4]],[54,[4]]]],
 [1828,[[0,[2,3,3]],[6,[2,3,3]],[12,[2,3,3]],[18,[2,3,3]],[24,[2,3,3]],
     [30,[2,3,3]],[36,[2,3,3]],[42,[2,3,3]],[48,[2,3,3]],[54,[2,3,3]]]],
 [1833,[[16,fail]]],[1834,[[16,fail]]],[1837,[[22,fail]]],[1842,[[22,fail]]],
 [1846,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1847,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1849,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1855,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1856,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1857,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1862,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1863,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1866,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1871,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1874,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1879,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1881,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1887,[[0,[2]],[4,[2]],[6,[2]],[10,[2]],[12,[2]],[16,[2]],[18,[2]],
     [22,[2]],[24,[2]],[28,[2]]]],
 [1901,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1902,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1904,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [1915,[[0,[2]],[2,[2]],[6,[2]],[8,[2]],[12,[2]],[14,[2]],[18,[2]],
     [20,[2]],[24,[2]],[26,[2]]]],
 [1929,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1931,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1935,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [1936,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [1939,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [1940,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [1941,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [1954,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1958,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1966,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[1968,[[10,fail]]],[1969,[[10,fail]]],
 [1971,[[10,fail]]],[1972,[[4,fail]]],[1974,[[4,fail]]],[1975,[[10,fail]]],
 [1976,[[4,fail]]],[1977,[[4,fail]]],
 [1979,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1982,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [1984,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [1992,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1993,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [1996,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [2001,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [2005,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [2013,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[2015,[[10,fail]]],
 [2016,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[2018,[[10,fail]]],[2019,[[4,fail]]],
 [2021,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2022,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[2023,[[4,fail]]],
 [2024,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2033,[[2,[2]],[4,[2]],[8,[2]],[10,[2]],[14,[2]],[16,[2]],[20,[2]],
     [22,[2]],[26,[2]],[28,[2]]]],
 [2048,[[0,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [2050,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2051,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2052,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2053,[[2,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [2055,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[2057,[[14,fail]]],[2060,[[14,fail]]],
 [2061,[[14,fail]]],[2063,[[8,fail]]],[2064,[[8,fail]]],[2065,[[14,fail]]],
 [2066,[[8,fail]]],[2068,[[8,fail]]],
 [2069,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2072,[[0,[2,3,3]],[8,[2,2,4]],[14,[2,2,4]],[20,[2,2,4]],[26,[2,2,4]],
     [32,[2,2,4]],[38,[2,2,4]],[44,[2,2,4]],[50,[2,2,4]],[56,[2,2,4]]]],
 [2073,[[0,[4]],[8,[4]],[14,[4]],[20,[4]],[26,[4]],[32,[4]],[38,[4]],
     [44,[4]],[50,[4]],[56,[4]]]],[2081,[[20,fail]]],[2084,[[26,fail]]],
 [2085,[[20,fail]]],[2086,[[26,fail]]],
 [2089,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2090,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2091,[[2,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[20,[1,1,2]],[26,[1,1,2]],
     [32,[1,1,2]],[38,[1,1,2]],[44,[1,1,2]],[50,[1,1,2]],[56,[1,1,2]]]],
 [2092,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2094,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[2096,[[14,fail]]],
 [2099,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[2100,[[14,fail]]],
 [2102,[[8,fail]]],
 [2103,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [2104,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[2105,[[8,fail]]],
 [2107,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [2109,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2110,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [2114,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [2117,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [2120,[[2,[3]],[8,[3]],[14,[3]],[20,[3]],[26,[3]],[32,[3]],[38,[3]],
     [44,[3]],[50,[3]],[56,[3]]]],
 [2125,[[2,[3]],[8,[3]],[14,[3]],[20,[3]],[26,[3]],[32,[3]],[38,[3]],
     [44,[3]],[50,[3]],[56,[3]]]],
 [2126,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [2127,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [2131,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2134,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2137,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [2142,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[2147,[[12,fail]]],[2150,[[12,fail]]],
 [2153,[[18,fail]]],[2158,[[18,fail]]],[2162,[[12,fail]]],[2165,[[12,fail]]],
 [2168,[[18,fail]]],[2173,[[18,fail]]],
 [2213,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[2214,[[6,fail]]],[2216,[[14,fail]]],
 [2217,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2218,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [2219,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [2220,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[2221,[[2,fail]]],
 [2222,[[0,fail]]],[2223,[[0,fail]]],[2225,[[6,fail]]],[2226,[[10,fail]]],
 [2227,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2228,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2229,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [2230,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[2231,[[4,fail]]],[2232,[[4,fail]]],
 [2233,[[0,fail]]],
 [2234,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [2235,[[10,[2]],[22,[2]],[34,[2]],[46,[2]],[58,[2]],[70,[2]],[82,[2]],
     [94,[2]],[106,[2]],[118,[2]]]],[2236,[[4,fail]]],[2237,[[0,fail]]],
 [2238,[[4,fail]]],[2239,[[10,fail]]],
 [2240,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [2241,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2242,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2243,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[2244,[[0,fail]]],
 [2245,[[0,fail]]],[2246,[[2,fail]]],[2247,[[14,fail]]],
 [2248,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [2249,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2250,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[2251,[[4,fail]]],[2252,[[0,fail]]],
 [2253,[[8,fail]]],
 [2255,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [2256,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [2257,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [2258,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [2259,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2260,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],[2261,[[4,fail]]],[2263,[[0,fail]]],
 [2264,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [2265,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],[2266,[[8,fail]]],[2267,[[0,fail]]],
 [2269,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],[2271,[[4,fail]]],[2272,[[8,fail]]],
 [2273,[[8,fail]]],[2274,[[4,fail]]],[2275,[[0,fail]]],
 [2276,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2277,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [2278,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [2306,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2307,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2311,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2313,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2314,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2315,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2316,[[3,[2,4]],[9,[2,4]],[15,[2,4]],[21,[2,4]],[27,[2,4]],[33,[2,4]],
     [39,[2,4]],[45,[2,4]],[51,[2,4]],[57,[2,4]]]],
 [2320,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2322,[[3,[2,4]],[9,[2,4]],[15,[2,4]],[21,[2,4]],[27,[2,4]],[33,[2,4]],
     [39,[2,4]],[45,[2,4]],[51,[2,4]],[57,[2,4]]]],
 [2324,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [2326,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2327,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [2328,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2329,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2331,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],
 [2332,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],
 [2333,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [2337,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [2339,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [2342,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],[63,[1,2]],
     [75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [2371,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2372,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2376,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2378,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2379,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2380,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2381,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [2385,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [2387,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [2389,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2391,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [2392,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [2393,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [2394,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [2396,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [2397,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],[2398,[[6,fail]]],[2402,[[9,fail]]],
 [2404,[[0,fail]]],[2407,[[3,fail]]],
 [2435,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [2436,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [2440,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [2442,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [2443,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [2444,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [2446,[[1,[2]],[6,[1]],[9,[1]],[13,[2]],[18,[1]],[21,[1]],[25,[2]],
     [30,[1]],[33,[1]],[37,[2]]]],
 [2451,[[0,[1,2]],[10,[1,2]],[13,[1,2]],[22,[1,2]],[25,[1,2]],[34,[1,2]],
     [37,[1,2]],[46,[1,2]],[49,[1,2]],[58,[1,2]]]],
 [2455,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [2456,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [2461,[[0,[1]],[1,[1]],[6,[2]],[12,[1]],[13,[1]],[18,[2]],[24,[1]],
     [25,[1]],[30,[2]],[36,[1]]]],[2463,[[10,fail]]],[2466,[[10,fail]]],
 [2481,[[1,[1]],[4,[1,2]],[13,[1]],[16,[1,2]],[25,[1]],[28,[1,2]],
     [37,[1]],[40,[1,2]],[49,[1]],[52,[1,2]]]],
 [2498,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [2499,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [2503,[[4,[1]],[9,[1]],[16,[1]],[21,[1]],[28,[1]],[33,[1]],[40,[1]],
     [45,[1]],[52,[1]],[57,[1]]]],
 [2505,[[4,[1]],[9,[1]],[16,[1]],[21,[1]],[28,[1]],[33,[1]],[40,[1]],
     [45,[1]],[52,[1]],[57,[1]]]],
 [2506,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [2507,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [2508,[[3,[1]],[4,[1]],[9,[2]],[15,[1]],[16,[1]],[21,[2]],[27,[1]],
     [28,[1]],[33,[2]],[39,[1]]]],
 [2512,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [2516,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [2520,[[0,[1]],[3,[1,2]],[12,[1]],[15,[1,2]],[24,[1]],[27,[1,2]],
     [36,[1]],[39,[1,2]],[48,[1]],[51,[1,2]]]],
 [2521,[[0,[1,2]],[3,[1]],[12,[1,2]],[15,[1]],[24,[1,2]],[27,[1]],
     [36,[1,2]],[39,[1]],[48,[1,2]],[51,[1]]]],
 [2522,[[0,[1]],[4,[2]],[9,[1]],[12,[1]],[16,[2]],[21,[1]],[24,[1]],
     [28,[2]],[33,[1]],[36,[1]]]],
 [2523,[[1,[1,2]],[4,[1,2]],[13,[1,2]],[16,[1,2]],[25,[1,2]],[28,[1,2]],
     [37,[1,2]],[40,[1,2]],[49,[1,2]],[52,[1,2]]]],[2528,[[1,fail]]],
 [2531,[[1,fail]]],
 [2537,[[4,[4]],[16,[4]],[28,[4]],[40,[4]],[52,[4]],[64,[4]],[76,[4]],
     [88,[4]],[100,[4]],[112,[4]]]],
 [2540,[[9,[2,3,4]],[21,[2,3,4]],[33,[2,3,4]],[45,[2,3,4]],[57,[2,3,4]],
     [69,[2,3,4]],[81,[2,3,4]],[93,[2,3,4]],[105,[2,3,4]],[117,[2,3,4]]] 
  ],
 [2560,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],[64,[2,3]],
     [76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [2568,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],[64,[2,3]],
     [76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [2582,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [2583,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],[61,[1,2]],
     [73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [2585,[[0,[1]],[4,[2]],[6,[1]],[12,[1]],[16,[2]],[18,[1]],[24,[1]],
     [28,[2]],[30,[1]],[36,[1]]]],[2587,[[1,fail]]],[2588,[[9,fail]]],
 [2589,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],[2592,[[9,fail]]],[2593,[[1,fail]]],
 [2596,[[12,fail]]],[2598,[[0,fail]]],
 [2599,[[4,[1]],[7,[1,2]],[16,[1]],[19,[1,2]],[28,[1]],[31,[1,2]],
     [40,[1]],[43,[1,2]],[52,[1]],[55,[1,2]]]],
 [2606,[[4,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],
     [19,[1,1,1,1,1,1,1,2]],[21,[1,1,1,1,1,1,1,2]],[27,[2]],[31,[2]],
     [39,[1,1,1,1,1,1,1,2]],[40,[1,1,1,1,1,1,1,2]],[51,[1,1,1,1,1,1,1,2]] 
    ]],
 [2615,[[4,[1]],[7,[1]],[16,[1]],[19,[1]],[28,[1]],[31,[1]],[40,[1]],
     [43,[1]],[52,[1]],[55,[1]]]],
 [2616,[[3,[2]],[7,[1]],[15,[2]],[19,[1]],[27,[2]],[31,[1]],[39,[2]],
     [43,[1]],[51,[2]],[55,[1]]]],
 [2617,[[3,[2]],[7,[1]],[15,[2]],[19,[1]],[27,[2]],[31,[1]],[39,[2]],
     [43,[1]],[51,[2]],[55,[1]]]],
 [2618,[[4,[1]],[7,[2]],[16,[1]],[19,[2]],[28,[1]],[31,[2]],[40,[1]],
     [43,[2]],[52,[1]],[55,[2]]]],
 [2621,[[4,[2]],[7,[2]],[16,[2]],[19,[2]],[28,[2]],[31,[2]],[40,[2]],
     [43,[2]],[52,[2]],[55,[2]]]],
 [2623,[[4,[1]],[7,[1]],[16,[1]],[19,[1]],[28,[1]],[31,[1]],[40,[1]],
     [43,[1]],[52,[1]],[55,[1]]]],
 [2624,[[4,[1]],[7,[2]],[16,[1]],[19,[2]],[28,[1]],[31,[2]],[40,[1]],
     [43,[2]],[52,[1]],[55,[2]]]],
 [2629,[[4,[2]],[7,[2]],[16,[2]],[19,[2]],[28,[2]],[31,[2]],[40,[2]],
     [43,[2]],[52,[2]],[55,[2]]]],
 [2633,[[3,[1,2]],[4,[1]],[9,[1,2]],[15,[1,2]],[16,[1]],[21,[1,2]],
     [27,[1,2]],[28,[1]],[33,[1,2]],[39,[1,2]]]],
 [2634,[[3,[1,2]],[4,[1]],[9,[1,2]],[15,[1,2]],[16,[1]],[21,[1,2]],
     [27,[1,2]],[28,[1]],[33,[1,2]],[39,[1,2]]]],
 [2635,[[3,[2]],[7,[1,2]],[15,[2]],[19,[1,2]],[27,[2]],[31,[1,2]],
     [39,[2]],[43,[1,2]],[51,[2]],[55,[1,2]]]],
 [2636,[[0,[1]],[4,[1]],[7,[1]],[12,[1]],[16,[1]],[19,[1]],[24,[1]],
     [28,[1]],[31,[1]],[36,[1]]]],
 [2637,[[4,[2,3]],[7,[1,2]],[16,[2,3]],[19,[1,2]],[28,[2,3]],[31,[1,2]],
     [40,[2,3]],[43,[1,2]],[52,[2,3]],[55,[1,2]]]],
 [2638,[[0,[2]],[7,[1]],[12,[2]],[19,[1]],[24,[2]],[31,[1]],[36,[2]],
     [43,[1]],[48,[2]],[55,[1]]]],
 [2639,[[3,[2]],[7,[1,2]],[15,[2]],[19,[1,2]],[27,[2]],[31,[1,2]],
     [39,[2]],[43,[1,2]],[51,[2]],[55,[1,2]]]],
 [2640,[[0,[2]],[7,[1]],[12,[2]],[19,[1]],[24,[2]],[31,[1]],[36,[2]],
     [43,[1]],[48,[2]],[55,[1]]]],
 [2641,[[3,[1,2]],[4,[1]],[9,[1,2]],[15,[1,2]],[16,[1]],[21,[1,2]],
     [27,[1,2]],[28,[1]],[33,[1,2]],[39,[1,2]]]],
 [2642,[[3,[1,2]],[4,[1]],[9,[1,2]],[15,[1,2]],[16,[1]],[21,[1,2]],
     [27,[1,2]],[28,[1]],[33,[1,2]],[39,[1,2]]]],
 [2655,[[3,[1]],[7,[1,2]],[15,[1]],[16,[1]],[19,[1,2]],[31,[1,2]],
     [39,[1]],[40,[1]],[43,[1,2]],[51,[1]]]],
 [2656,[[0,[1]],[4,[2]],[16,[2]],[19,[1]],[21,[1]],[27,[1]],[28,[2]],
     [40,[2]],[43,[1]],[52,[2]]]],
 [2658,[[4,[1]],[7,[1]],[16,[1]],[19,[1]],[28,[1]],[31,[1]],[40,[1]],
     [43,[1]],[52,[1]],[55,[1]]]],
 [2664,[[0,[1,2]],[4,[1]],[12,[1,2]],[16,[1]],[24,[1,2]],[28,[1]],
     [36,[1,2]],[40,[1]],[48,[1,2]],[52,[1]]]],
 [2682,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [2686,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [2688,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [2690,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [2692,[[0,[1]],[3,[1]],[7,[2]],[12,[1]],[15,[1]],[19,[2]],[24,[1]],
     [27,[1]],[31,[2]],[36,[1]]]],
 [2695,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],[67,[1,2]],
     [79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [2697,[[4,[1,2]],[7,[1,2]],[16,[1,2]],[19,[1,2]],[28,[1,2]],[31,[1,2]],
     [40,[1,2]],[43,[1,2]],[52,[1,2]],[55,[1,2]]]],
 [2699,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [2701,[[3,[1]],[6,[1,2]],[15,[1]],[18,[1,2]],[27,[1]],[30,[1,2]],
     [39,[1]],[42,[1,2]],[51,[1]],[54,[1,2]]]],
 [2702,[[3,[1,2]],[6,[1]],[15,[1,2]],[18,[1]],[27,[1,2]],[30,[1]],
     [39,[1,2]],[42,[1]],[51,[1,2]],[54,[1]]]],
 [2707,[[0,[2]],[6,[1]],[7,[1]],[12,[2]],[18,[1]],[19,[1]],[24,[2]],
     [30,[1]],[31,[1]],[36,[2]]]],[2713,[[4,fail]]],[2717,[[4,fail]]],
 [2723,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [2754,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],[67,[2,3]],
     [79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [2756,[[3,[1]],[7,[2]],[9,[1]],[15,[1]],[19,[2]],[21,[1]],[27,[1]],
     [31,[2]],[33,[1]],[39,[1]]]],
 [2758,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],[67,[2,3]],
     [79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [2760,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [2761,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [2762,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [2763,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[2767,[[15,fail]]],[2768,[[15,fail]]],
 [2770,[[0,fail]]],[2771,[[4,fail]]],
 [2774,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],[2776,[[4,fail]]],[2778,[[0,fail]]],
 [2782,[[13,[1,1,1,2]],[27,[1,1,1,2]],[33,[6]],[57,[1,1,1,2]],
     [73,[1,1,1,2]],[87,[1,1,1,2]],[93,[6]],[117,[1,1,1,2]],
     [133,[1,1,1,2]],[147,[1,1,1,2]]]],
 [2785,[[3,[1,1,1,2,1,2]],[15,[1,1,1,2,1,2]],[21,[1,1,1,2,1,2]],
     [25,[1,1,1,2,1,2]],[33,[1,1,1,2,1,2]],[34,[1,1,1,2,1,2]],
     [45,[1,1,1,2,1,2]],[49,[1,1,1,2,1,2]],[58,[1,1,1,2,1,2]],
     [63,[1,1,1,2,1,2]]]],
 [2786,[[15,[5,6,6]],[45,[5,6,6]],[75,[5,6,6]],[105,[5,6,6]],[135,[5,6,6]],
     [165,[5,6,6]],[195,[5,6,6]],[225,[5,6,6]],[255,[5,6,6]]]],
 [2787,[[6,[5,6]],[15,[2,3]],[27,[5,6]],[45,[2,3]],[57,[5,6]],[66,[5,6]],
     [75,[2,3]],[87,[5,6]],[105,[2,3]],[117,[5,6]]]],
 [2788,[[9,[1,2]],[10,[2,3,3,3]],[39,[1,2]],[45,[1,2]],[49,[2,3,3,3]],
     [69,[1,2]],[70,[2,3,3,3]],[99,[1,2]],[105,[1,2]],[109,[2,3,3,3]]]],
 [2789,[[9,[1]],[33,[4,6,6]],[39,[1]],[45,[1]],[69,[1]],[93,[4,6,6]],
     [99,[1]],[105,[1]],[129,[1]],[153,[4,6,6]]]],
 [2791,[[0,[1,1,1,1,2,2,2,2]],[10,[1,2,2]],[21,[1,2,2]],[27,[1,2,2]],
     [30,[1,1,1,1,2,2,2,2]],[45,[1,2,2]],[46,[1,1,1,1,2,2,2,2]],
     [57,[1,2,2]],[61,[1,1,1,1,2,2,2,2]],[70,[1,2,2]]]],
 [2793,[[9,[3]],[21,[3]],[33,[3]],[45,[3]],[57,[3]],[69,[3]],[81,[3]],
     [93,[3]],[105,[3]],[117,[3]]]],
 [2794,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [2795,[[0,[1,1,2,2]],[10,[1,1,2,2]],[13,[1,1,2,2]],[22,[1,1,2,2]],
     [25,[1,1,2,2]],[34,[1,1,2,2]],[37,[1,1,2,2]],[46,[1,1,2,2]],
     [49,[1,1,2,2]],[58,[1,1,2,2]]]],
 [2796,[[0,[1,2,2]],[9,[1,2,2]],[15,[1,2,2]],[21,[1,2,2]],[27,[1,2,2]],
     [33,[1,2,2]],[39,[1,2,2]],[45,[1,2,2]],[51,[1,2,2]],[57,[1,2,2]]]],
 [2797,[[0,[2,3]],[9,[2,3]],[15,[2,3]],[21,[2,3]],[27,[2,3]],[33,[2,3]],
     [39,[2,3]],[45,[2,3]],[51,[2,3]],[57,[2,3]]]],
 [2801,[[0,[1,1,1,1,2]],[10,[1,1,1,1,2]],[13,[1,1,1,1,2]],[22,[1,1,1,1,2]],
     [25,[1,1,1,1,2]],[34,[1,1,1,1,2]],[37,[1,1,1,1,2]],[46,[1,1,1,1,2]],
     [49,[1,1,1,1,2]],[58,[1,1,1,1,2]]]],
 [2802,[[0,[1,1,1,2]],[9,[1,1,1,2]],[15,[1,1,1,2]],[21,[1,1,1,2]],
     [27,[1,1,1,2]],[33,[1,1,1,2]],[39,[1,1,1,2]],[45,[1,1,1,2]],
     [51,[1,1,1,2]],[57,[1,1,1,2]]]],
 [2803,[[3,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [27,[1,2]],[33,[1,2]],[34,[1,2]],[39,[1,2]]]],
 [2804,[[0,[1,2,2]],[9,[1,2,2]],[15,[1,2,2]],[21,[1,2,2]],[27,[1,2,2]],
     [33,[1,2,2]],[39,[1,2,2]],[45,[1,2,2]],[51,[1,2,2]],[57,[1,2,2]]]],
 [2805,[[3,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [27,[1,2]],[33,[1,2]],[34,[1,2]],[39,[1,2]]]],
 [2810,[[3,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [27,[1,2]],[33,[1,2]],[34,[1,2]],[39,[1,2]]]],
 [2811,[[3,[1]],[9,[1]],[10,[1]],[15,[1]],[21,[1]],[22,[1]],[27,[1]],
     [33,[1]],[34,[1]],[39,[1]]]],
 [2813,[[0,[1]],[6,[1]],[10,[1]],[13,[1]],[18,[1]],[22,[1]],[25,[1]],
     [30,[1]],[34,[1]],[37,[1]]]],[2814,[[9,fail]]],
 [2815,[[0,[1,1,1,1,2]],[6,[1,1,1,1,2]],[13,[1,1,1,1,2]],[18,[1,1,1,1,2]],
     [25,[1,1,1,1,2]],[30,[1,1,1,1,2]],[37,[1,1,1,1,2]],[42,[1,1,1,1,2]],
     [49,[1,1,1,1,2]],[54,[1,1,1,1,2]]]],
 [2817,[[0,[1,1,2,2]],[6,[1,1,2,2]],[13,[1,1,2,2]],[18,[1,1,2,2]],
     [25,[1,1,2,2]],[30,[1,1,2,2]],[37,[1,1,2,2]],[42,[1,1,2,2]],
     [49,[1,1,2,2]],[54,[1,1,2,2]]]],[2830,[[9,fail]]],[2832,[[3,fail]]],
 [2833,[[0,fail]]],
 [2837,[[0,[1,2,2,3]],[6,[1,2,2,3]],[12,[1,2,2,3]],[18,[1,2,2,3]],
     [24,[1,2,2,3]],[30,[1,2,2,3]],[36,[1,2,2,3]],[42,[1,2,2,3]],
     [48,[1,2,2,3]],[54,[1,2,2,3]]]],
 [2880,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [2883,[[12,[4]],[36,[4]],[60,[4]],[84,[4]],[108,[4]],[132,[4]],
     [156,[4]],[180,[4]],[204,[4]],[228,[4]]]],[2885,[[1,fail]]],
 [2886,[[4,fail]]],[2887,[[9,fail]]],[2888,[[9,fail]]],
 [2891,[[12,[4]],[36,[4]],[60,[4]],[84,[4]],[108,[4]],[132,[4]],
     [156,[4]],[180,[4]],[204,[4]],[228,[4]]]],
 [2895,[[0,[1,1,1,2,1,2]],[12,[1,1,1,2,1,2]],[18,[1,1,1,2,1,2]],
     [22,[1,1,1,2,1,2]],[30,[1,1,1,2,1,2]],[31,[1,1,1,2,1,2]],
     [42,[1,1,1,2,1,2]],[46,[1,1,1,2,1,2]],[55,[1,1,1,2,1,2]],
     [60,[1,1,1,2,1,2]]]],
 [2896,[[6,[1,2]],[7,[2,3,3,3]],[36,[1,2]],[42,[1,2]],[46,[2,3,3,3]],
     [66,[1,2]],[67,[2,3,3,3]],[96,[1,2]],[102,[1,2]],[106,[2,3,3,3]]]],
 [2897,[[6,[1]],[30,[4,6,6]],[36,[1]],[42,[1]],[66,[1]],[90,[4,6,6]],
     [96,[1]],[102,[1]],[126,[1]],[150,[4,6,6]]]],
 [2899,[[6,[4,6,6,9,5]],[46,[4,6,6,9,5]],[66,[4,6,6,9,5]],
     [106,[4,6,6,9,5]],[126,[4,6,6,9,5]],[166,[4,6,6,9,5]],
     [186,[4,6,6,9,5]],[226,[4,6,6,9,5]],[246,[4,6,6,9,5]]]],
 [2901,[[10,[1,1,1,2]],[24,[1,1,1,2]],[30,[6]],[54,[1,1,1,2]],
     [70,[1,1,1,2]],[84,[1,1,1,2]],[90,[6]],[114,[1,1,1,2]],
     [130,[1,1,1,2]],[144,[1,1,1,2]]]],
 [2902,[[6,[1,1,2,3,3,3,1,2]],[10,[1,1,2,3,3,3,1,2]],[19,[1,1,2,3,3,3,1,2]],
     [30,[3,5,4]],[36,[1,1,2,3,3,3,1,2]],[43,[1,1,2,3,3,3,1,2]],
     [58,[1,1,2,3,3,3,1,2]],[66,[1,1,2,3,3,3,1,2]],[70,[1,1,2,3,3,3,1,2]],
     [79,[1,1,2,3,3,3,1,2]]]],
 [2906,[[0,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[18,[1,2]],[19,[1,2]],
     [24,[1,2]],[30,[1,2]],[31,[1,2]],[36,[1,2]]]],
 [2907,[[0,[1]],[6,[1]],[7,[1]],[12,[1]],[18,[1]],[19,[1]],[24,[1]],
     [30,[1]],[31,[1]],[36,[1]]]],
 [2908,[[0,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],[12,[1,1,1,2]],
     [18,[1,1,1,2]],[22,[1,1,1,2]],[24,[1,1,1,2]],[30,[1,1,1,2]],
     [34,[1,1,1,2]],[36,[1,1,1,2]]]],
 [2909,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [2910,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [2912,[[0,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[18,[1,2]],[19,[1,2]],
     [24,[1,2]],[30,[1,2]],[31,[1,2]],[36,[1,2]]]],
 [2914,[[0,[1]],[6,[1]],[10,[1]],[12,[1]],[18,[1]],[22,[1]],[24,[1]],
     [30,[1]],[34,[1]],[36,[1]]]],
 [2915,[[6,[1,1,2,2]],[18,[1,1,2,2]],[30,[1,1,2,2]],[42,[1,1,2,2]],
     [54,[1,1,2,2]],[66,[1,1,2,2]],[78,[1,1,2,2]],[90,[1,1,2,2]],
     [102,[1,1,2,2]],[114,[1,1,2,2]]]],
 [2917,[[6,[1,2,3]],[18,[1,2,3]],[30,[1,2,3]],[42,[1,2,3]],[54,[1,2,3]],
     [66,[1,2,3]],[78,[1,2,3]],[90,[1,2,3]],[102,[1,2,3]],[114,[1,2,3]]] 
  ],
 [2920,[[0,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[18,[1,2]],[19,[1,2]],
     [24,[1,2]],[30,[1,2]],[31,[1,2]],[36,[1,2]]]],
 [2923,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [2924,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [2926,[[0,[1]],[7,[1]],[10,[1]],[12,[1]],[19,[1]],[22,[1]],[24,[1]],
     [31,[1]],[34,[1]],[36,[1]]]],
 [2928,[[6,[1,1,1,1,2]],[7,[1,1,1,1,2]],[18,[1,1,1,1,2]],[19,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[31,[1,1,1,1,2]],[42,[1,1,1,1,2]],[43,[1,1,1,1,2]],
     [54,[1,1,1,1,2]],[55,[1,1,1,1,2]]]],
 [2930,[[6,[1,1,2,2]],[7,[1,1,2,2]],[18,[1,1,2,2]],[19,[1,1,2,2]],
     [30,[1,1,2,2]],[31,[1,1,2,2]],[42,[1,1,2,2]],[43,[1,1,2,2]],
     [54,[1,1,2,2]],[55,[1,1,2,2]]]],
 [2931,[[0,[1]],[3,[1]],[6,[1]],[10,[1]],[12,[1]],[15,[1]],[18,[1]],
     [22,[1]],[24,[1]],[27,[1]]]],
 [2932,[[0,[1,1,1,2]],[3,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[15,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[27,[1,1,1,2]]]],[2936,[[6,fail]]],[2940,[[0,fail]]],
 [2941,[[6,fail]]],[2948,[[6,fail]]],[2949,[[18,fail]]],
 [2960,[[1,[1]],[4,[1]],[13,[1]],[16,[1]],[25,[1]],[28,[1]],[37,[1]],
     [40,[1]],[49,[1]],[52,[1]]]],
 [2961,[[0,[1,2]],[1,[1]],[6,[1,2]],[12,[1,2]],[13,[1]],[18,[1,2]],
     [24,[1,2]],[25,[1]],[30,[1,2]],[36,[1,2]]]],
 [2962,[[0,[1,2]],[1,[1]],[6,[1,2]],[12,[1,2]],[13,[1]],[18,[1,2]],
     [24,[1,2]],[25,[1]],[30,[1,2]],[36,[1,2]]]],
 [2963,[[0,[1,2]],[4,[1]],[6,[1,2]],[12,[1,2]],[16,[1]],[18,[1,2]],
     [24,[1,2]],[28,[1]],[30,[1,2]],[36,[1,2]]]],
 [2964,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [2965,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [2966,[[0,[2]],[4,[1,2]],[12,[2]],[16,[1,2]],[24,[2]],[28,[1,2]],
     [36,[2]],[40,[1,2]],[48,[2]],[52,[1,2]]]],
 [2968,[[1,[1]],[4,[1]],[13,[1]],[16,[1]],[25,[1]],[28,[1]],[37,[1]],
     [40,[1]],[49,[1]],[52,[1]]]],
 [2969,[[0,[1,2]],[4,[1]],[6,[1,2]],[12,[1,2]],[16,[1]],[18,[1,2]],
     [24,[1,2]],[28,[1]],[30,[1,2]],[36,[1,2]]]],
 [2970,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [2972,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [2974,[[0,[2]],[4,[1,2]],[12,[2]],[16,[1,2]],[24,[2]],[28,[1,2]],
     [36,[2]],[40,[1,2]],[48,[2]],[52,[1,2]]]],
 [2978,[[0,[2]],[4,[1]],[12,[2]],[16,[1]],[24,[2]],[28,[1]],[36,[2]],
     [40,[1]],[48,[2]],[52,[1]]]],
 [2979,[[0,[2]],[4,[1]],[12,[2]],[16,[1]],[24,[2]],[28,[1]],[36,[2]],
     [40,[1]],[48,[2]],[52,[1]]]],
 [2980,[[0,[2]],[4,[2]],[13,[2]],[16,[2]],[25,[2]],[28,[2]],[37,[2]],
     [40,[2]],[49,[2]],[52,[2]]]],
 [2981,[[1,[1]],[4,[1]],[6,[1]],[13,[1]],[16,[1]],[18,[1]],[25,[1]],
     [28,[1]],[30,[1]],[37,[1]]]],
 [2983,[[0,[2]],[1,[1]],[12,[2]],[13,[1]],[24,[2]],[25,[1]],[36,[2]],
     [37,[1]],[48,[2]],[49,[1]]]],
 [2984,[[0,[2]],[4,[2]],[13,[2]],[16,[2]],[25,[2]],[28,[2]],[37,[2]],
     [40,[2]],[49,[2]],[52,[2]]]],
 [2985,[[0,[2]],[1,[1]],[12,[2]],[13,[1]],[24,[2]],[25,[1]],[36,[2]],
     [37,[1]],[48,[2]],[49,[1]]]],
 [2986,[[0,[1,2]],[4,[1]],[6,[1,2]],[12,[1,2]],[16,[1]],[18,[1,2]],
     [24,[1,2]],[28,[1]],[30,[1,2]],[36,[1,2]]]],
 [2987,[[0,[1,2]],[4,[1]],[6,[1,2]],[12,[1,2]],[16,[1]],[18,[1,2]],
     [24,[1,2]],[28,[1]],[30,[1,2]],[36,[1,2]]]],
 [2988,[[0,[1,2]],[1,[1]],[6,[1,2]],[12,[1,2]],[13,[1]],[18,[1,2]],
     [24,[1,2]],[25,[1]],[30,[1,2]],[36,[1,2]]]],
 [2989,[[0,[1,2]],[1,[1]],[6,[1,2]],[12,[1,2]],[13,[1]],[18,[1,2]],
     [24,[1,2]],[25,[1]],[30,[1,2]],[36,[1,2]]]],
 [2991,[[1,[2,3]],[4,[1,2]],[13,[2,3]],[16,[1,2]],[25,[2,3]],[28,[1,2]],
     [37,[2,3]],[40,[1,2]],[49,[2,3]],[52,[1,2]]]],
 [2995,[[0,[1]],[4,[1,2]],[12,[1]],[13,[1]],[16,[1,2]],[28,[1,2]],
     [36,[1]],[37,[1]],[40,[1,2]],[48,[1]]]],
 [3000,[[0,[1]],[4,[1]],[13,[1]],[16,[1]],[25,[1]],[28,[1]],[37,[1]],
     [40,[1]],[49,[1]],[52,[1]]]],
 [3003,[[1,[1,2]],[4,[1]],[12,[1]],[13,[1,2]],[25,[1,2]],[28,[1]],
     [30,[1]],[36,[1]],[37,[1,2]],[49,[1,2]]]],
 [3021,[[1,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[13,[1]],
     [18,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[43,[1]],[48,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [3025,[[3,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [22,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[52,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [3027,[[3,[1,1,1,1,1,1,2,2]],[10,[1,1,1,1,1,1,2,2]],[16,[1]],
     [22,[1,1,1,1,1,1,2,2]],[28,[1,1,1,1,1,1,2,2]],[33,[1,1,1,1,1,1,2,2]],
     [40,[1,1,1,1,1,1,2,2]],[46,[1]],[52,[1,1,1,1,1,1,2,2]],
     [58,[1,1,1,1,1,1,2,2]]]],
 [3029,[[1,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[13,[1]],
     [18,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[43,[1]],[48,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [3040,[[3,[1,1,1,1,2]],[22,[1,1,1,1,2]],[33,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [63,[1,1,1,1,2]],[82,[1,1,1,1,2]],[93,[1,1,1,1,2]],[112,[1,1,1,1,2]],
     [123,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [3041,[[3,[1,1,1,1,2]],[22,[1,1,1,1,2]],[33,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [63,[1,1,1,1,2]],[82,[1,1,1,1,2]],[93,[1,1,1,1,2]],[112,[1,1,1,1,2]],
     [123,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [3042,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [3043,[[7,[1,2]],[37,[1,2]],[67,[1,2]],[97,[1,2]],[127,[1,2]],
     [157,[1,2]],[187,[1,2]],[217,[1,2]],[247,[1,2]]]],
 [3073,[[12,[1]],[16,[1,2]],[42,[1]],[46,[1,2]],[72,[1]],[76,[1,2]],
     [102,[1]],[106,[1,2]],[132,[1]],[136,[1,2]]]],
 [3074,[[1,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [19,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[42,[1,2]],[49,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]]]],
 [3078,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[16,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[46,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [3080,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[16,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[46,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [3081,[[12,[1,2]],[16,[1]],[42,[1,2]],[46,[1]],[72,[1,2]],[76,[1]],
     [102,[1,2]],[106,[1]],[132,[1,2]],[136,[1]]]],
 [3082,[[1,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [19,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[42,[1,2]],[49,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]]]],
 [3089,[[7,[1,2]],[27,[1,2]],[37,[1,2]],[57,[1,2]],[67,[1,2]],[87,[1,2]],
     [97,[1,2]],[117,[1,2]],[127,[1,2]],[147,[1,2]]]],
 [3095,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [3096,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [3098,[[7,[1,2]],[16,[1,2]],[37,[1,2]],[46,[1,2]],[67,[1,2]],[76,[1,2]],
     [97,[1,2]],[106,[1,2]],[127,[1,2]],[136,[1,2]]]],
 [3125,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [3133,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [3139,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],[57,[1,1,1,1,2]],
     [67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],[117,[1,1,1,1,2]],
     [127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [3143,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],[57,[1,1,1,1,2]],
     [67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],[117,[1,1,1,1,2]],
     [127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [3147,[[7,[1,2]],[12,[1]],[37,[1,2]],[42,[1]],[67,[1,2]],[72,[1]],
     [97,[1,2]],[102,[1]],[127,[1,2]],[132,[1]]]],
 [3148,[[7,[1]],[12,[1,2]],[37,[1]],[42,[1,2]],[67,[1]],[72,[1,2]],
     [97,[1]],[102,[1,2]],[127,[1]],[132,[1,2]]]],
 [3150,[[1,[1]],[12,[1]],[18,[1]],[22,[1]],[31,[1]],[42,[1]],[48,[1]],
     [52,[1]],[61,[1]],[72,[1]]]],[3155,[[12,fail]]],[3158,[[7,fail]]],
 [3177,[[1,[1,1,1,1,1,1,2,2]],[6,[1,1,1,1,1,1,2,2]],[13,[1]],
     [19,[1,1,1,1,1,1,2,2]],[25,[1,1,1,1,1,1,2,2]],[31,[1,1,1,1,1,1,2,2]],
     [36,[1,1,1,1,1,1,2,2]],[43,[1]],[49,[1,1,1,1,1,1,2,2]],
     [55,[1,1,1,1,1,1,2,2]]]],
 [3181,[[4,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [21,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[34,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[51,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [3183,[[4,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [21,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[34,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[51,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [3185,[[1,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[13,[1]],
     [19,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[43,[1]],[49,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [3196,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [3197,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [3226,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [3234,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [3242,[[0,[1]],[10,[1]],[21,[1]],[27,[1]],[31,[1]],[40,[1]],[51,[1]],
     [57,[1]],[61,[1]],[70,[1]]]],[3254,[[21,fail]]],[3257,[[16,fail]]],
 [3264,[[6,fail]]],
 [3324,[[0,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[13,[1]],
     [19,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[43,[1]],[49,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [3328,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[45,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [58,[1,1,1,1,1,1,1,2]]]],
 [3330,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[45,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [58,[1,1,1,1,1,1,1,2]]]],
 [3332,[[0,[1,1,1,1,1,1,2,2]],[7,[1,1,1,1,1,1,2,2]],[13,[1]],
     [19,[1,1,1,1,1,1,2,2]],[25,[1,1,1,1,1,1,2,2]],[30,[1,1,1,1,1,1,2,2]],
     [37,[1,1,1,1,1,1,2,2]],[43,[1]],[49,[1,1,1,1,1,1,2,2]],
     [55,[1,1,1,1,1,1,2,2]]]],
 [3337,[[15,[1,2]],[19,[1]],[45,[1,2]],[49,[1]],[75,[1,2]],[79,[1]],
     [105,[1,2]],[109,[1]],[135,[1,2]],[139,[1]]]],
 [3339,[[10,[1,2]],[19,[1,2]],[40,[1,2]],[49,[1,2]],[70,[1,2]],
     [79,[1,2]],[100,[1,2]],[109,[1,2]],[130,[1,2]],[139,[1,2]]]],
 [3341,[[15,[1]],[19,[1,2]],[45,[1]],[49,[1,2]],[75,[1]],[79,[1,2]],
     [105,[1]],[109,[1,2]],[135,[1]],[139,[1,2]]]],
 [3343,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [3344,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [3345,[[0,[1,1,1,1,2]],[19,[1,1,1,1,2]],[30,[1,1,1,1,2]],[49,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[79,[1,1,1,1,2]],[90,[1,1,1,1,2]],[109,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[139,[1,1,1,1,2]]]],
 [3346,[[0,[1,1,1,1,2]],[19,[1,1,1,1,2]],[30,[1,1,1,1,2]],[49,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[79,[1,1,1,1,2]],[90,[1,1,1,1,2]],[109,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[139,[1,1,1,1,2]]]],
 [3384,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [3386,[[4,[1]],[15,[1]],[21,[1]],[25,[1]],[34,[1]],[45,[1]],[51,[1]],
     [55,[1]],[64,[1]],[75,[1]]]],
 [3388,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [3390,[[10,[1,2]],[15,[1]],[40,[1,2]],[45,[1]],[70,[1,2]],[75,[1]],
     [100,[1,2]],[105,[1]],[130,[1,2]],[135,[1]]]],
 [3391,[[10,[1]],[15,[1,2]],[40,[1]],[45,[1,2]],[70,[1]],[75,[1,2]],
     [100,[1]],[105,[1,2]],[130,[1]],[135,[1,2]]]],[3402,[[15,fail]]],
 [3406,[[10,fail]]],
 [3441,[[10,[1]],[19,[1]],[40,[1]],[49,[1]],[70,[1]],[79,[1]],[100,[1]],
     [109,[1]],[130,[1]],[139,[1]]]],
 [3461,[[7,[2]],[22,[2]],[37,[2]],[52,[2]],[67,[2]],[82,[2]],[97,[2]],
     [112,[2]],[127,[2]],[142,[2]]]],
 [3469,[[7,[1,1,2]],[22,[1,1,2]],[37,[1,1,2]],[52,[1,1,2]],[67,[1,1,2]],
     [82,[1,1,2]],[97,[1,1,2]],[112,[1,1,2]],[127,[1,1,2]],[142,[1,1,2]] 
    ]],
 [3477,[[0,[1,2,2]],[10,[1,2,2]],[21,[1,2,2]],[25,[1,2,2]],[31,[1,2,2]],
     [40,[1,2,2]],[51,[1,2,2]],[55,[1,2,2]],[61,[1,2,2]],[70,[1,2,2]]]],
 [3481,[[0,[2]],[30,[2]],[60,[2]],[90,[2]],[120,[2]],[150,[2]],
     [180,[2]],[210,[2]],[240,[2]]]],
 [3482,[[0,[3]],[30,[3]],[60,[3]],[90,[3]],[120,[3]],[150,[3]],
     [180,[3]],[210,[3]],[240,[3]]]],
 [3483,[[15,[3]],[45,[3]],[75,[3]],[105,[3]],[135,[3]],[165,[3]],
     [195,[3]],[225,[3]],[255,[3]]]],
 [3484,[[15,[2]],[45,[2]],[75,[2]],[105,[2]],[135,[2]],[165,[2]],
     [195,[2]],[225,[2]],[255,[2]]]],
 [3486,[[0,[1,1,1,2]],[10,[1,1,1,2]],[12,[1,1,1,2]],[22,[1,1,1,2]],
     [31,[1,1,1,2]],[40,[1,1,1,2]],[42,[1,1,1,2]],[52,[1,1,1,2]],
     [61,[1,1,1,2]],[70,[1,1,1,2]]]],[3489,[[30,fail]]],[3492,[[30,fail]]],
 [3499,[[15,fail]]],
 [3506,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3510,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3512,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3514,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3515,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [3516,[[1,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [3529,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [3531,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [3548,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3549,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3553,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [3555,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [3556,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3557,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3558,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [3570,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3571,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3572,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3573,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [3574,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [3575,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],[67,[1,2]],
     [79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [3581,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],[61,[1,2]],
     [73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [3590,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3591,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3595,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [3597,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [3598,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3599,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3600,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [3612,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3613,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3614,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3615,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [3616,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],[3617,[[7,fail]]],
 [3623,[[1,fail]]],
 [3631,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3632,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3636,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3638,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3639,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3640,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3642,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [3651,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3652,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3655,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [3656,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [3657,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [3659,[[10,[1,2]],[22,[1,2]],[34,[1,2]],[46,[1,2]],[58,[1,2]],
     [70,[1,2]],[82,[1,2]],[94,[1,2]],[106,[1,2]],[118,[1,2]]]],
 [3663,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],[3698,[[15,fail]]],
 [3699,[[15,fail]]],[3701,[[6,fail]]],[3702,[[6,fail]]],[3703,[[9,fail]]],
 [3704,[[9,fail]]],[3707,[[0,fail]]],[3709,[[0,fail]]],[3737,[[15,fail]]],
 [3738,[[15,[4]],[39,[4]],[63,[4]],[87,[4]],[111,[4]],[135,[4]],
     [159,[4]],[183,[4]],[207,[4]],[231,[4]]]],
 [3740,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[3741,[[6,fail]]],
 [3742,[[9,[4]],[33,[4]],[57,[4]],[81,[4]],[105,[4]],[129,[4]],
     [153,[4]],[177,[4]],[201,[4]],[225,[4]]]],[3743,[[9,fail]]],
 [3746,[[0,fail]]],
 [3748,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [3749,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3751,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3753,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3755,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3757,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3768,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [3769,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [3770,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [3771,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [3772,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],[3773,[[0,fail]]],
 [3774,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [3787,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3788,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3793,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3794,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [3797,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3798,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3799,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3800,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3801,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3802,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3803,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3804,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3805,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3806,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3807,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3808,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3810,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3814,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3819,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3820,[[1,[1,2]],[6,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [3822,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3826,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3828,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3830,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3831,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [3832,[[1,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [3845,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [3847,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [3861,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3863,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3864,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3865,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [3867,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [3876,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [3877,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3880,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [3881,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [3882,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],[3884,[[10,fail]]],[3888,[[4,fail]]],
 [3917,[[15,[4]],[39,[4]],[63,[4]],[87,[4]],[111,[4]],[135,[4]],
     [159,[4]],[183,[4]],[207,[4]],[231,[4]]]],[3918,[[15,fail]]],
 [3920,[[6,fail]]],
 [3921,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[3922,[[9,fail]]],
 [3923,[[9,[4]],[33,[4]],[57,[4]],[81,[4]],[105,[4]],[129,[4]],
     [153,[4]],[177,[4]],[201,[4]],[225,[4]]]],
 [3926,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[3928,[[0,fail]]],
 [3930,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [3931,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3935,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3936,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3937,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3938,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3939,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3940,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3941,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3942,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [3943,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [3944,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [3945,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3946,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [3948,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3952,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3957,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3958,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [3960,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],[3982,[[15,fail]]],[3983,[[15,fail]]],
 [3985,[[6,fail]]],[3986,[[6,fail]]],[3987,[[9,fail]]],[3988,[[9,fail]]],
 [3991,[[0,fail]]],[3993,[[0,fail]]],
 [3994,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3998,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [3999,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4000,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4001,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [4002,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4003,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4004,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4005,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4006,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4007,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4008,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4009,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4011,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4015,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4020,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4021,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [4023,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [4025,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4036,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [4037,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [4038,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [4039,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [4040,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],[4041,[[0,fail]]],
 [4042,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [4057,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4058,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4059,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4060,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [4061,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4062,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4063,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4064,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4065,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4066,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4067,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4068,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4070,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4074,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4079,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [4080,[[1,[1,2]],[6,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4082,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [4085,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4086,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4087,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4088,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [4089,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4090,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4091,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4092,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4095,[[0,[1]],[3,[2]],[6,[1]],[9,[2]],[12,[1]],[15,[2]],[18,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [4096,[[0,[1]],[3,[2]],[6,[1]],[9,[2]],[12,[1]],[15,[2]],[18,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [4107,[[3,[1]],[4,[1,2]],[9,[1,2]],[10,[1]],[15,[1]],[16,[1,2]],
     [21,[1,2]],[22,[1]],[27,[1]],[28,[1,2]]]],
 [4108,[[0,[1,2]],[4,[1]],[9,[1]],[10,[1,2]],[15,[1,2]],[16,[1]],
     [21,[1]],[22,[1,2]],[27,[1,2]],[28,[1]]]],
 [4112,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4113,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [4114,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4115,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [4116,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4117,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4118,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4119,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4120,[[0,[1]],[3,[2]],[6,[1]],[9,[2]],[12,[1]],[15,[2]],[18,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [4121,[[0,[1]],[3,[2]],[6,[1]],[9,[2]],[12,[1]],[15,[2]],[18,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [4126,[[0,[4]],[6,[4]],[12,[4]],[18,[4]],[24,[4]],[30,[4]],[36,[4]],
     [42,[4]],[48,[4]],[54,[4]]]],
 [4134,[[0,[1,2]],[3,[1]],[7,[1]],[9,[1,2]],[13,[1,2]],[15,[1]],
     [19,[1]],[21,[1,2]],[25,[1,2]],[27,[1]]]],
 [4135,[[0,[1,2]],[1,[1]],[6,[1,2]],[9,[1]],[13,[1]],[15,[1,2]],
     [19,[1,2]],[21,[1]],[25,[1]],[27,[1,2]]]],
 [4140,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4142,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4144,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [4146,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4147,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4152,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [4157,[[10,[1,2]],[22,[1,2]],[34,[1,2]],[46,[1,2]],[58,[1,2]],
     [70,[1,2]],[82,[1,2]],[94,[1,2]],[106,[1,2]],[118,[1,2]]]],
 [4162,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [4165,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [4167,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [4169,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [4171,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4172,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4177,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[4182,[[10,fail]]],[4187,[[4,fail]]],
 [4191,[[3,fail]]],
 [4192,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4194,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [4195,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4196,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [4197,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4198,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [4214,[[0,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [4222,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [4223,[[1,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [4224,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [4237,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],[4238,[[3,fail]]],
 [4239,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4240,[[3,[3]],[4,[1,2]],[9,[3]],[10,[1,2]],[15,[3]],[16,[1,2]],
     [21,[3]],[22,[1,2]],[27,[3]],[28,[1,2]]]],
 [4241,[[3,[2]],[4,[1]],[9,[2]],[10,[1]],[15,[2]],[16,[1]],[21,[2]],
     [22,[1]],[27,[2]],[28,[1]]]],
 [4242,[[0,[1]],[3,[2]],[7,[1]],[9,[2]],[13,[1]],[15,[2]],[19,[1]],
     [21,[2]],[25,[1]],[27,[2]]]],
 [4243,[[0,[1,2]],[3,[3]],[7,[1,2]],[9,[3]],[13,[1,2]],[15,[3]],
     [19,[1,2]],[21,[3]],[25,[1,2]],[27,[3]]]],
 [4245,[[0,[2]],[4,[2]],[7,[2]],[10,[2]],[13,[2]],[16,[2]],[19,[2]],
     [22,[2]],[25,[2]],[28,[2]]]],
 [4250,[[3,[2,4]],[13,[2,4]],[19,[2,4]],[27,[2,4]],[37,[2,4]],[43,[2,4]],
     [51,[2,4]],[61,[2,4]],[67,[2,4]],[75,[2,4]]]],
 [4251,[[3,[1,2]],[10,[2,4]],[15,[1,2]],[22,[2,4]],[27,[1,2]],[34,[2,4]],
     [39,[1,2]],[46,[2,4]],[51,[1,2]],[58,[2,4]]]],
 [4254,[[3,[1,1,1,2]],[7,[1,2]],[10,[1,1,1,2]],[15,[1,1,1,2]],[19,[1,2]],
     [22,[1,1,1,2]],[27,[1,1,1,2]],[31,[1,2]],[34,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [4255,[[0,[1,1,1,2]],[4,[1,2]],[9,[1,1,1,2]],[13,[1,1,1,2]],[16,[1,2]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[28,[1,2]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [4256,[[4,[2,4]],[9,[1,2]],[16,[2,4]],[21,[1,2]],[28,[2,4]],[33,[1,2]],
     [40,[2,4]],[45,[1,2]],[52,[2,4]],[57,[1,2]]]],
 [4258,[[9,[8,16]],[55,[8,16]],[73,[8,16]],[105,[8,16]],[151,[8,16]],
     [169,[8,16]],[201,[8,16]],[247,[8,16]]]],
 [4259,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [4263,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4264,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4265,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[4271,[[13,fail]]],[4279,[[7,fail]]],
 [4280,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [4281,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [4282,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [4283,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [4284,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [4302,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4303,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4304,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [4310,[[13,[2,4]],[37,[2,4]],[61,[2,4]],[85,[2,4]],[109,[2,4]],
     [133,[2,4]],[157,[2,4]],[181,[2,4]],[205,[2,4]],[229,[2,4]]]],
 [4318,[[7,[2,4]],[31,[2,4]],[55,[2,4]],[79,[2,4]],[103,[2,4]],
     [127,[2,4]],[151,[2,4]],[175,[2,4]],[199,[2,4]],[223,[2,4]]]],
 [4323,[[0,[2]],[4,[1]],[6,[2]],[10,[1]],[12,[2]],[16,[1]],[18,[2]],
     [22,[1]],[24,[2]],[28,[1]]]],
 [4324,[[0,[2]],[3,[1]],[6,[2]],[9,[1]],[12,[2]],[15,[1]],[18,[2]],
     [21,[1]],[24,[2]],[27,[1]]]],
 [4332,[[4,[1,2]],[9,[1,2]],[16,[1,2]],[21,[1,2]],[28,[1,2]],[33,[1,2]],
     [40,[1,2]],[45,[1,2]],[52,[1,2]],[57,[1,2]]]],
 [4335,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [4340,[[0,[3]],[4,[1,2]],[6,[3]],[10,[1,2]],[12,[3]],[16,[1,2]],
     [18,[3]],[22,[1,2]],[24,[3]],[28,[1,2]]]],
 [4341,[[0,[2]],[3,[1]],[6,[2]],[9,[1]],[12,[2]],[15,[1]],[18,[2]],
     [21,[1]],[24,[2]],[27,[1]]]],
 [4349,[[4,[1]],[9,[1]],[16,[1]],[21,[1]],[28,[1]],[33,[1]],[40,[1]],
     [45,[1]],[52,[1]],[57,[1]]]],
 [4352,[[0,[1,2]],[4,[1,2]],[12,[1,2]],[16,[1,2]],[24,[1,2]],[28,[1,2]],
     [36,[1,2]],[40,[1,2]],[48,[1,2]],[52,[1,2]]]],
 [4355,[[0,[2]],[3,[1]],[6,[2]],[9,[1]],[12,[2]],[15,[1]],[18,[2]],
     [21,[1]],[24,[2]],[27,[1]]]],
 [4356,[[0,[3]],[1,[1,2]],[6,[3]],[7,[1,2]],[12,[3]],[13,[1,2]],
     [18,[3]],[19,[1,2]],[24,[3]],[25,[1,2]]]],
 [4360,[[1,[1,2]],[6,[1,2]],[13,[1,2]],[18,[1,2]],[25,[1,2]],[30,[1,2]],
     [37,[1,2]],[42,[1,2]],[49,[1,2]],[54,[1,2]]]],
 [4365,[[0,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [4370,[[0,[2]],[3,[1]],[6,[2]],[9,[1]],[12,[2]],[15,[1]],[18,[2]],
     [21,[1]],[24,[2]],[27,[1]]]],
 [4371,[[0,[2]],[1,[1]],[6,[2]],[7,[1]],[12,[2]],[13,[1]],[18,[2]],
     [19,[1]],[24,[2]],[25,[1]]]],
 [4375,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [4380,[[0,[1,2]],[9,[1,2]],[13,[1,2]],[21,[1,2]],[25,[1,2]],[33,[1,2]],
     [37,[1,2]],[45,[1,2]],[49,[1,2]],[57,[1,2]]]],
 [4385,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [4389,[[0,[1,1,1,2]],[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [4397,[[0,[1,1,1,2]],[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [4399,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [4400,[[0,[1,2]],[7,[2,4]],[12,[1,2]],[19,[2,4]],[24,[1,2]],[31,[2,4]],
     [36,[1,2]],[43,[2,4]],[48,[1,2]],[55,[2,4]]]],
 [4401,[[4,[2,4]],[12,[2,4]],[22,[2,4]],[28,[2,4]],[36,[2,4]],[46,[2,4]],
     [52,[2,4]],[60,[2,4]],[70,[2,4]],[76,[2,4]]]],
 [4402,[[0,[1,1,1,2]],[4,[1,2]],[7,[1,1,1,2]],[12,[1,1,1,2]],[16,[1,2]],
     [19,[1,1,1,2]],[24,[1,1,1,2]],[28,[1,2]],[31,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [4405,[[10,[4,8]],[16,[4,8]],[42,[4,8]],[58,[4,8]],[64,[4,8]],
     [90,[4,8]],[106,[4,8]],[112,[4,8]],[138,[4,8]],[154,[4,8]]]],
 [4406,[[1,[2,4]],[6,[1,2]],[13,[2,4]],[18,[1,2]],[25,[2,4]],[30,[1,2]],
     [37,[2,4]],[42,[1,2]],[49,[2,4]],[54,[1,2]]]],
 [4410,[[1,[1,2]],[6,[1]],[10,[1,2]],[13,[1,2]],[18,[1]],[22,[1,2]],
     [25,[1,2]],[30,[1]],[34,[1,2]],[37,[1,2]]]],
 [4414,[[0,[1]],[1,[1,2]],[6,[1,2]],[7,[1]],[12,[1]],[13,[1,2]],
     [18,[1,2]],[19,[1]],[24,[1]],[25,[1,2]]]],
 [4422,[[0,[1,2]],[1,[1]],[6,[1]],[7,[1,2]],[12,[1,2]],[13,[1]],
     [18,[1]],[19,[1,2]],[24,[1,2]],[25,[1]]]],
 [4424,[[15,[4]],[39,[4]],[63,[4]],[87,[4]],[111,[4]],[135,[4]],
     [159,[4]],[183,[4]],[207,[4]],[231,[4]]]],
 [4428,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],[4429,[[1,fail]]],[4437,[[10,fail]]],
 [4438,[[9,fail]]],
 [4439,[[1,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],[4442,[[12,fail]]],
 [4454,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[4456,[[1,fail]]],
 [4459,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[4461,[[0,fail]]],[4466,[[4,fail]]],
 [4468,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4469,[[9,[4]],[33,[4]],[57,[4]],[81,[4]],[105,[4]],[129,[4]],
     [153,[4]],[177,[4]],[201,[4]],[225,[4]]]],[4472,[[4,fail]]],
 [4488,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [4516,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4517,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4521,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4523,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [4524,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4525,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [4526,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [4530,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4532,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [4534,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4536,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4537,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4538,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4539,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4541,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [4542,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[4543,[[6,fail]]],[4547,[[9,fail]]],
 [4549,[[0,fail]]],[4552,[[3,fail]]],
 [4560,[[6,[1]],[9,[1,2]],[18,[1]],[21,[1,2]],[30,[1]],[33,[1,2]],
     [42,[1]],[45,[1,2]],[54,[1]],[57,[1,2]]]],
 [4562,[[2,[1,2]],[6,[1]],[14,[1,2]],[18,[1]],[26,[1,2]],[30,[1]],
     [38,[1,2]],[42,[1]],[50,[1,2]],[54,[1]]]],
 [4580,[[5,[1]],[8,[1,2]],[17,[1]],[20,[1,2]],[29,[1]],[32,[1,2]],
     [41,[1]],[44,[1,2]],[53,[1]],[56,[1,2]]]],
 [4581,[[5,[1,2]],[8,[1]],[17,[1,2]],[20,[1]],[29,[1,2]],[32,[1]],
     [41,[1,2]],[44,[1]],[53,[1,2]],[56,[1]]]],
 [4588,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4589,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [4594,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [4596,[[2,[1]],[5,[1]],[9,[2]],[14,[1]],[17,[1]],[21,[2]],[26,[1]],
     [29,[1]],[33,[2]],[38,[1]]]],
 [4600,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [4602,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4603,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [4604,[[2,[2]],[8,[1]],[9,[1]],[14,[2]],[20,[1]],[21,[1]],[26,[2]],
     [32,[1]],[33,[1]],[38,[2]]]],
 [4606,[[2,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],[4607,[[6,fail]]],
 [4609,[[6,fail]]],
 [4623,[[5,[1,2]],[9,[1]],[17,[1,2]],[21,[1]],[29,[1,2]],[33,[1]],
     [41,[1,2]],[45,[1]],[53,[1,2]],[57,[1]]]],
 [4648,[[8,[1,2]],[11,[1]],[20,[1,2]],[23,[1]],[32,[1,2]],[35,[1]],
     [44,[1,2]],[47,[1]],[56,[1,2]],[59,[1]]]],
 [4650,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [4651,[[0,[1]],[5,[1]],[12,[1]],[17,[1]],[24,[1]],[29,[1]],[36,[1]],
     [41,[1]],[48,[1]],[53,[1]]]],
 [4652,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [4653,[[5,[1,2]],[9,[1,2]],[17,[1,2]],[21,[1,2]],[29,[1,2]],[33,[1,2]],
     [41,[1,2]],[45,[1,2]],[53,[1,2]],[57,[1,2]]]],
 [4654,[[0,[1]],[5,[2]],[11,[1]],[12,[1]],[17,[2]],[23,[1]],[24,[1]],
     [29,[2]],[35,[1]],[36,[1]]]],
 [4657,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4661,[[8,[1]],[11,[1,2]],[20,[1]],[23,[1,2]],[32,[1]],[35,[1,2]],
     [44,[1]],[47,[1,2]],[56,[1]],[59,[1,2]]]],
 [4663,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [4664,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [4665,[[0,[1]],[5,[1]],[12,[1]],[17,[1]],[24,[1]],[29,[1]],[36,[1]],
     [41,[1]],[48,[1]],[53,[1]]]],
 [4666,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [4668,[[0,[2]],[5,[1]],[8,[1]],[12,[2]],[17,[1]],[20,[1]],[24,[2]],
     [29,[1]],[32,[1]],[36,[2]]]],[4674,[[9,fail]]],[4677,[[9,fail]]],
 [4685,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [4705,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [4706,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [4710,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [4714,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],[60,[2,3]],
     [72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [4723,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [4728,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],[60,[2,3]],
     [72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [4731,[[0,[2]],[2,[1]],[8,[1]],[12,[2]],[14,[1]],[20,[1]],[24,[2]],
     [26,[1]],[32,[1]],[36,[2]]]],[4732,[[5,fail]]],
 [4735,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],[4738,[[5,fail]]],[4739,[[9,fail]]],
 [4740,[[9,fail]]],[4741,[[8,fail]]],[4742,[[8,fail]]],
 [4747,[[5,[1,2,2,3]],[8,[1,2,2,3]],[17,[1,2,2,3]],[20,[1,2,2,3]],
     [29,[1,2,2,3]],[32,[1,2,2,3]],[41,[1,2,2,3]],[44,[1,2,2,3]],
     [53,[1,2,2,3]],[56,[1,2,2,3]]]],
 [4750,[[5,[1,1,1,2]],[27,[6]],[35,[1,1,1,2]],[48,[1,1,1,2]],
     [65,[1,1,1,2]],[87,[6]],[95,[1,1,1,2]],[108,[1,1,1,2]],
     [125,[1,1,1,2]],[147,[6]]]],
 [4752,[[0,[1,1,2,3,3,3,1,2]],[15,[1,1,2,3,3,3,1,2]],[23,[1,1,2,3,3,3,1,2]],
     [27,[3,5,4]],[36,[1,1,2,3,3,3,1,2]],[47,[1,1,2,3,3,3,1,2]],
     [53,[1,1,2,3,3,3,1,2]],[60,[1,1,2,3,3,3,1,2]],[75,[1,1,2,3,3,3,1,2]],
     [83,[1,1,2,3,3,3,1,2]]]],
 [4753,[[11,[2,3,3,3]],[15,[1,2]],[23,[1,2]],[51,[2,3,3,3]],[53,[1,2]],
     [71,[2,3,3,3]],[75,[1,2]],[83,[1,2]],[111,[2,3,3,3]],[113,[1,2]]]],
 [4754,[[11,[4,6,6,9,5]],[51,[4,6,6,9,5]],[71,[4,6,6,9,5]],
     [111,[4,6,6,9,5]],[131,[4,6,6,9,5]],[171,[4,6,6,9,5]],
     [191,[4,6,6,9,5]],[231,[4,6,6,9,5]],[251,[4,6,6,9,5]]]],
 [4756,[[3,[1,1,1,2,1,2]],[12,[1,1,1,2,1,2]],[17,[1,1,1,2,1,2]],
     [27,[1,1,1,2,1,2]],[29,[1,1,1,2,1,2]],[35,[1,1,1,2,1,2]],
     [39,[1,1,1,2,1,2]],[47,[1,1,1,2,1,2]],[59,[1,1,1,2,1,2]],
     [63,[1,1,1,2,1,2]]]],
 [4757,[[15,[1]],[23,[1]],[24,[4,6,6]],[53,[1]],[75,[1]],[83,[1]],
     [84,[4,6,6]],[113,[1]],[135,[1]],[143,[1]]]],
 [4760,[[3,[3]],[15,[3]],[27,[3]],[39,[3]],[51,[3]],[63,[3]],[75,[3]],
     [87,[3]],[99,[3]],[111,[3]]]],
 [4762,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [4763,[[0,[1,1,1,2]],[5,[1,1,1,2]],[11,[1,1,1,2]],[12,[1,1,1,2]],
     [17,[1,1,1,2]],[23,[1,1,1,2]],[24,[1,1,1,2]],[29,[1,1,1,2]],
     [35,[1,1,1,2]],[36,[1,1,1,2]]]],
 [4764,[[0,[1]],[5,[1]],[11,[1]],[12,[1]],[17,[1]],[23,[1]],[24,[1]],
     [29,[1]],[35,[1]],[36,[1]]]],
 [4765,[[0,[1]],[3,[1]],[8,[1]],[12,[1]],[15,[1]],[20,[1]],[24,[1]],
     [27,[1]],[32,[1]],[36,[1]]]],
 [4766,[[0,[1,1,1,2]],[5,[1,1,1,2]],[8,[1,1,1,2]],[11,[1,1,1,2]],
     [12,[1,1,1,2]],[17,[1,1,1,2]],[20,[1,1,1,2]],[23,[1,1,1,2]],
     [24,[1,1,1,2]],[29,[1,1,1,2]]]],
 [4767,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[12,[1]],[17,[1]],[20,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [4768,[[3,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],[23,[1,2]],
     [27,[1,2]],[29,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [4769,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [4770,[[0,[1,1,2,2]],[12,[1,1,2,2]],[24,[1,1,2,2]],[36,[1,1,2,2]],
     [48,[1,1,2,2]],[60,[1,1,2,2]],[72,[1,1,2,2]],[84,[1,1,2,2]],
     [96,[1,1,2,2]],[108,[1,1,2,2]]]],
 [4772,[[0,[1,1,1,1,2]],[3,[1,1,1,1,2]],[12,[1,1,1,1,2]],[15,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[27,[1,1,1,1,2]],[36,[1,1,1,1,2]],[39,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[51,[1,1,1,1,2]]]],[4776,[[11,fail]]],
 [4779,[[3,[1]],[5,[1]],[11,[1]],[15,[1]],[17,[1]],[23,[1]],[27,[1]],
     [29,[1]],[35,[1]],[39,[1]]]],
 [4780,[[3,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],[23,[1,2]],
     [27,[1,2]],[29,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [4781,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [4783,[[0,[1,2,3]],[12,[1,2,3]],[24,[1,2,3]],[36,[1,2,3]],[48,[1,2,3]],
     [60,[1,2,3]],[72,[1,2,3]],[84,[1,2,3]],[96,[1,2,3]],[108,[1,2,3]]]]
  ,
 [4785,[[0,[1,1,2,2]],[3,[1,1,2,2]],[12,[1,1,2,2]],[15,[1,1,2,2]],
     [24,[1,1,2,2]],[27,[1,1,2,2]],[36,[1,1,2,2]],[39,[1,1,2,2]],
     [48,[1,1,2,2]],[51,[1,1,2,2]]]],
 [4786,[[3,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],[23,[1,2]],
     [27,[1,2]],[29,[1,2]],[35,[1,2]],[39,[1,2]]]],[4794,[[0,fail]]],
 [4798,[[3,fail]]],[4800,[[11,fail]]],[4801,[[5,fail]]],
 [4826,[[2,[1,1,1,1,2]],[11,[1,1,1,1,2]],[14,[1,1,1,1,2]],[23,[1,1,1,1,2]],
     [26,[1,1,1,1,2]],[35,[1,1,1,1,2]],[38,[1,1,1,1,2]],[47,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [4827,[[2,[1,1,1,1,2]],[11,[1,1,1,1,2]],[14,[1,1,1,1,2]],[23,[1,1,1,1,2]],
     [26,[1,1,1,1,2]],[35,[1,1,1,1,2]],[38,[1,1,1,1,2]],[47,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [4833,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [4834,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4840,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [4842,[[3,[2]],[8,[1]],[11,[1]],[15,[2]],[20,[1]],[23,[1]],[27,[2]],
     [32,[1]],[35,[1]],[39,[2]]]],
 [4846,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [4847,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],[63,[1,2]],
     [75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [4848,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [4850,[[2,[1]],[3,[1]],[8,[2]],[14,[1]],[15,[1]],[20,[2]],[26,[1]],
     [27,[1]],[32,[2]],[38,[1]]]],
 [4852,[[0,[1,2]],[8,[1,2]],[12,[1,2]],[20,[1,2]],[24,[1,2]],[32,[1,2]],
     [36,[1,2]],[44,[1,2]],[48,[1,2]],[56,[1,2]]]],[4859,[[0,fail]]],
 [4863,[[0,fail]]],
 [4867,[[3,[4]],[15,[4]],[27,[4]],[39,[4]],[51,[4]],[63,[4]],[75,[4]],
     [87,[4]],[99,[4]],[111,[4]]]],
 [4868,[[0,[2,3,4]],[12,[2,3,4]],[24,[2,3,4]],[36,[2,3,4]],[48,[2,3,4]],
     [60,[2,3,4]],[72,[2,3,4]],[84,[2,3,4]],[96,[2,3,4]],[108,[2,3,4]]]]
  ,
 [4890,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [4892,[[3,[2,3]],[15,[2,3]],[27,[2,3]],[39,[2,3]],[51,[2,3]],[63,[2,3]],
     [75,[2,3]],[87,[2,3]],[99,[2,3]],[111,[2,3]]]],
 [4895,[[3,[2]],[5,[1]],[11,[1]],[15,[2]],[17,[1]],[23,[1]],[27,[2]],
     [29,[1]],[35,[1]],[39,[2]]]],
 [4903,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [4906,[[3,[2,3]],[15,[2,3]],[27,[2,3]],[39,[2,3]],[51,[2,3]],[63,[2,3]],
     [75,[2,3]],[87,[2,3]],[99,[2,3]],[111,[2,3]]]],[4912,[[11,fail]]],
 [4914,[[0,fail]]],[4916,[[8,fail]]],
 [4917,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],[4920,[[23,fail]]],[4921,[[8,fail]]],
 [4922,[[0,fail]]],
 [4937,[[6,[1]],[9,[2]],[18,[1]],[21,[2]],[30,[1]],[33,[2]],[42,[1]],
     [45,[2]],[54,[1]],[57,[2]]]],
 [4938,[[6,[1]],[9,[1]],[18,[1]],[21,[1]],[30,[1]],[33,[1]],[42,[1]],
     [45,[1]],[54,[1]],[57,[1]]]],
 [4939,[[6,[1]],[9,[2]],[18,[1]],[21,[2]],[30,[1]],[33,[2]],[42,[1]],
     [45,[2]],[54,[1]],[57,[2]]]],
 [4940,[[5,[1,2]],[6,[1]],[11,[1,2]],[17,[1,2]],[18,[1]],[23,[1,2]],
     [29,[1,2]],[30,[1]],[35,[1,2]],[41,[1,2]]]],
 [4941,[[5,[1,2]],[6,[1]],[11,[1,2]],[17,[1,2]],[18,[1]],[23,[1,2]],
     [29,[1,2]],[30,[1]],[35,[1,2]],[41,[1,2]]]],
 [4942,[[2,[1]],[6,[1]],[9,[1]],[14,[1]],[18,[1]],[21,[1]],[26,[1]],
     [30,[1]],[33,[1]],[38,[1]]]],
 [4943,[[5,[1,2]],[6,[1]],[11,[1,2]],[17,[1,2]],[18,[1]],[23,[1,2]],
     [29,[1,2]],[30,[1]],[35,[1,2]],[41,[1,2]]]],
 [4944,[[5,[1,2]],[6,[1]],[11,[1,2]],[17,[1,2]],[18,[1]],[23,[1,2]],
     [29,[1,2]],[30,[1]],[35,[1,2]],[41,[1,2]]]],
 [4945,[[5,[1,2]],[9,[1]],[11,[1,2]],[17,[1,2]],[21,[1]],[23,[1,2]],
     [29,[1,2]],[33,[1]],[35,[1,2]],[41,[1,2]]]],
 [4946,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [4947,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [4948,[[5,[1,2]],[9,[1]],[11,[1,2]],[17,[1,2]],[21,[1]],[23,[1,2]],
     [29,[1,2]],[33,[1]],[35,[1,2]],[41,[1,2]]]],
 [4949,[[6,[2]],[9,[1]],[18,[2]],[21,[1]],[30,[2]],[33,[1]],[42,[2]],
     [45,[1]],[54,[2]],[57,[1]]]],
 [4950,[[6,[1,2]],[9,[2]],[18,[1,2]],[21,[2]],[30,[1,2]],[33,[2]],
     [42,[1,2]],[45,[2]],[54,[1,2]],[57,[2]]]],
 [4952,[[6,[2]],[9,[2]],[18,[2]],[21,[2]],[30,[2]],[33,[2]],[42,[2]],
     [45,[2]],[54,[2]],[57,[2]]]],
 [4953,[[6,[1,2]],[9,[2,3]],[18,[1,2]],[21,[2,3]],[30,[1,2]],[33,[2,3]],
     [42,[1,2]],[45,[2,3]],[54,[1,2]],[57,[2,3]]]],
 [4955,[[6,[1]],[9,[1]],[18,[1]],[21,[1]],[30,[1]],[33,[1]],[42,[1]],
     [45,[1]],[54,[1]],[57,[1]]]],
 [4956,[[5,[1,2]],[9,[1]],[11,[1,2]],[17,[1,2]],[21,[1]],[23,[1,2]],
     [29,[1,2]],[33,[1]],[35,[1,2]],[41,[1,2]]]],
 [4958,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [4960,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [4961,[[5,[1,2]],[9,[1]],[11,[1,2]],[17,[1,2]],[21,[1]],[23,[1,2]],
     [29,[1,2]],[33,[1]],[35,[1,2]],[41,[1,2]]]],
 [4962,[[6,[2]],[9,[1]],[18,[2]],[21,[1]],[30,[2]],[33,[1]],[42,[2]],
     [45,[1]],[54,[2]],[57,[1]]]],
 [4964,[[6,[1,2]],[9,[2]],[18,[1,2]],[21,[2]],[30,[1,2]],[33,[2]],
     [42,[1,2]],[45,[2]],[54,[1,2]],[57,[2]]]],
 [4966,[[6,[2]],[9,[2]],[18,[2]],[21,[2]],[30,[2]],[33,[2]],[42,[2]],
     [45,[2]],[54,[2]],[57,[2]]]],
 [4971,[[5,[1]],[9,[1,2]],[17,[1]],[18,[1]],[21,[1,2]],[33,[1,2]],
     [41,[1]],[42,[1]],[45,[1,2]],[53,[1]]]],
 [4973,[[6,[1]],[9,[1]],[18,[1]],[21,[1]],[30,[1]],[33,[1]],[42,[1]],
     [45,[1]],[54,[1]],[57,[1]]]],
 [4975,[[6,[1,2]],[9,[1]],[17,[1]],[18,[1,2]],[30,[1,2]],[33,[1]],
     [35,[1]],[41,[1]],[42,[1,2]],[54,[1,2]]]],
 [5010,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [5027,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],[5029,[[0,fail]]],
 [5031,[[9,fail]]],[5033,[[5,fail]]],[5034,[[17,fail]]],
 [5037,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [5043,[[3,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[8,[1,1,1,1,1,1,1,2]],
     [18,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],[26,[2]],[30,[2]],
     [38,[1,1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,1,2]],[50,[1,1,1,1,1,1,1,2]] 
    ]],
 [5050,[[2,[1,2]],[6,[1]],[8,[1,2]],[14,[1,2]],[18,[1]],[20,[1,2]],
     [26,[1,2]],[30,[1]],[32,[1,2]],[38,[1,2]]]],
 [5051,[[3,[1]],[6,[1]],[15,[1]],[18,[1]],[27,[1]],[30,[1]],[39,[1]],
     [42,[1]],[51,[1]],[54,[1]]]],
 [5052,[[2,[1,2]],[6,[1]],[8,[1,2]],[14,[1,2]],[18,[1]],[20,[1,2]],
     [26,[1,2]],[30,[1]],[32,[1,2]],[38,[1,2]]]],
 [5053,[[2,[2]],[6,[1]],[14,[2]],[18,[1]],[26,[2]],[30,[1]],[38,[2]],
     [42,[1]],[50,[2]],[54,[1]]]],
 [5054,[[2,[2]],[6,[1]],[14,[2]],[18,[1]],[26,[2]],[30,[1]],[38,[2]],
     [42,[1]],[50,[2]],[54,[1]]]],
 [5055,[[3,[1]],[6,[1]],[8,[1]],[15,[1]],[18,[1]],[20,[1]],[27,[1]],
     [30,[1]],[32,[1]],[39,[1]]]],
 [5056,[[2,[1,2]],[6,[1]],[8,[1,2]],[14,[1,2]],[18,[1]],[20,[1,2]],
     [26,[1,2]],[30,[1]],[32,[1,2]],[38,[1,2]]]],
 [5057,[[2,[1,2]],[6,[1]],[8,[1,2]],[14,[1,2]],[18,[1]],[20,[1,2]],
     [26,[1,2]],[30,[1]],[32,[1,2]],[38,[1,2]]]],
 [5058,[[3,[1]],[6,[2]],[15,[1]],[18,[2]],[27,[1]],[30,[2]],[39,[1]],
     [42,[2]],[51,[1]],[54,[2]]]],
 [5062,[[3,[1]],[6,[2]],[15,[1]],[18,[2]],[27,[1]],[30,[2]],[39,[1]],
     [42,[2]],[51,[1]],[54,[2]]]],
 [5063,[[3,[2]],[6,[2]],[15,[2]],[18,[2]],[27,[2]],[30,[2]],[39,[2]],
     [42,[2]],[51,[2]],[54,[2]]]],
 [5065,[[3,[1,2]],[6,[2]],[15,[1,2]],[18,[2]],[27,[1,2]],[30,[2]],
     [39,[1,2]],[42,[2]],[51,[1,2]],[54,[2]]]],
 [5068,[[3,[1]],[6,[1]],[15,[1]],[18,[1]],[27,[1]],[30,[1]],[39,[1]],
     [42,[1]],[51,[1]],[54,[1]]]],
 [5069,[[3,[1]],[6,[2]],[15,[1]],[18,[2]],[27,[1]],[30,[2]],[39,[1]],
     [42,[2]],[51,[1]],[54,[2]]]],
 [5075,[[3,[1]],[6,[2]],[15,[1]],[18,[2]],[27,[1]],[30,[2]],[39,[1]],
     [42,[2]],[51,[1]],[54,[2]]]],
 [5077,[[3,[2]],[6,[2]],[15,[2]],[18,[2]],[27,[2]],[30,[2]],[39,[2]],
     [42,[2]],[51,[2]],[54,[2]]]],
 [5079,[[3,[1,2]],[6,[2]],[15,[1,2]],[18,[2]],[27,[1,2]],[30,[2]],
     [39,[1,2]],[42,[2]],[51,[1,2]],[54,[2]]]],
 [5082,[[3,[1,2]],[6,[2,3]],[15,[1,2]],[18,[2,3]],[27,[1,2]],[30,[2,3]],
     [39,[1,2]],[42,[2,3]],[51,[1,2]],[54,[2,3]]]],
 [5084,[[2,[1]],[6,[1]],[15,[1]],[18,[1]],[27,[1]],[30,[1]],[39,[1]],
     [42,[1]],[51,[1]],[54,[1]]]],
 [5086,[[3,[1,2]],[6,[1]],[14,[1]],[15,[1,2]],[27,[1,2]],[30,[1]],
     [32,[1]],[38,[1]],[39,[1,2]],[51,[1,2]]]],
 [5094,[[3,[1]],[6,[2]],[14,[1]],[18,[2]],[26,[1]],[27,[1]],[30,[2]],
     [42,[2]],[50,[1]],[51,[1]]]],
 [5095,[[8,[2,3,3,3]],[12,[1,2]],[20,[1,2]],[48,[2,3,3,3]],[50,[1,2]],
     [68,[2,3,3,3]],[72,[1,2]],[80,[1,2]],[108,[2,3,3,3]],[110,[1,2]]]],
 [5096,[[0,[1,1,1,2,1,2]],[9,[1,1,1,2,1,2]],[14,[1,1,1,2,1,2]],
     [24,[1,1,1,2,1,2]],[26,[1,1,1,2,1,2]],[32,[1,1,1,2,1,2]],
     [36,[1,1,1,2,1,2]],[44,[1,1,1,2,1,2]],[56,[1,1,1,2,1,2]],
     [60,[1,1,1,2,1,2]]]],
 [5097,[[12,[1]],[20,[1]],[21,[4,6,6]],[50,[1]],[72,[1]],[80,[1]],
     [81,[4,6,6]],[110,[1]],[132,[1]],[140,[1]]]],
 [5099,[[14,[5,6,6]],[44,[5,6,6]],[74,[5,6,6]],[104,[5,6,6]],[134,[5,6,6]],
     [164,[5,6,6]],[194,[5,6,6]],[224,[5,6,6]],[254,[5,6,6]]]],
 [5101,[[2,[1,1,1,2]],[24,[6]],[32,[1,1,1,2]],[45,[1,1,1,2]],
     [62,[1,1,1,2]],[84,[6]],[92,[1,1,1,2]],[105,[1,1,1,2]],
     [122,[1,1,1,2]],[144,[6]]]],
 [5103,[[2,[5,6]],[14,[2,3]],[32,[5,6]],[44,[2,3]],[45,[5,6]],[62,[5,6]],
     [74,[2,3]],[92,[5,6]],[104,[2,3]],[105,[5,6]]]],
 [5104,[[2,[1,2,2]],[5,[1,2,2]],[12,[1,1,1,1,2,2,2,2]],
     [20,[1,1,1,1,2,2,2,2]],[32,[1,2,2]],[36,[1,2,2]],[45,[1,2,2]],
     [56,[1,1,1,1,2,2,2,2]],[62,[1,2,2]],[65,[1,2,2]]]],
 [5105,[[0,[1,2]],[2,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],[20,[1,2]],
     [24,[1,2]],[26,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [5107,[[0,[1]],[2,[1]],[8,[1]],[12,[1]],[14,[1]],[20,[1]],[24,[1]],
     [26,[1]],[32,[1]],[36,[1]]]],
 [5108,[[0,[1,1,2,2]],[8,[1,1,2,2]],[12,[1,1,2,2]],[20,[1,1,2,2]],
     [24,[1,1,2,2]],[32,[1,1,2,2]],[36,[1,1,2,2]],[44,[1,1,2,2]],
     [48,[1,1,2,2]],[56,[1,1,2,2]]]],
 [5109,[[0,[1,1,1,1,2]],[8,[1,1,1,1,2]],[12,[1,1,1,1,2]],[20,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[32,[1,1,1,1,2]],[36,[1,1,1,1,2]],[44,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[56,[1,1,1,1,2]]]],
 [5110,[[0,[1]],[2,[1]],[9,[1]],[12,[1]],[14,[1]],[21,[1]],[24,[1]],
     [26,[1]],[33,[1]],[36,[1]]]],
 [5113,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [5114,[[2,[1,2,2]],[8,[1,2,2]],[14,[1,2,2]],[20,[1,2,2]],[26,[1,2,2]],
     [32,[1,2,2]],[38,[1,2,2]],[44,[1,2,2]],[50,[1,2,2]],[56,[1,2,2]]]],
 [5115,[[2,[1,1,1,2]],[8,[1,1,1,2]],[14,[1,1,1,2]],[20,[1,1,1,2]],
     [26,[1,1,1,2]],[32,[1,1,1,2]],[38,[1,1,1,2]],[44,[1,1,1,2]],
     [50,[1,1,1,2]],[56,[1,1,1,2]]]],
 [5117,[[0,[1,1,1,1,2]],[8,[1,1,1,1,2]],[12,[1,1,1,1,2]],[20,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[32,[1,1,1,1,2]],[36,[1,1,1,1,2]],[44,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[56,[1,1,1,1,2]]]],
 [5119,[[0,[1,2]],[2,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],[20,[1,2]],
     [24,[1,2]],[26,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [5124,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [5126,[[2,[2,3]],[8,[2,3]],[14,[2,3]],[20,[2,3]],[26,[2,3]],[32,[2,3]],
     [38,[2,3]],[44,[2,3]],[50,[2,3]],[56,[2,3]]]],
 [5128,[[2,[1,2,2]],[8,[1,2,2]],[14,[1,2,2]],[20,[1,2,2]],[26,[1,2,2]],
     [32,[1,2,2]],[38,[1,2,2]],[44,[1,2,2]],[50,[1,2,2]],[56,[1,2,2]]]],
 [5130,[[0,[1,1,2,2]],[8,[1,1,2,2]],[12,[1,1,2,2]],[20,[1,1,2,2]],
     [24,[1,1,2,2]],[32,[1,1,2,2]],[36,[1,1,2,2]],[44,[1,1,2,2]],
     [48,[1,1,2,2]],[56,[1,1,2,2]]]],
 [5133,[[0,[1,2]],[2,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],[20,[1,2]],
     [24,[1,2]],[26,[1,2]],[32,[1,2]],[36,[1,2]]]],[5137,[[8,fail]]],
 [5140,[[8,fail]]],[5141,[[0,fail]]],[5149,[[2,fail]]],
 [5165,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [5166,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [5170,[[8,[1,1,1,1,2]],[27,[1,1,1,1,2]],[38,[1,1,1,1,2]],[57,[1,1,1,1,2]],
     [68,[1,1,1,1,2]],[87,[1,1,1,1,2]],[98,[1,1,1,1,2]],[117,[1,1,1,1,2]],
     [128,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [5173,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[23,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[42,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [53,[1,1,1,1,1,1,1,2]]]],
 [5174,[[8,[1]],[12,[1,2]],[38,[1]],[42,[1,2]],[68,[1]],[72,[1,2]],
     [98,[1]],[102,[1,2]],[128,[1]],[132,[1,2]]]],
 [5179,[[3,[1,1,1,1,1,1,2,2]],[8,[1,1,1,1,1,1,2,2]],[15,[1]],
     [21,[1,1,1,1,1,1,2,2]],[27,[1,1,1,1,1,1,2,2]],[33,[1,1,1,1,1,1,2,2]],
     [38,[1,1,1,1,1,1,2,2]],[45,[1]],[51,[1,1,1,1,1,1,2,2]],
     [57,[1,1,1,1,1,1,2,2]]]],
 [5183,[[8,[1,1,1,1,2]],[27,[1,1,1,1,2]],[38,[1,1,1,1,2]],[57,[1,1,1,1,2]],
     [68,[1,1,1,1,2]],[87,[1,1,1,1,2]],[98,[1,1,1,1,2]],[117,[1,1,1,1,2]],
     [128,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [5185,[[3,[1,1,1,1,2,1,1,2]],[8,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [38,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [5187,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[23,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[42,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [53,[1,1,1,1,1,1,1,2]]]],
 [5188,[[8,[1,2]],[12,[1]],[38,[1,2]],[42,[1]],[68,[1,2]],[72,[1]],
     [98,[1,2]],[102,[1]],[128,[1,2]],[132,[1]]]],
 [5191,[[8,[1,2]],[18,[1,2]],[38,[1,2]],[48,[1,2]],[68,[1,2]],[78,[1,2]],
     [98,[1,2]],[108,[1,2]],[128,[1,2]],[138,[1,2]]]],
 [5218,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [5219,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [5226,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [17,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[47,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [5232,[[2,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[32,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [5238,[[2,[1,1,1,1,1,1,2,2]],[9,[1,1,1,1,1,1,2,2]],[15,[1]],
     [21,[1,1,1,1,1,1,2,2]],[27,[1,1,1,1,1,1,2,2]],[32,[1,1,1,1,1,1,2,2]],
     [39,[1,1,1,1,1,1,2,2]],[45,[1]],[51,[1,1,1,1,1,1,2,2]],
     [57,[1,1,1,1,1,1,2,2]]]],
 [5240,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [17,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[47,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [5270,[[12,[1,2]],[17,[1]],[42,[1,2]],[47,[1]],[72,[1,2]],[77,[1]],
     [102,[1,2]],[107,[1]],[132,[1,2]],[137,[1]]]],
 [5271,[[12,[1]],[17,[1,2]],[42,[1]],[47,[1,2]],[72,[1]],[77,[1,2]],
     [102,[1]],[107,[1,2]],[132,[1]],[137,[1,2]]]],
 [5279,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [5293,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [5296,[[2,[1]],[8,[1]],[12,[1]],[21,[1]],[32,[1]],[38,[1]],[42,[1]],
     [51,[1]],[62,[1]],[68,[1]]]],[5297,[[17,fail]]],[5299,[[12,fail]]],
 [5326,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [5328,[[11,[1]],[15,[1,2]],[41,[1]],[45,[1,2]],[71,[1]],[75,[1,2]],
     [101,[1]],[105,[1,2]],[131,[1]],[135,[1,2]]]],
 [5329,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[11,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[41,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [5331,[[11,[1,2]],[21,[1,2]],[41,[1,2]],[51,[1,2]],[71,[1,2]],
     [81,[1,2]],[101,[1,2]],[111,[1,2]],[131,[1,2]],[141,[1,2]]]],
 [5335,[[3,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [39,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]]]],
 [5339,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [5341,[[3,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [39,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]]]],
 [5342,[[11,[1,2]],[15,[1]],[41,[1,2]],[45,[1]],[71,[1,2]],[75,[1]],
     [101,[1,2]],[105,[1]],[131,[1,2]],[135,[1]]]],
 [5343,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[11,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[41,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [5347,[[0,[1,2]],[21,[1,2]],[30,[1,2]],[51,[1,2]],[60,[1,2]],[81,[1,2]],
     [90,[1,2]],[111,[1,2]],[120,[1,2]],[141,[1,2]]]],
 [5378,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [5392,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [5397,[[2,[1]],[6,[1]],[15,[1]],[26,[1]],[32,[1]],[36,[1]],[45,[1]],
     [56,[1]],[62,[1]],[66,[1]]]],[5404,[[11,fail]]],[5406,[[21,fail]]],
 [5408,[[6,fail]]],
 [5430,[[6,[1]],[15,[1]],[36,[1]],[45,[1]],[66,[1]],[75,[1]],[96,[1]],
     [105,[1]],[126,[1]],[135,[1]]]],
 [5468,[[5,[1,1,1,1,2]],[24,[1,1,1,1,2]],[35,[1,1,1,1,2]],[54,[1,1,1,1,2]],
     [65,[1,1,1,1,2]],[84,[1,1,1,1,2]],[95,[1,1,1,1,2]],[114,[1,1,1,1,2]],
     [125,[1,1,1,1,2]],[144,[1,1,1,1,2]]]],
 [5469,[[5,[1,1,1,1,2]],[24,[1,1,1,1,2]],[35,[1,1,1,1,2]],[54,[1,1,1,1,2]],
     [65,[1,1,1,1,2]],[84,[1,1,1,1,2]],[95,[1,1,1,1,2]],[114,[1,1,1,1,2]],
     [125,[1,1,1,1,2]],[144,[1,1,1,1,2]]]],
 [5473,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [5476,[[0,[1,1,1,1,1,1,2,2]],[5,[1,1,1,1,1,1,2,2]],[12,[1]],
     [18,[1,1,1,1,1,1,2,2]],[24,[1,1,1,1,1,1,2,2]],[30,[1,1,1,1,1,1,2,2]],
     [35,[1,1,1,1,1,1,2,2]],[42,[1]],[48,[1,1,1,1,1,1,2,2]],
     [54,[1,1,1,1,1,1,2,2]]]],
 [5482,[[3,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [20,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[50,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [5486,[[20,[1,2]],[50,[1,2]],[80,[1,2]],[110,[1,2]],[140,[1,2]],
     [170,[1,2]],[200,[1,2]],[230,[1,2]]]],
 [5488,[[3,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [20,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[50,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [5490,[[0,[1,1,1,1,2,1,1,2]],[5,[1,1,1,1,2,1,1,2]],[12,[1]],
     [18,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [35,[1,1,1,1,2,1,1,2]],[42,[1]],[48,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [5520,[[15,[1]],[20,[1,2]],[45,[1]],[50,[1,2]],[75,[1]],[80,[1,2]],
     [105,[1]],[110,[1,2]],[135,[1]],[140,[1,2]]]],
 [5522,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [5524,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],[50,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],[110,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],
 [5525,[[5,[1]],[11,[1]],[15,[1]],[24,[1]],[35,[1]],[41,[1]],[45,[1]],
     [54,[1]],[65,[1]],[71,[1]]]],
 [5533,[[15,[1,2]],[20,[1]],[45,[1,2]],[50,[1]],[75,[1,2]],[80,[1]],
     [105,[1,2]],[110,[1]],[135,[1,2]],[140,[1]]]],
 [5536,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [5538,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],[50,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],[110,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],[5546,[[20,fail]]],
 [5549,[[15,fail]]],
 [5606,[[20,[3]],[50,[3]],[80,[3]],[110,[3]],[140,[3]],[170,[3]],
     [200,[3]],[230,[3]]]],
 [5607,[[20,[2]],[50,[2]],[80,[2]],[110,[2]],[140,[2]],[170,[2]],
     [200,[2]],[230,[2]]]],
 [5611,[[5,[3]],[35,[3]],[65,[3]],[95,[3]],[125,[3]],[155,[3]],
     [185,[3]],[215,[3]],[245,[3]]]],
 [5613,[[5,[1,1,2]],[21,[1,1,2]],[36,[1,1,2]],[51,[1,1,2]],[66,[1,1,2]],
     [81,[1,1,2]],[96,[1,1,2]],[111,[1,1,2]],[126,[1,1,2]],[141,[1,1,2]] 
    ]],
 [5616,[[6,[1,1,1,2]],[15,[1,1,1,2]],[17,[1,1,1,2]],[27,[1,1,1,2]],
     [36,[1,1,1,2]],[45,[1,1,1,2]],[47,[1,1,1,2]],[57,[1,1,1,2]],
     [66,[1,1,1,2]],[75,[1,1,1,2]]]],
 [5624,[[5,[2]],[35,[2]],[65,[2]],[95,[2]],[125,[2]],[155,[2]],
     [185,[2]],[215,[2]],[245,[2]]]],
 [5627,[[5,[2]],[21,[2]],[36,[2]],[51,[2]],[66,[2]],[81,[2]],[96,[2]],
     [111,[2]],[126,[2]],[141,[2]]]],
 [5632,[[0,[1,2,2]],[8,[1,2,2]],[15,[1,2,2]],[27,[1,2,2]],[30,[1,2,2]],
     [38,[1,2,2]],[45,[1,2,2]],[57,[1,2,2]],[60,[1,2,2]],[68,[1,2,2]]]],
 [5639,[[20,fail]]],[5641,[[35,fail]]],[5643,[[20,fail]]],
 [5650,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5651,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [5658,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5659,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5664,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5666,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [5670,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5672,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5673,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5674,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [5675,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [5676,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [5677,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [5683,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [5701,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5704,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [5707,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5709,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [5713,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5715,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5717,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [5718,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [5735,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [5736,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5743,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5744,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5749,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5751,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [5755,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5757,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5758,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5759,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [5760,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [5761,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],[5762,[[6,fail]]],[5768,[[0,fail]]],
 [5776,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],[35,[1,2]],
     [41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [5777,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [5783,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5784,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5786,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [5787,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [5790,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5792,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5796,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5797,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5798,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5800,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [5805,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [5813,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [5816,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [5817,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],[35,[1,2]],
     [41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [5823,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5824,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5826,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [5827,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [5830,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5832,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5836,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [5837,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5838,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5840,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],[5845,[[6,fail]]],[5853,[[0,fail]]],
 [5863,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5865,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [5866,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [5869,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5871,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [5875,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5877,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5879,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [5880,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [5881,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[12,[1]],[15,[1]],[18,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [5900,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [5901,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5902,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [5903,[[0,[1,2]],[5,[3]],[6,[1,2]],[11,[3]],[12,[1,2]],[17,[3]],
     [18,[1,2]],[23,[3]],[24,[1,2]],[29,[3]]]],
 [5907,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5909,[[2,[1]],[5,[2]],[8,[1]],[11,[2]],[14,[1]],[17,[2]],[20,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [5913,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5914,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [5915,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5916,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [5917,[[2,[2]],[5,[1]],[8,[2]],[11,[1]],[14,[2]],[17,[1]],[20,[2]],
     [23,[1]],[26,[2]],[29,[1]]]],
 [5919,[[0,[1]],[2,[2]],[6,[1]],[8,[2]],[12,[1]],[14,[2]],[18,[1]],
     [20,[2]],[24,[1]],[26,[2]]]],
 [5921,[[6,[1,2]],[11,[1,2]],[18,[1,2]],[23,[1,2]],[30,[1,2]],[35,[1,2]],
     [42,[1,2]],[47,[1,2]],[54,[1,2]],[59,[1,2]]]],
 [5923,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [5937,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [5938,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5939,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [5940,[[0,[1]],[5,[2]],[6,[1]],[11,[2]],[12,[1]],[17,[2]],[18,[1]],
     [23,[2]],[24,[1]],[29,[2]]]],
 [5944,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5946,[[2,[1]],[5,[2]],[8,[1]],[11,[2]],[14,[1]],[17,[2]],[20,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [5950,[[2,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [5951,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [5952,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [5953,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [5954,[[2,[2]],[5,[1]],[8,[2]],[11,[1]],[14,[2]],[17,[1]],[20,[2]],
     [23,[1]],[26,[2]],[29,[1]]]],
 [5956,[[0,[1,2]],[2,[3]],[6,[1,2]],[8,[3]],[12,[1,2]],[14,[3]],
     [18,[1,2]],[20,[3]],[24,[1,2]],[26,[3]]]],
 [5958,[[6,[1]],[11,[1]],[18,[1]],[23,[1]],[30,[1]],[35,[1]],[42,[1]],
     [47,[1]],[54,[1]],[59,[1]]]],
 [5960,[[2,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],
 [5971,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],[35,[1,2]],
     [41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [5973,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [5974,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5976,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [5977,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [5980,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [5982,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [5984,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [5986,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [5987,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [5988,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [5991,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [5997,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [6002,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],[63,[1,2]],
     [75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],[6028,[[11,fail]]],
 [6030,[[14,fail]]],[6032,[[14,fail]]],[6034,[[5,fail]]],[6035,[[5,fail]]],
 [6036,[[11,fail]]],[6037,[[8,fail]]],[6038,[[8,fail]]],
 [6062,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],[6064,[[14,fail]]],
 [6066,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],
 [6068,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],[6069,[[5,fail]]],[6070,[[11,fail]]],
 [6071,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],[6072,[[8,fail]]],
 [6074,[[0,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [6075,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6076,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [6077,[[0,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6078,[[3,[1,2]],[5,[3]],[9,[1,2]],[11,[3]],[15,[1,2]],[17,[3]],
     [21,[1,2]],[23,[3]],[27,[1,2]],[29,[3]]]],
 [6079,[[0,[1]],[5,[2]],[8,[1]],[11,[2]],[14,[1]],[17,[2]],[20,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [6081,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [6082,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6087,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [6088,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6089,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [6090,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [6091,[[0,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [6093,[[0,[2]],[5,[1]],[8,[2]],[11,[1]],[14,[2]],[17,[1]],[20,[2]],
     [23,[1]],[26,[2]],[29,[1]]]],
 [6094,[[0,[2]],[3,[1]],[8,[2]],[9,[1]],[14,[2]],[15,[1]],[20,[2]],
     [21,[1]],[26,[2]],[27,[1]]]],
 [6098,[[0,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [6100,[[5,[1,2]],[9,[1,2]],[17,[1,2]],[21,[1,2]],[29,[1,2]],[33,[1,2]],
     [41,[1,2]],[45,[1,2]],[53,[1,2]],[57,[1,2]]]],
 [6108,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6109,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6111,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [6114,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6118,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [6120,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6122,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6123,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6124,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6125,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [6126,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],[6134,[[9,fail]]],[6135,[[15,fail]]],
 [6139,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[6141,[[5,fail]]],
 [6142,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [6144,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6145,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6147,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6149,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [6151,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6153,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6170,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6171,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6173,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6174,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6179,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [6180,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6182,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6183,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [6184,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6187,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6189,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6191,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6193,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6199,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6204,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6208,[[0,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [6209,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6210,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6212,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6214,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6215,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],[6216,[[2,fail]]],
 [6229,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [6231,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [6232,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6234,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6236,[[3,[1]],[5,[2]],[9,[1]],[11,[2]],[15,[1]],[17,[2]],[21,[1]],
     [23,[2]],[27,[1]],[29,[2]]]],
 [6238,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[6239,[[5,fail]]],
 [6240,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6244,[[0,[2]],[3,[2]],[6,[2]],[9,[2]],[12,[2]],[15,[2]],[18,[2]],
     [21,[2]],[24,[2]],[27,[2]]]],
 [6246,[[0,[1,2]],[5,[1]],[9,[1,2]],[12,[1,2]],[17,[1]],[21,[1,2]],
     [24,[1,2]],[29,[1]],[33,[1,2]],[36,[1,2]]]],
 [6247,[[5,[4,8]],[30,[4,8]],[36,[4,8]],[53,[4,8]],[78,[4,8]],[84,[4,8]],
     [101,[4,8]],[126,[4,8]],[132,[4,8]],[149,[4,8]]]],
 [6249,[[5,[1,2]],[9,[2,4]],[17,[1,2]],[21,[2,4]],[29,[1,2]],[33,[2,4]],
     [41,[1,2]],[45,[2,4]],[53,[1,2]],[57,[2,4]]]],
 [6250,[[3,[1,1,1,2]],[6,[1,2]],[11,[1,1,1,2]],[15,[1,1,1,2]],[18,[1,2]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[30,[1,2]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [6254,[[3,[2,4]],[11,[1,2]],[15,[2,4]],[23,[1,2]],[27,[2,4]],[35,[1,2]],
     [39,[2,4]],[47,[1,2]],[51,[2,4]],[59,[1,2]]]],
 [6255,[[0,[2,4]],[11,[2,4]],[18,[2,4]],[24,[2,4]],[35,[2,4]],[42,[2,4]],
     [48,[2,4]],[59,[2,4]],[66,[2,4]],[72,[2,4]]]],
 [6257,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [6258,[[0,[1]],[5,[1]],[6,[1]],[11,[1]],[12,[1]],[17,[1]],[18,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [6263,[[0,[1]],[5,[2]],[8,[1]],[11,[2]],[14,[1]],[17,[2]],[20,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [6264,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [6266,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],
     [18,[1,2]],[23,[1,2]],[24,[1,2]],[29,[1,2]]]],
 [6273,[[0,[1,1,1,2]],[5,[1,1,1,2]],[6,[1,1,1,2]],[11,[1,1,1,2]],
     [12,[1,1,1,2]],[17,[1,1,1,2]],[18,[1,1,1,2]],[23,[1,1,1,2]],
     [24,[1,1,1,2]],[29,[1,1,1,2]]]],
 [6277,[[0,[1,1,1,2]],[5,[1,1,1,2]],[6,[1,1,1,2]],[11,[1,1,1,2]],
     [12,[1,1,1,2]],[17,[1,1,1,2]],[18,[1,1,1,2]],[23,[1,1,1,2]],
     [24,[1,1,1,2]],[29,[1,1,1,2]]]],
 [6285,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6287,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [6291,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6293,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6295,[[2,[1]],[3,[1]],[8,[1]],[9,[1]],[14,[1]],[15,[1]],[20,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [6296,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [6310,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6312,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6314,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],[35,[1,2]],
     [41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [6316,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6317,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6318,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6321,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[6327,[[9,fail]]],[6332,[[3,fail]]],
 [6338,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6339,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6340,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [6341,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6343,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6346,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6348,[[2,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6350,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6352,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6358,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[6370,[[11,fail]]],
 [6372,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],[6374,[[14,fail]]],
 [6376,[[5,fail]]],
 [6377,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [6378,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],[6379,[[8,fail]]],
 [6380,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [6386,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6389,[[2,[4]],[8,[4]],[14,[4]],[20,[4]],[26,[4]],[32,[4]],[38,[4]],
     [44,[4]],[50,[4]],[56,[4]]]],
 [6393,[[2,[1,2]],[5,[1]],[9,[1]],[11,[1,2]],[15,[1,2]],[17,[1]],
     [21,[1]],[23,[1,2]],[27,[1,2]],[29,[1]]]],
 [6397,[[3,[1]],[5,[1,2]],[9,[1,2]],[11,[1]],[15,[1]],[17,[1,2]],
     [21,[1,2]],[23,[1]],[27,[1]],[29,[1,2]]]],[6413,[[11,fail]]],
 [6415,[[14,fail]]],[6417,[[14,fail]]],[6419,[[5,fail]]],[6420,[[5,fail]]],
 [6421,[[11,fail]]],[6422,[[8,fail]]],[6423,[[8,fail]]],
 [6425,[[0,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [6426,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6427,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [6428,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[14,[1]],[17,[1]],[20,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [6429,[[0,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6431,[[0,[2]],[5,[1]],[8,[2]],[11,[1]],[14,[2]],[17,[1]],[20,[2]],
     [23,[1]],[26,[2]],[29,[1]]]],
 [6432,[[0,[3]],[3,[1,2]],[8,[3]],[9,[1,2]],[14,[3]],[15,[1,2]],
     [20,[3]],[21,[1,2]],[26,[3]],[27,[1,2]]]],
 [6436,[[0,[1,2]],[9,[1,2]],[14,[1,2]],[21,[1,2]],[26,[1,2]],[33,[1,2]],
     [38,[1,2]],[45,[1,2]],[50,[1,2]],[57,[1,2]]]],
 [6438,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [6445,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6447,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6448,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6449,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6450,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [6451,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6459,[[9,[2,4]],[33,[2,4]],[57,[2,4]],[81,[2,4]],[105,[2,4]],
     [129,[2,4]],[153,[2,4]],[177,[2,4]],[201,[2,4]],[225,[2,4]]]],
 [6460,[[15,[2,4]],[39,[2,4]],[63,[2,4]],[87,[2,4]],[111,[2,4]],
     [135,[2,4]],[159,[2,4]],[183,[2,4]],[207,[2,4]],[231,[2,4]]]],
 [6464,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6466,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6469,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6471,[[2,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6473,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6475,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6481,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6482,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6499,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6502,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6504,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6506,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6508,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [6514,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6515,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6516,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],[6517,[[2,fail]]],
 [6531,[[2,[1,2]],[3,[1,2]],[8,[1,2]],[9,[1,2]],[14,[1,2]],[15,[1,2]],
     [20,[1,2]],[21,[1,2]],[26,[1,2]],[27,[1,2]]]],
 [6535,[[2,[1,2]],[3,[1]],[8,[1]],[9,[1,2]],[14,[1,2]],[15,[1]],
     [20,[1]],[21,[1,2]],[26,[1,2]],[27,[1]]]],
 [6543,[[2,[1]],[3,[1,2]],[8,[1,2]],[9,[1]],[14,[1]],[15,[1,2]],
     [20,[1,2]],[21,[1]],[26,[1]],[27,[1,2]]]],
 [6544,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [6548,[[0,[1]],[2,[1,2]],[6,[1,2]],[8,[1]],[12,[1]],[14,[1,2]],
     [18,[1,2]],[20,[1]],[24,[1]],[26,[1,2]]]],
 [6556,[[0,[1,2]],[2,[1]],[6,[1]],[8,[1,2]],[12,[1,2]],[14,[1]],
     [18,[1]],[20,[1,2]],[24,[1,2]],[26,[1]]]],
 [6557,[[2,[1,2]],[6,[2,4]],[14,[1,2]],[18,[2,4]],[26,[1,2]],[30,[2,4]],
     [38,[1,2]],[42,[2,4]],[50,[1,2]],[54,[2,4]]]],
 [6560,[[0,[1,1,1,2]],[3,[1,2]],[8,[1,1,1,2]],[12,[1,1,1,2]],[15,[1,2]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[27,[1,2]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [6563,[[0,[2,4]],[8,[1,2]],[12,[2,4]],[20,[1,2]],[24,[2,4]],[32,[1,2]],
     [36,[2,4]],[44,[1,2]],[48,[2,4]],[56,[1,2]]]],
 [6564,[[3,[2,4]],[9,[2,4]],[20,[2,4]],[27,[2,4]],[33,[2,4]],[44,[2,4]],
     [51,[2,4]],[57,[2,4]],[68,[2,4]],[75,[2,4]]]],
 [6565,[[21,[8,16]],[39,[8,16]],[86,[8,16]],[117,[8,16]],[135,[8,16]],
     [182,[8,16]],[213,[8,16]],[231,[8,16]]]],
 [6568,[[2,[1,1,1,2]],[6,[1,2]],[9,[1,1,1,2]],[14,[1,1,1,2]],[18,[1,2]],
     [21,[1,1,1,2]],[26,[1,1,1,2]],[30,[1,2]],[33,[1,1,1,2]],
     [38,[1,1,1,2]]]],[6570,[[6,fail]]],[6574,[[5,fail]]],
 [6575,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [6576,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],[6578,[[8,fail]]],
 [6591,[[14,[4]],[38,[4]],[62,[4]],[86,[4]],[110,[4]],[134,[4]],
     [158,[4]],[182,[4]],[206,[4]],[230,[4]]]],
 [6596,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],[6597,[[0,fail]]],[6609,[[9,fail]]],
 [6611,[[8,fail]]],
 [6612,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [6620,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [6621,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],[6623,[[0,fail]]],[6625,[[9,fail]]],
 [6632,[[8,[4]],[32,[4]],[56,[4]],[80,[4]],[104,[4]],[128,[4]],
     [152,[4]],[176,[4]],[200,[4]],[224,[4]]]],
 [6640,[[0,[1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,2]],[13,[1,1,1,1,1,1,2]],
     [21,[1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,2]],[45,[1,1,1,1,1,1,2]],[49,[1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,2]]]],
 [6642,[[4,[1]],[6,[1,2,2]],[16,[1]],[18,[1,2,2]],[28,[1]],[30,[1,2,2]],
     [40,[1]],[42,[1,2,2]],[52,[1]],[54,[1,2,2]]]],
 [6661,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [6668,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [6669,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [6671,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [6682,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [6684,[[0,[2]],[9,[2]],[12,[2]],[21,[2]],[24,[2]],[33,[2]],[36,[2]],
     [45,[2]],[48,[2]],[57,[2]]]],[6688,[[9,fail]]],[6689,[[6,fail]]],
 [6690,[[6,fail]]],[6695,[[9,fail]]],
 [6703,[[7,[1]],[9,[1,2,2]],[19,[1]],[21,[1,2,2]],[31,[1]],[33,[1,2,2]],
     [43,[1]],[45,[1,2,2]],[55,[1]],[57,[1,2,2]]]],
 [6706,[[0,[1,2,2]],[4,[1]],[12,[1,2,2]],[16,[1]],[24,[1,2,2]],[28,[1]],
     [36,[1,2,2]],[40,[1]],[48,[1,2,2]],[52,[1]]]],
 [6724,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [6728,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],[63,[1,2]],
     [75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [6730,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],[67,[1,2]],
     [79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [6731,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [6732,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [6734,[[3,[1,1,2]],[7,[1,1,2]],[15,[1,1,2]],[19,[1,1,2]],[27,[1,1,2]],
     [31,[1,1,2]],[39,[1,1,2]],[43,[1,1,2]],[51,[1,1,2]],[55,[1,1,2]]]],
 [6737,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [6743,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [6745,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],[63,[1,2]],
     [75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [6747,[[3,[1,1,2]],[4,[1,1,2]],[15,[1,1,2]],[16,[1,1,2]],[27,[1,1,2]],
     [28,[1,1,2]],[39,[1,1,2]],[40,[1,1,2]],[51,[1,1,2]],[52,[1,1,2]]]],
 [6752,[[0,fail]]],[6753,[[0,fail]]],[6755,[[9,fail]]],[6757,[[9,fail]]],
 [6785,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6790,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [6803,[[1,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [6805,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [6806,[[1,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [6808,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [6824,[[3,[1,2,2]],[7,[1]],[15,[1,2,2]],[19,[1]],[27,[1,2,2]],[31,[1]],
     [39,[1,2,2]],[43,[1]],[51,[1,2,2]],[55,[1]]]],
 [6827,[[0,[1,1,1,2]],[4,[1,1,1,2]],[13,[1,1,1,2]],[16,[1,1,1,2]],
     [25,[1,1,1,2]],[28,[1,1,1,2]],[37,[1,1,1,2]],[40,[1,1,1,2]],
     [49,[1,1,1,2]],[52,[1,1,1,2]]]],
 [6831,[[27,[1,2,2]],[87,[1,2,2]],[147,[1,2,2]],[207,[1,2,2]]]],
 [6835,[[13,[4,5]],[43,[4,5]],[73,[4,5]],[103,[4,5]],[133,[4,5]],
     [163,[4,5]],[193,[4,5]],[223,[4,5]],[253,[4,5]]]],
 [6838,[[9,[2,3,3,3]],[25,[2,3,3,3]],[27,[2,3,3,3]],[39,[2,3,3,3]],
     [57,[2,3,3,3]],[69,[2,3,3,3]],[85,[2,3,3,3]],[87,[2,3,3,3]],
     [99,[2,3,3,3]],[117,[2,3,3,3]]]],
 [6840,[[3,[2,3]],[15,[2,3]],[27,[2,3]],[39,[2,3]],[51,[2,3]],[63,[2,3]],
     [75,[2,3]],[87,[2,3]],[99,[2,3]],[111,[2,3]]]],
 [6841,[[3,[1,2,2]],[15,[1,2,2]],[27,[1,2,2]],[39,[1,2,2]],[51,[1,2,2]],
     [63,[1,2,2]],[75,[1,2,2]],[87,[1,2,2]],[99,[1,2,2]],[111,[1,2,2]]]]
  ,
 [6843,[[0,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],[25,[1,2,2]],
     [31,[1,2,2]],[37,[1,2,2]],[43,[1,2,2]],[49,[1,2,2]],[55,[1,2,2]]]],
 [6845,[[0,[1,1,1,2]],[7,[1,1,1,2]],[13,[1,1,1,2]],[19,[1,1,1,2]],
     [25,[1,1,1,2]],[31,[1,1,1,2]],[37,[1,1,1,2]],[43,[1,1,1,2]],
     [49,[1,1,1,2]],[55,[1,1,1,2]]]],
 [6848,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6851,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [6853,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [6854,[[0,[1,2,2]],[4,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[16,[1,2,2]],
     [19,[1,2,2]],[25,[1,2,2]],[28,[1,2,2]],[31,[1,2,2]],[37,[1,2,2]]]],
 [6855,[[0,[2,3]],[4,[2,3]],[7,[2,3]],[13,[2,3]],[16,[2,3]],[19,[2,3]],
     [25,[2,3]],[28,[2,3]],[31,[2,3]],[37,[2,3]]]],[6857,[[7,fail]]],
 [6858,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6860,[[3,[1,1,1,2]],[15,[1,1,1,2]],[27,[1,1,1,2]],[39,[1,1,1,2]],
     [51,[1,1,1,2]],[63,[1,1,1,2]],[75,[1,1,1,2]],[87,[1,1,1,2]],
     [99,[1,1,1,2]],[111,[1,1,1,2]]]],
 [6861,[[0,[2,3]],[7,[2,3]],[13,[2,3]],[19,[2,3]],[25,[2,3]],[31,[2,3]],
     [37,[2,3]],[43,[2,3]],[49,[2,3]],[55,[2,3]]]],
 [6864,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [6865,[[0,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],[25,[1,2,2]],
     [31,[1,2,2]],[37,[1,2,2]],[43,[1,2,2]],[49,[1,2,2]],[55,[1,2,2]]]],
 [6866,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [6867,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[6874,[[0,fail]]],
 [6877,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],[6878,[[7,fail]]],[6880,[[7,fail]]],
 [6881,[[0,fail]]],
 [6882,[[3,[1]],[4,[1]],[9,[1]],[15,[1]],[16,[1]],[21,[1]],[27,[1]],
     [28,[1]],[33,[1]],[39,[1]]]],
 [6883,[[0,[1,2,2]],[4,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[16,[1,2,2]],
     [19,[1,2,2]],[25,[1,2,2]],[28,[1,2,2]],[31,[1,2,2]],[37,[1,2,2]]]],
 [6884,[[0,[1,1,1,2]],[4,[1,1,1,2]],[7,[1,1,1,2]],[13,[1,1,1,2]],
     [16,[1,1,1,2]],[19,[1,1,1,2]],[25,[1,1,1,2]],[28,[1,1,1,2]],
     [31,[1,1,1,2]],[37,[1,1,1,2]]]],
 [6889,[[0,[1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,2]],[12,[1,1,1,1,1,1,2]],
     [22,[1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,2]],[46,[1,1,1,1,1,1,2]],[48,[1,1,1,1,1,1,2]],
     [58,[1,1,1,1,1,1,2]]]],
 [6911,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [6913,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [6917,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [6920,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],[67,[1,2]],
     [79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [6926,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [6930,[[3,[2]],[6,[2]],[15,[2]],[18,[2]],[27,[2]],[30,[2]],[39,[2]],
     [42,[2]],[51,[2]],[54,[2]]]],[6938,[[3,fail]]],[6940,[[3,fail]]],
 [6943,[[0,fail]]],[6944,[[0,fail]]],
 [6965,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [6966,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [6983,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6986,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [6987,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [6988,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [7017,[[9,[1,2,2]],[21,[1,2,2]],[33,[1,2,2]],[45,[1,2,2]],[57,[1,2,2]],
     [69,[1,2,2]],[81,[1,2,2]],[93,[1,2,2]],[105,[1,2,2]],[117,[1,2,2]]] 
  ],
 [7018,[[9,[2,3]],[21,[2,3]],[33,[2,3]],[45,[2,3]],[57,[2,3]],[69,[2,3]],
     [81,[2,3]],[93,[2,3]],[105,[2,3]],[117,[2,3]]]],
 [7020,[[0,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],[25,[1,2,2]],
     [31,[1,2,2]],[37,[1,2,2]],[43,[1,2,2]],[49,[1,2,2]],[55,[1,2,2]]]],
 [7022,[[0,[2,3]],[7,[2,3]],[13,[2,3]],[19,[2,3]],[25,[2,3]],[31,[2,3]],
     [37,[2,3]],[43,[2,3]],[49,[2,3]],[55,[2,3]]]],
 [7024,[[0,[1,1,2,2]],[7,[1,1,2,2]],[13,[1,1,2,2]],[19,[1,1,2,2]],
     [25,[1,1,2,2]],[31,[1,1,2,2]],[37,[1,1,2,2]],[43,[1,1,2,2]],
     [49,[1,1,2,2]],[55,[1,1,2,2]]]],
 [7025,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7028,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [7030,[[9,[1,1,1,2]],[21,[1,1,1,2]],[33,[1,1,1,2]],[45,[1,1,1,2]],
     [57,[1,1,1,2]],[69,[1,1,1,2]],[81,[1,1,1,2]],[93,[1,1,1,2]],
     [105,[1,1,1,2]],[117,[1,1,1,2]]]],
 [7031,[[0,[2,3]],[7,[2,3]],[10,[2,3]],[13,[2,3]],[19,[2,3]],[22,[2,3]],
     [25,[2,3]],[31,[2,3]],[34,[2,3]],[37,[2,3]]]],
 [7032,[[0,[1,2,2]],[7,[1,2,2]],[10,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],
     [22,[1,2,2]],[25,[1,2,2]],[31,[1,2,2]],[34,[1,2,2]],[37,[1,2,2]]]],
 [7034,[[0,fail]]],
 [7035,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7037,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [7038,[[0,[1,1,1,2]],[7,[1,1,1,2]],[13,[1,1,1,2]],[19,[1,1,1,2]],
     [25,[1,1,1,2]],[31,[1,1,1,2]],[37,[1,1,1,2]],[43,[1,1,1,2]],
     [49,[1,1,1,2]],[55,[1,1,1,2]]]],
 [7041,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7042,[[0,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],[25,[1,2,2]],
     [31,[1,2,2]],[37,[1,2,2]],[43,[1,2,2]],[49,[1,2,2]],[55,[1,2,2]]]],
 [7043,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [7044,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7045,[[0,[1,1,1,1,2]],[7,[1,1,1,1,2]],[13,[1,1,1,1,2]],[19,[1,1,1,1,2]],
     [25,[1,1,1,1,2]],[31,[1,1,1,1,2]],[37,[1,1,1,1,2]],[43,[1,1,1,1,2]],
     [49,[1,1,1,1,2]],[55,[1,1,1,1,2]]]],[7051,[[0,fail]]],
 [7052,[[0,[1,1,1,2]],[7,[1,1,1,2]],[10,[1,1,1,2]],[13,[1,1,1,2]],
     [19,[1,1,1,2]],[22,[1,1,1,2]],[25,[1,1,1,2]],[31,[1,1,1,2]],
     [34,[1,1,1,2]],[37,[1,1,1,2]]]],
 [7053,[[0,[1,2,2]],[7,[1,2,2]],[10,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],
     [22,[1,2,2]],[25,[1,2,2]],[31,[1,2,2]],[34,[1,2,2]],[37,[1,2,2]]]],
 [7054,[[3,[1]],[9,[1]],[10,[1]],[15,[1]],[21,[1]],[22,[1]],[27,[1]],
     [33,[1]],[34,[1]],[39,[1]]]],[7055,[[7,fail]]],[7057,[[7,fail]]],
 [7058,[[0,fail]]],
 [7059,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [7062,[[4,[1,1,1,2]],[10,[1,1,1,2]],[16,[1,1,1,2]],[22,[1,1,1,2]],
     [28,[1,1,1,2]],[34,[1,1,1,2]],[40,[1,1,1,2]],[46,[1,1,1,2]],
     [52,[1,1,1,2]],[58,[1,1,1,2]]]],[7108,[[4,fail]]],[7109,[[10,fail]]],
 [7110,[[10,fail]]],[7112,[[0,fail]]],[7114,[[0,fail]]],[7115,[[4,fail]]],
 [7117,[[4,fail]]],[7118,[[4,fail]]],
 [7123,[[30,[1,2,2]],[90,[1,2,2]],[150,[1,2,2]],[210,[1,2,2]]]],
 [7125,[[0,[2,3,3,3]],[18,[2,3,3,3]],[30,[2,3,3,3]],[31,[2,3,3,3]],
     [48,[2,3,3,3]],[60,[2,3,3,3]],[78,[2,3,3,3]],[90,[2,3,3,3]],
     [91,[2,3,3,3]],[108,[2,3,3,3]]]],
 [7128,[[16,[4,5]],[46,[4,5]],[76,[4,5]],[106,[4,5]],[136,[4,5]],
     [166,[4,5]],[196,[4,5]],[226,[4,5]]]],
 [7130,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7131,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7133,[[4,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[22,[1,2,2]],[28,[1,2,2]],
     [34,[1,2,2]],[40,[1,2,2]],[46,[1,2,2]],[52,[1,2,2]],[58,[1,2,2]]]],
 [7135,[[4,[2,3]],[10,[2,3]],[16,[2,3]],[22,[2,3]],[28,[2,3]],[34,[2,3]],
     [40,[2,3]],[46,[2,3]],[52,[2,3]],[58,[2,3]]]],
 [7136,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7137,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [7138,[[6,[1,2,2]],[18,[1,2,2]],[30,[1,2,2]],[42,[1,2,2]],[54,[1,2,2]],
     [66,[1,2,2]],[78,[1,2,2]],[90,[1,2,2]],[102,[1,2,2]],[114,[1,2,2]]] 
  ],
 [7143,[[4,[1,2,2]],[7,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[19,[1,2,2]],
     [22,[1,2,2]],[28,[1,2,2]],[31,[1,2,2]],[34,[1,2,2]],[40,[1,2,2]]]],
 [7144,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [7145,[[6,[1,1,1,2]],[18,[1,1,1,2]],[30,[1,1,1,2]],[42,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[78,[1,1,1,2]],[90,[1,1,1,2]],
     [102,[1,1,1,2]],[114,[1,1,1,2]]]],
 [7148,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],[66,[2,3]],
     [78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [7150,[[4,[2,3]],[7,[2,3]],[10,[2,3]],[16,[2,3]],[19,[2,3]],[22,[2,3]],
     [28,[2,3]],[31,[2,3]],[34,[2,3]],[40,[2,3]]]],
 [7151,[[4,[1,1,1,2]],[10,[1,1,1,2]],[16,[1,1,1,2]],[22,[1,1,1,2]],
     [28,[1,1,1,2]],[34,[1,1,1,2]],[40,[1,1,1,2]],[46,[1,1,1,2]],
     [52,[1,1,1,2]],[58,[1,1,1,2]]]],
 [7155,[[4,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[22,[1,2,2]],[28,[1,2,2]],
     [34,[1,2,2]],[40,[1,2,2]],[46,[1,2,2]],[52,[1,2,2]],[58,[1,2,2]]]],
 [7158,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [7159,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[7160,[[4,fail]]],
 [7163,[[0,[1]],[6,[1]],[7,[1]],[12,[1]],[18,[1]],[19,[1]],[24,[1]],
     [30,[1]],[31,[1]],[36,[1]]]],
 [7164,[[4,[1,2,2]],[6,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[19,[1,2,2]],
     [22,[1,2,2]],[28,[1,2,2]],[31,[1,2,2]],[34,[1,2,2]],[40,[1,2,2]]]],
 [7165,[[4,fail]]],[7166,[[4,fail]]],
 [7169,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [7171,[[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],[16,[1,1,1,2]],
     [19,[1,1,1,2]],[22,[1,1,1,2]],[28,[1,1,1,2]],[31,[1,1,1,2]],
     [34,[1,1,1,2]],[40,[1,1,1,2]]]],[7173,[[10,fail]]],[7174,[[10,fail]]],
 [7185,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7186,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7188,[[4,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[22,[1,2,2]],[28,[1,2,2]],
     [34,[1,2,2]],[40,[1,2,2]],[46,[1,2,2]],[52,[1,2,2]],[58,[1,2,2]]]],
 [7190,[[4,[1,1,1,2]],[10,[1,1,1,2]],[16,[1,1,1,2]],[22,[1,1,1,2]],
     [28,[1,1,1,2]],[34,[1,1,1,2]],[40,[1,1,1,2]],[46,[1,1,1,2]],
     [52,[1,1,1,2]],[58,[1,1,1,2]]]],
 [7191,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7192,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [7193,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],[60,[2,3]],
     [72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [7196,[[4,[1,1,1,1,2]],[10,[1,1,1,1,2]],[16,[1,1,1,1,2]],[22,[1,1,1,1,2]],
     [28,[1,1,1,1,2]],[34,[1,1,1,1,2]],[40,[1,1,1,1,2]],[46,[1,1,1,1,2]],
     [52,[1,1,1,1,2]],[58,[1,1,1,1,2]]]],
 [7198,[[0,[2,3]],[4,[2,3]],[10,[2,3]],[13,[2,3]],[16,[2,3]],[22,[2,3]],
     [25,[2,3]],[28,[2,3]],[34,[2,3]],[37,[2,3]]]],
 [7199,[[0,[1,1,1,2]],[12,[1,1,1,2]],[24,[1,1,1,2]],[36,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[72,[1,1,1,2]],[84,[1,1,1,2]],
     [96,[1,1,1,2]],[108,[1,1,1,2]]]],
 [7200,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [7203,[[0,[1,2,2]],[12,[1,2,2]],[24,[1,2,2]],[36,[1,2,2]],[48,[1,2,2]],
     [60,[1,2,2]],[72,[1,2,2]],[84,[1,2,2]],[96,[1,2,2]],[108,[1,2,2]]]]
  ,
 [7205,[[0,[1,2,2]],[4,[1,2,2]],[10,[1,2,2]],[13,[1,2,2]],[16,[1,2,2]],
     [22,[1,2,2]],[25,[1,2,2]],[28,[1,2,2]],[34,[1,2,2]],[37,[1,2,2]]]],
 [7206,[[4,[2,3]],[10,[2,3]],[16,[2,3]],[22,[2,3]],[28,[2,3]],[34,[2,3]],
     [40,[2,3]],[46,[2,3]],[52,[2,3]],[58,[2,3]]]],
 [7210,[[4,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[22,[1,2,2]],[28,[1,2,2]],
     [34,[1,2,2]],[40,[1,2,2]],[46,[1,2,2]],[52,[1,2,2]],[58,[1,2,2]]]],
 [7211,[[4,[1,1,2,2]],[10,[1,1,2,2]],[16,[1,1,2,2]],[22,[1,1,2,2]],
     [28,[1,1,2,2]],[34,[1,1,2,2]],[40,[1,1,2,2]],[46,[1,1,2,2]],
     [52,[1,1,2,2]],[58,[1,1,2,2]]]],
 [7213,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [7214,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[7215,[[10,fail]]],
 [7218,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],[7220,[[4,fail]]],[7221,[[4,fail]]],
 [7223,[[0,[1,1,1,2]],[4,[1,1,1,2]],[10,[1,1,1,2]],[13,[1,1,1,2]],
     [16,[1,1,1,2]],[22,[1,1,1,2]],[25,[1,1,1,2]],[28,[1,1,1,2]],
     [34,[1,1,1,2]],[37,[1,1,1,2]]]],
 [7224,[[0,[1]],[1,[1]],[6,[1]],[12,[1]],[13,[1]],[18,[1]],[24,[1]],
     [25,[1]],[30,[1]],[36,[1]]]],
 [7225,[[0,[1,2,2]],[4,[1,2,2]],[10,[1,2,2]],[13,[1,2,2]],[16,[1,2,2]],
     [22,[1,2,2]],[25,[1,2,2]],[28,[1,2,2]],[34,[1,2,2]],[37,[1,2,2]]]],
 [7228,[[10,fail]]],[7229,[[10,fail]]],
 [7246,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [7253,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [7254,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [7255,[[3,[4,5,5,5,5]],[7,[2,2,2,3,3]],[15,[4,4,4,6,6]],[25,[2,2,2,3,3]],
     [27,[4,5,5,5,5]],[33,[4,5,5,5,5]],[37,[2,2,2,3,3]],[45,[4,4,4,6,6]],
     [55,[2,2,2,3,3]],[57,[4,5,5,5,5]]]],
 [7256,[[6,[2]],[18,[2]],[36,[2]],[48,[2]],[66,[2]],[78,[2]],[96,[2]],
     [108,[2]],[126,[2]],[138,[2]]]],
 [7261,[[3,[4,4,5,6,5]],[7,[2,2,2,3,3]],[15,[4,5,5,5,5]],[25,[2,2,2,3,3]],
     [27,[4,4,5,6,5]],[33,[4,4,5,6,5]],[37,[2,2,2,3,3]],[45,[4,5,5,5,5]],
     [55,[2,2,2,3,3]],[57,[4,4,5,6,5]]]],
 [7267,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [7269,[[3,[2]],[21,[2]],[33,[2]],[51,[2]],[63,[2]],[81,[2]],[93,[2]],
     [111,[2]],[123,[2]],[141,[2]]]],
 [7270,[[0,[2,2,3,3]],[12,[2,2,3,3]],[16,[1,1,2,2]],[18,[1]],
     [22,[2,2,3,3]],[30,[2,2,3,3]],[42,[2,2,3,3]],[46,[1,1,2,2]],
     [48,[1]],[52,[2,2,3,3]]]],
 [7271,[[0,[3,4]],[12,[3,4]],[16,[2]],[18,[1,2]],[22,[3,4]],[30,[3,4]],
     [42,[3,4]],[46,[2]],[48,[1,2]],[52,[3,4]]]],
 [7299,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [7306,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [7307,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [7309,[[9,[2,3,3]],[19,[2,3,3]],[39,[2,3,3]],[49,[2,3,3]],[69,[2,3,3]],
     [79,[2,3,3]],[99,[2,3,3]],[109,[2,3,3]],[129,[2,3,3]],[139,[2,3,3]] 
    ]],
 [7320,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [7322,[[4,[2,3,3]],[24,[2,3,3]],[34,[2,3,3]],[54,[2,3,3]],[64,[2,3,3]],
     [84,[2,3,3]],[94,[2,3,3]],[114,[2,3,3]],[124,[2,3,3]],[144,[2,3,3]] 
    ]],
 [7323,[[4,[3,4]],[6,[1,2]],[10,[2]],[12,[3,4]],[24,[3,4]],[34,[3,4]],
     [36,[1,2]],[40,[2]],[42,[3,4]],[54,[3,4]]]],
 [7324,[[4,[2,2,3,3]],[6,[1]],[10,[1,1,2,2]],[12,[2,2,3,3]],
     [24,[2,2,3,3]],[34,[2,2,3,3]],[36,[1]],[40,[1,1,2,2]],
     [42,[2,2,3,3]],[54,[2,2,3,3]]]],
 [7350,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [18,[1,1,1,1,2,1,1,2]],[22,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[48,[1,1,1,1,2,1,1,2]],
     [52,[1,1,1,1,2,1,1,2]]]],
 [7351,[[7,[1]],[15,[1,2]],[37,[1]],[45,[1,2]],[67,[1]],[75,[1,2]],
     [97,[1]],[105,[1,2]],[127,[1]],[135,[1,2]]]],
 [7358,[[0,[1,1,1,1,2]],[22,[1,1,1,1,2]],[30,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[82,[1,1,1,1,2]],[90,[1,1,1,1,2]],[112,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [7359,[[0,[1,1,1,1,2]],[22,[1,1,1,1,2]],[30,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[82,[1,1,1,1,2]],[90,[1,1,1,1,2]],[112,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [7368,[[3,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [7371,[[3,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [7372,[[7,[1,2]],[15,[1]],[37,[1,2]],[45,[1]],[67,[1,2]],[75,[1]],
     [97,[1,2]],[105,[1]],[127,[1,2]],[135,[1]]]],
 [7373,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [18,[1,1,1,1,2,1,1,2]],[22,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[48,[1,1,1,1,2,1,1,2]],
     [52,[1,1,1,1,2,1,1,2]]]],
 [7406,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [7408,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [7411,[[3,[3,4]],[15,[3,4]],[19,[2]],[21,[1,2]],[25,[3,4]],[33,[3,4]],
     [45,[3,4]],[49,[2]],[51,[1,2]],[55,[3,4]]]],
 [7412,[[3,[2,3,3]],[25,[2,3,3]],[33,[2,3,3]],[55,[2,3,3]],[63,[2,3,3]],
     [85,[2,3,3]],[93,[2,3,3]],[115,[2,3,3]],[123,[2,3,3]],[145,[2,3,3]] 
    ]],
 [7415,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [7417,[[3,[2,2,3,3]],[15,[2,2,3,3]],[19,[1,1,2,2]],[21,[1]],
     [25,[2,2,3,3]],[33,[2,2,3,3]],[45,[2,2,3,3]],[49,[1,1,2,2]],
     [51,[1]],[55,[2,2,3,3]]]],
 [7421,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [7425,[[10,[2,3,3]],[18,[2,3,3]],[40,[2,3,3]],[48,[2,3,3]],[70,[2,3,3]],
     [78,[2,3,3]],[100,[2,3,3]],[108,[2,3,3]],[130,[2,3,3]],[138,[2,3,3]] 
    ]],
 [7451,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [16,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[46,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [7458,[[9,[1,2]],[39,[1,2]],[69,[1,2]],[99,[1,2]],[129,[1,2]],
     [159,[1,2]],[189,[1,2]],[219,[1,2]],[249,[1,2]]]],
 [7459,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [7460,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [7465,[[9,[1]],[39,[1]],[69,[1]],[99,[1]],[129,[1]],[159,[1]],
     [189,[1]],[219,[1]],[249,[1]]]],
 [7469,[[1,[1,1,1,1,1,1,2,2]],[9,[1,1,1,1,1,1,2,2]],[15,[1]],
     [21,[1,1,1,1,1,1,2,2]],[27,[1,1,1,1,1,1,2,2]],[31,[1,1,1,1,1,1,2,2]],
     [39,[1,1,1,1,1,1,2,2]],[45,[1]],[51,[1,1,1,1,1,1,2,2]],
     [57,[1,1,1,1,1,1,2,2]]]],
 [7472,[[1,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [7474,[[0,[1,1,1,1,1,1,2,2]],[6,[1,1,1,1,1,1,2,2]],[12,[1]],
     [16,[1,1,1,1,1,1,2,2]],[24,[1,1,1,1,1,1,2,2]],[30,[1,1,1,1,1,1,2,2]],
     [36,[1,1,1,1,1,1,2,2]],[42,[1]],[46,[1,1,1,1,1,1,2,2]],
     [54,[1,1,1,1,1,1,2,2]]]],
 [7511,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [7524,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [7553,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [7555,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [7558,[[7,[2,2,3,3]],[9,[1]],[13,[1,1,2,2]],[15,[2,2,3,3]],
     [27,[2,2,3,3]],[37,[2,2,3,3]],[39,[1]],[43,[1,1,2,2]],
     [45,[2,2,3,3]],[57,[2,2,3,3]]]],
 [7559,[[3,[2]],[24,[2]],[33,[2]],[54,[2]],[63,[2]],[84,[2]],[93,[2]],
     [114,[2]],[123,[2]],[144,[2]]]],
 [7562,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [7564,[[7,[3,4]],[9,[1,2]],[13,[2]],[15,[3,4]],[27,[3,4]],[37,[3,4]],
     [39,[1,2]],[43,[2]],[45,[3,4]],[57,[3,4]]]],
 [7568,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [7572,[[9,[2]],[18,[2]],[39,[2]],[48,[2]],[69,[2]],[78,[2]],[99,[2]],
     [108,[2]],[129,[2]],[138,[2]]]],
 [7573,[[0,[4,4,5,6,5]],[4,[2,2,2,3,3]],[12,[4,5,5,5,5]],[22,[2,2,2,3,3]],
     [24,[4,4,5,6,5]],[30,[4,4,5,6,5]],[34,[2,2,2,3,3]],[42,[4,5,5,5,5]],
     [52,[2,2,2,3,3]],[54,[4,4,5,6,5]]]],
 [7574,[[0,[4,5,5,5,5]],[4,[2,2,2,3,3]],[12,[4,4,4,6,6]],[22,[2,2,2,3,3]],
     [24,[4,5,5,5,5]],[30,[4,5,5,5,5]],[34,[2,2,2,3,3]],[42,[4,4,4,6,6]],
     [52,[2,2,2,3,3]],[54,[4,5,5,5,5]]]],
 [7595,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[10,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[40,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [7600,[[10,[1]],[18,[1,2]],[40,[1]],[48,[1,2]],[70,[1]],[78,[1,2]],
     [100,[1]],[108,[1,2]],[130,[1]],[138,[1,2]]]],
 [7602,[[3,[1,1,1,1,2]],[25,[1,1,1,1,2]],[33,[1,1,1,1,2]],[55,[1,1,1,1,2]],
     [63,[1,1,1,1,2]],[85,[1,1,1,1,2]],[93,[1,1,1,1,2]],[115,[1,1,1,1,2]],
     [123,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [7609,[[3,[1,1,1,1,2]],[25,[1,1,1,1,2]],[33,[1,1,1,1,2]],[55,[1,1,1,1,2]],
     [63,[1,1,1,1,2]],[85,[1,1,1,1,2]],[93,[1,1,1,1,2]],[115,[1,1,1,1,2]],
     [123,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [7613,[[3,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [7615,[[10,[1,2]],[18,[1]],[40,[1,2]],[48,[1]],[70,[1,2]],[78,[1]],
     [100,[1,2]],[108,[1]],[130,[1,2]],[138,[1]]]],
 [7616,[[3,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [7618,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[10,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[40,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [7652,[[0,[1]],[15,[1]],[30,[1]],[45,[1]],[60,[1]],[75,[1]],[90,[1]],
     [105,[1]],[120,[1]],[135,[1]]]],
 [7665,[[0,[1]],[15,[1]],[30,[1]],[45,[1]],[60,[1]],[75,[1]],[90,[1]],
     [105,[1]],[120,[1]],[135,[1]]]],
 [7687,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [7691,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [7706,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [7708,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [7730,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7731,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7738,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [7739,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [7748,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7751,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7752,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7753,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7755,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [7756,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],[7757,[[7,fail]]],[7763,[[1,fail]]],
 [7773,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7774,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7781,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [7782,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [7791,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7794,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7795,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7796,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7798,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [7799,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[7800,[[7,fail]]],[7806,[[1,fail]]],
 [7815,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7833,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7836,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7838,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[7884,[[6,fail]]],[7885,[[10,fail]]],
 [7886,[[10,fail]]],[7888,[[0,fail]]],[7890,[[0,fail]]],[7891,[[6,fail]]],
 [7893,[[4,fail]]],[7894,[[4,fail]]],
 [7896,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7897,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7903,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [7910,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [7914,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7917,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [7918,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [7919,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[7963,[[6,fail]]],[7964,[[10,fail]]],
 [7965,[[10,fail]]],[7967,[[0,fail]]],[7969,[[0,fail]]],[7970,[[6,fail]]],
 [7972,[[4,fail]]],[7973,[[4,fail]]],
 [7974,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7975,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7976,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7977,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7978,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7979,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7980,[[0,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [7981,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7982,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7984,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [7985,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7986,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7987,[[0,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [7990,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [7993,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7995,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [7996,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [7997,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8000,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8004,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8006,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8009,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8017,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [8018,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [8019,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],[8021,[[7,fail]]],
 [8024,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [8027,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8028,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8031,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8033,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8035,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [8036,[[0,[4,5]],[6,[4,5]],[12,[4,5]],[18,[4,5]],[24,[4,5]],[30,[4,5]],
     [36,[4,5]],[42,[4,5]],[48,[4,5]],[54,[4,5]]]],
 [8039,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8040,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8051,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8053,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [8056,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [8060,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8062,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8064,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8066,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8067,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8069,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[8077,[[10,fail]]],[8082,[[4,fail]]],
 [8086,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8089,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [8090,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8099,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [8101,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8102,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [8104,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8126,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8133,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8136,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8138,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8139,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [8154,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8155,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [8156,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [8157,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [8158,[[3,[4,5]],[9,[4,5]],[15,[4,5]],[21,[4,5]],[27,[4,5]],[33,[4,5]],
     [39,[4,5]],[45,[4,5]],[51,[4,5]],[57,[4,5]]]],
 [8160,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8162,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [8164,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [8166,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8169,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8171,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[8172,[[4,fail]]],
 [8180,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8182,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8188,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8189,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [8198,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [8200,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8201,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [8203,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8223,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8228,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [8229,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8231,[[3,[1]],[4,[1]],[9,[1]],[10,[1]],[15,[1]],[16,[1]],[21,[1]],
     [22,[1]],[27,[1]],[28,[1]]]],
 [8232,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8233,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [8234,[[0,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8242,[[4,[1,2]],[10,[2,4]],[16,[1,2]],[22,[2,4]],[28,[1,2]],[34,[2,4]],
     [40,[1,2]],[46,[2,4]],[52,[1,2]],[58,[2,4]]]],
 [8247,[[4,[2]],[10,[1]],[16,[2]],[22,[1]],[28,[2]],[34,[1]],[40,[2]],
     [46,[1]],[52,[2]],[58,[1]]]],
 [8259,[[1,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8261,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [8262,[[1,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8263,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[19,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [8264,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8268,[[1,[1]],[7,[2]],[13,[1]],[19,[2]],[25,[1]],[31,[2]],[37,[1]],
     [43,[2]],[49,[1]],[55,[2]]]],
 [8274,[[1,[2,4]],[7,[1,2]],[13,[2,4]],[19,[1,2]],[25,[2,4]],[31,[1,2]],
     [37,[2,4]],[43,[1,2]],[49,[2,4]],[55,[1,2]]]],
 [8288,[[1,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8290,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [8291,[[1,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8292,[[0,[1]],[1,[1]],[6,[1]],[7,[1]],[12,[1]],[13,[1]],[18,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [8293,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8297,[[1,[1,2]],[7,[2,4]],[13,[1,2]],[19,[2,4]],[25,[1,2]],[31,[2,4]],
     [37,[1,2]],[43,[2,4]],[49,[1,2]],[55,[2,4]]]],
 [8303,[[1,[2]],[7,[1]],[13,[2]],[19,[1]],[25,[2]],[31,[1]],[37,[2]],
     [43,[1]],[49,[2]],[55,[1]]]],
 [8310,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8318,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],[8329,[[3,fail]]],[8334,[[3,fail]]],
 [8343,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8346,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],[8347,[[7,fail]]],
 [8348,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [8349,[[0,[2]],[3,[2]],[6,[2]],[9,[2]],[12,[2]],[15,[2]],[18,[2]],
     [21,[2]],[24,[2]],[27,[2]]]],[8354,[[0,fail]]],[8355,[[0,fail]]],
 [8362,[[0,fail]]],[8363,[[0,fail]]],
 [8365,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [8367,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [8369,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8371,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8372,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8374,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[8382,[[10,fail]]],[8387,[[4,fail]]],
 [8394,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8397,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8399,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8417,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [8418,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8420,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],
     [21,[1,2]],[22,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [8421,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8422,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [8423,[[0,[1]],[4,[1]],[7,[1]],[10,[1]],[13,[1]],[16,[1]],[19,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [8431,[[4,[1]],[10,[2]],[16,[1]],[22,[2]],[28,[1]],[34,[2]],[40,[1]],
     [46,[2]],[52,[1]],[58,[2]]]],
 [8436,[[4,[2,4]],[10,[1,2]],[16,[2,4]],[22,[1,2]],[28,[2,4]],[34,[1,2]],
     [40,[2,4]],[46,[1,2]],[52,[2,4]],[58,[1,2]]]],[8451,[[6,fail]]],
 [8452,[[10,fail]]],[8453,[[10,fail]]],[8455,[[0,fail]]],[8457,[[0,fail]]],
 [8458,[[6,fail]]],[8460,[[4,fail]]],[8461,[[4,fail]]],
 [8465,[[3,[4,5]],[9,[4,5]],[15,[4,5]],[21,[4,5]],[27,[4,5]],[33,[4,5]],
     [39,[4,5]],[45,[4,5]],[51,[4,5]],[57,[4,5]]]],[8476,[[3,fail]]],
 [8481,[[3,fail]]],
 [8484,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8487,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8488,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8489,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8506,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8507,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8508,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8510,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8513,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8517,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8519,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8522,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[8533,[[6,fail]]],
 [8534,[[10,fail]]],[8535,[[10,fail]]],[8537,[[0,fail]]],[8539,[[0,fail]]],
 [8540,[[6,fail]]],[8542,[[4,fail]]],[8543,[[4,fail]]],
 [8544,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8546,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[8547,[[4,fail]]],
 [8555,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8557,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8562,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8564,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [8567,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8571,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8573,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [8576,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [8579,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8581,[[0,[4,5]],[6,[4,5]],[12,[4,5]],[18,[4,5]],[24,[4,5]],[30,[4,5]],
     [36,[4,5]],[42,[4,5]],[48,[4,5]],[54,[4,5]]]],
 [8582,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [8585,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8586,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8595,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8598,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8602,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8604,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [8607,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[8613,[[0,fail]]],[8617,[[3,fail]]],
 [8619,[[3,fail]]],[8620,[[0,fail]]],[8625,[[0,fail]]],[8631,[[0,fail]]],
 [8637,[[0,fail]]],[8643,[[0,fail]]],[8660,[[6,fail]]],[8661,[[6,fail]]],
 [8668,[[4,fail]]],[8669,[[4,fail]]],[8672,[[0,fail]]],[8674,[[0,fail]]],
 [8675,[[6,fail]]],[8680,[[0,fail]]],[8682,[[0,fail]]],[8683,[[6,fail]]],
 [8698,[[0,fail]]],[8699,[[0,fail]]],[8707,[[0,fail]]],[8708,[[0,fail]]],
 [8710,[[4,fail]]],[8711,[[4,fail]]],
 [8721,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [8722,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [8739,[[5,[1]],[8,[1,2]],[17,[1]],[20,[1,2]],[29,[1]],[32,[1,2]],
     [41,[1]],[44,[1,2]],[53,[1]],[56,[1,2]]]],
 [8740,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [8744,[[8,[1,2]],[9,[1]],[20,[1,2]],[21,[1]],[32,[1,2]],[33,[1]],
     [44,[1,2]],[45,[1]],[56,[1,2]],[57,[1]]]],
 [8746,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [8747,[[4,[1,2]],[5,[1]],[16,[1,2]],[17,[1]],[28,[1,2]],[29,[1]],
     [40,[1,2]],[41,[1]],[52,[1,2]],[53,[1]]]],
 [8748,[[1,[1]],[4,[1,2]],[13,[1]],[16,[1,2]],[25,[1]],[28,[1,2]],
     [37,[1]],[40,[1,2]],[49,[1]],[52,[1,2]]]],
 [8749,[[5,[2]],[9,[2]],[17,[2]],[21,[2]],[29,[2]],[33,[2]],[41,[2]],
     [45,[2]],[53,[2]],[57,[2]]]],
 [8750,[[1,[2]],[5,[2]],[13,[2]],[17,[2]],[25,[2]],[29,[2]],[37,[2]],
     [41,[2]],[49,[2]],[53,[2]]]],
 [8755,[[0,[2]],[9,[2]],[13,[2]],[21,[2]],[25,[2]],[33,[2]],[37,[2]],
     [45,[2]],[49,[2]],[57,[2]]]],
 [8757,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [8759,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [8761,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],[61,[1,2]],
     [73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [8762,[[0,[1,2]],[1,[1]],[12,[1,2]],[13,[1]],[24,[1,2]],[25,[1]],
     [36,[1,2]],[37,[1]],[48,[1,2]],[49,[1]]]],
 [8763,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[9,[1,2]],[12,[1,2]],[16,[1,2]],
     [20,[1,2]],[21,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [8764,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [17,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [8765,[[0,[1,2]],[1,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[13,[1,2]],
     [16,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [8768,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [8769,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],[61,[1,2]],
     [73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [8770,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [8783,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [8784,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [8801,[[5,[1,2]],[8,[1,2]],[17,[1,2]],[20,[1,2]],[29,[1,2]],[32,[1,2]],
     [41,[1,2]],[44,[1,2]],[53,[1,2]],[56,[1,2]]]],
 [8802,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],[65,[1,2]],
     [77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [8806,[[8,[1]],[9,[1,2]],[20,[1]],[21,[1,2]],[32,[1]],[33,[1,2]],
     [44,[1]],[45,[1,2]],[56,[1]],[57,[1,2]]]],
 [8808,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [8809,[[4,[1]],[5,[1,2]],[16,[1]],[17,[1,2]],[28,[1]],[29,[1,2]],
     [40,[1]],[41,[1,2]],[52,[1]],[53,[1,2]]]],
 [8810,[[1,[1,2]],[4,[1,2]],[13,[1,2]],[16,[1,2]],[25,[1,2]],[28,[1,2]],
     [37,[1,2]],[40,[1,2]],[49,[1,2]],[52,[1,2]]]],
 [8811,[[5,[1,1,2]],[9,[1,1,2]],[17,[1,1,2]],[21,[1,1,2]],[29,[1,1,2]],
     [33,[1,1,2]],[41,[1,1,2]],[45,[1,1,2]],[53,[1,1,2]],[57,[1,1,2]]]],
 [8812,[[1,[2]],[5,[2]],[13,[2]],[17,[2]],[25,[2]],[29,[2]],[37,[2]],
     [41,[2]],[49,[2]],[53,[2]]]],
 [8817,[[0,[2]],[9,[2]],[13,[2]],[21,[2]],[25,[2]],[33,[2]],[37,[2]],
     [45,[2]],[49,[2]],[57,[2]]]],
 [8819,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [8821,[[0,[1,1,2,2]],[9,[1,1,2,2]],[12,[1,1,2,2]],[21,[1,1,2,2]],
     [24,[1,1,2,2]],[33,[1,1,2,2]],[36,[1,1,2,2]],[45,[1,1,2,2]],
     [48,[1,1,2,2]],[57,[1,1,2,2]]]],
 [8823,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [8824,[[0,[1]],[1,[1,2]],[12,[1]],[13,[1,2]],[24,[1]],[25,[1,2]],
     [36,[1]],[37,[1,2]],[48,[1]],[49,[1,2]]]],
 [8825,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[9,[1,2]],[12,[1,2]],[16,[1,2]],
     [20,[1,2]],[21,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [8826,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[12,[1]],[16,[1]],[17,[1]],
     [20,[1]],[24,[1]],[28,[1]]]],
 [8827,[[0,[1,2]],[1,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[13,[1,2]],
     [16,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],[8830,[[5,fail]]],
 [8831,[[1,fail]]],[8832,[[9,fail]]],
 [8840,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [8841,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [8842,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [8843,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [8845,[[0,[2]],[4,[2]],[8,[2]],[12,[2]],[16,[2]],[20,[2]],[24,[2]],
     [28,[2]],[32,[2]],[36,[2]]]],
 [8856,[[1,[1]],[4,[1]],[9,[1]],[13,[1]],[16,[1]],[21,[1]],[25,[1]],
     [28,[1]],[33,[1]],[37,[1]]]],
 [8859,[[1,[1]],[5,[1]],[8,[1]],[13,[1]],[17,[1]],[20,[1]],[25,[1]],
     [29,[1]],[32,[1]],[37,[1]]]],
 [8860,[[1,[1,1,1,2]],[5,[1,2]],[9,[1,1,1,2]],[13,[1,1,1,2]],[17,[1,2]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[29,[1,2]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [8863,[[1,[1,1,1,2]],[5,[1]],[9,[1,1,1,2]],[13,[1,1,1,2]],[17,[1]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[29,[1]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [8869,[[1,[1]],[5,[1,2]],[9,[1]],[13,[1]],[17,[1,2]],[21,[1]],
     [25,[1]],[29,[1,2]],[33,[1]],[37,[1]]]],
 [8874,[[0,[1]],[5,[1]],[9,[1]],[12,[1]],[17,[1]],[21,[1]],[24,[1]],
     [29,[1]],[33,[1]],[36,[1]]]],
 [8875,[[0,[1,2]],[5,[1]],[9,[1,2]],[13,[1,2]],[17,[1]],[21,[1,2]],
     [25,[1,2]],[29,[1]],[33,[1,2]],[37,[1,2]]]],
 [8883,[[0,[1,2,2]],[5,[1]],[9,[1,2,2]],[12,[1,2,2]],[17,[1]],
     [21,[1,2,2]],[24,[1,2,2]],[29,[1]],[33,[1,2,2]],[36,[1,2,2]]]],
 [8898,[[0,[1,1,1,2]],[5,[1]],[8,[1,1,1,2]],[9,[1,1,1,2]],[16,[1,1,1,2]],
     [17,[1]],[21,[1,1,1,2]],[24,[1,1,1,2]],[29,[1]],[32,[1,1,1,2]]]],
 [8899,[[0,[1,1,1,2]],[4,[1,1,1,2]],[5,[1]],[12,[1,1,1,2]],
     [13,[1,1,1,2]],[17,[1]],[20,[1,1,1,2]],[25,[1,1,1,2]],
     [28,[1,1,1,2]],[29,[1]]]],
 [8900,[[0,[1,2]],[1,[1]],[8,[1,2]],[9,[1]],[13,[1]],[16,[1,2]],
     [21,[1]],[24,[1,2]],[25,[1]],[32,[1,2]]]],
 [8902,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [8904,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [8905,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [8922,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8923,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [8931,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8932,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [8933,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [8936,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [8938,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [8942,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [8943,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [8946,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [8947,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [8948,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [8961,[[0,[1]],[5,[1]],[9,[1]],[13,[1]],[17,[1]],[21,[1]],[25,[1]],
     [29,[1]],[33,[1]],[37,[1]]]],
 [8981,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [8982,[[5,[3]],[17,[3]],[29,[3]],[41,[3]],[53,[3]],[65,[3]],[77,[3]],
     [89,[3]],[101,[3]],[113,[3]]]],
 [8988,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [8990,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [8991,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[13,[1]],[16,[1]],[17,[1]],
     [21,[1]],[25,[1]],[28,[1]]]],
 [8992,[[0,[1,2]],[1,[1,2]],[5,[1,2]],[9,[1,2]],[12,[1,2]],[13,[1,2]],
     [17,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [8995,[[8,[3]],[20,[3]],[32,[3]],[44,[3]],[56,[3]],[68,[3]],[80,[3]],
     [92,[3]],[104,[3]],[116,[3]]]],
 [8997,[[0,[1,2]],[5,[1,2]],[8,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],
     [20,[1,2]],[21,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [8999,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9002,[[4,[3]],[16,[3]],[28,[3]],[40,[3]],[52,[3]],[64,[3]],[76,[3]],
     [88,[3]],[100,[3]],[112,[3]]]],
 [9003,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [9005,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [9006,[[4,[1,1,2]],[8,[1,1,2]],[16,[1,1,2]],[20,[1,1,2]],[28,[1,1,2]],
     [32,[1,1,2]],[40,[1,1,2]],[44,[1,1,2]],[52,[1,1,2]],[56,[1,1,2]]]],
 [9007,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],[9008,[[0,fail]]],[9009,[[4,fail]]],
 [9016,[[8,fail]]],
 [9020,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [9021,[[2,[2]],[6,[2]],[10,[2]],[14,[2]],[18,[2]],[22,[2]],[26,[2]],
     [30,[2]],[34,[2]],[38,[2]]]],
 [9023,[[13,[1,2]],[33,[1,2]],[53,[1,2]],[73,[1,2]],[93,[1,2]],
     [113,[1,2]],[133,[1,2]],[153,[1,2]],[173,[1,2]],[193,[1,2]]]],
 [9025,[[13,[1]],[33,[1]],[53,[1]],[73,[1]],[93,[1]],[113,[1]],
     [133,[1]],[153,[1]],[173,[1]],[193,[1]]]],
 [9027,[[9,[1]],[29,[1]],[49,[1]],[69,[1]],[89,[1]],[109,[1]],[129,[1]],
     [149,[1]],[169,[1]],[189,[1]]]],
 [9028,[[6,[1,2]],[26,[1,2]],[46,[1,2]],[66,[1,2]],[86,[1,2]],
     [106,[1,2]],[126,[1,2]],[146,[1,2]],[166,[1,2]],[186,[1,2]]]],
 [9029,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [9031,[[14,[1]],[34,[1]],[54,[1]],[74,[1]],[94,[1]],[114,[1]],
     [134,[1]],[154,[1]],[174,[1]],[194,[1]]]],
 [9034,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],[69,[1,2]],
     [81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [9037,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [9038,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [9039,[[5,[1,2]],[10,[1,2]],[17,[1,2]],[22,[1,2]],[29,[1,2]],[34,[1,2]],
     [41,[1,2]],[46,[1,2]],[53,[1,2]],[58,[1,2]]]],
 [9040,[[5,[2,3]],[17,[2,3]],[29,[2,3]],[41,[2,3]],[53,[2,3]],[65,[2,3]],
     [77,[2,3]],[89,[2,3]],[101,[2,3]],[113,[2,3]]]],
 [9047,[[0,[1]],[6,[1]],[10,[1]],[13,[1]],[18,[1]],[22,[1]],[25,[1]],
     [30,[1]],[34,[1]],[37,[1]]]],
 [9048,[[2,[1,2]],[9,[1,2]],[14,[1,2]],[21,[1,2]],[26,[1,2]],[33,[1,2]],
     [38,[1,2]],[45,[1,2]],[50,[1,2]],[57,[1,2]]]],[9049,[[0,fail]]],
 [9050,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[13,[1,2]],[17,[1,2]],[18,[1,2]],
     [25,[1,2]],[29,[1,2]],[30,[1,2]],[37,[1,2]]]],
 [9051,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [9059,[[2,[2]],[9,[2]],[14,[2]],[21,[2]],[26,[2]],[33,[2]],[38,[2]],
     [45,[2]],[50,[2]],[57,[2]]]],
 [9075,[[2,[1,2]],[5,[1]],[9,[1]],[10,[1,2]],[14,[1,2]],[17,[1]],
     [21,[1]],[22,[1,2]],[26,[1,2]],[29,[1]]]],
 [9076,[[0,[1,1,1,2]],[5,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [13,[1,1,1,2]],[17,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [25,[1,1,1,2]],[29,[1,1,1,2]]]],
 [9077,[[0,[1]],[2,[1,2]],[6,[1,2]],[9,[1]],[13,[1]],[14,[1,2]],
     [18,[1,2]],[21,[1]],[25,[1]],[26,[1,2]]]],
 [9096,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9097,[[5,[3]],[17,[3]],[29,[3]],[41,[3]],[53,[3]],[65,[3]],[77,[3]],
     [89,[3]],[101,[3]],[113,[3]]]],
 [9103,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [9105,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [9106,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[16,[1,2]],
     [17,[1,2]],[21,[1,2]],[25,[1,2]],[28,[1,2]]]],
 [9107,[[0,[1,2]],[1,[1,2]],[5,[1,2]],[9,[1,2]],[12,[1,2]],[13,[1,2]],
     [17,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [9110,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [9112,[[0,[1,2]],[5,[1,2]],[8,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],
     [20,[1,2]],[21,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [9114,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [9117,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [9118,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [9120,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [9121,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [9122,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [9123,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],[60,[1,2]],
     [72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [9124,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [9131,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9135,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [9137,[[6,[1,2]],[26,[1,2]],[46,[1,2]],[66,[1,2]],[86,[1,2]],
     [106,[1,2]],[126,[1,2]],[146,[1,2]],[166,[1,2]],[186,[1,2]]]],
 [9138,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],[128,[1]],
     [148,[1]],[168,[1]],[188,[1]]]],
 [9142,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [9147,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [9148,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [9151,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9152,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],[68,[2,3]],
     [80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [9153,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [9157,[[0,[1]],[10,[1]],[12,[1]],[22,[1]],[24,[1]],[34,[1]],[36,[1]],
     [46,[1]],[48,[1]],[58,[1]]]],
 [9161,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [9164,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [9166,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [9174,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[12,[1,2]],[14,[1,2]],[18,[1,2]],
     [24,[1,2]],[26,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [9175,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],[9177,[[0,fail]]],
 [9178,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[12,[1,2]],[16,[1,2]],[18,[1,2]],
     [24,[1,2]],[28,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [9184,[[0,[1,1,1,2]],[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [9185,[[0,[1]],[2,[1,2]],[6,[1,2]],[8,[1]],[12,[1]],[14,[1,2]],
     [18,[1,2]],[20,[1]],[24,[1]],[26,[1,2]]]],
 [9186,[[2,[1,2]],[4,[1]],[8,[1]],[10,[1,2]],[14,[1,2]],[16,[1]],
     [20,[1]],[22,[1,2]],[26,[1,2]],[28,[1]]]],
 [9201,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [9203,[[0,[1,1,1,2]],[4,[1,2]],[8,[1,1,1,2]],[12,[1,1,1,2]],[16,[1,2]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[28,[1,2]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [9204,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [9210,[[0,[1,2]],[4,[1]],[8,[1,2]],[12,[1,2]],[16,[1]],[20,[1,2]],
     [24,[1,2]],[28,[1]],[32,[1,2]],[36,[1,2]]]],
 [9215,[[0,[1,1,2]],[4,[1,2]],[8,[1,1,2]],[12,[1,1,2]],[16,[1,2]],
     [20,[1,1,2]],[24,[1,1,2]],[28,[1,2]],[32,[1,1,2]],[36,[1,1,2]]]],
 [9216,[[0,[1,1,1,2]],[4,[1]],[8,[1,1,1,2]],[12,[1,1,1,2]],[16,[1]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[28,[1]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [9219,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [9227,[[0,[1,2,2]],[4,[1]],[8,[1,2,2]],[12,[1,2,2]],[16,[1]],
     [20,[1,2,2]],[24,[1,2,2]],[28,[1]],[32,[1,2,2]],[36,[1,2,2]]]],
 [9239,[[0,[1,1,1,2]],[4,[1]],[5,[1,1,1,2]],[12,[1,1,1,2]],
     [13,[1,1,1,2]],[16,[1]],[21,[1,1,1,2]],[24,[1,1,1,2]],[28,[1]],
     [29,[1,1,1,2]]]],
 [9240,[[0,[1]],[1,[1,2]],[8,[1]],[9,[1,2]],[12,[1]],[17,[1,2]],
     [20,[1]],[24,[1]],[25,[1,2]],[32,[1]]]],
 [9241,[[0,[1,1,1,2]],[4,[1]],[8,[1,1,1,2]],[9,[1,1,1,2]],[16,[1]],
     [17,[1,1,1,2]],[20,[1,1,1,2]],[25,[1,1,1,2]],[28,[1]],
     [32,[1,1,1,2]]]],
 [9261,[[5,[1,1,1,1,1,1,1,2]],[17,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],
     [32,[1,2]],[42,[1,1,1,1,1,1,1,2]],[46,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]],[65,[1,1,1,1,1,1,1,2]],[77,[1,1,1,1,1,1,1,2]],
     [80,[1,1,1,1,1,1,1,2]]]],
 [9262,[[5,[1,1,1,1,2,1,1,2]],[13,[1]],[17,[1,1,1,1,2,1,1,2]],[32,[1]],
     [41,[1,1,1,1,2,1,1,2]],[42,[1]],[53,[1,1,1,1,2,1,1,2]],
     [65,[1,1,1,1,2,1,1,2]],[73,[1]],[77,[1,1,1,1,2,1,1,2]]]],
 [9270,[[2,[1,1,1,1,2,1,1,2]],[13,[1]],[16,[1,1,1,1,2,1,1,2]],[25,[1]],
     [40,[1,1,1,1,2,1,1,2]],[42,[1]],[52,[1,1,1,1,2,1,1,2]],
     [62,[1,1,1,1,2,1,1,2]],[73,[1]],[76,[1,1,1,1,2,1,1,2]]]],
 [9272,[[1,[1,1,1,2,1,1,2,2]],[6,[1,1,1,2,1,1,2,2]],[8,[1]],
     [13,[1,1,1,2,1,1,2,2]],[18,[1]],[21,[1,1,1,2,1,1,2,2]],
     [26,[1,1,1,2,1,1,2,2]],[30,[1,1,1,2,1,1,2,2]],[38,[1]],
     [41,[1,1,1,2,1,1,2,2]]]],
 [9275,[[13,[1,1,1,1,2]],[52,[1,1,1,1,2]],[73,[1,1,1,1,2]],
     [112,[1,1,1,1,2]],[133,[1,1,1,1,2]],[172,[1,1,1,1,2]],
     [193,[1,1,1,1,2]],[232,[1,1,1,1,2]],[253,[1,1,1,1,2]]]],
 [9277,[[2,[1,1,1,1,2,2,1,2]],[8,[1,1,1,1,2,2,1,2]],[10,[1]],
     [13,[1,1,1,1,2,2,1,2]],[17,[1,1,1,1,2,2,1,2]],[26,[1,1,1,1,2,2,1,2]],
     [28,[1,1,1,1,2,2,1,2]],[33,[1,1,1,1,2,2,1,2]],[37,[1,1,1,1,2,2,1,2]],
     [38,[1,1,1,1,2,2,1,2]]]],
 [9279,[[13,[1,1,1,1,2]],[28,[1,1,1,1,2]],[58,[1,1,1,1,2]],
     [73,[1,1,1,1,2]],[88,[1,1,1,1,2]],[118,[1,1,1,1,2]],
     [133,[1,1,1,1,2]],[148,[1,1,1,1,2]],[178,[1,1,1,1,2]],
     [193,[1,1,1,1,2]]]],
 [9284,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [9287,[[2,[1,1,1,2,1,1,2,2]],[6,[1,1,1,2,1,1,2,2]],[8,[1]],
     [13,[1,1,1,2,1,1,2,2]],[16,[1,1,1,2,1,1,2,2]],[18,[1]],
     [26,[1,1,1,2,1,1,2,2]],[30,[1,1,1,2,1,1,2,2]],[36,[1,1,1,2,1,1,2,2]],
     [38,[1]]]],
 [9314,[[6,[1,1,1,1,2,1,1,2]],[17,[1]],[20,[1,1,1,1,2,1,1,2]],[29,[1]],
     [44,[1,1,1,1,2,1,1,2]],[46,[1]],[56,[1,1,1,1,2,1,1,2]],
     [66,[1,1,1,1,2,1,1,2]],[77,[1]],[80,[1,1,1,1,2,1,1,2]]]],
 [9315,[[5,[1,1,1,1,1,1,1,2]],[14,[1,1,1,1,1,1,1,2]],[17,[1,1,1,1,1,1,1,2]],
     [29,[1,2]],[41,[1,1,1,1,1,1,1,2]],[44,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]],[65,[1,1,1,1,1,1,1,2]],[74,[1,1,1,1,1,1,1,2]],
     [77,[1,1,1,1,1,1,1,2]]]],
 [9322,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [9323,[[4,[1,1,1,1,1,1,1,2]],[16,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],
     [26,[1,2]],[40,[1,1,1,1,1,1,1,2]],[54,[1,1,1,1,1,1,1,2]],
     [64,[1,1,1,1,1,1,1,2]],[76,[1,1,1,1,1,1,1,2]],[85,[1,1,1,1,1,1,1,2]],
     [86,[1,2]]]],
 [9324,[[10,[1,1,1,1,2,2]],[12,[1,1,1,1,2,2]],[17,[1,1,1,1,2,2]],
     [30,[1,1,1,1,2,2]],[52,[1,1,1,1,2,2]],[57,[1,1,1,1,2,2]],
     [70,[1,1,1,1,2,2]],[72,[1,1,1,1,2,2]],[77,[1,1,1,1,2,2]],
     [90,[1,1,1,1,2,2]]]],
 [9325,[[2,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],
     [14,[1,1,1,1,1,1,1,2]],[17,[3]],[29,[1,1,1,1,1,1,1,2]],
     [30,[1,1,1,1,1,1,1,2]],[37,[3]],[42,[1,1,1,1,1,1,1,2]],
     [49,[1,1,1,1,1,1,1,2]]]],
 [9334,[[9,[1,1,1,1,2]],[46,[1,1,1,1,2]],[69,[1,1,1,1,2]],
     [106,[1,1,1,1,2]],[129,[1,1,1,1,2]],[166,[1,1,1,1,2]],
     [189,[1,1,1,1,2]],[226,[1,1,1,1,2]],[249,[1,1,1,1,2]]]],
 [9335,[[0,[1]],[30,[1]],[36,[1]],[45,[1]],[60,[1]],[90,[1]],[96,[1]],
     [105,[1]],[120,[1]],[150,[1]]]],
 [9336,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [9337,[[26,[1]],[86,[1]],[146,[1]],[206,[1]]]],
 [9338,[[2,[1,1,1,1,2,2,1,2]],[4,[1,1,1,1,2,2,1,2]],[10,[1]],
     [14,[1,1,1,1,2,2,1,2]],[22,[1,1,1,1,2,2,1,2]],[24,[1,1,1,1,2,2,1,2]],
     [26,[1,1,1,1,2,2,1,2]],[32,[1,1,1,1,2,2,1,2]],[34,[1,1,1,1,2,2,1,2]],
     [44,[1,1,1,1,2,2,1,2]]]],
 [9339,[[6,[2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],[17,[1,2]],[30,[1,2]],
     [36,[1,2]],[46,[2]],[52,[1,2]],[56,[1,2]]]],
 [9340,[[2,[1,1,1,1,1,1,2,2]],[4,[1,2]],[6,[1,1,1,1,1,1,2,2]],
     [14,[1,1,1,1,1,1,2,2]],[24,[1,2]],[26,[1,1,1,1,1,1,2,2]],
     [30,[1,1,1,1,1,1,2,2]],[37,[1,2]],[42,[1,1,1,1,1,1,2,2]],[44,[1,2]] 
    ]],[9374,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [9375,[[2,[1,1,1,2,2,2,1,2]],[16,[1,1,1,2,2,2,1,2]],[28,[1,2]],
     [40,[1,1,1,2,2,2,1,2]],[52,[1,1,1,2,2,2,1,2]],[62,[1,1,1,2,2,2,1,2]],
     [76,[1,1,1,2,2,2,1,2]],[88,[1,2]],[100,[1,1,1,2,2,2,1,2]],
     [112,[1,1,1,2,2,2,1,2]]]],
 [9376,[[6,[1,1,2]],[46,[1,1,2]],[66,[1,1,2]],[106,[1,1,2]],[126,[1,1,2]],
     [166,[1,1,2]],[186,[1,1,2]],[226,[1,1,2]],[246,[1,1,2]]]],
 [9380,[[13,[1,1,2,2]],[28,[1,1,2,2]],[57,[1,1,2,2]],[73,[1,1,2,2]],
     [88,[1,1,2,2]],[117,[1,1,2,2]],[133,[1,1,2,2]],[148,[1,1,2,2]],
     [177,[1,1,2,2]],[193,[1,1,2,2]]]],
 [9384,[[8,[1,1,1,1,2]],[37,[1,1,1,1,2]],[53,[1,1,1,1,2]],[68,[1,1,1,1,2]],
     [97,[1,1,1,1,2]],[113,[1,1,1,1,2]],[128,[1,1,1,1,2]],
     [157,[1,1,1,1,2]],[173,[1,1,1,1,2]],[188,[1,1,1,1,2]]]],
 [9386,[[2,[1,1,2,2]],[33,[1,1,2,2]],[48,[1,1,2,2]],[62,[1,1,2,2]],
     [93,[1,1,2,2]],[108,[1,1,2,2]],[122,[1,1,2,2]],[153,[1,1,2,2]],
     [168,[1,1,2,2]],[182,[1,1,2,2]]]],
 [9388,[[6,[1,2]],[26,[1]],[37,[1,2]],[66,[1,2]],[86,[1]],[97,[1,2]],
     [126,[1,2]],[146,[1]],[157,[1,2]],[186,[1,2]]]],
 [9389,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [9391,[[0,[1]],[17,[1]],[20,[1]],[22,[1]],[32,[1]],[40,[1]],[42,[1]],
     [52,[1]],[60,[1]],[77,[1]]]],[9393,[[12,fail]]],[9395,[[17,fail]]],
 [9417,[[8,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],[29,[1,1,1,1,1,1,1,2]],
     [30,[1,2]],[44,[1,1,1,1,1,1,1,2]],[58,[1,1,1,1,1,1,1,2]],
     [68,[1,1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,1,2]],[89,[1,1,1,1,1,1,1,2]],
     [90,[1,2]]]],
 [9418,[[5,[1,1,1,1,1,1,2,2]],[8,[1,1,1,1,1,1,2,2]],[29,[1]],
     [38,[1,1,1,1,1,1,2,2]],[41,[1,1,1,1,1,1,2,2]],[53,[1,1,1,1,1,1,2,2]],
     [65,[1,1,1,1,1,1,2,2]],[68,[1,1,1,1,1,1,2,2]],[89,[1]],
     [98,[1,1,1,1,1,1,2,2]]]],
 [9422,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [9424,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [9425,[[30,[1]],[90,[1]],[150,[1]],[210,[1]]]],
 [9426,[[4,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[28,[1]],
     [36,[1,1,1,1,2,1,1,2]],[40,[1,1,1,1,2,1,1,2]],[50,[1,1,1,1,2,1,1,2]],
     [64,[1,1,1,1,2,1,1,2]],[66,[1,1,1,1,2,1,1,2]],[88,[1]],
     [96,[1,1,1,1,2,1,1,2]]]],
 [9427,[[10,[1,2]],[13,[1,2]],[16,[1,2]],[18,[1,2]],[21,[2]],[33,[1,2]],
     [36,[1,2]],[41,[2]],[53,[1,2]],[58,[1,2]]]],
 [9428,[[1,[1,1,1,1,2,2,1,2]],[5,[1,1,1,1,2,2,1,2]],[6,[1,1,1,1,2,2,1,2]],
     [14,[1,1,1,1,2,2,1,2]],[18,[1]],[25,[1,1,1,1,2,2,1,2]],
     [26,[1,1,1,1,2,2,1,2]],[30,[1,1,1,1,2,2,1,2]],[36,[1,1,1,1,2,2,1,2]],
     [38,[1]]]],
 [9431,[[4,[1]],[34,[1]],[40,[1]],[49,[1]],[64,[1]],[94,[1]],[100,[1]],
     [109,[1]],[124,[1]],[154,[1]]]],
 [9433,[[0,[1,1,1,1,1,1,2,2]],[5,[1,2]],[14,[1,1,1,1,1,1,2,2]],
     [21,[1,1,1,1,1,1,2,2]],[25,[1,2]],[26,[1,1,1,1,1,1,2,2]],
     [34,[1,1,1,1,1,1,2,2]],[38,[1,1,1,1,1,1,2,2]],[45,[1,2]],
     [46,[1,1,1,1,1,1,2,2]]]],
 [9438,[[10,[1]],[41,[1]],[70,[1]],[101,[1]],[130,[1]],[161,[1]],
     [190,[1]],[221,[1]],[250,[1]]]],
 [9441,[[0,[1,1,1,1,1,1,1,2]],[10,[3]],[14,[1,1,1,1,1,1,1,2]],
     [20,[1,1,1,1,1,1,1,2]],[21,[1,1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,1,2]],
     [34,[1,1,1,1,1,1,1,2]],[38,[1,1,1,1,1,1,1,2]],[40,[1,1,1,1,1,1,1,2]],
     [46,[1,1,1,1,1,1,1,2]]]],
 [9442,[[10,[1,1,1,1,2,2]],[16,[1,1,1,1,2,2]],[18,[1,1,1,1,2,2]],
     [30,[1,1,1,1,2,2]],[36,[1,1,1,1,2,2]],[58,[1,1,1,1,2,2]],
     [70,[1,1,1,1,2,2]],[76,[1,1,1,1,2,2]],[78,[1,1,1,1,2,2]],
     [90,[1,1,1,1,2,2]]]],
 [9467,[[6,[1,1,1,2,2,2,1,2]],[20,[1,1,1,2,2,2,1,2]],[32,[1,2]],
     [44,[1,1,1,2,2,2,1,2]],[56,[1,1,1,2,2,2,1,2]],[66,[1,1,1,2,2,2,1,2]],
     [80,[1,1,1,2,2,2,1,2]],[92,[1,2]],[104,[1,1,1,2,2,2,1,2]],
     [116,[1,1,1,2,2,2,1,2]]]],
 [9468,[[5,[1,1,1,1,2,1,2,2]],[17,[1,1,1,1,2,1,2,2]],[29,[2]],
     [41,[1,1,1,1,2,1,2,2]],[50,[1,1,1,1,2,1,2,2]],[65,[1,1,1,1,2,1,2,2]],
     [77,[1,1,1,1,2,1,2,2]],[89,[2]],[101,[1,1,1,1,2,1,2,2]],
     [110,[1,1,1,1,2,1,2,2]]]],
 [9472,[[32,[1]],[92,[1]],[152,[1]],[212,[1]]]],
 [9474,[[10,[1,2]],[30,[1]],[41,[1,2]],[70,[1,2]],[90,[1]],[101,[1,2]],
     [130,[1,2]],[150,[1]],[161,[1,2]],[190,[1,2]]]],
 [9475,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [9476,[[4,[1,1,2,1,1,2,2,2]],[16,[1,1,2,1,1,2,2,2]],[26,[1,2]],
     [40,[1,1,2,1,1,2,2,2]],[52,[1,1,2,1,1,2,2,2]],[64,[1,1,2,1,1,2,2,2]],
     [76,[1,1,2,1,1,2,2,2]],[86,[1,2]],[100,[1,1,2,1,1,2,2,2]],
     [112,[1,1,2,1,1,2,2,2]]]],
 [9477,[[10,[1]],[16,[1]],[17,[1]],[21,[2,2,3]],[30,[1]],[37,[1]],
     [41,[2,2,3]],[57,[1]],[70,[1]],[76,[1]]]],
 [9478,[[1,[1,1,2,2,2,2,1,2]],[5,[1,2]],[6,[1,1,2,2,2,2,1,2]],
     [9,[1,1,2,2,2,2,1,2]],[14,[1,1,2,2,2,2,1,2]],[25,[1,2]],
     [29,[1,1,2,2,2,2,1,2]],[30,[1,1,2,2,2,2,1,2]],[36,[1,2]],
     [41,[1,1,2,2,2,2,1,2]]]],
 [9491,[[0,[1,1,2,2,2,2,1,2]],[4,[1,2]],[14,[1,1,2,2,2,2,1,2]],
     [20,[1,1,2,2,2,2,1,2]],[21,[1,1,2,2,2,2,1,2]],[24,[1,2]],
     [26,[1,1,2,2,2,2,1,2]],[34,[1,1,2,2,2,2,1,2]],[36,[1,1,2,2,2,2,1,2]],
     [40,[1,1,2,2,2,2,1,2]]]],
 [9492,[[6,[2,2,3]],[10,[1]],[12,[1]],[16,[1]],[32,[1]],[46,[2,2,3]],
     [52,[1]],[56,[1]],[66,[2,2,3]],[70,[1]]]],[9495,[[16,fail]]],
 [9498,[[21,fail]]],
 [9516,[[8,[1,1,2,3,3,3,2,2]],[20,[1,1,2,3,3,3,2,2]],[32,[1]],
     [41,[1,1,2,3,3,3,2,2]],[56,[1,1,2,3,3,3,2,2]],[68,[1,1,2,3,3,3,2,2]],
     [80,[1,1,2,3,3,3,2,2]],[92,[1]],[101,[1,1,2,3,3,3,2,2]],
     [116,[1,1,2,3,3,3,2,2]]]],
 [9517,[[5,[1,2,1,2,2,1,2,3]],[17,[1,2,1,2,2,1,2,3]],[26,[2]],
     [41,[1,2,1,2,2,1,2,3]],[53,[1,2,1,2,2,1,2,3]],[65,[1,2,1,2,2,1,2,3]],
     [77,[1,2,1,2,2,1,2,3]],[86,[2]],[101,[1,2,1,2,2,1,2,3]],
     [113,[1,2,1,2,2,1,2,3]]]],
 [9523,[[25,[1]],[28,[1]],[85,[1]],[88,[1]],[145,[1]],[148,[1]],
     [205,[1]],[208,[1]]]],
 [9524,[[25,[1,1,2]],[85,[1,1,2]],[145,[1,1,2]],[205,[1,1,2]]]],
 [9525,[[1,[1,1,1,2,2,3,4,2]],[16,[1,1,1,2,2,3,4,2]],[28,[1,2]],
     [40,[1,1,1,2,2,3,4,2]],[52,[1,1,1,2,2,3,4,2]],[61,[1,1,1,2,2,3,4,2]],
     [76,[1,1,1,2,2,3,4,2]],[88,[1,2]],[100,[1,1,1,2,2,3,4,2]],
     [112,[1,1,1,2,2,3,4,2]]]],
 [9526,[[6,[2]],[13,[1,2]],[16,[1,2]],[33,[1,2]],[46,[2]],[53,[1,2]],
     [66,[2]],[73,[1,2]],[76,[1,2]],[93,[1,2]]]],
 [9537,[[21,[1,2,3]],[81,[1,2,3]],[141,[1,2,3]],[201,[1,2,3]]]],
 [9544,[[30,fail]]],[9545,[[30,fail]]],
 [9564,[[8,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[32,[1]],
     [40,[1,1,1,1,2,1,1,2]],[44,[1,1,1,1,2,1,1,2]],[54,[1,1,1,1,2,1,1,2]],
     [68,[1,1,1,1,2,1,1,2]],[70,[1,1,1,1,2,1,1,2]],[92,[1]],
     [100,[1,1,1,1,2,1,1,2]]]],
 [9565,[[5,[1,1,1,1,2,1,1,2]],[17,[1,1,1,1,2,1,1,2]],[20,[1,1,1,1,2,1,1,2]],
     [29,[1]],[50,[1,1,1,1,2,1,1,2]],[53,[1,1,1,1,2,1,1,2]],
     [65,[1,1,1,1,2,1,1,2]],[77,[1,1,1,1,2,1,1,2]],[80,[1,1,1,1,2,1,1,2]],
     [89,[1]]]],[9569,[[34,[1]],[94,[1]],[154,[1]],[214,[1]]]],
 [9573,[[4,[1,1,1,1,1,1,2,2]],[14,[1,1,1,1,1,1,2,2]],[18,[1,1,1,1,1,1,2,2]],
     [28,[1]],[49,[1,1,1,1,1,1,2,2]],[52,[1,1,1,1,1,1,2,2]],
     [64,[1,1,1,1,1,1,2,2]],[74,[1,1,1,1,1,1,2,2]],[78,[1,1,1,1,1,1,2,2]],
     [88,[1]]]],
 [9578,[[14,[1]],[45,[1]],[74,[1]],[105,[1]],[134,[1]],[165,[1]],
     [194,[1]],[225,[1]],[254,[1]]]],
 [9580,[[2,[1,1,1,2,1,1,2,2]],[10,[1]],[13,[1,1,1,2,1,1,2,2]],
     [14,[1,1,1,2,1,1,2,2]],[20,[1]],[22,[1,1,1,2,1,1,2,2]],
     [25,[1,1,1,2,1,1,2,2]],[33,[1,1,1,2,1,1,2,2]],[38,[1,1,1,2,1,1,2,2]],
     [40,[1]]]],
 [9582,[[20,[1,2]],[50,[1,2]],[80,[1,2]],[110,[1,2]],[140,[1,2]],
     [170,[1,2]],[200,[1,2]],[230,[1,2]]]],
 [9584,[[14,[1]],[45,[1]],[74,[1]],[105,[1]],[134,[1]],[165,[1]],
     [194,[1]],[225,[1]],[254,[1]]]],
 [9586,[[5,[1,1,1,1,2]],[20,[1,1,1,1,2]],[50,[1,1,1,1,2]],[65,[1,1,1,1,2]],
     [80,[1,1,1,1,2]],[110,[1,1,1,1,2]],[125,[1,1,1,1,2]],
     [140,[1,1,1,1,2]],[170,[1,1,1,1,2]],[185,[1,1,1,1,2]]]],
 [9588,[[2,[1,1,1,2,1,1,2,2]],[8,[1,1,1,2,1,1,2,2]],[10,[1]],
     [14,[1,1,1,2,1,1,2,2]],[20,[1]],[22,[1,1,1,2,1,1,2,2]],
     [28,[1,1,1,2,1,1,2,2]],[34,[1,1,1,2,1,1,2,2]],[38,[1,1,1,2,1,1,2,2]],
     [40,[1]]]],
 [9590,[[0,[1,1,1,1,2,2,1,2]],[2,[1,1,1,1,2,2,1,2]],[12,[1,1,1,1,2,2,1,2]],
     [14,[1,1,1,1,2,2,1,2]],[18,[1]],[20,[1,1,1,1,2,2,1,2]],
     [25,[1,1,1,1,2,2,1,2]],[30,[1,1,1,1,2,2,1,2]],[32,[1,1,1,1,2,2,1,2]],
     [38,[1]]]],
 [9611,[[8,[1,1,2,1,1,2,2,2]],[20,[1,1,2,1,1,2,2,2]],[30,[1,2]],
     [44,[1,1,2,1,1,2,2,2]],[56,[1,1,2,1,1,2,2,2]],[68,[1,1,2,1,1,2,2,2]],
     [80,[1,1,2,1,1,2,2,2]],[90,[1,2]],[104,[1,1,2,1,1,2,2,2]],
     [116,[1,1,2,1,1,2,2,2]]]],
 [9612,[[5,[1,2,2,1,2,2,2,3]],[14,[1,2,2,1,2,2,2,3]],[29,[1]],
     [41,[1,2,2,1,2,2,2,3]],[53,[1,2,2,1,2,2,2,3]],[65,[1,2,2,1,2,2,2,3]],
     [74,[1,2,2,1,2,2,2,3]],[89,[1]],[101,[1,2,2,1,2,2,2,3]],
     [113,[1,2,2,1,2,2,2,3]]]],
 [9616,[[20,[1,2]],[50,[1,2]],[80,[1,2]],[110,[1,2]],[140,[1,2]],
     [170,[1,2]],[200,[1,2]],[230,[1,2]]]],
 [9620,[[4,[1,2,2,1,2,2,2,3]],[16,[1,2,2,1,2,2,2,3]],[28,[1]],
     [40,[1,2,2,1,2,2,2,3]],[50,[1,2,2,1,2,2,2,3]],[64,[1,2,2,1,2,2,2,3]],
     [76,[1,2,2,1,2,2,2,3]],[88,[1]],[100,[1,2,2,1,2,2,2,3]],
     [110,[1,2,2,1,2,2,2,3]]]],
 [9621,[[5,[1]],[9,[1]],[10,[1]],[29,[1]],[34,[1]],[45,[1]],[49,[1]],
     [54,[1]],[65,[1]],[69,[1]]]],
 [9629,[[14,[1,2]],[34,[1]],[45,[1,2]],[74,[1,2]],[94,[1]],[105,[1,2]],
     [134,[1,2]],[154,[1]],[165,[1,2]],[194,[1,2]]]],
 [9631,[[10,[2]],[21,[2]],[50,[2]],[70,[2]],[81,[2]],[110,[2]],
     [130,[2]],[141,[2]],[170,[2]],[190,[2]]]],
 [9632,[[5,[2]],[36,[2]],[45,[2]],[65,[2]],[96,[2]],[105,[2]],[125,[2]],
     [156,[2]],[165,[2]],[185,[2]]]],
 [9636,[[20,[1,1,2]],[40,[1,1,2]],[80,[1,1,2]],[100,[1,1,2]],[140,[1,1,2]],
     [160,[1,1,2]],[200,[1,1,2]],[220,[1,1,2]]]],[9646,[[20,fail]]],
 [9657,[[5,[1,1,1,2,2,3,4,2]],[20,[1,1,1,2,2,3,4,2]],[32,[1,2]],
     [44,[1,1,1,2,2,3,4,2]],[56,[1,1,1,2,2,3,4,2]],[65,[1,1,1,2,2,3,4,2]],
     [80,[1,1,1,2,2,3,4,2]],[92,[1,2]],[104,[1,1,1,2,2,3,4,2]],
     [116,[1,1,1,2,2,3,4,2]]]],
 [9658,[[5,[1,1,2,2,2,2,2,4]],[17,[1,1,2,2,2,2,2,4]],[29,[2]],
     [41,[1,1,2,2,2,2,2,4]],[50,[1,1,2,2,2,2,2,4]],[65,[1,1,2,2,2,2,2,4]],
     [77,[1,1,2,2,2,2,2,4]],[89,[2]],[101,[1,1,2,2,2,2,2,4]],
     [110,[1,1,2,2,2,2,2,4]]]],
 [9662,[[29,[1,1,2]],[89,[1,1,2]],[149,[1,1,2]],[209,[1,1,2]]]],
 [9666,[[4,[1,1,1,2,2,1,2,3]],[16,[1,1,1,2,2,1,2,3]],[25,[3,4]],
     [40,[1,1,1,2,2,1,2,3]],[52,[1,1,1,2,2,1,2,3]],[64,[1,1,1,2,2,1,2,3]],
     [76,[1,1,1,2,2,1,2,3]],[85,[3,4]],[100,[1,1,1,2,2,1,2,3]],
     [112,[1,1,1,2,2,1,2,3]]]],
 [9671,[[25,[1,2,3]],[85,[1,2,3]],[145,[1,2,3]],[205,[1,2,3]]]],
 [9675,[[29,[1]],[32,[1]],[89,[1]],[92,[1]],[149,[1]],[152,[1]],
     [209,[1]],[212,[1]]]],
 [9678,[[30,[1,2,2]],[90,[1,2,2]],[150,[1,2,2]],[210,[1,2,2]]]],
 [9682,[[10,[1,2]],[16,[1,2]],[20,[2]],[36,[1,2]],[40,[2]],[56,[1,2]],
     [70,[1,2]],[76,[1,2]],[80,[2]],[96,[1,2]]]],[9688,[[34,fail]]],
 [9692,[[34,fail]]],
 [9703,[[5,[1,1,2,3,3,4,2,2]],[17,[1,1,2,3,3,4,2,2]],[25,[4,5]],
     [41,[1,1,2,3,3,4,2,2]],[53,[1,1,2,3,3,4,2,2]],[65,[1,1,2,3,3,4,2,2]],
     [77,[1,1,2,3,3,4,2,2]],[85,[4,5]],[101,[1,1,2,3,3,4,2,2]],
     [113,[1,1,2,3,3,4,2,2]]]],
 [9709,[[25,[2,2,3]],[85,[2,2,3]],[145,[2,2,3]],[205,[2,2,3]]]],
 [9710,[[25,[1,2,2,2]],[85,[1,2,2,2]],[145,[1,2,2,2]],[205,[1,2,2,2]]]],
 [9711,[[0,[1,2,3,2,3,3,2,3]],[16,[1,2,3,2,3,3,2,3]],[28,[3,4]],
     [40,[1,2,3,2,3,3,2,3]],[52,[1,2,3,2,3,3,2,3]],[60,[1,2,3,2,3,3,2,3]],
     [76,[1,2,3,2,3,3,2,3]],[88,[3,4]],[100,[1,2,3,2,3,3,2,3]],
     [112,[1,2,3,2,3,3,2,3]]]],
 [9716,[[28,[1,1,2,3]],[40,[1,1,2,1,2]],[88,[1,1,2,3]],[100,[1,1,2,1,2]],
     [148,[1,1,2,3]],[160,[1,1,2,1,2]],[208,[1,1,2,3]],[220,[1,1,2,1,2]]]]
  ,
 [9720,[[25,[2,2,3]],[41,[1,1,1,2,2,2]],[85,[2,2,3]],[101,[1,1,1,2,2,2]],
     [145,[2,2,3]],[161,[1,1,1,2,2,2]],[205,[2,2,3]],[221,[1,1,1,2,2,2]]]]
  ,
 [9722,[[5,[1,1,2,2,3,2,3]],[20,[1,1,2,2,3,2,3]],[26,[1,1,2,2,3,2,3]],
     [57,[1,1,2,2,3,2,3]],[65,[1,1,2,2,3,2,3]],[80,[1,1,2,2,3,2,3]],
     [86,[1,1,2,2,3,2,3]],[117,[1,1,2,2,3,2,3]],[125,[1,1,2,2,3,2,3]],
     [140,[1,1,2,2,3,2,3]]]],
 [9723,[[5,[4]],[6,[4]],[36,[4]],[48,[4]],[65,[4]],[66,[4]],[96,[4]],
     [108,[4]],[125,[4]],[126,[4]]]],
 [9724,[[2,[1]],[33,[1]],[45,[1]],[62,[1]],[93,[1]],[105,[1]],[122,[1]],
     [153,[1]],[165,[1]],[182,[1]]]],
 [9746,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [9747,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [9755,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [9757,[[1,[1]],[2,[1]],[6,[1]],[9,[1]],[13,[1]],[14,[1]],[18,[1]],
     [21,[1]],[25,[1]],[26,[1]]]],
 [9762,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [9770,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [9772,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [9789,[[5,[1]],[8,[1,2]],[17,[1]],[20,[1,2]],[29,[1]],[32,[1,2]],
     [41,[1]],[44,[1,2]],[53,[1]],[56,[1,2]]]],
 [9790,[[5,[1,2]],[8,[1]],[17,[1,2]],[20,[1]],[29,[1,2]],[32,[1]],
     [41,[1,2]],[44,[1]],[53,[1,2]],[56,[1]]]],
 [9797,[[1,[1,2]],[6,[1,2]],[13,[1,2]],[18,[1,2]],[25,[1,2]],[30,[1,2]],
     [37,[1,2]],[42,[1,2]],[49,[1,2]],[54,[1,2]]]],
 [9798,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [9805,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [9811,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [9812,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [9813,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [9815,[[2,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],[9816,[[6,fail]]],
 [9818,[[6,fail]]],
 [9832,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [9839,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [9840,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [9841,[[1,[1,1,2]],[9,[1,1,2]],[13,[1,1,2]],[21,[1,1,2]],[25,[1,1,2]],
     [33,[1,1,2]],[37,[1,1,2]],[45,[1,1,2]],[49,[1,1,2]],[57,[1,1,2]]]],
 [9842,[[2,[2]],[6,[2]],[14,[2]],[18,[2]],[26,[2]],[30,[2]],[38,[2]],
     [42,[2]],[50,[2]],[54,[2]]]],
 [9847,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [9853,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [9854,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [9855,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [9856,[[0,[1]],[4,[1]],[6,[1]],[8,[1]],[12,[1]],[16,[1]],[18,[1]],
     [20,[1]],[24,[1]],[28,[1]]]],
 [9857,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],[9860,[[6,fail]]],
 [9861,[[6,fail]]],
 [9872,[[5,[1]],[10,[1]],[17,[1]],[22,[1]],[29,[1]],[34,[1]],[41,[1]],
     [46,[1]],[53,[1]],[58,[1]]]],
 [9873,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [9881,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [9882,[[1,[1]],[5,[1]],[6,[1]],[10,[1]],[13,[1]],[17,[1]],[18,[1]],
     [22,[1]],[25,[1]],[29,[1]]]],
 [9883,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [9888,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [9893,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [9896,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [9897,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [9898,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [9912,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9919,[[1,[1,2]],[6,[1,2]],[13,[1,2]],[18,[1,2]],[25,[1,2]],[30,[1,2]],
     [37,[1,2]],[42,[1,2]],[49,[1,2]],[54,[1,2]]]],
 [9921,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],[62,[1,2]],
     [74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [9922,[[1,[1]],[5,[1]],[6,[1]],[9,[1]],[13,[1]],[17,[1]],[18,[1]],
     [21,[1]],[25,[1]],[29,[1]]]],
 [9923,[[1,[1,2]],[5,[1,2]],[6,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],
     [18,[1,2]],[21,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [9928,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [9936,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [9937,[[0,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[44,[1,1,2]],[48,[1,1,2]],[56,[1,1,2]]]],
 [9938,[[2,[2]],[6,[2]],[14,[2]],[18,[2]],[26,[2]],[30,[2]],[38,[2]],
     [42,[2]],[50,[2]],[54,[2]]]],[9939,[[6,fail]]],[9940,[[6,fail]]],
 [9951,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [9952,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [9958,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [9960,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],[64,[1,2]],
     [76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [9962,[[2,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],
 [9967,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [9975,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],[9979,[[6,fail]]],[9981,[[6,fail]]],
 [9990,[[5,[1,2]],[8,[1,2]],[17,[1,2]],[20,[1,2]],[29,[1,2]],[32,[1,2]],
     [41,[1,2]],[44,[1,2]],[53,[1,2]],[56,[1,2]]]],
 [9991,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [9992,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9993,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [9994,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],[68,[1,2]],
     [80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [9995,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [9996,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],[34,[1,2]],
     [40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [9997,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],[66,[1,2]],
     [78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [9998,[[4,[1,2]],[8,[1]],[16,[1,2]],[20,[1]],[28,[1,2]],[32,[1]],
     [40,[1,2]],[44,[1]],[52,[1,2]],[56,[1]]]],
 [10001,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10002,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [10003,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10004,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10006,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10007,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10008,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10009,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [10016,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10019,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [10020,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10021,[[5,[1,1,2,2]],[10,[1,1,2,2]],[13,[1,2]],[22,[1,1,2,2]],
     [29,[1,1,2,2]],[34,[1,1,2,2]],[37,[1,2]],[46,[1,1,2,2]],
     [53,[1,1,2,2]],[58,[1,1,2,2]]]],
 [10022,[[5,[1]],[8,[1]],[13,[1]],[20,[1]],[29,[1]],[32,[1]],[37,[1]],
     [44,[1]],[53,[1]],[56,[1]]]],
 [10023,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10024,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10025,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10027,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10028,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10029,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10030,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10031,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10032,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [10034,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [10035,[[1,[2]],[6,[2]],[13,[2]],[18,[2]],[25,[2]],[30,[2]],[37,[2]],
     [42,[2]],[49,[2]],[54,[2]]]],
 [10036,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10038,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10039,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10040,[[5,[2,3]],[17,[2,3]],[29,[2,3]],[41,[2,3]],[53,[2,3]],
     [65,[2,3]],[77,[2,3]],[89,[2,3]],[101,[2,3]],[113,[2,3]]]],
 [10041,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10043,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10044,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10045,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [10046,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10047,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10048,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [10049,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [10051,[[0,[1,1,2]],[5,[1,2]],[8,[2,3,3]],[12,[1,1,2]],[17,[1,2]],
     [20,[2,3,3]],[24,[1,1,2]],[29,[1,2]],[32,[2,3,3]],[36,[1,1,2]]]],
 [10054,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [10055,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [10057,[[5,[2,3]],[17,[2,3]],[29,[2,3]],[41,[2,3]],[53,[2,3]],
     [65,[2,3]],[77,[2,3]],[89,[2,3]],[101,[2,3]],[113,[2,3]]]],
 [10058,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10060,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10061,[[5,[2,3]],[17,[2,3]],[29,[2,3]],[41,[2,3]],[53,[2,3]],
     [65,[2,3]],[77,[2,3]],[89,[2,3]],[101,[2,3]],[113,[2,3]]]],
 [10062,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10063,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10067,[[5,[1,2]],[10,[1,2]],[17,[1,2]],[22,[1,2]],[29,[1,2]],
     [34,[1,2]],[41,[1,2]],[46,[1,2]],[53,[1,2]],[58,[1,2]]]],
 [10069,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [10070,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [10071,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10073,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [10078,[[0,[1,2]],[10,[1,2]],[13,[1,2]],[22,[1,2]],[25,[1,2]],
     [34,[1,2]],[37,[1,2]],[46,[1,2]],[49,[1,2]],[58,[1,2]]]],
 [10082,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [10083,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [10088,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],[10090,[[10,fail]]],[10093,[[10,fail]]],
 [10102,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10104,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [10105,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [10106,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10107,[[5,[1,1,2]],[6,[1,1,2]],[17,[1,1,2]],[18,[1,1,2]],[29,[1,1,2]],
     [30,[1,1,2]],[41,[1,1,2]],[42,[1,1,2]],[53,[1,1,2]],[54,[1,1,2]]]],
 [10108,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [10113,[[0,[2]],[10,[2]],[13,[2]],[22,[2]],[25,[2]],[34,[2]],[37,[2]],
     [46,[2]],[49,[2]],[58,[2]]]],
 [10121,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [10122,[[0,[1]],[4,[1]],[8,[1]],[10,[1]],[12,[1]],[16,[1]],[20,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [10123,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],[10126,[[10,fail]]],[10128,[[10,fail]]],
 [10136,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],
 [10140,[[1,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [10145,[[0,[1,2,2]],[13,[1,2,2]],[25,[1,2,2]],[37,[1,2,2]],[49,[1,2,2]],
     [61,[1,2,2]],[73,[1,2,2]],[85,[1,2,2]],[97,[1,2,2]],[109,[1,2,2]]]]
  ,
 [10149,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10158,[[14,[3]],[38,[3]],[62,[3]],[86,[3]],[110,[3]],[134,[3]],
     [158,[3]],[182,[3]],[206,[3]],[230,[3]]]],[10161,[[14,fail]]],
 [10162,[[14,[3]],[38,[3]],[62,[3]],[86,[3]],[110,[3]],[134,[3]],
     [158,[3]],[182,[3]],[206,[3]],[230,[3]]]],[10166,[[14,fail]]],
 [10170,[[1,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [10171,[[4,[1,2]],[5,[1,2]],[10,[2,4]],[16,[1,2]],[17,[1,2]],[22,[2,4]],
     [28,[1,2]],[29,[1,2]],[34,[2,4]],[40,[1,2]]]],
 [10172,[[5,[1]],[8,[1]],[10,[1]],[17,[1]],[20,[1]],[22,[1]],[29,[1]],
     [32,[1]],[34,[1]],[41,[1]]]],
 [10181,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10183,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [10187,[[0,[1]],[1,[1]],[9,[1]],[12,[1]],[14,[1]],[21,[1]],[24,[1]],
     [26,[1]],[33,[1]],[36,[1]]]],[10195,[[20,fail]]],
 [10196,[[5,[1]],[9,[1,2]],[17,[1,2]],[21,[1]],[29,[1]],[33,[1,2]],
     [41,[1,2]],[45,[1]],[53,[1]],[57,[1,2]]]],
 [10210,[[4,[1,1,1,2]],[16,[1,1,1,2]],[28,[1,1,1,2]],[40,[1,1,1,2]],
     [52,[1,1,1,2]],[64,[1,1,1,2]],[76,[1,1,1,2]],[88,[1,1,1,2]],
     [100,[1,1,1,2]],[112,[1,1,1,2]]]],
 [10214,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,[10223,[[14,fail]]],[10226,[[14,fail]]],[10227,[[14,fail]]],
 [10231,[[14,fail]]],
 [10236,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10238,[[1,[1,2]],[6,[2,4]],[13,[1,2]],[18,[2,4]],[25,[1,2]],[30,[2,4]],
     [37,[1,2]],[42,[2,4]],[49,[1,2]],[54,[2,4]]]],
 [10253,[[1,[2]],[6,[4]],[13,[2]],[18,[4]],[25,[2]],[30,[4]],[37,[2]],
     [42,[4]],[49,[2]],[54,[4]]]],[10255,[[16,fail]]],
 [10265,[[4,[1]],[12,[1]],[28,[1]],[36,[1]],[52,[1]],[60,[1]],[76,[1]],
     [84,[1]],[100,[1]],[108,[1]]]],
 [10266,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10279,[[0,[1,2]],[1,[1,2]],[6,[2,4]],[12,[1,2]],[13,[1,2]],[18,[2,4]],
     [24,[1,2]],[25,[1,2]],[30,[2,4]],[36,[1,2]]]],
 [10280,[[1,[1]],[4,[1]],[6,[1]],[13,[1]],[16,[1]],[18,[1]],[25,[1]],
     [28,[1]],[30,[1]],[37,[1]]]],
 [10283,[[1,[1,2]],[6,[3]],[13,[1,2]],[18,[3]],[25,[1,2]],[30,[3]],
     [37,[1,2]],[42,[3]],[49,[1,2]],[54,[3]]]],[10286,[[16,fail]]],
 [10290,[[1,[1]],[5,[1,2]],[13,[1,2]],[17,[1]],[25,[1]],[29,[1,2]],
     [37,[1,2]],[41,[1]],[49,[1]],[53,[1,2]]]],
 [10296,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10298,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10299,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10300,[[4,[2,4]],[16,[2,4]],[28,[2,4]],[40,[2,4]],[52,[2,4]],
     [64,[2,4]],[76,[2,4]],[88,[2,4]],[100,[2,4]],[112,[2,4]]]],
 [10301,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10303,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [10305,[[4,[3]],[16,[3]],[28,[3]],[40,[3]],[52,[3]],[64,[3]],[76,[3]],
     [88,[3]],[100,[3]],[112,[3]]]],
 [10306,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10307,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10308,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [10309,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],
     [62,[1,2]],[74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [10311,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10314,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10315,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10317,[[4,[3,4]],[16,[3,4]],[28,[3,4]],[40,[3,4]],[52,[3,4]],
     [64,[3,4]],[76,[3,4]],[88,[3,4]],[100,[3,4]],[112,[3,4]]]],
 [10318,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10319,[[1,[1,1,2,2]],[6,[1,1,2,2]],[9,[1,2]],[18,[1,1,2,2]],
     [25,[1,1,2,2]],[30,[1,1,2,2]],[33,[1,2]],[42,[1,1,2,2]],
     [49,[1,1,2,2]],[54,[1,1,2,2]]]],
 [10320,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10321,[[4,[2,4]],[16,[2,4]],[28,[2,4]],[40,[2,4]],[52,[2,4]],
     [64,[2,4]],[76,[2,4]],[88,[2,4]],[100,[2,4]],[112,[2,4]]]],
 [10322,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10323,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10325,[[1,[1,2]],[5,[1,2]],[6,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],
     [18,[1,2]],[21,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [10327,[[0,[1]],[5,[1]],[9,[1]],[10,[1]],[13,[1]],[17,[1]],[21,[1]],
     [22,[1]],[25,[1]],[29,[1]]]],
 [10330,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[10,[1,2]],[13,[1,2]],[17,[1,2]],
     [21,[1,2]],[22,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [10334,[[0,[1,1,1,2,2]],[5,[1,1,1,2,2]],[9,[2,3,3,3,3]],[12,[1,1,1,2,2]],
     [17,[1,1,1,2,2]],[21,[2,3,3,3,3]],[24,[1,1,1,2,2]],[29,[1,1,1,2,2]],
     [33,[2,3,3,3,3]],[36,[1,1,1,2,2]]]],
 [10339,[[0,[2]],[4,[2]],[6,[2]],[10,[2]],[12,[2]],[16,[2]],[18,[2]],
     [22,[2]],[24,[2]],[28,[2]]]],[10343,[[5,fail]]],[10344,[[1,fail]]],
 [10345,[[5,fail]]],[10350,[[0,fail]]],[10351,[[0,fail]]],[10352,[[0,fail]]],
 [10353,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [10354,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [10356,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [10361,[[2,[2]],[9,[1]],[14,[2]],[21,[1]],[26,[2]],[33,[1]],[38,[2]],
     [45,[1]],[50,[2]],[57,[1]]]],
 [10362,[[0,[1]],[6,[2]],[12,[1]],[18,[2]],[24,[1]],[30,[2]],[36,[1]],
     [42,[2]],[48,[1]],[54,[2]]]],
 [10367,[[0,[1]],[1,[1]],[2,[2]],[6,[2]],[8,[1]],[9,[1]],[12,[1]],
     [13,[1]],[14,[2]],[18,[2]]]],
 [10373,[[1,[1]],[6,[1]],[9,[1]],[17,[1]],[18,[1]],[25,[1]],[30,[1]],
     [33,[1]],[41,[1]],[42,[1]]]],
 [10375,[[2,[1]],[5,[1]],[13,[1]],[14,[1]],[21,[1]],[26,[1]],[29,[1]],
     [37,[1]],[38,[1]],[45,[1]]]],
 [10377,[[0,[1]],[2,[1]],[5,[1]],[8,[1]],[9,[1]],[12,[1]],[14,[1]],
     [17,[1]],[20,[1]],[21,[1]]]],
 [10378,[[0,[1]],[1,[1]],[5,[1]],[6,[1]],[8,[1]],[12,[1]],[13,[1]],
     [17,[1]],[18,[1]],[20,[1]]]],
 [10379,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[8,[1,2]],[9,[1,2]],[13,[1,2]],
     [18,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [10381,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [10383,[[2,[1]],[5,[1]],[9,[1]],[10,[1]],[14,[1]],[17,[1]],[21,[1]],
     [22,[1]],[26,[1]],[29,[1]]]],
 [10387,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [10391,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [10393,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [10408,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[10,[1,2]],[13,[1,2]],[17,[1,2]],
     [21,[1,2]],[22,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [10410,[[5,[1,2]],[10,[1,2]],[17,[1,2]],[22,[1,2]],[29,[1,2]],
     [34,[1,2]],[41,[1,2]],[46,[1,2]],[53,[1,2]],[58,[1,2]]]],
 [10416,[[0,[2]],[10,[2]],[12,[2]],[22,[2]],[24,[2]],[34,[2]],[36,[2]],
     [46,[2]],[48,[2]],[58,[2]]]],
 [10417,[[4,[1,1,2]],[6,[1,1,2]],[16,[1,1,2]],[18,[1,1,2]],[28,[1,1,2]],
     [30,[1,1,2]],[40,[1,1,2]],[42,[1,1,2]],[52,[1,1,2]],[54,[1,1,2]]]],
 [10418,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[10420,[[10,fail]]],[10427,[[10,fail]]],
 [10435,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [10436,[[2,[2]],[9,[2]],[14,[2]],[21,[2]],[26,[2]],[33,[2]],[38,[2]],
     [45,[2]],[50,[2]],[57,[2]]]],
 [10454,[[4,[2]],[16,[1]],[20,[1]],[28,[2]],[40,[1]],[44,[1]],[52,[2]],
     [64,[1]],[68,[1]],[76,[2]]]],
 [10457,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [10459,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [10460,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [10463,[[0,[1,2]],[10,[1,2]],[12,[1,2]],[22,[1,2]],[24,[1,2]],
     [34,[1,2]],[36,[1,2]],[46,[1,2]],[48,[1,2]],[58,[1,2]]]],
 [10465,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[10468,[[10,fail]]],[10474,[[10,fail]]],
 [10483,[[2,[2,4]],[9,[1,2]],[14,[2,4]],[21,[1,2]],[26,[2,4]],[33,[1,2]],
     [38,[2,4]],[45,[1,2]],[50,[2,4]],[57,[1,2]]]],
 [10485,[[2,[2]],[4,[1]],[5,[1]],[8,[1]],[9,[1]],[10,[2]],[14,[2]],
     [16,[1]],[17,[1]],[20,[1]]]],
 [10493,[[0,[1]],[9,[1]],[10,[1]],[17,[1]],[22,[1]],[25,[1]],[33,[1]],
     [34,[1]],[41,[1]],[46,[1]]]],
 [10494,[[2,[1]],[5,[1]],[13,[1]],[14,[1]],[21,[1]],[26,[1]],[29,[1]],
     [37,[1]],[38,[1]],[45,[1]]]],
 [10498,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[10,[1]],[13,[1]],[16,[1]],
     [17,[1]],[20,[1]],[22,[1]]]],
 [10499,[[0,[1]],[2,[1]],[4,[1]],[8,[1]],[9,[1]],[13,[1]],[14,[1]],
     [16,[1]],[20,[1]],[21,[1]]]],
 [10500,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],
 [10504,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],[10509,[[14,fail]]],[10512,[[14,fail]]],
 [10513,[[14,fail]]],[10517,[[14,fail]]],
 [10521,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [10525,[[0,[2,4]],[8,[1,2]],[9,[1,2]],[14,[2,4]],[20,[1,2]],[21,[1,2]],
     [26,[2,4]],[32,[1,2]],[33,[1,2]],[38,[2,4]]]],
 [10527,[[4,[1,1,2]],[8,[2,3,3]],[16,[1,1,2]],[20,[2,3,3]],[28,[1,1,2]],
     [32,[2,3,3]],[40,[1,1,2]],[44,[2,3,3]],[52,[1,1,2]],[56,[2,3,3]]]],
 [10537,[[20,fail]]],
 [10539,[[8,[1]],[16,[1]],[32,[1]],[40,[1]],[56,[1]],[64,[1]],[80,[1]],
     [88,[1]],[104,[1]],[112,[1]]]],
 [10544,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],[10548,[[14,fail]]],
 [10551,[[14,[3]],[38,[3]],[62,[3]],[86,[3]],[110,[3]],[134,[3]],
     [158,[3]],[182,[3]],[206,[3]],[230,[3]]]],[10552,[[14,fail]]],
 [10556,[[14,[3]],[38,[3]],[62,[3]],[86,[3]],[110,[3]],[134,[3]],
     [158,[3]],[182,[3]],[206,[3]],[230,[3]]]],
 [10560,[[0,[1,2]],[9,[1,2]],[12,[1,2]],[21,[1,2]],[24,[1,2]],[33,[1,2]],
     [36,[1,2]],[45,[1,2]],[48,[1,2]],[57,[1,2]]]],
 [10564,[[0,[2,3,3]],[4,[2,3,3]],[8,[2,3,3]],[10,[1,1,2]],[12,[2,3,3]],
     [16,[2,3,3]],[20,[2,3,3]],[22,[1,1,2]],[24,[2,3,3]],[28,[2,3,3]]]],
 [10565,[[2,[2]],[9,[1]],[14,[2]],[21,[1]],[26,[2]],[33,[1]],[38,[2]],
     [45,[1]],[50,[2]],[57,[1]]]],
 [10582,[[0,[1]],[6,[2]],[12,[1]],[18,[2]],[24,[1]],[30,[2]],[36,[1]],
     [42,[2]],[48,[1]],[54,[2]]]],
 [10596,[[2,[4]],[9,[2]],[14,[4]],[21,[2]],[26,[4]],[33,[2]],[38,[4]],
     [45,[2]],[50,[4]],[57,[2]]]],
 [10597,[[0,[6]],[6,[4,5]],[8,[2,4]],[12,[6]],[18,[4,5]],[20,[2,4]],
     [24,[6]],[30,[4,5]],[32,[2,4]],[36,[6]]]],[10599,[[12,fail]]],
 [10611,[[2,[3]],[9,[1,2]],[14,[3]],[21,[1,2]],[26,[3]],[33,[1,2]],
     [38,[3]],[45,[1,2]],[50,[3]],[57,[1,2]]]],
 [10612,[[0,[2]],[4,[2]],[6,[1]],[8,[2]],[12,[2]],[16,[2]],[18,[1]],
     [20,[2]],[24,[2]],[28,[2]]]],[10617,[[12,fail]]],
 [10621,[[0,[1,1,1,2]],[9,[1,1,1,2]],[13,[1,1,1,2]],[21,[1,1,1,2]],
     [25,[1,1,1,2]],[33,[1,1,1,2]],[37,[1,1,1,2]],[45,[1,1,1,2]],
     [49,[1,1,1,2]],[57,[1,1,1,2]]]],
 [10626,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [10633,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[10,[1]],[12,[1]],[16,[1]],
     [17,[1]],[21,[1]],[22,[1]]]],
 [10634,[[0,[1]],[2,[1]],[5,[1]],[8,[1]],[9,[1]],[12,[1]],[14,[1]],
     [17,[1]],[20,[1]],[21,[1]]]],
 [10638,[[0,[1]],[8,[1]],[10,[1]],[16,[1]],[22,[1]],[24,[1]],[32,[1]],
     [34,[1]],[40,[1]],[46,[1]]]],
 [10639,[[2,[1]],[4,[1]],[12,[1]],[14,[1]],[20,[1]],[26,[1]],[28,[1]],
     [36,[1]],[38,[1]],[44,[1]]]],
 [10640,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],[10641,[[0,fail]]],
 [10642,[[4,fail]]],[10646,[[0,fail]]],[10647,[[0,fail]]],[10648,[[0,fail]]],
 [10649,[[4,fail]]],
 [10658,[[0,[1]],[1,[1]],[4,[1]],[6,[1]],[9,[1]],[12,[1]],[13,[1]],
     [16,[1]],[18,[1]],[21,[1]]]],
 [10659,[[0,[1,2]],[1,[1,2]],[6,[1,2]],[8,[1,2]],[9,[1,2]],[12,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [10660,[[0,[1]],[2,[1]],[4,[1]],[8,[1]],[9,[1]],[13,[1]],[14,[1]],
     [16,[1]],[20,[1]],[21,[1]]]],
 [10662,[[2,[1]],[4,[1]],[12,[1]],[14,[1]],[20,[1]],[26,[1]],[28,[1]],
     [36,[1]],[38,[1]],[44,[1]]]],
 [10663,[[0,[1]],[6,[1]],[8,[1]],[16,[1]],[18,[1]],[24,[1]],[30,[1]],
     [32,[1]],[40,[1]],[42,[1]]]],
 [10665,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [10666,[[6,fail]]],[10668,[[14,fail]]],
 [10672,[[14,[2,4]],[38,[2,4]],[62,[2,4]],[86,[2,4]],[110,[2,4]],
     [134,[2,4]],[158,[2,4]],[182,[2,4]],[206,[2,4]],[230,[2,4]]]],
 [10677,[[6,fail]]],[10678,[[10,fail]]],
 [10682,[[10,[1,2]],[22,[1,2]],[34,[1,2]],[46,[1,2]],[58,[1,2]],
     [70,[1,2]],[82,[1,2]],[94,[1,2]],[106,[1,2]],[118,[1,2]]]],
 [10686,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [10687,[[10,[1,2]],[22,[1,2]],[34,[1,2]],[46,[1,2]],[58,[1,2]],
     [70,[1,2]],[82,[1,2]],[94,[1,2]],[106,[1,2]],[118,[1,2]]]],
 [10691,[[10,fail]]],
 [10695,[[14,[2,4]],[38,[2,4]],[62,[2,4]],[86,[2,4]],[110,[2,4]],
     [134,[2,4]],[158,[2,4]],[182,[2,4]],[206,[2,4]],[230,[2,4]]]],
 [10699,[[14,fail]]],
 [10736,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [10737,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [10754,[[5,[1,2]],[8,[1]],[17,[1,2]],[20,[1]],[29,[1,2]],[32,[1]],
     [41,[1,2]],[44,[1]],[53,[1,2]],[56,[1]]]],
 [10755,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [10759,[[8,[1,2]],[9,[1,2]],[20,[1,2]],[21,[1,2]],[32,[1,2]],[33,[1,2]],
     [44,[1,2]],[45,[1,2]],[56,[1,2]],[57,[1,2]]]],
 [10761,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [10762,[[4,[1,2]],[5,[1,2]],[16,[1,2]],[17,[1,2]],[28,[1,2]],[29,[1,2]],
     [40,[1,2]],[41,[1,2]],[52,[1,2]],[53,[1,2]]]],
 [10763,[[1,[1,2]],[4,[1]],[13,[1,2]],[16,[1]],[25,[1,2]],[28,[1]],
     [37,[1,2]],[40,[1]],[49,[1,2]],[52,[1]]]],
 [10764,[[5,[2]],[9,[2]],[17,[2]],[21,[2]],[29,[2]],[33,[2]],[41,[2]],
     [45,[2]],[53,[2]],[57,[2]]]],
 [10765,[[1,[1,1,2]],[5,[1,1,2]],[13,[1,1,2]],[17,[1,1,2]],[25,[1,1,2]],
     [29,[1,1,2]],[37,[1,1,2]],[41,[1,1,2]],[49,[1,1,2]],[53,[1,1,2]]]],
 [10770,[[0,[1,1,2]],[9,[1,1,2]],[13,[1,1,2]],[21,[1,1,2]],[25,[1,1,2]],
     [33,[1,1,2]],[37,[1,1,2]],[45,[1,1,2]],[49,[1,1,2]],[57,[1,1,2]]]],
 [10772,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [10774,[[0,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [24,[1,1,1,1,2]],[33,[1,1,1,1,2]],[36,[1,1,1,1,2]],[45,[1,1,1,1,2]],
     [48,[1,1,1,1,2]],[57,[1,1,1,1,2]]]],
 [10776,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [10777,[[0,[1,2]],[1,[1,2]],[12,[1,2]],[13,[1,2]],[24,[1,2]],[25,[1,2]],
     [36,[1,2]],[37,[1,2]],[48,[1,2]],[49,[1,2]]]],
 [10778,[[0,[1]],[4,[1]],[8,[1]],[9,[1]],[12,[1]],[16,[1]],[20,[1]],
     [21,[1]],[24,[1]],[28,[1]]]],
 [10779,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [17,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [10780,[[0,[1]],[1,[1]],[4,[1]],[8,[1]],[12,[1]],[13,[1]],[16,[1]],
     [20,[1]],[24,[1]],[25,[1]]]],[10783,[[5,fail]]],[10784,[[1,fail]]],
 [10785,[[9,fail]]],
 [10793,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [10794,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [10795,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [10796,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [10810,[[3,[1]],[7,[1]],[11,[1]],[15,[1]],[19,[1]],[23,[1]],[27,[1]],
     [31,[1]],[35,[1]],[39,[1]]]],
 [10813,[[3,[1,1,1,2]],[7,[1,2]],[11,[1,1,1,2]],[15,[1,1,1,2]],[19,[1,2]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[31,[1,2]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [10816,[[3,[1]],[7,[1,2]],[11,[1]],[15,[1]],[19,[1,2]],[23,[1]],
     [27,[1]],[31,[1,2]],[35,[1]],[39,[1]]]],
 [10817,[[3,[1]],[7,[1]],[11,[1]],[15,[1]],[19,[1]],[23,[1]],[27,[1]],
     [31,[1]],[35,[1]],[39,[1]]]],
 [10822,[[3,[1,1,1,2]],[7,[1]],[11,[1,1,1,2]],[15,[1,1,1,2]],[19,[1]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[31,[1]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [10828,[[3,[1,1,1,2]],[7,[1,2]],[11,[1,1,1,2]],[15,[1,1,1,2]],[19,[1,2]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[31,[1,2]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [10829,[[3,[1,1,2]],[7,[1,2]],[11,[1,1,2]],[15,[1,1,2]],[19,[1,2]],
     [23,[1,1,2]],[27,[1,1,2]],[31,[1,2]],[35,[1,1,2]],[39,[1,1,2]]]],
 [10851,[[3,[1]],[4,[1,2]],[11,[1]],[12,[1,2]],[15,[1]],[20,[1,2]],
     [23,[1]],[27,[1]],[28,[1,2]],[35,[1]]]],
 [10852,[[0,[1,1,1,2]],[7,[1]],[8,[1,1,1,2]],[11,[1,1,1,2]],
     [16,[1,1,1,2]],[19,[1]],[23,[1,1,1,2]],[24,[1,1,1,2]],[31,[1]],
     [32,[1,1,1,2]]]],
 [10853,[[0,[1,1,1,2]],[4,[1,1,1,2]],[7,[1]],[12,[1,1,1,2]],
     [15,[1,1,1,2]],[19,[1]],[20,[1,1,1,2]],[27,[1,1,1,2]],
     [28,[1,1,1,2]],[31,[1]]]],
 [10855,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [10876,[[0,[1,1,1,1,2]],[11,[1,1,1,1,2]],[12,[1,1,1,1,2]],
     [23,[1,1,1,1,2]],[24,[1,1,1,1,2]],[35,[1,1,1,1,2]],[36,[1,1,1,1,2]],
     [47,[1,1,1,1,2]],[48,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [10880,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10882,[[4,[1]],[7,[1,2]],[16,[1]],[19,[1,2]],[28,[1]],[31,[1,2]],
     [40,[1]],[43,[1,2]],[52,[1]],[55,[1,2]]]],
 [10883,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10885,[[3,[1,2]],[4,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[16,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [10886,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[11,[1,2]],[12,[1,2]],[15,[1,2]],
     [19,[1,2]],[23,[1,2]],[24,[1,2]],[27,[1,2]]]],
 [10889,[[7,[1,2]],[8,[1]],[19,[1,2]],[20,[1]],[31,[1,2]],[32,[1]],
     [43,[1,2]],[44,[1]],[55,[1,2]],[56,[1]]]],
 [10891,[[3,[1,2]],[7,[1,2]],[8,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [20,[1,2]],[23,[1,2]],[27,[1,2]],[31,[1,2]]]],
 [10893,[[8,[1]],[11,[1,2]],[20,[1]],[23,[1,2]],[32,[1]],[35,[1,2]],
     [44,[1]],[47,[1,2]],[56,[1]],[59,[1,2]]]],
 [10895,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10896,[[3,[1,2]],[4,[1]],[15,[1,2]],[16,[1]],[27,[1,2]],[28,[1]],
     [39,[1,2]],[40,[1]],[51,[1,2]],[52,[1]]]],
 [10897,[[0,[1]],[3,[1,2]],[12,[1]],[15,[1,2]],[24,[1]],[27,[1,2]],
     [36,[1]],[39,[1,2]],[48,[1]],[51,[1,2]]]],
 [10898,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [10899,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [10900,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [10901,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [10907,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10908,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [10909,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10914,[[3,[1]],[7,[1]],[11,[1]],[15,[1]],[19,[1]],[23,[1]],[27,[1]],
     [31,[1]],[35,[1]],[39,[1]]]],
 [10935,[[0,[1,1,1,1,2]],[11,[1,1,1,1,2]],[12,[1,1,1,1,2]],
     [23,[1,1,1,1,2]],[24,[1,1,1,1,2]],[35,[1,1,1,1,2]],[36,[1,1,1,1,2]],
     [47,[1,1,1,1,2]],[48,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [10939,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [10941,[[4,[1,2]],[7,[1,2]],[16,[1,2]],[19,[1,2]],[28,[1,2]],[31,[1,2]],
     [40,[1,2]],[43,[1,2]],[52,[1,2]],[55,[1,2]]]],
 [10942,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [10944,[[3,[1,2]],[4,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[16,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [10945,[[0,[1]],[3,[1]],[7,[1]],[11,[1]],[12,[1]],[15,[1]],[19,[1]],
     [23,[1]],[24,[1]],[27,[1]]]],
 [10948,[[7,[1]],[8,[1,2]],[19,[1]],[20,[1,2]],[31,[1]],[32,[1,2]],
     [43,[1]],[44,[1,2]],[55,[1]],[56,[1,2]]]],
 [10950,[[3,[1]],[7,[1]],[8,[1]],[11,[1]],[15,[1]],[19,[1]],[20,[1]],
     [23,[1]],[27,[1]],[31,[1]]]],
 [10952,[[8,[1,2]],[11,[1,2]],[20,[1,2]],[23,[1,2]],[32,[1,2]],
     [35,[1,2]],[44,[1,2]],[47,[1,2]],[56,[1,2]],[59,[1,2]]]],
 [10954,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [10955,[[3,[1]],[4,[1,2]],[15,[1]],[16,[1,2]],[27,[1]],[28,[1,2]],
     [39,[1]],[40,[1,2]],[51,[1]],[52,[1,2]]]],
 [10956,[[0,[1,2]],[3,[1,2]],[12,[1,2]],[15,[1,2]],[24,[1,2]],[27,[1,2]],
     [36,[1,2]],[39,[1,2]],[48,[1,2]],[51,[1,2]]]],
 [10957,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [10958,[[4,[1,1,2]],[8,[1,1,2]],[16,[1,1,2]],[20,[1,1,2]],[28,[1,1,2]],
     [32,[1,1,2]],[40,[1,1,2]],[44,[1,1,2]],[52,[1,1,2]],[56,[1,1,2]]]],
 [10959,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [10960,[[0,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[44,[1,1,2]],[48,[1,1,2]],[56,[1,1,2]]]],
 [10966,[[4,fail]]],[10967,[[0,fail]]],[10968,[[8,fail]]],
 [10973,[[0,[1]],[5,[1]],[9,[1]],[13,[1]],[17,[1]],[21,[1]],[25,[1]],
     [29,[1]],[33,[1]],[37,[1]]]],
 [10975,[[0,[2]],[5,[2]],[9,[2]],[13,[2]],[17,[2]],[21,[2]],[25,[2]],
     [29,[2]],[33,[2]],[37,[2]]]],
 [10976,[[13,[1]],[33,[1]],[53,[1]],[73,[1]],[93,[1]],[113,[1]],
     [133,[1]],[153,[1]],[173,[1]],[193,[1]]]],
 [10980,[[15,[1]],[35,[1]],[55,[1]],[75,[1]],[95,[1]],[115,[1]],
     [135,[1]],[155,[1]],[175,[1]],[195,[1]]]],
 [10981,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [10982,[[9,[1,2]],[29,[1,2]],[49,[1,2]],[69,[1,2]],[89,[1,2]],
     [109,[1,2]],[129,[1,2]],[149,[1,2]],[169,[1,2]],[189,[1,2]]]],
 [10983,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [10984,[[15,[1,2]],[35,[1,2]],[55,[1,2]],[75,[1,2]],[95,[1,2]],
     [115,[1,2]],[135,[1,2]],[155,[1,2]],[175,[1,2]],[195,[1,2]]]],
 [10987,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [10991,[[0,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [10997,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [10999,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [11002,[[3,[1,2]],[7,[1,2]],[9,[1,2]],[15,[1,2]],[19,[1,2]],[21,[1,2]],
     [27,[1,2]],[31,[1,2]],[33,[1,2]],[39,[1,2]]]],[11003,[[0,fail]]],
 [11004,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [11005,[[7,[1]],[11,[1]],[19,[1]],[23,[1]],[31,[1]],[35,[1]],[43,[1]],
     [47,[1]],[55,[1]],[59,[1]]]],[11008,[[3,fail]]],
 [11010,[[11,[2,3]],[23,[2,3]],[35,[2,3]],[47,[2,3]],[59,[2,3]],
     [71,[2,3]],[83,[2,3]],[95,[2,3]],[107,[2,3]],[119,[2,3]]]],
 [11012,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[15,[1,2]],[17,[1,2]],[21,[1,2]],
     [27,[1,2]],[29,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [11013,[[3,[1]],[7,[1]],[15,[1]],[19,[1]],[27,[1]],[31,[1]],[39,[1]],
     [43,[1]],[51,[1]],[55,[1]]]],
 [11014,[[0,[3]],[7,[3]],[13,[3]],[19,[3]],[25,[3]],[31,[3]],[37,[3]],
     [43,[3]],[49,[3]],[55,[3]]]],
 [11015,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [11028,[[3,[1]],[5,[1,2]],[9,[1,2]],[11,[1]],[15,[1]],[17,[1,2]],
     [21,[1,2]],[23,[1]],[27,[1]],[29,[1,2]]]],
 [11029,[[0,[1,1,1,2]],[5,[1,1,1,2]],[7,[1,1,1,2]],[11,[1,1,1,2]],
     [13,[1,1,1,2]],[17,[1,1,1,2]],[19,[1,1,1,2]],[23,[1,1,1,2]],
     [25,[1,1,1,2]],[29,[1,1,1,2]]]],
 [11030,[[0,[1,2]],[3,[1]],[7,[1]],[9,[1,2]],[13,[1,2]],[15,[1]],
     [19,[1]],[21,[1,2]],[25,[1,2]],[27,[1]]]],
 [11031,[[0,[1]],[4,[1]],[8,[1]],[12,[1]],[16,[1]],[20,[1]],[24,[1]],
     [28,[1]],[32,[1]],[36,[1]]]],
 [11032,[[1,[1]],[5,[1]],[9,[1]],[13,[1]],[17,[1]],[21,[1]],[25,[1]],
     [29,[1]],[33,[1]],[37,[1]]]],
 [11054,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11056,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [11057,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [11059,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[12,[1]],[16,[1]],[17,[1]],
     [21,[1]],[24,[1]],[28,[1]]]],
 [11060,[[0,[1]],[1,[1]],[5,[1]],[8,[1]],[12,[1]],[13,[1]],[17,[1]],
     [20,[1]],[24,[1]],[25,[1]]]],
 [11065,[[0,[1]],[4,[1]],[8,[1]],[9,[1]],[13,[1]],[16,[1]],[20,[1]],
     [21,[1]],[25,[1]],[28,[1]]]],
 [11067,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11071,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [11072,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [11073,[[0,[1]],[5,[1]],[8,[1]],[9,[1]],[12,[1]],[17,[1]],[20,[1]],
     [21,[1]],[24,[1]],[29,[1]]]],
 [11074,[[1,[1]],[4,[1]],[5,[1]],[8,[1]],[13,[1]],[16,[1]],[17,[1]],
     [20,[1]],[25,[1]],[28,[1]]]],
 [11075,[[0,[1]],[1,[1]],[4,[1]],[9,[1]],[12,[1]],[13,[1]],[16,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [11088,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [11100,[[0,[1]],[3,[1]],[8,[1]],[12,[1]],[15,[1]],[20,[1]],[24,[1]],
     [27,[1]],[32,[1]],[36,[1]]]],
 [11101,[[0,[1,1,1,2]],[4,[1,2]],[8,[1,1,1,2]],[12,[1,1,1,2]],[16,[1,2]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[28,[1,2]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [11107,[[0,[1]],[4,[1]],[7,[1]],[12,[1]],[16,[1]],[19,[1]],[24,[1]],
     [28,[1]],[31,[1]],[36,[1]]]],
 [11108,[[0,[1,1,1,2]],[4,[1,2]],[8,[1,1,1,2]],[12,[1,1,1,2]],[16,[1,2]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[28,[1,2]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [11113,[[0,[1,1,1,2]],[4,[1]],[8,[1,1,1,2]],[12,[1,1,1,2]],[16,[1]],
     [20,[1,1,1,2]],[24,[1,1,1,2]],[28,[1]],[32,[1,1,1,2]],
     [36,[1,1,1,2]]]],
 [11114,[[0,[1,1,2]],[4,[1,2]],[7,[1,1,2]],[12,[1,1,2]],[16,[1,2]],
     [19,[1,1,2]],[24,[1,1,2]],[28,[1,2]],[31,[1,1,2]],[36,[1,1,2]]]],
 [11125,[[0,[1]],[4,[1,2]],[8,[1]],[12,[1]],[16,[1,2]],[20,[1]],
     [24,[1]],[28,[1,2]],[32,[1]],[36,[1]]]],
 [11132,[[0,[1]],[3,[1,2]],[8,[1]],[11,[1,2]],[12,[1]],[19,[1,2]],
     [20,[1]],[24,[1]],[27,[1,2]],[32,[1]]]],
 [11133,[[0,[1,1,1,2]],[4,[1]],[7,[1,1,1,2]],[12,[1,1,1,2]],
     [15,[1,1,1,2]],[16,[1]],[23,[1,1,1,2]],[24,[1,1,1,2]],[28,[1]],
     [31,[1,1,1,2]]]],
 [11140,[[0,[1,1,1,2]],[4,[1]],[8,[1,1,1,2]],[11,[1,1,1,2]],[16,[1]],
     [19,[1,1,1,2]],[20,[1,1,1,2]],[27,[1,1,1,2]],[28,[1]],
     [32,[1,1,1,2]]]],
 [11144,[[8,[1,2]],[28,[1,2]],[48,[1,2]],[68,[1,2]],[88,[1,2]],
     [108,[1,2]],[128,[1,2]],[148,[1,2]],[168,[1,2]],[188,[1,2]]]],
 [11146,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [11148,[[4,[1]],[24,[1]],[44,[1]],[64,[1]],[84,[1]],[104,[1]],
     [124,[1]],[144,[1]],[164,[1]],[184,[1]]]],
 [11149,[[1,[1,2]],[21,[1,2]],[41,[1,2]],[61,[1,2]],[81,[1,2]],
     [101,[1,2]],[121,[1,2]],[141,[1,2]],[161,[1,2]],[181,[1,2]]]],
 [11150,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [11152,[[9,[1]],[29,[1]],[49,[1]],[69,[1]],[89,[1]],[109,[1]],
     [129,[1]],[149,[1]],[169,[1]],[189,[1]]]],
 [11154,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [11156,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [11160,[[4,[1]],[5,[1]],[16,[1]],[17,[1]],[28,[1]],[29,[1]],[40,[1]],
     [41,[1]],[52,[1]],[53,[1]]]],
 [11161,[[1,[1,2]],[5,[1,2]],[8,[1,2]],[13,[1,2]],[17,[1,2]],[20,[1,2]],
     [25,[1,2]],[29,[1,2]],[32,[1,2]],[37,[1,2]]]],
 [11162,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [11165,[[4,[3]],[9,[3]],[16,[3]],[21,[3]],[28,[3]],[33,[3]],[40,[3]],
     [45,[3]],[52,[3]],[57,[3]]]],
 [11168,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [11175,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [11178,[[4,[1,2]],[9,[1,2]],[16,[1,2]],[21,[1,2]],[28,[1,2]],[33,[1,2]],
     [40,[1,2]],[45,[1,2]],[52,[1,2]],[57,[1,2]]]],
 [11182,[[0,[1,2]],[5,[1,2]],[12,[1,2]],[17,[1,2]],[24,[1,2]],[29,[1,2]],
     [36,[1,2]],[41,[1,2]],[48,[1,2]],[53,[1,2]]]],
 [11183,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [11184,[[4,fail]]],
 [11185,[[1,[1,2]],[4,[1,2]],[8,[1,2]],[13,[1,2]],[16,[1,2]],[20,[1,2]],
     [25,[1,2]],[28,[1,2]],[32,[1,2]],[37,[1,2]]]],[11186,[[0,fail]]],
 [11187,[[0,[1]],[1,[1,2]],[5,[1,2]],[8,[1]],[12,[1]],[13,[1,2]],
     [17,[1,2]],[20,[1]],[24,[1]],[25,[1,2]]]],
 [11188,[[0,[1,1,1,2]],[4,[1,1,1,2]],[5,[1,1,1,2]],[9,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[17,[1,1,1,2]],[21,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [11195,[[1,[1,2]],[4,[1]],[8,[1]],[9,[1,2]],[13,[1,2]],[16,[1]],
     [20,[1]],[21,[1,2]],[25,[1,2]],[28,[1]]]],
 [11214,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [11215,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [11219,[[8,[1,1,1,1,2,1,1,2]],[20,[1,1,1,1,2,1,1,2]],[23,[1,1,1,1,2,1,1,2]]
      ,[32,[1]],[53,[1,1,1,1,2,1,1,2]],[56,[1,1,1,1,2,1,1,2]],
     [68,[1,1,1,1,2,1,1,2]],[80,[1,1,1,1,2,1,1,2]],[83,[1,1,1,1,2,1,1,2]],
     [92,[1]]]],
 [11221,[[7,[1,1,1,1,1,1,2,2]],[17,[1,1,1,1,1,1,2,2]],[21,[1,1,1,1,1,1,2,2]]
      ,[31,[1]],[52,[1,1,1,1,1,1,2,2]],[55,[1,1,1,1,1,1,2,2]],
     [67,[1,1,1,1,1,1,2,2]],[77,[1,1,1,1,1,1,2,2]],[81,[1,1,1,1,1,1,2,2]],
     [91,[1]]]],
 [11222,[[1,[1,1,1,1,1,1,1,2]],[16,[1,1,1,1,1,1,1,2]],[28,[1,2]],
     [31,[1,1,1,1,1,1,1,2]],[40,[1,1,1,1,1,1,1,2]],[52,[1,1,1,1,1,1,1,2]],
     [61,[1,1,1,1,1,1,1,2]],[76,[1,1,1,1,1,1,1,2]],[88,[1,2]],
     [91,[1,1,1,1,1,1,1,2]]]],
 [11223,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [11224,[[3,[1,1,1,1,2,2,1,2]],[5,[1,1,1,1,2,2,1,2]],[15,[1,1,1,1,2,2,1,2]],
     [17,[1,1,1,1,2,2,1,2]],[21,[1]],[23,[1,1,1,1,2,2,1,2]],
     [28,[1,1,1,1,2,2,1,2]],[33,[1,1,1,1,2,2,1,2]],[35,[1,1,1,1,2,2,1,2]],
     [41,[1]]]],
 [11225,[[1,[1,2]],[7,[1,2]],[17,[2]],[23,[1,2]],[27,[1,2]],[37,[2]],
     [41,[1,2]],[43,[1,2]],[47,[1,2]],[48,[1,2]]]],
 [11232,[[11,[1,1,1,1,2,1,1,2]],[13,[1,1,1,1,2,1,1,2]],[35,[1]],
     [43,[1,1,1,1,2,1,1,2]],[47,[1,1,1,1,2,1,1,2]],[57,[1,1,1,1,2,1,1,2]],
     [71,[1,1,1,1,2,1,1,2]],[73,[1,1,1,1,2,1,1,2]],[95,[1]],
     [103,[1,1,1,1,2,1,1,2]]]],
 [11234,[[8,[1,1,1,1,2]],[23,[1,1,1,1,2]],[53,[1,1,1,1,2]],
     [68,[1,1,1,1,2]],[83,[1,1,1,1,2]],[113,[1,1,1,1,2]],
     [128,[1,1,1,1,2]],[143,[1,1,1,1,2]],[173,[1,1,1,1,2]],
     [188,[1,1,1,1,2]]]],
 [11236,[[0,[1,1,1,1,1,1,1,2]],[12,[1,1,1,1,1,1,1,2]],[15,[1,1,1,1,1,1,1,2]]
      ,[27,[1,2]],[37,[1,1,1,1,1,1,1,2]],[41,[1,1,1,1,1,1,1,2]],
     [51,[1,1,1,1,1,1,1,2]],[60,[1,1,1,1,1,1,1,2]],[72,[1,1,1,1,1,1,1,2]],
     [75,[1,1,1,1,1,1,1,2]]]],
 [11237,[[0,[1,1,1,1,2,1,1,2]],[8,[1]],[12,[1,1,1,1,2,1,1,2]],[27,[1]],
     [36,[1,1,1,1,2,1,1,2]],[37,[1]],[48,[1,1,1,1,2,1,1,2]],
     [60,[1,1,1,1,2,1,1,2]],[68,[1]],[72,[1,1,1,1,2,1,1,2]]]],
 [11238,[[3,[1]],[23,[1]],[33,[1]],[53,[1]],[63,[1]],[83,[1]],[93,[1]],
     [113,[1]],[123,[1]],[143,[1]]]],
 [11239,[[1,[1,1,1,1,1,1,2,2]],[5,[1,1,1,1,1,1,2,2]],[12,[1,2]],
     [13,[1,1,1,1,1,1,2,2]],[17,[1,2]],[25,[1,1,1,1,1,1,2,2]],
     [28,[1,1,1,1,1,1,2,2]],[32,[1,2]],[41,[1,1,1,1,1,1,2,2]],
     [48,[1,1,1,1,1,1,2,2]]]],
 [11240,[[0,[1,2]],[3,[1,2]],[8,[2]],[20,[1,2]],[25,[1,2]],[37,[1,2]],
     [40,[1,2]],[43,[1,2]],[45,[1,2]],[48,[2]]]],
 [11267,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [11272,[[5,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],[32,[1,2]],
     [35,[1,1,1,1,1,1,1,2]],[44,[1,1,1,1,1,1,1,2]],[56,[1,1,1,1,1,1,1,2]],
     [65,[1,1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,1,2]],[92,[1,2]],
     [95,[1,1,1,1,1,1,1,2]]]],
 [11274,[[4,[1,1,1,1,1,1,1,2]],[16,[1,1,1,1,1,1,1,2]],[19,[1,1,1,1,1,1,1,2]]
      ,[31,[1,2]],[41,[1,1,1,1,1,1,1,2]],[45,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]],[64,[1,1,1,1,1,1,1,2]],[76,[1,1,1,1,1,1,1,2]],
     [79,[1,1,1,1,1,1,1,2]]]],
 [11275,[[4,[1,1,1,1,2,1,1,2]],[12,[1]],[16,[1,1,1,1,2,1,1,2]],[31,[1]],
     [40,[1,1,1,1,2,1,1,2]],[41,[1]],[52,[1,1,1,1,2,1,1,2]],
     [64,[1,1,1,1,2,1,1,2]],[72,[1]],[76,[1,1,1,1,2,1,1,2]]]],
 [11277,[[5,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,1,2]],
     [17,[1,1,1,1,1,1,1,2]],[21,[3]],[29,[1,1,1,1,1,1,1,2]],
     [31,[1,1,1,1,1,1,1,2]],[41,[3]],[45,[1,1,1,1,1,1,1,2]],
     [51,[1,1,1,1,1,1,1,2]]]],
 [11278,[[1,[1,1,1,1,2,2]],[7,[1,1,1,1,2,2]],[29,[1,1,1,1,2,2]],
     [41,[1,1,1,1,2,2]],[47,[1,1,1,1,2,2]],[49,[1,1,1,1,2,2]],
     [61,[1,1,1,1,2,2]],[67,[1,1,1,1,2,2]],[89,[1,1,1,1,2,2]],
     [101,[1,1,1,1,2,2]]]],
 [11283,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],
 [11285,[[11,[1,1,1,1,1,1,2,2]],[21,[1,1,1,1,1,1,2,2]],
     [25,[1,1,1,1,1,1,2,2]],[35,[1]],[56,[1,1,1,1,1,1,2,2]],
     [59,[1,1,1,1,1,1,2,2]],[71,[1,1,1,1,1,1,2,2]],[81,[1,1,1,1,1,1,2,2]],
     [85,[1,1,1,1,1,1,2,2]],[95,[1]]]],
 [11289,[[1,[1,1,1,1,2,1,1,2]],[12,[1]],[15,[1,1,1,1,2,1,1,2]],[24,[1]],
     [39,[1,1,1,1,2,1,1,2]],[41,[1]],[51,[1,1,1,1,2,1,1,2]],
     [61,[1,1,1,1,2,1,1,2]],[72,[1]],[75,[1,1,1,1,2,1,1,2]]]],
 [11290,[[0,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[12,[1,1,1,1,1,1,1,2]],
     [24,[1,2]],[36,[1,1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,1,2]],
     [51,[1,1,1,1,1,1,1,2]],[60,[1,1,1,1,1,1,1,2]],[69,[1,1,1,1,1,1,1,2]],
     [72,[1,1,1,1,1,1,1,2]]]],
 [11292,[[0,[1,1,1,2,1,1,2,2]],[5,[1,1,1,2,1,1,2,2]],[7,[1]],
     [12,[1,1,1,2,1,1,2,2]],[17,[1]],[20,[1,1,1,2,1,1,2,2]],
     [25,[1,1,1,2,1,1,2,2]],[29,[1,1,1,2,1,1,2,2]],[37,[1]],
     [40,[1,1,1,2,1,1,2,2]]]],
 [11319,[[12,[1,2]],[41,[1,2]],[72,[1,2]],[101,[1,2]],[132,[1,2]],
     [161,[1,2]],[192,[1,2]],[221,[1,2]],[252,[1,2]]]],
 [11320,[[17,[1,2]],[27,[1]],[47,[1,2]],[77,[1,2]],[87,[1]],[107,[1,2]],
     [137,[1,2]],[147,[1]],[167,[1,2]],[197,[1,2]]]],
 [11324,[[8,[1,1,2,1,1,2,2,2]],[20,[1,1,2,1,1,2,2,2]],[32,[1,2]],
     [41,[1,1,2,1,1,2,2,2]],[56,[1,1,2,1,1,2,2,2]],[68,[1,1,2,1,1,2,2,2]],
     [80,[1,1,2,1,1,2,2,2]],[92,[1,2]],[101,[1,1,2,1,1,2,2,2]],
     [116,[1,1,2,1,1,2,2,2]]]],
 [11326,[[7,[1,1,1,1,2,1,2,2]],[17,[1,1,1,1,2,1,2,2]],[31,[2]],
     [43,[1,1,1,1,2,1,2,2]],[55,[1,1,1,1,2,1,2,2]],[67,[1,1,1,1,2,1,2,2]],
     [77,[1,1,1,1,2,1,2,2]],[91,[2]],[103,[1,1,1,1,2,1,2,2]],
     [115,[1,1,1,1,2,1,2,2]]]],
 [11327,[[1,[1,1,1,2,2,2,1,2]],[16,[1,1,1,2,2,2,1,2]],[28,[1,2]],
     [40,[1,1,1,2,2,2,1,2]],[52,[1,1,1,2,2,2,1,2]],[61,[1,1,1,2,2,2,1,2]],
     [76,[1,1,1,2,2,2,1,2]],[88,[1,2]],[100,[1,1,1,2,2,2,1,2]],
     [112,[1,1,1,2,2,2,1,2]]]],
 [11328,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [11329,[[5,[1,1,2,2,2,2,1,2]],[7,[1,1,2,2,2,2,1,2]],[11,[1,1,2,2,2,2,1,2]],
     [15,[1,2]],[17,[1,1,2,2,2,2,1,2]],[21,[1,2]],[27,[1,1,2,2,2,2,1,2]],
     [31,[1,1,2,2,2,2,1,2]],[35,[1,2]],[45,[1,1,2,2,2,2,1,2]]]],
 [11330,[[3,[1]],[17,[2,2,3]],[23,[1]],[27,[1]],[37,[2,2,3]],[41,[1]],
     [43,[1]],[47,[1]],[63,[1]],[77,[2,2,3]]]],
 [11337,[[11,[1,2,2,1,2,2,2,3]],[23,[1,2,2,1,2,2,2,3]],[35,[1]],
     [47,[1,2,2,1,2,2,2,3]],[57,[1,2,2,1,2,2,2,3]],[71,[1,2,2,1,2,2,2,3]],
     [83,[1,2,2,1,2,2,2,3]],[95,[1]],[107,[1,2,2,1,2,2,2,3]],
     [117,[1,2,2,1,2,2,2,3]]]],
 [11339,[[3,[1,1,1,1,2]],[32,[1,1,1,1,2]],[48,[1,1,1,1,2]],
     [63,[1,1,1,1,2]],[92,[1,1,1,1,2]],[108,[1,1,1,1,2]],
     [123,[1,1,1,1,2]],[152,[1,1,1,1,2]],[168,[1,1,1,1,2]],
     [183,[1,1,1,1,2]]]],
 [11345,[[1,[1]],[12,[1]],[16,[1]],[21,[1]],[32,[1]],[36,[1]],[37,[1]],
     [56,[1]],[61,[1]],[72,[1]]]],[11349,[[7,fail]]],[11352,[[12,fail]]],
 [11375,[[8,[1,1,1,1,2,1,1,2]],[16,[1]],[20,[1,1,1,1,2,1,1,2]],[35,[1]],
     [44,[1,1,1,1,2,1,1,2]],[45,[1]],[56,[1,1,1,1,2,1,1,2]],
     [68,[1,1,1,1,2,1,1,2]],[76,[1]],[80,[1,1,1,1,2,1,1,2]]]],
 [11377,[[5,[1,1,1,1,2,1,1,2]],[16,[1]],[19,[1,1,1,1,2,1,1,2]],[28,[1]],
     [43,[1,1,1,1,2,1,1,2]],[45,[1]],[55,[1,1,1,1,2,1,1,2]],
     [65,[1,1,1,1,2,1,1,2]],[76,[1]],[79,[1,1,1,1,2,1,1,2]]]],
 [11378,[[4,[1,1,1,1,1,1,1,2]],[13,[1,1,1,1,1,1,1,2]],[16,[1,1,1,1,1,1,1,2]]
      ,[28,[1,2]],[40,[1,1,1,1,1,1,1,2]],[43,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]],[64,[1,1,1,1,1,1,1,2]],[73,[1,1,1,1,1,1,1,2]],
     [76,[1,1,1,1,1,1,1,2]]]],
 [11380,[[5,[1,1,1,2,1,1,2,2]],[9,[1,1,1,2,1,1,2,2]],[11,[1]],
     [16,[1,1,1,2,1,1,2,2]],[19,[1,1,1,2,1,1,2,2]],[21,[1]],
     [29,[1,1,1,2,1,1,2,2]],[33,[1,1,1,2,1,1,2,2]],[39,[1,1,1,2,1,1,2,2]],
     [41,[1]]]],
 [11388,[[8,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],[23,[1,1,1,1,1,1,1,2]]
      ,[35,[1,2]],[45,[1,1,1,1,1,1,1,2]],[49,[1,1,1,1,1,1,1,2]],
     [59,[1,1,1,1,1,1,1,2]],[68,[1,1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,1,2]],
     [83,[1,1,1,1,1,1,1,2]]]],
 [11391,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [11392,[[3,[1,1,1,1,1,1,1,2]],[15,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]]
      ,[25,[1,2]],[39,[1,1,1,1,1,1,1,2]],[53,[1,1,1,1,1,1,1,2]],
     [63,[1,1,1,1,1,1,1,2]],[75,[1,1,1,1,1,1,1,2]],[84,[1,1,1,1,1,1,1,2]],
     [85,[1,2]]]],
 [11393,[[0,[1,1,1,1,1,1,2,2]],[3,[1,1,1,1,1,1,2,2]],[24,[1]],
     [33,[1,1,1,1,1,1,2,2]],[36,[1,1,1,1,1,1,2,2]],[48,[1,1,1,1,1,1,2,2]],
     [60,[1,1,1,1,1,1,2,2]],[63,[1,1,1,1,1,1,2,2]],[84,[1]],
     [93,[1,1,1,1,1,1,2,2]]]],
 [11394,[[9,[1,1,1,1,2,2]],[11,[1,1,1,1,2,2]],[16,[1,1,1,1,2,2]],
     [29,[1,1,1,1,2,2]],[51,[1,1,1,1,2,2]],[56,[1,1,1,1,2,2]],
     [69,[1,1,1,1,2,2]],[71,[1,1,1,1,2,2]],[76,[1,1,1,1,2,2]],
     [89,[1,1,1,1,2,2]]]],
 [11395,[[1,[1,1,1,1,1,1,1,2]],[5,[1,1,1,1,1,1,1,2]],[8,[1,1,1,1,1,1,1,2]],
     [13,[1,1,1,1,1,1,1,2]],[16,[3]],[28,[1,1,1,1,1,1,1,2]],
     [29,[1,1,1,1,1,1,1,2]],[36,[3]],[41,[1,1,1,1,1,1,1,2]],
     [48,[1,1,1,1,1,1,1,2]]]],
 [11396,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [11420,[[32,[1]],[92,[1]],[152,[1]],[212,[1]]]],
 [11425,[[5,[1,1,1,2,2,2,1,2]],[20,[1,1,1,2,2,2,1,2]],[32,[1,2]],
     [44,[1,1,1,2,2,2,1,2]],[56,[1,1,1,2,2,2,1,2]],[65,[1,1,1,2,2,2,1,2]],
     [80,[1,1,1,2,2,2,1,2]],[92,[1,2]],[104,[1,1,1,2,2,2,1,2]],
     [116,[1,1,1,2,2,2,1,2]]]],
 [11431,[[11,[1,1,2]],[51,[1,1,2]],[71,[1,1,2]],[111,[1,1,2]],
     [131,[1,1,2]],[171,[1,1,2]],[191,[1,1,2]],[231,[1,1,2]],
     [251,[1,1,2]]]],
 [11438,[[11,[1,1,1,1,2,1,2,2]],[21,[1,1,1,1,2,1,2,2]],[35,[2]],
     [47,[1,1,1,1,2,1,2,2]],[59,[1,1,1,1,2,1,2,2]],[71,[1,1,1,1,2,1,2,2]],
     [81,[1,1,1,1,2,1,2,2]],[95,[2]],[107,[1,1,1,1,2,1,2,2]],
     [119,[1,1,1,1,2,1,2,2]]]],
 [11441,[[27,[1]],[87,[1]],[147,[1]],[207,[1]]]],
 [11442,[[1,[1,1,1,2,2,2,1,2]],[15,[1,1,1,2,2,2,1,2]],[27,[1,2]],
     [39,[1,1,1,2,2,2,1,2]],[51,[1,1,1,2,2,2,1,2]],[61,[1,1,1,2,2,2,1,2]],
     [75,[1,1,1,2,2,2,1,2]],[87,[1,2]],[99,[1,1,1,2,2,2,1,2]],
     [111,[1,1,1,2,2,2,1,2]]]],
 [11443,[[0,[1,1,1,1,2,1,2,2]],[12,[1,1,1,1,2,1,2,2]],[24,[2]],
     [36,[1,1,1,1,2,1,2,2]],[45,[1,1,1,1,2,1,2,2]],[60,[1,1,1,1,2,1,2,2]],
     [72,[1,1,1,1,2,1,2,2]],[84,[2]],[96,[1,1,1,1,2,1,2,2]],
     [105,[1,1,1,1,2,1,2,2]]]],
 [11444,[[5,[1,1,2]],[45,[1,1,2]],[65,[1,1,2]],[105,[1,1,2]],[125,[1,1,2]],
     [165,[1,1,2]],[185,[1,1,2]],[225,[1,1,2]],[245,[1,1,2]]]],
 [11449,[[11,fail]]],[11452,[[16,fail]]],
 [11469,[[35,[1,1,2]],[95,[1,1,2]],[155,[1,1,2]],[215,[1,1,2]]]],
 [11470,[[32,[1]],[35,[1]],[92,[1]],[95,[1]],[152,[1]],[155,[1]],
     [212,[1]],[215,[1]]]],
 [11474,[[8,[1,1,1,2,2,3,4,2]],[20,[1,1,1,2,2,3,4,2]],[32,[1,2]],
     [41,[1,1,1,2,2,3,4,2]],[56,[1,1,1,2,2,3,4,2]],[68,[1,1,1,2,2,3,4,2]],
     [80,[1,1,1,2,2,3,4,2]],[92,[1,2]],[101,[1,1,1,2,2,3,4,2]],
     [116,[1,1,1,2,2,3,4,2]]]],
 [11476,[[7,[1,2,1,2,2,1,2,3]],[16,[1,2,1,2,2,1,2,3]],[31,[2]],
     [43,[1,2,1,2,2,1,2,3]],[55,[1,2,1,2,2,1,2,3]],[67,[1,2,1,2,2,1,2,3]],
     [76,[1,2,1,2,2,1,2,3]],[91,[2]],[103,[1,2,1,2,2,1,2,3]],
     [115,[1,2,1,2,2,1,2,3]]]],
 [11477,[[1,[1,1,2,3,3,3,2,2]],[16,[1,1,2,3,3,3,2,2]],[28,[1]],
     [40,[1,1,2,3,3,3,2,2]],[52,[1,1,2,3,3,3,2,2]],[61,[1,1,2,3,3,3,2,2]],
     [76,[1,1,2,3,3,3,2,2]],[88,[1]],[100,[1,1,2,3,3,3,2,2]],
     [112,[1,1,2,3,3,3,2,2]]]],
 [11480,[[7,[1,2]],[11,[2]],[27,[1,2]],[41,[1,2]],[47,[1,2]],[51,[2]],
     [67,[1,2]],[71,[2]],[87,[1,2]],[101,[1,2]]]],
 [11485,[[11,[2,3,4,5]],[16,[2,3,4,5]],[31,[2,3,4,5]],[56,[2,3,4,5]],
     [71,[2,3,4,5]],[76,[2,3,4,5]],[91,[2,3,4,5]],[116,[2,3,4,5]],
     [131,[2,3,4,5]],[136,[2,3,4,5]]]],
 [11487,[[11,[1,1,2,2,2,2,2,4]],[23,[1,1,2,2,2,2,2,4]],[35,[2]],
     [47,[1,1,2,2,2,2,2,4]],[56,[1,1,2,2,2,2,2,4]],[71,[1,1,2,2,2,2,2,4]],
     [83,[1,1,2,2,2,2,2,4]],[95,[2]],[107,[1,1,2,2,2,2,2,4]],
     [116,[1,1,2,2,2,2,2,4]]]],
 [11491,[[3,[1,1,2,3,3,3,2,2]],[15,[1,1,2,3,3,3,2,2]],[27,[1]],
     [36,[1,1,2,3,3,3,2,2]],[51,[1,1,2,3,3,3,2,2]],[63,[1,1,2,3,3,3,2,2]],
     [75,[1,1,2,3,3,3,2,2]],[87,[1]],[96,[1,1,2,3,3,3,2,2]],
     [111,[1,1,2,3,3,3,2,2]]]],
 [11492,[[0,[1,2,1,2,2,1,2,3]],[12,[1,2,1,2,2,1,2,3]],[21,[2]],
     [36,[1,2,1,2,2,1,2,3]],[48,[1,2,1,2,2,1,2,3]],[60,[1,2,1,2,2,1,2,3]],
     [72,[1,2,1,2,2,1,2,3]],[81,[2]],[96,[1,2,1,2,2,1,2,3]],
     [108,[1,2,1,2,2,1,2,3]]]],
 [11493,[[5,[2,3]],[8,[2,3]],[28,[2,3]],[36,[2,3]],[48,[2,3]],[56,[2,3]],
     [65,[2,3]],[68,[2,3]],[88,[2,3]],[96,[2,3]]]],[11498,[[25,fail]]],
 [11502,[[25,fail]]],
 [11518,[[5,[1,1,1,1,2]],[35,[1,1,1,1,2]],[49,[1,1,1,1,2]],
     [65,[1,1,1,1,2]],[95,[1,1,1,1,2]],[109,[1,1,1,1,2]],
     [125,[1,1,1,1,2]],[155,[1,1,1,1,2]],[169,[1,1,1,1,2]],
     [185,[1,1,1,1,2]]]],
 [11522,[[8,[1,1,1,1,1,1,1,2]],[17,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]]
      ,[32,[1,2]],[44,[1,1,1,1,1,1,1,2]],[47,[1,1,1,1,1,1,1,2]],
     [59,[1,1,1,1,1,1,1,2]],[68,[1,1,1,1,1,1,1,2]],[77,[1,1,1,1,1,1,1,2]],
     [80,[1,1,1,1,1,1,1,2]]]],
 [11524,[[7,[1,1,1,1,1,1,1,2]],[19,[1,1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,1,2]]
      ,[29,[1,2]],[43,[1,1,1,1,1,1,1,2]],[57,[1,1,1,1,1,1,1,2]],
     [67,[1,1,1,1,1,1,1,2]],[79,[1,1,1,1,1,1,1,2]],[88,[1,1,1,1,1,1,1,2]],
     [89,[1,2]]]],
 [11525,[[4,[1,1,1,1,1,1,2,2]],[7,[1,1,1,1,1,1,2,2]],[28,[1]],
     [37,[1,1,1,1,1,1,2,2]],[40,[1,1,1,1,1,1,2,2]],[52,[1,1,1,1,1,1,2,2]],
     [64,[1,1,1,1,1,1,2,2]],[67,[1,1,1,1,1,1,2,2]],[88,[1]],
     [97,[1,1,1,1,1,1,2,2]]]],
 [11527,[[5,[1,1,1,1,1,1,2,2]],[7,[1,2]],[9,[1,1,1,1,1,1,2,2]],
     [17,[1,1,1,1,1,1,2,2]],[27,[1,2]],[29,[1,1,1,1,1,1,2,2]],
     [33,[1,1,1,1,1,1,2,2]],[40,[1,2]],[45,[1,1,1,1,1,1,2,2]],[47,[1,2]] 
    ]],
 [11528,[[5,[1]],[25,[1]],[35,[1]],[55,[1]],[65,[1]],[85,[1]],[95,[1]],
     [115,[1]],[125,[1]],[145,[1]]]],
 [11531,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [11533,[[9,[2]],[13,[1,2]],[15,[1,2]],[19,[1,2]],[20,[1,2]],[33,[1,2]],
     [39,[1,2]],[49,[2]],[55,[1,2]],[59,[1,2]]]],
 [11535,[[9,[1,1,1,1,2,1,1,2]],[20,[1]],[23,[1,1,1,1,2,1,1,2]],[32,[1]],
     [47,[1,1,1,1,2,1,1,2]],[49,[1]],[59,[1,1,1,1,2,1,1,2]],
     [69,[1,1,1,1,2,1,1,2]],[80,[1]],[83,[1,1,1,1,2,1,1,2]]]],
 [11537,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [11538,[[29,[1]],[89,[1]],[149,[1]],[209,[1]]]],
 [11539,[[3,[1,1,1,1,2,1,1,2]],[5,[1,1,1,1,2,1,1,2]],[27,[1]],
     [35,[1,1,1,1,2,1,1,2]],[39,[1,1,1,1,2,1,1,2]],[49,[1,1,1,1,2,1,1,2]],
     [63,[1,1,1,1,2,1,1,2]],[65,[1,1,1,1,2,1,1,2]],[87,[1]],
     [95,[1,1,1,1,2,1,1,2]]]],
 [11540,[[0,[1,1,1,1,2,1,1,2]],[12,[1,1,1,1,2,1,1,2]],[15,[1,1,1,1,2,1,1,2]]
      ,[24,[1]],[45,[1,1,1,1,2,1,1,2]],[48,[1,1,1,1,2,1,1,2]],
     [60,[1,1,1,1,2,1,1,2]],[72,[1,1,1,1,2,1,1,2]],[75,[1,1,1,1,2,1,1,2]],
     [84,[1]]]],
 [11541,[[9,[1,2]],[12,[1,2]],[15,[1,2]],[17,[1,2]],[20,[2]],[32,[1,2]],
     [35,[1,2]],[40,[2]],[52,[1,2]],[57,[1,2]]]],
 [11542,[[0,[1,1,1,1,2,2,1,2]],[4,[1,1,1,1,2,2,1,2]],[5,[1,1,1,1,2,2,1,2]],
     [13,[1,1,1,1,2,2,1,2]],[17,[1]],[24,[1,1,1,1,2,2,1,2]],
     [25,[1,1,1,1,2,2,1,2]],[29,[1,1,1,1,2,2,1,2]],[35,[1,1,1,1,2,2,1,2]],
     [37,[1]]]],
 [11565,[[11,[1,1,1,1,2]],[25,[1,1,1,1,2]],[56,[1,1,1,1,2]],
     [71,[1,1,1,1,2]],[85,[1,1,1,1,2]],[116,[1,1,1,1,2]],
     [131,[1,1,1,1,2]],[145,[1,1,1,1,2]],[176,[1,1,1,1,2]],
     [191,[1,1,1,1,2]]]],
 [11571,[[5,[1,1,1,2,2,2,1,2]],[19,[1,1,1,2,2,2,1,2]],[31,[1,2]],
     [43,[1,1,1,2,2,2,1,2]],[55,[1,1,1,2,2,2,1,2]],[65,[1,1,1,2,2,2,1,2]],
     [79,[1,1,1,2,2,2,1,2]],[91,[1,2]],[103,[1,1,1,2,2,2,1,2]],
     [115,[1,1,1,2,2,2,1,2]]]],
 [11572,[[4,[1,1,1,1,2,1,2,2]],[16,[1,1,1,1,2,1,2,2]],[28,[2]],
     [40,[1,1,1,1,2,1,2,2]],[49,[1,1,1,1,2,1,2,2]],[64,[1,1,1,1,2,1,2,2]],
     [76,[1,1,1,1,2,1,2,2]],[88,[2]],[100,[1,1,1,1,2,1,2,2]],
     [109,[1,1,1,1,2,1,2,2]]]],
 [11578,[[31,[1]],[91,[1]],[151,[1]],[211,[1]]]],
 [11580,[[3,[1]],[20,[1]],[23,[1]],[25,[1]],[35,[1]],[43,[1]],[45,[1]],
     [55,[1]],[63,[1]],[80,[1]]]],
 [11584,[[9,[1,2]],[29,[1]],[40,[1,2]],[69,[1,2]],[89,[1]],[100,[1,2]],
     [129,[1,2]],[149,[1]],[160,[1,2]],[189,[1,2]]]],
 [11585,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [11586,[[3,[1,1,2,1,1,2,2,2]],[15,[1,1,2,1,1,2,2,2]],[25,[1,2]],
     [39,[1,1,2,1,1,2,2,2]],[51,[1,1,2,1,1,2,2,2]],[63,[1,1,2,1,1,2,2,2]],
     [75,[1,1,2,1,1,2,2,2]],[85,[1,2]],[99,[1,1,2,1,1,2,2,2]],
     [111,[1,1,2,1,1,2,2,2]]]],
 [11587,[[0,[1,2,2,1,2,2,2,3]],[9,[1,2,2,1,2,2,2,3]],[24,[1]],
     [36,[1,2,2,1,2,2,2,3]],[48,[1,2,2,1,2,2,2,3]],[60,[1,2,2,1,2,2,2,3]],
     [69,[1,2,2,1,2,2,2,3]],[84,[1]],[96,[1,2,2,1,2,2,2,3]],
     [108,[1,2,2,1,2,2,2,3]]]],
 [11588,[[9,[1]],[15,[1]],[16,[1]],[20,[2,2,3]],[29,[1]],[36,[1]],
     [40,[2,2,3]],[56,[1]],[69,[1]],[75,[1]]]],
 [11589,[[0,[1,1,2,2,2,2,1,2]],[4,[1,2]],[5,[1,1,2,2,2,2,1,2]],
     [8,[1,1,2,2,2,2,1,2]],[13,[1,1,2,2,2,2,1,2]],[24,[1,2]],
     [28,[1,1,2,2,2,2,1,2]],[29,[1,1,2,2,2,2,1,2]],[35,[1,2]],
     [40,[1,1,2,2,2,2,1,2]]]],[11595,[[15,fail]]],[11598,[[20,fail]]],
 [11615,[[5,[1,1,2,3,3,3,2,2]],[20,[1,1,2,3,3,3,2,2]],[32,[1]],
     [44,[1,1,2,3,3,3,2,2]],[56,[1,1,2,3,3,3,2,2]],[65,[1,1,2,3,3,3,2,2]],
     [80,[1,1,2,3,3,3,2,2]],[92,[1]],[104,[1,1,2,3,3,3,2,2]],
     [116,[1,1,2,3,3,3,2,2]]]],
 [11617,[[7,[1,1,2,3,3,3,2,2]],[19,[1,1,2,3,3,3,2,2]],[31,[1]],
     [40,[1,1,2,3,3,3,2,2]],[55,[1,1,2,3,3,3,2,2]],[67,[1,1,2,3,3,3,2,2]],
     [79,[1,1,2,3,3,3,2,2]],[91,[1]],[100,[1,1,2,3,3,3,2,2]],
     [115,[1,1,2,3,3,3,2,2]]]],
 [11618,[[4,[1,2,1,2,2,1,2,3]],[16,[1,2,1,2,2,1,2,3]],[25,[2]],
     [40,[1,2,1,2,2,1,2,3]],[52,[1,2,1,2,2,1,2,3]],[64,[1,2,1,2,2,1,2,3]],
     [76,[1,2,1,2,2,1,2,3]],[85,[2]],[100,[1,2,1,2,2,1,2,3]],
     [112,[1,2,1,2,2,1,2,3]]]],
 [11621,[[0,[2,3]],[11,[2,3]],[20,[2,3]],[31,[2,3]],[49,[2,3]],
     [51,[2,3]],[60,[2,3]],[71,[2,3]],[80,[2,3]],[91,[2,3]]]],
 [11628,[[11,[1,2,1,2,2,1,2,3]],[20,[1,2,1,2,2,1,2,3]],[35,[2]],
     [47,[1,2,1,2,2,1,2,3]],[59,[1,2,1,2,2,1,2,3]],[71,[1,2,1,2,2,1,2,3]],
     [80,[1,2,1,2,2,1,2,3]],[95,[2]],[107,[1,2,1,2,2,1,2,3]],
     [119,[1,2,1,2,2,1,2,3]]]],
 [11630,[[24,[1]],[27,[1]],[84,[1]],[87,[1]],[144,[1]],[147,[1]],
     [204,[1]],[207,[1]]]],
 [11631,[[24,[1,1,2]],[84,[1,1,2]],[144,[1,1,2]],[204,[1,1,2]]]],
 [11632,[[0,[1,1,1,2,2,3,4,2]],[15,[1,1,1,2,2,3,4,2]],[27,[1,2]],
     [39,[1,1,1,2,2,3,4,2]],[51,[1,1,1,2,2,3,4,2]],[60,[1,1,1,2,2,3,4,2]],
     [75,[1,1,1,2,2,3,4,2]],[87,[1,2]],[99,[1,1,1,2,2,3,4,2]],
     [111,[1,1,1,2,2,3,4,2]]]],
 [11633,[[0,[1,1,2,2,2,2,2,4]],[12,[1,1,2,2,2,2,2,4]],[24,[2]],
     [36,[1,1,2,2,2,2,2,4]],[45,[1,1,2,2,2,2,2,4]],[60,[1,1,2,2,2,2,2,4]],
     [72,[1,1,2,2,2,2,2,4]],[84,[2]],[96,[1,1,2,2,2,2,2,4]],
     [105,[1,1,2,2,2,2,2,4]]]],
 [11634,[[5,[2]],[12,[1,2]],[15,[1,2]],[32,[1,2]],[45,[2]],[52,[1,2]],
     [65,[2]],[72,[1,2]],[75,[1,2]],[92,[1,2]]]],
 [11636,[[0,[2,3,4,5]],[25,[2,3,4,5]],[40,[2,3,4,5]],[45,[2,3,4,5]],
     [60,[2,3,4,5]],[85,[2,3,4,5]],[100,[2,3,4,5]],[105,[2,3,4,5]],
     [120,[2,3,4,5]],[145,[2,3,4,5]]]],[11641,[[29,fail]]],
 [11642,[[29,fail]]],
 [11656,[[23,[1,1,1,2,2,2]],[35,[2,2,3]],[83,[1,1,1,2,2,2]],[95,[2,2,3]],
     [143,[1,1,1,2,2,2]],[155,[2,2,3]],[203,[1,1,1,2,2,2]],[215,[2,2,3]]]]
  ,
 [11662,[[5,[2,2,3,3,3,3,4,4]],[15,[2,2,3,3,3,3,4,4]],[31,[1]],
     [43,[2,2,3,3,3,3,4,4]],[55,[2,2,3,3,3,3,4,4]],[67,[2,2,3,3,3,3,4,4]],
     [75,[2,2,3,3,3,3,4,4]],[91,[1]],[103,[2,2,3,3,3,3,4,4]],
     [115,[2,2,3,3,3,3,4,4]]]],
 [11663,[[0,[2,2,3,3,3,3,4,4]],[16,[2,2,3,3,3,3,4,4]],[28,[1]],
     [40,[2,2,3,3,3,3,4,4]],[52,[2,2,3,3,3,3,4,4]],[60,[2,2,3,3,3,3,4,4]],
     [76,[2,2,3,3,3,3,4,4]],[88,[1]],[100,[2,2,3,3,3,3,4,4]],
     [112,[2,2,3,3,3,3,4,4]]]],
 [11673,[[11,[1,1,2,3,3,4,2,2]],[23,[1,1,2,3,3,4,2,2]],[35,[4,5]],
     [47,[1,1,2,3,3,4,2,2]],[55,[1,1,2,3,3,4,2,2]],[71,[1,1,2,3,3,4,2,2]],
     [83,[1,1,2,3,3,4,2,2]],[95,[4,5]],[107,[1,1,2,3,3,4,2,2]],
     [115,[1,1,2,3,3,4,2,2]]]],
 [11675,[[20,[2,2,3]],[36,[1,1,1,2,2,2]],[80,[2,2,3]],[96,[1,1,1,2,2,2]],
     [140,[2,2,3]],[156,[1,1,1,2,2,2]],[200,[2,2,3]],[216,[1,1,1,2,2,2]]]]
  ,
 [11678,[[0,[1,1,2,3,3,4,2,2]],[12,[1,1,2,3,3,4,2,2]],[20,[4,5]],
     [36,[1,1,2,3,3,4,2,2]],[48,[1,1,2,3,3,4,2,2]],[60,[1,1,2,3,3,4,2,2]],
     [72,[1,1,2,3,3,4,2,2]],[80,[4,5]],[96,[1,1,2,3,3,4,2,2]],
     [108,[1,1,2,3,3,4,2,2]]]],
 [11699,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [11700,[[1,[1,2]],[8,[1,2]],[13,[1,2]],[20,[1,2]],[25,[1,2]],[32,[1,2]],
     [37,[1,2]],[44,[1,2]],[49,[1,2]],[56,[1,2]]]],
 [11704,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11706,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [11707,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [11708,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [11709,[[4,[1]],[9,[1]],[16,[1]],[21,[1]],[28,[1]],[33,[1]],[40,[1]],
     [45,[1]],[52,[1]],[57,[1]]]],
 [11713,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [11717,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [11721,[[0,[1]],[3,[1,2]],[12,[1]],[15,[1,2]],[24,[1]],[27,[1,2]],
     [36,[1]],[39,[1,2]],[48,[1]],[51,[1,2]]]],
 [11722,[[0,[1,2]],[3,[1]],[12,[1,2]],[15,[1]],[24,[1,2]],[27,[1]],
     [36,[1,2]],[39,[1]],[48,[1,2]],[51,[1]]]],
 [11724,[[1,[1,2]],[4,[1,2]],[13,[1,2]],[16,[1,2]],[25,[1,2]],[28,[1,2]],
     [37,[1,2]],[40,[1,2]],[49,[1,2]],[52,[1,2]]]],[11729,[[1,fail]]],
 [11732,[[1,fail]]],
 [11747,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11749,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [11750,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [11752,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [11753,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [11760,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [11764,[[0,[1]],[5,[1]],[12,[1]],[17,[1]],[24,[1]],[29,[1]],[36,[1]],
     [41,[1]],[48,[1]],[53,[1]]]],
 [11765,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [11767,[[0,[1]],[1,[1]],[5,[1]],[8,[1]],[12,[1]],[13,[1]],[17,[1]],
     [20,[1]],[24,[1]],[25,[1]]]],
 [11784,[[1,[1,2]],[8,[1,2]],[13,[1,2]],[20,[1,2]],[25,[1,2]],[32,[1,2]],
     [37,[1,2]],[44,[1,2]],[49,[1,2]],[56,[1,2]]]],
 [11785,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [11789,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11791,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [11792,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [11793,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [11794,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [11795,[[3,[1,1,2]],[7,[1,1,2]],[15,[1,1,2]],[19,[1,1,2]],[27,[1,1,2]],
     [31,[1,1,2]],[39,[1,1,2]],[43,[1,1,2]],[51,[1,1,2]],[55,[1,1,2]]]],
 [11800,[[7,[1,1,2]],[9,[1,1,2]],[19,[1,1,2]],[21,[1,1,2]],[31,[1,1,2]],
     [33,[1,1,2]],[43,[1,1,2]],[45,[1,1,2]],[55,[1,1,2]],[57,[1,1,2]]]],
 [11802,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [11806,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [11809,[[0,[1,2]],[1,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[13,[1,2]],
     [16,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [11810,[[0,[1]],[1,[1]],[4,[1]],[8,[1]],[12,[1]],[13,[1]],[16,[1]],
     [20,[1]],[24,[1]],[25,[1]]]],[11813,[[1,fail]]],[11814,[[1,fail]]],
 [11825,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [11830,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [11832,[[4,[1]],[7,[1,2]],[16,[1]],[19,[1,2]],[28,[1]],[31,[1,2]],
     [40,[1]],[43,[1,2]],[52,[1]],[55,[1,2]]]],
 [11833,[[4,[1,2]],[7,[1]],[16,[1,2]],[19,[1]],[28,[1,2]],[31,[1]],
     [40,[1,2]],[43,[1]],[52,[1,2]],[55,[1]]]],
 [11843,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [11846,[[0,[1,2]],[5,[1,2]],[12,[1,2]],[17,[1,2]],[24,[1,2]],[29,[1,2]],
     [36,[1,2]],[41,[1,2]],[48,[1,2]],[53,[1,2]]]],
 [11847,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [11848,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[11854,[[5,fail]]],[11857,[[5,fail]]],
 [11866,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [11870,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [11873,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [11875,[[3,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [11876,[[3,[1]],[5,[1]],[7,[1]],[11,[1]],[15,[1]],[17,[1]],[19,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [11883,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [11886,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [11887,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [11888,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [11889,[[0,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[44,[1,1,2]],[48,[1,1,2]],[56,[1,1,2]]]],
 [11890,[[1,[2]],[5,[2]],[13,[2]],[17,[2]],[25,[2]],[29,[2]],[37,[2]],
     [41,[2]],[49,[2]],[53,[2]]]],[11897,[[5,fail]]],[11898,[[5,fail]]],
 [11909,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [11911,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [11912,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [11913,[[7,[1,1,2]],[19,[1,1,2]],[31,[1,1,2]],[43,[1,1,2]],[55,[1,1,2]],
     [67,[1,1,2]],[79,[1,1,2]],[91,[1,1,2]],[103,[1,1,2]],[115,[1,1,2]]] 
  ],
 [11922,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [11924,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [11925,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [11926,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [11927,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [11929,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [11934,[[9,[3]],[33,[3]],[57,[3]],[81,[3]],[105,[3]],[129,[3]],
     [153,[3]],[177,[3]],[201,[3]],[225,[3]]]],[11935,[[9,fail]]],
 [11936,[[9,[3]],[33,[3]],[57,[3]],[81,[3]],[105,[3]],[129,[3]],
     [153,[3]],[177,[3]],[201,[3]],[225,[3]]]],[11938,[[21,fail]]],
 [11945,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11947,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [11949,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [11950,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [11951,[[1,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [11956,[[4,[1]],[11,[1]],[16,[1]],[23,[1]],[28,[1]],[35,[1]],[40,[1]],
     [47,[1]],[52,[1]],[59,[1]]]],
 [11957,[[11,[1,1,2]],[23,[1,1,2]],[35,[1,1,2]],[47,[1,1,2]],[59,[1,1,2]],
     [71,[1,1,2]],[83,[1,1,2]],[95,[1,1,2]],[107,[1,1,2]],[119,[1,1,2]]] 
  ],
 [11959,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [11960,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],
 [11963,[[0,[1]],[5,[2]],[11,[1]],[12,[1]],[17,[2]],[23,[1]],[24,[1]],
     [29,[2]],[35,[1]],[36,[1]]]],
 [11964,[[1,[1,2]],[8,[1,2]],[13,[1,2]],[20,[1,2]],[25,[1,2]],[32,[1,2]],
     [37,[1,2]],[44,[1,2]],[49,[1,2]],[56,[1,2]]]],
 [11968,[[0,[2]],[1,[1]],[4,[2]],[8,[2]],[12,[2]],[13,[1]],[16,[2]],
     [20,[2]],[24,[2]],[25,[1]]]],
 [11970,[[7,[1]],[11,[1,2]],[19,[1,2]],[23,[1]],[31,[1]],[35,[1,2]],
     [43,[1,2]],[47,[1]],[55,[1]],[59,[1,2]]]],[11971,[[23,fail]]],
 [11983,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [11984,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [11987,[[1,[1,2]],[8,[1,2]],[13,[1,2]],[20,[1,2]],[25,[1,2]],[32,[1,2]],
     [37,[1,2]],[44,[1,2]],[49,[1,2]],[56,[1,2]]]],
 [11988,[[1,[2,4]],[7,[1,2]],[8,[1,2]],[13,[2,4]],[19,[1,2]],[20,[1,2]],
     [25,[2,4]],[31,[1,2]],[32,[1,2]],[37,[2,4]]]],
 [11989,[[5,[2,4]],[11,[1,2]],[17,[2,4]],[23,[1,2]],[29,[2,4]],
     [35,[1,2]],[41,[2,4]],[47,[1,2]],[53,[2,4]],[59,[1,2]]]],
 [11993,[[0,[1,1,2]],[8,[1,1,2]],[11,[1,1,2]],[13,[1,1,2]],[20,[1,1,2]],
     [23,[1,1,2]],[25,[1,1,2]],[32,[1,1,2]],[35,[1,1,2]],[37,[1,1,2]]]],
 [11994,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [11996,[[11,[1,1,2]],[23,[1,1,2]],[35,[1,1,2]],[47,[1,1,2]],[59,[1,1,2]],
     [71,[1,1,2]],[83,[1,1,2]],[95,[1,1,2]],[107,[1,1,2]],[119,[1,1,2]]] 
  ],
 [11997,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],
 [12001,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12003,[[0,[1,1,2]],[8,[2,3,3]],[12,[1,1,2]],[20,[2,3,3]],[24,[1,1,2]],
     [32,[2,3,3]],[36,[1,1,2]],[44,[2,3,3]],[48,[1,1,2]],[56,[2,3,3]]]],
 [12005,[[0,[2,4]],[1,[4,5]],[8,[6]],[12,[2,4]],[13,[4,5]],[20,[6]],
     [24,[2,4]],[25,[4,5]],[32,[6]],[36,[2,4]]]],[12012,[[23,fail]]],
 [12020,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [12022,[[4,[1]],[9,[1]],[16,[1]],[21,[1]],[28,[1]],[33,[1]],[40,[1]],
     [45,[1]],[52,[1]],[57,[1]]]],
 [12023,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12025,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [12033,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12037,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12038,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12039,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[12,[1]],[16,[1]],[17,[1]],
     [21,[1]],[24,[1]],[28,[1]]]],
 [12040,[[1,[1]],[5,[1]],[13,[1]],[17,[1]],[25,[1]],[29,[1]],[37,[1]],
     [41,[1]],[49,[1]],[53,[1]]]],
 [12055,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12057,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12060,[[5,[2]],[7,[2]],[17,[2]],[19,[2]],[29,[2]],[31,[2]],[41,[2]],
     [43,[2]],[53,[2]],[55,[2]]]],
 [12061,[[1,[1,1,2]],[11,[1,1,2]],[13,[1,1,2]],[23,[1,1,2]],[25,[1,1,2]],
     [35,[1,1,2]],[37,[1,1,2]],[47,[1,1,2]],[49,[1,1,2]],[59,[1,1,2]]]],
 [12068,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12070,[[0,[1,2]],[5,[1,2]],[12,[1,2]],[17,[1,2]],[24,[1,2]],[29,[1,2]],
     [36,[1,2]],[41,[1,2]],[48,[1,2]],[53,[1,2]]]],
 [12072,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [12073,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12074,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[12,[1]],[16,[1]],[17,[1]],
     [20,[1]],[24,[1]],[28,[1]]]],
 [12075,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [17,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],[12079,[[5,fail]]],
 [12081,[[5,fail]]],
 [12089,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12091,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [12092,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [12094,[[5,[1,2]],[7,[1,2]],[17,[1,2]],[19,[1,2]],[29,[1,2]],[31,[1,2]],
     [41,[1,2]],[43,[1,2]],[53,[1,2]],[55,[1,2]]]],
 [12102,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12104,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12106,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12107,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12109,[[1,[1,2]],[5,[1,2]],[13,[1,2]],[17,[1,2]],[25,[1,2]],[29,[1,2]],
     [37,[1,2]],[41,[1,2]],[49,[1,2]],[53,[1,2]]]],[12115,[[5,fail]]],
 [12117,[[5,fail]]],
 [12124,[[4,[2]],[9,[2]],[16,[2]],[21,[2]],[28,[2]],[33,[2]],[40,[2]],
     [45,[2]],[52,[2]],[57,[2]]]],
 [12125,[[4,[1]],[8,[1,2]],[16,[1]],[20,[1,2]],[28,[1]],[32,[1,2]],
     [40,[1]],[44,[1,2]],[52,[1]],[56,[1,2]]]],
 [12128,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12129,[[8,[1,2]],[11,[1]],[20,[1,2]],[23,[1]],[32,[1,2]],[35,[1]],
     [44,[1,2]],[47,[1]],[56,[1,2]],[59,[1]]]],
 [12130,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [12131,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12132,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12133,[[3,[1,1,2]],[8,[1,2]],[11,[2,3,3]],[15,[1,1,2]],[20,[1,2]],
     [23,[2,3,3]],[27,[1,1,2]],[32,[1,2]],[35,[2,3,3]],[39,[1,1,2]]]],
 [12134,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12135,[[8,[1,2]],[11,[1,2]],[20,[1,2]],[23,[1,2]],[32,[1,2]],
     [35,[1,2]],[44,[1,2]],[47,[1,2]],[56,[1,2]],[59,[1,2]]]],
 [12136,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12137,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12138,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [12139,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [12140,[[0,[1,2]],[8,[1]],[12,[1,2]],[20,[1]],[24,[1,2]],[32,[1]],
     [36,[1,2]],[44,[1]],[48,[1,2]],[56,[1]]]],
 [12143,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [12144,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12145,[[5,[1,1,2,2]],[15,[1,2]],[17,[1,1,2,2]],[23,[1,1,2,2]],
     [29,[1,1,2,2]],[39,[1,2]],[41,[1,1,2,2]],[47,[1,1,2,2]],
     [53,[1,1,2,2]],[63,[1,2]]]],
 [12146,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12147,[[8,[3,4]],[20,[3,4]],[32,[3,4]],[44,[3,4]],[56,[3,4]],
     [68,[3,4]],[80,[3,4]],[92,[3,4]],[104,[3,4]],[116,[3,4]]]],
 [12150,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12151,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12152,[[8,[1]],[15,[1]],[20,[1]],[23,[1]],[32,[1]],[39,[1]],[44,[1]],
     [47,[1]],[56,[1]],[63,[1]]]],
 [12154,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12155,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12156,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [12157,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12158,[[4,[2]],[9,[2]],[16,[2]],[21,[2]],[28,[2]],[33,[2]],[40,[2]],
     [45,[2]],[52,[2]],[57,[2]]]],
 [12167,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [12169,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [12170,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12171,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12172,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [12174,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],[12179,[[9,fail]]],[12180,[[9,fail]]],
 [12181,[[9,fail]]],[12183,[[21,fail]]],
 [12188,[[4,[1,2]],[7,[1,2]],[16,[1,2]],[19,[1,2]],[28,[1,2]],[31,[1,2]],
     [40,[1,2]],[43,[1,2]],[52,[1,2]],[55,[1,2]]]],
 [12189,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [12191,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [12192,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [12193,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12194,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12195,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12196,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12197,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12198,[[7,[1,2]],[11,[1]],[19,[1,2]],[23,[1]],[31,[1,2]],[35,[1]],
     [43,[1,2]],[47,[1]],[55,[1,2]],[59,[1]]]],
 [12199,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12200,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [12201,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [12202,[[3,[1,2]],[7,[1]],[15,[1,2]],[19,[1]],[27,[1,2]],[31,[1]],
     [39,[1,2]],[43,[1]],[51,[1,2]],[55,[1]]]],
 [12203,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [12206,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12207,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12209,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12210,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [12213,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [12214,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [12215,[[5,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12216,[[4,[1,1,2,2]],[9,[1,1,2,2]],[12,[1,2]],[21,[1,1,2,2]],
     [28,[1,1,2,2]],[33,[1,1,2,2]],[36,[1,2]],[45,[1,1,2,2]],
     [52,[1,1,2,2]],[57,[1,1,2,2]]]],
 [12217,[[4,[1]],[7,[1]],[12,[1]],[19,[1]],[28,[1]],[31,[1]],[36,[1]],
     [43,[1]],[52,[1]],[55,[1]]]],
 [12218,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12219,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12222,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12223,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12224,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [12225,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [12226,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12227,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [12228,[[4,[1]],[11,[1]],[16,[1]],[23,[1]],[28,[1]],[35,[1]],[40,[1]],
     [47,[1]],[52,[1]],[59,[1]]]],
 [12229,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12231,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12232,[[0,[2]],[5,[2]],[12,[2]],[17,[2]],[24,[2]],[29,[2]],[36,[2]],
     [41,[2]],[48,[2]],[53,[2]]]],
 [12233,[[0,[1]],[4,[1,2]],[12,[1]],[16,[1,2]],[24,[1]],[28,[1,2]],
     [36,[1]],[40,[1,2]],[48,[1]],[52,[1,2]]]],
 [12234,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [12236,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12237,[[1,[1,1,2,2]],[11,[1,2]],[13,[1,1,2,2]],[19,[1,1,2,2]],
     [25,[1,1,2,2]],[35,[1,2]],[37,[1,1,2,2]],[43,[1,1,2,2]],
     [49,[1,1,2,2]],[59,[1,2]]]],
 [12238,[[4,[1]],[11,[1]],[16,[1]],[19,[1]],[28,[1]],[35,[1]],[40,[1]],
     [43,[1]],[52,[1]],[59,[1]]]],
 [12240,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12241,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [12242,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12244,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],
     [64,[2,3]],[76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [12245,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12246,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12248,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12251,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12257,[[4,[2,3]],[9,[2,3]],[16,[2,3]],[21,[2,3]],[28,[2,3]],[33,[2,3]],
     [40,[2,3]],[45,[2,3]],[52,[2,3]],[57,[2,3]]]],
 [12259,[[0,[1,1,2]],[3,[1,1,2]],[9,[1,1,2]],[12,[1,1,2]],[15,[1,1,2]],
     [21,[1,1,2]],[24,[1,1,2]],[27,[1,1,2]],[33,[1,1,2]],[36,[1,1,2]]]],
 [12260,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [12261,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12262,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12263,[[0,[2]],[4,[2]],[8,[2]],[9,[1]],[12,[2]],[16,[2]],[20,[2]],
     [21,[1]],[24,[2]],[28,[2]]]],
 [12264,[[1,[3]],[7,[1,2]],[13,[3]],[19,[1,2]],[25,[3]],[31,[1,2]],
     [37,[3]],[43,[1,2]],[49,[3]],[55,[1,2]]]],
 [12266,[[3,[1]],[7,[1,2]],[15,[1,2]],[19,[1]],[27,[1]],[31,[1,2]],
     [39,[1,2]],[43,[1]],[51,[1]],[55,[1,2]]]],[12269,[[19,fail]]],
 [12278,[[3,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [12279,[[5,[1,2]],[9,[1,2]],[17,[1,2]],[21,[1,2]],[29,[1,2]],[33,[1,2]],
     [41,[1,2]],[45,[1,2]],[53,[1,2]],[57,[1,2]]]],
 [12280,[[3,[1,2]],[7,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[31,[1,2]]]],
 [12281,[[4,[1,2]],[9,[3]],[16,[1,2]],[21,[3]],[28,[1,2]],[33,[3]],
     [40,[1,2]],[45,[3]],[52,[1,2]],[57,[3]]]],
 [12282,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [12283,[[3,[1,2]],[7,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[31,[1,2]]]],
 [12284,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [12286,[[0,[1]],[9,[1]],[12,[1]],[21,[1]],[24,[1]],[33,[1]],[36,[1]],
     [45,[1]],[48,[1]],[57,[1]]]],
 [12294,[[5,[1]],[7,[1]],[15,[1]],[17,[1]],[23,[1]],[29,[1]],[31,[1]],
     [39,[1]],[41,[1]],[47,[1]]]],
 [12302,[[5,[1]],[9,[1]],[15,[1]],[21,[1]],[23,[1]],[31,[1]],[33,[1]],
     [39,[1]],[45,[1]],[47,[1]]]],
 [12303,[[3,[1,2]],[4,[1,2]],[9,[1,2]],[11,[1,2]],[12,[1,2]],[15,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [12304,[[0,[1]],[4,[1]],[5,[1]],[7,[1]],[11,[1]],[12,[1]],[16,[1]],
     [17,[1]],[19,[1]],[23,[1]]]],
 [12305,[[0,[1]],[3,[1]],[4,[1]],[7,[1]],[9,[1]],[12,[1]],[15,[1]],
     [16,[1]],[19,[1]],[21,[1]]]],
 [12308,[[0,[1]],[3,[2]],[7,[2]],[11,[2]],[13,[1]],[15,[2]],[19,[2]],
     [23,[2]],[25,[1]],[27,[2]]]],
 [12312,[[11,[1,2]],[23,[1,2]],[35,[1,2]],[47,[1,2]],[59,[1,2]],
     [71,[1,2]],[83,[1,2]],[95,[1,2]],[107,[1,2]],[119,[1,2]]]],
 [12314,[[3,[2,3,3]],[11,[1,1,2]],[15,[2,3,3]],[23,[1,1,2]],[27,[2,3,3]],
     [35,[1,1,2]],[39,[2,3,3]],[47,[1,1,2]],[51,[2,3,3]],[59,[1,1,2]]]],
 [12317,[[0,[1,2]],[3,[2,3,3]],[7,[1,1,2]],[12,[1,2]],[15,[2,3,3]],
     [19,[1,1,2]],[24,[1,2]],[27,[2,3,3]],[31,[1,1,2]],[36,[1,2]]]],
 [12323,[[1,fail]]],[12324,[[1,fail]]],[12325,[[3,fail]]],[12330,[[0,fail]]],
 [12331,[[0,fail]]],[12332,[[0,fail]]],
 [12334,[[4,[1,2]],[9,[1,2]],[16,[1,2]],[21,[1,2]],[28,[1,2]],[33,[1,2]],
     [40,[1,2]],[45,[1,2]],[52,[1,2]],[57,[1,2]]]],
 [12338,[[8,[1]],[11,[1,2]],[20,[1]],[23,[1,2]],[32,[1]],[35,[1,2]],
     [44,[1]],[47,[1,2]],[56,[1]],[59,[1,2]]]],
 [12340,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [12341,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [12342,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12343,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12345,[[0,[1]],[5,[1]],[12,[1]],[17,[1]],[24,[1]],[29,[1]],[36,[1]],
     [41,[1]],[48,[1]],[53,[1]]]],[12351,[[9,fail]]],[12354,[[9,fail]]],
 [12359,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [12361,[[3,[1]],[7,[1]],[9,[1]],[11,[1]],[15,[1]],[19,[1]],[21,[1]],
     [23,[1]],[27,[1]],[31,[1]]]],
 [12365,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [12366,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [12367,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12368,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12369,[[4,[1,1,2]],[5,[1,1,2]],[16,[1,1,2]],[17,[1,1,2]],[28,[1,1,2]],
     [29,[1,1,2]],[40,[1,1,2]],[41,[1,1,2]],[52,[1,1,2]],[53,[1,1,2]]]],
 [12370,[[0,[1]],[5,[1]],[12,[1]],[17,[1]],[24,[1]],[29,[1]],[36,[1]],
     [41,[1]],[48,[1]],[53,[1]]]],
 [12371,[[0,[1,1,2]],[4,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],[24,[1,1,2]],
     [28,[1,1,2]],[36,[1,1,2]],[40,[1,1,2]],[48,[1,1,2]],[52,[1,1,2]]]],
 [12377,[[9,fail]]],[12379,[[9,fail]]],
 [12384,[[4,[1,1,2]],[16,[1,1,2]],[28,[1,1,2]],[40,[1,1,2]],[52,[1,1,2]],
     [64,[1,1,2]],[76,[1,1,2]],[88,[1,1,2]],[100,[1,1,2]],[112,[1,1,2]]] 
  ],
 [12386,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [12387,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [12389,[[3,[1,2]],[4,[1,2]],[9,[2,4]],[15,[1,2]],[16,[1,2]],[21,[2,4]],
     [27,[1,2]],[28,[1,2]],[33,[2,4]],[39,[1,2]]]],
 [12390,[[4,[1]],[7,[1]],[9,[1]],[16,[1]],[19,[1]],[21,[1]],[28,[1]],
     [31,[1]],[33,[1]],[40,[1]]]],
 [12392,[[0,[2,3]],[7,[2,3]],[13,[2,3]],[19,[2,3]],[25,[2,3]],[31,[2,3]],
     [37,[2,3]],[43,[2,3]],[49,[2,3]],[55,[2,3]]]],[12403,[[19,fail]]],
 [12405,[[4,[1]],[8,[1,2]],[16,[1,2]],[20,[1]],[28,[1]],[32,[1,2]],
     [40,[1,2]],[44,[1]],[52,[1]],[56,[1,2]]]],
 [12410,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],
 [12414,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [12415,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [12421,[[13,[3]],[37,[3]],[61,[3]],[85,[3]],[109,[3]],[133,[3]],
     [157,[3]],[181,[3]],[205,[3]],[229,[3]]]],[12422,[[1,fail]]],
 [12425,[[13,fail]]],
 [12426,[[13,[3]],[37,[3]],[61,[3]],[85,[3]],[109,[3]],[133,[3]],
     [157,[3]],[181,[3]],[205,[3]],[229,[3]]]],
 [12434,[[3,[6]],[9,[4,5]],[11,[2,4]],[15,[6]],[21,[4,5]],[23,[2,4]],
     [27,[6]],[33,[4,5]],[35,[2,4]],[39,[6]]]],
 [12435,[[3,[2]],[7,[2]],[9,[1]],[11,[2]],[15,[2]],[19,[2]],[21,[1]],
     [23,[2]],[27,[2]],[31,[2]]]],
 [12436,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],[12443,[[0,fail]]],[12444,[[0,fail]]],
 [12445,[[3,fail]]],[12450,[[3,fail]]],[12451,[[0,fail]]],[12452,[[0,fail]]],
 [12453,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],
 [12458,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [12464,[[13,fail]]],[12465,[[1,fail]]],[12468,[[13,fail]]],[12469,[[13,fail]]],
 [12477,[[3,[1]],[11,[1,2]],[15,[1]],[23,[1,2]],[27,[1]],[35,[1,2]],
     [39,[1]],[47,[1,2]],[51,[1]],[59,[1,2]]]],
 [12479,[[4,[1,1,2]],[8,[2,3,3]],[11,[1,2]],[16,[1,1,2]],[20,[2,3,3]],
     [23,[1,2]],[28,[1,1,2]],[32,[2,3,3]],[35,[1,2]],[40,[1,1,2]]]],
 [12482,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12483,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12484,[[11,[2,3]],[23,[2,3]],[35,[2,3]],[47,[2,3]],[59,[2,3]],
     [71,[2,3]],[83,[2,3]],[95,[2,3]],[107,[2,3]],[119,[2,3]]]],
 [12486,[[11,[1,2]],[23,[1,2]],[35,[1,2]],[47,[1,2]],[59,[1,2]],
     [71,[1,2]],[83,[1,2]],[95,[1,2]],[107,[1,2]],[119,[1,2]]]],
 [12487,[[11,[2]],[23,[2]],[35,[2]],[47,[2]],[59,[2]],[71,[2]],[83,[2]],
     [95,[2]],[107,[2]],[119,[2]]]],
 [12488,[[11,[2,3]],[23,[2,3]],[35,[2,3]],[47,[2,3]],[59,[2,3]],
     [71,[2,3]],[83,[2,3]],[95,[2,3]],[107,[2,3]],[119,[2,3]]]],
 [12491,[[8,[1]],[11,[1]],[16,[1]],[23,[1]],[32,[1]],[35,[1]],[40,[1]],
     [47,[1]],[56,[1]],[59,[1]]]],
 [12492,[[11,[1]],[23,[1]],[35,[1]],[47,[1]],[59,[1]],[71,[1]],[83,[1]],
     [95,[1]],[107,[1]],[119,[1]]]],
 [12496,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12499,[[0,[1]],[1,[1]],[12,[1]],[13,[1]],[24,[1]],[25,[1]],[36,[1]],
     [37,[1]],[48,[1]],[49,[1]]]],[12504,[[9,fail]]],[12508,[[9,fail]]],
 [12509,[[0,fail]]],[12512,[[16,fail]]],
 [12514,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12515,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [12517,[[0,[1,2]],[5,[2,4]],[12,[1,2]],[17,[2,4]],[24,[1,2]],[29,[2,4]],
     [36,[1,2]],[41,[2,4]],[48,[1,2]],[53,[2,4]]]],[12523,[[15,fail]]],
 [12531,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12532,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[12541,[[15,fail]]],
 [12546,[[0,[1]],[4,[1,2]],[12,[1,2]],[16,[1]],[24,[1]],[28,[1,2]],
     [36,[1,2]],[40,[1]],[48,[1]],[52,[1,2]]]],
 [12548,[[0,[1,2]],[3,[1,2]],[12,[1,2]],[15,[1,2]],[24,[1,2]],[27,[1,2]],
     [36,[1,2]],[39,[1,2]],[48,[1,2]],[51,[1,2]]]],
 [12549,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12551,[[0,[2,3,3]],[3,[1,2]],[8,[1,1,2]],[12,[2,3,3]],[15,[1,2]],
     [20,[1,1,2]],[24,[2,3,3]],[27,[1,2]],[32,[1,1,2]],[36,[2,3,3]]]],
 [12553,[[1,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12555,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12556,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12557,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [12559,[[3,[3,4]],[15,[3,4]],[27,[3,4]],[39,[3,4]],[51,[3,4]],
     [63,[3,4]],[75,[3,4]],[87,[3,4]],[99,[3,4]],[111,[3,4]]]],
 [12560,[[0,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12561,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [12562,[[0,[1,1,2,2]],[5,[1,1,2,2]],[8,[1,2]],[17,[1,1,2,2]],
     [24,[1,1,2,2]],[29,[1,1,2,2]],[32,[1,2]],[41,[1,1,2,2]],
     [48,[1,1,2,2]],[53,[1,1,2,2]]]],
 [12563,[[0,[1]],[3,[1]],[8,[1]],[15,[1]],[24,[1]],[27,[1]],[32,[1]],
     [39,[1]],[48,[1]],[51,[1]]]],
 [12564,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12567,[[0,[1]],[7,[1]],[12,[1]],[15,[1]],[24,[1]],[31,[1]],[36,[1]],
     [39,[1]],[48,[1]],[55,[1]]]],
 [12568,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12569,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [12571,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [12572,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [12573,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12576,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12577,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12579,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],
     [17,[1,2]],[20,[1,2]],[24,[1,2]],[28,[1,2]]]],[12581,[[0,fail]]],
 [12582,[[0,fail]]],[12586,[[4,fail]]],[12587,[[0,fail]]],[12588,[[4,fail]]],
 [12589,[[0,fail]]],
 [12593,[[0,[1,2]],[1,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[13,[1,2]],
     [16,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [12594,[[0,[1,2]],[1,[1,2]],[8,[1,2]],[11,[1,2]],[12,[1,2]],[13,[1,2]],
     [19,[1,2]],[20,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [12595,[[0,[1]],[4,[1]],[5,[1]],[7,[1]],[11,[1]],[12,[1]],[16,[1]],
     [17,[1]],[19,[1]],[23,[1]]]],
 [12602,[[1,[1]],[4,[1]],[5,[1]],[8,[1]],[11,[1]],[13,[1]],[16,[1]],
     [19,[1]],[20,[1]],[23,[1]]]],
 [12603,[[0,[1]],[5,[1]],[8,[1]],[16,[1]],[17,[1]],[24,[1]],[29,[1]],
     [32,[1]],[40,[1]],[41,[1]]]],
 [12605,[[0,[1]],[1,[1]],[8,[1]],[13,[1]],[16,[1]],[24,[1]],[25,[1]],
     [32,[1]],[37,[1]],[40,[1]]]],[12606,[[0,fail]]],[12607,[[0,fail]]],
 [12611,[[0,fail]]],[12612,[[0,fail]]],[12613,[[4,fail]]],[12614,[[0,fail]]],
 [12639,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [12640,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [12641,[[5,fail]]],[12643,[[13,fail]]],
 [12648,[[9,[2,4]],[33,[2,4]],[57,[2,4]],[81,[2,4]],[105,[2,4]],
     [129,[2,4]],[153,[2,4]],[177,[2,4]],[201,[2,4]],[225,[2,4]]]],
 [12649,[[9,fail]]],[12650,[[1,fail]]],[12651,[[9,fail]]],[12657,[[5,fail]]],
 [12658,[[9,fail]]],
 [12663,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [12664,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [12669,[[13,[2,4]],[37,[2,4]],[61,[2,4]],[85,[2,4]],[109,[2,4]],
     [133,[2,4]],[157,[2,4]],[181,[2,4]],[205,[2,4]],[229,[2,4]]]],
 [12690,[[8,[4]],[28,[4]],[48,[4]],[68,[4]],[88,[4]],[108,[4]],
     [128,[4]],[148,[4]],[168,[4]],[188,[4]]]],
 [12691,[[9,[2,3,3]],[29,[2,3,3]],[49,[2,3,3]],[69,[2,3,3]],[89,[2,3,3]],
     [109,[2,3,3]],[129,[2,3,3]],[149,[2,3,3]],[169,[2,3,3]],
     [189,[2,3,3]]]],
 [12693,[[9,[4]],[29,[4]],[49,[4]],[69,[4]],[89,[4]],[109,[4]],
     [129,[4]],[149,[4]],[169,[4]],[189,[4]]]],
 [12698,[[5,[2,3,3]],[25,[2,3,3]],[45,[2,3,3]],[65,[2,3,3]],[85,[2,3,3]],
     [105,[2,3,3]],[125,[2,3,3]],[145,[2,3,3]],[165,[2,3,3]],
     [185,[2,3,3]]]],
 [12700,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [12701,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],
 [12703,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],
 [12705,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [12706,[[5,[3,3,4]],[8,[1,1,2]],[17,[3,3,4]],[20,[1,1,2]],[29,[3,3,4]],
     [32,[1,1,2]],[41,[3,3,4]],[44,[1,1,2]],[53,[3,3,4]],[56,[1,1,2]]]],
 [12708,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [12710,[[9,[1,1,2]],[21,[1,1,2]],[33,[1,1,2]],[45,[1,1,2]],[57,[1,1,2]],
     [69,[1,1,2]],[81,[1,1,2]],[93,[1,1,2]],[105,[1,1,2]],[117,[1,1,2]]] 
  ],
 [12714,[[4,[1,1,2]],[5,[3,3,4]],[16,[1,1,2]],[17,[3,3,4]],[28,[1,1,2]],
     [29,[3,3,4]],[40,[1,1,2]],[41,[3,3,4]],[52,[1,1,2]],[53,[3,3,4]]]],
 [12716,[[9,fail]]],[12717,[[1,fail]]],
 [12720,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [12721,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[12722,[[5,fail]]],
 [12725,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [12726,[[0,[2,3,3]],[9,[2,3,3]],[12,[2,3,3]],[21,[2,3,3]],[24,[2,3,3]],
     [33,[2,3,3]],[36,[2,3,3]],[45,[2,3,3]],[48,[2,3,3]],[57,[2,3,3]]]],
 [12729,[[1,[4]],[13,[4]],[25,[4]],[37,[4]],[49,[4]],[61,[4]],[73,[4]],
     [85,[4]],[97,[4]],[109,[4]]]],
 [12748,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [12749,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [12766,[[4,[3]],[16,[3]],[28,[3]],[40,[3]],[52,[3]],[64,[3]],[76,[3]],
     [88,[3]],[100,[3]],[112,[3]]]],
 [12771,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12774,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12775,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [12776,[[0,[1,1,2]],[4,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],[24,[1,1,2]],
     [28,[1,1,2]],[36,[1,1,2]],[40,[1,1,2]],[48,[1,1,2]],[52,[1,1,2]]]],
 [12777,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [12780,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12782,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [12786,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [12787,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12789,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12790,[[2,[1,2]],[6,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[30,[1,2]]]],
 [12791,[[2,[1]],[4,[1]],[6,[1]],[10,[1]],[14,[1]],[16,[1]],[18,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [12792,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[26,[1,2]]]],[12802,[[8,fail]]],
 [12803,[[4,fail]]],[12804,[[0,fail]]],
 [12825,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [12830,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [12832,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12833,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [12834,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [12839,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12843,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [12846,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12847,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12848,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [12867,[[13,[2]],[33,[2]],[53,[2]],[73,[2]],[93,[2]],[113,[2]],
     [133,[2]],[153,[2]],[173,[2]],[193,[2]]]],
 [12872,[[6,[2]],[13,[1,1,2]],[26,[2]],[33,[1,1,2]],[46,[2]],
     [53,[1,1,2]],[66,[2]],[73,[1,1,2]],[86,[2]],[93,[1,1,2]]]],
 [12873,[[9,[2]],[29,[2]],[49,[2]],[69,[2]],[89,[2]],[109,[2]],
     [129,[2]],[149,[2]],[169,[2]],[189,[2]]]],
 [12875,[[9,[1,1,2]],[10,[2]],[29,[1,1,2]],[30,[2]],[49,[1,1,2]],
     [50,[2]],[69,[1,1,2]],[70,[2]],[89,[1,1,2]],[90,[2]]]],
 [12878,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [12880,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],
 [12882,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [12883,[[5,[4]],[17,[4]],[29,[4]],[41,[4]],[53,[4]],[65,[4]],[77,[4]],
     [89,[4]],[101,[4]],[113,[4]]]],
 [12884,[[5,[1,1,1,2]],[17,[1,1,1,2]],[29,[1,1,1,2]],[41,[1,1,1,2]],
     [53,[1,1,1,2]],[65,[1,1,1,2]],[77,[1,1,1,2]],[89,[1,1,1,2]],
     [101,[1,1,1,2]],[113,[1,1,1,2]]]],
 [12885,[[9,[1,1,2]],[21,[1,1,2]],[33,[1,1,2]],[45,[1,1,2]],[57,[1,1,2]],
     [69,[1,1,2]],[81,[1,1,2]],[93,[1,1,2]],[105,[1,1,2]],[117,[1,1,2]]] 
  ],
 [12887,[[9,[1,1,2]],[21,[1,1,2]],[33,[1,1,2]],[45,[1,1,2]],[57,[1,1,2]],
     [69,[1,1,2]],[81,[1,1,2]],[93,[1,1,2]],[105,[1,1,2]],[117,[1,1,2]]] 
  ],
 [12888,[[9,[4]],[21,[4]],[33,[4]],[45,[4]],[57,[4]],[69,[4]],[81,[4]],
     [93,[4]],[105,[4]],[117,[4]]]],
 [12892,[[0,[3,3,4]],[10,[1,1,2]],[13,[3,3,4]],[22,[1,1,2]],[25,[3,3,4]],
     [34,[1,1,2]],[37,[3,3,4]],[46,[1,1,2]],[49,[3,3,4]],[58,[1,1,2]]]],
 [12893,[[0,fail]]],[12894,[[5,fail]]],
 [12895,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [12898,[[5,[1,1,2]],[17,[1,1,2]],[29,[1,1,2]],[41,[1,1,2]],[53,[1,1,2]],
     [65,[1,1,2]],[77,[1,1,2]],[89,[1,1,2]],[101,[1,1,2]],[113,[1,1,2]]] 
  ],[12899,[[9,fail]]],
 [12901,[[9,[1,1,1,2]],[21,[1,1,1,2]],[33,[1,1,1,2]],[45,[1,1,1,2]],
     [57,[1,1,1,2]],[69,[1,1,1,2]],[81,[1,1,1,2]],[93,[1,1,1,2]],
     [105,[1,1,1,2]],[117,[1,1,1,2]]]],
 [12902,[[0,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [12905,[[5,[1,1,1,2]],[17,[1,1,1,2]],[29,[1,1,1,2]],[41,[1,1,1,2]],
     [53,[1,1,1,2]],[65,[1,1,1,2]],[77,[1,1,1,2]],[89,[1,1,1,2]],
     [101,[1,1,1,2]],[113,[1,1,1,2]]]],
 [12906,[[0,[3,3,4]],[6,[1,1,2]],[13,[3,3,4]],[18,[1,1,2]],[25,[3,3,4]],
     [30,[1,1,2]],[37,[3,3,4]],[42,[1,1,2]],[49,[3,3,4]],[54,[1,1,2]]]],
 [12922,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [12923,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [12940,[[4,[2,4]],[16,[2,4]],[28,[2,4]],[40,[2,4]],[52,[2,4]],
     [64,[2,4]],[76,[2,4]],[88,[2,4]],[100,[2,4]],[112,[2,4]]]],
 [12945,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [12948,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [12949,[[0,[2,4]],[12,[2,4]],[24,[2,4]],[36,[2,4]],[48,[2,4]],
     [60,[2,4]],[72,[2,4]],[84,[2,4]],[96,[2,4]],[108,[2,4]]]],
 [12950,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [12951,[[0,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[44,[1,1,2]],[48,[1,1,2]],[56,[1,1,2]]]],
 [12954,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [12956,[[4,[1,1,2]],[8,[1,1,2]],[16,[1,1,2]],[20,[1,1,2]],[28,[1,1,2]],
     [32,[1,1,2]],[40,[1,1,2]],[44,[1,1,2]],[52,[1,1,2]],[56,[1,1,2]]]],
 [12960,[[6,[1,2,3]],[18,[1,2,3]],[30,[1,2,3]],[42,[1,2,3]],[54,[1,2,3]],
     [66,[1,2,3]],[78,[1,2,3]],[90,[1,2,3]],[102,[1,2,3]],[114,[1,2,3]]] 
  ],
 [12961,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [12963,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [12964,[[2,[1]],[6,[1]],[8,[1]],[10,[1]],[14,[1]],[18,[1]],[20,[1]],
     [22,[1]],[26,[1]],[30,[1]]]],
 [12965,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [12966,[[0,[1]],[2,[1]],[6,[1]],[10,[1]],[12,[1]],[14,[1]],[18,[1]],
     [22,[1]],[24,[1]],[26,[1]]]],[12976,[[8,fail]]],[12977,[[4,fail]]],
 [12978,[[0,fail]]],
 [12980,[[0,[1]],[6,[1]],[10,[1]],[16,[1]],[20,[1]],[26,[1]],[30,[1]],
     [36,[1]],[40,[1]],[46,[1]]]],
 [12981,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[46,[1,2]]]],
 [12985,[[0,[2]],[10,[2]],[20,[2]],[30,[2]],[40,[2]],[50,[2]],[60,[2]],
     [70,[2]],[80,[2]],[90,[2]]]],
 [12986,[[2,[1]],[4,[1,2]],[12,[1]],[14,[1,2]],[22,[1]],[24,[1,2]],
     [32,[1]],[34,[1,2]],[42,[1]],[44,[1,2]]]],
 [12988,[[6,[1]],[16,[1]],[26,[1]],[36,[1]],[46,[1]],[56,[1]],[66,[1]],
     [76,[1]],[86,[1]],[96,[1]]]],
 [12990,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [12991,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [12995,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [12996,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [12997,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [12998,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [13001,[[4,[2,4]],[10,[2,4]],[16,[2,4]],[22,[2,4]],[28,[2,4]],
     [34,[2,4]],[40,[2,4]],[46,[2,4]],[52,[2,4]],[58,[2,4]]]],
 [13003,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [13004,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [13005,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13008,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [13010,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [13011,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [13018,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],
 [13019,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[13020,[[4,fail]]],
 [13021,[[2,fail]]],[13022,[[0,fail]]],
 [13023,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [13024,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [13028,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [13029,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [13030,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [13031,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [13035,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[46,[1,2]]]],
 [13036,[[0,[1]],[6,[1]],[10,[1]],[16,[1]],[20,[1]],[26,[1]],[30,[1]],
     [36,[1]],[40,[1]],[46,[1]]]],
 [13040,[[0,[3]],[10,[3]],[20,[3]],[30,[3]],[40,[3]],[50,[3]],[60,[3]],
     [70,[3]],[80,[3]],[90,[3]]]],
 [13041,[[2,[1,2]],[4,[1]],[12,[1,2]],[14,[1]],[22,[1,2]],[24,[1]],
     [32,[1,2]],[34,[1]],[42,[1,2]],[44,[1]]]],
 [13043,[[6,[1,2]],[16,[1,2]],[26,[1,2]],[36,[1,2]],[46,[1,2]],
     [56,[1,2]],[66,[1,2]],[76,[1,2]],[86,[1,2]],[96,[1,2]]]],
 [13045,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [13046,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [13050,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [13051,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13052,[[2,[2,4]],[8,[2,4]],[14,[2,4]],[20,[2,4]],[26,[2,4]],[32,[2,4]],
     [38,[2,4]],[44,[2,4]],[50,[2,4]],[56,[2,4]]]],
 [13053,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13056,[[4,[3]],[10,[3]],[16,[3]],[22,[3]],[28,[3]],[34,[3]],[40,[3]],
     [46,[3]],[52,[3]],[58,[3]]]],
 [13058,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [13059,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [13060,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13063,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [13065,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [13066,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [13073,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [13074,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[13075,[[4,fail]]],
 [13076,[[2,fail]]],[13077,[[0,fail]]],
 [13078,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [13079,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [13083,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [13084,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [13085,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [13086,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [13105,[[5,[1,2,2,2,3,2,2,2]],[17,[1,2,2,2,3,2,2,2]],[28,[1,2]],
     [41,[1,2,2,2,3,2,2,2]],[53,[1,2,2,2,3,2,2,2]],[65,[1,2,2,2,3,2,2,2]],
     [77,[1,2,2,2,3,2,2,2]],[88,[1,2]],[101,[1,2,2,2,3,2,2,2]],
     [113,[1,2,2,2,3,2,2,2]]]],
 [13106,[[13,[1,2]],[41,[1,2]],[73,[1,2]],[101,[1,2]],[133,[1,2]],
     [161,[1,2]],[193,[1,2]],[221,[1,2]],[253,[1,2]]]],
 [13110,[[8,[1,1,2,1,2,2,2,3]],[21,[1,1,2,1,2,2,2,3]],[33,[1]],
     [45,[1,1,2,1,2,2,2,3]],[57,[1,1,2,1,2,2,2,3]],[68,[1,1,2,1,2,2,2,3]],
     [81,[1,1,2,1,2,2,2,3]],[93,[1]],[105,[1,1,2,1,2,2,2,3]],
     [117,[1,1,2,1,2,2,2,3]]]],
 [13113,[[5,[1,1,1,2,2,1,1,2]],[17,[1,1,1,2,2,1,1,2]],[28,[3,5]],
     [41,[1,1,1,2,2,1,1,2]],[53,[1,1,1,2,2,1,1,2]],[65,[1,1,1,2,2,1,1,2]],
     [77,[1,1,1,2,2,1,1,2]],[88,[3,5]],[101,[1,1,1,2,2,1,1,2]],
     [113,[1,1,1,2,2,1,1,2]]]],
 [13116,[[8,[4]],[17,[2]],[21,[1,1,2]],[37,[2]],[41,[1,1,2]],[48,[4]],
     [68,[4]],[77,[2]],[81,[1,1,2]],[97,[2]]]],
 [13125,[[8,[1,1,2,2]],[12,[1,1,2,2]],[21,[1,1,2,2]],[42,[1,1,2,2]],
     [57,[1,1,2,2]],[68,[1,1,2,2]],[72,[1,1,2,2]],[81,[1,1,2,2]],
     [102,[1,1,2,2]],[117,[1,1,2,2]]]],
 [13127,[[25,[1]],[85,[1]],[145,[1]],[205,[1]]]],
 [13129,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[20,[1,2]],[21,[1,2]],[26,[1,2]],
     [32,[1,2]],[33,[1,2]],[40,[1,2]],[46,[1,2]]]],
 [13130,[[12,[1]],[17,[1]],[32,[1]],[52,[1]],[72,[1]],[77,[1]],[92,[1]],
     [112,[1]],[132,[1]],[137,[1]]]],
 [13131,[[1,[1,2]],[2,[1,2]],[6,[1,2]],[12,[1,2]],[22,[1,2]],[26,[1,2]],
     [32,[1,2]],[37,[1,2]],[42,[1,2]],[46,[1,2]]]],
 [13159,[[29,[1]],[89,[1]],[149,[1]],[209,[1]]]],
 [13163,[[9,[1,1,1,2,2,1,1,2]],[21,[1,1,1,2,2,1,1,2]],[32,[3,5]],
     [45,[1,1,1,2,2,1,1,2]],[57,[1,1,1,2,2,1,1,2]],[69,[1,1,1,2,2,1,1,2]],
     [81,[1,1,1,2,2,1,1,2]],[92,[3,5]],[105,[1,1,1,2,2,1,1,2]],
     [117,[1,1,1,2,2,1,1,2]]]],
 [13165,[[29,[1]],[89,[1]],[149,[1]],[209,[1]]]],
 [13167,[[1,[1,1,1,2,2,1,1,2]],[12,[1,1,1,2,2,1,1,2]],[25,[3,5]],
     [37,[1,1,1,2,2,1,1,2]],[49,[1,1,1,2,2,1,1,2]],[61,[1,1,1,2,2,1,1,2]],
     [72,[1,1,1,2,2,1,1,2]],[85,[3,5]],[97,[1,1,1,2,2,1,1,2]],
     [109,[1,1,1,2,2,1,1,2]]]],
 [13168,[[21,[2,3,3]],[41,[2,3,3]],[81,[2,3,3]],[101,[2,3,3]],
     [141,[2,3,3]],[161,[2,3,3]],[201,[2,3,3]],[221,[2,3,3]]]],
 [13169,[[17,[2,3,3]],[37,[2,3,3]],[77,[2,3,3]],[97,[2,3,3]],[137,[2,3,3]],
     [157,[2,3,3]],[197,[2,3,3]],[217,[2,3,3]]]],
 [13174,[[5,[3,3,5,5]],[25,[3,3,5,5]],[37,[3,3,5,5]],[57,[3,3,5,5]],
     [65,[3,3,5,5]],[85,[3,3,5,5]],[97,[3,3,5,5]],[117,[3,3,5,5]],
     [125,[3,3,5,5]],[145,[3,3,5,5]]]],
 [13178,[[9,[1,1,1,1,2]],[45,[1,1,1,1,2]],[69,[1,1,1,1,2]],
     [105,[1,1,1,1,2]],[129,[1,1,1,1,2]],[165,[1,1,1,1,2]],
     [189,[1,1,1,1,2]],[225,[1,1,1,1,2]],[249,[1,1,1,1,2]]]],
 [13180,[[12,[1,2]],[41,[1,2]],[72,[1,2]],[101,[1,2]],[132,[1,2]],
     [161,[1,2]],[192,[1,2]],[221,[1,2]],[252,[1,2]]]],
 [13181,[[1,[1,2,2,2,3,2,2,2]],[12,[1,2,2,2,3,2,2,2]],[25,[1,2]],
     [37,[1,2,2,2,3,2,2,2]],[49,[1,2,2,2,3,2,2,2]],[61,[1,2,2,2,3,2,2,2]],
     [72,[1,2,2,2,3,2,2,2]],[85,[1,2]],[97,[1,2,2,2,3,2,2,2]],
     [109,[1,2,2,2,3,2,2,2]]]],
 [13182,[[0,[1]],[4,[1,1,1,1,2]],[6,[1,1,1,1,2]],[14,[1]],[20,[1]],
     [21,[1]],[24,[1,1,1,1,2]],[26,[1,1,1,1,2]],[32,[1,1,1,1,2]],
     [34,[1]]]],
 [13183,[[4,[1,2]],[5,[1,2]],[10,[1,2]],[14,[1,2]],[17,[1,2]],[24,[1,2]],
     [30,[1,2]],[34,[1,2]],[44,[1,2]],[50,[1,2]]]],
 [13184,[[4,[1]],[24,[1]],[37,[1]],[44,[1]],[64,[1]],[84,[1]],[97,[1]],
     [104,[1]],[124,[1]],[144,[1]]]],
 [13211,[[17,[1]],[45,[1]],[77,[1]],[105,[1]],[137,[1]],[165,[1]],
     [197,[1]],[225,[1]]]],
 [13232,[[5,[1]],[37,[1]],[65,[1]],[97,[1]],[125,[1]],[157,[1]],
     [185,[1]],[217,[1]],[245,[1]]]],
 [13261,[[5,[1,1,1,2,2,1,1,2]],[16,[1,1,1,2,2,1,1,2]],[29,[3,5]],
     [41,[1,1,1,2,2,1,1,2]],[53,[1,1,1,2,2,1,1,2]],[65,[1,1,1,2,2,1,1,2]],
     [76,[1,1,1,2,2,1,1,2]],[89,[3,5]],[101,[1,1,1,2,2,1,1,2]],
     [113,[1,1,1,2,2,1,1,2]]]],
 [13268,[[16,[1,2]],[45,[1,2]],[76,[1,2]],[105,[1,2]],[136,[1,2]],
     [165,[1,2]],[196,[1,2]],[225,[1,2]]]],
 [13269,[[5,[1,2,2,2,3,2,2,2]],[16,[1,2,2,2,3,2,2,2]],[29,[1,2]],
     [41,[1,2,2,2,3,2,2,2]],[53,[1,2,2,2,3,2,2,2]],[65,[1,2,2,2,3,2,2,2]],
     [76,[1,2,2,2,3,2,2,2]],[89,[1,2]],[101,[1,2,2,2,3,2,2,2]],
     [113,[1,2,2,2,3,2,2,2]]]],
 [13270,[[1,[1,1,2,1,2,2,2,3]],[13,[1,1,2,1,2,2,2,3]],[25,[1]],
     [36,[1,1,2,1,2,2,2,3]],[49,[1,1,2,1,2,2,2,3]],[61,[1,1,2,1,2,2,2,3]],
     [73,[1,1,2,1,2,2,2,3]],[85,[1]],[96,[1,1,2,1,2,2,2,3]],
     [109,[1,1,2,1,2,2,2,3]]]],
 [13271,[[9,[4]],[16,[1,1,2]],[21,[2]],[36,[1,1,2]],[41,[2]],[49,[4]],
     [69,[4]],[76,[1,1,2]],[81,[2]],[96,[1,1,2]]]],
 [13279,[[33,[1]],[93,[1]],[153,[1]],[213,[1]]]],
 [13282,[[9,[1,2]],[41,[1,2]],[69,[1,2]],[101,[1,2]],[129,[1,2]],
     [161,[1,2]],[189,[1,2]],[221,[1,2]],[249,[1,2]]]],
 [13284,[[1,[1,1,1,2,2,2,3,2]],[13,[1,1,1,2,2,2,3,2]],[25,[1,2]],
     [36,[1,1,1,2,2,2,3,2]],[49,[1,1,1,2,2,2,3,2]],[61,[1,1,1,2,2,2,3,2]],
     [73,[1,1,1,2,2,2,3,2]],[85,[1,2]],[96,[1,1,1,2,2,2,3,2]],
     [109,[1,1,1,2,2,2,3,2]]]],
 [13285,[[0,[1,1,1,1,2]],[8,[1,1,1,1,2]],[9,[1,1,1,1,2]],[10,[1,1,1,1,2]],
     [14,[1,1,1,1,2]],[20,[1,1,1,1,2]],[21,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[34,[1,1,1,1,2]]]],
 [13286,[[0,[1,1,1,1,2]],[5,[1,1,1,1,2]],[8,[1,1,1,1,2]],[14,[1,1,1,1,2]],
     [16,[1,1,1,1,2]],[18,[1,1,1,1,2]],[20,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [29,[1,1,1,1,2]],[34,[1,1,1,1,2]]]],
 [13287,[[0,[1,2]],[1,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[25,[1,2]],
     [28,[1,2]],[34,[1,2]],[40,[1,2]],[48,[1,2]]]],
 [13318,[[9,[1]],[41,[1]],[69,[1]],[101,[1]],[129,[1]],[161,[1]],
     [189,[1]],[221,[1]],[249,[1]]]],
 [13360,[[5,[1,1,1,1,2,2,3,2]],[16,[1,1,1,1,2,2,3,2]],[26,[3,4]],
     [41,[1,1,1,1,2,2,3,2]],[53,[1,1,1,1,2,2,3,2]],[65,[1,1,1,1,2,2,3,2]],
     [76,[1,1,1,1,2,2,3,2]],[86,[3,4]],[101,[1,1,1,1,2,2,3,2]],
     [113,[1,1,1,1,2,2,3,2]]]],
 [13365,[[6,[2,2,2,2,3,2,2,3]],[21,[2,2,2,2,3,2,2,3]],[33,[1]],
     [45,[2,2,2,2,3,2,2,3]],[56,[2,2,2,2,3,2,2,3]],[66,[2,2,2,2,3,2,2,3]],
     [81,[2,2,2,2,3,2,2,3]],[93,[1]],[105,[2,2,2,2,3,2,2,3]],
     [116,[2,2,2,2,3,2,2,3]]]],
 [13368,[[5,[1,1,1,1,2,2,3,2]],[16,[1,1,1,1,2,2,3,2]],[26,[3,4]],
     [41,[1,1,1,1,2,2,3,2]],[53,[1,1,1,1,2,2,3,2]],[65,[1,1,1,1,2,2,3,2]],
     [76,[1,1,1,1,2,2,3,2]],[86,[3,4]],[101,[1,1,1,1,2,2,3,2]],
     [113,[1,1,1,1,2,2,3,2]]]],
 [13369,[[1,[2,2,2,2,3,2,2,3]],[13,[2,2,2,2,3,2,2,3]],[25,[1]],
     [36,[2,2,2,2,3,2,2,3]],[46,[2,2,2,2,3,2,2,3]],[61,[2,2,2,2,3,2,2,3]],
     [73,[2,2,2,2,3,2,2,3]],[85,[1]],[96,[2,2,2,2,3,2,2,3]],
     [106,[2,2,2,2,3,2,2,3]]]],
 [13370,[[5,[2,3]],[16,[2]],[25,[2,3]],[36,[2]],[45,[2,3]],[46,[2,3]],
     [65,[2,3]],[76,[2]],[85,[2,3]],[96,[2]]]],
 [13371,[[6,[2,3]],[13,[2,3]],[21,[2]],[33,[2,3]],[41,[2]],[53,[2,3]],
     [66,[2,3]],[73,[2,3]],[81,[2]],[93,[2,3]]]],
 [13376,[[0,[1,1,2,3,2]],[13,[1,1,2,3,2]],[16,[1,1,2,3,2]],
     [26,[1,1,2,3,2]],[33,[1,1,2,3,2]],[41,[1,1,2,3,2]],[53,[1,1,2,3,2]],
     [56,[1,1,2,3,2]],[61,[1,1,2,3,2]],[73,[1,1,2,3,2]]]],
 [13380,[[21,[2,2,3]],[81,[2,2,3]],[141,[2,2,3]],[201,[2,2,3]]]],
 [13381,[[25,[1]],[36,[1,1,1,2]],[85,[1]],[96,[1,1,1,2]],[145,[1]],
     [156,[1,1,1,2]],[205,[1]],[216,[1,1,1,2]]]],
 [13382,[[21,[1,2,2]],[81,[1,2,2]],[141,[1,2,2]],[201,[1,2,2]]]],
 [13383,[[1,[1,1,2,2,2,3,3,2]],[13,[1,1,2,2,2,3,3,2]],[25,[1,2]],
     [36,[1,1,2,2,2,3,3,2]],[46,[1,1,2,2,2,3,3,2]],[61,[1,1,2,2,2,3,3,2]],
     [73,[1,1,2,2,2,3,3,2]],[85,[1,2]],[96,[1,1,2,2,2,3,3,2]],
     [106,[1,1,2,2,2,3,3,2]]]],
 [13384,[[6,[2,3,3,4]],[10,[2,3,3,4]],[12,[2,3,3,4]],[30,[2,3,3,4]],
     [32,[2,3,3,4]],[50,[2,3,3,4]],[52,[2,3,3,4]],[56,[2,3,3,4]],
     [66,[2,3,3,4]],[70,[2,3,3,4]]]],[13389,[[26,fail]]],
 [13408,[[5,[1,1,2,1,2,2,2,3]],[17,[1,1,2,1,2,2,2,3]],[29,[1]],
     [40,[1,1,2,1,2,2,2,3]],[53,[1,1,2,1,2,2,2,3]],[65,[1,1,2,1,2,2,2,3]],
     [77,[1,1,2,1,2,2,2,3]],[89,[1]],[100,[1,1,2,1,2,2,2,3]],
     [113,[1,1,2,1,2,2,2,3]]]],
 [13413,[[9,[1,2,2,2,3,2,2,2]],[20,[1,2,2,2,3,2,2,2]],[33,[1,2]],
     [45,[1,2,2,2,3,2,2,2]],[57,[1,2,2,2,3,2,2,2]],[69,[1,2,2,2,3,2,2,2]],
     [80,[1,2,2,2,3,2,2,2]],[93,[1,2]],[105,[1,2,2,2,3,2,2,2]],
     [117,[1,2,2,2,3,2,2,2]]]],
 [13416,[[5,[1,1,1,2,2,2,3,2]],[17,[1,1,1,2,2,2,3,2]],[29,[1,2]],
     [40,[1,1,1,2,2,2,3,2]],[53,[1,1,1,2,2,2,3,2]],[65,[1,1,1,2,2,2,3,2]],
     [77,[1,1,1,2,2,2,3,2]],[89,[1,2]],[100,[1,1,1,2,2,2,3,2]],
     [113,[1,1,1,2,2,2,3,2]]]],
 [13417,[[0,[1,1,1,2,2,2,3,2]],[13,[1,1,1,2,2,2,3,2]],[25,[1,2]],
     [37,[1,1,1,2,2,2,3,2]],[49,[1,1,1,2,2,2,3,2]],[60,[1,1,1,2,2,2,3,2]],
     [73,[1,1,1,2,2,2,3,2]],[85,[1,2]],[97,[1,1,1,2,2,2,3,2]],
     [109,[1,1,1,2,2,2,3,2]]]],
 [13419,[[5,[3,3,5,5]],[25,[3,3,5,5]],[33,[3,3,5,5]],[53,[3,3,5,5]],
     [65,[3,3,5,5]],[85,[3,3,5,5]],[93,[3,3,5,5]],[113,[3,3,5,5]],
     [125,[3,3,5,5]],[145,[3,3,5,5]]]],
 [13422,[[13,[1,2]],[45,[1,2]],[73,[1,2]],[105,[1,2]],[133,[1,2]],
     [165,[1,2]],[193,[1,2]],[225,[1,2]],[253,[1,2]]]],
 [13424,[[9,[2]],[13,[1,1,2]],[20,[4]],[40,[4]],[49,[2]],[53,[1,1,2]],
     [69,[2]],[73,[1,1,2]],[80,[4]],[100,[4]]]],
 [13426,[[20,[1,2]],[49,[1,2]],[80,[1,2]],[109,[1,2]],[140,[1,2]],
     [169,[1,2]],[200,[1,2]],[229,[1,2]]]],
 [13431,[[0,[1,1,2,1,2,2,2,3]],[13,[1,1,2,1,2,2,2,3]],[25,[1]],
     [37,[1,1,2,1,2,2,2,3]],[49,[1,1,2,1,2,2,2,3]],[60,[1,1,2,1,2,2,2,3]],
     [73,[1,1,2,1,2,2,2,3]],[85,[1]],[97,[1,1,2,1,2,2,2,3]],
     [109,[1,1,2,1,2,2,2,3]]]],
 [13432,[[4,[1,2]],[9,[1,2]],[14,[1,2]],[18,[1,2]],[20,[1,2]],[24,[1,2]],
     [33,[1,2]],[34,[1,2]],[38,[1,2]],[44,[1,2]]]],
 [13433,[[2,[1,1,1,1,2]],[4,[1,1,1,1,2]],[5,[1]],[8,[1]],[14,[1]],
     [22,[1,1,1,1,2]],[24,[1,1,1,1,2]],[28,[1]],[29,[1,1,1,1,2]],
     [34,[1]]]],
 [13434,[[0,[1,1,1,1,2]],[2,[1]],[8,[1]],[12,[1,1,1,1,2]],[13,[1]],
     [14,[1,1,1,1,2]],[22,[1]],[25,[1,1,1,1,2]],[28,[1]],
     [32,[1,1,1,1,2]]]],
 [13473,[[13,[1]],[45,[1]],[73,[1]],[105,[1]],[133,[1]],[165,[1]],
     [193,[1]],[225,[1]],[253,[1]]]],
 [13475,[[10,[2]],[40,[2]],[70,[2]],[100,[2]],[130,[2]],[160,[2]],
     [190,[2]],[220,[2]],[250,[2]]]],
 [13476,[[13,[1]],[45,[1]],[73,[1]],[105,[1]],[133,[1]],[165,[1]],
     [193,[1]],[225,[1]],[253,[1]]]],
 [13501,[[5,[2,2,2,2,3,2,2,3]],[17,[2,2,2,2,3,2,2,3]],[29,[1]],
     [40,[2,2,2,2,3,2,2,3]],[50,[2,2,2,2,3,2,2,3]],[65,[2,2,2,2,3,2,2,3]],
     [77,[2,2,2,2,3,2,2,3]],[89,[1]],[100,[2,2,2,2,3,2,2,3]],
     [110,[2,2,2,2,3,2,2,3]]]],
 [13506,[[9,[1,1,1,1,2,2,3,2]],[20,[1,1,1,1,2,2,3,2]],[30,[3,4]],
     [45,[1,1,1,1,2,2,3,2]],[57,[1,1,1,1,2,2,3,2]],[69,[1,1,1,1,2,2,3,2]],
     [80,[1,1,1,1,2,2,3,2]],[90,[3,4]],[105,[1,1,1,1,2,2,3,2]],
     [117,[1,1,1,1,2,2,3,2]]]],
 [13508,[[25,[1,2,2]],[85,[1,2,2]],[145,[1,2,2]],[205,[1,2,2]]]],
 [13509,[[5,[1,1,2,2,2,3,3,2]],[17,[1,1,2,2,2,3,3,2]],[29,[1,2]],
     [40,[1,1,2,2,2,3,3,2]],[50,[1,1,2,2,2,3,3,2]],[65,[1,1,2,2,2,3,3,2]],
     [77,[1,1,2,2,2,3,3,2]],[89,[1,2]],[100,[1,1,2,2,2,3,3,2]],
     [110,[1,1,2,2,2,3,3,2]]]],
 [13510,[[0,[1,1,1,1,2,2,3,2]],[10,[1,1,1,1,2,2,3,2]],[25,[3]],
     [37,[1,1,1,1,2,2,3,2]],[49,[1,1,1,1,2,2,3,2]],[60,[1,1,1,1,2,2,3,2]],
     [70,[1,1,1,1,2,2,3,2]],[85,[3]],[97,[1,1,1,1,2,2,3,2]],
     [109,[1,1,1,1,2,2,3,2]]]],
 [13511,[[0,[1,1,2,2,2]],[10,[1,2,2]],[17,[1,2,2]],[25,[1,1,2,2,2]],
     [37,[1,2,2]],[40,[1,1,2,2,2]],[45,[1,1,2,2,2]],[57,[1,2,2]],
     [60,[1,1,2,2,2]],[70,[1,2,2]]]],
 [13512,[[0,[2,2,2,3]],[17,[2,2,2,3]],[20,[2,2,2,3]],[30,[2,2,2,3]],
     [37,[2,2,2,3]],[57,[2,2,2,3]],[60,[2,2,2,3]],[77,[2,2,2,3]],
     [80,[2,2,2,3]],[90,[2,2,2,3]]]],
 [13515,[[29,[1]],[40,[1,1,1,2]],[89,[1]],[100,[1,1,1,2]],[149,[1]],
     [160,[1,1,1,2]],[209,[1]],[220,[1,1,1,2]]]],
 [13517,[[20,[1,1,2]],[40,[1,1,2]],[80,[1,1,2]],[100,[1,1,2]],
     [140,[1,1,2]],[160,[1,1,2]],[200,[1,1,2]],[220,[1,1,2]]]],
 [13521,[[30,[2]],[90,[2]],[150,[2]],[210,[2]]]],
 [13524,[[0,[1,1,2,3,3,3,3,2]],[10,[1,1,2,3,3,3,3,2]],[25,[1]],
     [37,[1,1,2,3,3,3,3,2]],[49,[1,1,2,3,3,3,3,2]],[60,[1,1,2,3,3,3,3,2]],
     [70,[1,1,2,3,3,3,3,2]],[85,[1]],[97,[1,1,2,3,3,3,3,2]],
     [109,[1,1,2,3,3,3,3,2]]]],
 [13525,[[2,[1,2]],[4,[3]],[14,[1]],[20,[1]],[22,[1,2]],[24,[3]],
     [30,[3]],[34,[1]],[42,[1,2]],[44,[3]]]],
 [13526,[[4,[3]],[5,[1]],[6,[1,2]],[14,[1]],[24,[3]],[26,[1,2]],
     [34,[1]],[40,[1,2]],[44,[3]],[46,[1,2]]]],
 [13527,[[10,[2]],[16,[2]],[36,[2]],[56,[2]],[70,[2]],[76,[2]],[96,[2]],
     [116,[2]],[130,[2]],[136,[2]]]],[13532,[[30,fail]]],
 [13566,[[0,[1,1,2]],[18,[2,3,3]],[20,[1,1,2]],[30,[1,1,2]],[48,[2,3,3]],
     [50,[1,1,2]],[60,[1,1,2]],[78,[2,3,3]],[80,[1,1,2]],[90,[1,1,2]]]],
 [13567,[[5,[1]],[33,[1]],[65,[1]],[93,[1]],[125,[1]],[153,[1]],
     [185,[1]],[213,[1]],[245,[1]]]],
 [13568,[[13,[1]],[45,[1]],[73,[1]],[105,[1]],[133,[1]],[165,[1]],
     [193,[1]],[225,[1]],[253,[1]]]],
 [13590,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [13591,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [13595,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [13598,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [13612,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13613,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13615,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [13616,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],[13617,[[1,fail]]],
 [13623,[[1,fail]]],
 [13633,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13634,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13638,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [13642,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [13655,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13656,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13657,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [13658,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [13659,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],[13660,[[5,fail]]],[13666,[[5,fail]]],
 [13675,[[1,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [13680,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [13695,[[6,[1,2,2]],[18,[1,2,2]],[30,[1,2,2]],[42,[1,2,2]],[54,[1,2,2]],
     [66,[1,2,2]],[78,[1,2,2]],[90,[1,2,2]],[102,[1,2,2]],[114,[1,2,2]]] 
  ],
 [13698,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [13721,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [13723,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13724,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13725,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13737,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [13739,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13741,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],[13744,[[5,fail]]],
 [13748,[[5,fail]]],
 [13756,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13757,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [13761,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [13763,[[1,[1]],[5,[1]],[13,[1]],[17,[1]],[25,[1]],[29,[1]],[37,[1]],
     [41,[1]],[49,[1]],[53,[1]]]],
 [13764,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13765,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13779,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13795,[[1,[2,3]],[14,[2,3]],[26,[2,3]],[38,[2,3]],[50,[2,3]],
     [62,[2,3]],[74,[2,3]],[86,[2,3]],[98,[2,3]],[110,[2,3]]]],
 [13800,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [13802,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13803,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [13804,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13816,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13818,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13819,[[6,[1]],[10,[1]],[18,[1]],[22,[1]],[30,[1]],[34,[1]],[42,[1]],
     [46,[1]],[54,[1]],[58,[1]]]],
 [13821,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],[13823,[[1,fail]]],
 [13827,[[1,fail]]],
 [13834,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13835,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [13837,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13840,[[4,[1]],[5,[2]],[10,[1]],[16,[1]],[17,[2]],[22,[1]],[28,[1]],
     [29,[2]],[34,[1]],[40,[1]]]],
 [13841,[[4,[3]],[16,[3]],[28,[3]],[40,[3]],[52,[3]],[64,[3]],[76,[3]],
     [88,[3]],[100,[3]],[112,[3]]]],
 [13844,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [13845,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13846,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13847,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13848,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13849,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [13850,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [13851,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13852,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [13855,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13856,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [13857,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],[13858,[[0,fail]]],
 [13859,[[0,[1,2,2,3]],[4,[1,2]],[8,[1,2,2,3]],[12,[1,2,2,3]],[16,[1,2]],
     [20,[1,2,2,3]],[24,[1,2,2,3]],[28,[1,2]],[32,[1,2,2,3]],
     [36,[1,2,2,3]]]],
 [13860,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13862,[[5,fail]]],
 [13863,[[1,[1,2,2,3]],[10,[1,2]],[18,[1,2,2,3]],[26,[1,2,2,3]],
     [34,[1,2]],[42,[1,2,2,3]],[50,[1,2,2,3]],[58,[1,2]],[66,[1,2,2,3]],
     [74,[1,2,2,3]]]],
 [13864,[[5,[1]],[14,[1]],[22,[1]],[30,[1]],[38,[1]],[46,[1]],[54,[1]],
     [62,[1]],[70,[1]],[78,[1]]]],
 [13866,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13867,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13868,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13869,[[4,[1]],[12,[1]],[20,[1]],[28,[1]],[36,[1]],[44,[1]],[52,[1]],
     [60,[1]],[68,[1]],[76,[1]]]],[13870,[[4,[1,2]],[17,fail]]],
 [13871,[[0,[1,2]],[8,[2,3]],[16,[1,2]],[24,[1,2]],[32,[2,3]],[40,[1,2]],
     [48,[1,2]],[56,[2,3]],[64,[1,2]],[72,[1,2]]]],
 [13874,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [13875,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [13877,[[1,[1]],[5,[2]],[9,[1]],[13,[1]],[17,[2]],[21,[1]],[25,[1]],
     [29,[2]],[33,[1]],[37,[1]]]],
 [13878,[[2,[1]],[5,[2]],[8,[1]],[14,[1]],[17,[2]],[20,[1]],[26,[1]],
     [29,[2]],[32,[1]],[38,[1]]]],[13881,[[1,fail]]],
 [13893,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13894,[[2,[1]],[6,[1]],[9,[1]],[14,[1]],[18,[1]],[21,[1]],[26,[1]],
     [30,[1]],[33,[1]],[38,[1]]]],
 [13895,[[2,[1]],[5,[1]],[6,[1]],[14,[1]],[17,[1]],[18,[1]],[26,[1]],
     [29,[1]],[30,[1]],[38,[1]]]],
 [13896,[[0,[1,2]],[2,[3]],[6,[1,2]],[8,[3]],[12,[1,2]],[14,[3]],
     [18,[1,2]],[20,[3]],[24,[1,2]],[26,[3]]]],
 [13899,[[6,[1]],[14,[1]],[30,[1]],[38,[1]],[54,[1]],[62,[1]],[78,[1]],
     [86,[1]],[102,[1]],[110,[1]]]],
 [13900,[[2,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],
 [13913,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [13914,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [13915,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [13929,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13930,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [13932,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],[13934,[[9,fail]]],[13938,[[9,fail]]],
 [13949,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [13950,[[1,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [13961,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [13964,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [13980,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [13983,[[5,[2,3]],[17,[2,3]],[29,[2,3]],[41,[2,3]],[53,[2,3]],
     [65,[2,3]],[77,[2,3]],[89,[2,3]],[101,[2,3]],[113,[2,3]]]],
 [13984,[[1,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [13998,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [13999,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [14000,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],[14002,[[9,fail]]],[14008,[[9,fail]]],
 [14019,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [14020,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14021,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [14022,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14023,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [14024,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [14025,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [14026,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14027,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [14028,[[6,[2,4]],[18,[2,4]],[30,[2,4]],[42,[2,4]],[54,[2,4]],
     [66,[2,4]],[78,[2,4]],[90,[2,4]],[102,[2,4]],[114,[2,4]]]],
 [14029,[[0,[1]],[6,[1]],[9,[2]],[12,[1]],[18,[1]],[21,[2]],[24,[1]],
     [30,[1]],[33,[2]],[36,[1]]]],
 [14030,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [14032,[[4,[2,4,3,6,2,4,3,6,3,6,3,6,2,4,3,6,2,4,3,6,3,6,3,6,2,4,3,6,2,4,
         3,6,3,6,4,8,2,4,3,6,2,4,3,6,3,6,3,6,2,4,3,6,2,4,3,6,3,6,3,6,2,4,3,
         6,2,4,3,6,3,6,4,8,3,6,3,6,2,4,3,6,3,6,3,6,2,4,3,6,2,4,3,6,3,6,3,6,
         2,4,3,6,2,4,3,6,3,6,4,8]],[6,[1,2]],[22,[1,2]],[24,[2,4]],
     [28,fail]]],
 [14033,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [14034,[[1,[1,2,2,3]],[6,[1,2]],[10,[1,2,2,3]],[14,[1,2,2,3]],[18,[1,2]],
     [22,[1,2,2,3]],[26,[1,2,2,3]],[30,[1,2]],[34,[1,2,2,3]],
     [38,[1,2,2,3]]]],
 [14035,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14037,[[6,[1]],[14,[1]],[22,[1]],[30,[1]],[38,[1]],[46,[1]],[54,[1]],
     [62,[1]],[70,[1]],[78,[1]]]],
 [14038,[[6,[1,2]],[14,[2,3]],[22,[1,2]],[30,[1,2]],[38,[2,3]],
     [46,[1,2]],[54,[1,2]],[62,[2,3]],[70,[1,2]],[78,[1,2]]]],
 [14039,[[9,fail]]],
 [14041,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14042,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14043,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [14044,[[9,fail]]],
 [14045,[[4,[1]],[12,[1]],[20,[1]],[28,[1]],[36,[1]],[44,[1]],[52,[1]],
     [60,[1]],[68,[1]],[76,[1]]]],
 [14046,[[4,[1,2,2,3]],[12,[1,2]],[20,[1,2,2,3]],[28,[1,2,2,3]],
     [36,[1,2]],[44,[1,2,2,3]],[52,[1,2,2,3]],[60,[1,2]],[68,[1,2,2,3]],
     [76,[1,2,2,3]]]],
 [14079,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14080,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14081,[[9,fail]]],
 [14094,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14095,[[0,[1,2]],[4,[3]],[6,[1,2]],[10,[3]],[12,[1,2]],[16,[3]],
     [18,[1,2]],[22,[3]],[24,[1,2]],[28,[3]]]],
 [14100,[[10,[1]],[18,[1]],[34,[1]],[42,[1]],[58,[1]],[66,[1]],[82,[1]],
     [90,[1]],[106,[1]],[114,[1]]]],
 [14102,[[5,[1,2]],[10,[1,2]],[18,[1,2]],[22,[1,2]],[30,[1,2]],
     [34,[1,2]],[42,[1,2]],[46,[1,2]],[54,[1,2]],[58,[1,2]]]],
 [14111,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [14113,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14114,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [14115,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14116,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14117,[[5,[2]],[17,[2]],[29,[2]],[41,[2]],[53,[2]],[65,[2]],[77,[2]],
     [89,[2]],[101,[2]],[113,[2]]]],
 [14118,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [14119,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [14120,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [14122,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14125,[[2,[1,2,2,3]],[6,[1,2]],[10,[1,2,2,3]],[14,[1,2,2,3]],[18,[1,2]],
     [22,[1,2,2,3]],[26,[1,2,2,3]],[30,[1,2]],[34,[1,2,2,3]],
     [38,[1,2,2,3]]]],[14126,[[2,fail]]],
 [14127,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [14129,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14130,[[5,fail]]],
 [14131,[[2,[1]],[10,[1]],[18,[1]],[26,[1]],[34,[1]],[42,[1]],[50,[1]],
     [58,[1]],[66,[1]],[74,[1]]]],
 [14132,[[5,[1,2,2,3]],[14,[1,2]],[22,[1,2,2,3]],[30,[1,2,2,3]],
     [38,[1,2]],[46,[1,2,2,3]],[54,[1,2,2,3]],[62,[1,2]],[70,[1,2,2,3]],
     [78,[1,2,2,3]]]],
 [14133,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14135,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14136,[[5,[1,2]],[17,[1,2]],[29,[1,2]],[41,[1,2]],[53,[1,2]],
     [65,[1,2]],[77,[1,2]],[89,[1,2]],[101,[1,2]],[113,[1,2]]]],
 [14137,[[4,[1,2,2,3]],[12,[1,2]],[20,[1,2,2,3]],[28,[1,2,2,3]],
     [36,[1,2]],[44,[1,2,2,3]],[52,[1,2,2,3]],[60,[1,2]],[68,[1,2,2,3]],
     [76,[1,2,2,3]]]],[14138,[[5,fail]]],
 [14139,[[0,[1]],[8,[1]],[16,[1]],[24,[1]],[32,[1]],[40,[1]],[48,[1]],
     [56,[1]],[64,[1]],[72,[1]]]],
 [14140,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [14142,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [14143,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14144,[[0,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14145,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [14146,[[0,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [14147,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14148,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14149,[[0,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14150,[[0,[2,3]],[6,[2,3]],[12,[2,3]],[18,[2,3]],[24,[2,3]],[30,[2,3]],
     [36,[2,3]],[42,[2,3]],[48,[2,3]],[54,[2,3]]]],
 [14151,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14152,[[0,[1]],[1,[2]],[6,[1]],[12,[1]],[13,[2]],[18,[1]],[24,[1]],
     [25,[2]],[30,[1]],[36,[1]]]],
 [14153,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [14154,[[0,[1,2]],[4,[2,3]],[8,[1,2]],[12,[1,2]],[16,[2,3]],[20,[1,2]],
     [24,[1,2]],[28,[2,3]],[32,[1,2]],[36,[1,2]]]],
 [14155,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],[14156,[[0,fail]]],
 [14158,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14159,[[1,[1]],[10,[1]],[18,[1]],[26,[1]],[34,[1]],[42,[1]],[50,[1]],
     [58,[1]],[66,[1]],[74,[1]]]],[14160,[[1,fail]]],
 [14161,[[1,[1,2]],[10,[2,3]],[18,[1,2]],[26,[1,2]],[34,[2,3]],
     [42,[1,2]],[50,[1,2]],[58,[2,3]],[66,[1,2]],[74,[1,2]]]],
 [14162,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14164,[[0,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14165,[[0,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14166,[[0,[1,2,2,3]],[8,[1,2]],[16,[1,2,2,3]],[24,[1,2,2,3]],[32,[1,2]],
     [40,[1,2,2,3]],[48,[1,2,2,3]],[56,[1,2]],[64,[1,2,2,3]],
     [72,[1,2,2,3]]]],
 [14167,[[0,[1]],[8,[1]],[16,[1]],[24,[1]],[32,[1]],[40,[1]],[48,[1]],
     [56,[1]],[64,[1]],[72,[1]]]],[14168,[[0,[1,2]],[13,fail]]],
 [14179,[[5,fail]]],
 [14181,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],[14187,[[5,fail]]],[14188,[[1,fail]]],
 [14189,[[5,fail]]],[14194,[[0,fail]]],[14195,[[0,fail]]],[14196,[[0,fail]]],
 [14207,[[5,fail]]],
 [14208,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],[14214,[[1,fail]]],[14215,[[1,fail]]],
 [14216,[[1,fail]]],[14221,[[0,fail]]],[14222,[[0,fail]]],[14223,[[0,fail]]],
 [14225,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [14229,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [14234,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [14235,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [14236,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],[14245,[[9,fail]]],[14246,[[9,fail]]],
 [14254,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [14257,[[1,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [14259,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14275,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],[14276,[[9,fail]]],
 [14277,[[0,[1]],[5,[1]],[13,[1]],[17,[1]],[25,[1]],[29,[1]],[37,[1]],
     [41,[1]],[49,[1]],[53,[1]]]],
 [14279,[[0,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14282,[[0,[2]],[5,[1]],[9,[1]],[13,[2]],[17,[1]],[21,[1]],[25,[2]],
     [29,[1]],[33,[1]],[37,[2]]]],
 [14283,[[0,[2]],[4,[1]],[10,[1]],[13,[2]],[16,[1]],[22,[1]],[25,[2]],
     [28,[1]],[34,[1]],[37,[2]]]],
 [14284,[[2,[1,2]],[4,[3]],[8,[1,2]],[10,[3]],[14,[1,2]],[16,[3]],
     [20,[1,2]],[22,[3]],[26,[1,2]],[28,[3]]]],
 [14285,[[4,[1]],[5,[1]],[8,[1]],[16,[1]],[17,[1]],[20,[1]],[28,[1]],
     [29,[1]],[32,[1]],[40,[1]]]],
 [14286,[[0,[1]],[4,[1]],[8,[1]],[13,[1]],[16,[1]],[20,[1]],[25,[1]],
     [28,[1]],[32,[1]],[37,[1]]]],
 [14296,[[4,[1,2]],[8,[1,2]],[16,[1,2]],[20,[1,2]],[28,[1,2]],[32,[1,2]],
     [40,[1,2]],[44,[1,2]],[52,[1,2]],[56,[1,2]]]],
 [14297,[[8,[1]],[16,[1]],[32,[1]],[40,[1]],[56,[1]],[64,[1]],[80,[1]],
     [88,[1]],[104,[1]],[112,[1]]]],
 [14301,[[5,[1]],[17,[1]],[29,[1]],[41,[1]],[53,[1]],[65,[1]],[77,[1]],
     [89,[1]],[101,[1]],[113,[1]]]],
 [14303,[[6,[1,2,2]],[18,[1,2,2]],[30,[1,2,2]],[42,[1,2,2]],[54,[1,2,2]],
     [66,[1,2,2]],[78,[1,2,2]],[90,[1,2,2]],[102,[1,2,2]],[114,[1,2,2]]] 
  ],
 [14306,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [14307,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [14308,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [14309,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],[14317,[[5,fail]]],[14318,[[5,fail]]],
 [14323,[[0,fail]]],[14334,[[0,fail]]],[14335,[[0,fail]]],[14336,[[0,fail]]],
 [14341,[[4,fail]]],[14342,[[4,fail]]],[14343,[[0,fail]]],
 [14348,[[1,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [14349,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [14365,[[0,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [14366,[[0,[1]],[8,[1]],[9,[2]],[14,[1]],[20,[1]],[21,[2]],[26,[1]],
     [32,[1]],[33,[2]],[38,[1]]]],
 [14367,[[1,[1]],[5,[1]],[9,[2]],[13,[1]],[17,[1]],[21,[2]],[25,[1]],
     [29,[1]],[33,[2]],[37,[1]]]],
 [14370,[[0,[1]],[9,[1]],[10,[1]],[14,[1]],[21,[1]],[22,[1]],[26,[1]],
     [33,[1]],[34,[1]],[38,[1]]]],
 [14371,[[0,[1]],[5,[1]],[10,[1]],[14,[1]],[17,[1]],[22,[1]],[26,[1]],
     [29,[1]],[34,[1]],[38,[1]]]],
 [14372,[[0,[3]],[4,[1,2]],[8,[3]],[10,[1,2]],[14,[3]],[16,[1,2]],
     [20,[3]],[22,[1,2]],[26,[3]],[28,[1,2]]]],
 [14376,[[0,[1,2]],[10,[1,2]],[14,[1,2]],[22,[1,2]],[26,[1,2]],
     [34,[1,2]],[38,[1,2]],[46,[1,2]],[50,[1,2]],[58,[1,2]]]],
 [14377,[[14,[1]],[22,[1]],[38,[1]],[46,[1]],[62,[1]],[70,[1]],[86,[1]],
     [94,[1]],[110,[1]],[118,[1]]]],
 [14385,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [14390,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [14391,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],[14399,[[0,fail]]],
 [14400,[[0,fail]]],
 [14423,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14424,[[0,[1]],[4,[1]],[9,[1]],[12,[1]],[16,[1]],[21,[1]],[24,[1]],
     [28,[1]],[33,[1]],[36,[1]]]],
 [14425,[[0,[3]],[4,[1,2]],[6,[3]],[10,[1,2]],[12,[3]],[16,[1,2]],
     [18,[3]],[22,[1,2]],[24,[3]],[28,[1,2]]]],
 [14436,[[0,[1]],[16,[1]],[24,[1]],[40,[1]],[48,[1]],[64,[1]],[72,[1]],
     [88,[1]],[96,[1]],[112,[1]]]],
 [14437,[[0,[1,2]],[4,[1,2]],[12,[1,2]],[16,[1,2]],[24,[1,2]],[28,[1,2]],
     [36,[1,2]],[40,[1,2]],[48,[1,2]],[52,[1,2]]]],
 [14438,[[4,[1]],[12,[1]],[28,[1]],[36,[1]],[52,[1]],[60,[1]],[76,[1]],
     [84,[1]],[100,[1]],[108,[1]]]],
 [14439,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14441,[[0,[3]],[2,[1,2]],[6,[3]],[8,[1,2]],[12,[3]],[14,[1,2]],
     [18,[3]],[20,[1,2]],[24,[3]],[26,[1,2]]]],
 [14442,[[1,[1]],[2,[1]],[6,[1]],[13,[1]],[14,[1]],[18,[1]],[25,[1]],
     [26,[1]],[30,[1]],[37,[1]]]],
 [14445,[[1,[1,2]],[6,[1,2]],[14,[1,2]],[18,[1,2]],[26,[1,2]],[30,[1,2]],
     [38,[1,2]],[42,[1,2]],[50,[1,2]],[54,[1,2]]]],
 [14446,[[6,[1]],[14,[1]],[30,[1]],[38,[1]],[54,[1]],[62,[1]],[78,[1]],
     [86,[1]],[102,[1]],[110,[1]]]],
 [14447,[[1,[1]],[18,[1]],[26,[1]],[42,[1]],[50,[1]],[66,[1]],[74,[1]],
     [90,[1]],[98,[1]],[114,[1]]]],
 [14455,[[0,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [14456,[[0,[1,2,2,3]],[4,[1,2]],[8,[1,2,2,3]],[12,[1,2,2,3]],[16,[1,2]],
     [20,[1,2,2,3]],[24,[1,2,2,3]],[28,[1,2]],[32,[1,2,2,3]],
     [36,[1,2,2,3]]]],[14457,[[1,fail]]],
 [14458,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14459,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14460,[[1,[1,2,2,3]],[10,[1,2]],[18,[1,2,2,3]],[26,[1,2,2,3]],
     [34,[1,2]],[42,[1,2,2,3]],[50,[1,2,2,3]],[58,[1,2]],[66,[1,2,2,3]],
     [74,[1,2,2,3]]]],[14461,[[1,fail]]],
 [14462,[[1,[1]],[10,[1]],[18,[1]],[26,[1]],[34,[1]],[42,[1]],[50,[1]],
     [58,[1]],[66,[1]],[74,[1]]]],
 [14463,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14464,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [14467,[[0,[1]],[8,[1]],[16,[1]],[24,[1]],[32,[1]],[40,[1]],[48,[1]],
     [56,[1]],[64,[1]],[72,[1]]]],
 [14468,[[0,[1,2,2,3]],[8,[1,2]],[16,[1,2,2,3]],[24,[1,2,2,3]],[32,[1,2]],
     [40,[1,2,2,3]],[48,[1,2,2,3]],[56,[1,2]],[64,[1,2,2,3]],
     [72,[1,2,2,3]]]],[14469,[[1,fail]]],[14472,[[0,fail]]],
 [14473,[[0,fail]]],
 [14475,[[6,[1]],[14,[1]],[22,[1]],[30,[1]],[38,[1]],[46,[1]],[54,[1]],
     [62,[1]],[70,[1]],[78,[1]]]],
 [14476,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],[14477,[[0,fail]]],
 [14478,[[0,fail]]],[14479,[[2,fail]]],[14480,[[2,fail]]],
 [14481,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [14482,[[4,[1]],[12,[1]],[20,[1]],[28,[1]],[36,[1]],[44,[1]],[52,[1]],
     [60,[1]],[68,[1]],[76,[1]]]],[14485,[[0,fail]]],[14486,[[0,fail]]],
 [14487,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [14488,[[2,[1]],[10,[1]],[18,[1]],[26,[1]],[34,[1]],[42,[1]],[50,[1]],
     [58,[1]],[66,[1]],[74,[1]]]],[14490,[[0,fail]]],[14491,[[0,fail]]],
 [14492,[[2,fail]]],[14493,[[2,fail]]],
 [14494,[[4,[1]],[12,[1]],[20,[1]],[28,[1]],[36,[1]],[44,[1]],[52,[1]],
     [60,[1]],[68,[1]],[76,[1]]]],
 [14495,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],[14497,[[0,fail]]],
 [14498,[[0,fail]]],
 [14499,[[1,[1]],[10,[1]],[18,[1]],[26,[1]],[34,[1]],[42,[1]],[50,[1]],
     [58,[1]],[66,[1]],[74,[1]]]],
 [14500,[[0,[1,2]],[4,[1,2]],[8,[1,2]],[12,[1,2]],[16,[1,2]],[20,[1,2]],
     [24,[1,2]],[28,[1,2]],[32,[1,2]],[36,[1,2]]]],[14502,[[0,fail]]],
 [14503,[[0,fail]]],[14504,[[0,fail]]],[14505,[[0,fail]]],
 [14506,[[0,[1]],[8,[1]],[16,[1]],[24,[1]],[32,[1]],[40,[1]],[48,[1]],
     [56,[1]],[64,[1]],[72,[1]]]],
 [14508,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [14575,[[3,[1]],[7,[1]],[11,[1]],[15,[1]],[19,[1]],[23,[1]],[27,[1]],
     [31,[1]],[35,[1]],[39,[1]]]],
 [14576,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [14579,[[0,[2]],[4,[2]],[8,[2]],[12,[2]],[16,[2]],[20,[2]],[24,[2]],
     [28,[2]],[32,[2]],[36,[2]]]],
 [14580,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14583,[[11,[1,2]],[31,[1,2]],[51,[1,2]],[71,[1,2]],[91,[1,2]],
     [111,[1,2]],[131,[1,2]],[151,[1,2]],[171,[1,2]],[191,[1,2]]]],
 [14587,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [14590,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [14598,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [14601,[[4,[1,2]],[8,[1,2]],[11,[1,2]],[16,[1,2]],[20,[1,2]],[23,[1,2]],
     [28,[1,2]],[32,[1,2]],[35,[1,2]],[40,[1,2]]]],
 [14605,[[0,[2]],[7,[2]],[12,[2]],[19,[2]],[24,[2]],[31,[2]],[36,[2]],
     [43,[2]],[48,[2]],[55,[2]]]],[14606,[[3,fail]]],
 [14609,[[3,[1]],[7,[1]],[15,[1]],[19,[1]],[27,[1]],[31,[1]],[39,[1]],
     [43,[1]],[51,[1]],[55,[1]]]],
 [14610,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [14611,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [14612,[[4,[1,2]],[7,[1,2]],[11,[1,2]],[16,[1,2]],[19,[1,2]],[23,[1,2]],
     [28,[1,2]],[31,[1,2]],[35,[1,2]],[40,[1,2]]]],
 [14614,[[7,[1]],[8,[1]],[19,[1]],[20,[1]],[31,[1]],[32,[1]],[43,[1]],
     [44,[1]],[55,[1]],[56,[1]]]],
 [14616,[[3,[1,2]],[8,[1,2]],[15,[1,2]],[20,[1,2]],[27,[1,2]],[32,[1,2]],
     [39,[1,2]],[44,[1,2]],[51,[1,2]],[56,[1,2]]]],
 [14617,[[3,[2,3]],[15,[2,3]],[27,[2,3]],[39,[2,3]],[51,[2,3]],
     [63,[2,3]],[75,[2,3]],[87,[2,3]],[99,[2,3]],[111,[2,3]]]],
 [14618,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [14625,[[0,[1,1,1,2]],[4,[1,1,1,2]],[7,[1,1,1,2]],[11,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[19,[1,1,1,2]],[23,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [14626,[[0,[1,2]],[3,[1]],[7,[1]],[8,[1,2]],[12,[1,2]],[15,[1]],
     [19,[1]],[20,[1,2]],[24,[1,2]],[27,[1]]]],
 [14627,[[3,[1]],[4,[1,2]],[8,[1,2]],[11,[1]],[15,[1]],[16,[1,2]],
     [20,[1,2]],[23,[1]],[27,[1]],[28,[1,2]]]],
 [14636,[[0,[1]],[5,[1]],[9,[1]],[13,[1]],[17,[1]],[21,[1]],[25,[1]],
     [29,[1]],[33,[1]],[37,[1]]]],
 [14639,[[5,[1,2]],[7,[1]],[15,[1,2]],[17,[1]],[25,[1,2]],[27,[1]],
     [35,[1,2]],[37,[1]],[45,[1,2]],[47,[1]]]],
 [14642,[[3,[1,2]],[9,[1,2]],[13,[1,2]],[19,[1,2]],[23,[1,2]],[29,[1,2]],
     [33,[1,2]],[39,[1,2]],[43,[1,2]],[49,[1,2]]]],
 [14644,[[0,[1]],[13,[1]],[23,[1]],[33,[1]],[43,[1]],[53,[1]],[63,[1]],
     [73,[1]],[83,[1]],[93,[1]]]],
 [14645,[[3,[1]],[9,[1]],[13,[1]],[19,[1]],[23,[1]],[29,[1]],[33,[1]],
     [39,[1]],[43,[1]],[49,[1]]]],
 [14647,[[9,[2]],[19,[2]],[29,[2]],[39,[2]],[49,[2]],[59,[2]],[69,[2]],
     [79,[2]],[89,[2]],[99,[2]]]],
 [14649,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14650,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [14654,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [14657,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [14660,[[5,[2,4]],[11,[2,4]],[17,[2,4]],[23,[2,4]],[29,[2,4]],
     [35,[2,4]],[41,[2,4]],[47,[2,4]],[53,[2,4]],[59,[2,4]]]],
 [14662,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14663,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [14664,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],[14665,[[3,fail]]],
 [14666,[[0,fail]]],
 [14667,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [14669,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [14670,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],[14671,[[5,fail]]],
 [14673,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14675,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [14676,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14677,[[0,[2,4]],[7,[2,4]],[13,[2,4]],[19,[2,4]],[25,[2,4]],[31,[2,4]],
     [37,[2,4]],[43,[2,4]],[49,[2,4]],[55,[2,4]]]],
 [14684,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [14685,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [14686,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [14691,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [14692,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [14693,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [14694,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [14697,[[5,[1,2]],[7,[1,2]],[15,[1,2]],[17,[1,2]],[25,[1,2]],[27,[1,2]],
     [35,[1,2]],[37,[1,2]],[45,[1,2]],[47,[1,2]]]],
 [14700,[[3,[1,2]],[9,[1,2]],[13,[1,2]],[19,[1,2]],[23,[1,2]],[29,[1,2]],
     [33,[1,2]],[39,[1,2]],[43,[1,2]],[49,[1,2]]]],
 [14702,[[0,[1,2]],[13,[1,2]],[23,[1,2]],[33,[1,2]],[43,[1,2]],
     [53,[1,2]],[63,[1,2]],[73,[1,2]],[83,[1,2]],[93,[1,2]]]],
 [14703,[[3,[1,2]],[9,[1,2]],[13,[1,2]],[19,[1,2]],[23,[1,2]],[29,[1,2]],
     [33,[1,2]],[39,[1,2]],[43,[1,2]],[49,[1,2]]]],
 [14705,[[9,[2,4]],[19,[2,4]],[29,[2,4]],[39,[2,4]],[49,[2,4]],
     [59,[2,4]],[69,[2,4]],[79,[2,4]],[89,[2,4]],[99,[2,4]]]],
 [14707,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14708,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [14712,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [14715,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [14718,[[5,[3]],[11,[3]],[17,[3]],[23,[3]],[29,[3]],[35,[3]],[41,[3]],
     [47,[3]],[53,[3]],[59,[3]]]],
 [14720,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [14721,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [14722,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [14723,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14724,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [14725,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [14727,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [14728,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [14729,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [14731,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [14733,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [14734,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [14735,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [14742,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [14743,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [14744,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [14749,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [14750,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [14751,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [14752,[[0,[2]],[4,[2]],[8,[2]],[12,[2]],[16,[2]],[20,[2]],[24,[2]],
     [28,[2]],[32,[2]],[36,[2]]]],
 [14754,[[8,[1,2]],[28,[1,2]],[48,[1,2]],[68,[1,2]],[88,[1,2]],
     [108,[1,2]],[128,[1,2]],[148,[1,2]],[168,[1,2]],[188,[1,2]]]],
 [14757,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14758,[[0,[1,1,1,2]],[9,[1]],[20,[1,1,1,2]],[29,[1]],[40,[1,1,1,2]],
     [49,[1]],[60,[1,1,1,2]],[69,[1]],[80,[1,1,1,2]],[89,[1]]]],
 [14761,[[4,[1,2,2]],[24,[1,2,2]],[44,[1,2,2]],[64,[1,2,2]],[84,[1,2,2]],
     [104,[1,2,2]],[124,[1,2,2]],[144,[1,2,2]],[164,[1,2,2]],
     [184,[1,2,2]]]],
 [14764,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [14768,[[1,[1]],[5,[1]],[13,[1]],[17,[1]],[25,[1]],[29,[1]],[37,[1]],
     [41,[1]],[49,[1]],[53,[1]]]],
 [14771,[[1,[1]],[8,[1]],[13,[1]],[20,[1]],[25,[1]],[32,[1]],[37,[1]],
     [44,[1]],[49,[1]],[56,[1]]]],
 [14772,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [14775,[[4,[1]],[8,[2]],[17,[1]],[20,[2]],[29,[1]],[32,[2]],[41,[1]],
     [44,[2]],[53,[1]],[56,[2]]]],
 [14777,[[4,[1]],[5,[1]],[16,[1]],[17,[1]],[28,[1]],[29,[1]],[40,[1]],
     [41,[1]],[52,[1]],[53,[1]]]],
 [14779,[[1,[1,2]],[4,[3]],[13,[1,2]],[16,[3]],[25,[1,2]],[28,[3]],
     [37,[1,2]],[40,[3]],[49,[1,2]],[52,[3]]]],
 [14780,[[0,[1,2]],[4,[1,2]],[9,[1,2]],[12,[1,2]],[17,[1,2]],[21,[1,2]],
     [24,[1,2]],[29,[1,2]],[33,[1,2]],[36,[1,2]]]],[14781,[[0,fail]]],
 [14784,[[0,[1,1,1,1,2]],[13,[1,1,1,1,2]],[25,[1,1,1,1,2]],
     [37,[1,1,1,1,2]],[49,[1,1,1,1,2]],[61,[1,1,1,1,2]],[73,[1,1,1,1,2]],
     [85,[1,1,1,1,2]],[97,[1,1,1,1,2]],[109,[1,1,1,1,2]]]],
 [14785,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[14786,[[4,fail]]],
 [14799,[[0,[1,1,1,2]],[4,[1,1,1,2]],[5,[1,1,1,2]],[8,[1,1,1,2]],
     [13,[1,1,1,2]],[16,[1,1,1,2]],[17,[1,1,1,2]],[20,[1,1,1,2]],
     [25,[1,1,1,2]],[28,[1,1,1,2]]]],
 [14800,[[0,[1,2]],[1,[1]],[4,[1,2]],[9,[1]],[12,[1,2]],[13,[1]],
     [16,[1,2]],[21,[1]],[24,[1,2]],[25,[1]]]],
 [14801,[[0,[1,2]],[5,[1]],[8,[1,2]],[9,[1]],[12,[1,2]],[17,[1]],
     [20,[1,2]],[21,[1]],[24,[1,2]],[29,[1]]]],
 [14875,[[0,[1]],[1,[1]],[4,[2]],[8,[1]],[9,[1]],[12,[1]],[13,[1]],
     [16,[2]],[20,[1]],[21,[1]]]],
 [14878,[[0,[2]],[4,[1]],[5,[1]],[8,[2]],[12,[2]],[16,[1]],[17,[1]],
     [20,[2]],[24,[2]],[28,[1]]]],
 [14893,[[0,[2]],[4,[1]],[5,[1]],[8,[2]],[12,[2]],[16,[1]],[17,[1]],
     [20,[2]],[24,[2]],[28,[1]]]],
 [14920,[[7,[3,4]],[27,[3,4]],[47,[3,4]],[67,[3,4]],[87,[3,4]],
     [107,[3,4]],[127,[3,4]],[147,[3,4]],[167,[3,4]],[187,[3,4]]]],
 [14921,[[7,[3,4]],[27,[3,4]],[47,[3,4]],[67,[3,4]],[87,[3,4]],
     [107,[3,4]],[127,[3,4]],[147,[3,4]],[167,[3,4]],[187,[3,4]]]],
 [14922,[[3,[1]],[8,[1]],[11,[1]],[16,[1]],[23,[1]],[28,[1]],[31,[1]],
     [36,[1]],[43,[1]],[48,[1]]]],
 [14923,[[1,[1,2]],[7,[1,2]],[17,[1,2]],[21,[1,2]],[27,[1,2]],[37,[1,2]],
     [41,[1,2]],[47,[1,2]],[57,[1,2]],[61,[1,2]]]],
 [14924,[[1,[1,2]],[7,[1,2]],[17,[1,2]],[21,[1,2]],[27,[1,2]],[37,[1,2]],
     [41,[1,2]],[47,[1,2]],[57,[1,2]],[61,[1,2]]]],
 [14925,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14926,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14927,[[5,[4]],[25,[4]],[45,[4]],[65,[4]],[85,[4]],[105,[4]],
     [125,[4]],[145,[4]],[165,[4]],[185,[4]]]],
 [14928,[[5,[4]],[25,[4]],[45,[4]],[65,[4]],[85,[4]],[105,[4]],
     [125,[4]],[145,[4]],[165,[4]],[185,[4]]]],
 [14929,[[3,[1,1,1,2,1,1,2,2]],[8,[1]],[16,[1,1,1,2,1,1,2,2]],
     [27,[1,1,1,2,1,1,2,2]],[28,[1]],[40,[1,1,1,2,1,1,2,2]],[48,[1]],
     [57,[1,1,1,2,1,1,2,2]],[63,[1,1,1,2,1,1,2,2]],[68,[1]]]],
 [14930,[[5,[1,1,1,2]],[27,[4]],[35,[1,1,1,2]],[48,[1,1,1,2]],
     [65,[1,1,1,2]],[87,[4]],[95,[1,1,1,2]],[108,[1,1,1,2]],
     [125,[1,1,1,2]],[147,[4]]]],
 [14931,[[8,[1,1,2,2]],[27,[4]],[48,[1,1,2,2]],[68,[1,1,2,2]],[87,[4]],
     [108,[1,1,2,2]],[128,[1,1,2,2]],[147,[4]],[168,[1,1,2,2]],
     [188,[1,1,2,2]]]],
 [14932,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14933,[[5,[1,1,1,2]],[7,[1,2]],[23,[1,2]],[27,[1,2]],[35,[1,1,1,2]],
     [37,[1,2]],[48,[1,1,1,2]],[57,[1,2]],[65,[1,1,1,2]],[67,[1,2]]]],
 [14934,[[7,[1,2]],[8,[1,1,2,2]],[37,[1,2]],[43,[1,2]],[48,[1,1,2,2]],
     [67,[1,2]],[68,[1,1,2,2]],[97,[1,2]],[103,[1,2]],[108,[1,1,2,2]]]],
 [14935,[[5,[1,1,2,3]],[25,[1,1,2,3]],[28,[4]],[35,[1,1,2,3]],
     [55,[1,1,2,3]],[65,[1,1,2,3]],[85,[1,1,2,3]],[88,[4]],
     [95,[1,1,2,3]],[115,[1,1,2,3]]]],
 [14936,[[7,[1]],[8,[1,1,1,2]],[37,[1]],[43,[1]],[48,[1,1,1,2]],
     [67,[1]],[68,[1,1,1,2]],[97,[1]],[103,[1]],[108,[1,1,1,2]]]],
 [14938,[[7,[2,3,4,3]],[28,[1]],[48,[2,3,4,3]],[67,[2,3,4,3]],[88,[1]],
     [108,[2,3,4,3]],[127,[2,3,4,3]],[148,[1]],[168,[2,3,4,3]],
     [187,[2,3,4,3]]]],
 [14939,[[8,[1,1,2,2]],[25,[2]],[48,[1,1,2,2]],[68,[1,1,2,2]],[85,[2]],
     [108,[1,1,2,2]],[128,[1,1,2,2]],[145,[2]],[168,[1,1,2,2]],
     [188,[1,1,2,2]]]],
 [14941,[[8,[1,1,2,3]],[25,[2]],[27,[1,1,2,3]],[57,[1,1,2,3]],
     [68,[1,1,2,3]],[85,[2]],[87,[1,1,2,3]],[117,[1,1,2,3]],
     [128,[1,1,2,3]],[145,[2]]]],
 [14942,[[3,[1]],[17,[1]],[28,[1,2]],[47,[1]],[48,[1]],[63,[1]],
     [77,[1]],[88,[1,2]],[107,[1]],[108,[1]]]],
 [14947,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [14948,[[3,[1,2]],[17,[1,2]],[25,[1,2]],[28,[1]],[47,[1,2]],[55,[1,2]],
     [63,[1,2]],[77,[1,2]],[85,[1,2]],[88,[1]]]],
 [14949,[[5,[1,1,2,2]],[25,[1,1,2,2]],[27,[4]],[35,[1,1,2,2]],
     [55,[1,1,2,2]],[65,[1,1,2,2]],[85,[1,1,2,2]],[87,[4]],
     [95,[1,1,2,2]],[115,[1,1,2,2]]]],
 [14952,[[8,[1,1,2,2]],[21,[4]],[48,[1,1,2,2]],[68,[1,1,2,2]],[81,[4]],
     [108,[1,1,2,2]],[128,[1,1,2,2]],[141,[4]],[168,[1,1,2,2]],
     [188,[1,1,2,2]]]],
 [14953,[[7,[1,2,2,2]],[8,[1,2,2,2]],[27,[4]],[37,[1,2,2,2]],
     [43,[1,2,2,2]],[56,[1,2,2,2]],[67,[1,2,2,2]],[68,[1,2,2,2]],
     [87,[4]],[97,[1,2,2,2]]]],
 [14955,[[8,[2,3,4]],[23,[2,3,4]],[27,[2,3,4]],[28,[1]],[57,[2,3,4]],
     [68,[2,3,4]],[83,[2,3,4]],[87,[2,3,4]],[88,[1]],[117,[2,3,4]]]],
 [14956,[[3,[1,2,2]],[17,[1,2,2]],[28,[1]],[47,[1,2,2]],[48,[1,2,2]],
     [63,[1,2,2]],[77,[1,2,2]],[88,[1]],[107,[1,2,2]],[108,[1,2,2]]]],
 [14971,[[3,[1,1,1,2]],[23,[1,1,1,2]],[28,[2]],[63,[1,1,1,2]],
     [68,[2,2,2,3]],[72,[2,2,2,3]],[83,[1,1,1,2]],[123,[1,1,1,2]],
     [143,[1,1,1,2]],[148,[2]]]],
 [14972,[[0,[1,2,2,2,1,2,2,2,1,2,2,3]],[28,[1]],
     [40,[1,2,2,2,1,2,2,2,1,2,2,3]],[43,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [80,[1,2,2,2,1,2,2,2,1,2,2,3]],[83,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [88,[1]],[108,[1,2,2,2,1,2,2,2,1,2,2,3]],[148,[1]],
     [160,[1,2,2,2,1,2,2,2,1,2,2,3]]]],
 [14973,[[8,[1]],[16,[1,2]],[48,[1]],[56,[1,2]],[68,[1]],[96,[1,2]],
     [108,[1]],[128,[1]],[136,[1,2]],[168,[1]]]],
 [14974,[[7,[2,2,3]],[27,[2,2,3]],[47,[2,2,3]],[67,[2,2,3]],[87,[2,2,3]],
     [107,[2,2,3]],[127,[2,2,3]],[147,[2,2,3]],[167,[2,2,3]],
     [187,[2,2,3]]]],
 [14975,[[11,[3,4]],[31,[3,4]],[51,[3,4]],[71,[3,4]],[91,[3,4]],
     [111,[3,4]],[131,[3,4]],[151,[3,4]],[171,[3,4]],[191,[3,4]]]],
 [14976,[[11,[2,2,3]],[31,[2,2,3]],[51,[2,2,3]],[71,[2,2,3]],[91,[2,2,3]],
     [111,[2,2,3]],[131,[2,2,3]],[151,[2,2,3]],[171,[2,2,3]],
     [191,[2,2,3]]]],
 [14977,[[1,[1]],[7,[1]],[12,[1]],[16,[1]],[21,[1]],[27,[1]],[32,[1]],
     [36,[1]],[41,[1]],[47,[1]]]],
 [14978,[[0,[1]],[12,[1]],[15,[1]],[20,[1]],[32,[1]],[35,[1]],[40,[1]],
     [52,[1]],[55,[1]],[60,[1]]]],
 [14981,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [14982,[[4,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[27,[2]],
     [39,[1,1,1,1,1,1,1,2]],[40,[1,1,1,1,1,1,1,2]],[52,[1,1,1,1,1,1,1,2]],
     [64,[1,1,1,1,1,1,1,2]],[69,[1,1,1,1,1,1,1,2]],[87,[2]],
     [99,[1,1,1,1,1,1,1,2]]]],
 [14984,[[27,[1,1,2]],[87,[1,1,2]],[147,[1,1,2]],[207,[1,1,2]]]],
 [14988,[[5,[2]],[11,[1]],[12,[1]],[20,[2]],[25,[2]],[35,[2]],[41,[1]],
     [47,[2]],[55,[2]],[56,[1]]]],
 [14990,[[7,[1,1,1,1,1,1,1,2]],[19,[1,1,1,1,1,1,1,2]],[21,[1,1,1,1,1,1,1,2]]
      ,[31,[2]],[51,[1,1,1,1,1,1,1,2]],[55,[1,1,1,1,1,1,1,2]],
     [67,[1,1,1,1,1,1,1,2]],[79,[1,1,1,1,1,1,1,2]],[81,[1,1,1,1,1,1,1,2]],
     [91,[2]]]],
 [14991,[[31,[1,1,2]],[91,[1,1,2]],[151,[1,1,2]],[211,[1,1,2]]]],
 [14993,[[5,[2,2,2,3]],[9,[2]],[11,[4,4,4,6]],[29,[2,2,2,3]],[32,[2]],
     [35,[2,2,2,3]],[39,[2]],[41,[4,4,4,6]],[47,[2]],[51,[2,2,2,3]]]],
 [14994,[[7,[1,1,2]],[49,[1,1,2]],[67,[1,1,2]],[109,[1,1,2]],[127,[1,1,2]],
     [169,[1,1,2]],[187,[1,1,2]],[229,[1,1,2]],[247,[1,1,2]]]],
 [14996,[[4,[1]],[5,[2]],[12,[2]],[19,[1]],[25,[2]],[35,[2]],[40,[2]],
     [47,[1]],[49,[1]],[55,[2]]]],
 [14997,[[1,[2,2,2,3]],[7,[2,2,2,3]],[12,[2]],[19,[4,4,4,6]],[21,[2]],
     [25,[2,2,2,3]],[27,[2]],[31,[2,2,2,3]],[49,[4,4,4,6]],[51,[2]]]],
 [15003,[[0,[1,1,2,2,2,2,1,2]],[12,[1,1,2,2,2,2,1,2]],[24,[2]],
     [31,[1,1,2,2,2,2,1,2]],[36,[1,1,2,2,2,2,1,2]],[47,[1,1,2,2,2,2,1,2]],
     [61,[1,1,2,2,2,2,1,2]],[72,[1,1,2,2,2,2,1,2]],[84,[2]],
     [91,[1,1,2,2,2,2,1,2]]]],
 [15005,[[24,[1,1,2]],[84,[1,1,2]],[144,[1,1,2]],[204,[1,1,2]]]],
 [15006,[[27,[1]],[87,[1]],[147,[1]],[207,[1]]]],
 [15007,[[24,[1]],[27,[1]],[84,[1]],[87,[1]],[144,[1]],[147,[1]],
     [204,[1]],[207,[1]]]],
 [15011,[[1,[1,2,1,2,3]],[12,[2,2,3]],[21,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]],
     [27,[2,2,3]],[31,[1,2,1,2,3]],[32,[1,2,1,2,3]],
     [51,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]],[61,[1,2,1,2,3]],[72,[2,2,3]],
     [81,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]]]],
 [15027,[[3,[1,2]],[13,[1,2]],[16,[1,2]],[23,[1,2]],[33,[1,2]],
     [36,[1,2]],[43,[1,2]],[53,[1,2]],[56,[1,2]],[63,[1,2]]]],
 [15029,[[3,[1]],[13,[1]],[16,[1]],[23,[1]],[33,[1]],[36,[1]],[43,[1]],
     [53,[1]],[56,[1]],[63,[1]]]],
 [15035,[[27,[2,3,3]],[87,[2,3,3]],[147,[2,3,3]],[207,[2,3,3]]]],
 [15040,[[5,[2,3]],[11,[2,3]],[13,[2,3]],[20,[2,3]],[25,[2,3]],
     [35,[2,3]],[41,[2,3]],[43,[2,3]],[55,[2,3]],[56,[2,3]]]],
 [15041,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [15044,[[11,[1]],[27,[1]],[41,[1]],[57,[1]],[71,[1]],[87,[1]],
     [101,[1]],[117,[1]],[131,[1]],[147,[1]]]],
 [15048,[[13,[2,2,3]],[28,[2,2,3]],[43,[2,2,3]],[73,[2,2,3]],[88,[2,2,3]],
     [103,[2,2,3]],[133,[2,2,3]],[148,[2,2,3]],[163,[2,2,3]],
     [193,[2,2,3]]]],[15051,[[7,fail]]],
 [15054,[[27,[1,2,2,3]],[87,[1,2,2,3]],[147,[1,2,2,3]],[207,[1,2,2,3]]]],
 [15058,[[15,[1,1,1,1,1,2,2]],[45,[1,1,1,1,1,2,2]],[75,[1,1,1,1,1,2,2]],
     [105,[1,1,1,1,1,2,2]],[135,[1,1,1,1,1,2,2]],[165,[1,1,1,1,1,2,2]],
     [195,[1,1,1,1,1,2,2]],[225,[1,1,1,1,1,2,2]],[255,[1,1,1,1,1,2,2]]]],
 [15059,[[3,[1,2,2]],[33,[1,2,2]],[36,[1,2,2]],[63,[1,2,2]],[93,[1,2,2]],
     [96,[1,2,2]],[123,[1,2,2]],[153,[1,2,2]],[156,[1,2,2]],[183,[1,2,2]] 
    ]],
 [15060,[[3,[4]],[33,[4]],[48,[4]],[63,[4]],[93,[4]],[108,[4]],
     [123,[4]],[153,[4]],[168,[4]],[183,[4]]]],
 [15062,[[7,[2,3]],[37,[2,3]],[67,[2,3]],[97,[2,3]],[127,[2,3]],
     [157,[2,3]],[187,[2,3]],[217,[2,3]],[247,[2,3]]]],
 [15063,[[7,[3,4]],[21,[3,4]],[37,[3,4]],[51,[3,4]],[67,[3,4]],
     [81,[3,4]],[97,[3,4]],[111,[3,4]],[127,[3,4]],[141,[3,4]]]],
 [15076,[[0,[1,1,1,2]],[11,[1,1,1,2]],[20,[1,1,1,2]],[21,[1,1,1,2]],
     [27,[1,1,1,2]],[40,[1,1,1,2]],[41,[1,1,1,2]],[51,[1,1,1,2]],
     [57,[1,1,1,2]],[60,[1,1,1,2]]]],
 [15077,[[1,[1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,2]],[16,[1,1,1,1,1,1,2]],
     [17,[1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,2]],[36,[1,1,1,1,1,1,2]],
     [41,[1,1,1,1,1,1,2]],[47,[1,1,1,1,1,1,2]],[56,[1,1,1,1,1,1,2]],
     [61,[1,1,1,1,1,1,2]]]],
 [15078,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [15079,[[11,[3,4]],[31,[3,4]],[51,[3,4]],[71,[3,4]],[91,[3,4]],
     [111,[3,4]],[131,[3,4]],[151,[3,4]],[171,[3,4]],[191,[3,4]]]],
 [15080,[[3,[1,2]],[13,[1,2]],[16,[1,2]],[23,[1,2]],[33,[1,2]],
     [36,[1,2]],[43,[1,2]],[53,[1,2]],[56,[1,2]],[63,[1,2]]]],
 [15081,[[3,[1,2]],[13,[1,2]],[15,[1,2]],[23,[1,2]],[33,[1,2]],
     [35,[1,2]],[43,[1,2]],[53,[1,2]],[55,[1,2]],[63,[1,2]]]],
 [15082,[[3,[1,2]],[13,[1,2]],[15,[1,2]],[23,[1,2]],[33,[1,2]],
     [35,[1,2]],[43,[1,2]],[53,[1,2]],[55,[1,2]],[63,[1,2]]]],
 [15083,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [15084,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [15086,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [15087,[[9,[2,3,4,3]],[31,[1]],[51,[2,3,4,3]],[69,[2,3,4,3]],[91,[1]],
     [111,[2,3,4,3]],[129,[2,3,4,3]],[151,[1]],[171,[2,3,4,3]],
     [189,[2,3,4,3]]]],
 [15088,[[11,[1,1,1,2]],[25,[1,1,1,2]],[31,[4]],[55,[1,1,1,2]],
     [71,[1,1,1,2]],[85,[1,1,1,2]],[91,[4]],[115,[1,1,1,2]],
     [131,[1,1,1,2]],[145,[1,1,1,2]]]],
 [15089,[[3,[1,2]],[11,[1,1,1,2]],[23,[1,2]],[25,[1,1,1,2]],[33,[1,2]],
     [36,[1,2]],[53,[1,2]],[55,[1,1,1,2]],[63,[1,2]],[71,[1,1,1,2]]]],
 [15090,[[8,[1,1,2,2]],[31,[2]],[49,[1,1,2,2]],[68,[1,1,2,2]],[91,[2]],
     [109,[1,1,2,2]],[128,[1,1,2,2]],[151,[2]],[169,[1,1,2,2]],
     [188,[1,1,2,2]]]],
 [15092,[[11,[1]],[13,[1]],[31,[1,2]],[43,[1]],[56,[1]],[71,[1]],
     [73,[1]],[91,[1,2]],[103,[1]],[116,[1]]]],
 [15093,[[3,[1,1,1,2,1,1,2,2]],[11,[1]],[19,[1,1,1,2,1,1,2,2]],[31,[1]],
     [33,[1,1,1,2,1,1,2,2]],[43,[1,1,1,2,1,1,2,2]],[51,[1]],
     [55,[1,1,1,2,1,1,2,2]],[63,[1,1,1,2,1,1,2,2]],[71,[1]]]],
 [15094,[[11,[1,1,2,2]],[31,[4]],[49,[1,1,2,2]],[71,[1,1,2,2]],[91,[4]],
     [109,[1,1,2,2]],[131,[1,1,2,2]],[151,[4]],[169,[1,1,2,2]],
     [191,[1,1,2,2]]]],
 [15095,[[11,[1,1,2,2]],[13,[1,2]],[23,[1,2]],[49,[1,1,2,2]],[53,[1,2]],
     [71,[1,1,2,2]],[73,[1,2]],[83,[1,2]],[109,[1,1,2,2]],[113,[1,2]]]],
 [15097,[[3,[1,1,2,3]],[31,[2]],[33,[1,1,2,3]],[51,[1,1,2,3]],
     [63,[1,1,2,3]],[91,[2]],[93,[1,1,2,3]],[111,[1,1,2,3]],
     [123,[1,1,2,3]],[151,[2]]]],
 [15098,[[11,[1,1,1,2]],[16,[1]],[23,[1]],[51,[1,1,1,2]],[53,[1]],
     [71,[1,1,1,2]],[76,[1]],[83,[1]],[111,[1,1,1,2]],[113,[1]]]],
 [15099,[[5,[1,1,2,3]],[25,[1,1,2,3]],[31,[4]],[35,[1,1,2,3]],
     [55,[1,1,2,3]],[65,[1,1,2,3]],[85,[1,1,2,3]],[91,[4]],
     [95,[1,1,2,3]],[115,[1,1,2,3]]]],
 [15103,[[11,[2,2,3,3]],[15,[1,2]],[45,[1,2]],[51,[2,2,3,3]],
     [71,[2,2,3,3]],[75,[1,2]],[105,[1,2]],[111,[2,2,3,3]],
     [131,[2,2,3,3]],[135,[1,2]]]],
 [15104,[[3,[1,1,1,2]],[13,[1]],[15,[1,2]],[19,[1,1,1,2]],[33,[1,1,1,2]],
     [43,[1]],[45,[1,2]],[49,[1,1,1,2]],[51,[1,1,1,2]],[63,[1,1,1,2]]]],
 [15105,[[3,[1,1,2]],[15,[1,1,2]],[19,[1,1,2]],[23,[1,1,2]],[31,[1,2]],
     [49,[1,1,2]],[51,[1,1,2]],[53,[1,1,2]],[63,[1,1,2]],[75,[1,1,2]]]],
 [15108,[[9,[3]],[31,[1]],[48,[3]],[69,[3]],[91,[1]],[108,[3]],
     [129,[3]],[151,[1]],[168,[3]],[189,[3]]]],
 [15109,[[8,[3]],[19,[3]],[31,[1,2]],[49,[3]],[51,[3]],[68,[3]],
     [79,[3]],[91,[1,2]],[109,[3]],[111,[3]]]],
 [15110,[[3,[3,3,3,4]],[31,[1]],[33,[3,3,3,4]],[48,[3,3,3,4]],
     [63,[3,3,3,4]],[91,[1]],[93,[3,3,3,4]],[108,[3,3,3,4]],
     [123,[3,3,3,4]],[151,[1]]]],
 [15111,[[11,[3,3,4,4]],[15,[1,2]],[45,[1,2]],[51,[3,3,4,4]],
     [71,[3,3,4,4]],[75,[1,2]],[105,[1,2]],[111,[3,3,4,4]],
     [131,[3,3,4,4]],[135,[1,2]]]],
 [15113,[[9,[2,3,4,6]],[13,[2,3,4,6]],[24,[2,3,4,6]],[31,[1]],
     [43,[2,3,4,6]],[56,[2,3,4,6]],[69,[2,3,4,6]],[73,[2,3,4,6]],
     [84,[2,3,4,6]],[91,[1]]]],
 [15114,[[3,[2,2,4,4]],[13,[2,2,4,4]],[24,[2,2,4,4]],[31,[1]],
     [33,[2,2,4,4]],[43,[2,2,4,4]],[56,[2,2,4,4]],[63,[2,2,4,4]],
     [73,[2,2,4,4]],[84,[2,2,4,4]]]],
 [15127,[[11,[1]],[20,[1,2]],[51,[1]],[60,[1,2]],[71,[1]],[100,[1,2]],
     [111,[1]],[131,[1]],[140,[1,2]],[171,[1]]]],
 [15129,[[4,[1,1,1,2]],[31,[1]],[44,[1,1,1,2]],[51,[1,1,1,2]],
     [84,[1,1,1,2]],[91,[1]],[111,[1,1,1,2]],[124,[1,1,1,2]],[151,[1]],
     [164,[1,1,1,2]]]],
 [15130,[[1,[1]],[7,[1]],[17,[1]],[21,[1]],[27,[1]],[37,[1]],[41,[1]],
     [47,[1]],[57,[1]],[61,[1]]]],
 [15131,[[0,[1,1,2,1,2]],[9,[1,1,2,1,2]],[19,[1,1,2,1,2]],[20,[1,1,2,1,2]],
     [29,[1,1,2,1,2]],[39,[1,1,2,1,2]],[40,[1,1,2,1,2]],[49,[1,1,2,1,2]],
     [59,[1,1,2,1,2]],[60,[1,1,2,1,2]]]],
 [15133,[[0,[1,1,1,2,2]],[9,[1,1,1,2,2]],[19,[1,1,1,2,2]],[20,[1,1,1,2,2]],
     [29,[1,1,1,2,2]],[39,[1,1,1,2,2]],[40,[1,1,1,2,2]],[49,[1,1,1,2,2]],
     [59,[1,1,1,2,2]],[60,[1,1,1,2,2]]]],
 [15138,[[31,[2,3,3]],[91,[2,3,3]],[151,[2,3,3]],[211,[2,3,3]]]],
 [15140,[[1,[1]],[19,[1]],[31,[1]],[49,[1]],[61,[1]],[79,[1]],[91,[1]],
     [109,[1]],[121,[1]],[139,[1]]]],
 [15141,[[17,[2,2,3]],[32,[2,2,3]],[47,[2,2,3]],[77,[2,2,3]],[92,[2,2,3]],
     [107,[2,2,3]],[137,[2,2,3]],[152,[2,2,3]],[167,[2,2,3]],
     [197,[2,2,3]]]],
 [15148,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [15149,[[4,[2,3]],[5,[2,3]],[17,[2,3]],[19,[2,3]],[25,[2,3]],[35,[2,3]],
     [40,[2,3]],[47,[2,3]],[49,[2,3]],[55,[2,3]]]],[15151,[[9,fail]]],
 [15160,[[9,[2,2,3]],[39,[2,2,3]],[69,[2,2,3]],[99,[2,2,3]],[129,[2,2,3]],
     [159,[2,2,3]],[189,[2,2,3]],[219,[2,2,3]],[249,[2,2,3]]]],
 [15177,[[0,[1,2,2]],[20,[1,2,2]],[21,[1,2,2]],[40,[1,2,2]],[51,[1,2,2]],
     [60,[1,2,2]],[80,[1,2,2]],[81,[1,2,2]],[100,[1,2,2]],[111,[1,2,2]]] 
  ],
 [15179,[[9,[1]],[19,[1]],[39,[1]],[49,[1]],[69,[1]],[79,[1]],[99,[1]],
     [109,[1]],[129,[1]],[139,[1]]]],
 [15182,[[0,[1]],[5,[1]],[16,[1]],[20,[1]],[25,[1]],[36,[1]],[40,[1]],
     [45,[1]],[56,[1]],[60,[1]]]],
 [15184,[[1,[1,2,2,1,2,2,2,2]],[13,[1,2]],[16,[1,2,2,1,2,2,2,2]],
     [40,[1,2,2,1,2,2,2,2]],[43,[1,2]],[52,[1,2,2,1,2,2,2,2]],
     [61,[1,2,2,1,2,2,2,2]],[73,[1,2]],[76,[1,2,2,1,2,2,2,2]],
     [100,[1,2,2,1,2,2,2,2]]]],
 [15188,[[13,[1]],[17,[1]],[43,[1]],[47,[1]],[73,[1]],[77,[1]],
     [103,[1]],[107,[1]],[133,[1]],[137,[1]]]],
 [15190,[[7,[1,1,2,1,2]],[37,[1,1,2,1,2]],[41,[1,1,2,1,2]],
     [67,[1,1,2,1,2]],[97,[1,1,2,1,2]],[101,[1,1,2,1,2]],
     [127,[1,1,2,1,2]],[157,[1,1,2,1,2]],[161,[1,1,2,1,2]],
     [187,[1,1,2,1,2]]]],
 [15191,[[8,[1]],[17,[1]],[23,[1]],[32,[1]],[47,[1]],[53,[1]],[68,[1]],
     [77,[1]],[83,[1]],[92,[1]]]],
 [15192,[[7,[1,2,2,1,2,2,2,2]],[16,[1,2,2,1,2,2,2,2]],[17,[1,2]],
     [41,[1,2,2,1,2,2,2,2]],[47,[1,2]],[53,[1,2,2,1,2,2,2,2]],
     [67,[1,2,2,1,2,2,2,2]],[76,[1,2,2,1,2,2,2,2]],[77,[1,2]],
     [101,[1,2,2,1,2,2,2,2]]]],
 [15196,[[16,[1,1,2]],[37,[1,1,2]],[76,[1,1,2]],[97,[1,1,2]],[136,[1,1,2]],
     [157,[1,1,2]],[196,[1,1,2]],[217,[1,1,2]]]],
 [15197,[[7,[1]],[13,[1]],[28,[1]],[37,[1]],[43,[1]],[52,[1]],[67,[1]],
     [73,[1]],[88,[1]],[97,[1]]]],
 [15198,[[16,[1,1,2,1,2]],[23,[1,1,2,1,2]],[53,[1,1,2,1,2]],
     [76,[1,1,2,1,2]],[83,[1,1,2,1,2]],[113,[1,1,2,1,2]],
     [136,[1,1,2,1,2]],[143,[1,1,2,1,2]],[173,[1,1,2,1,2]],
     [196,[1,1,2,1,2]]]],
 [15229,[[3,[1]],[13,[1]],[15,[1]],[23,[1]],[33,[1]],[35,[1]],[43,[1]],
     [53,[1]],[55,[1]],[63,[1]]]],
 [15230,[[0,[1,2,2,2]],[9,[1,2,2,2]],[19,[1,2,2,2]],[20,[1,2,2,2]],
     [29,[1,2,2,2]],[39,[1,2,2,2]],[40,[1,2,2,2]],[49,[1,2,2,2]],
     [59,[1,2,2,2]],[60,[1,2,2,2]]]],
 [15232,[[3,[1,1,1,1,2,2,2,3]],[15,[1,1,1,1,2,2,2,3]],[28,[1]],
     [33,[1,1,1,1,2,2,2,3]],[40,[1,1,1,1,2,2,2,3]],[52,[1,1,1,1,2,2,2,3]],
     [63,[1,1,1,1,2,2,2,3]],[75,[1,1,1,1,2,2,2,3]],[88,[1]],
     [93,[1,1,1,1,2,2,2,3]]]],
 [15234,[[33,[2,3,3]],[93,[2,3,3]],[153,[2,3,3]],[213,[2,3,3]]]],
 [15240,[[7,[1,1,1,1,1,1,2,2]],[15,[1,2]],[19,[1,1,1,1,1,1,2,2]],
     [23,[1,2]],[43,[1,1,1,1,1,1,2,2]],[53,[1,2]],[55,[1,1,1,1,1,1,2,2]],
     [67,[1,1,1,1,1,1,2,2]],[75,[1,2]],[79,[1,1,1,1,1,1,2,2]]]],
 [15243,[[3,[4,4,6,6]],[15,[1,2]],[23,[3,5,4,4]],[29,[2,2,3,3]],
     [32,[1,2]],[33,[4,4,6,6]],[35,[4,4,6,6]],[40,[2,2,3,3]],
     [53,[3,5,4,4]],[59,[2,2,3,3]]]],
 [15250,[[12,[1,1,1,1,1,2]],[20,[1,1,1,1,1,2]],[27,[1,1,1,1,1,2]],
     [57,[1,1,1,1,1,2]],[72,[1,1,1,1,1,2]],[80,[1,1,1,1,1,2]],
     [87,[1,1,1,1,1,2]],[117,[1,1,1,1,1,2]],[132,[1,1,1,1,1,2]],
     [140,[1,1,1,1,1,2]]]],
 [15251,[[15,[1]],[23,[1]],[53,[1]],[75,[1]],[83,[1]],[113,[1]],
     [135,[1]],[143,[1]],[173,[1]],[195,[1]]]],
 [15252,[[15,[1,2]],[23,[1,2]],[53,[1,2]],[75,[1,2]],[83,[1,2]],
     [113,[1,2]],[135,[1,2]],[143,[1,2]],[173,[1,2]],[195,[1,2]]]],
 [15253,[[0,[1,2,3,2,2,2,2,3]],[12,[1,2,3,2,2,2,2,3]],[13,[1,2,3,2,2,2,2,3]]
      ,[24,[1]],[35,[1,2,3,2,2,2,2,3]],[43,[1,2,3,2,2,2,2,3]],
     [55,[1,2,3,2,2,2,2,3]],[60,[1,2,3,2,2,2,2,3]],[72,[1,2,3,2,2,2,2,3]],
     [73,[1,2,3,2,2,2,2,3]]]],
 [15255,[[33,[2,3,3]],[93,[2,3,3]],[153,[2,3,3]],[213,[2,3,3]]]],
 [15256,[[13,[5]],[15,[1]],[20,[5]],[32,[1]],[43,[5]],[55,[5]],[73,[5]],
     [75,[1]],[80,[5]],[92,[1]]]],
 [15257,[[9,[2,2,2,3]],[15,[2,2,2,3]],[39,[2,2,2,3]],[48,[2,2,2,3]],
     [69,[2,2,2,3]],[75,[2,2,2,3]],[99,[2,2,2,3]],[108,[2,2,2,3]],
     [129,[2,2,2,3]],[135,[2,2,2,3]]]],
 [15258,[[3,[1,1,2,2]],[15,[1,2]],[20,[1,1,2,2]],[23,[1,2]],
     [27,[1,1,2,2]],[33,[1,1,2,2]],[35,[1,1,2,2]],[53,[1,2]],
     [57,[1,1,2,2]],[63,[1,1,2,2]]]],
 [15259,[[9,[1,2,1,2,2]],[12,[1,2,1,2,2]],[27,[1,2,1,2,2]],
     [39,[1,2,1,2,2]],[57,[1,2,1,2,2]],[69,[1,2,1,2,2]],[72,[1,2,1,2,2]],
     [87,[1,2,1,2,2]],[99,[1,2,1,2,2]],[117,[1,2,1,2,2]]]],
 [15261,[[9,[1,2,3,2,3]],[15,[1,2,3,2,3]],[24,[1,2,3,2,3]],
     [27,[1,2,3,2,3]],[39,[1,2,3,2,3]],[57,[1,2,3,2,3]],[69,[1,2,3,2,3]],
     [75,[1,2,3,2,3]],[84,[1,2,3,2,3]],[87,[1,2,3,2,3]]]],
 [15279,[[4,[1,1,2,2,3,3,1,2]],[15,[1,1,2,2,3,3,1,2]],[21,[1,1,2,2,3,3,1,2]]
      ,[25,[1,1,2,2,3,3,1,2]],[28,[1]],[51,[1,1,2,2,3,3,1,2]],
     [55,[1,1,2,2,3,3,1,2]],[64,[1,1,2,2,3,3,1,2]],[75,[1,1,2,2,3,3,1,2]],
     [81,[1,1,2,2,3,3,1,2]]]],
 [15284,[[0,[1,1,1,2,2,1,2]],[31,[1,1,1,2,2,1,2]],[44,[1,1,1,2,2,1,2]],
     [61,[1,1,1,2,2,1,2]],[91,[1,1,1,2,2,1,2]],[104,[1,1,1,2,2,1,2]],
     [121,[1,1,1,2,2,1,2]],[151,[1,1,1,2,2,1,2]],[164,[1,1,1,2,2,1,2]],
     [181,[1,1,1,2,2,1,2]]]],
 [15287,[[5,[1,1,2,2,2,1,2,3]],[11,[1,1,2,2,2,1,2,3]],[15,[1,2]],
     [41,[1,1,2,2,2,1,2,3]],[43,[1,1,2,2,2,1,2,3]],[45,[1,2]],
     [55,[1,1,2,2,2,1,2,3]],[65,[1,1,2,2,2,1,2,3]],[71,[1,1,2,2,2,1,2,3]],
     [75,[1,2]]]],
 [15289,[[21,[1,2,2]],[51,[1,2,2]],[81,[1,2,2]],[111,[1,2,2]],
     [141,[1,2,2]],[171,[1,2,2]],[201,[1,2,2]],[231,[1,2,2]]]],
 [15293,[[5,[1]],[13,[1]],[28,[1]],[29,[1]],[35,[1]],[43,[1]],[59,[1]],
     [65,[1]],[73,[1]],[88,[1]]]],
 [15297,[[15,[1]],[24,[1,2,2]],[45,[1]],[75,[1]],[84,[1,2,2]],[105,[1]],
     [135,[1]],[144,[1,2,2]],[165,[1]],[195,[1]]]],
 [15300,[[0,[1,1,1,1,1,2,2,3]],[5,[1,1,1,1,1,2,2,3]],[24,[2,3]],
     [31,[1,1,1,1,1,2,2,3]],[35,[1,1,1,1,1,2,2,3]],[36,[1,1,1,1,1,2,2,3]],
     [48,[1,1,1,1,1,2,2,3]],[61,[1,1,1,1,1,2,2,3]],[65,[1,1,1,1,1,2,2,3]],
     [84,[2,3]]]],
 [15303,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [15304,[[0,[1,2,1,2,2,2]],[21,[1,2,1,2,2,2]],[31,[1,2,1,2,2,2]],
     [51,[1,2,1,2,2,2]],[61,[1,2,1,2,2,2]],[81,[1,2,1,2,2,2]],
     [91,[1,2,1,2,2,2]],[111,[1,2,1,2,2,2]],[121,[1,2,1,2,2,2]],
     [141,[1,2,1,2,2,2]]]],
 [15305,[[3,[3,4]],[9,[3,4]],[15,[2]],[21,[3,4]],[33,[3,4]],[39,[3,4]],
     [45,[2]],[48,[3,4]],[51,[3,4]],[63,[3,4]]]],
 [15306,[[15,[1,2]],[24,[1,2]],[45,[1,2]],[75,[1,2]],[84,[1,2]],
     [105,[1,2]],[135,[1,2]],[144,[1,2]],[165,[1,2]],[195,[1,2]]]],
 [15307,[[24,[1,1,1,2,2]],[84,[1,1,1,2,2]],[144,[1,1,1,2,2]],
     [204,[1,1,1,2,2]]]],
 [15321,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [15324,[[5,[2,3,3]],[25,[2,3,3]],[45,[2,3,3]],[65,[2,3,3]],[85,[2,3,3]],
     [105,[2,3,3]],[125,[2,3,3]],[145,[2,3,3]],[165,[2,3,3]],
     [185,[2,3,3]]]],
 [15329,[[19,[4]],[49,[4]],[79,[4]],[109,[4]],[139,[4]],[169,[4]],
     [199,[4]],[229,[4]]]],
 [15331,[[19,[2,3,3,4,3]],[25,[2,3,3,4,3]],[29,[2,3,3,4,3]],
     [59,[2,3,3,4,3]],[79,[2,3,3,4,3]],[85,[2,3,3,4,3]],[89,[2,3,3,4,3]],
     [119,[2,3,3,4,3]],[139,[2,3,3,4,3]],[145,[2,3,3,4,3]]]],
 [15333,[[5,[1,1,1,2,2,2,2,2]],[19,[1,1,1,2,2,2,2,2]],[29,[1,1,1,2,2,2,2,2]]
      ,[31,[1]],[40,[1,1,1,2,2,2,2,2]],[59,[1,1,1,2,2,2,2,2]],
     [65,[1,1,1,2,2,2,2,2]],[79,[1,1,1,2,2,2,2,2]],[89,[1,1,1,2,2,2,2,2]],
     [91,[1]]]],
 [15337,[[25,[5,5,6]],[85,[5,5,6]],[145,[5,5,6]],[205,[5,5,6]]]],
 [15345,[[20,[1,2,2,2,3,3,2]],[80,[1,2,2,2,3,3,2]],[140,[1,2,2,2,3,3,2]],
     [200,[1,2,2,2,3,3,2]]]],
 [15349,[[0,[1,1,1,1,2,2,1,2,3]],[9,[1,1,1,1,2,2,1,2,3]],
     [31,[1,1,1,1,2,2,1,2,3]],[32,[1,1,1,1,2,2,1,2,3]],
     [39,[1,1,1,1,2,2,1,2,3]],[40,[1,1,1,1,2,2,1,2,3]],
     [56,[1,1,1,1,2,2,1,2,3]],[61,[1,1,1,1,2,2,1,2,3]],
     [69,[1,1,1,1,2,2,1,2,3]],[91,[1,1,1,1,2,2,1,2,3]]]],
 [15353,[[12,[1]],[20,[1]],[27,[1]],[57,[1]],[72,[1]],[80,[1]],[87,[1]],
     [117,[1]],[132,[1]],[140,[1]]]],
 [15354,[[12,[1,1,1,1,1,1,2]],[21,[1,1,1,1,1,1,2]],[51,[1,1,1,1,1,1,2]],
     [72,[1,1,1,1,1,1,2]],[81,[1,1,1,1,1,1,2]],[111,[1,1,1,1,1,1,2]],
     [132,[1,1,1,1,1,1,2]],[141,[1,1,1,1,1,1,2]],[171,[1,1,1,1,1,1,2]],
     [192,[1,1,1,1,1,1,2]]]],
 [15370,[[0,[1,1,1,1,2,3,4,3]],[15,[1,1,1,1,2,3,4,3]],[25,[3]],
     [40,[1,1,1,1,2,3,4,3]],[52,[1,1,1,1,2,3,4,3]],[60,[1,1,1,1,2,3,4,3]],
     [75,[1,1,1,1,2,3,4,3]],[85,[3]],[100,[1,1,1,1,2,3,4,3]],
     [112,[1,1,1,1,2,3,4,3]]]],
 [15371,[[25,[1]],[35,[1,2,3]],[85,[1]],[95,[1,2,3]],[145,[1]],
     [155,[1,2,3]],[205,[1]],[215,[1,2,3]]]],
 [15373,[[5,[1,1,2,2,2,2,2]],[40,[1,1,2,2,2,2,2]],[65,[1,1,2,2,2,2,2]],
     [100,[1,1,2,2,2,2,2]],[125,[1,1,2,2,2,2,2]],[160,[1,1,2,2,2,2,2]],
     [185,[1,1,2,2,2,2,2]],[220,[1,1,2,2,2,2,2]],[245,[1,1,2,2,2,2,2]]]],
 [15378,[[5,[2,2,3,2,2,3,3,3]],[15,[2,2,3,2,2,3,3,3]],[31,[1]],
     [40,[2,2,3,2,2,3,3,3]],[55,[2,2,3,2,2,3,3,3]],[65,[2,2,3,2,2,3,3,3]],
     [75,[2,2,3,2,2,3,3,3]],[91,[1]],[100,[2,2,3,2,2,3,3,3]],
     [115,[2,2,3,2,2,3,3,3]]]],
 [15380,[[25,[2]],[35,[2]],[85,[2]],[95,[2]],[145,[2]],[155,[2]],
     [205,[2]],[215,[2]]]],
 [15388,[[20,[2]],[80,[2]],[140,[2]],[200,[2]]]],
 [15390,[[25,[1,1,2,1,2]],[35,[1,2,2,2]],[85,[1,1,2,1,2]],[95,[1,2,2,2]],
     [145,[1,1,2,1,2]],[155,[1,2,2,2]],[205,[1,1,2,1,2]],[215,[1,2,2,2]]]]
  ,
 [15391,[[0,[1,2,2,2,2,2,3,2]],[12,[1,2,2,2,2,2,3,2]],[20,[3]],
     [35,[1,2,2,2,2,2,3,2]],[48,[1,2,2,2,2,2,3,2]],[60,[1,2,2,2,2,2,3,2]],
     [72,[1,2,2,2,2,2,3,2]],[80,[3]],[95,[1,2,2,2,2,2,3,2]],
     [108,[1,2,2,2,2,2,3,2]]]],
 [15395,[[20,[1,1,2,2]],[80,[1,1,2,2]],[140,[1,1,2,2]],[200,[1,1,2,2]]]],
 [15396,[[3,[1,2,3,3,4,3]],[12,[3,4,5,4]],[21,[3,4,5,4]],
     [33,[1,2,3,3,4,3]],[48,[1,2,3,3,4,3]],[51,[3,4,5,4]],
     [63,[1,2,3,3,4,3]],[72,[3,4,5,4]],[81,[3,4,5,4]],[93,[1,2,3,3,4,3]] 
    ]],
 [15397,[[3,[3,4]],[33,[3,4]],[35,[3,4]],[63,[3,4]],[93,[3,4]],
     [95,[3,4]],[123,[3,4]],[153,[3,4]],[155,[3,4]],[183,[3,4]]]],
 [15398,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [15399,[[12,[1,1,2,2,2]],[21,[1,1,2,2,2]],[51,[1,1,2,2,2]],
     [72,[1,1,2,2,2]],[81,[1,1,2,2,2]],[111,[1,1,2,2,2]],
     [132,[1,1,2,2,2]],[141,[1,1,2,2,2]],[171,[1,1,2,2,2]],
     [192,[1,1,2,2,2]]]],
 [15415,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [15416,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [15417,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15418,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [15419,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [15420,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [15421,[[1,[1]],[7,[1]],[8,[1]],[13,[1]],[19,[1]],[20,[1]],[25,[1]],
     [31,[1]],[32,[1]],[37,[1]]]],
 [15422,[[4,[1]],[7,[1]],[16,[1]],[19,[1]],[28,[1]],[31,[1]],[40,[1]],
     [43,[1]],[52,[1]],[55,[1]]]],
 [15423,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15424,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [15426,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [15427,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [15428,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [15429,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [15430,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [15432,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15433,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15434,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [15435,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [15436,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],
     [64,[2,3]],[76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [15437,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [15438,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [15439,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [15440,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15441,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15448,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[103,[1,2]]]],
 [15452,[[4,[1]],[13,[1]],[28,[1]],[31,[1]],[37,[1]],[52,[1]],[67,[1]],
     [76,[1]],[85,[1]],[91,[1]]]],
 [15454,[[3,[1]],[15,[1]],[16,[1]],[39,[1]],[40,[1]],[51,[1]],[57,[1]],
     [64,[1]],[75,[1]],[88,[1]]]],
 [15455,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [15456,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15457,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [15459,[[3,[1,1,2]],[15,[1,1,2]],[27,[1,1,2]],[39,[1,1,2]],[51,[1,1,2]],
     [63,[1,1,2]],[75,[1,1,2]],[87,[1,1,2]],[99,[1,1,2]],[111,[1,1,2]]]]
  ,
 [15465,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15468,[[5,[1]],[8,[1]],[11,[1]],[17,[1]],[20,[1]],[23,[1]],[29,[1]],
     [32,[1]],[35,[1]],[41,[1]]]],
 [15471,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [15472,[[1,[2]],[3,[2]],[7,[2]],[13,[2]],[15,[2]],[19,[2]],[25,[2]],
     [27,[2]],[31,[2]],[37,[2]]]],
 [15478,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [15480,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [15481,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [15482,[[0,[1]],[3,[1]],[12,[1]],[15,[1]],[24,[1]],[27,[1]],[36,[1]],
     [39,[1]],[48,[1]],[51,[1]]]],
 [15487,[[0,[1]],[3,[2]],[5,[2]],[8,[1]],[11,[2]],[12,[1]],[15,[2]],
     [17,[2]],[20,[1]],[23,[2]]]],
 [15494,[[3,[1]],[5,[2]],[11,[2]],[15,[1]],[17,[2]],[23,[2]],[27,[1]],
     [29,[2]],[35,[2]],[39,[1]]]],
 [15505,[[1,[2]],[7,[2]],[8,[2]],[13,[2]],[19,[2]],[20,[2]],[25,[2]],
     [31,[2]],[32,[2]],[37,[2]]]],
 [15507,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15510,[[3,[1]],[8,[1]],[9,[1]],[15,[1]],[20,[1]],[21,[1]],[27,[1]],
     [32,[1]],[33,[1]],[39,[1]]]],
 [15513,[[1,[1,1,2]],[4,[1,1,2]],[7,[1,1,2]],[13,[1,1,2]],[16,[1,1,2]],
     [19,[1,1,2]],[25,[1,1,2]],[28,[1,1,2]],[31,[1,1,2]],[37,[1,1,2]]]],
 [15514,[[1,[2]],[4,[2]],[7,[2]],[13,[2]],[16,[2]],[19,[2]],[25,[2]],
     [28,[2]],[31,[2]],[37,[2]]]],[15516,[[7,fail]]],
 [15519,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [15520,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[15521,[[7,fail]]],
 [15524,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [15529,[[0,[1]],[3,[2]],[4,[1]],[8,[1]],[9,[2]],[12,[1]],[15,[2]],
     [16,[1]],[20,[1]],[21,[2]]]],
 [15536,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [15546,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [15548,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15549,[[7,[1,1,2]],[19,[1,1,2]],[31,[1,1,2]],[43,[1,1,2]],[55,[1,1,2]],
     [67,[1,1,2]],[79,[1,1,2]],[91,[1,1,2]],[103,[1,1,2]],[115,[1,1,2]]] 
  ],
 [15551,[[5,[2]],[8,[2]],[11,[2]],[17,[2]],[20,[2]],[23,[2]],[29,[2]],
     [32,[2]],[35,[2]],[41,[2]]]],
 [15555,[[1,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [15558,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [15559,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [15561,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [15572,[[0,[1]],[1,[2]],[4,[1]],[7,[2]],[8,[2]],[12,[1]],[13,[2]],
     [16,[1]],[19,[2]],[20,[2]]]],
 [15576,[[1,[2]],[7,[2]],[8,[1]],[13,[2]],[19,[2]],[20,[1]],[25,[2]],
     [31,[2]],[32,[1]],[37,[2]]]],
 [15585,[[1,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [15587,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [15588,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [15590,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [15591,[[5,[2,4]],[11,[2,4]],[17,[2,4]],[23,[2,4]],[29,[2,4]],
     [35,[2,4]],[41,[2,4]],[47,[2,4]],[53,[2,4]],[59,[2,4]]]],
 [15593,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [15595,[[1,[2,4]],[7,[2,4]],[13,[2,4]],[19,[2,4]],[25,[2,4]],[31,[2,4]],
     [37,[2,4]],[43,[2,4]],[49,[2,4]],[55,[2,4]]]],[15596,[[3,fail]]],
 [15597,[[3,fail]]],
 [15601,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15611,[[0,[1]],[1,[2]],[5,[2]],[7,[2]],[11,[2]],[12,[1]],[13,[2]],
     [17,[2]],[19,[2]],[23,[2]]]],
 [15615,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [15616,[[1,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [15617,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [15622,[[0,[1]],[5,[1]],[11,[1]],[12,[1]],[17,[1]],[23,[1]],[24,[1]],
     [29,[1]],[35,[1]],[36,[1]]]],
 [15624,[[0,[1]],[1,[1]],[7,[1]],[12,[1]],[13,[1]],[19,[1]],[24,[1]],
     [25,[1]],[31,[1]],[36,[1]]]],
 [15627,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15629,[[1,[1]],[8,[1]],[13,[1]],[20,[1]],[25,[1]],[32,[1]],[37,[1]],
     [44,[1]],[49,[1]],[56,[1]]]],
 [15631,[[7,[1,1,2]],[19,[1,1,2]],[31,[1,1,2]],[43,[1,1,2]],[55,[1,1,2]],
     [67,[1,1,2]],[79,[1,1,2]],[91,[1,1,2]],[103,[1,1,2]],[115,[1,1,2]]] 
  ],
 [15632,[[1,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [15634,[[1,[1,2]],[4,[1,2]],[7,[1,2]],[13,[1,2]],[16,[1,2]],[19,[1,2]],
     [25,[1,2]],[28,[1,2]],[31,[1,2]],[37,[1,2]]]],
 [15640,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15650,[[0,[1]],[1,[2]],[4,[1]],[7,[2]],[8,[2]],[12,[1]],[13,[2]],
     [16,[1]],[19,[2]],[20,[2]]]],
 [15654,[[1,[2]],[7,[2]],[8,[1]],[13,[2]],[19,[2]],[20,[1]],[25,[2]],
     [31,[2]],[32,[1]],[37,[2]]]],
 [15665,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15666,[[5,[1,1,2]],[8,[1,1,2]],[11,[1,1,2]],[17,[1,1,2]],[20,[1,1,2]],
     [23,[1,1,2]],[29,[1,1,2]],[32,[1,1,2]],[35,[1,1,2]],[41,[1,1,2]]]],
 [15668,[[5,[2]],[8,[2]],[11,[2]],[17,[2]],[20,[2]],[23,[2]],[29,[2]],
     [32,[2]],[35,[2]],[41,[2]]]],
 [15671,[[4,[1,1,2]],[7,[1,1,2]],[16,[1,1,2]],[19,[1,1,2]],[28,[1,1,2]],
     [31,[1,1,2]],[40,[1,1,2]],[43,[1,1,2]],[52,[1,1,2]],[55,[1,1,2]]]],
 [15672,[[1,[2]],[4,[2]],[7,[2]],[13,[2]],[16,[2]],[19,[2]],[25,[2]],
     [28,[2]],[31,[2]],[37,[2]]]],
 [15673,[[1,[1,2]],[5,[7,8]],[11,[4,5]],[17,[13,14]],[23,[4,5]],
     [29,[7,8]],[35,[4,5]],[41,[10,11]],[47,[4,5]],[53,[7,8]]]],
 [15675,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[12,[1]],[17,[1]],[20,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [15676,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [15678,[[0,[2]],[7,[2]],[8,[2]],[13,[2]],[19,[2]],[20,[2]],[25,[2]],
     [31,[2]],[32,[2]],[37,[2]]]],
 [15680,[[1,[1]],[7,[1]],[8,[1]],[13,[1]],[19,[1]],[20,[1]],[25,[1]],
     [31,[1]],[32,[1]],[37,[1]]]],
 [15681,[[0,[1,1,2]],[7,[1,1,2]],[8,[1,1,2]],[13,[1,1,2]],[19,[1,1,2]],
     [20,[1,1,2]],[25,[1,1,2]],[31,[1,1,2]],[32,[1,1,2]],[37,[1,1,2]]]],
 [15682,[[0,[1,1,2]],[1,[1,1,2]],[7,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],
     [13,[1,1,2]],[19,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],[25,[1,1,2]]]],
 [15685,[[1,[1,2,2]],[7,[1,2,2]],[8,[1,2,2]],[13,[1,2,2]],[19,[1,2,2]],
     [20,[1,2,2]],[25,[1,2,2]],[31,[1,2,2]],[32,[1,2,2]],[37,[1,2,2]]]],
 [15697,[[0,fail]]],[15698,[[0,fail]]],
 [15702,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15704,[[5,[1]],[8,[1]],[11,[1]],[17,[1]],[20,[1]],[23,[1]],[29,[1]],
     [32,[1]],[35,[1]],[41,[1]]]],
 [15705,[[5,[1,2]],[8,[1,2]],[11,[1,2]],[17,[1,2]],[20,[1,2]],[23,[1,2]],
     [29,[1,2]],[32,[1,2]],[35,[1,2]],[41,[1,2]]]],
 [15707,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [15709,[[1,[2]],[7,[2]],[8,[1]],[13,[2]],[19,[2]],[20,[1]],[25,[2]],
     [31,[2]],[32,[1]],[37,[2]]]],
 [15715,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15725,[[0,[1]],[1,[2]],[5,[1]],[7,[2]],[8,[2]],[11,[1]],[12,[1]],
     [13,[2]],[17,[1]],[19,[2]]]],
 [15726,[[0,[1]],[1,[2]],[3,[1]],[7,[2]],[8,[2]],[9,[1]],[12,[1]],
     [13,[2]],[15,[1]],[19,[2]]]],
 [15729,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [15730,[[1,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [15731,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [15736,[[0,[1]],[8,[2]],[12,[1]],[20,[2]],[24,[1]],[32,[2]],[36,[1]],
     [44,[2]],[48,[1]],[56,[2]]]],
 [15739,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15740,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [15741,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [15742,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15743,[[4,[1]],[5,[1]],[11,[1]],[16,[1]],[17,[1]],[23,[1]],[28,[1]],
     [29,[1]],[35,[1]],[40,[1]]]],
 [15744,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [15747,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15748,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [15749,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [15750,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15751,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [15752,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15753,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15754,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15755,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15756,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [15757,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [15758,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15759,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15763,[[5,[1]],[17,[1]],[19,[1]],[41,[1]],[43,[1]],[53,[1]],[59,[1]],
     [67,[1]],[77,[1]],[91,[1]]]],
 [15769,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [59,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [15770,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[105,[1,2]]]],
 [15771,[[0,[1]],[19,[1]],[21,[1]],[27,[1]],[43,[1]],[57,[1]],[67,[1]],
     [75,[1]],[81,[1]],[91,[1]]]],
 [15773,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15774,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [15776,[[5,[2]],[8,[2]],[11,[2]],[17,[2]],[20,[2]],[23,[2]],[29,[2]],
     [32,[2]],[35,[2]],[41,[2]]]],
 [15779,[[4,[2]],[5,[2]],[11,[2]],[16,[2]],[17,[2]],[23,[2]],[28,[2]],
     [29,[2]],[35,[2]],[40,[2]]]],
 [15780,[[1,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],[15781,[[5,fail]]],
 [15783,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [15786,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[15787,[[11,fail]]],
 [15792,[[0,[1,1,1,2]],[12,[1,1,1,2]],[24,[1,1,1,2]],[36,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[72,[1,1,1,2]],[84,[1,1,1,2]],
     [96,[1,1,1,2]],[108,[1,1,1,2]]]],
 [15797,[[0,[1]],[1,[2]],[4,[1]],[7,[2]],[8,[1]],[12,[1]],[13,[2]],
     [16,[1]],[19,[2]],[20,[1]]]],
 [15801,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [15810,[[5,[1,2]],[8,[1,2]],[11,[1,2]],[17,[1,2]],[20,[1,2]],[23,[1,2]],
     [29,[1,2]],[32,[1,2]],[35,[1,2]],[41,[1,2]]]],
 [15811,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [15820,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15830,[[0,[1]],[1,[2]],[5,[2]],[8,[1]],[11,[2]],[12,[1]],[13,[2]],
     [17,[2]],[20,[1]],[23,[2]]]],
 [15834,[[1,[1]],[5,[2]],[11,[2]],[13,[1]],[17,[2]],[23,[2]],[25,[1]],
     [29,[2]],[35,[2]],[37,[1]]]],
 [15845,[[4,[1]],[5,[2]],[11,[2]],[16,[1]],[17,[2]],[23,[2]],[28,[1]],
     [29,[2]],[35,[2]],[40,[1]]]],
 [15846,[[5,[2]],[8,[2]],[11,[2]],[17,[2]],[20,[2]],[23,[2]],[29,[2]],
     [32,[2]],[35,[2]],[41,[2]]]],
 [15850,[[3,[1,2]],[8,[1,2]],[9,[1,2]],[15,[1,2]],[20,[1,2]],[21,[1,2]],
     [27,[1,2]],[32,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [15851,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [15852,[[5,[1,2]],[8,[1,2]],[11,[1,2]],[17,[1,2]],[20,[1,2]],[23,[1,2]],
     [29,[1,2]],[32,[1,2]],[35,[1,2]],[41,[1,2]]]],
 [15853,[[0,[1]],[5,[1]],[8,[1]],[11,[1]],[12,[1]],[17,[1]],[20,[1]],
     [23,[1]],[24,[1]],[29,[1]]]],
 [15854,[[5,[1,2]],[8,[1,2]],[11,[1,2]],[17,[1,2]],[20,[1,2]],[23,[1,2]],
     [29,[1,2]],[32,[1,2]],[35,[1,2]],[41,[1,2]]]],
 [15855,[[3,[1]],[8,[1]],[9,[1]],[15,[1]],[20,[1]],[21,[1]],[27,[1]],
     [32,[1]],[33,[1]],[39,[1]]]],
 [15856,[[3,[1,2]],[8,[1,2]],[9,[1,2]],[15,[1,2]],[20,[1,2]],[21,[1,2]],
     [27,[1,2]],[32,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [15857,[[0,[1]],[3,[1]],[8,[1]],[9,[1]],[12,[1]],[15,[1]],[20,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [15858,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [15859,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [15860,[[3,[1]],[8,[1]],[9,[1]],[15,[1]],[20,[1]],[21,[1]],[27,[1]],
     [32,[1]],[33,[1]],[39,[1]]]],
 [15861,[[0,[1]],[3,[2]],[8,[1]],[9,[2]],[12,[1]],[15,[2]],[20,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [15865,[[5,[1]],[8,[1]],[11,[1]],[17,[2]],[20,[1]],[29,[3]],[32,[1]],
     [35,[2]],[44,[1]],[53,[10]]]],
 [15871,[[5,[1,2]],[8,[3]],[17,[1,2]],[20,[4,5]],[32,[3]],[35,[1,2]],
     [41,[2,4]],[44,[3]],[56,[3]],[59,[5,7]]]],
 [15872,[[3,[1,2]],[8,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],[20,[1,2]],
     [23,[1,2]],[32,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [15873,[[0,[1]],[8,[1]],[9,[1]],[11,[1]],[17,[1]],[20,[1]],[27,[1]],
     [32,[1]],[33,[1]],[35,[1]]]],
 [15875,[[5,[1]],[8,[1]],[11,[1]],[17,[1]],[20,[1]],[23,[1]],[29,[1]],
     [32,[1]],[35,[1]],[41,[1]]]],
 [15876,[[0,[1]],[4,[1]],[8,[2]],[12,[1]],[16,[1]],[20,[2]],[24,[1]],
     [28,[1]],[32,[2]],[36,[1]]]],[15880,[[9,fail]]],[15881,[[15,fail]]],
 [15885,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15895,[[0,[1]],[1,[2]],[4,[1]],[7,[2]],[8,[1]],[12,[1]],[13,[2]],
     [16,[1]],[19,[2]],[20,[1]]]],
 [15899,[[1,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [15910,[[1,[1,2]],[4,[1,2]],[7,[1,2]],[13,[1,2]],[16,[1,2]],[19,[1,2]],
     [25,[1,2]],[28,[1,2]],[31,[1,2]],[37,[1,2]]]],
 [15916,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [15925,[[0,[1]],[3,[1]],[4,[2]],[5,[2]],[9,[1]],[11,[2]],[12,[1]],
     [15,[1]],[16,[2]],[17,[2]]]],
 [15926,[[0,[1]],[1,[1]],[4,[2]],[5,[2]],[7,[1]],[11,[2]],[12,[1]],
     [13,[1]],[16,[2]],[17,[2]]]],
 [15930,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [15931,[[1,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [15932,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [15939,[[0,[1]],[4,[2]],[12,[1]],[16,[2]],[24,[1]],[28,[2]],[36,[1]],
     [40,[2]],[48,[1]],[52,[2]]]],
 [15940,[[1,[2]],[4,[2]],[7,[2]],[13,[2]],[16,[2]],[19,[2]],[25,[2]],
     [28,[2]],[31,[2]],[37,[2]]]],
 [15942,[[1,[4,5]],[7,[10,11]],[13,[4,5]],[19,[7,8]],[25,[4,5]],
     [31,[16,17]],[37,[4,5]],[43,[7,8]],[49,[4,5]],[55,[10,11]]]],
 [15943,[[0,[1,1,2]],[4,[1,1,2]],[5,[1,1,2]],[11,[1,1,2]],[12,[1,1,2]],
     [16,[1,1,2]],[17,[1,1,2]],[23,[1,1,2]],[24,[1,1,2]],[28,[1,1,2]]]],
 [15945,[[0,[1,1,2]],[7,[1,1,2]],[13,[1,1,2]],[19,[1,1,2]],[25,[1,1,2]],
     [31,[1,1,2]],[37,[1,1,2]],[43,[1,1,2]],[49,[1,1,2]],[55,[1,1,2]]]],
 [15946,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],[15947,[[4,fail]]],
 [15948,[[0,[1,1,2]],[1,[1,1,2]],[7,[1,1,2]],[12,[1,1,2]],[13,[1,1,2]],
     [19,[1,1,2]],[24,[1,1,2]],[25,[1,1,2]],[31,[1,1,2]],[36,[1,1,2]]]],
 [15949,[[0,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [15950,[[0,[1]],[1,[1]],[4,[1]],[7,[1]],[12,[1]],[13,[1]],[16,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [15952,[[0,[1,1,1,2]],[4,[1,1,1,2]],[5,[1,1,1,2]],[11,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[17,[1,1,1,2]],[23,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],[15965,[[0,fail]]],[15966,[[0,fail]]],
 [15972,[[0,[1]],[3,[1]],[4,[1]],[9,[1]],[12,[1]],[15,[1]],[16,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [15973,[[0,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [15974,[[0,[2]],[3,[2]],[7,[2]],[13,[2]],[15,[2]],[19,[2]],[25,[2]],
     [27,[2]],[31,[2]],[37,[2]]]],
 [15975,[[0,[1]],[1,[1]],[4,[1]],[7,[1]],[12,[1]],[13,[1]],[16,[1]],
     [19,[1]],[24,[1]],[25,[1]]]],
 [15976,[[0,[2,3]],[4,[2,3]],[7,[2,3]],[13,[2,3]],[16,[2,3]],[19,[2,3]],
     [25,[2,3]],[28,[2,3]],[31,[2,3]],[37,[2,3]]]],
 [15977,[[0,[2]],[1,[2]],[7,[2]],[12,[2]],[13,[2]],[19,[2]],[24,[2]],
     [25,[2]],[31,[2]],[36,[2]]]],
 [15978,[[0,[2]],[4,[2]],[7,[2]],[13,[2]],[16,[2]],[19,[2]],[25,[2]],
     [28,[2]],[31,[2]],[37,[2]]]],
 [15979,[[0,[2]],[3,[2]],[7,[2]],[13,[2]],[15,[2]],[19,[2]],[25,[2]],
     [27,[2]],[31,[2]],[37,[2]]]],
 [15980,[[0,[1]],[3,[2]],[4,[1]],[9,[2]],[12,[1]],[15,[2]],[16,[1]],
     [21,[2]],[24,[1]],[27,[2]]]],
 [15981,[[0,[1]],[3,[1]],[4,[1]],[9,[1]],[12,[1]],[15,[1]],[16,[1]],
     [21,[1]],[24,[1]],[27,[1]]]],
 [15988,[[1,[1,2]],[4,[3]],[13,[2,4]],[16,[3]],[28,[4,5]],[37,[1,2]],
     [40,[3]],[49,[3,6]],[52,[3]],[55,[1,2]]]],
 [15992,[[1,[1]],[4,[1]],[7,[2]],[16,[1]],[19,[5]],[28,[1]],[40,[1]],
     [43,[4]],[52,[1]],[55,[4]]]],
 [15994,[[0,[1]],[4,[1]],[7,[1]],[9,[1]],[16,[1]],[19,[1]],[25,[1]],
     [27,[1]],[28,[1]],[31,[1]]]],
 [15995,[[0,[2]],[1,[2]],[4,[2]],[13,[2]],[16,[2]],[19,[2]],[21,[2]],
     [25,[2]],[27,[2]],[28,[2]]]],
 [15996,[[0,[1]],[4,[2]],[8,[1]],[12,[1]],[16,[2]],[20,[1]],[24,[1]],
     [28,[2]],[32,[1]],[36,[1]]]],
 [15997,[[1,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [15999,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[16001,[[5,fail]]],
 [16003,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [16004,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [16024,[[3,fail]]],[16025,[[0,fail]]],[16026,[[0,fail]]],
 [16030,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [16031,[[7,[2,4]],[19,[2,4]],[31,[2,4]],[43,[2,4]],[55,[2,4]],
     [67,[2,4]],[79,[2,4]],[91,[2,4]],[103,[2,4]],[115,[2,4]]]],
 [16032,[[7,fail]]],[16033,[[7,fail]]],[16051,[[0,fail]]],[16052,[[0,fail]]],
 [16053,[[0,fail]]],
 [16054,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [16055,[[3,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],[23,[1,2]],
     [27,[1,2]],[29,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [16056,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [16059,[[3,[1]],[8,[1]],[9,[1]],[15,[1]],[20,[1]],[21,[1]],[27,[1]],
     [32,[1]],[33,[1]],[39,[1]]]],
 [16061,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [16067,[[0,[2]],[3,[2]],[4,[1]],[8,[1]],[9,[2]],[12,[2]],[15,[2]],
     [16,[1]],[20,[1]],[21,[2]]]],
 [16071,[[0,[1]],[3,[2]],[9,[2]],[12,[1]],[15,[2]],[21,[2]],[24,[1]],
     [27,[2]],[33,[2]],[36,[1]]]],
 [16081,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],[16082,[[5,fail]]],
 [16084,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [16086,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [16087,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [16092,[[0,[2]],[3,[2]],[4,[1]],[7,[2]],[9,[2]],[13,[2]],[15,[2]],
     [16,[1]],[19,[2]],[21,[2]]]],
 [16095,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [16096,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [16097,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [16102,[[3,[1]],[4,[1]],[9,[1]],[15,[1]],[16,[1]],[21,[1]],[27,[1]],
     [28,[1]],[33,[1]],[39,[1]]]],
 [16103,[[0,[1]],[4,[1]],[7,[1]],[13,[1]],[16,[1]],[19,[1]],[25,[1]],
     [28,[1]],[31,[1]],[37,[1]]]],
 [16105,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [16107,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [16108,[[3,[1,1,2]],[7,[1]],[15,[1,1,2]],[19,[1]],[27,[1,1,2]],
     [31,[1]],[39,[1,1,2]],[43,[1]],[51,[1,1,2]],[55,[1]]]],
 [16109,[[0,[1,1,2]],[3,[1,1,2]],[7,[1,1,2]],[13,[1,1,2]],[15,[1,1,2]],
     [19,[1,1,2]],[25,[1,1,2]],[27,[1,1,2]],[31,[1,1,2]],[37,[1,1,2]]]],
 [16110,[[3,[3]],[5,[3]],[11,[3]],[15,[3]],[17,[3]],[23,[3]],[27,[3]],
     [29,[3]],[35,[3]],[39,[3]]]],
 [16111,[[3,[1]],[5,[1]],[11,[1]],[15,[1]],[17,[1]],[23,[1]],[27,[1]],
     [29,[1]],[35,[1]],[39,[1]]]],
 [16121,[[3,[1,2]],[5,[3]],[11,[3]],[15,[1,2]],[17,[3]],[23,[3]],
     [27,[1,2]],[29,[3]],[35,[3]],[39,[1,2]]]],[16124,[[3,fail]]],
 [16125,[[0,fail]]],
 [16126,[[3,[1,2]],[8,[1,2]],[15,[1,2]],[20,[1,2]],[27,[1,2]],[32,[1,2]],
     [39,[1,2]],[44,[1,2]],[51,[1,2]],[56,[1,2]]]],
 [16130,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [16131,[[0,[2]],[7,[2]],[8,[2]],[13,[2]],[19,[2]],[20,[2]],[25,[2]],
     [31,[2]],[32,[2]],[37,[2]]]],
 [16132,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [16133,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [16134,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [16135,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [16136,[[0,[3]],[12,[3]],[24,[3]],[36,[3]],[48,[3]],[60,[3]],[72,[3]],
     [84,[3]],[96,[3]],[108,[3]]]],
 [16140,[[0,[1]],[11,[1]],[24,[1]],[29,[1]],[35,[1]],[48,[1]],[65,[1]],
     [72,[1]],[83,[1]],[89,[1]]]],
 [16141,[[0,[1]],[12,[1]],[13,[1]],[36,[1]],[37,[1]],[49,[1]],[55,[1]],
     [60,[1]],[73,[1]],[84,[1]]]],
 [16145,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [55,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [16146,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [16149,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [16151,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[16152,[[7,fail]]],[16157,[[7,fail]]],
 [16171,[[4,fail]]],[16172,[[4,fail]]],[16173,[[0,fail]]],
 [16175,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [16178,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [16180,[[0,[2]],[3,[2]],[8,[1]],[9,[2]],[12,[2]],[15,[2]],[20,[1]],
     [21,[2]],[24,[2]],[27,[2]]]],
 [16187,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [16195,[[0,[2]],[7,[2]],[8,[2]],[13,[2]],[19,[2]],[20,[2]],[25,[2]],
     [31,[2]],[32,[2]],[37,[2]]]],
 [16196,[[3,[2]],[8,[1]],[9,[2]],[15,[2]],[20,[1]],[21,[2]],[27,[2]],
     [32,[1]],[33,[2]],[39,[2]]]],
 [16197,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [16207,[[3,[2,4]],[9,[2,4]],[15,[2,4]],[21,[2,4]],[27,[2,4]],[33,[2,4]],
     [39,[2,4]],[45,[2,4]],[51,[2,4]],[57,[2,4]]]],[16210,[[7,fail]]],
 [16211,[[0,fail]]],
 [16212,[[4,[1]],[8,[2]],[16,[1]],[20,[2]],[28,[1]],[32,[2]],[40,[1]],
     [44,[2]],[52,[1]],[56,[2]]]],
 [16217,[[0,[1,1,1,2]],[12,[1,1,1,2]],[24,[1,1,1,2]],[36,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[72,[1,1,1,2]],[84,[1,1,1,2]],
     [96,[1,1,1,2]],[108,[1,1,1,2]]]],
 [16218,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [16219,[[0,[2]],[3,[2]],[4,[1]],[8,[1]],[9,[2]],[12,[2]],[15,[2]],
     [16,[1]],[20,[1]],[21,[2]]]],
 [16226,[[0,[1]],[3,[2]],[9,[2]],[12,[1]],[15,[2]],[21,[2]],[24,[1]],
     [27,[2]],[33,[2]],[36,[1]]]],
 [16234,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [16239,[[0,[2]],[3,[3]],[4,[1]],[8,[1]],[9,[3]],[12,[2]],[15,[3]],
     [16,[1]],[20,[1]],[21,[3]]]],
 [16243,[[0,[1]],[3,[3]],[9,[3]],[12,[1]],[15,[3]],[21,[3]],[24,[1]],
     [27,[3]],[33,[3]],[36,[1]]]],[16245,[[3,fail]]],
 [16256,[[0,[2]],[3,[3]],[4,[1]],[9,[3]],[12,[2]],[15,[3]],[16,[1]],
     [21,[3]],[24,[2]],[27,[3]]]],
 [16260,[[0,[1]],[3,[2]],[9,[2]],[12,[1]],[15,[2]],[21,[2]],[24,[1]],
     [27,[2]],[33,[2]],[36,[1]]]],[16262,[[3,fail]]],
 [16266,[[3,[1]],[16,[1]],[21,[1]],[39,[1]],[40,[1]],[57,[1]],[64,[1]],
     [75,[1]],[88,[1]],[93,[1]]]],
 [16267,[[0,[2,3]],[4,[2,3]],[12,[2,3]],[16,[2,3]],[24,[2,3]],[28,[2,3]],
     [36,[2,3]],[40,[2,3]],[48,[2,3]],[52,[2,3]]]],
 [16270,[[0,[2]],[3,[3]],[8,[1]],[9,[3]],[12,[2]],[15,[3]],[20,[1]],
     [21,[3]],[24,[2]],[27,[3]]]],
 [16277,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [16283,[[0,[3,3,4]],[8,[1,2,2]],[12,[3,3,4]],[20,[1,2,2]],[24,[3,3,4]],
     [32,[1,2,2]],[36,[3,3,4]],[44,[1,2,2]],[48,[3,3,4]],[56,[1,2,2]]]],
 [16284,[[0,[2]],[8,[1]],[12,[2]],[20,[1]],[24,[2]],[32,[1]],[36,[2]],
     [44,[1]],[48,[2]],[56,[1]]]],
 [16285,[[0,[2]],[3,[3]],[4,[1]],[8,[1]],[9,[3]],[12,[2]],[15,[3]],
     [16,[1]],[20,[1]],[21,[3]]]],
 [16292,[[0,[1]],[3,[3]],[9,[3]],[12,[1]],[15,[3]],[21,[3]],[24,[1]],
     [27,[3]],[33,[3]],[36,[1]]]],[16294,[[3,fail]]],
 [16308,[[0,[3]],[3,[1]],[5,[1]],[8,[6]],[9,[5]],[12,[3]],[15,[1]],
     [17,[6]],[20,[2]],[24,[8]]]],
 [16309,[[0,[1]],[3,[2]],[4,[4]],[8,[6]],[11,[1]],[15,[3]],[16,[16]],
     [17,[4]],[20,[7]],[23,[1]]]],
 [16312,[[0,[2]],[4,[2]],[5,[1]],[8,[2]],[11,[1]],[12,[2]],[16,[2]],
     [17,[1]],[20,[2]],[23,[1]]]],
 [16313,[[0,[2]],[3,[1]],[4,[2]],[8,[2]],[9,[1]],[12,[2]],[15,[1]],
     [16,[2]],[20,[2]],[21,[1]]]],
 [16315,[[0,[6]],[1,[1]],[5,[2]],[8,[8]],[12,[2]],[13,[1]],[17,[3]],
     [19,[3]],[20,[6]],[24,[4]]]],
 [16316,[[0,[2]],[4,[5]],[5,[1]],[7,[5]],[12,[6]],[16,[2]],[17,[1]],
     [23,[3]],[24,[4]],[25,[2]]]],
 [16324,[[0,[2]],[4,[2]],[5,[1]],[8,[2]],[11,[1]],[12,[2]],[16,[2]],
     [17,[1]],[20,[2]],[23,[1]]]],
 [16326,[[0,[2]],[1,[1]],[4,[2]],[7,[1]],[8,[2]],[12,[2]],[13,[1]],
     [16,[2]],[19,[1]],[20,[2]]]],
 [16332,[[0,[4]],[1,[1]],[3,[1]],[4,[11]],[7,[2]],[12,[2]],[15,[1]],
     [16,[7]],[19,[3]],[21,[6]]]],
 [16334,[[0,[3]],[4,[6]],[7,[1]],[8,[3]],[9,[7]],[16,[2]],[19,[1]],
     [20,[3]],[25,[7]],[27,[2]]]],
 [16336,[[0,[2]],[3,[1]],[4,[2]],[8,[2]],[9,[1]],[12,[2]],[15,[1]],
     [16,[2]],[20,[2]],[21,[1]]]],
 [16337,[[0,[2]],[1,[1]],[4,[2]],[7,[1]],[8,[2]],[12,[2]],[13,[1]],
     [16,[2]],[19,[1]],[20,[2]]]],
 [16366,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[11,[1]],[12,[1]],[16,[1]],
     [17,[1]],[20,[1]],[23,[1]]]],
 [16367,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [16368,[[0,[1]],[1,[1]],[4,[1]],[7,[1]],[8,[1]],[12,[1]],[13,[1]],
     [16,[1]],[19,[1]],[20,[1]]]],
 [16374,[[0,[1]],[3,[1]],[4,[1]],[8,[1]],[9,[1]],[12,[1]],[15,[1]],
     [16,[1]],[20,[1]],[21,[1]]]],
 [16375,[[0,[1]],[1,[1]],[4,[1]],[7,[1]],[8,[1]],[12,[1]],[13,[1]],
     [16,[1]],[19,[1]],[20,[1]]]],
 [16376,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [16381,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [16382,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[11,[1]],[12,[1]],[16,[1]],
     [17,[1]],[20,[1]],[23,[1]]]],
 [16383,[[0,[1]],[3,[1]],[4,[1]],[8,[1]],[9,[1]],[12,[1]],[15,[1]],
     [16,[1]],[20,[1]],[21,[1]]]],
 [16405,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [16426,[[0,[1,1,2,2]],[11,[1,1,2,2]],[12,[1,1,2,2]],[23,[1,1,2,2]],
     [24,[1,1,2,2]],[35,[1,1,2,2]],[36,[1,1,2,2]],[47,[1,1,2,2]],
     [48,[1,1,2,2]],[59,[1,1,2,2]]]],
 [16430,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [16432,[[4,[1,2]],[7,[1]],[16,[1,2]],[19,[1]],[28,[1,2]],[31,[1]],
     [40,[1,2]],[43,[1]],[52,[1,2]],[55,[1]]]],
 [16433,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [16435,[[3,[1]],[4,[1]],[7,[1]],[11,[1]],[15,[1]],[16,[1]],[19,[1]],
     [23,[1]],[27,[1]],[28,[1]]]],
 [16436,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[11,[1,2]],[12,[1,2]],[15,[1,2]],
     [19,[1,2]],[23,[1,2]],[24,[1,2]],[27,[1,2]]]],
 [16439,[[7,[1,2]],[8,[1,2]],[19,[1,2]],[20,[1,2]],[31,[1,2]],[32,[1,2]],
     [43,[1,2]],[44,[1,2]],[55,[1,2]],[56,[1,2]]]],
 [16441,[[3,[1,2]],[7,[1,2]],[8,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [20,[1,2]],[23,[1,2]],[27,[1,2]],[31,[1,2]]]],
 [16443,[[8,[1,2]],[11,[1]],[20,[1,2]],[23,[1]],[32,[1,2]],[35,[1]],
     [44,[1,2]],[47,[1]],[56,[1,2]],[59,[1]]]],
 [16445,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [16446,[[3,[1,2]],[4,[1,2]],[15,[1,2]],[16,[1,2]],[27,[1,2]],[28,[1,2]],
     [39,[1,2]],[40,[1,2]],[51,[1,2]],[52,[1,2]]]],
 [16447,[[0,[1,2]],[3,[1]],[12,[1,2]],[15,[1]],[24,[1,2]],[27,[1]],
     [36,[1,2]],[39,[1]],[48,[1,2]],[51,[1]]]],
 [16448,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [16449,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [16450,[[0,[1,1,2]],[4,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],[24,[1,1,2]],
     [28,[1,1,2]],[36,[1,1,2]],[40,[1,1,2]],[48,[1,1,2]],[52,[1,1,2]]]],
 [16451,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],[16457,[[4,fail]]],[16458,[[0,fail]]],
 [16459,[[8,fail]]],
 [16465,[[2,[2]],[6,[2]],[10,[2]],[14,[2]],[18,[2]],[22,[2]],[26,[2]],
     [30,[2]],[34,[2]],[38,[2]]]],
 [16477,[[3,[1]],[7,[1]],[10,[1]],[15,[1]],[19,[1]],[22,[1]],[27,[1]],
     [31,[1]],[34,[1]],[39,[1]]]],
 [16480,[[2,[1]],[7,[1]],[11,[1]],[14,[1]],[19,[1]],[23,[1]],[26,[1]],
     [31,[1]],[35,[1]],[38,[1]]]],
 [16481,[[2,[1,2]],[7,[1]],[11,[1,2]],[15,[1,2]],[19,[1]],[23,[1,2]],
     [27,[1,2]],[31,[1]],[35,[1,2]],[39,[1,2]]]],
 [16484,[[2,[1,2,2]],[7,[1]],[11,[1,2,2]],[14,[1,2,2]],[19,[1]],
     [23,[1,2,2]],[26,[1,2,2]],[31,[1]],[35,[1,2,2]],[38,[1,2,2]]]],
 [16490,[[3,[1,1,2]],[7,[1,2]],[10,[1,1,2]],[15,[1,1,2]],[19,[1,2]],
     [22,[1,1,2]],[27,[1,1,2]],[31,[1,2]],[34,[1,1,2]],[39,[1,1,2]]]],
 [16495,[[3,[1]],[6,[1]],[11,[1]],[15,[1]],[18,[1]],[23,[1]],[27,[1]],
     [30,[1]],[35,[1]],[39,[1]]]],
 [16496,[[3,[1,1,1,2]],[7,[1,2]],[11,[1,1,1,2]],[15,[1,1,1,2]],[19,[1,2]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[31,[1,2]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [16497,[[3,[1,1,1,2]],[7,[1]],[11,[1,1,1,2]],[15,[1,1,1,2]],[19,[1]],
     [23,[1,1,1,2]],[27,[1,1,1,2]],[31,[1]],[35,[1,1,1,2]],
     [39,[1,1,1,2]]]],
 [16512,[[2,[1,1,1,2]],[7,[1]],[10,[1,1,1,2]],[11,[1,1,1,2]],
     [18,[1,1,1,2]],[19,[1]],[23,[1,1,1,2]],[26,[1,1,1,2]],[31,[1]],
     [34,[1,1,1,2]]]],
 [16513,[[2,[1,1,1,2]],[6,[1,1,1,2]],[7,[1]],[14,[1,1,1,2]],
     [15,[1,1,1,2]],[19,[1]],[22,[1,1,1,2]],[27,[1,1,1,2]],
     [30,[1,1,1,2]],[31,[1]]]],
 [16514,[[3,[1]],[6,[1,2]],[11,[1]],[14,[1,2]],[15,[1]],[22,[1,2]],
     [23,[1]],[27,[1]],[30,[1,2]],[35,[1]]]],
 [16522,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [16523,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [16540,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [16545,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [16548,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [16549,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [16550,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [16551,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [16554,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [16556,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [16560,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [16561,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [16563,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [16564,[[2,[1,2]],[6,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[30,[1,2]]]],
 [16565,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [16566,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [16576,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [16577,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [16578,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [16579,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [16590,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [16592,[[2,[1,2]],[6,[1]],[10,[1,2]],[14,[1,2]],[18,[1]],[22,[1,2]],
     [26,[1,2]],[30,[1]],[34,[1,2]],[38,[1,2]]]],
 [16593,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [16596,[[2,[1,2,2]],[6,[1]],[10,[1,2,2]],[14,[1,2,2]],[18,[1]],
     [22,[1,2,2]],[26,[1,2,2]],[30,[1]],[34,[1,2,2]],[38,[1,2,2]]]],
 [16599,[[2,[1,1,1,2]],[6,[1,2]],[10,[1,1,1,2]],[14,[1,1,1,2]],[18,[1,2]],
     [22,[1,1,1,2]],[26,[1,1,1,2]],[30,[1,2]],[34,[1,1,1,2]],
     [38,[1,1,1,2]]]],
 [16604,[[2,[1]],[6,[1,2]],[10,[1]],[14,[1]],[18,[1,2]],[22,[1]],
     [26,[1]],[30,[1,2]],[34,[1]],[38,[1]]]],
 [16608,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [16616,[[2,[1,1,1,2]],[6,[1]],[10,[1,1,1,2]],[14,[1,1,1,2]],[18,[1]],
     [22,[1,1,1,2]],[26,[1,1,1,2]],[30,[1]],[34,[1,1,1,2]],
     [38,[1,1,1,2]]]],
 [16623,[[2,[1,1,1,2]],[6,[1]],[7,[1,1,1,2]],[14,[1,1,1,2]],
     [15,[1,1,1,2]],[18,[1]],[23,[1,1,1,2]],[26,[1,1,1,2]],[30,[1]],
     [31,[1,1,1,2]]]],
 [16624,[[2,[1,1,1,2]],[6,[1]],[10,[1,1,1,2]],[11,[1,1,1,2]],[18,[1]],
     [19,[1,1,1,2]],[22,[1,1,1,2]],[27,[1,1,1,2]],[30,[1]],
     [34,[1,1,1,2]]]],
 [16631,[[2,[1]],[6,[1,2]],[10,[1]],[14,[1]],[15,[1,2]],[22,[1]],
     [23,[1,2]],[26,[1]],[31,[1,2]],[34,[1]]]],
 [16635,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [16639,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [16640,[[0,[1]],[20,[1]],[40,[1]],[60,[1]],[80,[1]],[100,[1]],
     [120,[1]],[140,[1]],[160,[1]],[180,[1]]]],
 [16641,[[4,[1,2]],[24,[1,2]],[44,[1,2]],[64,[1,2]],[84,[1,2]],
     [104,[1,2]],[124,[1,2]],[144,[1,2]],[164,[1,2]],[184,[1,2]]]],
 [16642,[[6,[1]],[26,[1]],[46,[1]],[66,[1]],[86,[1]],[106,[1]],
     [126,[1]],[146,[1]],[166,[1]],[186,[1]]]],
 [16643,[[10,[1,2]],[30,[1,2]],[50,[1,2]],[70,[1,2]],[90,[1,2]],
     [110,[1,2]],[130,[1,2]],[150,[1,2]],[170,[1,2]],[190,[1,2]]]],
 [16645,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [16652,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [16653,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [16654,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [16658,[[0,[1]],[4,[1]],[10,[1]],[12,[1]],[16,[1]],[22,[1]],[24,[1]],
     [28,[1]],[34,[1]],[36,[1]]]],
 [16665,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [16666,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [16671,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [16672,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [16675,[[4,[1,2]],[6,[1,2]],[10,[1,2]],[16,[1,2]],[18,[1,2]],[22,[1,2]],
     [28,[1,2]],[30,[1,2]],[34,[1,2]],[40,[1,2]]]],[16676,[[2,fail]]],
 [16678,[[0,[1,2]],[2,[1]],[6,[1]],[8,[1,2]],[12,[1,2]],[14,[1]],
     [18,[1]],[20,[1,2]],[24,[1,2]],[26,[1]]]],
 [16679,[[0,[1,1,1,2]],[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [16686,[[2,[1]],[4,[1,2]],[8,[1,2]],[10,[1]],[14,[1]],[16,[1,2]],
     [20,[1,2]],[22,[1]],[26,[1]],[28,[1,2]]]],
 [16706,[[12,[1]],[43,[1]],[72,[1]],[103,[1]],[132,[1]],[163,[1]],
     [192,[1]],[223,[1]],[252,[1]]]],
 [16710,[[8,[1,1,1,1,2]],[38,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [68,[1,1,1,1,2]],[98,[1,1,1,1,2]],[112,[1,1,1,1,2]],
     [128,[1,1,1,1,2]],[158,[1,1,1,1,2]],[172,[1,1,1,1,2]],
     [188,[1,1,1,1,2]]]],
 [16714,[[12,[1]],[43,[1]],[72,[1]],[103,[1]],[132,[1]],[163,[1]],
     [192,[1]],[223,[1]],[252,[1]]]],
 [16716,[[0,[1,1,1,2,1,1,2,2]],[8,[1]],[11,[1,1,1,2,1,1,2,2]],
     [12,[1,1,1,2,1,1,2,2]],[18,[1]],[20,[1,1,1,2,1,1,2,2]],
     [23,[1,1,1,2,1,1,2,2]],[31,[1,1,1,2,1,1,2,2]],[36,[1,1,1,2,1,1,2,2]],
     [38,[1]]]],
 [16719,[[7,[1,1,1,1,1,1,2,2]],[10,[1,1,1,1,1,1,2,2]],[31,[1]],
     [40,[1,1,1,1,1,1,2,2]],[43,[1,1,1,1,1,1,2,2]],[55,[1,1,1,1,1,1,2,2]],
     [67,[1,1,1,1,1,1,2,2]],[70,[1,1,1,1,1,1,2,2]],[91,[1]],
     [100,[1,1,1,1,1,1,2,2]]]],
 [16721,[[3,[1,1,1,1,2,2,1,2]],[7,[1,1,1,1,2,2,1,2]],[8,[1,1,1,1,2,2,1,2]],
     [16,[1,1,1,1,2,2,1,2]],[20,[1]],[27,[1,1,1,1,2,2,1,2]],
     [28,[1,1,1,1,2,2,1,2]],[32,[1,1,1,1,2,2,1,2]],[38,[1,1,1,1,2,2,1,2]],
     [40,[1]]]],
 [16725,[[6,[1,1,1,1,2,1,1,2]],[8,[1,1,1,1,2,1,1,2]],[30,[1]],
     [38,[1,1,1,1,2,1,1,2]],[42,[1,1,1,1,2,1,1,2]],[52,[1,1,1,1,2,1,1,2]],
     [66,[1,1,1,1,2,1,1,2]],[68,[1,1,1,1,2,1,1,2]],[90,[1]],
     [98,[1,1,1,1,2,1,1,2]]]],
 [16726,[[3,[1,1,1,1,2,1,1,2]],[15,[1,1,1,1,2,1,1,2]],[18,[1,1,1,1,2,1,1,2]]
      ,[27,[1]],[48,[1,1,1,1,2,1,1,2]],[51,[1,1,1,1,2,1,1,2]],
     [63,[1,1,1,1,2,1,1,2]],[75,[1,1,1,1,2,1,1,2]],[78,[1,1,1,1,2,1,1,2]],
     [87,[1]]]],[16727,[[23,[1]],[83,[1]],[143,[1]],[203,[1]]]],
 [16728,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [16731,[[0,[1,1,1,2,1,1,2,2]],[6,[1,1,1,2,1,1,2,2]],[8,[1]],
     [12,[1,1,1,2,1,1,2,2]],[18,[1]],[20,[1,1,1,2,1,1,2,2]],
     [26,[1,1,1,2,1,1,2,2]],[32,[1,1,1,2,1,1,2,2]],[36,[1,1,1,2,1,1,2,2]],
     [38,[1]]]],
 [16758,[[16,[1]],[47,[1]],[76,[1]],[107,[1]],[136,[1]],[167,[1]],
     [196,[1]],[227,[1]]]],
 [16765,[[27,[1]],[87,[1]],[147,[1]],[207,[1]]]],
 [16766,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [16767,[[10,[1]],[19,[1]],[24,[1]],[55,[1]],[70,[1]],[79,[1]],[84,[1]],
     [115,[1]],[130,[1]],[139,[1]]]],
 [16768,[[0,[1,1,1,1,2,2]],[22,[1,1,1,1,2,2]],[27,[1,1,1,1,2,2]],
     [40,[1,1,1,1,2,2]],[42,[1,1,1,1,2,2]],[47,[1,1,1,1,2,2]],
     [60,[1,1,1,1,2,2]],[82,[1,1,1,1,2,2]],[87,[1,1,1,1,2,2]],
     [100,[1,1,1,1,2,2]]]],
 [16769,[[0,[1,1,1,1,1,1,1,2]],[7,[3]],[12,[1,1,1,1,1,1,1,2]],
     [19,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],
     [32,[1,1,1,1,1,1,1,2]],[36,[1,1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,1,2]],
     [44,[1,1,1,1,1,1,1,2]]]],
 [16772,[[7,[1,1,1,1,2,1,1,2]],[19,[1,1,1,1,2,1,1,2]],[22,[1,1,1,1,2,1,1,2]]
      ,[31,[1]],[52,[1,1,1,1,2,1,1,2]],[55,[1,1,1,1,2,1,1,2]],
     [67,[1,1,1,1,2,1,1,2]],[79,[1,1,1,1,2,1,1,2]],[82,[1,1,1,1,2,1,1,2]],
     [91,[1]]]],
 [16778,[[6,[1,1,1,1,1,1,2,2]],[16,[1,1,1,1,1,1,2,2]],[20,[1,1,1,1,1,1,2,2]]
      ,[30,[1]],[51,[1,1,1,1,1,1,2,2]],[54,[1,1,1,1,1,1,2,2]],
     [66,[1,1,1,1,1,1,2,2]],[76,[1,1,1,1,1,1,2,2]],[80,[1,1,1,1,1,1,2,2]],
     [90,[1]]]],
 [16779,[[0,[1,1,1,1,1,1,1,2]],[15,[1,1,1,1,1,1,1,2]],[27,[1,2]],
     [30,[1,1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,1,2]],[51,[1,1,1,1,1,1,1,2]],
     [60,[1,1,1,1,1,1,1,2]],[75,[1,1,1,1,1,1,1,2]],[87,[1,2]],
     [90,[1,1,1,1,1,1,1,2]]]],
 [16780,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [16782,[[2,[1,1,1,1,2,2,1,2]],[4,[1,1,1,1,2,2,1,2]],[14,[1,1,1,1,2,2,1,2]],
     [16,[1,1,1,1,2,2,1,2]],[20,[1]],[22,[1,1,1,1,2,2,1,2]],
     [27,[1,1,1,1,2,2,1,2]],[32,[1,1,1,1,2,2,1,2]],[34,[1,1,1,1,2,2,1,2]],
     [40,[1]]]],
 [16783,[[0,[1,2]],[6,[1,2]],[16,[2]],[22,[1,2]],[26,[1,2]],[36,[2]],
     [40,[1,2]],[42,[1,2]],[46,[1,2]],[47,[1,2]]]],
 [16784,[[0,[1,1,1,1,1,1,2,2]],[7,[1,2]],[12,[1,1,1,1,1,1,2,2]],[14,[1,2]],
     [20,[1,1,1,1,1,1,2,2]],[24,[1,1,1,1,1,1,2,2]],[32,[1,1,1,1,1,1,2,2]],
     [34,[1,2]],[36,[1,1,1,1,1,1,2,2]],[44,[1,1,1,1,1,1,2,2]]]],
 [16810,[[12,[2]],[23,[2]],[52,[2]],[72,[2]],[83,[2]],[112,[2]],
     [132,[2]],[143,[2]],[172,[2]],[192,[2]]]],
 [16811,[[7,[2]],[38,[2]],[47,[2]],[67,[2]],[98,[2]],[107,[2]],
     [127,[2]],[158,[2]],[167,[2]],[187,[2]]]],
 [16820,[[16,[1,1,2]],[36,[1,1,2]],[76,[1,1,2]],[96,[1,1,2]],[136,[1,1,2]],
     [156,[1,1,2]],[196,[1,1,2]],[216,[1,1,2]]]],
 [16824,[[7,[1,2,2,1,2,2,2,3]],[16,[1,2,2,1,2,2,2,3]],[31,[1]],
     [43,[1,2,2,1,2,2,2,3]],[55,[1,2,2,1,2,2,2,3]],[67,[1,2,2,1,2,2,2,3]],
     [76,[1,2,2,1,2,2,2,3]],[91,[1]],[103,[1,2,2,1,2,2,2,3]],
     [115,[1,2,2,1,2,2,2,3]]]],
 [16830,[[6,[1,2,2,1,2,2,2,3]],[18,[1,2,2,1,2,2,2,3]],[30,[1]],
     [42,[1,2,2,1,2,2,2,3]],[52,[1,2,2,1,2,2,2,3]],[66,[1,2,2,1,2,2,2,3]],
     [78,[1,2,2,1,2,2,2,3]],[90,[1]],[102,[1,2,2,1,2,2,2,3]],
     [112,[1,2,2,1,2,2,2,3]]]],
 [16831,[[3,[1,1,2,1,1,2,2,2]],[15,[1,1,2,1,1,2,2,2]],[27,[1,2]],
     [36,[1,1,2,1,1,2,2,2]],[51,[1,1,2,1,1,2,2,2]],[63,[1,1,2,1,1,2,2,2]],
     [75,[1,1,2,1,1,2,2,2]],[87,[1,2]],[96,[1,1,2,1,1,2,2,2]],
     [111,[1,1,2,1,1,2,2,2]]]],
 [16832,[[7,[1,2]],[36,[1,2]],[67,[1,2]],[96,[1,2]],[127,[1,2]],
     [156,[1,2]],[187,[1,2]],[216,[1,2]],[247,[1,2]]]],
 [16833,[[12,[1,2]],[22,[1]],[42,[1,2]],[72,[1,2]],[82,[1]],[102,[1,2]],
     [132,[1,2]],[142,[1]],[162,[1,2]],[192,[1,2]]]],
 [16835,[[2,[1]],[10,[1]],[12,[1]],[22,[1]],[30,[1]],[47,[1]],[50,[1]],
     [52,[1]],[62,[1]],[70,[1]]]],[16848,[[7,fail]]],
 [16861,[[14,[1]],[23,[1]],[28,[1]],[59,[1]],[74,[1]],[83,[1]],[88,[1]],
     [119,[1]],[134,[1]],[143,[1]]]],
 [16862,[[11,[1,1,1,1,2]],[50,[1,1,1,1,2]],[71,[1,1,1,1,2]],
     [110,[1,1,1,1,2]],[131,[1,1,1,1,2]],[170,[1,1,1,1,2]],
     [191,[1,1,1,1,2]],[230,[1,1,1,1,2]],[251,[1,1,1,1,2]]]],
 [16866,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [16868,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [16871,[[3,[1,2]],[6,[1,2]],[11,[2]],[23,[1,2]],[28,[1,2]],[40,[1,2]],
     [43,[1,2]],[46,[1,2]],[48,[1,2]],[51,[2]]]],
 [16872,[[0,[1,1,1,1,2,2,1,2]],[6,[1,1,1,1,2,2,1,2]],[8,[1]],
     [11,[1,1,1,1,2,2,1,2]],[15,[1,1,1,1,2,2,1,2]],[24,[1,1,1,1,2,2,1,2]],
     [26,[1,1,1,1,2,2,1,2]],[31,[1,1,1,1,2,2,1,2]],[35,[1,1,1,1,2,2,1,2]],
     [36,[1,1,1,1,2,2,1,2]]]],
 [16875,[[4,[1,1,1,1,1,1,1,2]],[19,[1,1,1,1,1,1,1,2]],[31,[1,2]],
     [34,[1,1,1,1,1,1,1,2]],[43,[1,1,1,1,1,1,1,2]],[55,[1,1,1,1,1,1,1,2]],
     [64,[1,1,1,1,1,1,1,2]],[79,[1,1,1,1,1,1,1,2]],[91,[1,2]],
     [94,[1,1,1,1,1,1,1,2]]]],
 [16877,[[4,[1,1,1,1,1,1,2,2]],[8,[1,1,1,1,1,1,2,2]],[15,[1,2]],
     [16,[1,1,1,1,1,1,2,2]],[20,[1,2]],[28,[1,1,1,1,1,1,2,2]],
     [31,[1,1,1,1,1,1,2,2]],[35,[1,2]],[44,[1,1,1,1,1,1,2,2]],
     [51,[1,1,1,1,1,1,2,2]]]],
 [16879,[[31,[1]],[91,[1]],[151,[1]],[211,[1]]]],
 [16881,[[3,[1,1,1,1,1,1,1,2]],[15,[1,1,1,1,1,1,1,2]],[18,[1,1,1,1,1,1,1,2]]
      ,[30,[1,2]],[40,[1,1,1,1,1,1,1,2]],[44,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]],[63,[1,1,1,1,1,1,1,2]],[75,[1,1,1,1,1,1,1,2]],
     [78,[1,1,1,1,1,1,1,2]]]],
 [16882,[[3,[1,1,1,1,2,1,1,2]],[11,[1]],[15,[1,1,1,1,2,1,1,2]],[30,[1]],
     [39,[1,1,1,1,2,1,1,2]],[40,[1]],[51,[1,1,1,1,2,1,1,2]],
     [63,[1,1,1,1,2,1,1,2]],[71,[1]],[75,[1,1,1,1,2,1,1,2]]]],
 [16885,[[4,[1,1,1,1,1,1,1,2]],[8,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],
     [16,[1,1,1,1,1,1,1,2]],[20,[3]],[28,[1,1,1,1,1,1,1,2]],
     [30,[1,1,1,1,1,1,1,2]],[40,[3]],[44,[1,1,1,1,1,1,1,2]],
     [50,[1,1,1,1,1,1,1,2]]]],
 [16886,[[0,[1,1,1,1,2,2]],[6,[1,1,1,1,2,2]],[28,[1,1,1,1,2,2]],
     [40,[1,1,1,1,2,2]],[46,[1,1,1,1,2,2]],[48,[1,1,1,1,2,2]],
     [60,[1,1,1,1,2,2]],[66,[1,1,1,1,2,2]],[88,[1,1,1,1,2,2]],
     [100,[1,1,1,1,2,2]]]],
 [16918,[[11,[1,2]],[40,[1,2]],[71,[1,2]],[100,[1,2]],[131,[1,2]],
     [160,[1,2]],[191,[1,2]],[220,[1,2]],[251,[1,2]]]],
 [16919,[[16,[1,2]],[26,[1]],[46,[1,2]],[76,[1,2]],[86,[1]],[106,[1,2]],
     [136,[1,2]],[146,[1]],[166,[1,2]],[196,[1,2]]]],
 [16921,[[0,[1]],[7,[1]],[11,[2,2,3]],[27,[1]],[40,[1]],[46,[1]],
     [47,[1]],[51,[2,2,3]],[60,[1]],[67,[1]]]],
 [16922,[[0,[1,1,2,2,2,2,1,2]],[6,[1,2]],[11,[1,1,2,2,2,2,1,2]],[15,[1,2]],
     [19,[1,1,2,2,2,2,1,2]],[20,[1,1,2,2,2,2,1,2]],[24,[1,1,2,2,2,2,1,2]],
     [31,[1,1,2,2,2,2,1,2]],[35,[1,2]],[36,[1,1,2,2,2,2,1,2]]]],
 [16925,[[7,[1,1,2,1,1,2,2,2]],[19,[1,1,2,1,1,2,2,2]],[31,[1,2]],
     [40,[1,1,2,1,1,2,2,2]],[55,[1,1,2,1,1,2,2,2]],[67,[1,1,2,1,1,2,2,2]],
     [79,[1,1,2,1,1,2,2,2]],[91,[1,2]],[100,[1,1,2,1,1,2,2,2]],
     [115,[1,1,2,1,1,2,2,2]]]],
 [16931,[[6,[1,1,1,1,2,1,2,2]],[16,[1,1,1,1,2,1,2,2]],[30,[2]],
     [42,[1,1,1,1,2,1,2,2]],[54,[1,1,1,1,2,1,2,2]],[66,[1,1,1,1,2,1,2,2]],
     [76,[1,1,1,1,2,1,2,2]],[90,[2]],[102,[1,1,1,1,2,1,2,2]],
     [114,[1,1,1,1,2,1,2,2]]]],
 [16932,[[0,[1,1,1,2,2,2,1,2]],[15,[1,1,1,2,2,2,1,2]],[27,[1,2]],
     [39,[1,1,1,2,2,2,1,2]],[51,[1,1,1,2,2,2,1,2]],[60,[1,1,1,2,2,2,1,2]],
     [75,[1,1,1,2,2,2,1,2]],[87,[1,2]],[99,[1,1,1,2,2,2,1,2]],
     [111,[1,1,1,2,2,2,1,2]]]],
 [16933,[[27,[1]],[87,[1]],[147,[1]],[207,[1]]]],
 [16935,[[4,[1,1,2,2,2,2,1,2]],[6,[1,1,2,2,2,2,1,2]],[10,[1,1,2,2,2,2,1,2]],
     [14,[1,2]],[16,[1,1,2,2,2,2,1,2]],[20,[1,2]],[26,[1,1,2,2,2,2,1,2]],
     [30,[1,1,2,2,2,2,1,2]],[34,[1,2]],[44,[1,1,2,2,2,2,1,2]]]],
 [16936,[[2,[1]],[16,[2,2,3]],[22,[1]],[26,[1]],[36,[2,2,3]],[40,[1]],
     [42,[1]],[46,[1]],[62,[1]],[76,[2,2,3]]]],[16944,[[6,fail]]],
 [16948,[[11,fail]]],
 [16960,[[26,[1,2,2]],[86,[1,2,2]],[146,[1,2,2]],[206,[1,2,2]]]],
 [16969,[[31,[1,2,3]],[91,[1,2,3]],[151,[1,2,3]],[211,[1,2,3]]]],
 [16970,[[3,[1,2]],[16,[2]],[23,[1,2]],[36,[2]],[43,[1,2]],[46,[1,2]],
     [63,[1,2]],[76,[2]],[83,[1,2]],[96,[2]]]],
 [16974,[[7,[1,1,1,2,2,1,2,3]],[16,[1,1,1,2,2,1,2,3]],[31,[3,4]],
     [43,[1,1,1,2,2,1,2,3]],[55,[1,1,1,2,2,1,2,3]],[67,[1,1,1,2,2,1,2,3]],
     [76,[1,1,1,2,2,1,2,3]],[91,[3,4]],[103,[1,1,1,2,2,1,2,3]],
     [115,[1,1,1,2,2,1,2,3]]]],
 [16980,[[6,[1,1,2,2,2,2,2,4]],[18,[1,1,2,2,2,2,2,4]],[30,[2]],
     [42,[1,1,2,2,2,2,2,4]],[51,[1,1,2,2,2,2,2,4]],[66,[1,1,2,2,2,2,2,4]],
     [78,[1,1,2,2,2,2,2,4]],[90,[2]],[102,[1,1,2,2,2,2,2,4]],
     [111,[1,1,2,2,2,2,2,4]]]],
 [16981,[[3,[1,1,1,2,2,3,4,2]],[15,[1,1,1,2,2,3,4,2]],[27,[1,2]],
     [36,[1,1,1,2,2,3,4,2]],[51,[1,1,1,2,2,3,4,2]],[63,[1,1,1,2,2,3,4,2]],
     [75,[1,1,1,2,2,3,4,2]],[87,[1,2]],[96,[1,1,1,2,2,3,4,2]],
     [111,[1,1,1,2,2,3,4,2]]]],
 [16982,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [16983,[[27,[1]],[30,[1]],[87,[1]],[90,[1]],[147,[1]],[150,[1]],
     [207,[1]],[210,[1]]]],[16993,[[20,fail]]],[16998,[[20,fail]]],
 [17017,[[7,[1,1,1,1,2]],[44,[1,1,1,1,2]],[67,[1,1,1,1,2]],
     [104,[1,1,1,1,2]],[127,[1,1,1,1,2]],[164,[1,1,1,1,2]],
     [187,[1,1,1,1,2]],[224,[1,1,1,1,2]],[247,[1,1,1,1,2]]]],
 [17022,[[7,[1,1,1,1,2,1,1,2]],[15,[1]],[19,[1,1,1,1,2,1,1,2]],[34,[1]],
     [43,[1,1,1,1,2,1,1,2]],[44,[1]],[55,[1,1,1,1,2,1,1,2]],
     [67,[1,1,1,1,2,1,1,2]],[75,[1]],[79,[1,1,1,1,2,1,1,2]]]],
 [17024,[[3,[1,1,1,2,1,1,2,2]],[8,[1,1,1,2,1,1,2,2]],[10,[1]],
     [15,[1,1,1,2,1,1,2,2]],[20,[1]],[23,[1,1,1,2,1,1,2,2]],
     [28,[1,1,1,2,1,1,2,2]],[32,[1,1,1,2,1,1,2,2]],[40,[1]],
     [43,[1,1,1,2,1,1,2,2]]]],
 [17026,[[20,[1,2]],[50,[1,2]],[80,[1,2]],[110,[1,2]],[140,[1,2]],
     [170,[1,2]],[200,[1,2]],[230,[1,2]]]],
 [17028,[[4,[1,1,1,1,2,1,1,2]],[15,[1]],[18,[1,1,1,1,2,1,1,2]],[27,[1]],
     [42,[1,1,1,1,2,1,1,2]],[44,[1]],[54,[1,1,1,1,2,1,1,2]],
     [64,[1,1,1,1,2,1,1,2]],[75,[1]],[78,[1,1,1,1,2,1,1,2]]]],
 [17029,[[3,[1,1,1,1,1,1,1,2]],[12,[1,1,1,1,1,1,1,2]],[15,[1,1,1,1,1,1,1,2]]
      ,[27,[1,2]],[39,[1,1,1,1,1,1,1,2]],[42,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]],[63,[1,1,1,1,1,1,1,2]],[72,[1,1,1,1,1,1,1,2]],
     [75,[1,1,1,1,1,1,1,2]]]],
 [17031,[[0,[1,1,1,1,2]],[30,[1,1,1,1,2]],[44,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[90,[1,1,1,1,2]],[104,[1,1,1,1,2]],
     [120,[1,1,1,1,2]],[150,[1,1,1,1,2]],[164,[1,1,1,1,2]],
     [180,[1,1,1,1,2]]]],
 [17032,[[4,[1,1,1,2,1,1,2,2]],[8,[1,1,1,2,1,1,2,2]],[10,[1]],
     [15,[1,1,1,2,1,1,2,2]],[18,[1,1,1,2,1,1,2,2]],[20,[1]],
     [28,[1,1,1,2,1,1,2,2]],[32,[1,1,1,2,1,1,2,2]],[38,[1,1,1,2,1,1,2,2]],
     [40,[1]]]],
 [17034,[[0,[1,1,1,1,2,2,1,2]],[2,[1,1,1,1,2,2,1,2]],[8,[1]],
     [12,[1,1,1,1,2,2,1,2]],[20,[1,1,1,1,2,2,1,2]],[22,[1,1,1,1,2,2,1,2]],
     [24,[1,1,1,1,2,2,1,2]],[30,[1,1,1,1,2,2,1,2]],[32,[1,1,1,1,2,2,1,2]],
     [42,[1,1,1,1,2,2,1,2]]]],
 [17056,[[11,[1,1,2,2]],[26,[1,1,2,2]],[55,[1,1,2,2]],[71,[1,1,2,2]],
     [86,[1,1,2,2]],[115,[1,1,2,2]],[131,[1,1,2,2]],[146,[1,1,2,2]],
     [175,[1,1,2,2]],[191,[1,1,2,2]]]],
 [17060,[[20,[1,2]],[30,[1]],[50,[1,2]],[80,[1,2]],[90,[1]],[110,[1,2]],
     [140,[1,2]],[150,[1]],[170,[1,2]],[200,[1,2]]]],
 [17062,[[31,[1]],[91,[1]],[151,[1]],[211,[1]]]],
 [17064,[[0,[1,1,2,2]],[31,[1,1,2,2]],[46,[1,1,2,2]],[60,[1,1,2,2]],
     [91,[1,1,2,2]],[106,[1,1,2,2]],[120,[1,1,2,2]],[151,[1,1,2,2]],
     [166,[1,1,2,2]],[180,[1,1,2,2]]]],
 [17065,[[4,[1]],[15,[1]],[19,[1]],[24,[1]],[35,[1]],[39,[1]],[40,[1]],
     [59,[1]],[64,[1]],[75,[1]]]],
 [17069,[[4,[1,1,1,2,2,2,1,2]],[19,[1,1,1,2,2,2,1,2]],[31,[1,2]],
     [43,[1,1,1,2,2,2,1,2]],[55,[1,1,1,2,2,2,1,2]],[64,[1,1,1,2,2,2,1,2]],
     [79,[1,1,1,2,2,2,1,2]],[91,[1,2]],[103,[1,1,1,2,2,2,1,2]],
     [115,[1,1,1,2,2,2,1,2]]]],
 [17073,[[15,[1,2]],[44,[1,2]],[75,[1,2]],[104,[1,2]],[135,[1,2]],
     [164,[1,2]],[195,[1,2]],[224,[1,2]],[255,[1,2]]]],
 [17078,[[6,[1,1,1,1,2]],[20,[1,1,1,1,2]],[51,[1,1,1,1,2]],
     [66,[1,1,1,1,2]],[80,[1,1,1,1,2]],[111,[1,1,1,1,2]],
     [126,[1,1,1,1,2]],[140,[1,1,1,1,2]],[171,[1,1,1,1,2]],
     [186,[1,1,1,1,2]]]],
 [17080,[[10,[1,1,2]],[50,[1,1,2]],[70,[1,1,2]],[110,[1,1,2]],
     [130,[1,1,2]],[170,[1,1,2]],[190,[1,1,2]],[230,[1,1,2]],
     [250,[1,1,2]]]],[17087,[[10,fail]]],[17091,[[15,fail]]],
 [17101,[[35,[1,2,3]],[95,[1,2,3]],[155,[1,2,3]],[215,[1,2,3]]]],
 [17108,[[34,[1,1,2]],[94,[1,1,2]],[154,[1,1,2]],[214,[1,1,2]]]],
 [17109,[[31,[1]],[34,[1]],[91,[1]],[94,[1]],[151,[1]],[154,[1]],
     [211,[1]],[214,[1]]]],
 [17115,[[7,[1,1,1,2,2,3,4,2]],[19,[1,1,1,2,2,3,4,2]],[31,[1,2]],
     [40,[1,1,1,2,2,3,4,2]],[55,[1,1,1,2,2,3,4,2]],[67,[1,1,1,2,2,3,4,2]],
     [79,[1,1,1,2,2,3,4,2]],[91,[1,2]],[100,[1,1,1,2,2,3,4,2]],
     [115,[1,1,1,2,2,3,4,2]]]],
 [17121,[[6,[1,2,1,2,2,1,2,3]],[15,[1,2,1,2,2,1,2,3]],[30,[2]],
     [42,[1,2,1,2,2,1,2,3]],[54,[1,2,1,2,2,1,2,3]],[66,[1,2,1,2,2,1,2,3]],
     [75,[1,2,1,2,2,1,2,3]],[90,[2]],[102,[1,2,1,2,2,1,2,3]],
     [114,[1,2,1,2,2,1,2,3]]]],
 [17122,[[0,[1,1,2,3,3,3,2,2]],[15,[1,1,2,3,3,3,2,2]],[27,[1]],
     [39,[1,1,2,3,3,3,2,2]],[51,[1,1,2,3,3,3,2,2]],[60,[1,1,2,3,3,3,2,2]],
     [75,[1,1,2,3,3,3,2,2]],[87,[1]],[99,[1,1,2,3,3,3,2,2]],
     [111,[1,1,2,3,3,3,2,2]]]],
 [17126,[[6,[1,2]],[10,[2]],[26,[1,2]],[40,[1,2]],[46,[1,2]],[50,[2]],
     [66,[1,2]],[70,[2]],[86,[1,2]],[100,[1,2]]]],[17133,[[24,fail]]],
 [17138,[[24,fail]]],
 [17146,[[11,[4]],[23,[4]],[50,[4]],[52,[4]],[71,[4]],[83,[4]],
     [110,[4]],[112,[4]],[131,[4]],[143,[4]]]],
 [17147,[[0,[1,1,2,2,3,2,3]],[32,[1,1,2,2,3,2,3]],[35,[1,1,2,2,3,2,3]],
     [50,[1,1,2,2,3,2,3]],[62,[1,1,2,2,3,2,3]],[92,[1,1,2,2,3,2,3]],
     [95,[1,1,2,2,3,2,3]],[110,[1,1,2,2,3,2,3]],[122,[1,1,2,2,3,2,3]],
     [152,[1,1,2,2,3,2,3]]]],
 [17151,[[10,[1]],[26,[1]],[56,[1]],[70,[1]],[86,[1]],[116,[1]],
     [130,[1]],[146,[1]],[176,[1]],[190,[1]]]],
 [17153,[[30,[1,2,2,2]],[90,[1,2,2,2]],[150,[1,2,2,2]],[210,[1,2,2,2]]]],
 [17154,[[30,[2,2,3]],[90,[2,2,3]],[150,[2,2,3]],[210,[2,2,3]]]],
 [17155,[[15,[1,1,2,1,2]],[31,[1,1,2,3]],[75,[1,1,2,1,2]],[91,[1,1,2,3]],
     [135,[1,1,2,1,2]],[151,[1,1,2,3]],[195,[1,1,2,1,2]],[211,[1,1,2,3]],
     [255,[1,1,2,1,2]]]],
 [17160,[[7,[1,2,3,2,3,3,2,3]],[15,[1,2,3,2,3,3,2,3]],[31,[3,4]],
     [43,[1,2,3,2,3,3,2,3]],[55,[1,2,3,2,3,3,2,3]],[67,[1,2,3,2,3,3,2,3]],
     [75,[1,2,3,2,3,3,2,3]],[91,[3,4]],[103,[1,2,3,2,3,3,2,3]],
     [115,[1,2,3,2,3,3,2,3]]]],
 [17166,[[6,[1,1,2,3,3,4,2,2]],[18,[1,1,2,3,3,4,2,2]],[30,[4,5]],
     [42,[1,1,2,3,3,4,2,2]],[50,[1,1,2,3,3,4,2,2]],[66,[1,1,2,3,3,4,2,2]],
     [78,[1,1,2,3,3,4,2,2]],[90,[4,5]],[102,[1,1,2,3,3,4,2,2]],
     [110,[1,1,2,3,3,4,2,2]]]],
 [17169,[[18,[1,1,1,2,2,2]],[30,[2,2,3]],[78,[1,1,1,2,2,2]],[90,[2,2,3]],
     [138,[1,1,1,2,2,2]],[150,[2,2,3]],[198,[1,1,1,2,2,2]],[210,[2,2,3]]]]
  ,
 [17191,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17199,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [17201,[[0,[1]],[3,[1]],[7,[1]],[8,[1]],[12,[1]],[15,[1]],[19,[1]],
     [20,[1]],[24,[1]],[27,[1]]]],
 [17204,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17206,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [17210,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17211,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17214,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [17216,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [17233,[[2,[1,1,1,1,2]],[11,[1,1,1,1,2]],[14,[1,1,1,1,2]],
     [23,[1,1,1,1,2]],[26,[1,1,1,1,2]],[35,[1,1,1,1,2]],[38,[1,1,1,1,2]],
     [47,[1,1,1,1,2]],[50,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [17234,[[2,[1,1,1,1,2]],[11,[1,1,1,1,2]],[14,[1,1,1,1,2]],
     [23,[1,1,1,1,2]],[26,[1,1,1,1,2]],[35,[1,1,1,1,2]],[38,[1,1,1,1,2]],
     [47,[1,1,1,1,2]],[50,[1,1,1,1,2]],[59,[1,1,1,1,2]]]],
 [17240,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17241,[[0,[1,2]],[7,[1,2]],[12,[1,2]],[19,[1,2]],[24,[1,2]],[31,[1,2]],
     [36,[1,2]],[43,[1,2]],[48,[1,2]],[55,[1,2]]]],
 [17247,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17249,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [17253,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17254,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [17255,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [17257,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [17259,[[0,[1,2]],[8,[1,2]],[12,[1,2]],[20,[1,2]],[24,[1,2]],[32,[1,2]],
     [36,[1,2]],[44,[1,2]],[48,[1,2]],[56,[1,2]]]],[17266,[[0,fail]]],
 [17270,[[0,fail]]],
 [17285,[[3,[1,1,2]],[7,[1,1,2]],[15,[1,1,2]],[19,[1,1,2]],[27,[1,1,2]],
     [31,[1,1,2]],[39,[1,1,2]],[43,[1,1,2]],[51,[1,1,2]],[55,[1,1,2]]]],
 [17286,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],
 [17289,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17291,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [17295,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17296,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [17298,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [17299,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [17300,[[0,[1]],[2,[1]],[6,[1]],[10,[1]],[12,[1]],[14,[1]],[18,[1]],
     [22,[1]],[24,[1]],[26,[1]]]],
 [17301,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[26,[1,2]]]],[17312,[[0,fail]]],
 [17313,[[0,fail]]],
 [17316,[[4,[1]],[11,[1]],[16,[1]],[23,[1]],[28,[1]],[35,[1]],[40,[1]],
     [47,[1]],[52,[1]],[59,[1]]]],
 [17326,[[0,[1]],[4,[1]],[7,[1]],[11,[1]],[12,[1]],[16,[1]],[19,[1]],
     [23,[1]],[24,[1]],[28,[1]]]],
 [17327,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [17330,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17332,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [17336,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17337,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [17340,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [17341,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [17342,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [17363,[[0,[1,2]],[7,[1,2]],[12,[1,2]],[19,[1,2]],[24,[1,2]],[31,[1,2]],
     [36,[1,2]],[43,[1,2]],[48,[1,2]],[55,[1,2]]]],
 [17364,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [17366,[[0,[1]],[3,[1]],[7,[1]],[11,[1]],[12,[1]],[15,[1]],[19,[1]],
     [23,[1]],[24,[1]],[27,[1]]]],
 [17367,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[11,[1,2]],[12,[1,2]],[15,[1,2]],
     [19,[1,2]],[23,[1,2]],[24,[1,2]],[27,[1,2]]]],
 [17370,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17372,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17376,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17377,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [17378,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17380,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17381,[[2,[1,1,2]],[6,[1,1,2]],[14,[1,1,2]],[18,[1,1,2]],[26,[1,1,2]],
     [30,[1,1,2]],[38,[1,1,2]],[42,[1,1,2]],[50,[1,1,2]],[54,[1,1,2]]]],
 [17382,[[0,[2]],[8,[2]],[12,[2]],[20,[2]],[24,[2]],[32,[2]],[36,[2]],
     [44,[2]],[48,[2]],[56,[2]]]],[17388,[[0,fail]]],[17389,[[0,fail]]],
 [17395,[[2,[1,1,2]],[14,[1,1,2]],[26,[1,1,2]],[38,[1,1,2]],[50,[1,1,2]],
     [62,[1,1,2]],[74,[1,1,2]],[86,[1,1,2]],[98,[1,1,2]],[110,[1,1,2]]]]
  ,
 [17396,[[8,[1,1,2]],[20,[1,1,2]],[32,[1,1,2]],[44,[1,1,2]],[56,[1,1,2]],
     [68,[1,1,2]],[80,[1,1,2]],[92,[1,1,2]],[104,[1,1,2]],[116,[1,1,2]]] 
  ],
 [17406,[[0,[1,2]],[8,[1,2]],[12,[1,2]],[20,[1,2]],[24,[1,2]],[32,[1,2]],
     [36,[1,2]],[44,[1,2]],[48,[1,2]],[56,[1,2]]]],
 [17409,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17411,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17415,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17416,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [17418,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17419,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],[17427,[[0,fail]]],[17433,[[0,fail]]],
 [17434,[[2,[1,2]],[11,[1,2]],[14,[1,2]],[23,[1,2]],[26,[1,2]],
     [35,[1,2]],[38,[1,2]],[47,[1,2]],[50,[1,2]],[59,[1,2]]]],
 [17447,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17449,[[4,[2]],[11,[1]],[16,[2]],[23,[1]],[28,[2]],[35,[1]],[40,[2]],
     [47,[1]],[52,[2]],[59,[1]]]],
 [17453,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17457,[[4,[2]],[11,[1]],[16,[2]],[23,[1]],[28,[2]],[35,[1]],[40,[2]],
     [47,[1]],[52,[2]],[59,[1]]]],
 [17479,[[0,[2]],[7,[2]],[12,[2]],[19,[2]],[24,[2]],[31,[2]],[36,[2]],
     [43,[2]],[48,[2]],[55,[2]]]],
 [17480,[[0,[1,1,2]],[3,[2,3,3]],[7,[2,3,3]],[11,[2,3,3]],[12,[1,1,2]],
     [15,[2,3,3]],[19,[2,3,3]],[23,[2,3,3]],[24,[1,1,2]],[27,[2,3,3]]]],
 [17484,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17486,[[2,[1]],[8,[2]],[14,[1]],[20,[2]],[26,[1]],[32,[2]],[38,[1]],
     [44,[2]],[50,[1]],[56,[2]]]],
 [17490,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17491,[[3,[2,3]],[15,[2,3]],[27,[2,3]],[39,[2,3]],[51,[2,3]],
     [63,[2,3]],[75,[2,3]],[87,[2,3]],[99,[2,3]],[111,[2,3]]]],
 [17494,[[2,[1]],[8,[2]],[14,[1]],[20,[2]],[26,[1]],[32,[2]],[38,[1]],
     [44,[2]],[50,[1]],[56,[2]]]],
 [17495,[[2,[2,3,3,3,3]],[6,[1,1,1,2,2]],[11,[1,1,1,2,2]],[14,[2,3,3,3,3]],
     [18,[1,1,1,2,2]],[23,[1,1,1,2,2]],[26,[2,3,3,3,3]],[30,[1,1,1,2,2]],
     [35,[1,1,1,2,2]],[38,[2,3,3,3,3]]]],
 [17511,[[4,[1,2]],[11,[1,2]],[16,[1,2]],[23,[1,2]],[28,[1,2]],
     [35,[1,2]],[40,[1,2]],[47,[1,2]],[52,[1,2]],[59,[1,2]]]],
 [17513,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [17517,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [17520,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17522,[[4,[1,2]],[7,[1,2]],[16,[1,2]],[19,[1,2]],[28,[1,2]],[31,[1,2]],
     [40,[1,2]],[43,[1,2]],[52,[1,2]],[55,[1,2]]]],
 [17524,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17526,[[3,[1]],[6,[1,2]],[15,[1]],[18,[1,2]],[27,[1]],[30,[1,2]],
     [39,[1]],[42,[1,2]],[51,[1]],[54,[1,2]]]],
 [17527,[[3,[1,2]],[6,[1]],[15,[1,2]],[18,[1]],[27,[1,2]],[30,[1]],
     [39,[1,2]],[42,[1]],[51,[1,2]],[54,[1]]]],
 [17532,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],[17538,[[4,fail]]],[17542,[[4,fail]]],
 [17549,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [17551,[[0,[1,1,2]],[11,[1,1,2]],[12,[1,1,2]],[23,[1,1,2]],[24,[1,1,2]],
     [35,[1,1,2]],[36,[1,1,2]],[47,[1,1,2]],[48,[1,1,2]],[59,[1,1,2]]]],
 [17552,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [17555,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17557,[[4,[2]],[7,[2]],[16,[2]],[19,[2]],[28,[2]],[31,[2]],[40,[2]],
     [43,[2]],[52,[2]],[55,[2]]]],
 [17562,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [17565,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [17566,[[2,[1]],[4,[1]],[6,[1]],[10,[1]],[14,[1]],[16,[1]],[18,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [17567,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],[17577,[[4,fail]]],[17578,[[4,fail]]],
 [17584,[[7,[1,2,2]],[19,[1,2,2]],[31,[1,2,2]],[43,[1,2,2]],[55,[1,2,2]],
     [67,[1,2,2]],[79,[1,2,2]],[91,[1,2,2]],[103,[1,2,2]],[115,[1,2,2]]] 
  ],
 [17589,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [17595,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [17596,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17597,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [17598,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17608,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],[17609,[[8,fail]]],
 [17611,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],[17613,[[8,fail]]],
 [17614,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17615,[[4,[2,4]],[10,[1,2]],[11,[1,2]],[16,[2,4]],[22,[1,2]],
     [23,[1,2]],[28,[2,4]],[34,[1,2]],[35,[1,2]],[40,[2,4]]]],
 [17618,[[3,[2,4]],[4,[4,5]],[11,[6]],[15,[2,4]],[16,[4,5]],[23,[6]],
     [27,[2,4]],[28,[4,5]],[35,[6]],[39,[2,4]]]],
 [17619,[[0,[2]],[8,[4]],[14,[2]],[20,[4]],[26,[2]],[32,[4]],[38,[2]],
     [44,[4]],[50,[2]],[56,[4]]]],
 [17621,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17622,[[4,[1,2]],[11,[1,2]],[16,[1,2]],[23,[1,2]],[28,[1,2]],
     [35,[1,2]],[40,[1,2]],[47,[1,2]],[52,[1,2]],[59,[1,2]]]],
 [17628,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [17634,[[0,[1,2]],[8,[2,4]],[14,[1,2]],[20,[2,4]],[26,[1,2]],[32,[2,4]],
     [38,[1,2]],[44,[2,4]],[50,[1,2]],[56,[2,4]]]],[17644,[[26,fail]]],
 [17654,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [17660,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [17661,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17662,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [17663,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],[17673,[[8,fail]]],[17674,[[8,fail]]],[17676,[[8,fail]]],
 [17678,[[8,fail]]],
 [17684,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17685,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17687,[[4,[3]],[10,[1,2]],[16,[3]],[22,[1,2]],[28,[3]],[34,[1,2]],
     [40,[3]],[46,[1,2]],[52,[3]],[58,[1,2]]]],
 [17689,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [17691,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [17692,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [17693,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],
 [17702,[[6,[1]],[10,[1,2]],[18,[1,2]],[22,[1]],[30,[1]],[34,[1,2]],
     [42,[1,2]],[46,[1]],[54,[1]],[58,[1,2]]]],[17703,[[22,fail]]],
 [17715,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17716,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17717,[[4,[4]],[10,[2]],[16,[4]],[22,[2]],[28,[4]],[34,[2]],[40,[4]],
     [46,[2]],[52,[4]],[58,[2]]]],
 [17722,[[0,[1,2]],[7,[1,2]],[12,[1,2]],[19,[1,2]],[24,[1,2]],[31,[1,2]],
     [36,[1,2]],[43,[1,2]],[48,[1,2]],[55,[1,2]]]],
 [17723,[[0,[2,4]],[6,[1,2]],[7,[1,2]],[12,[2,4]],[18,[1,2]],[19,[1,2]],
     [24,[2,4]],[30,[1,2]],[31,[1,2]],[36,[2,4]]]],
 [17725,[[4,[2,4]],[10,[1,2]],[16,[2,4]],[22,[1,2]],[28,[2,4]],
     [34,[1,2]],[40,[2,4]],[46,[1,2]],[52,[2,4]],[58,[1,2]]]],
 [17736,[[11,[1]],[19,[1]],[35,[1]],[43,[1]],[59,[1]],[67,[1]],[83,[1]],
     [91,[1]],[107,[1]],[115,[1]]]],[17738,[[22,fail]]],
 [17744,[[7,[2,4]],[19,[2,4]],[31,[2,4]],[43,[2,4]],[55,[2,4]],
     [67,[2,4]],[79,[2,4]],[91,[2,4]],[103,[2,4]],[115,[2,4]]]],
 [17747,[[7,[1,1,1,2]],[19,[1,1,1,2]],[31,[1,1,1,2]],[43,[1,1,1,2]],
     [55,[1,1,1,2]],[67,[1,1,1,2]],[79,[1,1,1,2]],[91,[1,1,1,2]],
     [103,[1,1,1,2]],[115,[1,1,1,2]]]],
 [17749,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [17750,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [17751,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17765,[[0,[1]],[6,[1]],[19,[2]],[27,[1]],[31,[1]],[43,[2]],[51,[1]],
     [55,[1]],[67,[2]],[75,[1]]]],
 [17769,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[11,[1,2]],[12,[1,2]],[15,[1,2]],
     [19,[1,2]],[23,[1,2]],[24,[1,2]],[27,[1,2]]]],
 [17771,[[3,[1]],[4,[1]],[7,[1]],[11,[1]],[15,[1]],[16,[1]],[19,[1]],
     [23,[1]],[27,[1]],[28,[1]]]],
 [17772,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17774,[[3,[1,2]],[4,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[16,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [17776,[[3,[2]],[4,[1]],[7,[2]],[11,[2]],[15,[2]],[16,[1]],[19,[2]],
     [23,[2]],[27,[2]],[28,[1]]]],
 [17778,[[3,[2,3,3]],[6,[1,2]],[11,[1,1,2]],[15,[2,3,3]],[18,[1,2]],
     [23,[1,1,2]],[27,[2,3,3]],[30,[1,2]],[35,[1,1,2]],[39,[2,3,3]]]],
 [17781,[[3,[2,3,3]],[7,[1,1,2]],[15,[2,3,3]],[19,[1,1,2]],[27,[2,3,3]],
     [31,[1,1,2]],[39,[2,3,3]],[43,[1,1,2]],[51,[2,3,3]],[55,[1,1,2]]]],
 [17783,[[0,[2]],[4,[2]],[6,[2]],[10,[2]],[12,[2]],[16,[2]],[18,[2]],
     [22,[2]],[24,[2]],[28,[2]]]],[17787,[[0,fail]]],[17788,[[0,fail]]],
 [17789,[[3,fail]]],[17794,[[3,fail]]],[17795,[[0,fail]]],[17796,[[0,fail]]],
 [17797,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [17798,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [17800,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [17803,[[0,[1,2]],[8,[3]],[14,[1,2]],[20,[3]],[26,[1,2]],[32,[3]],
     [38,[1,2]],[44,[3]],[50,[1,2]],[56,[3]]]],
 [17811,[[0,[2]],[2,[1]],[3,[1]],[6,[1]],[7,[1]],[8,[2]],[12,[2]],
     [14,[1]],[15,[1]],[18,[1]]]],
 [17813,[[0,[1]],[7,[1]],[12,[1]],[15,[1]],[23,[1]],[24,[1]],[31,[1]],
     [36,[1]],[39,[1]],[47,[1]]]],
 [17814,[[0,[1]],[2,[1]],[6,[1]],[7,[1]],[11,[1]],[12,[1]],[14,[1]],
     [18,[1]],[19,[1]],[23,[1]]]],
 [17816,[[0,[1]],[3,[1]],[6,[1]],[8,[1]],[11,[1]],[14,[1]],[15,[1]],
     [18,[1]],[20,[1]],[23,[1]]]],
 [17820,[[0,[1]],[8,[1]],[11,[1]],[19,[1]],[20,[1]],[27,[1]],[32,[1]],
     [35,[1]],[43,[1]],[44,[1]]]],
 [17825,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [17827,[[3,[1]],[4,[1]],[8,[1]],[11,[1]],[15,[1]],[16,[1]],[20,[1]],
     [23,[1]],[27,[1]],[28,[1]]]],
 [17831,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [17832,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17835,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [17837,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [17850,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17852,[[3,[1,2]],[4,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[16,[1,2]],
     [19,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [17854,[[4,[1,2]],[11,[1,2]],[16,[1,2]],[23,[1,2]],[28,[1,2]],
     [35,[1,2]],[40,[1,2]],[47,[1,2]],[52,[1,2]],[59,[1,2]]]],
 [17856,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [17860,[[4,[2]],[6,[2]],[16,[2]],[18,[2]],[28,[2]],[30,[2]],[40,[2]],
     [42,[2]],[52,[2]],[54,[2]]]],
 [17861,[[0,[1,1,2]],[10,[1,1,2]],[12,[1,1,2]],[22,[1,1,2]],[24,[1,1,2]],
     [34,[1,1,2]],[36,[1,1,2]],[46,[1,1,2]],[48,[1,1,2]],[58,[1,1,2]]]],
 [17862,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[17868,[[4,fail]]],[17870,[[4,fail]]],
 [17875,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17878,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17879,[[7,[3]],[19,[3]],[31,[3]],[43,[3]],[55,[3]],[67,[3]],[79,[3]],
     [91,[3]],[103,[3]],[115,[3]]]],
 [17880,[[3,[2]],[8,[2]],[15,[2]],[20,[2]],[27,[2]],[32,[2]],[39,[2]],
     [44,[2]],[51,[2]],[56,[2]]]],
 [17881,[[3,[1]],[7,[1,2]],[15,[1]],[19,[1,2]],[27,[1]],[31,[1,2]],
     [39,[1]],[43,[1,2]],[51,[1]],[55,[1,2]]]],
 [17885,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17887,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17888,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17889,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17890,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [17891,[[4,[1,1,2,2]],[14,[1,2]],[16,[1,1,2,2]],[22,[1,1,2,2]],
     [28,[1,1,2,2]],[38,[1,2]],[40,[1,1,2,2]],[46,[1,1,2,2]],
     [52,[1,1,2,2]],[62,[1,2]]]],
 [17892,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17893,[[7,[3,4]],[19,[3,4]],[31,[3,4]],[43,[3,4]],[55,[3,4]],
     [67,[3,4]],[79,[3,4]],[91,[3,4]],[103,[3,4]],[115,[3,4]]]],
 [17897,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [17898,[[7,[2,4]],[19,[2,4]],[31,[2,4]],[43,[2,4]],[55,[2,4]],
     [67,[2,4]],[79,[2,4]],[91,[2,4]],[103,[2,4]],[115,[2,4]]]],
 [17903,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [17904,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [17907,[[4,[1,2]],[6,[1,2]],[16,[1,2]],[18,[1,2]],[28,[1,2]],[30,[1,2]],
     [40,[1,2]],[42,[1,2]],[52,[1,2]],[54,[1,2]]]],
 [17909,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],[17917,[[4,fail]]],[17920,[[4,fail]]],
 [17929,[[2,[1]],[3,[1]],[4,[2]],[8,[2]],[10,[1]],[11,[1]],[14,[1]],
     [15,[1]],[16,[2]],[20,[2]]]],
 [17932,[[3,[1]],[8,[1]],[11,[1]],[19,[1]],[20,[1]],[27,[1]],[32,[1]],
     [35,[1]],[43,[1]],[44,[1]]]],
 [17933,[[4,[1]],[7,[1]],[15,[1]],[16,[1]],[23,[1]],[28,[1]],[31,[1]],
     [39,[1]],[40,[1]],[47,[1]]]],
 [17934,[[2,[1]],[4,[1]],[7,[1]],[10,[1]],[11,[1]],[14,[1]],[16,[1]],
     [19,[1]],[22,[1]],[23,[1]]]],
 [17935,[[2,[1]],[3,[1]],[7,[1]],[8,[1]],[10,[1]],[14,[1]],[15,[1]],
     [19,[1]],[20,[1]],[22,[1]]]],
 [17936,[[3,[1,2]],[4,[1,2]],[11,[1,2]],[14,[1,2]],[15,[1,2]],[16,[1,2]],
     [22,[1,2]],[23,[1,2]],[27,[1,2]],[28,[1,2]]]],
 [17946,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [17947,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17948,[[3,[2]],[8,[2]],[15,[2]],[20,[2]],[27,[2]],[32,[2]],[39,[2]],
     [44,[2]],[51,[2]],[56,[2]]]],
 [17949,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],[17959,[[8,fail]]],[17960,[[8,fail]]],[17962,[[8,fail]]],
 [17964,[[8,fail]]],
 [17965,[[0,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [17966,[[4,[1,2]],[11,[1,2]],[16,[1,2]],[23,[1,2]],[28,[1,2]],
     [35,[1,2]],[40,[1,2]],[47,[1,2]],[52,[1,2]],[59,[1,2]]]],
 [17968,[[0,[1]],[8,[1]],[11,[1]],[14,[1]],[20,[1]],[23,[1]],[26,[1]],
     [32,[1]],[35,[1]],[38,[1]]]],
 [17969,[[0,[1,2]],[3,[1,2]],[8,[2,4]],[14,[1,2]],[15,[1,2]],[20,[2,4]],
     [26,[1,2]],[27,[1,2]],[32,[2,4]],[38,[1,2]]]],
 [17976,[[0,[1,1,1,2]],[10,[1,1,1,2]],[14,[1,1,1,2]],[22,[1,1,1,2]],
     [26,[1,1,1,2]],[34,[1,1,1,2]],[38,[1,1,1,2]],[46,[1,1,1,2]],
     [50,[1,1,1,2]],[58,[1,1,1,2]]]],[17980,[[26,fail]]],
 [17985,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [17986,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [17987,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [17988,[[3,[2]],[8,[2]],[15,[2]],[20,[2]],[27,[2]],[32,[2]],[39,[2]],
     [44,[2]],[51,[2]],[56,[2]]]],[17998,[[8,fail]]],
 [17999,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],[18001,[[8,fail]]],
 [18003,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],
 [18004,[[3,[1,2]],[6,[1,2]],[15,[1,2]],[18,[1,2]],[27,[1,2]],[30,[1,2]],
     [39,[1,2]],[42,[1,2]],[51,[1,2]],[54,[1,2]]]],
 [18005,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [18006,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [18008,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [18010,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [18011,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [18012,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [18013,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [18015,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [18016,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [18020,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [18021,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [18022,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18023,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18027,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [18029,[[0,[1,1,2,2]],[10,[1,2]],[12,[1,1,2,2]],[18,[1,1,2,2]],
     [24,[1,1,2,2]],[34,[1,2]],[36,[1,1,2,2]],[42,[1,1,2,2]],
     [48,[1,1,2,2]],[58,[1,2]]]],
 [18030,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [18031,[[3,[1]],[10,[1]],[15,[1]],[18,[1]],[27,[1]],[34,[1]],[39,[1]],
     [42,[1]],[51,[1]],[58,[1]]]],
 [18033,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18034,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [18035,[[0,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [18036,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18038,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18045,[[2,[1]],[6,[1,2]],[14,[1,2]],[18,[1]],[26,[1]],[30,[1,2]],
     [38,[1,2]],[42,[1]],[50,[1]],[54,[1,2]]]],[18049,[[18,fail]]],
 [18059,[[7,[1]],[15,[1]],[31,[1]],[39,[1]],[55,[1]],[63,[1]],[79,[1]],
     [87,[1]],[103,[1]],[111,[1]]]],[18069,[[18,fail]]],
 [18070,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [18072,[[2,[1]],[3,[1]],[6,[1]],[8,[1]],[11,[1]],[14,[1]],[15,[1]],
     [18,[1]],[20,[1]],[23,[1]]]],
 [18073,[[2,[1]],[4,[1]],[6,[1]],[10,[1]],[11,[1]],[15,[1]],[16,[1]],
     [18,[1]],[22,[1]],[23,[1]]]],
 [18074,[[4,[1]],[6,[1]],[14,[1]],[16,[1]],[22,[1]],[28,[1]],[30,[1]],
     [38,[1]],[40,[1]],[46,[1]]]],
 [18075,[[2,[1]],[8,[1]],[10,[1]],[18,[1]],[20,[1]],[26,[1]],[32,[1]],
     [34,[1]],[42,[1]],[44,[1]]]],
 [18080,[[2,[1,2]],[4,[1,2]],[10,[1,2]],[14,[1,2]],[15,[1,2]],[16,[1,2]],
     [22,[1,2]],[23,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [18084,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[26,[1,2]]]],[18085,[[0,fail]]],
 [18086,[[0,fail]]],[18090,[[0,fail]]],[18091,[[0,fail]]],[18092,[[2,fail]]],
 [18093,[[2,fail]]],
 [18098,[[0,[1]],[2,[1]],[6,[1]],[7,[1]],[10,[1]],[12,[1]],[15,[1]],
     [18,[1]],[19,[1]],[22,[1]]]],
 [18099,[[0,[1]],[6,[1]],[12,[1]],[14,[1]],[22,[1]],[24,[1]],[30,[1]],
     [36,[1]],[38,[1]],[46,[1]]]],
 [18101,[[0,[1]],[8,[1]],[10,[1]],[18,[1]],[20,[1]],[26,[1]],[32,[1]],
     [34,[1]],[42,[1]],[44,[1]]]],
 [18105,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[10,[1]],[14,[1]],[15,[1]],
     [19,[1]],[20,[1]],[22,[1]]]],
 [18154,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [18155,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [18157,[[4,fail]]],[18159,[[0,fail]]],
 [18160,[[8,[2,4]],[32,[2,4]],[56,[2,4]],[80,[2,4]],[104,[2,4]],
     [128,[2,4]],[152,[2,4]],[176,[2,4]],[200,[2,4]],[224,[2,4]]]],
 [18162,[[8,fail]]],[18163,[[0,fail]]],[18167,[[4,fail]]],[18168,[[8,fail]]],
 [18172,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [18173,[[8,[2,4]],[32,[2,4]],[56,[2,4]],[80,[2,4]],[104,[2,4]],
     [128,[2,4]],[152,[2,4]],[176,[2,4]],[200,[2,4]],[224,[2,4]]]],
 [18174,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [18175,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [18178,[[5,[1]],[7,[1,2]],[15,[1]],[17,[1,2]],[25,[1]],[27,[1,2]],
     [35,[1]],[37,[1,2]],[45,[1]],[47,[1,2]]]],
 [18181,[[3,[1]],[9,[1]],[13,[1]],[19,[1]],[23,[1]],[29,[1]],[33,[1]],
     [39,[1]],[43,[1]],[49,[1]]]],
 [18183,[[0,[1,2]],[13,[1,2]],[23,[1,2]],[33,[1,2]],[43,[1,2]],
     [53,[1,2]],[63,[1,2]],[73,[1,2]],[83,[1,2]],[93,[1,2]]]],
 [18184,[[3,[1,2]],[9,[1,2]],[13,[1,2]],[19,[1,2]],[23,[1,2]],[29,[1,2]],
     [33,[1,2]],[39,[1,2]],[43,[1,2]],[49,[1,2]]]],
 [18186,[[9,[3]],[19,[3]],[29,[3]],[39,[3]],[49,[3]],[59,[3]],[69,[3]],
     [79,[3]],[89,[3]],[99,[3]]]],
 [18188,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [18189,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [18193,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [18196,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [18199,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [18201,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [18202,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [18203,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],[18204,[[3,fail]]],[18205,[[0,fail]]],
 [18206,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [18208,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [18209,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],[18210,[[5,fail]]],
 [18212,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [18214,[[3,[2,4]],[9,[2,4]],[15,[2,4]],[21,[2,4]],[27,[2,4]],[33,[2,4]],
     [39,[2,4]],[45,[2,4]],[51,[2,4]],[57,[2,4]]]],
 [18215,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [18216,[[0,[3]],[7,[3]],[13,[3]],[19,[3]],[25,[3]],[31,[3]],[37,[3]],
     [43,[3]],[49,[3]],[55,[3]]]],
 [18223,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [18224,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [18225,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [18230,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [18231,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [18232,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [18251,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [18252,[[5,[1,2,3]],[17,[1,2,3]],[29,[1,2,3]],[41,[1,2,3]],[53,[1,2,3]],
     [65,[1,2,3]],[77,[1,2,3]],[89,[1,2,3]],[101,[1,2,3]],[113,[1,2,3]]] 
  ],
 [18258,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [18260,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [18261,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[16,[1,2]],
     [17,[1,2]],[21,[1,2]],[25,[1,2]],[28,[1,2]]]],
 [18262,[[0,[1]],[1,[1]],[5,[1]],[9,[1]],[12,[1]],[13,[1]],[17,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [18265,[[8,[2,4]],[20,[2,4]],[32,[2,4]],[44,[2,4]],[56,[2,4]],
     [68,[2,4]],[80,[2,4]],[92,[2,4]],[104,[2,4]],[116,[2,4]]]],
 [18267,[[0,[1]],[5,[1]],[8,[1]],[9,[1]],[13,[1]],[17,[1]],[20,[1]],
     [21,[1]],[25,[1]],[29,[1]]]],
 [18269,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [18272,[[4,[2,4]],[16,[2,4]],[28,[2,4]],[40,[2,4]],[52,[2,4]],
     [64,[2,4]],[76,[2,4]],[88,[2,4]],[100,[2,4]],[112,[2,4]]]],
 [18273,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [18275,[[0,[1,1,2]],[8,[1,1,2]],[12,[1,1,2]],[20,[1,1,2]],[24,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[44,[1,1,2]],[48,[1,1,2]],[56,[1,1,2]]]],
 [18276,[[4,[2]],[8,[2]],[16,[2]],[20,[2]],[28,[2]],[32,[2]],[40,[2]],
     [44,[2]],[52,[2]],[56,[2]]]],
 [18277,[[0,[1,1,2]],[4,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],[24,[1,1,2]],
     [28,[1,1,2]],[36,[1,1,2]],[40,[1,1,2]],[48,[1,1,2]],[52,[1,1,2]]]],
 [18278,[[0,fail]]],[18279,[[4,fail]]],[18286,[[8,fail]]],
 [18292,[[7,[4]],[27,[4]],[47,[4]],[67,[4]],[87,[4]],[107,[4]],
     [127,[4]],[147,[4]],[167,[4]],[187,[4]]]],
 [18294,[[8,[2,3,3]],[28,[2,3,3]],[48,[2,3,3]],[68,[2,3,3]],[88,[2,3,3]],
     [108,[2,3,3]],[128,[2,3,3]],[148,[2,3,3]],[168,[2,3,3]],
     [188,[2,3,3]]]],
 [18296,[[8,[2,3,3]],[28,[2,3,3]],[48,[2,3,3]],[68,[2,3,3]],[88,[2,3,3]],
     [108,[2,3,3]],[128,[2,3,3]],[148,[2,3,3]],[168,[2,3,3]],
     [188,[2,3,3]]]],
 [18297,[[8,[4]],[28,[4]],[48,[4]],[68,[4]],[88,[4]],[108,[4]],
     [128,[4]],[148,[4]],[168,[4]],[188,[4]]]],
 [18302,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [18304,[[4,[1,1,2]],[16,[1,1,2]],[28,[1,1,2]],[40,[1,1,2]],[52,[1,1,2]],
     [64,[1,1,2]],[76,[1,1,2]],[88,[1,1,2]],[100,[1,1,2]],[112,[1,1,2]]] 
  ],
 [18306,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [18308,[[0,[2,3,3]],[11,[2,3,3]],[12,[2,3,3]],[23,[2,3,3]],[24,[2,3,3]],
     [35,[2,3,3]],[36,[2,3,3]],[47,[2,3,3]],[48,[2,3,3]],[59,[2,3,3]]]],
 [18309,[[4,[1,1,2]],[16,[1,1,2]],[28,[1,1,2]],[40,[1,1,2]],[52,[1,1,2]],
     [64,[1,1,2]],[76,[1,1,2]],[88,[1,1,2]],[100,[1,1,2]],[112,[1,1,2]]] 
  ],
 [18311,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [18314,[[4,[3,3,4]],[7,[1,1,2]],[16,[3,3,4]],[19,[1,1,2]],[28,[3,3,4]],
     [31,[1,1,2]],[40,[3,3,4]],[43,[1,1,2]],[52,[3,3,4]],[55,[1,1,2]]]],
 [18316,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [18319,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [18322,[[8,[1,1,2]],[20,[1,1,2]],[32,[1,1,2]],[44,[1,1,2]],[56,[1,1,2]],
     [68,[1,1,2]],[80,[1,1,2]],[92,[1,1,2]],[104,[1,1,2]],[116,[1,1,2]]] 
  ],
 [18325,[[8,[4]],[20,[4]],[32,[4]],[44,[4]],[56,[4]],[68,[4]],[80,[4]],
     [92,[4]],[104,[4]],[116,[4]]]],
 [18326,[[8,[1,1,2]],[20,[1,1,2]],[32,[1,1,2]],[44,[1,1,2]],[56,[1,1,2]],
     [68,[1,1,2]],[80,[1,1,2]],[92,[1,1,2]],[104,[1,1,2]],[116,[1,1,2]]] 
  ],
 [18328,[[3,[1,1,2]],[4,[3,3,4]],[15,[1,1,2]],[16,[3,3,4]],[27,[1,1,2]],
     [28,[3,3,4]],[39,[1,1,2]],[40,[3,3,4]],[51,[1,1,2]],[52,[3,3,4]]]],
 [18331,[[8,fail]]],[18332,[[0,fail]]],[18333,[[4,fail]]],
 [18346,[[8,[2]],[28,[2]],[48,[2]],[68,[2]],[88,[2]],[108,[2]],
     [128,[2]],[148,[2]],[168,[2]],[188,[2]]]],
 [18351,[[1,[2]],[8,[1,1,2]],[21,[2]],[28,[1,1,2]],[41,[2]],[48,[1,1,2]],
     [61,[2]],[68,[1,1,2]],[81,[2]],[88,[1,1,2]]]],
 [18352,[[4,[2]],[24,[2]],[44,[2]],[64,[2]],[84,[2]],[104,[2]],
     [124,[2]],[144,[2]],[164,[2]],[184,[2]]]],
 [18354,[[4,[1,1,2]],[5,[2]],[24,[1,1,2]],[25,[2]],[44,[1,1,2]],
     [45,[2]],[64,[1,1,2]],[65,[2]],[84,[1,1,2]],[85,[2]]]],
 [18356,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [18357,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [18359,[[4,[1,1,2]],[16,[1,1,2]],[28,[1,1,2]],[40,[1,1,2]],[52,[1,1,2]],
     [64,[1,1,2]],[76,[1,1,2]],[88,[1,1,2]],[100,[1,1,2]],[112,[1,1,2]]] 
  ],
 [18361,[[4,[1,1,2]],[16,[1,1,2]],[28,[1,1,2]],[40,[1,1,2]],[52,[1,1,2]],
     [64,[1,1,2]],[76,[1,1,2]],[88,[1,1,2]],[100,[1,1,2]],[112,[1,1,2]]] 
  ],
 [18364,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [18366,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [18367,[[4,[1,1,1,2]],[16,[1,1,1,2]],[28,[1,1,1,2]],[40,[1,1,1,2]],
     [52,[1,1,1,2]],[64,[1,1,1,2]],[76,[1,1,1,2]],[88,[1,1,1,2]],
     [100,[1,1,1,2]],[112,[1,1,1,2]]]],
 [18376,[[0,[1,1,2]],[8,[3,3,4]],[13,[1,1,2]],[20,[3,3,4]],[25,[1,1,2]],
     [32,[3,3,4]],[37,[1,1,2]],[44,[3,3,4]],[49,[1,1,2]],[56,[3,3,4]]]],
 [18377,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [18380,[[4,[1,1,2]],[8,[3,3,4]],[17,[1,1,2]],[20,[3,3,4]],[29,[1,1,2]],
     [32,[3,3,4]],[41,[1,1,2]],[44,[3,3,4]],[53,[1,1,2]],[56,[3,3,4]]]],
 [18381,[[8,[1,1,2]],[20,[1,1,2]],[32,[1,1,2]],[44,[1,1,2]],[56,[1,1,2]],
     [68,[1,1,2]],[80,[1,1,2]],[92,[1,1,2]],[104,[1,1,2]],[116,[1,1,2]]] 
  ],
 [18382,[[4,[1,1,1,2]],[16,[1,1,1,2]],[28,[1,1,1,2]],[40,[1,1,1,2]],
     [52,[1,1,1,2]],[64,[1,1,1,2]],[76,[1,1,1,2]],[88,[1,1,1,2]],
     [100,[1,1,1,2]],[112,[1,1,1,2]]]],
 [18383,[[4,[4]],[16,[4]],[28,[4]],[40,[4]],[52,[4]],[64,[4]],[76,[4]],
     [88,[4]],[100,[4]],[112,[4]]]],
 [18384,[[0,[4]],[12,[4]],[24,[4]],[36,[4]],[48,[4]],[60,[4]],[72,[4]],
     [84,[4]],[96,[4]],[108,[4]]]],
 [18385,[[0,[1,1,1,2]],[12,[1,1,1,2]],[24,[1,1,1,2]],[36,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[72,[1,1,1,2]],[84,[1,1,1,2]],
     [96,[1,1,1,2]],[108,[1,1,1,2]]]],[18386,[[4,fail]]],[18387,[[8,fail]]],
 [18388,[[0,fail]]],
 [18423,[[3,[1,1,1,2,2,2,3,2]],[16,[1,1,1,2,2,2,3,2]],[28,[1,2]],
     [40,[1,1,1,2,2,2,3,2]],[52,[1,1,1,2,2,2,3,2]],[63,[1,1,1,2,2,2,3,2]],
     [76,[1,1,1,2,2,2,3,2]],[88,[1,2]],[100,[1,1,1,2,2,2,3,2]],
     [112,[1,1,1,2,2,2,3,2]]]],
 [18425,[[12,[1,2]],[43,[1,2]],[72,[1,2]],[103,[1,2]],[132,[1,2]],
     [163,[1,2]],[192,[1,2]],[223,[1,2]],[252,[1,2]]]],
 [18426,[[3,[1,1,1,1,2]],[5,[1]],[11,[1]],[15,[1,1,1,1,2]],[16,[1]],
     [17,[1,1,1,1,2]],[25,[1]],[28,[1,1,1,1,2]],[31,[1]],
     [35,[1,1,1,1,2]]]],
 [18427,[[1,[1,2]],[5,[1,2]],[15,[1,2]],[21,[1,2]],[23,[1,2]],[25,[1,2]],
     [35,[1,2]],[36,[1,2]],[41,[1,2]],[45,[1,2]]]],
 [18430,[[8,[1,1,1,2,2,2,3,2]],[20,[1,1,1,2,2,2,3,2]],[32,[1,2]],
     [43,[1,1,1,2,2,2,3,2]],[56,[1,1,1,2,2,2,3,2]],[68,[1,1,1,2,2,2,3,2]],
     [80,[1,1,1,2,2,2,3,2]],[92,[1,2]],[103,[1,1,1,2,2,2,3,2]],
     [116,[1,1,1,2,2,2,3,2]]]],
 [18432,[[5,[1,1,1,1,2]],[7,[1,1,1,1,2]],[8,[1]],[11,[1]],[17,[1]],
     [25,[1,1,1,1,2]],[27,[1,1,1,1,2]],[31,[1]],[32,[1,1,1,1,2]],
     [37,[1]]]],
 [18434,[[8,[1,1,2,1,2,2,2,3]],[20,[1,1,2,1,2,2,2,3]],[32,[1]],
     [43,[1,1,2,1,2,2,2,3]],[56,[1,1,2,1,2,2,2,3]],[68,[1,1,2,1,2,2,2,3]],
     [80,[1,1,2,1,2,2,2,3]],[92,[1]],[103,[1,1,2,1,2,2,2,3]],
     [116,[1,1,2,1,2,2,2,3]]]],
 [18437,[[3,[1,1,2,1,2,2,2,3]],[16,[1,1,2,1,2,2,2,3]],[28,[1]],
     [40,[1,1,2,1,2,2,2,3]],[52,[1,1,2,1,2,2,2,3]],[63,[1,1,2,1,2,2,2,3]],
     [76,[1,1,2,1,2,2,2,3]],[88,[1]],[100,[1,1,2,1,2,2,2,3]],
     [112,[1,1,2,1,2,2,2,3]]]],
 [18438,[[0,[1,2,2,2,3,2,2,2]],[12,[1,2,2,2,3,2,2,2]],[23,[1,2]],
     [36,[1,2,2,2,3,2,2,2]],[48,[1,2,2,2,3,2,2,2]],[60,[1,2,2,2,3,2,2,2]],
     [72,[1,2,2,2,3,2,2,2]],[83,[1,2]],[96,[1,2,2,2,3,2,2,2]],
     [108,[1,2,2,2,3,2,2,2]]]],
 [18439,[[8,[1,2]],[36,[1,2]],[68,[1,2]],[96,[1,2]],[128,[1,2]],
     [156,[1,2]],[188,[1,2]],[216,[1,2]],[248,[1,2]]]],
 [18440,[[3,[3,3,5,5]],[23,[3,3,5,5]],[32,[3,3,5,5]],[52,[3,3,5,5]],
     [63,[3,3,5,5]],[83,[3,3,5,5]],[92,[3,3,5,5]],[112,[3,3,5,5]],
     [123,[3,3,5,5]],[143,[3,3,5,5]]]],
 [18442,[[3,[1,1,2]],[8,[2]],[16,[4]],[36,[4]],[43,[1,1,2]],[48,[2]],
     [63,[1,1,2]],[68,[2]],[76,[4]],[96,[4]]]],
 [18469,[[16,[1,2]],[47,[1,2]],[76,[1,2]],[107,[1,2]],[136,[1,2]],
     [167,[1,2]],[196,[1,2]],[227,[1,2]]]],
 [18476,[[4,[1,2,2,2,3,2,2,2]],[16,[1,2,2,2,3,2,2,2]],[27,[1,2]],
     [40,[1,2,2,2,3,2,2,2]],[52,[1,2,2,2,3,2,2,2]],[64,[1,2,2,2,3,2,2,2]],
     [76,[1,2,2,2,3,2,2,2]],[87,[1,2]],[100,[1,2,2,2,3,2,2,2]],
     [112,[1,2,2,2,3,2,2,2]]]],
 [18477,[[12,[1,2]],[40,[1,2]],[72,[1,2]],[100,[1,2]],[132,[1,2]],
     [160,[1,2]],[192,[1,2]],[220,[1,2]],[252,[1,2]]]],
 [18479,[[0,[1,1,1,1,2]],[5,[1,1,1,1,2]],[11,[1,1,1,1,2]],[16,[1,1,1,1,2]],
     [19,[1,1,1,1,2]],[21,[1,1,1,1,2]],[25,[1,1,1,1,2]],[27,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[39,[1,1,1,1,2]]]],
 [18480,[[0,[1,1,1,1,2]],[5,[1,1,1,1,2]],[9,[1,1,1,1,2]],[11,[1,1,1,1,2]],
     [12,[1,1,1,1,2]],[19,[1,1,1,1,2]],[25,[1,1,1,1,2]],[29,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[36,[1,1,1,1,2]]]],
 [18483,[[7,[1,1,2,1,2,2,2,3]],[20,[1,1,2,1,2,2,2,3]],[32,[1]],
     [44,[1,1,2,1,2,2,2,3]],[56,[1,1,2,1,2,2,2,3]],[67,[1,1,2,1,2,2,2,3]],
     [80,[1,1,2,1,2,2,2,3]],[92,[1]],[104,[1,1,2,1,2,2,2,3]],
     [116,[1,1,2,1,2,2,2,3]]]],
 [18485,[[5,[1,2]],[7,[1,2]],[11,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [32,[1,2]],[39,[1,2]],[45,[1,2]],[51,[1,2]]]],
 [18487,[[7,[1,1,1,2,2,2,3,2]],[20,[1,1,1,2,2,2,3,2]],[32,[1,2]],
     [44,[1,1,1,2,2,2,3,2]],[56,[1,1,1,2,2,2,3,2]],[67,[1,1,1,2,2,2,3,2]],
     [80,[1,1,1,2,2,2,3,2]],[92,[1,2]],[104,[1,1,1,2,2,2,3,2]],
     [116,[1,1,1,2,2,2,3,2]]]],
 [18490,[[4,[1,1,1,2,2,1,1,2]],[16,[1,1,1,2,2,1,1,2]],[27,[3,5]],
     [40,[1,1,1,2,2,1,1,2]],[52,[1,1,1,2,2,1,1,2]],[64,[1,1,1,2,2,1,1,2]],
     [76,[1,1,1,2,2,1,1,2]],[87,[3,5]],[100,[1,1,1,2,2,1,1,2]],
     [112,[1,1,1,2,2,1,1,2]]]],
 [18492,[[24,[1]],[84,[1]],[144,[1]],[204,[1]]]],
 [18494,[[7,[4]],[16,[2]],[20,[1,1,2]],[36,[2]],[40,[1,1,2]],[47,[4]],
     [67,[4]],[76,[2]],[80,[1,1,2]],[96,[2]]]],
 [18521,[[12,[1]],[40,[1]],[72,[1]],[100,[1]],[132,[1]],[160,[1]],
     [192,[1]],[220,[1]],[252,[1]]]],
 [18522,[[17,[2]],[47,[2]],[77,[2]],[107,[2]],[137,[2]],[167,[2]],
     [197,[2]],[227,[2]]]],
 [18544,[[12,[1]],[40,[1]],[72,[1]],[100,[1]],[132,[1]],[160,[1]],
     [192,[1]],[220,[1]],[252,[1]]]],
 [18573,[[11,[1,1,1,1,2]],[48,[1,1,1,1,2]],[71,[1,1,1,1,2]],
     [108,[1,1,1,1,2]],[131,[1,1,1,1,2]],[168,[1,1,1,1,2]],
     [191,[1,1,1,1,2]],[228,[1,1,1,1,2]],[251,[1,1,1,1,2]]]],
 [18577,[[16,[1,2]],[44,[1,2]],[76,[1,2]],[104,[1,2]],[136,[1,2]],
     [164,[1,2]],[196,[1,2]],[224,[1,2]]]],
 [18580,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [18582,[[4,[1,2]],[5,[1,2]],[9,[1,2]],[15,[1,2]],[25,[1,2]],[29,[1,2]],
     [35,[1,2]],[40,[1,2]],[45,[1,2]],[49,[1,2]]]],
 [18583,[[0,[1,1,1,1,2]],[5,[1]],[11,[1]],[13,[1,1,1,1,2]],
     [15,[1,1,1,1,2]],[19,[1]],[24,[1,1,1,1,2]],[25,[1]],
     [33,[1,1,1,1,2]],[35,[1,1,1,1,2]]]],
 [18586,[[8,[1,1,1,2,2,1,1,2]],[20,[1,1,1,2,2,1,1,2]],[31,[3,5]],
     [44,[1,1,1,2,2,1,1,2]],[56,[1,1,1,2,2,1,1,2]],[68,[1,1,1,2,2,1,1,2]],
     [80,[1,1,1,2,2,1,1,2]],[91,[3,5]],[104,[1,1,1,2,2,1,1,2]],
     [116,[1,1,1,2,2,1,1,2]]]],
 [18588,[[15,[1]],[20,[1]],[35,[1]],[55,[1]],[75,[1]],[80,[1]],[95,[1]],
     [115,[1]],[135,[1]],[140,[1]]]],
 [18590,[[8,[1,2,2,2,3,2,2,2]],[20,[1,2,2,2,3,2,2,2]],[31,[1,2]],
     [44,[1,2,2,2,3,2,2,2]],[56,[1,2,2,2,3,2,2,2]],[68,[1,2,2,2,3,2,2,2]],
     [80,[1,2,2,2,3,2,2,2]],[91,[1,2]],[104,[1,2,2,2,3,2,2,2]],
     [116,[1,2,2,2,3,2,2,2]]]],
 [18592,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [18594,[[0,[1,1,1,2,2,1,1,2]],[11,[1,1,1,2,2,1,1,2]],[24,[3,5]],
     [36,[1,1,1,2,2,1,1,2]],[48,[1,1,1,2,2,1,1,2]],[60,[1,1,1,2,2,1,1,2]],
     [71,[1,1,1,2,2,1,1,2]],[84,[3,5]],[96,[1,1,1,2,2,1,1,2]],
     [108,[1,1,1,2,2,1,1,2]]]],
 [18596,[[20,[2,3,3]],[40,[2,3,3]],[80,[2,3,3]],[100,[2,3,3]],
     [140,[2,3,3]],[160,[2,3,3]],[200,[2,3,3]],[220,[2,3,3]]]],
 [18597,[[16,[2,3,3]],[36,[2,3,3]],[76,[2,3,3]],[96,[2,3,3]],[136,[2,3,3]],
     [156,[2,3,3]],[196,[2,3,3]],[216,[2,3,3]]]],
 [18598,[[0,[3,3,5,5]],[20,[3,3,5,5]],[31,[3,3,5,5]],[51,[3,3,5,5]],
     [60,[3,3,5,5]],[80,[3,3,5,5]],[91,[3,3,5,5]],[111,[3,3,5,5]],
     [120,[3,3,5,5]],[140,[3,3,5,5]]]],
 [18630,[[16,[1]],[44,[1]],[76,[1]],[104,[1]],[136,[1]],[164,[1]],
     [196,[1]],[224,[1]]]],
 [18672,[[21,[2]],[81,[2]],[141,[2]],[201,[2]]]],
 [18678,[[0,[1,1,2,2,2,3,3,2]],[16,[1,1,2,2,2,3,3,2]],[28,[1,2]],
     [40,[1,1,2,2,2,3,3,2]],[51,[1,1,2,2,2,3,3,2]],[61,[1,1,2,2,2,3,3,2]],
     [76,[1,1,2,2,2,3,3,2]],[88,[1,2]],[100,[1,1,2,2,2,3,3,2]],
     [111,[1,1,2,2,2,3,3,2]]]],
 [18679,[[31,[1,2,2]],[91,[1,2,2]],[151,[1,2,2]],[211,[1,2,2]]]],
 [18680,[[16,[1,1,1,2]],[28,[1]],[76,[1,1,1,2]],[88,[1]],[136,[1,1,1,2]],
     [148,[1]],[196,[1,1,1,2]],[208,[1]]]],
 [18681,[[0,[3]],[5,[1]],[13,[1,2]],[15,[3]],[16,[1,2]],[25,[1]],
     [33,[1,2]],[35,[3]],[45,[1]],[51,[1]]]],
 [18682,[[5,[1]],[11,[1,2]],[15,[3]],[17,[1,2]],[21,[3]],[25,[1]],
     [35,[3]],[36,[1]],[37,[1,2]],[45,[1]]]],
 [18685,[[8,[1,1,1,1,2,2,3,2]],[20,[1,1,1,1,2,2,3,2]],[31,[3]],
     [41,[1,1,1,1,2,2,3,2]],[56,[1,1,1,1,2,2,3,2]],[68,[1,1,1,1,2,2,3,2]],
     [80,[1,1,1,1,2,2,3,2]],[91,[3]],[101,[1,1,1,1,2,2,3,2]],
     [116,[1,1,1,1,2,2,3,2]]]],
 [18687,[[0,[2]],[23,[2]],[41,[2]],[43,[2]],[63,[2]],[83,[2]],[101,[2]],
     [103,[2]],[123,[2]],[143,[2]]]],
 [18689,[[8,[1,1,2,3,3,3,3,2]],[20,[1,1,2,3,3,3,3,2]],[31,[1]],
     [41,[1,1,2,3,3,3,3,2]],[56,[1,1,2,3,3,3,3,2]],[68,[1,1,2,3,3,3,3,2]],
     [80,[1,1,2,3,3,3,3,2]],[91,[1]],[101,[1,1,2,3,3,3,3,2]],
     [116,[1,1,2,3,3,3,3,2]]]],
 [18692,[[1,[2,2,2,2,3,2,2,3]],[16,[2,2,2,2,3,2,2,3]],[28,[1]],
     [40,[2,2,2,2,3,2,2,3]],[51,[2,2,2,2,3,2,2,3]],[61,[2,2,2,2,3,2,2,3]],
     [76,[2,2,2,2,3,2,2,3]],[88,[1]],[100,[2,2,2,2,3,2,2,3]],
     [111,[2,2,2,2,3,2,2,3]]]],
 [18693,[[0,[1,1,1,1,2,2,3,2]],[11,[1,1,1,1,2,2,3,2]],[21,[3,4]],
     [36,[1,1,1,1,2,2,3,2]],[48,[1,1,1,1,2,2,3,2]],[60,[1,1,1,1,2,2,3,2]],
     [71,[1,1,1,1,2,2,3,2]],[81,[3,4]],[96,[1,1,1,1,2,2,3,2]],
     [108,[1,1,1,1,2,2,3,2]]]],
 [18695,[[0,[2,2,2,3]],[20,[2,2,2,3]],[21,[2,2,2,3]],[36,[2,2,2,3]],
     [40,[2,2,2,3]],[56,[2,2,2,3]],[60,[2,2,2,3]],[80,[2,2,2,3]],
     [81,[2,2,2,3]],[96,[2,2,2,3]]]],
 [18696,[[0,[1,2,2]],[11,[1,1,2,2,2]],[16,[1,1,2,2,2]],[20,[1,2,2]],
     [31,[1,1,2,2,2]],[40,[1,2,2]],[41,[1,2,2]],[56,[1,1,2,2,2]],
     [60,[1,2,2]],[71,[1,1,2,2,2]]]],
 [18697,[[16,[1,1,2]],[36,[1,1,2]],[76,[1,1,2]],[96,[1,1,2]],[136,[1,1,2]],
     [156,[1,1,2]],[196,[1,1,2]],[216,[1,1,2]]]],[18704,[[21,fail]]],
 [18720,[[0,[1,1,2,2]],[17,[1,1,2,2]],[35,[1,1,2,2]],[47,[1,1,2,2]],
     [48,[1,1,2,2]],[60,[1,1,2,2]],[77,[1,1,2,2]],[95,[1,1,2,2]],
     [107,[1,1,2,2]],[108,[1,1,2,2]]]],
 [18724,[[32,[1]],[92,[1]],[152,[1]],[212,[1]]]],
 [18726,[[4,[1,1,1,2,2,1,1,2]],[15,[1,1,1,2,2,1,1,2]],[28,[3,5]],
     [40,[1,1,1,2,2,1,1,2]],[52,[1,1,1,2,2,1,1,2]],[64,[1,1,1,2,2,1,1,2]],
     [75,[1,1,1,2,2,1,1,2]],[88,[3,5]],[100,[1,1,1,2,2,1,1,2]],
     [112,[1,1,1,2,2,1,1,2]]]],
 [18729,[[7,[1]],[27,[1]],[40,[1]],[47,[1]],[67,[1]],[87,[1]],[100,[1]],
     [107,[1]],[127,[1]],[147,[1]]]],
 [18730,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[24,[1,2]],[27,[1,2]],
     [33,[1,2]],[35,[1,2]],[39,[1,2]],[47,[1,2]]]],
 [18735,[[7,[1,2]],[8,[1,2]],[13,[1,2]],[17,[1,2]],[20,[1,2]],[27,[1,2]],
     [33,[1,2]],[37,[1,2]],[47,[1,2]],[53,[1,2]]]],
 [18739,[[15,[1,2]],[44,[1,2]],[75,[1,2]],[104,[1,2]],[135,[1,2]],
     [164,[1,2]],[195,[1,2]],[224,[1,2]],[255,[1,2]]]],
 [18740,[[4,[1,2,2,2,3,2,2,2]],[15,[1,2,2,2,3,2,2,2]],[28,[1,2]],
     [40,[1,2,2,2,3,2,2,2]],[52,[1,2,2,2,3,2,2,2]],[64,[1,2,2,2,3,2,2,2]],
     [75,[1,2,2,2,3,2,2,2]],[88,[1,2]],[100,[1,2,2,2,3,2,2,2]],
     [112,[1,2,2,2,3,2,2,2]]]],
 [18741,[[0,[1,1,2,1,2,2,2,3]],[12,[1,1,2,1,2,2,2,3]],[24,[1]],
     [35,[1,1,2,1,2,2,2,3]],[48,[1,1,2,1,2,2,2,3]],[60,[1,1,2,1,2,2,2,3]],
     [72,[1,1,2,1,2,2,2,3]],[84,[1]],[95,[1,1,2,1,2,2,2,3]],
     [108,[1,1,2,1,2,2,2,3]]]],
 [18743,[[8,[4]],[15,[1,1,2]],[20,[2]],[35,[1,1,2]],[40,[2]],[48,[4]],
     [68,[4]],[75,[1,1,2]],[80,[2]],[95,[1,1,2]]]],
 [18771,[[20,[1]],[48,[1]],[80,[1]],[108,[1]],[140,[1]],[168,[1]],
     [200,[1]],[228,[1]]]],
 [18786,[[8,[1]],[40,[1]],[68,[1]],[100,[1]],[128,[1]],[160,[1]],
     [188,[1]],[220,[1]],[248,[1]]]],
 [18812,[[20,[1,1,1,2]],[32,[1]],[80,[1,1,1,2]],[92,[1]],[140,[1,1,1,2]],
     [152,[1]],[200,[1,1,1,2]],[212,[1]]]],
 [18813,[[35,[2,2,3]],[95,[2,2,3]],[155,[2,2,3]],[215,[2,2,3]]]],
 [18817,[[35,[1,2,2]],[95,[1,2,2]],[155,[1,2,2]],[215,[1,2,2]]]],
 [18819,[[4,[1,1,1,1,2,2,3,2]],[15,[1,1,1,1,2,2,3,2]],[25,[3,4]],
     [40,[1,1,1,1,2,2,3,2]],[52,[1,1,1,1,2,2,3,2]],[64,[1,1,1,1,2,2,3,2]],
     [75,[1,1,1,1,2,2,3,2]],[85,[3,4]],[100,[1,1,1,1,2,2,3,2]],
     [112,[1,1,1,1,2,2,3,2]]]],
 [18823,[[0,[2,3,3,4]],[7,[2,3,3,4]],[9,[2,3,3,4]],[27,[2,3,3,4]],
     [29,[2,3,3,4]],[45,[2,3,3,4]],[47,[2,3,3,4]],[49,[2,3,3,4]],
     [60,[2,3,3,4]],[67,[2,3,3,4]]]],
 [18826,[[5,[2,2,2,2,3,2,2,3]],[20,[2,2,2,2,3,2,2,3]],[32,[1]],
     [44,[2,2,2,2,3,2,2,3]],[55,[2,2,2,2,3,2,2,3]],[65,[2,2,2,2,3,2,2,3]],
     [80,[2,2,2,2,3,2,2,3]],[92,[1]],[104,[2,2,2,2,3,2,2,3]],
     [115,[2,2,2,2,3,2,2,3]]]],
 [18830,[[4,[1,1,2,2,2,3,3,2]],[20,[1,1,2,2,2,3,3,2]],[32,[1,2]],
     [44,[1,1,2,2,2,3,3,2]],[55,[1,1,2,2,2,3,3,2]],[65,[1,1,2,2,2,3,3,2]],
     [80,[1,1,2,2,2,3,3,2]],[92,[1,2]],[104,[1,1,2,2,2,3,3,2]],
     [115,[1,1,2,2,2,3,3,2]]]],
 [18833,[[4,[1,1,1,1,2,2,3,2]],[15,[1,1,1,1,2,2,3,2]],[25,[3,4]],
     [40,[1,1,1,1,2,2,3,2]],[52,[1,1,1,1,2,2,3,2]],[64,[1,1,1,1,2,2,3,2]],
     [75,[1,1,1,1,2,2,3,2]],[85,[3,4]],[100,[1,1,1,1,2,2,3,2]],
     [112,[1,1,1,1,2,2,3,2]]]],
 [18834,[[0,[2,2,2,2,3,2,2,3]],[12,[2,2,2,2,3,2,2,3]],[24,[1]],
     [35,[2,2,2,2,3,2,2,3]],[45,[2,2,2,2,3,2,2,3]],[60,[2,2,2,2,3,2,2,3]],
     [72,[2,2,2,2,3,2,2,3]],[84,[1]],[95,[2,2,2,2,3,2,2,3]],
     [105,[2,2,2,2,3,2,2,3]]]],
 [18836,[[4,[2,3]],[15,[2]],[24,[2,3]],[35,[2]],[44,[2,3]],[45,[2,3]],
     [64,[2,3]],[75,[2]],[84,[2,3]],[95,[2]]]],
 [18837,[[5,[2,3]],[12,[2,3]],[20,[2]],[32,[2,3]],[40,[2]],[52,[2,3]],
     [65,[2,3]],[72,[2,3]],[80,[2]],[92,[2,3]]]],
 [18838,[[0,[1,1,2,3,2]],[4,[1,1,2,3,2]],[15,[1,1,2,3,2]],[24,[1,1,2,3,2]],
     [25,[1,1,2,3,2]],[40,[1,1,2,3,2]],[44,[1,1,2,3,2]],[55,[1,1,2,3,2]],
     [60,[1,1,2,3,2]],[64,[1,1,2,3,2]]]],[18844,[[25,fail]]],
 [18857,[[20,[1]],[48,[1]],[80,[1]],[108,[1]],[140,[1]],[168,[1]],
     [200,[1]],[228,[1]]]],
 [18858,[[5,[1,1,2]],[11,[2,3,3]],[25,[1,1,2]],[35,[1,1,2]],[41,[2,3,3]],
     [55,[1,1,2]],[65,[1,1,2]],[71,[2,3,3]],[85,[1,1,2]],[95,[1,1,2]]]],
 [18862,[[8,[1]],[40,[1]],[68,[1]],[100,[1]],[128,[1]],[160,[1]],
     [188,[1]],[220,[1]],[248,[1]]]],
 [18908,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [18910,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [18911,[[3,[1]],[7,[1]],[15,[1]],[19,[1]],[27,[1]],[31,[1]],[39,[1]],
     [43,[1]],[51,[1]],[55,[1]]]],
 [18912,[[1,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [18915,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [18919,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [18922,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [18923,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [18924,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[18931,[[0,fail]]],[18939,[[0,fail]]],
 [18951,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [18952,[[1,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [18955,[[1,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [18958,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [18960,[[7,[1]],[11,[1]],[19,[1]],[23,[1]],[31,[1]],[35,[1]],[43,[1]],
     [47,[1]],[55,[1]],[59,[1]]]],
 [18962,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [18965,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],[18973,[[0,fail]]],[18981,[[0,fail]]],
 [18986,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [18993,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19000,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19004,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19007,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19008,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [19009,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [19027,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [19034,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19035,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19037,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [19041,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19045,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19049,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[19056,[[4,fail]]],[19064,[[4,fail]]],
 [19068,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [19074,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [19081,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [19085,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [19107,[[0,[1,2,2]],[12,[1,2,2]],[24,[1,2,2]],[36,[1,2,2]],[48,[1,2,2]],
     [60,[1,2,2]],[72,[1,2,2]],[84,[1,2,2]],[96,[1,2,2]],[108,[1,2,2]]]]
  ,
 [19113,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19115,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19116,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [19117,[[3,[1]],[7,[1]],[15,[1]],[19,[1]],[27,[1]],[31,[1]],[39,[1]],
     [43,[1]],[51,[1]],[55,[1]]]],
 [19120,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19122,[[0,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [19124,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [19127,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19128,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [19129,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],[19136,[[4,fail]]],[19144,[[4,fail]]],
 [19151,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19154,[[0,[1,2]],[5,[3]],[7,[1,2]],[11,[3]],[13,[1,2]],[17,[3]],
     [19,[1,2]],[23,[3]],[25,[1,2]],[29,[3]]]],
 [19155,[[0,[1]],[7,[1]],[11,[1]],[12,[1]],[19,[1]],[23,[1]],[24,[1]],
     [31,[1]],[35,[1]],[36,[1]]]],
 [19158,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19159,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19162,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19166,[[0,[2]],[5,[1]],[11,[1]],[12,[2]],[17,[1]],[23,[1]],[24,[2]],
     [29,[1]],[35,[1]],[36,[2]]]],
 [19167,[[0,[2]],[4,[1]],[8,[1]],[12,[2]],[16,[1]],[20,[1]],[24,[2]],
     [28,[1]],[32,[1]],[36,[2]]]],[19169,[[4,fail]]],
 [19171,[[7,[1]],[23,[1]],[31,[1]],[47,[1]],[55,[1]],[71,[1]],[79,[1]],
     [95,[1]],[103,[1]],[119,[1]]]],
 [19172,[[7,[1,2]],[11,[1,2]],[19,[1,2]],[23,[1,2]],[31,[1,2]],
     [35,[1,2]],[43,[1,2]],[47,[1,2]],[55,[1,2]],[59,[1,2]]]],
 [19179,[[11,[1]],[19,[1]],[35,[1]],[43,[1]],[59,[1]],[67,[1]],[83,[1]],
     [91,[1]],[107,[1]],[115,[1]]]],
 [19194,[[0,[1,2,2]],[12,[1,2,2]],[24,[1,2,2]],[36,[1,2,2]],[48,[1,2,2]],
     [60,[1,2,2]],[72,[1,2,2]],[84,[1,2,2]],[96,[1,2,2]],[108,[1,2,2]]]]
  ,
 [19195,[[5,[2,3]],[11,[2,3]],[17,[2,3]],[23,[2,3]],[29,[2,3]],
     [35,[2,3]],[41,[2,3]],[47,[2,3]],[53,[2,3]],[59,[2,3]]]],
 [19200,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [19203,[[0,[2,4]],[12,[2,4]],[24,[2,4]],[36,[2,4]],[48,[2,4]],
     [60,[2,4]],[72,[2,4]],[84,[2,4]],[96,[2,4]],[108,[2,4]]]],
 [19204,[[0,[2]],[3,[1]],[9,[1]],[12,[2]],[15,[1]],[21,[1]],[24,[2]],
     [27,[1]],[33,[1]],[36,[2]]]],
 [19222,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [19227,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [19228,[[3,[1]],[11,[1]],[15,[1]],[23,[1]],[27,[1]],[35,[1]],[39,[1]],
     [47,[1]],[51,[1]],[59,[1]]]],
 [19231,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [19233,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [19235,[[7,[1,2]],[19,[1,2]],[31,[1,2]],[43,[1,2]],[55,[1,2]],
     [67,[1,2]],[79,[1,2]],[91,[1,2]],[103,[1,2]],[115,[1,2]]]],
 [19237,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19238,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19239,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[19248,[[4,fail]]],[19253,[[4,fail]]],
 [19259,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19260,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [19266,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19270,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19272,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [19273,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19274,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [19293,[[0,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [19296,[[3,[1]],[11,[1]],[15,[1]],[23,[1]],[27,[1]],[35,[1]],[39,[1]],
     [47,[1]],[51,[1]],[59,[1]]]],
 [19297,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [19300,[[7,[2,3]],[19,[2,3]],[31,[2,3]],[43,[2,3]],[55,[2,3]],
     [67,[2,3]],[79,[2,3]],[91,[2,3]],[103,[2,3]],[115,[2,3]]]],
 [19304,[[7,[1]],[19,[1]],[31,[1]],[43,[1]],[55,[1]],[67,[1]],[79,[1]],
     [91,[1]],[103,[1]],[115,[1]]]],
 [19306,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [19307,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [19308,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19317,[[0,fail]]],[19322,[[0,fail]]],
 [19325,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [19328,[[0,[1]],[4,[1]],[8,[2]],[12,[1]],[16,[1]],[20,[2]],[24,[1]],
     [28,[1]],[32,[2]],[36,[1]]]],
 [19329,[[3,[1,2]],[5,[3]],[9,[1,2]],[11,[3]],[15,[1,2]],[17,[3]],
     [21,[1,2]],[23,[3]],[27,[1,2]],[29,[3]]]],
 [19331,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19333,[[5,[1]],[8,[2]],[11,[1]],[17,[1]],[20,[2]],[23,[1]],[29,[1]],
     [32,[2]],[35,[1]],[41,[1]]]],
 [19335,[[5,[1]],[8,[1]],[9,[1]],[17,[1]],[20,[1]],[21,[1]],[29,[1]],
     [32,[1]],[33,[1]],[41,[1]]]],
 [19337,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19340,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19341,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[19343,[[4,fail]]],
 [19351,[[5,[1,2]],[9,[1,2]],[17,[1,2]],[21,[1,2]],[29,[1,2]],[33,[1,2]],
     [41,[1,2]],[45,[1,2]],[53,[1,2]],[57,[1,2]]]],
 [19352,[[5,[1]],[21,[1]],[29,[1]],[45,[1]],[53,[1]],[69,[1]],[77,[1]],
     [93,[1]],[101,[1]],[117,[1]]]],
 [19353,[[9,[1]],[17,[1]],[33,[1]],[41,[1]],[57,[1]],[65,[1]],[81,[1]],
     [89,[1]],[105,[1]],[113,[1]]]],
 [19358,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19360,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [19365,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19369,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19372,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19373,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [19390,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19391,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19392,[[3,fail]]],
 [19393,[[0,[1,2,2,3]],[5,[1,2]],[9,[1,2,2,3]],[13,[1,2,2,3]],[17,[1,2]],
     [21,[1,2,2,3]],[25,[1,2,2,3]],[29,[1,2]],[33,[1,2,2,3]],
     [37,[1,2,2,3]]]],
 [19394,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [19397,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19398,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [19401,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19402,[[3,[1]],[4,[2]],[9,[1]],[15,[1]],[16,[2]],[21,[1]],[27,[1]],
     [28,[2]],[33,[1]],[39,[1]]]],
 [19403,[[3,[3]],[15,[3]],[27,[3]],[39,[3]],[51,[3]],[63,[3]],[75,[3]],
     [87,[3]],[99,[3]],[111,[3]]]],
 [19405,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19407,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [19408,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [19409,[[3,[1,2,2,3]],[11,[1,2]],[19,[1,2,2,3]],[27,[1,2,2,3]],
     [35,[1,2]],[43,[1,2,2,3]],[51,[1,2,2,3]],[59,[1,2]],[67,[1,2,2,3]],
     [75,[1,2,2,3]]]],[19410,[[4,fail]]],
 [19411,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19412,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19414,[[4,fail]]],
 [19415,[[0,[1,2,2,3]],[9,[1,2]],[17,[1,2,2,3]],[25,[1,2,2,3]],[33,[1,2]],
     [41,[1,2,2,3]],[49,[1,2,2,3]],[57,[1,2]],[65,[1,2,2,3]],
     [73,[1,2,2,3]]]],
 [19416,[[4,[1]],[13,[1]],[21,[1]],[29,[1]],[37,[1]],[45,[1]],[53,[1]],
     [61,[1]],[69,[1]],[77,[1]]]],
 [19417,[[4,[1]],[15,[1]],[23,[1]],[31,[1]],[39,[1]],[47,[1]],[55,[1]],
     [63,[1]],[71,[1]],[79,[1]]]],
 [19419,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19420,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19423,[[1,[3]],[5,[1,2]],[7,[3]],[11,[1,2]],[13,[3]],[17,[1,2]],
     [19,[3]],[23,[1,2]],[25,[3]],[29,[1,2]]]],
 [19426,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19427,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19430,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19432,[[0,[1]],[4,[2]],[8,[1]],[12,[1]],[16,[2]],[20,[1]],[24,[1]],
     [28,[2]],[32,[1]],[36,[1]]]],
 [19433,[[1,[1]],[4,[2]],[7,[1]],[13,[1]],[16,[2]],[19,[1]],[25,[1]],
     [28,[2]],[31,[1]],[37,[1]]]],[19437,[[0,fail]]],
 [19444,[[5,[1]],[13,[1]],[29,[1]],[37,[1]],[53,[1]],[61,[1]],[77,[1]],
     [85,[1]],[101,[1]],[109,[1]]]],
 [19445,[[1,[1,2]],[5,[1,2]],[13,[1,2]],[17,[1,2]],[25,[1,2]],[29,[1,2]],
     [37,[1,2]],[41,[1,2]],[49,[1,2]],[53,[1,2]]]],
 [19451,[[3,[1]],[4,[1]],[7,[1]],[15,[1]],[16,[1]],[19,[1]],[27,[1]],
     [28,[1]],[31,[1]],[39,[1]]]],
 [19452,[[1,[3]],[3,[1,2]],[7,[3]],[9,[1,2]],[13,[3]],[15,[1,2]],
     [19,[3]],[21,[1,2]],[25,[3]],[27,[1,2]]]],
 [19455,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19457,[[3,[1]],[7,[1]],[8,[1]],[15,[1]],[19,[1]],[20,[1]],[27,[1]],
     [31,[1]],[32,[1]],[39,[1]]]],
 [19459,[[1,[1]],[7,[1]],[8,[2]],[13,[1]],[19,[1]],[20,[2]],[25,[1]],
     [31,[1]],[32,[2]],[37,[1]]]],
 [19460,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [19462,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [19463,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19467,[[0,fail]]],
 [19468,[[3,[1,2]],[7,[1,2]],[15,[1,2]],[19,[1,2]],[27,[1,2]],[31,[1,2]],
     [39,[1,2]],[43,[1,2]],[51,[1,2]],[55,[1,2]]]],
 [19469,[[7,[1]],[15,[1]],[31,[1]],[39,[1]],[55,[1]],[63,[1]],[79,[1]],
     [87,[1]],[103,[1]],[111,[1]]]],
 [19481,[[5,[1]],[9,[1]],[17,[1]],[21,[1]],[29,[1]],[33,[1]],[41,[1]],
     [45,[1]],[53,[1]],[57,[1]]]],
 [19483,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [19487,[[3,[1,2,2,3]],[7,[1,2]],[11,[1,2,2,3]],[15,[1,2,2,3]],[19,[1,2]],
     [23,[1,2,2,3]],[27,[1,2,2,3]],[31,[1,2]],[35,[1,2,2,3]],
     [39,[1,2,2,3]]]],
 [19488,[[0,[1]],[9,[1]],[13,[1]],[21,[1]],[25,[1]],[33,[1]],[37,[1]],
     [45,[1]],[49,[1]],[57,[1]]]],
 [19489,[[4,[1]],[5,[1]],[9,[1]],[16,[1]],[17,[1]],[21,[1]],[28,[1]],
     [29,[1]],[33,[1]],[40,[1]]]],[19490,[[4,fail]]],
 [19491,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [19492,[[0,[1]],[4,[1]],[9,[1]],[13,[1]],[16,[1]],[21,[1]],[25,[1]],
     [28,[1]],[33,[1]],[37,[1]]]],
 [19496,[[3,[1]],[11,[1]],[19,[1]],[27,[1]],[35,[1]],[43,[1]],[51,[1]],
     [59,[1]],[67,[1]],[75,[1]]]],
 [19497,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],[19498,[[0,fail]]],
 [19499,[[0,fail]]],[19500,[[3,fail]]],
 [19501,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [19503,[[4,[1]],[13,[1]],[21,[1]],[29,[1]],[37,[1]],[45,[1]],[53,[1]],
     [61,[1]],[69,[1]],[77,[1]]]],[19505,[[3,fail]]],[19506,[[0,fail]]],
 [19507,[[0,fail]]],
 [19510,[[3,[1,2]],[7,[2,3]],[11,[1,2]],[15,[1,2]],[19,[2,3]],[23,[1,2]],
     [27,[1,2]],[31,[2,3]],[35,[1,2]],[39,[1,2]]]],
 [19511,[[1,[1]],[5,[1]],[13,[1]],[17,[1]],[25,[1]],[29,[1]],[37,[1]],
     [41,[1]],[49,[1]],[53,[1]]]],
 [19514,[[1,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [19516,[[0,[1]],[5,[1]],[9,[1]],[12,[1]],[17,[1]],[21,[1]],[24,[1]],
     [29,[1]],[33,[1]],[36,[1]]]],
 [19517,[[1,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],[19518,[[0,[1,2]],[7,fail]]],
 [19519,[[0,[1]],[1,[1]],[9,[1]],[12,[1]],[13,[1]],[21,[1]],[24,[1]],
     [25,[1]],[33,[1]],[36,[1]]]],
 [19523,[[1,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],
 [19524,[[0,[1]],[11,[1]],[19,[1]],[27,[1]],[35,[1]],[43,[1]],[51,[1]],
     [59,[1]],[67,[1]],[75,[1]]]],[19525,[[0,fail]]],[19526,[[0,fail]]],
 [19527,[[0,fail]]],
 [19529,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [19530,[[0,[1]],[9,[1]],[17,[1]],[25,[1]],[33,[1]],[41,[1]],[49,[1]],
     [57,[1]],[65,[1]],[73,[1]]]],[19532,[[0,fail]]],[19533,[[0,fail]]],
 [19534,[[0,fail]]],
 [19538,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [19540,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19542,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [19543,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19544,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19553,[[8,fail]]],[19558,[[8,fail]]],
 [19565,[[4,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [19568,[[3,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [19569,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [19586,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19587,[[5,fail]]],
 [19589,[[7,[3]],[19,[3]],[31,[3]],[43,[3]],[55,[3]],[67,[3]],[79,[3]],
     [91,[3]],[103,[3]],[115,[3]]]],
 [19590,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19594,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19596,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [19597,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [19598,[[7,[1,2,2,3]],[15,[1,2]],[23,[1,2,2,3]],[31,[1,2,2,3]],
     [39,[1,2]],[47,[1,2,2,3]],[55,[1,2,2,3]],[63,[1,2]],[71,[1,2,2,3]],
     [79,[1,2,2,3]]]],
 [19599,[[7,[1]],[15,[1]],[23,[1]],[31,[1]],[39,[1]],[47,[1]],[55,[1]],
     [63,[1]],[71,[1]],[79,[1]]]],
 [19600,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19601,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19603,[[5,[1]],[13,[1]],[21,[1]],[29,[1]],[37,[1]],[45,[1]],[53,[1]],
     [61,[1]],[69,[1]],[77,[1]]]],
 [19604,[[5,[1,2]],[13,[2,3]],[21,[1,2]],[29,[1,2]],[37,[2,3]],
     [45,[1,2]],[53,[1,2]],[61,[2,3]],[69,[1,2]],[77,[1,2]]]],
 [19605,[[8,fail]]],[19606,[[8,[1,2]],[20,fail]]],
 [19608,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19609,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19610,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [19612,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19615,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],
     [64,[2,3]],[76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [19616,[[0,[2,3]],[12,[2,3]],[24,[2,3]],[36,[2,3]],[48,[2,3]],
     [60,[2,3]],[72,[2,3]],[84,[2,3]],[96,[2,3]],[108,[2,3]]]],
 [19623,[[8,fail]]],[19631,[[8,fail]]],[19634,[[3,fail]]],
 [19635,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [19636,[[3,[3]],[5,[1,2]],[9,[3]],[11,[1,2]],[15,[3]],[17,[1,2]],
     [21,[3]],[23,[1,2]],[27,[3]],[29,[1,2]]]],
 [19637,[[3,[1,2,2,3]],[7,[1,2]],[11,[1,2,2,3]],[15,[1,2,2,3]],[19,[1,2]],
     [23,[1,2,2,3]],[27,[1,2,2,3]],[31,[1,2]],[35,[1,2,2,3]],
     [39,[1,2,2,3]]]],
 [19638,[[0,[1,2,2,3]],[5,[1,2]],[9,[1,2,2,3]],[13,[1,2,2,3]],[17,[1,2]],
     [21,[1,2,2,3]],[25,[1,2,2,3]],[29,[1,2]],[33,[1,2,2,3]],
     [37,[1,2,2,3]]]],
 [19639,[[0,[1,2]],[3,[3]],[7,[1,2]],[9,[3]],[13,[1,2]],[15,[3]],
     [19,[1,2]],[21,[3]],[25,[1,2]],[27,[3]]]],
 [19643,[[7,[1]],[15,[1]],[23,[1]],[31,[1]],[39,[1]],[47,[1]],[55,[1]],
     [63,[1]],[71,[1]],[79,[1]]]],[19645,[[0,fail]]],[19646,[[0,fail]]],
 [19647,[[3,fail]]],
 [19648,[[5,[1]],[13,[1]],[21,[1]],[29,[1]],[37,[1]],[45,[1]],[53,[1]],
     [61,[1]],[69,[1]],[77,[1]]]],
 [19650,[[3,[1,2]],[7,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],[23,[1,2]],
     [27,[1,2]],[31,[1,2]],[35,[1,2]],[39,[1,2]]]],
 [19651,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[17,[1,2]],[21,[1,2]],
     [25,[1,2]],[29,[1,2]],[33,[1,2]],[37,[1,2]]]],[19652,[[3,fail]]],
 [19653,[[0,fail]]],[19654,[[0,fail]]],
 [19677,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19678,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [19681,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [19682,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [19684,[[7,[1]],[15,[1]],[23,[1]],[31,[1]],[39,[1]],[47,[1]],[55,[1]],
     [63,[1]],[71,[1]],[79,[1]]]],
 [19685,[[7,[1,2,2,3]],[15,[1,2]],[23,[1,2,2,3]],[31,[1,2,2,3]],
     [39,[1,2]],[47,[1,2,2,3]],[55,[1,2,2,3]],[63,[1,2]],[71,[1,2,2,3]],
     [79,[1,2,2,3]]]],
 [19686,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19688,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19689,[[4,[1,2,2,3]],[13,[1,2]],[21,[1,2,2,3]],[29,[1,2,2,3]],
     [37,[1,2]],[45,[1,2,2,3]],[53,[1,2,2,3]],[61,[1,2]],[69,[1,2,2,3]],
     [77,[1,2,2,3]]]],
 [19690,[[1,[1]],[13,[1]],[21,[1]],[29,[1]],[37,[1]],[45,[1]],[53,[1]],
     [61,[1]],[69,[1]],[77,[1]]]],[19691,[[8,fail]]],[19692,[[8,fail]]],
 [19693,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19694,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [19697,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19698,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19699,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],[19706,[[8,fail]]],
 [19714,[[8,fail]]],
 [19715,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19716,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19718,[[8,fail]]],
 [19726,[[9,[1]],[17,[1]],[33,[1]],[41,[1]],[57,[1]],[65,[1]],[81,[1]],
     [89,[1]],[105,[1]],[113,[1]]]],
 [19728,[[4,[1,2]],[9,[1,2]],[17,[1,2]],[21,[1,2]],[29,[1,2]],[33,[1,2]],
     [41,[1,2]],[45,[1,2]],[53,[1,2]],[57,[1,2]]]],
 [19734,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19735,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [19737,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [19738,[[3,[1]],[11,[1]],[19,[1]],[27,[1]],[35,[1]],[43,[1]],[51,[1]],
     [59,[1]],[67,[1]],[75,[1]]]],[19739,[[4,[1,2]],[16,fail]]],
 [19741,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19742,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19743,[[4,fail]]],
 [19744,[[1,[1]],[9,[1]],[17,[1]],[25,[1]],[33,[1]],[41,[1]],[49,[1]],
     [57,[1]],[65,[1]],[73,[1]]]],
 [19745,[[4,[1,2,2,3]],[13,[1,2]],[21,[1,2,2,3]],[29,[1,2,2,3]],
     [37,[1,2]],[45,[1,2,2,3]],[53,[1,2,2,3]],[61,[1,2]],[69,[1,2,2,3]],
     [77,[1,2,2,3]]]],
 [19746,[[4,[1,2]],[15,[2,3]],[23,[1,2]],[31,[1,2]],[39,[2,3]],
     [47,[1,2]],[55,[1,2]],[63,[2,3]],[71,[1,2]],[79,[1,2]]]],
 [19747,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19749,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [19750,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19751,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [19753,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],[19754,[[0,fail]]],
 [19755,[[0,[1]],[11,[1]],[19,[1]],[27,[1]],[35,[1]],[43,[1]],[51,[1]],
     [59,[1]],[67,[1]],[75,[1]]]],
 [19757,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19758,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19759,[[0,[1]],[9,[1]],[17,[1]],[25,[1]],[33,[1]],[41,[1]],[49,[1]],
     [57,[1]],[65,[1]],[73,[1]]]],[19760,[[0,fail]]],
 [19761,[[0,[1,2]],[9,[2,3]],[17,[1,2]],[25,[1,2]],[33,[2,3]],[41,[1,2]],
     [49,[1,2]],[57,[2,3]],[65,[1,2]],[73,[1,2]]]],
 [19762,[[0,[1,2,2,3]],[11,[1,2]],[19,[1,2,2,3]],[27,[1,2,2,3]],
     [35,[1,2]],[43,[1,2,2,3]],[51,[1,2,2,3]],[59,[1,2]],[67,[1,2,2,3]],
     [75,[1,2,2,3]]]],
 [19763,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19765,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [19768,[[8,fail]]],
 [19775,[[1,[1]],[9,[1]],[25,[1]],[33,[1]],[49,[1]],[57,[1]],[73,[1]],
     [81,[1]],[97,[1]],[105,[1]]]],
 [19776,[[0,[1,2]],[9,[1,2]],[13,[1,2]],[21,[1,2]],[25,[1,2]],[33,[1,2]],
     [37,[1,2]],[45,[1,2]],[49,[1,2]],[57,[1,2]]]],[19783,[[0,fail]]],
 [19784,[[0,fail]]],[19788,[[4,fail]]],[19789,[[0,fail]]],[19790,[[4,fail]]],
 [19791,[[0,fail]]],[19796,[[0,fail]]],[19797,[[4,fail]]],[19801,[[0,fail]]],
 [19802,[[0,fail]]],[19803,[[0,fail]]],[19804,[[4,fail]]],[19808,[[0,fail]]],
 [19809,[[0,fail]]],[19813,[[0,fail]]],[19814,[[0,fail]]],[19815,[[0,fail]]],
 [19816,[[0,fail]]],
 [19902,[[0,[1,1,1,2]],[5,[1,2]],[9,[1,1,1,2]],[13,[1,1,1,2]],[17,[1,2]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[29,[1,2]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [19903,[[0,[1]],[2,[1]],[9,[1]],[13,[1]],[14,[1]],[21,[1]],[25,[1]],
     [26,[1]],[33,[1]],[37,[1]]]],
 [19917,[[0,[1,1,1,2]],[5,[1,2]],[9,[1,1,1,2]],[13,[1,1,1,2]],[17,[1,2]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[29,[1,2]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [19918,[[0,[1,1,1,2]],[5,[1]],[9,[1,1,1,2]],[13,[1,1,1,2]],[17,[1]],
     [21,[1,1,1,2]],[25,[1,1,1,2]],[29,[1]],[33,[1,1,1,2]],
     [37,[1,1,1,2]]]],
 [19919,[[0,[1]],[5,[1]],[6,[1]],[13,[1]],[17,[1]],[18,[1]],[25,[1]],
     [29,[1]],[30,[1]],[37,[1]]]],
 [19926,[[0,[1,2,2]],[5,[1]],[6,[1,2,2]],[13,[1,2,2]],[17,[1]],
     [18,[1,2,2]],[25,[1,2,2]],[29,[1]],[30,[1,2,2]],[37,[1,2,2]]]],
 [19933,[[0,[1,1,1,2]],[5,[1]],[6,[1,1,1,2]],[13,[1,1,1,2]],
     [14,[1,1,1,2]],[17,[1]],[22,[1,1,1,2]],[25,[1,1,1,2]],[29,[1]],
     [30,[1,1,1,2]]]],
 [19934,[[0,[1]],[2,[1,2]],[9,[1]],[10,[1,2]],[13,[1]],[18,[1,2]],
     [21,[1]],[25,[1]],[26,[1,2]],[33,[1]]]],
 [19935,[[0,[1,1,1,2]],[5,[1]],[9,[1,1,1,2]],[10,[1,1,1,2]],[17,[1]],
     [18,[1,1,1,2]],[21,[1,1,1,2]],[26,[1,1,1,2]],[29,[1]],
     [33,[1,1,1,2]]]],
 [19954,[[2,[2]],[6,[1]],[7,[1]],[10,[2]],[14,[2]],[18,[1]],[19,[1]],
     [22,[2]],[26,[2]],[30,[1]]]],
 [19957,[[2,[2]],[6,[1]],[7,[1]],[10,[2]],[14,[2]],[18,[1]],[19,[1]],
     [22,[2]],[26,[2]],[30,[1]]]],
 [19972,[[2,[1]],[3,[1]],[6,[2]],[10,[1]],[11,[1]],[14,[1]],[15,[1]],
     [18,[2]],[22,[1]],[23,[1]]]],
 [20054,[[5,[1,2]],[15,[1,2]],[17,[1,2]],[25,[1,2]],[35,[1,2]],
     [37,[1,2]],[45,[1,2]],[55,[1,2]],[57,[1,2]],[65,[1,2]]]],
 [20055,[[5,[1,2]],[15,[1,2]],[17,[1,2]],[25,[1,2]],[35,[1,2]],
     [37,[1,2]],[45,[1,2]],[55,[1,2]],[57,[1,2]],[65,[1,2]]]],
 [20056,[[13,[1]],[33,[1]],[53,[1]],[73,[1]],[93,[1]],[113,[1]],
     [133,[1]],[153,[1]],[173,[1]],[193,[1]]]],
 [20057,[[5,[1]],[11,[2]],[15,[1]],[25,[1]],[31,[2]],[35,[1]],[45,[1]],
     [51,[2]],[55,[1]],[65,[1]]]],
 [20058,[[5,[1,2]],[11,[2]],[15,[1,2]],[25,[1,2]],[31,[2]],[35,[1,2]],
     [45,[1,2]],[51,[2]],[55,[1,2]],[65,[1,2]]]],
 [20059,[[5,[1]],[10,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[33,[1]],
     [38,[1]],[45,[1]],[50,[1]]]],
 [20060,[[13,[1]],[33,[1]],[53,[1]],[73,[1]],[93,[1]],[113,[1]],
     [133,[1]],[153,[1]],[173,[1]],[193,[1]]]],
 [20061,[[10,[2]],[15,[2]],[30,[2]],[35,[2]],[50,[2]],[55,[2]],[70,[2]],
     [75,[2]],[90,[2]],[95,[2]]]],
 [20062,[[10,[2]],[15,[1,1,2]],[30,[2]],[35,[1,1,2]],[50,[2]],
     [55,[1,1,2]],[70,[2]],[75,[1,1,2]],[90,[2]],[95,[1,1,2]]]],
 [20063,[[13,[1,1,1,2]],[27,[1,1,1,2]],[33,[4]],[57,[1,1,1,2]],
     [73,[1,1,1,2]],[87,[1,1,1,2]],[93,[4]],[117,[1,1,1,2]],
     [133,[1,1,1,2]],[147,[1,1,1,2]]]],
 [20064,[[5,[1,1,1,2,1,1,2,2]],[13,[1]],[21,[1,1,1,2,1,1,2,2]],[33,[1]],
     [35,[1,1,1,2,1,1,2,2]],[45,[1,1,1,2,1,1,2,2]],[53,[1]],
     [57,[1,1,1,2,1,1,2,2]],[65,[1,1,1,2,1,1,2,2]],[73,[1]]]],
 [20065,[[13,[1,1,2,2]],[33,[4]],[51,[1,1,2,2]],[73,[1,1,2,2]],[93,[4]],
     [111,[1,1,2,2]],[133,[1,1,2,2]],[153,[4]],[171,[1,1,2,2]],
     [193,[1,1,2,2]]]],
 [20066,[[13,[2,2,3,3]],[17,[1,2]],[47,[1,2]],[53,[2,2,3,3]],
     [73,[2,2,3,3]],[77,[1,2]],[107,[1,2]],[113,[2,2,3,3]],
     [133,[2,2,3,3]],[137,[1,2]]]],
 [20067,[[5,[1,1,1,2]],[15,[1]],[17,[1,2]],[21,[1,1,1,2]],[35,[1,1,1,2]],
     [45,[1]],[47,[1,2]],[51,[1,1,1,2]],[53,[1,1,1,2]],[65,[1,1,1,2]]]],
 [20069,[[13,[3,3,4,4]],[17,[1,2]],[47,[1,2]],[53,[3,3,4,4]],
     [73,[3,3,4,4]],[77,[1,2]],[107,[1,2]],[113,[3,3,4,4]],
     [133,[3,3,4,4]],[137,[1,2]]]],
 [20071,[[13,[1]],[33,[1]],[53,[1]],[73,[1]],[93,[1]],[113,[1]],
     [133,[1]],[153,[1]],[173,[1]],[193,[1]]]],
 [20072,[[13,[2]],[31,[2]],[53,[2]],[73,[2]],[91,[2]],[113,[2]],
     [133,[2]],[151,[2]],[173,[2]],[193,[2]]]],
 [20073,[[5,[1,1,1,2]],[31,[2]],[35,[1,1,1,2]],[38,[1,1,1,2]],
     [53,[1,1,1,2]],[65,[1,1,1,2]],[91,[2]],[95,[1,1,1,2]],
     [98,[1,1,1,2]],[113,[1,1,1,2]]]],
 [20074,[[5,[2,3,4]],[33,[1]],[35,[2,3,4]],[38,[2,3,4]],[53,[2,3,4]],
     [65,[2,3,4]],[93,[1]],[95,[2,3,4]],[98,[2,3,4]],[113,[2,3,4]]]],
 [20075,[[13,[2,2,2,3]],[15,[2,2,2,3]],[33,[1]],[45,[2,2,2,3]],
     [55,[2,2,2,3]],[73,[2,2,2,3]],[75,[2,2,2,3]],[93,[1]],
     [105,[2,2,2,3]],[115,[2,2,2,3]]]],
 [20076,[[7,[1,1,2,2]],[27,[1,1,2,2]],[33,[4]],[37,[1,1,2,2]],
     [57,[1,1,2,2]],[67,[1,1,2,2]],[87,[1,1,2,2]],[93,[4]],
     [97,[1,1,2,2]],[117,[1,1,2,2]]]],
 [20082,[[7,[1,2]],[15,[1,2]],[33,[1]],[37,[1,2]],[45,[1,2]],[58,[1,2]],
     [67,[1,2]],[75,[1,2]],[93,[1]],[97,[1,2]]]],
 [20083,[[13,[1]],[15,[1]],[33,[1,2]],[45,[1]],[58,[1]],[73,[1]],
     [75,[1]],[93,[1,2]],[105,[1]],[118,[1]]]],
 [20084,[[13,[1,1,2,2]],[30,[2]],[53,[1,1,2,2]],[73,[1,1,2,2]],[90,[2]],
     [113,[1,1,2,2]],[133,[1,1,2,2]],[150,[2]],[173,[1,1,2,2]],
     [193,[1,1,2,2]]]],
 [20086,[[13,[1,2,3,2]],[30,[2]],[53,[1,2,3,2]],[73,[1,2,3,2]],[90,[2]],
     [113,[1,2,3,2]],[133,[1,2,3,2]],[150,[2]],[173,[1,2,3,2]],
     [193,[1,2,3,2]]]],
 [20087,[[13,[1,2,2]],[15,[1,2,2]],[33,[1]],[45,[1,2,2]],[58,[1,2,2]],
     [73,[1,2,2]],[75,[1,2,2]],[93,[1]],[105,[1,2,2]],[118,[1,2,2]]]],
 [20088,[[13,[2,3,5,3]],[25,[2,3,5,3]],[33,[1]],[55,[2,3,5,3]],
     [73,[2,3,5,3]],[85,[2,3,5,3]],[93,[1]],[115,[2,3,5,3]],
     [133,[2,3,5,3]],[145,[2,3,5,3]]]],
 [20090,[[6,[1,2,2,2]],[18,[1,2,2,2]],[25,[1,2,2,2]],[33,[4]],
     [51,[1,2,2,2]],[55,[1,2,2,2]],[66,[1,2,2,2]],[78,[1,2,2,2]],
     [85,[1,2,2,2]],[93,[4]]]],
 [20091,[[7,[2,3]],[13,[2,2,2,3]],[37,[2,3]],[42,[2,3]],[53,[2,2,2,3]],
     [67,[2,3]],[73,[2,2,2,3]],[97,[2,3]],[102,[2,3]],[113,[2,2,2,3]]]],
 [20098,[[13,[1]],[22,[1,2]],[53,[1]],[62,[1,2]],[73,[1]],[102,[1,2]],
     [113,[1]],[133,[1]],[142,[1,2]],[173,[1]]]],
 [20100,[[10,[2,2,2,3]],[38,[1,1,1,2]],[53,[2,2,2,3]],[58,[1,1,1,2]],
     [90,[2,2,2,3]],[93,[2]],[98,[1,1,1,2]],[118,[1,1,1,2]],
     [158,[1,1,1,2]],[170,[2,2,2,3]]]],
 [20108,[[5,[1]],[15,[1]],[17,[1]],[25,[1]],[35,[1]],[37,[1]],[45,[1]],
     [55,[1]],[57,[1]],[65,[1]]]],
 [20111,[[6,[1]],[26,[1]],[46,[1]],[66,[1]],[86,[1]],[106,[1]],
     [126,[1]],[146,[1]],[166,[1]],[186,[1]]]],
 [20112,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [20113,[[15,[2,2,3]],[35,[2,2,3]],[55,[2,2,3]],[75,[2,2,3]],[95,[2,2,3]],
     [115,[2,2,3]],[135,[2,2,3]],[155,[2,2,3]],[175,[2,2,3]],
     [195,[2,2,3]]]],
 [20114,[[15,[3,4]],[35,[3,4]],[55,[3,4]],[75,[3,4]],[95,[3,4]],
     [115,[3,4]],[135,[3,4]],[155,[3,4]],[175,[3,4]],[195,[3,4]]]],
 [20117,[[9,[1,1,1,1,1,1,2,2]],[17,[1,2]],[21,[1,1,1,1,1,1,2,2]],
     [25,[1,2]],[45,[1,1,1,1,1,1,2,2]],[55,[1,2]],[57,[1,1,1,1,1,1,2,2]],
     [69,[1,1,1,1,1,1,2,2]],[77,[1,2]],[81,[1,1,1,1,1,1,2,2]]]],
 [20119,[[14,[1,1,1,1,1,2]],[22,[1,1,1,1,1,2]],[29,[1,1,1,1,1,2]],
     [59,[1,1,1,1,1,2]],[74,[1,1,1,1,1,2]],[82,[1,1,1,1,1,2]],
     [89,[1,1,1,1,1,2]],[119,[1,1,1,1,1,2]],[134,[1,1,1,1,1,2]],
     [142,[1,1,1,1,1,2]]]],
 [20120,[[17,[1]],[25,[1]],[55,[1]],[77,[1]],[85,[1]],[115,[1]],
     [137,[1]],[145,[1]],[175,[1]],[197,[1]]]],
 [20121,[[2,[1,2,3,2,2,2,2,3]],[14,[1,2,3,2,2,2,2,3]],[15,[1,2,3,2,2,2,2,3]]
      ,[26,[1]],[37,[1,2,3,2,2,2,2,3]],[45,[1,2,3,2,2,2,2,3]],
     [57,[1,2,3,2,2,2,2,3]],[62,[1,2,3,2,2,2,2,3]],[74,[1,2,3,2,2,2,2,3]],
     [75,[1,2,3,2,2,2,2,3]]]],
 [20122,[[5,[1,1,2,2]],[17,[1,2]],[22,[1,1,2,2]],[25,[1,2]],
     [29,[1,1,2,2]],[35,[1,1,2,2]],[37,[1,1,2,2]],[55,[1,2]],
     [59,[1,1,2,2]],[65,[1,1,2,2]]]],
 [20123,[[11,[1,2,1,2,2]],[14,[1,2,1,2,2]],[29,[1,2,1,2,2]],
     [41,[1,2,1,2,2]],[59,[1,2,1,2,2]],[71,[1,2,1,2,2]],[74,[1,2,1,2,2]],
     [89,[1,2,1,2,2]],[101,[1,2,1,2,2]],[119,[1,2,1,2,2]]]],
 [20131,[[10,[3]],[21,[3]],[51,[3]],[70,[3]],[81,[3]],[111,[3]],
     [130,[3]],[141,[3]],[171,[3]],[190,[3]]]],
 [20134,[[5,[1,1,1,1,2,2,2,3]],[17,[1,1,1,1,2,2,2,3]],[30,[1]],
     [35,[1,1,1,1,2,2,2,3]],[42,[1,1,1,1,2,2,2,3]],[54,[1,1,1,1,2,2,2,3]],
     [65,[1,1,1,1,2,2,2,3]],[77,[1,1,1,1,2,2,2,3]],[90,[1]],
     [95,[1,1,1,1,2,2,2,3]]]],
 [20144,[[5,[3]],[35,[3]],[37,[3]],[42,[3]],[65,[3]],[95,[3]],[97,[3]],
     [102,[3]],[125,[3]],[155,[3]]]],
 [20145,[[0,[1,1,1,1,2,2,1,2,1,2,2]],[30,[1,1,1,1,2,2,1,2,1,2,2]],
     [31,[1,1,1,1,2,2,1,2,1,2,2]],[37,[1,1,1,1,2,2,1,2,1,2,2]],
     [42,[1,1,1,1,2,2,1,2,1,2,2]],[61,[1,1,1,1,2,2,1,2,1,2,2]],
     [90,[1,1,1,1,2,2,1,2,1,2,2]],[91,[1,1,1,1,2,2,1,2,1,2,2]],
     [97,[1,1,1,1,2,2,1,2,1,2,2]],[102,[1,1,1,1,2,2,1,2,1,2,2]]]],
 [20161,[[6,[2,2,3]],[26,[2,2,3]],[46,[2,2,3]],[66,[2,2,3]],[86,[2,2,3]],
     [106,[2,2,3]],[126,[2,2,3]],[146,[2,2,3]],[166,[2,2,3]],
     [186,[2,2,3]]]],
 [20163,[[6,[3,4]],[26,[3,4]],[46,[3,4]],[66,[3,4]],[86,[3,4]],
     [106,[3,4]],[126,[3,4]],[146,[3,4]],[166,[3,4]],[186,[3,4]]]],
 [20164,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [20166,[[15,[1]],[35,[1]],[55,[1]],[75,[1]],[95,[1]],[115,[1]],
     [135,[1]],[155,[1]],[175,[1]],[195,[1]]]],
 [20169,[[7,[1,1,2,2,2,1,2,3]],[13,[1,1,2,2,2,1,2,3]],[17,[1,2]],
     [43,[1,1,2,2,2,1,2,3]],[45,[1,1,2,2,2,1,2,3]],[47,[1,2]],
     [57,[1,1,2,2,2,1,2,3]],[67,[1,1,2,2,2,1,2,3]],[73,[1,1,2,2,2,1,2,3]],
     [77,[1,2]]]],
 [20171,[[17,[1]],[26,[1,2,2]],[47,[1]],[77,[1]],[86,[1,2,2]],[107,[1]],
     [137,[1]],[146,[1,2,2]],[167,[1]],[197,[1]]]],
 [20173,[[2,[1,1,1,1,1,2,2,3]],[7,[1,1,1,1,1,2,2,3]],[26,[2,3]],
     [33,[1,1,1,1,1,2,2,3]],[37,[1,1,1,1,1,2,2,3]],[38,[1,1,1,1,1,2,2,3]],
     [50,[1,1,1,1,1,2,2,3]],[63,[1,1,1,1,1,2,2,3]],[67,[1,1,1,1,1,2,2,3]],
     [86,[2,3]]]],
 [20174,[[5,[3,4]],[11,[3,4]],[17,[2]],[23,[3,4]],[35,[3,4]],[41,[3,4]],
     [47,[2]],[50,[3,4]],[53,[3,4]],[65,[3,4]]]],
 [20175,[[17,[1,2]],[26,[1,2]],[47,[1,2]],[77,[1,2]],[86,[1,2]],
     [107,[1,2]],[137,[1,2]],[146,[1,2]],[167,[1,2]],[197,[1,2]]]],
 [20186,[[6,[1,1,2,2,3,3,1,2]],[17,[1,1,2,2,3,3,1,2]],[23,[1,1,2,2,3,3,1,2]]
      ,[27,[1,1,2,2,3,3,1,2]],[30,[1]],[53,[1,1,2,2,3,3,1,2]],
     [57,[1,1,2,2,3,3,1,2]],[66,[1,1,2,2,3,3,1,2]],[77,[1,1,2,2,3,3,1,2]],
     [83,[1,1,2,2,3,3,1,2]]]],
 [20189,[[13,[1,2,2]],[43,[1,2,2]],[73,[1,2,2]],[103,[1,2,2]],
     [133,[1,2,2]],[163,[1,2,2]],[193,[1,2,2]],[223,[1,2,2]],
     [253,[1,2,2]]]],
 [20193,[[13,[1,1,1,2]],[43,[1,1,1,2]],[73,[1,1,1,2]],[103,[1,1,1,2]],
     [133,[1,1,1,2]],[163,[1,1,1,2]],[193,[1,1,1,2]],[223,[1,1,1,2]],
     [253,[1,1,1,2]]]],
 [20203,[[13,[1]],[23,[1]],[43,[1]],[53,[1]],[73,[1]],[83,[1]],
     [103,[1]],[113,[1]],[133,[1]],[143,[1]]]],
 [20205,[[6,[1,1,1,2]],[26,[1,1,1,2]],[27,[1,1,1,2]],[46,[1,1,1,2]],
     [57,[1,1,1,2]],[66,[1,1,1,2]],[86,[1,1,1,2]],[87,[1,1,1,2]],
     [106,[1,1,1,2]],[117,[1,1,1,2]]]],
 [20214,[[6,[3,4]],[26,[3,4]],[46,[3,4]],[66,[3,4]],[86,[3,4]],
     [106,[3,4]],[126,[3,4]],[146,[3,4]],[166,[3,4]],[186,[3,4]]]],
 [20215,[[5,[1,2]],[9,[1,2]],[19,[1,2]],[25,[1,2]],[29,[1,2]],[39,[1,2]],
     [45,[1,2]],[49,[1,2]],[59,[1,2]],[65,[1,2]]]],
 [20216,[[5,[1]],[9,[1]],[19,[1]],[25,[1]],[29,[1]],[39,[1]],[45,[1]],
     [49,[1]],[59,[1]],[65,[1]]]],
 [20217,[[15,[1]],[35,[1]],[55,[1]],[75,[1]],[95,[1]],[115,[1]],
     [135,[1]],[155,[1]],[175,[1]],[195,[1]]]],
 [20220,[[9,[1,1,1,1,2,2,2,3]],[21,[1,1,1,1,2,2,2,3]],[29,[1,1,1,1,2,2,2,3]]
      ,[33,[1]],[45,[1,1,1,1,2,2,2,3]],[59,[1,1,1,1,2,2,2,3]],
     [69,[1,1,1,1,2,2,2,3]],[81,[1,1,1,1,2,2,2,3]],[89,[1,1,1,1,2,2,2,3]],
     [93,[1]]]],
 [20221,[[26,[2,3,3]],[86,[2,3,3]],[146,[2,3,3]],[206,[2,3,3]]]],
 [20224,[[0,[1,2,2,2,2,2,2,2]],[9,[1,2,2,2,2,2,2,2]],[26,[3]],
     [38,[1,2,2,2,2,2,2,2]],[39,[1,2,2,2,2,2,2,2]],[50,[1,2,2,2,2,2,2,2]],
     [61,[1,2,2,2,2,2,2,2]],[69,[1,2,2,2,2,2,2,2]],[86,[3]],
     [98,[1,2,2,2,2,2,2,2]]]],
 [20227,[[5,[1,1,1,1,1,2]],[35,[1,1,1,1,1,2]],[41,[1,1,1,1,1,2]],
     [49,[1,1,1,1,1,2]],[65,[1,1,1,1,1,2]],[95,[1,1,1,1,1,2]],
     [101,[1,1,1,1,1,2]],[109,[1,1,1,1,1,2]],[125,[1,1,1,1,1,2]],
     [155,[1,1,1,1,1,2]]]],
 [20230,[[5,[1,1,2,2]],[9,[1,2]],[26,[1,1,2,2]],[29,[1,1,2,2]],
     [35,[1,1,2,2]],[39,[1,2]],[41,[1,1,2,2]],[46,[1,2]],[59,[1,1,2,2]],
     [65,[1,1,2,2]]]],
 [20231,[[19,[1,2,2]],[49,[1,2,2]],[79,[1,2,2]],[109,[1,2,2]],
     [139,[1,2,2]],[169,[1,2,2]],[199,[1,2,2]],[229,[1,2,2]]]],
 [20232,[[9,[1,2]],[39,[1,2]],[46,[1,2]],[69,[1,2]],[99,[1,2]],
     [106,[1,2]],[129,[1,2]],[159,[1,2]],[166,[1,2]],[189,[1,2]]]],
 [20237,[[6,[1,1,1,1,1,1,2,2]],[9,[1,2]],[18,[1,1,1,1,1,1,2,2]],[39,[1,2]],
     [41,[1,1,1,1,1,1,2,2]],[46,[1,2]],[54,[1,1,1,1,1,1,2,2]],
     [66,[1,1,1,1,1,1,2,2]],[69,[1,2]],[78,[1,1,1,1,1,1,2,2]]]],
 [20238,[[9,[1]],[39,[1]],[46,[1]],[69,[1]],[99,[1]],[106,[1]],
     [129,[1]],[159,[1]],[166,[1]],[189,[1]]]],
 [20243,[[5,[1,2,1,2,2]],[23,[1,2,1,2,2]],[35,[1,2,1,2,2]],
     [49,[1,2,1,2,2]],[53,[1,2,1,2,2]],[65,[1,2,1,2,2]],[83,[1,2,1,2,2]],
     [95,[1,2,1,2,2]],[109,[1,2,1,2,2]],[113,[1,2,1,2,2]]]],
 [20244,[[19,[2,3,5,3]],[49,[2,3,5,3]],[79,[2,3,5,3]],[109,[2,3,5,3]],
     [139,[2,3,5,3]],[169,[2,3,5,3]],[199,[2,3,5,3]],[229,[2,3,5,3]]]],
 [20245,[[3,[2,2,3,3]],[9,[3,5,4,4]],[21,[2,2,3,3]],[26,[4,4,6,6]],
     [29,[4,4,6,6]],[30,[1,2]],[33,[2,2,3,3]],[39,[3,5,4,4]],[45,[1,2]],
     [59,[4,4,6,6]]]],
 [20246,[[6,[5]],[19,[5]],[30,[1]],[39,[5]],[45,[1]],[49,[5]],[66,[5]],
     [79,[5]],[90,[1]],[99,[5]]]],
 [20248,[[3,[4,4,5]],[18,[4,4,5]],[19,[4,4,5]],[25,[4,4,5]],[26,[4,4,5]],
     [49,[4,4,5]],[55,[4,4,5]],[63,[4,4,5]],[78,[4,4,5]],[79,[4,4,5]]]],
 [20264,[[5,[1,2]],[11,[1,1,2]],[15,[1,2]],[25,[1,2]],[31,[1,1,2]],
     [35,[1,2]],[45,[1,2]],[51,[1,1,2]],[55,[1,2]],[65,[1,2]]]],
 [20265,[[9,[1]],[10,[2]],[19,[1]],[29,[1]],[30,[2]],[39,[1]],[49,[1]],
     [50,[2]],[59,[1]],[69,[1]]]],
 [20267,[[9,[1,2]],[10,[1,1,2]],[19,[1,2]],[29,[1,2]],[30,[1,1,2]],
     [39,[1,2]],[49,[1,2]],[50,[1,1,2]],[59,[1,2]],[69,[1,2]]]],
 [20269,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [20270,[[9,[1,1,2,2,1,2,1,2]],[21,[1,1,2,2,1,2,1,2]],[25,[1,1,2,2,1,2,1,2]]
      ,[29,[1,1,2,2,1,2,1,2]],[31,[2]],[55,[1,1,2,2,1,2,1,2]],
     [59,[1,1,2,2,1,2,1,2]],[69,[1,1,2,2,1,2,1,2]],[81,[1,1,2,2,1,2,1,2]],
     [85,[1,1,2,2,1,2,1,2]]]],
 [20274,[[2,[1,1,1,2,2,2,2,2]],[14,[1,1,1,2,2,2,2,2]],[15,[1,2]],
     [19,[1,1,1,2,2,2,2,2]],[45,[1,2]],[49,[1,1,1,2,2,2,2,2]],
     [50,[1,1,1,2,2,2,2,2]],[62,[1,1,1,2,2,2,2,2]],[74,[1,1,1,2,2,2,2,2]],
     [75,[1,2]]]],
 [20275,[[5,[1,2,2,2,2]],[11,[1,2,2,2,2]],[19,[1,2,2,2,2]],
     [29,[1,2,2,2,2]],[35,[1,2,2,2,2]],[41,[1,2,2,2,2]],[49,[1,2,2,2,2]],
     [59,[1,2,2,2,2]],[65,[1,2,2,2,2]],[71,[1,2,2,2,2]]]],
 [20279,[[31,[1,1,2]],[91,[1,1,2]],[151,[1,1,2]],[211,[1,1,2]]]],
 [20280,[[5,[1,2,2,2,2]],[15,[1,2,2,2,2]],[21,[1,2,2,2,2]],
     [29,[1,2,2,2,2]],[35,[1,2,2,2,2]],[45,[1,2,2,2,2]],[51,[1,2,2,2,2]],
     [59,[1,2,2,2,2]],[65,[1,2,2,2,2]],[75,[1,2,2,2,2]]]],
 [20282,[[10,[1,2]],[21,[1,2]],[27,[1,2]],[57,[1,2]],[70,[1,2]],
     [81,[1,2]],[87,[1,2]],[117,[1,2]],[130,[1,2]],[141,[1,2]]]],
 [20284,[[0,[1]],[10,[1,1,2]],[15,[1]],[19,[1]],[25,[1,1,2]],[31,[1]],
     [34,[1]],[45,[1]],[49,[1]],[55,[1,1,2]]]],[20286,[[5,fail]]],
 [20287,[[5,[1,1,2,2,1,2,1,2]],[9,[1,1,2,2,1,2,1,2]],[30,[2]],
     [35,[1,1,2,2,1,2,1,2]],[39,[1,1,2,2,1,2,1,2]],[41,[1,1,2,2,1,2,1,2]],
     [54,[1,1,2,2,1,2,1,2]],[65,[1,1,2,2,1,2,1,2]],[69,[1,1,2,2,1,2,1,2]],
     [90,[2]]]],
 [20290,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [20297,[[5,[1,2,2,2]],[19,[1,2,2,2]],[30,[1,1,1,2]],[35,[1,2,2,2]],
     [49,[1,2,2,2]],[65,[1,2,2,2]],[79,[1,2,2,2]],[90,[1,1,1,2]],
     [95,[1,2,2,2]],[109,[1,2,2,2]]]],
 [20305,[[9,[1]],[19,[1]],[39,[1]],[49,[1]],[69,[1]],[79,[1]],[99,[1]],
     [109,[1]],[129,[1]],[139,[1]]]],
 [20314,[[5,[2]],[10,[2]],[25,[2]],[30,[2]],[45,[2]],[50,[2]],[65,[2]],
     [70,[2]],[85,[2]],[90,[2]]]],
 [20315,[[6,[1]],[26,[1]],[46,[1]],[66,[1]],[86,[1]],[106,[1]],
     [126,[1]],[146,[1]],[166,[1]],[186,[1]]]],
 [20316,[[6,[1]],[10,[1]],[11,[1]],[15,[1]],[26,[1]],[30,[1]],[31,[1]],
     [35,[1]],[46,[1]],[50,[1]]]],
 [20317,[[5,[2]],[10,[1,1,2]],[25,[2]],[30,[1,1,2]],[45,[2]],
     [50,[1,1,2]],[65,[2]],[70,[1,1,2]],[85,[2]],[90,[1,1,2]]]],
 [20318,[[6,[1,1,2,2]],[15,[1,2]],[45,[1,2]],[46,[1,1,2,2]],
     [66,[1,1,2,2]],[75,[1,2]],[105,[1,2]],[106,[1,1,2,2]],
     [126,[1,1,2,2]],[135,[1,2]]]],
 [20320,[[6,[2,2,4,4]],[26,[2]],[46,[2,2,4,4]],[66,[2,2,4,4]],[86,[2]],
     [106,[2,2,4,4]],[126,[2,2,4,4]],[146,[2]],[166,[2,2,4,4]],
     [186,[2,2,4,4]]]],
 [20321,[[5,[1,1,1,2]],[26,[2]],[35,[1,1,1,2]],[46,[1,1,1,2]],
     [65,[1,1,1,2]],[86,[2]],[95,[1,1,1,2]],[106,[1,1,1,2]],
     [125,[1,1,1,2]],[146,[2]]]],
 [20322,[[6,[2]],[15,[1,2]],[23,[2]],[45,[1,2]],[53,[2]],[66,[2]],
     [75,[1,2]],[83,[2]],[105,[1,2]],[113,[2]]]],
 [20324,[[5,[3,3,5,5]],[26,[3,4]],[35,[3,3,5,5]],[46,[3,3,5,5]],
     [65,[3,3,5,5]],[86,[3,4]],[95,[3,3,5,5]],[106,[3,3,5,5]],
     [125,[3,3,5,5]],[146,[3,4]]]],
 [20325,[[5,[1,1,1,2]],[23,[1,1,1,2]],[26,[2,3]],[35,[1,1,1,2]],
     [53,[1,1,1,2]],[65,[1,1,1,2]],[83,[1,1,1,2]],[86,[2,3]],
     [95,[1,1,1,2]],[113,[1,1,1,2]]]],
 [20326,[[6,[3]],[25,[2]],[46,[3]],[66,[3]],[85,[2]],[106,[3]],
     [126,[3]],[145,[2]],[166,[3]],[186,[3]]]],
 [20327,[[6,[3]],[26,[1]],[31,[1,1,2]],[46,[3]],[66,[3]],[86,[1]],
     [91,[1,1,2]],[106,[3]],[126,[3]],[146,[1]]]],
 [20328,[[6,[2,2,3,4]],[26,[1]],[27,[2,2,3,4]],[57,[2,2,3,4]],
     [66,[2,2,3,4]],[86,[1]],[87,[2,2,3,4]],[117,[2,2,3,4]],
     [126,[2,2,3,4]],[146,[1]]]],
 [20330,[[6,[2,2,3,3]],[25,[2]],[46,[2,2,3,3]],[66,[2,2,3,3]],[85,[2]],
     [106,[2,2,3,3]],[126,[2,2,3,3]],[145,[2]],[166,[2,2,3,3]],
     [186,[2,2,3,3]]]],
 [20331,[[6,[1,1,2,3]],[13,[1,2]],[43,[1,2]],[46,[1,1,2,3]],
     [66,[1,1,2,3]],[73,[1,2]],[103,[1,2]],[106,[1,1,2,3]],
     [126,[1,1,2,3]],[133,[1,2]]]],
 [20337,[[5,[1,1,1,2]],[13,[2,3]],[35,[1,1,1,2]],[43,[2,3]],
     [46,[1,1,1,2]],[65,[1,1,1,2]],[73,[2,3]],[95,[1,1,1,2]],[103,[2,3]],
     [106,[1,1,1,2]]]],
 [20338,[[0,[1,1,1,2]],[26,[1]],[31,[1,1,1,2]],[33,[1,1,1,2]],
     [46,[1,1,1,2]],[63,[1,1,1,2]],[86,[1]],[91,[1,1,1,2]],
     [93,[1,1,1,2]],[106,[1,1,1,2]]]],
 [20339,[[6,[1]],[26,[1]],[30,[1]],[31,[1]],[46,[1]],[66,[1]],[86,[1]],
     [90,[1]],[91,[1]],[106,[1]]]],
 [20341,[[6,[2,3,4,3]],[26,[1]],[30,[1,1,2]],[42,[2,3,4,3]],
     [66,[2,3,4,3]],[86,[1]],[90,[1,1,2]],[102,[2,3,4,3]],
     [126,[2,3,4,3]],[146,[1]]]],
 [20342,[[5,[3,3,3,5]],[25,[3,4]],[35,[3,3,3,5]],[46,[3,3,3,5]],
     [65,[3,3,3,5]],[85,[3,4]],[95,[3,3,3,5]],[106,[3,3,3,5]],
     [125,[3,3,3,5]],[145,[3,4]]]],
 [20343,[[6,[2,2,2,3]],[13,[2,3]],[25,[2,2,2,3]],[43,[2,3]],
     [55,[2,2,2,3]],[66,[2,2,2,3]],[73,[2,3]],[85,[2,2,2,3]],[103,[2,3]],
     [115,[2,2,2,3]]]],
 [20346,[[6,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[25,[1,2,2]],[26,[1]],
     [30,[1,2,2]],[37,[1,2,2]],[42,[1,2,2]],[43,[1,2,2]],[55,[1,2,2]]]],
 [20347,[[6,[2,2,4,3]],[7,[2]],[37,[2]],[42,[2]],[46,[2,2,4,3]],
     [66,[2,2,4,3]],[67,[2]],[97,[2]],[102,[2]],[106,[2,2,4,3]]]],
 [20354,[[6,[2,3]],[31,[1]],[46,[2,3]],[51,[1]],[58,[2,4]],[91,[1]],
     [111,[1]],[126,[2,3]],[138,[2,4]],[151,[1]]]],
 [20355,[[6,[1,2,2,2,1,2,2,2,1,2,2,3]],[22,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [26,[1]],[62,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [71,[1,2,2,2,1,2,2,2,1,2,2,3]],[86,[1]],
     [102,[1,2,2,2,1,2,2,2,1,2,2,3]],[111,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [126,[1,2,2,2,1,2,2,2,1,2,2,3]],[146,[1]]]],
 [20363,[[5,[1,2]],[9,[1,2]],[19,[1,2]],[25,[1,2]],[29,[1,2]],[39,[1,2]],
     [45,[1,2]],[49,[1,2]],[59,[1,2]],[65,[1,2]]]],
 [20364,[[9,[1,2]],[10,[2]],[19,[1,2]],[29,[1,2]],[30,[2]],[39,[1,2]],
     [49,[1,2]],[50,[2]],[59,[1,2]],[69,[1,2]]]],
 [20365,[[5,[1,1,2]],[10,[2]],[25,[1,1,2]],[30,[2]],[45,[1,1,2]],
     [50,[2]],[65,[1,1,2]],[70,[2]],[85,[1,1,2]],[90,[2]]]],
 [20366,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [20368,[[9,[2,3,4,3]],[30,[1]],[50,[2,3,4,3]],[69,[2,3,4,3]],[90,[1]],
     [110,[2,3,4,3]],[129,[2,3,4,3]],[150,[1]],[170,[2,3,4,3]],
     [189,[2,3,4,3]]]],
 [20369,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [20370,[[5,[1,2]],[19,[1,2]],[27,[1,2]],[30,[1]],[49,[1,2]],[57,[1,2]],
     [65,[1,2]],[79,[1,2]],[87,[1,2]],[90,[1]]]],
 [20372,[[10,[2,3,4]],[25,[2,3,4]],[29,[2,3,4]],[30,[1]],[59,[2,3,4]],
     [70,[2,3,4]],[85,[2,3,4]],[89,[2,3,4]],[90,[1]],[119,[2,3,4]]]],
 [20373,[[5,[1,2,2]],[19,[1,2,2]],[30,[1]],[49,[1,2,2]],[50,[1,2,2]],
     [65,[1,2,2]],[79,[1,2,2]],[90,[1]],[109,[1,2,2]],[110,[1,2,2]]]],
 [20374,[[10,[2,2,3,3]],[17,[1,2]],[47,[1,2]],[49,[2,2,3,3]],
     [70,[2,2,3,3]],[77,[1,2]],[107,[1,2]],[109,[2,2,3,3]],
     [130,[2,2,3,3]],[137,[1,2]]]],
 [20375,[[10,[2]],[30,[2]],[49,[2]],[70,[2]],[90,[2]],[109,[2]],
     [130,[2]],[150,[2]],[169,[2]],[190,[2]]]],
 [20376,[[7,[1,1,2,2]],[30,[2]],[50,[1,1,2,2]],[67,[1,1,2,2]],[90,[2]],
     [110,[1,1,2,2]],[127,[1,1,2,2]],[150,[2]],[170,[1,1,2,2]],
     [187,[1,1,2,2]]]],
 [20377,[[10,[3,3,4,4]],[17,[1,2]],[47,[1,2]],[50,[3,3,4,4]],
     [70,[3,3,4,4]],[77,[1,2]],[107,[1,2]],[110,[3,3,4,4]],
     [130,[3,3,4,4]],[137,[1,2]]]],
 [20378,[[7,[1,1,2,2]],[19,[2,3]],[25,[1,1,2]],[49,[2,3]],[50,[1,1,2,2]],
     [67,[1,1,2,2]],[79,[2,3]],[85,[1,1,2]],[109,[2,3]],[110,[1,1,2,2]]] 
  ],
 [20379,[[9,[1,1,2]],[10,[1,1,2]],[13,[1,1,2]],[30,[1,2]],[39,[1,1,2]],
     [43,[1,1,2]],[45,[1,1,2]],[58,[1,1,2]],[69,[1,1,2]],[70,[1,1,2]]]],
 [20381,[[3,[4,5,6,5]],[30,[2,3]],[33,[4,5,6,5]],[34,[4,5,6,5]],
     [45,[4,5,6,5]],[63,[4,5,6,5]],[90,[2,3]],[93,[4,5,6,5]],
     [94,[4,5,6,5]],[105,[4,5,6,5]]]],
 [20384,[[5,[1,1,1,2,1,1,2,2]],[10,[1]],[18,[1,1,1,2,1,1,2,2]],
     [29,[1,1,1,2,1,1,2,2]],[30,[1]],[42,[1,1,1,2,1,1,2,2]],[50,[1]],
     [59,[1,1,1,2,1,1,2,2]],[65,[1,1,1,2,1,1,2,2]],[70,[1]]]],
 [20385,[[10,[1,1,1,2]],[13,[1,1,1,2]],[17,[1,2]],[19,[1]],[29,[1,1,1,2]],
     [43,[1,1,1,2]],[47,[1,2]],[49,[1]],[59,[1,1,1,2]],[70,[1,1,1,2]]]],
 [20386,[[9,[1]],[10,[1,1,1,2]],[39,[1]],[45,[1]],[50,[1,1,1,2]],
     [69,[1]],[70,[1,1,1,2]],[99,[1]],[105,[1]],[110,[1,1,1,2]]]],
 [20387,[[10,[1,1,1,2]],[25,[1,1,1,2]],[29,[1,1,1,2]],[30,[2]],
     [59,[1,1,1,2]],[70,[1,1,1,2]],[85,[1,1,1,2]],[89,[1,1,1,2]],
     [90,[2]],[119,[1,1,1,2]]]],
 [20389,[[5,[1,2,3,2]],[30,[2]],[49,[1,2,3,2]],[65,[1,2,3,2]],[90,[2]],
     [109,[1,2,3,2]],[125,[1,2,3,2]],[150,[2]],[169,[1,2,3,2]],
     [185,[1,2,3,2]]]],
 [20393,[[9,[3]],[13,[3]],[30,[1,2]],[43,[3]],[54,[3]],[69,[3]],
     [73,[3]],[90,[1,2]],[103,[3]],[114,[3]]]],
 [20395,[[3,[1,2,2,2]],[7,[1,2,2,2]],[25,[1,2,2,2]],[27,[1,2,2,2]],
     [30,[3,4]],[33,[1,2,2,2]],[37,[1,2,2,2]],[42,[1,2,2,2]],
     [57,[1,2,2,2]],[63,[1,2,2,2]]]],
 [20401,[[5,[1,1,1,2]],[25,[1,1,1,2]],[30,[2]],[65,[1,1,1,2]],
     [70,[2,2,2,3]],[74,[2,2,2,3]],[85,[1,1,1,2]],[125,[1,1,1,2]],
     [145,[1,1,1,2]],[150,[2]]]],
 [20402,[[2,[1,2,2,2,1,2,2,2,1,2,2,3]],[30,[1]],
     [42,[1,2,2,2,1,2,2,2,1,2,2,3]],[45,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [82,[1,2,2,2,1,2,2,2,1,2,2,3]],[85,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [90,[1]],[110,[1,2,2,2,1,2,2,2,1,2,2,3]],[150,[1]],
     [162,[1,2,2,2,1,2,2,2,1,2,2,3]]]],
 [20403,[[10,[1]],[22,[1,2]],[50,[1]],[62,[1,2]],[70,[1]],[102,[1,2]],
     [110,[1]],[130,[1]],[142,[1,2]],[170,[1]]]],
 [20411,[[15,[3,4]],[35,[3,4]],[55,[3,4]],[75,[3,4]],[95,[3,4]],
     [115,[3,4]],[135,[3,4]],[155,[3,4]],[175,[3,4]],[195,[3,4]]]],
 [20414,[[5,[1,1,2,2,3,3,1,2]],[11,[1,1,2,2,3,3,1,2]],[33,[1]],
     [35,[1,1,2,2,3,3,1,2]],[41,[1,1,2,2,3,3,1,2]],[45,[1,1,2,2,3,3,1,2]],
     [55,[1,1,2,2,3,3,1,2]],[65,[1,1,2,2,3,3,1,2]],[71,[1,1,2,2,3,3,1,2]],
     [93,[1]]]],
 [20418,[[0,[1,1,2,3,2,2,2,2]],[14,[1,1,2,3,2,2,2,2]],[25,[1,1,2,3,2,2,2,2]]
      ,[26,[1]],[31,[1,1,2,3,2,2,2,2]],[38,[1,1,2,3,2,2,2,2]],
     [55,[1,1,2,3,2,2,2,2]],[61,[1,1,2,3,2,2,2,2]],[74,[1,1,2,3,2,2,2,2]],
     [85,[1,1,2,3,2,2,2,2]]]],
 [20421,[[15,[1]],[35,[1,2,2]],[45,[1]],[75,[1]],[95,[1,2,2]],[105,[1]],
     [135,[1]],[155,[1,2,2]],[165,[1]],[195,[1]]]],
 [20423,[[21,[1,2,2]],[51,[1,2,2]],[81,[1,2,2]],[111,[1,2,2]],
     [141,[1,2,2]],[171,[1,2,2]],[201,[1,2,2]],[231,[1,2,2]]]],
 [20424,[[11,[3,4]],[14,[3,4]],[15,[2]],[23,[3,4]],[29,[3,4]],[41,[3,4]],
     [45,[2]],[53,[3,4]],[59,[3,4]],[71,[3,4]]]],
 [20431,[[5,[1,1,2,2,2,1,2,3]],[15,[1,2]],[18,[1,1,2,2,2,1,2,3]],
     [21,[1,1,2,2,2,1,2,3]],[45,[1,2]],[51,[1,1,2,2,2,1,2,3]],
     [54,[1,1,2,2,2,1,2,3]],[65,[1,1,2,2,2,1,2,3]],[75,[1,2]],
     [78,[1,1,2,2,2,1,2,3]]]],
 [20437,[[15,[1,2]],[35,[1,2]],[45,[1,2]],[75,[1,2]],[95,[1,2]],
     [105,[1,2]],[135,[1,2]],[155,[1,2]],[165,[1,2]],[195,[1,2]]]],
 [20438,[[0,[1,2,1,2,2,2]],[21,[1,2,1,2,2,2]],[31,[1,2,1,2,2,2]],
     [51,[1,2,1,2,2,2]],[61,[1,2,1,2,2,2]],[81,[1,2,1,2,2,2]],
     [91,[1,2,1,2,2,2]],[111,[1,2,1,2,2,2]],[121,[1,2,1,2,2,2]],
     [141,[1,2,1,2,2,2]]]],
 [20440,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [20441,[[0,[1,1,1,1,1,1,2,2,3]],[13,[1,1,1,1,1,1,2,2,3]],
     [18,[1,1,1,1,1,1,2,2,3]],[31,[1,1,1,1,1,1,2,2,3]],
     [43,[1,1,1,1,1,1,2,2,3]],[54,[1,1,1,1,1,1,2,2,3]],
     [61,[1,1,1,1,1,1,2,2,3]],[73,[1,1,1,1,1,1,2,2,3]],
     [78,[1,1,1,1,1,1,2,2,3]],[91,[1,1,1,1,1,1,2,2,3]]]],
 [20448,[[5,[1,1,1,2]],[18,[1,1,1,2]],[35,[1,1,1,2]],[38,[1,1,1,2]],
     [58,[1,1,1,2]],[65,[1,1,1,2]],[78,[1,1,1,2]],[95,[1,1,1,2]],
     [98,[1,1,1,2]],[118,[1,1,1,2]]]],
 [20449,[[0,[1,2,2]],[6,[1,2,2]],[21,[1,2,2]],[25,[1,2,2]],[26,[1,2,2]],
     [31,[1,2,2]],[46,[1,2,2]],[51,[1,2,2]],[55,[1,2,2]],[61,[1,2,2]]]],
 [20450,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [20458,[[10,[1,1,2]],[15,[2]],[30,[1,1,2]],[35,[2]],[50,[1,1,2]],
     [55,[2]],[70,[1,1,2]],[75,[2]],[90,[1,1,2]],[95,[2]]]],
 [20459,[[15,[1,1,2,2]],[30,[3]],[55,[1,1,2,2]],[75,[1,1,2,2]],[90,[3]],
     [115,[1,1,2,2]],[135,[1,1,2,2]],[150,[3]],[175,[1,1,2,2]],
     [195,[1,1,2,2]]]],
 [20461,[[15,[1,1,2,2]],[30,[3]],[55,[1,1,2,2]],[75,[1,1,2,2]],[90,[3]],
     [115,[1,1,2,2]],[135,[1,1,2,2]],[150,[3]],[175,[1,1,2,2]],
     [195,[1,1,2,2]]]],
 [20462,[[11,[3]],[35,[2]],[50,[3]],[71,[3]],[95,[2]],[110,[3]],
     [131,[3]],[155,[2]],[170,[3]],[191,[3]]]],
 [20463,[[15,[1,1,1,2]],[21,[2,3]],[29,[1,1,1,2]],[51,[2,3]],
     [59,[1,1,1,2]],[75,[1,1,1,2]],[81,[2,3]],[89,[1,1,1,2]],[111,[2,3]],
     [119,[1,1,1,2]]]],
 [20466,[[11,[3,3,3,5]],[29,[3,3,3,5]],[35,[3,4]],[59,[3,3,3,5]],
     [71,[3,3,3,5]],[89,[3,3,3,5]],[95,[3,4]],[119,[3,3,3,5]],
     [131,[3,3,3,5]],[149,[3,3,3,5]]]],
 [20467,[[15,[1,1,1,2]],[29,[1,1,1,2]],[35,[2]],[59,[1,1,1,2]],
     [75,[1,1,1,2]],[89,[1,1,1,2]],[95,[2]],[119,[1,1,1,2]],
     [135,[1,1,1,2]],[149,[1,1,1,2]]]],
 [20468,[[10,[3]],[30,[1,1,2]],[35,[1]],[49,[3]],[70,[3]],[90,[1,1,2]],
     [95,[1]],[109,[3]],[130,[3]],[150,[1,1,2]]]],
 [20469,[[15,[1]],[30,[1]],[31,[1]],[35,[1]],[55,[1]],[75,[1]],[90,[1]],
     [91,[1]],[95,[1]],[115,[1]]]],
 [20470,[[11,[3,3,5,5]],[29,[3,3,5,5]],[35,[3,4]],[59,[3,3,5,5]],
     [71,[3,3,5,5]],[89,[3,3,5,5]],[95,[3,4]],[119,[3,3,5,5]],
     [131,[3,3,5,5]],[149,[3,3,5,5]]]],
 [20471,[[15,[1,1,2,2]],[31,[3]],[55,[1,1,2,2]],[75,[1,1,2,2]],[91,[3]],
     [115,[1,1,2,2]],[135,[1,1,2,2]],[151,[3]],[175,[1,1,2,2]],
     [195,[1,1,2,2]]]],
 [20472,[[15,[2,2,3,4]],[19,[3,4]],[49,[3,4]],[55,[2,2,3,4]],
     [75,[2,2,3,4]],[79,[3,4]],[109,[3,4]],[115,[2,2,3,4]],
     [135,[2,2,3,4]],[139,[3,4]]]],
 [20474,[[9,[7,8]],[15,[1,2,3,3]],[39,[7,8]],[46,[7,8]],[55,[1,2,3,3]],
     [69,[7,8]],[75,[1,2,3,3]],[99,[7,8]],[106,[7,8]],[115,[1,2,3,3]]]],
 [20478,[[11,[2]],[19,[1,2]],[41,[2]],[49,[1,2]],[55,[2]],[71,[2]],
     [79,[1,2]],[101,[2]],[109,[1,2]],[115,[2]]]],
 [20479,[[10,[1,1,1,2]],[21,[1,1,1,2]],[35,[1]],[51,[1,1,1,2]],
     [55,[1,1,1,2]],[70,[1,1,1,2]],[81,[1,1,1,2]],[95,[1]],
     [111,[1,1,1,2]],[115,[1,1,1,2]]]],
 [20480,[[7,[2,2,3,4]],[35,[1]],[37,[2,2,3,4]],[55,[2,2,3,4]],
     [67,[2,2,3,4]],[95,[1]],[97,[2,2,3,4]],[115,[2,2,3,4]],
     [127,[2,2,3,4]],[155,[1]]]],
 [20482,[[6,[2,3,4,3]],[30,[1,1,2]],[35,[1]],[49,[2,3,4,3]],
     [66,[2,3,4,3]],[90,[1,1,2]],[95,[1]],[109,[2,3,4,3]],
     [126,[2,3,4,3]],[150,[1,1,2]]]],
 [20483,[[11,[1,1,1,2]],[29,[1,1,1,2]],[35,[2,3]],[41,[1,1,1,2]],
     [59,[1,1,1,2]],[71,[1,1,1,2]],[89,[1,1,1,2]],[95,[2,3]],
     [101,[1,1,1,2]],[119,[1,1,1,2]]]],
 [20484,[[6,[1,1,2,3]],[19,[1,1,2,3]],[30,[3]],[49,[1,1,2,3]],
     [55,[1,1,2,3]],[66,[1,1,2,3]],[79,[1,1,2,3]],[90,[3]],
     [109,[1,1,2,3]],[115,[1,1,2,3]]]],
 [20494,[[10,[1,2,2,2,1,2,2,2,1,2,2,3]],[35,[1]],
     [50,[1,2,2,2,1,2,2,2,1,2,2,3]],[55,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [62,[1,2,2,2,1,2,2,2,1,2,2,3]],[95,[1]],
     [102,[1,2,2,2,1,2,2,2,1,2,2,3]],[130,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [142,[1,2,2,2,1,2,2,2,1,2,2,3]],[155,[1]]]],
 [20495,[[15,[1]],[22,[1,2]],[55,[1]],[62,[1,2]],[75,[1]],[102,[1,2]],
     [115,[1]],[135,[1]],[142,[1,2]],[175,[1]]]],
 [20505,[[5,[1,1,1,2,3,2,2,2]],[21,[1,1,1,2,3,2,2,2]],[30,[2]],
     [45,[1,1,1,2,3,2,2,2]],[57,[1,1,1,2,3,2,2,2]],[65,[1,1,1,2,3,2,2,2]],
     [81,[1,1,1,2,3,2,2,2]],[90,[2]],[105,[1,1,1,2,3,2,2,2]],
     [117,[1,1,1,2,3,2,2,2]]]],
 [20507,[[35,[1,1,2]],[95,[1,1,2]],[155,[1,1,2]],[215,[1,1,2]]]],
 [20509,[[2,[1,2,2,1,2,2,2,2]],[10,[1,2,2,1,2,2,2,2]],[25,[2]],
     [38,[1,2,2,1,2,2,2,2]],[50,[1,2,2,1,2,2,2,2]],[62,[1,2,2,1,2,2,2,2]],
     [70,[1,2,2,1,2,2,2,2]],[85,[2]],[98,[1,2,2,1,2,2,2,2]],
     [110,[1,2,2,1,2,2,2,2]]]],
 [20510,[[11,[4]],[41,[4]],[50,[4]],[71,[4]],[101,[4]],[110,[4]],
     [131,[4]],[161,[4]],[170,[4]],[191,[4]]]],
 [20511,[[35,[2,2,3,3]],[95,[2,2,3,3]],[155,[2,2,3,3]],[215,[2,2,3,3]]]],
 [20512,[[25,[1,1,2]],[85,[1,1,2]],[145,[1,1,2]],[205,[1,1,2]]]],
 [20514,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [20515,[[10,[4]],[21,[4]],[51,[4]],[70,[4]],[81,[4]],[111,[4]],
     [130,[4]],[141,[4]],[171,[4]],[190,[4]]]],
 [20519,[[0,[2,3,3]],[10,[1,1,2]],[15,[2,3,3]],[30,[1,1,2]],[31,[2,3,3]],
     [45,[2,3,3]],[46,[1,1,2]],[58,[1,1,2]],[61,[2,3,3]],[70,[1,1,2]]]],
 [20521,[[11,fail]]],
 [20522,[[6,[1,1,1,2,3,2,2,2]],[15,[1,1,1,2,3,2,2,2]],[30,[2]],
     [41,[1,1,1,2,3,2,2,2]],[50,[1,1,1,2,3,2,2,2]],[66,[1,1,1,2,3,2,2,2]],
     [75,[1,1,1,2,3,2,2,2]],[90,[2]],[101,[1,1,1,2,3,2,2,2]],
     [110,[1,1,1,2,3,2,2,2]]]],
 [20525,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [20528,[[25,[2,2,3,3]],[85,[2,2,3,3]],[145,[2,2,3,3]],[205,[2,2,3,3]]]],
 [20531,[[0,[1]],[31,[1]],[61,[1]],[91,[1]],[121,[1]],[151,[1]],
     [181,[1]],[211,[1]],[241,[1]]]],
 [20532,[[7,[3]],[37,[3]],[42,[3]],[67,[3]],[97,[3]],[102,[3]],
     [127,[3]],[157,[3]],[162,[3]],[187,[3]]]],
 [20549,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20550,[[9,[1,1,2]],[21,[1,1,2]],[33,[1,1,2]],[45,[1,1,2]],[57,[1,1,2]],
     [69,[1,1,2]],[81,[1,1,2]],[93,[1,1,2]],[105,[1,1,2]],[117,[1,1,2]]] 
  ],
 [20551,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [20552,[[2,[1]],[9,[1]],[15,[1]],[21,[1]],[27,[1]],[33,[1]],[39,[1]],
     [45,[1]],[51,[1]],[57,[1]]]],
 [20553,[[2,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [20562,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [20563,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20566,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20574,[[3,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [20575,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20578,[[2,[1]],[3,[2]],[6,[1]],[9,[2]],[10,[2]],[14,[1]],[15,[2]],
     [18,[1]],[21,[2]],[22,[2]]]],
 [20590,[[3,[2]],[9,[2]],[10,[1]],[15,[2]],[21,[2]],[22,[1]],[27,[2]],
     [33,[2]],[34,[1]],[39,[2]]]],
 [20593,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20594,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20595,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20596,[[2,[1]],[9,[1]],[14,[1]],[21,[1]],[26,[1]],[33,[1]],[38,[1]],
     [45,[1]],[50,[1]],[57,[1]]]],
 [20597,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20598,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20599,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20600,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [20601,[[7,[2]],[19,[2]],[31,[2]],[43,[2]],[55,[2]],[67,[2]],[79,[2]],
     [91,[2]],[103,[2]],[115,[2]]]],
 [20602,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20603,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20604,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20606,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20607,[[9,[2,3]],[21,[2,3]],[33,[2,3]],[45,[2,3]],[57,[2,3]],
     [69,[2,3]],[81,[2,3]],[93,[2,3]],[105,[2,3]],[117,[2,3]]]],
 [20609,[[6,[1]],[9,[1]],[18,[1]],[21,[1]],[30,[1]],[33,[1]],[42,[1]],
     [45,[1]],[54,[1]],[57,[1]]]],
 [20610,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20611,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [20612,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [20613,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[117,[1,2]]]],
 [20614,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [20615,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20616,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20618,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20620,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20625,[[9,[1,2]],[21,[1,2]],[33,[1,2]],[45,[1,2]],[57,[1,2]],
     [69,[1,2]],[81,[1,2]],[93,[1,2]],[105,[1,2]],[107,[1,2]]]],
 [20627,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20628,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20629,[[9,[1]],[17,[1]],[33,[1]],[35,[1]],[41,[1]],[57,[1]],[71,[1]],
     [81,[1]],[89,[1]],[95,[1]]]],
 [20631,[[7,[1]],[19,[1]],[21,[1]],[43,[1]],[45,[1]],[55,[1]],[61,[1]],
     [69,[1]],[79,[1]],[93,[1]]]],
 [20632,[[9,[2]],[21,[2]],[33,[2]],[45,[2]],[57,[2]],[69,[2]],[81,[2]],
     [93,[2]],[105,[2]],[117,[2]]]],
 [20636,[[2,[1,1,2]],[14,[1,1,2]],[26,[1,1,2]],[38,[1,1,2]],[50,[1,1,2]],
     [62,[1,1,2]],[74,[1,1,2]],[86,[1,1,2]],[98,[1,1,2]],[110,[1,1,2]]]]
  ,
 [20638,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [20640,[[2,[1,1,1,2]],[14,[1,1,1,2]],[26,[1,1,1,2]],[38,[1,1,1,2]],
     [50,[1,1,1,2]],[62,[1,1,1,2]],[74,[1,1,1,2]],[86,[1,1,1,2]],
     [98,[1,1,1,2]],[110,[1,1,1,2]]]],
 [20646,[[9,[1]],[21,[1]],[33,[1]],[45,[1]],[57,[1]],[69,[1]],[81,[1]],
     [93,[1]],[105,[1]],[117,[1]]]],
 [20647,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [20648,[[0,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[13,[1,1,2]],[19,[1,1,2]],
     [22,[1,1,2]],[25,[1,1,2]],[31,[1,1,2]],[34,[1,1,2]],[37,[1,1,2]]]],
 [20649,[[7,fail]]],[20650,[[0,fail]]],
 [20651,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20659,[[3,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [20662,[[0,[2]],[6,[2]],[7,[2]],[13,[2]],[18,[2]],[19,[2]],[25,[2]],
     [30,[2]],[31,[2]],[37,[2]]]],
 [20663,[[2,[1]],[3,[2]],[6,[1]],[9,[2]],[10,[1]],[14,[1]],[15,[2]],
     [18,[1]],[21,[2]],[22,[1]]]],
 [20675,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [20678,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [20679,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [20680,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20687,[[0,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[13,[1,1,2]],[19,[1,1,2]],
     [22,[1,1,2]],[25,[1,1,2]],[31,[1,1,2]],[34,[1,1,2]],[37,[1,1,2]]]],
 [20688,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [20689,[[0,[1]],[2,[1]],[7,[1]],[10,[1]],[13,[1]],[14,[1]],[19,[1]],
     [22,[1]],[25,[1]],[26,[1]]]],
 [20692,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20700,[[2,[1]],[5,[1]],[6,[1]],[11,[1]],[14,[1]],[17,[1]],[18,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [20701,[[0,[2]],[6,[2]],[7,[2]],[13,[2]],[18,[2]],[19,[2]],[25,[2]],
     [30,[2]],[31,[2]],[37,[2]]]],
 [20703,[[0,[1,1,2]],[2,[1,1,2]],[6,[1,1,2]],[7,[1,1,2]],[13,[1,1,2]],
     [14,[1,1,2]],[18,[1,1,2]],[19,[1,1,2]],[25,[1,1,2]],[26,[1,1,2]]]],
 [20704,[[2,[2]],[5,[2]],[6,[1]],[10,[1]],[11,[2]],[14,[2]],[17,[2]],
     [18,[1]],[22,[1]],[23,[2]]]],
 [20716,[[2,[1]],[5,[2]],[11,[2]],[14,[1]],[17,[2]],[23,[2]],[26,[1]],
     [29,[2]],[35,[2]],[38,[1]]]],
 [20719,[[2,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [20720,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [20721,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20727,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20728,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [20729,[[0,[1]],[2,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],[20730,[[0,fail]]],[20731,[[0,fail]]],
 [20732,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20740,[[2,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [20744,[[2,[2]],[5,[2]],[6,[1]],[9,[2]],[11,[2]],[15,[2]],[17,[2]],
     [18,[1]],[21,[2]],[23,[2]]]],
 [20749,[[5,[1]],[6,[1]],[11,[1]],[17,[1]],[18,[1]],[23,[1]],[29,[1]],
     [30,[1]],[35,[1]],[41,[1]]]],
 [20750,[[2,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [20756,[[2,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [20757,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [20758,[[0,[1,2]],[2,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [20759,[[2,[3]],[14,[3]],[26,[3]],[38,[3]],[50,[3]],[62,[3]],[74,[3]],
     [86,[3]],[98,[3]],[110,[3]]]],
 [20760,[[2,[2,3]],[14,[2,3]],[26,[2,3]],[38,[2,3]],[50,[2,3]],
     [62,[2,3]],[74,[2,3]],[86,[2,3]],[98,[2,3]],[110,[2,3]]]],
 [20761,[[0,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [20762,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20763,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20764,[[0,[3]],[14,[3]],[26,[3]],[38,[3]],[50,[3]],[62,[3]],[74,[3]],
     [86,[3]],[98,[3]],[110,[3]]]],
 [20765,[[0,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [20766,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20767,[[0,[1]],[2,[1]],[7,[1]],[10,[1]],[13,[1]],[14,[1]],[19,[1]],
     [22,[1]],[25,[1]],[26,[1]]]],
 [20768,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20770,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],
     [62,[1,2]],[74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [20771,[[2,[1]],[6,[1]],[14,[1]],[18,[1]],[26,[1]],[30,[1]],[38,[1]],
     [42,[1]],[50,[1]],[54,[1]]]],
 [20772,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20773,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20774,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20775,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],
     [62,[1,2]],[74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [20776,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20777,[[0,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [20778,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [20779,[[2,[1]],[3,[1]],[6,[1]],[9,[1]],[14,[1]],[15,[1]],[18,[1]],
     [21,[1]],[26,[1]],[27,[1]]]],
 [20780,[[0,[2]],[6,[2]],[7,[2]],[13,[2]],[18,[2]],[19,[2]],[25,[2]],
     [30,[2]],[31,[2]],[37,[2]]]],
 [20781,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20782,[[0,[2]],[6,[2]],[7,[2]],[13,[2]],[18,[2]],[19,[2]],[25,[2]],
     [30,[2]],[31,[2]],[37,[2]]]],
 [20786,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],
     [57,[1,2]],[74,[1,2]],[86,[1,2]],[98,[1,2]],[110,[1,2]]]],
 [20788,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20790,[[0,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [20792,[[2,[1]],[14,[1]],[26,[1]],[27,[1]],[50,[1]],[51,[1]],[63,[1]],
     [69,[1]],[74,[1]],[87,[1]]]],
 [20793,[[2,[1]],[13,[1]],[26,[1]],[31,[1]],[37,[1]],[50,[1]],[67,[1]],
     [74,[1]],[85,[1]],[91,[1]]]],
 [20794,[[2,[1,2]],[14,[1,2]],[26,[1,2]],[38,[1,2]],[50,[1,2]],
     [62,[1,2]],[74,[1,2]],[86,[1,2]],[98,[1,2]],[103,[1,2]]]],
 [20798,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [20809,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20817,[[2,[1]],[5,[2]],[6,[1]],[11,[2]],[14,[1]],[17,[2]],[18,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [20821,[[2,[2]],[5,[3]],[6,[1]],[10,[1]],[11,[3]],[14,[2]],[17,[3]],
     [18,[1]],[22,[1]],[23,[3]]]],[20824,[[5,fail]]],
 [20833,[[2,[1]],[5,[3]],[11,[3]],[14,[1]],[17,[3]],[23,[3]],[26,[1]],
     [29,[3]],[35,[3]],[38,[1]]]],
 [20846,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [20854,[[2,[1]],[5,[1]],[6,[1]],[11,[1]],[14,[1]],[17,[1]],[18,[1]],
     [23,[1]],[26,[1]],[29,[1]]]],
 [20855,[[0,[1,2,2]],[6,[1,2,2]],[7,[1,2,2]],[13,[1,2,2]],[18,[1,2,2]],
     [19,[1,2,2]],[25,[1,2,2]],[30,[1,2,2]],[31,[1,2,2]],[37,[1,2,2]]]],
 [20856,[[0,[1,1,1,1,2]],[7,[1,1,1,1,2]],[13,[1,1,1,1,2]],[19,[1,1,1,1,2]],
     [25,[1,1,1,1,2]],[31,[1,1,1,1,2]],[37,[1,1,1,1,2]],[43,[1,1,1,1,2]],
     [49,[1,1,1,1,2]],[55,[1,1,1,1,2]]]],
 [20857,[[0,[1,1,1,2]],[2,[1,1,1,2]],[6,[1,1,1,2]],[7,[1,1,1,2]],
     [13,[1,1,1,2]],[14,[1,1,1,2]],[18,[1,1,1,2]],[19,[1,1,1,2]],
     [25,[1,1,1,2]],[26,[1,1,1,2]]]],
 [20858,[[2,[2]],[5,[3]],[6,[1]],[11,[3]],[14,[2]],[17,[3]],[18,[1]],
     [23,[3]],[26,[2]],[29,[3]]]],[20861,[[5,fail]]],
 [20863,[[5,[1]],[18,[1]],[23,[1]],[41,[1]],[42,[1]],[59,[1]],[66,[1]],
     [77,[1]],[90,[1]],[95,[1]]]],
 [20864,[[2,[2,3]],[6,[2,3]],[14,[2,3]],[18,[2,3]],[26,[2,3]],[30,[2,3]],
     [38,[2,3]],[42,[2,3]],[50,[2,3]],[54,[2,3]]]],
 [20870,[[2,[1]],[5,[2]],[11,[2]],[14,[1]],[17,[2]],[23,[2]],[26,[1]],
     [29,[2]],[35,[2]],[38,[1]]]],
 [20875,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20876,[[0,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [20877,[[3,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [27,[1,2]],[33,[1,2]],[34,[1,2]],[39,[1,2]]]],
 [20878,[[0,[1]],[5,[1]],[10,[1]],[11,[1]],[13,[1]],[17,[1]],[22,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [20879,[[0,[1,1,2]],[3,[1,1,2]],[9,[1,1,2]],[10,[1,1,2]],[13,[1,1,2]],
     [15,[1,1,2]],[21,[1,1,2]],[22,[1,1,2]],[25,[1,1,2]],[27,[1,1,2]]]],
 [20882,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20883,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [20889,[[0,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [20890,[[3,[1,2]],[6,[1,2]],[9,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [27,[1,2]],[30,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [20891,[[3,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [20893,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[13,[1]],[15,[1]],[18,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [20895,[[0,[2]],[5,[2]],[6,[1]],[10,[1]],[11,[2]],[13,[2]],[17,[2]],
     [18,[1]],[22,[1]],[23,[2]]]],
 [20907,[[0,[1]],[5,[2]],[11,[2]],[13,[1]],[17,[2]],[23,[2]],[25,[1]],
     [29,[2]],[35,[2]],[37,[1]]]],
 [20909,[[7,[1,1,2]],[19,[1,1,2]],[31,[1,1,2]],[43,[1,1,2]],[55,[1,1,2]],
     [67,[1,1,2]],[79,[1,1,2]],[91,[1,1,2]],[103,[1,1,2]],[115,[1,1,2]]] 
  ],[20916,[[5,fail]]],
 [20917,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [20920,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],[20921,[[5,fail]]],
 [20927,[[6,[1,1,1,2]],[18,[1,1,1,2]],[30,[1,1,1,2]],[42,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[78,[1,1,1,2]],[90,[1,1,1,2]],
     [102,[1,1,1,2]],[114,[1,1,1,2]]]],
 [20931,[[0,[2]],[2,[1]],[6,[1]],[7,[2]],[10,[1]],[13,[2]],[14,[1]],
     [18,[1]],[19,[2]],[22,[1]]]],
 [20943,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [20951,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [20954,[[6,[1]],[7,[1]],[18,[1]],[19,[1]],[30,[1]],[31,[1]],[42,[1]],
     [43,[1]],[54,[1]],[55,[1]]]],
 [20956,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [20965,[[0,[2]],[2,[1]],[6,[1]],[7,[2]],[9,[2]],[14,[1]],[15,[2]],
     [18,[1]],[19,[2]],[21,[2]]]],
 [20977,[[0,[2]],[7,[1]],[9,[2]],[15,[2]],[19,[1]],[21,[2]],[27,[2]],
     [31,[1]],[33,[2]],[39,[2]]]],
 [20979,[[3,[3]],[9,[3]],[10,[3]],[15,[3]],[21,[3]],[22,[3]],[27,[3]],
     [33,[3]],[34,[3]],[39,[3]]]],
 [20980,[[0,[1]],[5,[2]],[10,[1]],[11,[2]],[14,[1]],[17,[2]],[22,[1]],
     [23,[2]],[26,[1]],[29,[2]]]],
 [20984,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [20985,[[5,[2]],[11,[2]],[17,[2]],[23,[2]],[29,[2]],[35,[2]],[41,[2]],
     [47,[2]],[53,[2]],[59,[2]]]],
 [20990,[[5,[1]],[11,[1]],[17,[1]],[23,[1]],[29,[1]],[35,[1]],[41,[1]],
     [47,[1]],[53,[1]],[59,[1]]]],
 [20992,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [20993,[[3,[2]],[6,[1]],[9,[2]],[15,[2]],[18,[1]],[21,[2]],[27,[2]],
     [30,[1]],[33,[2]],[39,[2]]]],
 [20997,[[0,[2]],[5,[3]],[6,[1]],[10,[1]],[11,[3]],[14,[2]],[17,[3]],
     [18,[1]],[22,[1]],[23,[3]]]],[21006,[[5,fail]]],
 [21009,[[0,[1]],[5,[3]],[11,[3]],[14,[1]],[17,[3]],[23,[3]],[26,[1]],
     [29,[3]],[35,[3]],[38,[1]]]],
 [21012,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21013,[[3,[2]],[9,[2]],[10,[2]],[15,[2]],[21,[2]],[22,[2]],[27,[2]],
     [33,[2]],[34,[2]],[39,[2]]]],[21014,[[15,fail]]],
 [21016,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[21020,[[9,fail]]],
 [21022,[[0,[1,1,1,2]],[13,[1,1,1,2]],[25,[1,1,1,2]],[37,[1,1,1,2]],
     [49,[1,1,1,2]],[61,[1,1,1,2]],[73,[1,1,1,2]],[85,[1,1,1,2]],
     [97,[1,1,1,2]],[109,[1,1,1,2]]]],
 [21023,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [21024,[[3,[2]],[6,[2]],[9,[2]],[15,[2]],[18,[2]],[21,[2]],[27,[2]],
     [30,[2]],[33,[2]],[39,[2]]]],
 [21027,[[3,[1,1,2]],[6,[1,1,2]],[9,[1,1,2]],[15,[1,1,2]],[18,[1,1,2]],
     [21,[1,1,2]],[27,[1,1,2]],[30,[1,1,2]],[33,[1,1,2]],[39,[1,1,2]]]],
 [21029,[[0,[2]],[2,[1]],[6,[1]],[7,[2]],[10,[1]],[13,[2]],[14,[1]],
     [18,[1]],[19,[2]],[22,[1]]]],
 [21041,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [21043,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [21044,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [21047,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [21053,[[3,[1]],[9,[1]],[10,[1]],[15,[1]],[21,[1]],[22,[1]],[27,[1]],
     [33,[1]],[34,[1]],[39,[1]]]],
 [21055,[[3,[1,2]],[6,[1,2]],[9,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [27,[1,2]],[30,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [21056,[[6,[1]],[9,[1,1,2]],[18,[1]],[21,[1,1,2]],[30,[1]],[33,[1,1,2]],
     [42,[1]],[45,[1,1,2]],[54,[1]],[57,[1,1,2]]]],[21063,[[0,fail]]],
 [21066,[[6,[1,2]],[10,[1,2]],[18,[1,2]],[22,[1,2]],[30,[1,2]],
     [34,[1,2]],[42,[1,2]],[46,[1,2]],[54,[1,2]],[58,[1,2]]]],
 [21067,[[7,fail]]],
 [21071,[[3,[3]],[9,[3]],[10,[1,2]],[15,[3]],[21,[3]],[22,[1,2]],
     [27,[3]],[33,[3]],[34,[1,2]],[39,[3]]]],
 [21074,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [21075,[[0,[1,2]],[7,[1,2]],[10,[1,2]],[13,[1,2]],[19,[1,2]],[22,[1,2]],
     [25,[1,2]],[31,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [21078,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21079,[[0,[1,2]],[7,[1,2]],[10,[1,2]],[13,[1,2]],[19,[1,2]],[22,[1,2]],
     [25,[1,2]],[31,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [21080,[[0,[1,2]],[7,[1,2]],[10,[1,2]],[13,[1,2]],[19,[1,2]],[22,[1,2]],
     [25,[1,2]],[31,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [21083,[[0,[1]],[5,[1]],[10,[1]],[11,[1]],[13,[1]],[17,[1]],[22,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [21084,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21086,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [21088,[[0,[2]],[7,[2]],[10,[2]],[13,[2]],[19,[2]],[22,[2]],[25,[2]],
     [31,[2]],[34,[2]],[37,[2]]]],
 [21093,[[0,[1]],[5,[1]],[10,[1]],[13,[1]],[17,[1]],[19,[1]],[22,[1]],
     [25,[1]],[34,[1]],[37,[1]]]],
 [21095,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21096,[[0,[1]],[6,[1]],[10,[2]],[14,[1]],[18,[1]],[22,[2]],[26,[1]],
     [30,[1]],[34,[2]],[38,[1]]]],
 [21097,[[0,[1,2]],[7,[1,2]],[10,[1,2]],[11,[1,2]],[19,[1,2]],[22,[1,2]],
     [23,[1,2]],[25,[1,2]],[31,[1,2]],[34,[1,2]]]],
 [21100,[[0,[1]],[6,[1]],[10,[1]],[13,[2]],[22,[1]],[25,[3]],[31,[2]],
     [34,[1]],[46,[1]],[49,[10]]]],
 [21105,[[0,[7,8]],[7,[4,5]],[13,[13,14]],[19,[4,5]],[25,[7,8]],
     [31,[4,5]],[37,[10,11]],[43,[4,5]],[49,[7,8]],[55,[4,5]]]],
 [21106,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [21112,[[0,[1,1,1,2]],[3,[1,1,1,2]],[9,[1,1,1,2]],[10,[1,1,1,2]],
     [13,[1,1,1,2]],[15,[1,1,1,2]],[21,[1,1,1,2]],[22,[1,1,1,2]],
     [25,[1,1,1,2]],[27,[1,1,1,2]]]],
 [21114,[[3,[2]],[6,[2]],[9,[2]],[15,[2]],[18,[2]],[21,[2]],[27,[2]],
     [30,[2]],[33,[2]],[39,[2]]]],
 [21115,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21117,[[6,[1,1,2]],[9,[1,1,2]],[18,[1,1,2]],[21,[1,1,2]],[30,[1,1,2]],
     [33,[1,1,2]],[42,[1,1,2]],[45,[1,1,2]],[54,[1,1,2]],[57,[1,1,2]]]],
 [21122,[[0,fail]]],[21126,[[3,fail]]],
 [21133,[[0,[1,2]],[7,[1,2]],[13,[1,2]],[19,[1,2]],[25,[1,2]],[31,[1,2]],
     [37,[1,2]],[43,[1,2]],[49,[1,2]],[55,[1,2]]]],
 [21134,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [21135,[[3,fail]]],
 [21138,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [21142,[[3,[1,2]],[6,[1,2]],[9,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [27,[1,2]],[30,[1,2]],[33,[1,2]],[39,[1,2]]]],[21145,[[0,fail]]],
 [21151,[[0,fail]]],[21152,[[0,fail]]],[21153,[[3,fail]]],
 [21161,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [21165,[[5,[2,4]],[17,[2,4]],[29,[2,4]],[41,[2,4]],[53,[2,4]],
     [65,[2,4]],[77,[2,4]],[89,[2,4]],[101,[2,4]],[113,[2,4]]]],
 [21166,[[5,fail]]],[21170,[[0,fail]]],[21178,[[0,fail]]],[21179,[[0,fail]]],
 [21180,[[0,fail]]],
 [21188,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [21189,[[3,[1]],[9,[1]],[10,[1]],[15,[1]],[21,[1]],[22,[1]],[27,[1]],
     [33,[1]],[34,[1]],[39,[1]]]],
 [21190,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [21192,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [21193,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [21194,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [21195,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [21196,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [21197,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [21198,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [21202,[[6,[1]],[15,[1]],[30,[1]],[33,[1]],[39,[1]],[54,[1]],[69,[1]],
     [78,[1]],[87,[1]],[93,[1]]]],
 [21203,[[5,[1]],[17,[1]],[18,[1]],[41,[1]],[42,[1]],[53,[1]],[59,[1]],
     [66,[1]],[77,[1]],[90,[1]]]],
 [21204,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [21205,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [21207,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [59,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [21208,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],[21216,[[3,fail]]],
 [21218,[[5,[1,2]],[11,[1,2]],[17,[1,2]],[23,[1,2]],[29,[1,2]],
     [35,[1,2]],[41,[1,2]],[47,[1,2]],[53,[1,2]],[59,[1,2]]]],
 [21219,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [21220,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [21221,[[3,[1,2]],[9,[1,2]],[15,[1,2]],[21,[1,2]],[27,[1,2]],[33,[1,2]],
     [39,[1,2]],[45,[1,2]],[51,[1,2]],[57,[1,2]]]],
 [21223,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [21225,[[0,[2]],[5,[2]],[7,[2]],[10,[1]],[11,[2]],[13,[2]],[17,[2]],
     [19,[2]],[22,[1]],[23,[2]]]],
 [21230,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21231,[[5,[1]],[10,[1]],[11,[1]],[17,[1]],[22,[1]],[23,[1]],[29,[1]],
     [34,[1]],[35,[1]],[41,[1]]]],
 [21236,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [21237,[[0,[1]],[5,[1]],[7,[1]],[11,[1]],[13,[1]],[17,[1]],[19,[1]],
     [23,[1]],[25,[1]],[29,[1]]]],
 [21238,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [21239,[[0,[1]],[7,[1]],[10,[1]],[13,[1]],[19,[1]],[22,[1]],[25,[1]],
     [31,[1]],[34,[1]],[37,[1]]]],
 [21241,[[0,[1]],[7,[1]],[13,[1]],[19,[1]],[25,[1]],[31,[1]],[37,[1]],
     [43,[1]],[49,[1]],[55,[1]]]],
 [21244,[[3,[2]],[9,[2]],[10,[1]],[15,[2]],[21,[2]],[22,[1]],[27,[2]],
     [33,[2]],[34,[1]],[39,[2]]]],
 [21248,[[2,[1]],[3,[2]],[5,[1]],[9,[2]],[10,[2]],[11,[1]],[14,[1]],
     [15,[2]],[17,[1]],[21,[2]]]],
 [21250,[[0,[1]],[2,[1]],[3,[2]],[7,[1]],[9,[2]],[10,[2]],[13,[1]],
     [14,[1]],[15,[2]],[19,[1]]]],
 [21253,[[2,[1]],[10,[2]],[14,[1]],[22,[2]],[26,[1]],[34,[2]],[38,[1]],
     [46,[2]],[50,[1]],[58,[2]]]],
 [21260,[[3,[1]],[5,[1]],[9,[1]],[11,[1]],[15,[1]],[17,[1]],[21,[1]],
     [23,[1]],[27,[1]],[29,[1]]]],
 [21261,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [21262,[[0,[1]],[3,[1]],[7,[1]],[9,[1]],[13,[1]],[15,[1]],[19,[1]],
     [21,[1]],[25,[1]],[27,[1]]]],
 [21264,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [21273,[[0,[2]],[2,[1]],[6,[2]],[7,[2]],[10,[1]],[13,[2]],[14,[1]],
     [18,[2]],[19,[2]],[22,[1]]]],
 [21285,[[0,[2]],[6,[1]],[7,[2]],[13,[2]],[18,[1]],[19,[2]],[25,[2]],
     [30,[1]],[31,[2]],[37,[2]]]],[21286,[[5,fail]]],[21298,[[2,fail]]],
 [21299,[[2,fail]]],[21300,[[3,fail]]],
 [21316,[[0,[2]],[2,[1]],[6,[2]],[7,[2]],[13,[2]],[14,[1]],[18,[2]],
     [19,[2]],[25,[2]],[26,[1]]]],
 [21328,[[0,[2]],[7,[2]],[13,[2]],[19,[2]],[25,[2]],[31,[2]],[37,[2]],
     [43,[2]],[49,[2]],[55,[2]]]],
 [21330,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [21331,[[3,[3]],[9,[3]],[15,[3]],[21,[3]],[27,[3]],[33,[3]],[39,[3]],
     [45,[3]],[51,[3]],[57,[3]]]],
 [21335,[[0,[2]],[5,[3]],[10,[1]],[11,[3]],[13,[2]],[17,[3]],[22,[1]],
     [23,[3]],[25,[2]],[29,[3]]]],
 [21340,[[0,[2,3]],[10,[2,3]],[13,[2,3]],[22,[2,3]],[25,[2,3]],
     [34,[2,3]],[37,[2,3]],[46,[2,3]],[49,[2,3]],[58,[2,3]]]],
 [21341,[[10,[1]],[17,[1]],[34,[1]],[35,[1]],[53,[1]],[58,[1]],[71,[1]],
     [82,[1]],[89,[1]],[106,[1]]]],[21344,[[11,fail]]],
 [21347,[[0,[1]],[5,[2]],[11,[2]],[13,[1]],[17,[2]],[23,[2]],[25,[1]],
     [29,[2]],[35,[2]],[37,[1]]]],
 [21349,[[3,[2]],[6,[2]],[9,[2]],[15,[2]],[18,[2]],[21,[2]],[27,[2]],
     [30,[2]],[33,[2]],[39,[2]]]],
 [21352,[[3,[2]],[9,[2]],[15,[2]],[21,[2]],[27,[2]],[33,[2]],[39,[2]],
     [45,[2]],[51,[2]],[57,[2]]]],
 [21354,[[0,[2]],[2,[1]],[6,[2]],[7,[2]],[10,[1]],[13,[2]],[14,[1]],
     [18,[2]],[19,[2]],[22,[1]]]],
 [21366,[[0,[2]],[6,[1]],[7,[2]],[13,[2]],[18,[1]],[19,[2]],[25,[2]],
     [30,[1]],[31,[2]],[37,[2]]]],
 [21368,[[3,[1,2]],[6,[1,2]],[9,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [27,[1,2]],[30,[1,2]],[33,[1,2]],[39,[1,2]]]],
 [21370,[[3,[2]],[6,[2]],[9,[2]],[15,[2]],[18,[2]],[21,[2]],[27,[2]],
     [30,[2]],[33,[2]],[39,[2]]]],
 [21374,[[3,[1]],[6,[1]],[9,[2]],[18,[1]],[21,[5]],[30,[1]],[42,[1]],
     [45,[4]],[54,[1]],[57,[4]]]],
 [21375,[[2,[1]],[6,[1]],[9,[1]],[11,[1]],[18,[1]],[21,[1]],[27,[1]],
     [29,[1]],[30,[1]],[33,[1]]]],
 [21376,[[2,[1]],[6,[2]],[10,[1]],[14,[1]],[18,[2]],[22,[1]],[26,[1]],
     [30,[2]],[34,[1]],[38,[1]]]],
 [21377,[[3,[1]],[6,[1]],[9,[1]],[15,[1]],[18,[1]],[21,[1]],[27,[1]],
     [30,[1]],[33,[1]],[39,[1]]]],
 [21379,[[3,[1,2]],[6,[1,2]],[9,[1,2]],[15,[1,2]],[17,[1,2]],[18,[1,2]],
     [27,[1,2]],[30,[1,2]],[33,[1,2]],[35,[1,2]]]],
 [21387,[[0,[1,1,2]],[6,[1,1,2]],[7,[1,1,2]],[13,[1,1,2]],[18,[1,1,2]],
     [19,[1,1,2]],[25,[1,1,2]],[30,[1,1,2]],[31,[1,1,2]],[37,[1,1,2]]]],
 [21392,[[0,fail]]],
 [21395,[[6,[2]],[10,[1]],[18,[2]],[22,[1]],[30,[2]],[34,[1]],[42,[2]],
     [46,[1]],[54,[2]],[58,[1]]]],[21396,[[6,fail]]],
 [21400,[[3,[2,4]],[9,[2,4]],[15,[2,4]],[21,[2,4]],[27,[2,4]],[33,[2,4]],
     [39,[2,4]],[45,[2,4]],[51,[2,4]],[57,[2,4]]]],
 [21406,[[0,[3]],[2,[1]],[6,[3]],[7,[3]],[13,[3]],[14,[1]],[18,[3]],
     [19,[3]],[25,[3]],[26,[1]]]],
 [21411,[[0,[1]],[6,[2]],[14,[1]],[18,[2]],[26,[1]],[30,[2]],[38,[1]],
     [42,[2]],[50,[1]],[54,[2]]]],
 [21418,[[0,[2]],[6,[1]],[7,[2]],[13,[2]],[18,[1]],[19,[2]],[25,[2]],
     [30,[1]],[31,[2]],[37,[2]]]],[21423,[[0,fail]]],[21427,[[3,fail]]],
 [21436,[[2,[4]],[3,[1]],[5,[1]],[6,[11]],[9,[2]],[14,[2]],[17,[1]],
     [18,[7]],[21,[3]],[23,[6]]]],
 [21437,[[2,[3]],[6,[6]],[9,[1]],[10,[3]],[11,[7]],[18,[2]],[21,[1]],
     [22,[3]],[27,[7]],[29,[2]]]],
 [21438,[[2,[2]],[5,[1]],[6,[2]],[10,[2]],[11,[1]],[14,[2]],[17,[1]],
     [18,[2]],[22,[2]],[23,[1]]]],
 [21439,[[2,[2]],[3,[1]],[6,[2]],[9,[1]],[10,[2]],[14,[2]],[15,[1]],
     [18,[2]],[21,[1]],[22,[2]]]],
 [21452,[[0,[1]],[2,[2]],[6,[2]],[7,[1]],[10,[2]],[13,[1]],[14,[2]],
     [18,[2]],[19,[1]],[22,[2]]]],
 [21453,[[0,[2]],[5,[1]],[6,[2]],[10,[2]],[11,[1]],[14,[2]],[17,[1]],
     [18,[2]],[22,[2]],[23,[1]]]],
 [21454,[[0,[4]],[5,[1]],[6,[8]],[7,[1]],[10,[6]],[11,[2]],[18,[9]],
     [19,[1]],[22,[5]],[23,[3]]]],
 [21456,[[0,[1]],[2,[2]],[5,[6]],[10,[3]],[11,[1]],[13,[4]],[14,[3]],
     [22,[5]],[23,[1]],[26,[6]]]],
 [21461,[[0,[1]],[2,[2]],[3,[1]],[6,[3]],[7,[4]],[13,[1]],[14,[4]],
     [15,[8]],[18,[2]],[25,[1]]]],
 [21463,[[0,[1]],[2,[2]],[6,[2]],[7,[1]],[10,[2]],[13,[1]],[14,[2]],
     [18,[2]],[19,[1]],[22,[2]]]],
 [21465,[[0,[2]],[3,[1]],[6,[2]],[9,[1]],[10,[2]],[14,[2]],[15,[1]],
     [18,[2]],[21,[1]],[22,[2]]]],
 [21469,[[0,[2]],[2,[6]],[9,[1]],[10,[2]],[13,[3]],[14,[6]],[15,[6]],
     [21,[1]],[22,[8]],[26,[2]]]],
 [21500,[[2,[1]],[5,[1]],[6,[1]],[10,[1]],[11,[1]],[14,[1]],[17,[1]],
     [18,[1]],[22,[1]],[23,[1]]]],
 [21501,[[0,[1,2]],[5,[1,2]],[7,[1,2]],[11,[1,2]],[13,[1,2]],[17,[1,2]],
     [19,[1,2]],[23,[1,2]],[25,[1,2]],[29,[1,2]]]],
 [21502,[[0,[1]],[2,[1]],[6,[1]],[7,[1]],[10,[1]],[13,[1]],[14,[1]],
     [18,[1]],[19,[1]],[22,[1]]]],
 [21508,[[2,[1]],[3,[1]],[6,[1]],[9,[1]],[10,[1]],[14,[1]],[15,[1]],
     [18,[1]],[21,[1]],[22,[1]]]],
 [21509,[[0,[1]],[2,[1]],[6,[1]],[7,[1]],[10,[1]],[13,[1]],[14,[1]],
     [18,[1]],[19,[1]],[22,[1]]]],
 [21510,[[0,[1,2]],[3,[1,2]],[7,[1,2]],[9,[1,2]],[13,[1,2]],[15,[1,2]],
     [19,[1,2]],[21,[1,2]],[25,[1,2]],[27,[1,2]]]],
 [21515,[[3,[1,2]],[5,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[17,[1,2]],
     [21,[1,2]],[23,[1,2]],[27,[1,2]],[29,[1,2]]]],
 [21516,[[0,[1]],[5,[1]],[6,[1]],[10,[1]],[11,[1]],[14,[1]],[17,[1]],
     [18,[1]],[22,[1]],[23,[1]]]],
 [21517,[[0,[1]],[3,[1]],[6,[1]],[9,[1]],[10,[1]],[14,[1]],[15,[1]],
     [18,[1]],[21,[1]],[22,[1]]]],
 [21539,[[2,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],[22,[1,2]],
     [26,[1,2]],[30,[1,2]],[34,[1,2]],[38,[1,2]]]],
 [21541,[[4,[1]],[24,[1]],[44,[1]],[64,[1]],[84,[1]],[104,[1]],
     [124,[1]],[144,[1]],[164,[1]],[184,[1]]]],
 [21542,[[12,[1,2,2]],[32,[1,2,2]],[52,[1,2,2]],[72,[1,2,2]],[92,[1,2,2]],
     [112,[1,2,2]],[132,[1,2,2]],[152,[1,2,2]],[172,[1,2,2]],
     [192,[1,2,2]]]],
 [21544,[[10,[1]],[16,[1,1,1,2]],[30,[1]],[36,[1,1,1,2]],[50,[1]],
     [56,[1,1,1,2]],[70,[1]],[76,[1,1,1,2]],[90,[1]],[96,[1,1,1,2]]]],
 [21546,[[8,[1,2]],[28,[1,2]],[48,[1,2]],[68,[1,2]],[88,[1,2]],
     [108,[1,2]],[128,[1,2]],[148,[1,2]],[168,[1,2]],[188,[1,2]]]],
 [21551,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [21555,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [21559,[[6,[1]],[10,[1]],[18,[1]],[22,[1]],[30,[1]],[34,[1]],[42,[1]],
     [46,[1]],[54,[1]],[58,[1]]]],
 [21564,[[4,[1]],[6,[1]],[16,[1]],[18,[1]],[28,[1]],[30,[1]],[40,[1]],
     [42,[1]],[52,[1]],[54,[1]]]],
 [21565,[[10,[1,1,1,1,2]],[22,[1,1,1,1,2]],[34,[1,1,1,1,2]],
     [46,[1,1,1,1,2]],[58,[1,1,1,1,2]],[70,[1,1,1,1,2]],[82,[1,1,1,1,2]],
     [94,[1,1,1,1,2]],[106,[1,1,1,1,2]],[118,[1,1,1,1,2]]]],
 [21568,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [21570,[[4,[3]],[10,[1,2]],[16,[3]],[22,[1,2]],[28,[3]],[34,[1,2]],
     [40,[3]],[46,[1,2]],[52,[3]],[58,[1,2]]]],
 [21576,[[0,[1]],[10,[1]],[12,[1]],[22,[1]],[24,[1]],[34,[1]],[36,[1]],
     [46,[1]],[48,[1]],[58,[1]]]],
 [21578,[[0,[2]],[6,[1]],[12,[2]],[18,[1]],[24,[2]],[30,[1]],[36,[2]],
     [42,[1]],[48,[2]],[54,[1]]]],[21580,[[2,fail]]],
 [21581,[[2,[1,2]],[6,[1,2]],[8,[1,2]],[14,[1,2]],[18,[1,2]],[20,[1,2]],
     [26,[1,2]],[30,[1,2]],[32,[1,2]],[38,[1,2]]]],[21582,[[0,fail]]],
 [21588,[[0,[1,1,1,2]],[4,[1,1,1,2]],[6,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[16,[1,1,1,2]],[18,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[28,[1,1,1,2]]]],
 [21589,[[0,[1,2]],[2,[1]],[6,[1]],[8,[1,2]],[12,[1,2]],[14,[1]],
     [18,[1]],[20,[1,2]],[24,[1,2]],[26,[1]]]],
 [21590,[[2,[1]],[4,[1,2]],[8,[1,2]],[10,[1]],[14,[1]],[16,[1,2]],
     [20,[1,2]],[22,[1]],[26,[1]],[28,[1,2]]]],
 [21607,[[2,[1,1,1,2]],[6,[1,2]],[10,[1,1,1,2]],[14,[1,1,1,2]],[18,[1,2]],
     [22,[1,1,1,2]],[26,[1,1,1,2]],[30,[1,2]],[34,[1,1,1,2]],
     [38,[1,1,1,2]]]],
 [21610,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [21614,[[2,[1,1,1,2]],[6,[1,2]],[10,[1,1,1,2]],[14,[1,1,1,2]],[18,[1,2]],
     [22,[1,1,1,2]],[26,[1,1,1,2]],[30,[1,2]],[34,[1,1,1,2]],
     [38,[1,1,1,2]]]],
 [21616,[[1,[1,2,2]],[6,[1]],[10,[1,2,2]],[14,[1,2,2]],[18,[1]],
     [22,[1,2,2]],[26,[1,2,2]],[30,[1]],[34,[1,2,2]],[38,[1,2,2]]]],
 [21620,[[2,[1,1,1,2]],[6,[1]],[10,[1,1,1,2]],[14,[1,1,1,2]],[18,[1]],
     [22,[1,1,1,2]],[26,[1,1,1,2]],[30,[1]],[34,[1,1,1,2]],
     [38,[1,1,1,2]]]],
 [21626,[[2,[1]],[6,[1]],[10,[1]],[14,[1]],[18,[1]],[22,[1]],[26,[1]],
     [30,[1]],[34,[1]],[38,[1]]]],
 [21643,[[1,[1,1,1,2]],[6,[1]],[9,[1,1,1,2]],[10,[1,1,1,2]],
     [17,[1,1,1,2]],[18,[1]],[22,[1,1,1,2]],[25,[1,1,1,2]],[30,[1]],
     [33,[1,1,1,2]]]],
 [21644,[[1,[1,1,1,2]],[5,[1,1,1,2]],[6,[1]],[13,[1,1,1,2]],
     [14,[1,1,1,2]],[18,[1]],[21,[1,1,1,2]],[26,[1,1,1,2]],
     [29,[1,1,1,2]],[30,[1]]]],
 [21645,[[2,[1]],[5,[1,2]],[10,[1]],[13,[1,2]],[14,[1]],[21,[1,2]],
     [22,[1]],[26,[1]],[29,[1,2]],[34,[1]]]],
 [21666,[[13,[2,3]],[20,[2,3]],[50,[2,3]],[73,[2,3]],[80,[2,3]],
     [110,[2,3]],[133,[2,3]],[140,[2,3]],[170,[2,3]],[193,[2,3]]]],
 [21672,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [21674,[[13,[1,2]],[22,[1,2]],[52,[1,2]],[73,[1,2]],[82,[1,2]],
     [112,[1,2]],[133,[1,2]],[142,[1,2]],[172,[1,2]],[193,[1,2]]]],
 [21676,[[5,[1,2]],[8,[5,6]],[25,[1,2]],[36,[1,2]],[45,[1,2]],[48,[5,6]],
     [65,[1,2]],[68,[5,6]],[85,[1,2]],[96,[1,2]]]],
 [21681,[[0,[1,1,1,2]],[8,[1,1,1,2]],[13,[1,1,1,2]],[17,[1,1,1,2]],
     [21,[1,1,1,2]],[28,[1,1,1,2]],[33,[1,1,1,2]],[37,[1,1,1,2]],
     [40,[1,1,1,2]],[41,[1,1,1,2]]]],
 [21685,[[33,[1,2,2]],[93,[1,2,2]],[153,[1,2,2]],[213,[1,2,2]]]],
 [21687,[[30,[1,2,2]],[90,[1,2,2]],[150,[1,2,2]],[210,[1,2,2]]]],
 [21688,[[0,[1]],[33,[1]],[36,[1]],[60,[1]],[93,[1]],[96,[1]],[120,[1]],
     [153,[1]],[156,[1]],[180,[1]]]],
 [21689,[[0,[1,1,2,3]],[20,[1,1,2,3]],[22,[1,1,2,3]],[33,[1,1,2,3]],
     [42,[1,1,2,3]],[53,[1,1,2,3]],[62,[1,1,2,3]],[80,[1,1,2,3]],
     [82,[1,1,2,3]],[93,[1,1,2,3]]]],
 [21691,[[2,[1,2]],[16,[5,6]],[22,[1,2]],[36,[5,6]],[42,[1,2]],
     [48,[1,2]],[62,[1,2]],[76,[5,6]],[82,[1,2]],[96,[5,6]]]],
 [21692,[[20,fail]]],
 [21718,[[17,[1,2]],[26,[1,2]],[56,[1,2]],[77,[1,2]],[86,[1,2]],
     [116,[1,2]],[137,[1,2]],[146,[1,2]],[176,[1,2]],[197,[1,2]]]],
 [21725,[[34,[1,2,2]],[94,[1,2,2]],[154,[1,2,2]],[214,[1,2,2]]]],
 [21726,[[4,[1]],[37,[1]],[40,[1]],[64,[1]],[97,[1]],[100,[1]],
     [124,[1]],[157,[1]],[160,[1]],[184,[1]]]],
 [21727,[[25,[2,2,3]],[34,[1,1,2,2]],[85,[2,2,3]],[94,[1,1,2,2]],
     [145,[2,2,3]],[154,[1,1,2,2]],[205,[2,2,3]],[214,[1,1,2,2]]]],
 [21734,[[4,[1,1,2,3]],[9,[1,1,2,3]],[29,[1,1,2,3]],[37,[1,1,2,3]],
     [49,[1,1,2,3]],[57,[1,1,2,3]],[64,[1,1,2,3]],[69,[1,1,2,3]],
     [89,[1,1,2,3]],[97,[1,1,2,3]]]],
 [21736,[[32,[1]],[92,[1]],[152,[1]],[212,[1]]]],
 [21739,[[21,[1,1,2,2]],[30,[2,2,3]],[81,[1,1,2,2]],[90,[2,2,3]],
     [141,[1,1,2,2]],[150,[2,2,3]],[201,[1,1,2,2]],[210,[2,2,3]]]],
 [21740,[[12,[1]],[17,[1]],[44,[1]],[72,[1]],[77,[1]],[104,[1]],
     [132,[1]],[137,[1]],[164,[1]],[192,[1]]]],
 [21741,[[21,[1,2,2]],[81,[1,2,2]],[141,[1,2,2]],[201,[1,2,2]]]],
 [21742,[[0,[1,1,1,2]],[10,[1,1,1,2]],[14,[1,1,1,2]],[17,[1,1,1,2]],
     [20,[1,1,1,2]],[30,[1,1,1,2]],[32,[1,1,1,2]],[34,[1,1,1,2]],
     [44,[1,1,1,2]],[50,[1,1,1,2]]]],[21746,[[24,fail]]],
 [21756,[[24,fail]]],
 [21770,[[8,[2,3]],[38,[2,3]],[42,[2,3]],[68,[2,3]],[98,[2,3]],
     [102,[2,3]],[128,[2,3]],[158,[2,3]],[162,[2,3]],[188,[2,3]]]],
 [21771,[[8,[2]],[38,[2]],[42,[2]],[68,[2]],[98,[2]],[102,[2]],
     [128,[2]],[158,[2]],[162,[2]],[188,[2]]]],
 [21778,[[32,[2,2,3]],[92,[2,2,3]],[152,[2,2,3]],[212,[2,2,3]]]],
 [21780,[[0,[1,1,1,2,1,2,2,2]],[1,[1,1,1,2,1,2,2,2]],[5,[1,1,1,2,1,2,2,2]],
     [16,[2]],[21,[1,1,1,2,1,2,2,2]],[22,[1,1,1,2,1,2,2,2]],
     [25,[1,1,1,2,1,2,2,2]],[28,[1,1,1,2,1,2,2,2]],[36,[2]],
     [40,[1,1,1,2,1,2,2,2]]]],
 [21781,[[1,[3,3,4]],[21,[3,3,4]],[41,[3,3,4]],[42,[3,3,4]],[61,[3,3,4]],
     [81,[3,3,4]],[101,[3,3,4]],[102,[3,3,4]],[121,[3,3,4]],[141,[3,3,4]] 
    ]],
 [21786,[[2,[1,2,2]],[5,[1,2,2]],[13,[1,2,2]],[16,[1,2,2]],[25,[1,2,2]],
     [32,[1,2,2]],[33,[1,2,2]],[45,[1,2,2]],[53,[1,2,2]],[56,[1,2,2]]]],
 [21791,[[22,[1]],[82,[1]],[142,[1]],[202,[1]]]],
 [21792,[[0,[1,2]],[30,[1,2]],[36,[1,2]],[60,[1,2]],[90,[1,2]],
     [96,[1,2]],[120,[1,2]],[150,[1,2]],[156,[1,2]],[180,[1,2]]]],
 [21793,[[12,[1,2]],[21,[1,2]],[48,[1,2]],[72,[1,2]],[81,[1,2]],
     [108,[1,2]],[132,[1,2]],[141,[1,2]],[168,[1,2]],[192,[1,2]]]],
 [21794,[[6,[1,2,2]],[12,[1,2,2]],[18,[1,2,2]],[22,[1,2,2]],[26,[1,2,2]],
     [32,[1,2,2]],[38,[1,2,2]],[46,[1,2,2]],[56,[1,2,2]],[58,[1,2,2]]]],
 [21796,[[2,[1,1,2,2,2,2]],[10,[1,1,2,2,2,2]],[12,[1,1,2,2,2,2]],
     [28,[1,1,2,2,2,2]],[30,[1,1,2,2,2,2]],[48,[1,1,2,2,2,2]],
     [50,[1,1,2,2,2,2]],[52,[1,1,2,2,2,2]],[62,[1,1,2,2,2,2]],
     [70,[1,1,2,2,2,2]]]],[21807,[[16,fail]]],
 [21821,[[29,[2,2,3]],[38,[1,1,2,2]],[89,[2,2,3]],[98,[1,1,2,2]],
     [149,[2,2,3]],[158,[1,1,2,2]],[209,[2,2,3]],[218,[1,1,2,2]]]],
 [21826,[[8,[1]],[41,[1]],[44,[1]],[68,[1]],[101,[1]],[104,[1]],
     [128,[1]],[161,[1]],[164,[1]],[188,[1]]]],
 [21828,[[16,[1]],[21,[1]],[48,[1]],[76,[1]],[81,[1]],[108,[1]],
     [136,[1]],[141,[1]],[168,[1]],[196,[1]]]],
 [21829,[[25,[1,2,2]],[85,[1,2,2]],[145,[1,2,2]],[205,[1,2,2]]]],
 [21832,[[1,[1,1,1,2]],[5,[1,1,1,2]],[8,[1,1,1,2]],[9,[1,1,1,2]],
     [24,[1,1,1,2]],[25,[1,1,1,2]],[29,[1,1,1,2]],[36,[1,1,1,2]],
     [41,[1,1,1,2]],[45,[1,1,1,2]]]],
 [21835,[[25,[1,1,2,2]],[34,[2,2,3]],[85,[1,1,2,2]],[94,[2,2,3]],
     [145,[1,1,2,2]],[154,[2,2,3]],[205,[1,1,2,2]],[214,[2,2,3]]]],
 [21839,[[38,[1,2,2]],[98,[1,2,2]],[158,[1,2,2]],[218,[1,2,2]]]],
 [21842,[[0,[1,2]],[33,[1,2]],[41,[1,2]],[60,[1,2]],[93,[1,2]],
     [101,[1,2]],[120,[1,2]],[153,[1,2]],[161,[1,2]],[180,[1,2]]]],
 [21844,[[24,[1]],[84,[1]],[144,[1]],[204,[1]]]],
 [21847,[[1,[1,1,2,3]],[10,[1,1,2,3]],[21,[1,1,2,3]],[30,[1,1,2,3]],
     [48,[1,1,2,3]],[50,[1,1,2,3]],[61,[1,1,2,3]],[70,[1,1,2,3]],
     [81,[1,1,2,3]],[90,[1,1,2,3]]]],[21856,[[28,fail]]],
 [21858,[[28,fail]]],
 [21872,[[20,[1]],[29,[1,2,2]],[80,[1]],[89,[1,2,2]],[140,[1]],
     [149,[1,2,2]],[200,[1]],[209,[1,2,2]]]],
 [21876,[[36,[2,2,3]],[96,[2,2,3]],[156,[2,2,3]],[216,[2,2,3]]]],
 [21878,[[4,[1,2]],[34,[1,2]],[40,[1,2]],[64,[1,2]],[94,[1,2]],
     [100,[1,2]],[124,[1,2]],[154,[1,2]],[160,[1,2]],[184,[1,2]]]],
 [21879,[[16,[1,2]],[25,[1,2]],[52,[1,2]],[76,[1,2]],[85,[1,2]],
     [112,[1,2]],[136,[1,2]],[145,[1,2]],[172,[1,2]],[196,[1,2]]]],
 [21880,[[26,[1]],[86,[1]],[146,[1]],[206,[1]]]],
 [21882,[[5,[1]],[25,[1]],[36,[1]],[45,[1]],[65,[1]],[85,[1]],[96,[1]],
     [105,[1]],[125,[1]],[145,[1]]]],
 [21885,[[26,[1]],[86,[1]],[146,[1]],[206,[1]]]],
 [21887,[[20,[3,4,5]],[40,[3,4,5]],[80,[3,4,5]],[100,[3,4,5]],
     [140,[3,4,5]],[160,[3,4,5]],[200,[3,4,5]],[220,[3,4,5]]]],
 [21891,[[30,[1,2,2]],[36,[1]],[90,[1,2,2]],[96,[1]],[150,[1,2,2]],
     [156,[1]],[210,[1,2,2]],[216,[1]]]],
 [21893,[[20,[2,2,3]],[80,[2,2,3]],[140,[2,2,3]],[200,[2,2,3]]]],
 [21895,[[14,[1]],[20,[1]],[34,[1]],[54,[1]],[74,[1]],[80,[1]],[94,[1]],
     [114,[1]],[134,[1]],[140,[1]]]],
 [21897,[[16,[3,4,5]],[36,[3,4,5]],[76,[3,4,5]],[96,[3,4,5]],[136,[3,4,5]],
     [156,[3,4,5]],[196,[3,4,5]],[216,[3,4,5]]]],[21898,[[6,fail]]],
 [21907,[[20,fail]]],
 [21930,[[0,[1,1,1,2,2,1,2,2]],[1,[1,1,1,2,2,1,2,2]],[6,[1]],
     [12,[1,1,1,2,2,1,2,2]],[16,[1]],[21,[1,1,1,2,2,1,2,2]],
     [28,[1,1,1,2,2,1,2,2]],[36,[1]],[40,[1,1,1,2,2,1,2,2]],[46,[1]]]],
 [21931,[[6,[2,3]],[12,[2,3]],[17,[2,3]],[21,[2]],[32,[2,3]],[37,[2,3]],
     [41,[2]],[57,[2,3]],[66,[2,3]],[72,[2,3]]]],
 [21936,[[0,[1,1,1,1,2,2]],[20,[1,1,1,1,2,2]],[26,[1,1,1,1,2,2]],
     [40,[1,1,1,1,2,2]],[41,[1,1,1,1,2,2]],[46,[1,1,1,1,2,2]],
     [61,[1,1,1,1,2,2]],[80,[1,1,1,1,2,2]],[86,[1,1,1,1,2,2]],
     [100,[1,1,1,1,2,2]]]],
 [21944,[[6,[1]],[26,[1]],[36,[1]],[56,[1]],[66,[1]],[86,[1]],[96,[1]],
     [116,[1]],[126,[1]],[146,[1]]]],
 [21945,[[1,[1,1,2,2,1,2,2,2]],[2,[1,1,2,2,1,2,2,2]],[16,[1,1,2,2,1,2,2,2]],
     [20,[1]],[22,[1,1,2,2,1,2,2,2]],[26,[1,1,2,2,1,2,2,2]],
     [32,[1,1,2,2,1,2,2,2]],[40,[1]],[41,[1,1,2,2,1,2,2,2]],
     [42,[1,1,2,2,1,2,2,2]]]],
 [21969,[[25,[1,2,2]],[85,[1,2,2]],[145,[1,2,2]],[205,[1,2,2]]]],
 [21973,[[29,[1,2,2]],[89,[1,2,2]],[149,[1,2,2]],[209,[1,2,2]]]],
 [21976,[[28,[1]],[88,[1]],[148,[1]],[208,[1]]]],
 [21979,[[5,[1,1,2,3]],[17,[1,1,2,3]],[25,[1,1,2,3]],[32,[1,1,2,3]],
     [37,[1,1,2,3]],[57,[1,1,2,3]],[65,[1,1,2,3]],[77,[1,1,2,3]],
     [85,[1,1,2,3]],[92,[1,1,2,3]]]],
 [21982,[[4,[1,2]],[37,[1,2]],[45,[1,2]],[64,[1,2]],[97,[1,2]],
     [105,[1,2]],[124,[1,2]],[157,[1,2]],[165,[1,2]],[184,[1,2]]]],
 [21984,[[8,[1,2]],[17,[1,2]],[20,[5,6]],[37,[1,2]],[40,[5,6]],
     [57,[1,2]],[68,[1,2]],[77,[1,2]],[80,[5,6]],[97,[1,2]]]],
 [21986,[[20,[1]],[25,[1]],[52,[1]],[80,[1]],[85,[1]],[112,[1]],
     [140,[1]],[145,[1]],[172,[1]],[200,[1]]]],
 [21988,[[9,[2,3]],[32,[2,3]],[45,[2,3]],[69,[2,3]],[92,[2,3]],
     [105,[2,3]],[129,[2,3]],[152,[2,3]],[165,[2,3]],[189,[2,3]]]],
 [21992,[[8,[5,6]],[14,[1,2]],[20,[1,2]],[34,[1,2]],[48,[5,6]],
     [54,[1,2]],[68,[5,6]],[74,[1,2]],[80,[1,2]],[94,[1,2]]]],
 [21994,[[0,[1,1,1,2]],[2,[1,1,1,2]],[12,[1,1,1,2]],[18,[1,1,1,2]],
     [22,[1,1,1,2]],[25,[1,1,1,2]],[28,[1,1,1,2]],[38,[1,1,1,2]],
     [42,[1,1,1,2]],[45,[1,1,1,2]]]],[22004,[[32,fail]]],
 [22015,[[30,[1]],[90,[1]],[150,[1]],[210,[1]]]],
 [22020,[[20,[1,2]],[29,[1,2]],[56,[1,2]],[80,[1,2]],[89,[1,2]],
     [116,[1,2]],[140,[1,2]],[149,[1,2]],[176,[1,2]],[200,[1,2]]]],
 [22022,[[24,[2,2,3]],[84,[2,2,3]],[144,[2,2,3]],[204,[2,2,3]]]],
 [22026,[[0,[1,2,2]],[1,[1,2,2]],[13,[1,2,2]],[21,[1,2,2]],[24,[1,2,2]],
     [30,[1,2,2]],[33,[1,2,2]],[41,[1,2,2]],[44,[1,2,2]],[53,[1,2,2]]]],
 [22031,[[4,[1,1,2,2,2,2]],[8,[1,1,2,2,2,2]],[9,[1,1,2,2,2,2]],
     [28,[1,1,2,2,2,2]],[29,[1,1,2,2,2,2]],[44,[1,1,2,2,2,2]],
     [49,[1,1,2,2,2,2]],[50,[1,1,2,2,2,2]],[64,[1,1,2,2,2,2]],
     [68,[1,1,2,2,2,2]]]],
 [22033,[[8,[1,2]],[38,[1,2]],[44,[1,2]],[68,[1,2]],[98,[1,2]],
     [104,[1,2]],[128,[1,2]],[158,[1,2]],[164,[1,2]],[188,[1,2]]]],
 [22035,[[10,[2]],[21,[2]],[48,[2]],[70,[2]],[81,[2]],[108,[2]],
     [130,[2]],[141,[2]],[168,[2]],[190,[2]]]],
 [22036,[[10,[2,3]],[21,[2,3]],[48,[2,3]],[70,[2,3]],[81,[2,3]],
     [108,[2,3]],[130,[2,3]],[141,[2,3]],[168,[2,3]],[190,[2,3]]]],
 [22039,[[10,[3,3,4]],[18,[3,3,4]],[38,[3,3,4]],[58,[3,3,4]],[70,[3,3,4]],
     [78,[3,3,4]],[98,[3,3,4]],[118,[3,3,4]],[130,[3,3,4]],[138,[3,3,4]] 
    ]],
 [22040,[[4,[1,1,1,2,1,2,2,2]],[8,[1,1,1,2,1,2,2,2]],[14,[1,1,1,2,1,2,2,2]],
     [16,[1,1,1,2,1,2,2,2]],[18,[1,1,1,2,1,2,2,2]],[20,[2]],
     [28,[1,1,1,2,1,2,2,2]],[30,[1,1,1,2,1,2,2,2]],[34,[1,1,1,2,1,2,2,2]],
     [38,[1,1,1,2,1,2,2,2]]]],
 [22041,[[0,[1,2,2]],[6,[1,2,2]],[14,[1,2,2]],[24,[1,2,2]],[26,[1,2,2]],
     [34,[1,2,2]],[40,[1,2,2]],[46,[1,2,2]],[50,[1,2,2]],[54,[1,2,2]]]],
 [22043,[[10,fail]]],
 [22071,[[0,[1,1,2,2,1,2,2,2]],[4,[1,1,2,2,1,2,2,2]],[12,[1,1,2,2,1,2,2,2]],
     [16,[1]],[17,[1,1,2,2,1,2,2,2]],[24,[1,1,2,2,1,2,2,2]],
     [25,[1,1,2,2,1,2,2,2]],[36,[1]],[37,[1,1,2,2,1,2,2,2]],
     [40,[1,1,2,2,1,2,2,2]]]],
 [22072,[[0,[1]],[20,[1]],[30,[1]],[50,[1]],[60,[1]],[80,[1]],[90,[1]],
     [110,[1]],[120,[1]],[140,[1]]]],
 [22085,[[2,[2,3]],[12,[2]],[22,[2,3]],[24,[2,3]],[32,[2]],[42,[2,3]],
     [44,[2,3]],[45,[2,3]],[62,[2,3]],[72,[2]]]],
 [22086,[[4,[1,1,1,2,2,1,2,2]],[5,[1,1,1,2,2,1,2,2]],[10,[1]],
     [14,[1,1,1,2,2,1,2,2]],[20,[1]],[25,[1,1,1,2,2,1,2,2]],
     [32,[1,1,1,2,2,1,2,2]],[40,[1]],[44,[1,1,1,2,2,1,2,2]],[50,[1]]]],
 [22087,[[10,[1,1,1,1,2,2]],[12,[1,1,1,1,2,2]],[16,[1,1,1,1,2,2]],
     [30,[1,1,1,1,2,2]],[36,[1,1,1,1,2,2]],[52,[1,1,1,1,2,2]],
     [70,[1,1,1,1,2,2]],[72,[1,1,1,1,2,2]],[76,[1,1,1,1,2,2]],
     [90,[1,1,1,1,2,2]]]],
 [22106,[[10,[1]],[40,[1]],[50,[1]],[70,[1]],[100,[1]],[110,[1]],
     [130,[1]],[160,[1]],[170,[1]],[190,[1]]]],
 [22107,[[26,[1,1,1,2]],[86,[1,1,1,2]],[146,[1,1,1,2]],[206,[1,1,1,2]]]],
 [22111,[[10,[3]],[20,[3]],[53,[3]],[70,[3]],[80,[3]],[113,[3]],
     [130,[3]],[140,[3]],[173,[3]],[190,[3]]]],
 [22126,[[33,[1,1,1,2]],[93,[1,1,1,2]],[153,[1,1,1,2]],[213,[1,1,1,2]]]],
 [22127,[[5,[1]],[12,[1]],[45,[1]],[65,[1]],[72,[1]],[105,[1]],
     [125,[1]],[132,[1]],[165,[1]],[185,[1]]]],
 [22128,[[6,[3]],[32,[3]],[45,[3]],[66,[3]],[92,[3]],[105,[3]],
     [126,[3]],[152,[3]],[165,[3]],[186,[3]]]],[22133,[[20,fail]]],
 [22142,[[32,fail]]],
 [22155,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [22157,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [22160,[[0,[1,2]],[4,[1,2]],[12,[1,2]],[16,[1,2]],[24,[1,2]],[28,[1,2]],
     [36,[1,2]],[40,[1,2]],[48,[1,2]],[52,[1,2]]]],
 [22175,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],[22177,[[0,fail]]],[22188,[[0,fail]]],
 [22203,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [22207,[[0,[1,1,1,2]],[13,[1,1,1,2]],[25,[1,1,1,2]],[37,[1,1,1,2]],
     [49,[1,1,1,2]],[61,[1,1,1,2]],[73,[1,1,1,2]],[85,[1,1,1,2]],
     [97,[1,1,1,2]],[109,[1,1,1,2]]]],
 [22213,[[9,[1,2,2]],[21,[1,2,2]],[33,[1,2,2]],[45,[1,2,2]],[57,[1,2,2]],
     [69,[1,2,2]],[81,[1,2,2]],[93,[1,2,2]],[105,[1,2,2]],[117,[1,2,2]]] 
  ],
 [22220,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],[22228,[[8,fail]]],
 [22229,[[20,fail]]],
 [22230,[[8,[3]],[32,[3]],[56,[3]],[80,[3]],[104,[3]],[128,[3]],
     [152,[3]],[176,[3]],[200,[3]],[224,[3]]]],
 [22245,[[0,[2]],[4,[2]],[12,[2]],[16,[2]],[24,[2]],[28,[2]],[36,[2]],
     [40,[2]],[48,[2]],[52,[2]]]],
 [22251,[[0,[1,1,2]],[8,[1,1,2]],[13,[1,1,2]],[20,[1,1,2]],[25,[1,1,2]],
     [32,[1,1,2]],[37,[1,1,2]],[44,[1,1,2]],[49,[1,1,2]],[56,[1,1,2]]]],
 [22256,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [22260,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [22261,[[2,[1]],[4,[1]],[6,[1]],[10,[1]],[14,[1]],[16,[1]],[18,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],[22272,[[4,fail]]],[22273,[[4,fail]]],
 [22294,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [22299,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],[22304,[[4,fail]]],[22313,[[4,fail]]],
 [22325,[[2,[1]],[14,[1]],[26,[1]],[38,[1]],[50,[1]],[62,[1]],[74,[1]],
     [86,[1]],[98,[1]],[110,[1]]]],
 [22326,[[0,[1,2]],[1,[1,2]],[5,[1,2]],[9,[1,2]],[12,[1,2]],[13,[1,2]],
     [17,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [22327,[[0,[1]],[1,[1]],[5,[1]],[9,[1]],[12,[1]],[13,[1]],[17,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [22340,[[6,[1,1,2]],[8,[1,1,2]],[18,[1,1,2]],[20,[1,1,2]],[30,[1,1,2]],
     [32,[1,1,2]],[42,[1,1,2]],[44,[1,1,2]],[54,[1,1,2]],[56,[1,1,2]]]],
 [22341,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [22342,[[2,[1,1,2]],[6,[1,1,2]],[14,[1,1,2]],[18,[1,1,2]],[26,[1,1,2]],
     [30,[1,1,2]],[38,[1,1,2]],[42,[1,1,2]],[50,[1,1,2]],[54,[1,1,2]]]],
 [22343,[[0,fail]]],[22344,[[0,fail]]],
 [22365,[[0,[1]],[1,[1]],[4,[1]],[9,[1]],[12,[1]],[13,[1]],[16,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [22380,[[4,[1]],[8,[1]],[16,[1]],[20,[1]],[28,[1]],[32,[1]],[40,[1]],
     [44,[1]],[52,[1]],[56,[1]]]],
 [22381,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [22406,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [22409,[[5,[1,1,2,1,2]],[13,[1,1,2,1,2]],[29,[1,1,2,1,2]],
     [37,[1,1,2,1,2]],[53,[1,1,2,1,2]],[61,[1,1,2,1,2]],[77,[1,1,2,1,2]],
     [85,[1,1,2,1,2]],[101,[1,1,2,1,2]],[109,[1,1,2,1,2]]]],
 [22425,[[5,[1,2,2]],[13,[1,2,2]],[29,[1,2,2]],[37,[1,2,2]],[53,[1,2,2]],
     [61,[1,2,2]],[77,[1,2,2]],[85,[1,2,2]],[101,[1,2,2]],[109,[1,2,2]]] 
  ],
 [22432,[[1,[1,2,2]],[13,[1,2,2]],[25,[1,2,2]],[37,[1,2,2]],[49,[1,2,2]],
     [61,[1,2,2]],[73,[1,2,2]],[85,[1,2,2]],[97,[1,2,2]],[109,[1,2,2]]]]
  ,
 [22436,[[2,[1,1,1,2]],[14,[1,1,1,2]],[26,[1,1,1,2]],[38,[1,1,1,2]],
     [50,[1,1,1,2]],[62,[1,1,1,2]],[74,[1,1,1,2]],[86,[1,1,1,2]],
     [98,[1,1,1,2]],[110,[1,1,1,2]]]],
 [22454,[[5,[1,1,1,2,2]],[6,[1,1,1,2,2]],[17,[1,1,1,2,2]],[18,[1,1,1,2,2]],
     [29,[1,1,1,2,2]],[30,[1,1,1,2,2]],[41,[1,1,1,2,2]],[42,[1,1,1,2,2]],
     [53,[1,1,1,2,2]],[54,[1,1,1,2,2]]]],
 [22455,[[2,[1]],[8,[2]],[14,[1]],[20,[2]],[26,[1]],[32,[2]],[38,[1]],
     [44,[2]],[50,[1]],[56,[2]]]],
 [22460,[[2,[1]],[6,[2,3]],[14,[2,3]],[18,[1]],[26,[1]],[30,[2,3]],
     [38,[2,3]],[42,[1]],[50,[1]],[54,[2,3]]]],
 [22475,[[10,[1,1,1,2]],[22,[1,1,1,2]],[34,[1,1,1,2]],[46,[1,1,1,2]],
     [58,[1,1,1,2]],[70,[1,1,1,2]],[82,[1,1,1,2]],[94,[1,1,1,2]],
     [106,[1,1,1,2]],[118,[1,1,1,2]]]],
 [22491,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[22493,[[0,fail]]],
 [22494,[[12,[3]],[36,[3]],[60,[3]],[84,[3]],[108,[3]],[132,[3]],
     [156,[3]],[180,[3]],[204,[3]],[228,[3]]]],
 [22502,[[12,[3]],[36,[3]],[60,[3]],[84,[3]],[108,[3]],[132,[3]],
     [156,[3]],[180,[3]],[204,[3]],[228,[3]]]],[22504,[[12,fail]]],
 [22511,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [22512,[[0,[1,1,2]],[5,[1,1,2]],[12,[1,1,2]],[17,[1,1,2]],[24,[1,1,2]],
     [29,[1,1,2]],[36,[1,1,2]],[41,[1,1,2]],[48,[1,1,2]],[53,[1,1,2]]]],
 [22515,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [22517,[[4,[1,1,2]],[5,[1,1,2]],[16,[1,1,2]],[17,[1,1,2]],[28,[1,1,2]],
     [29,[1,1,2]],[40,[1,1,2]],[41,[1,1,2]],[52,[1,1,2]],[53,[1,1,2]]]],
 [22525,[[2,[1]],[6,[1]],[8,[1]],[10,[1]],[14,[1]],[18,[1]],[20,[1]],
     [22,[1]],[26,[1]],[30,[1]]]],
 [22526,[[2,[1,2]],[6,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[30,[1,2]]]],[22537,[[8,fail]]],
 [22538,[[8,fail]]],
 [22545,[[0,[1]],[1,[1]],[12,[1]],[13,[1]],[24,[1]],[25,[1]],[36,[1]],
     [37,[1]],[48,[1]],[49,[1]]]],
 [22560,[[1,[1]],[8,[1]],[13,[1]],[20,[1]],[25,[1]],[32,[1]],[37,[1]],
     [44,[1]],[49,[1]],[56,[1]]]],[22562,[[8,fail]]],[22566,[[1,fail]]],
 [22568,[[17,fail]]],[22571,[[8,fail]]],
 [22579,[[1,[1,1,1,2,2]],[9,[1,1,1,2,2]],[14,[1,1,1,2,2]],[21,[1,1,1,2,2]],
     [26,[1,1,1,2,2]],[33,[1,1,1,2,2]],[38,[1,1,1,2,2]],[45,[1,1,1,2,2]],
     [50,[1,1,1,2,2]],[57,[1,1,1,2,2]]]],
 [22593,[[4,[1]],[8,[2]],[17,[1]],[20,[2]],[29,[1]],[32,[2]],[41,[1]],
     [44,[2]],[53,[1]],[56,[2]]]],
 [22594,[[0,[1]],[1,[2]],[6,[2]],[10,[2]],[12,[1]],[14,[2]],[18,[2]],
     [22,[2]],[24,[1]],[26,[2]]]],
 [22600,[[4,[2,3]],[9,[1]],[17,[1]],[21,[2,3]],[29,[2,3]],[33,[1]],
     [41,[1]],[45,[2,3]],[53,[2,3]],[57,[1]]]],
 [22607,[[10,[1,1,1,2]],[22,[1,1,1,2]],[34,[1,1,1,2]],[46,[1,1,1,2]],
     [58,[1,1,1,2]],[70,[1,1,1,2]],[82,[1,1,1,2]],[94,[1,1,1,2]],
     [106,[1,1,1,2]],[118,[1,1,1,2]]]],
 [22625,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],[22627,[[0,fail]]],[22628,[[12,fail]]],
 [22636,[[12,fail]]],[22638,[[12,fail]]],
 [22642,[[0,[1]],[1,[2]],[5,[2]],[9,[2]],[12,[1]],[13,[2]],[17,[2]],
     [21,[2]],[24,[1]],[25,[2]]]],
 [22656,[[4,[2]],[10,[1]],[16,[2]],[22,[1]],[28,[2]],[34,[1]],[40,[2]],
     [46,[1]],[52,[2]],[58,[1]]]],[22657,[[1,fail]]],
 [22662,[[4,[2,3]],[10,[1]],[18,[1]],[22,[2,3]],[30,[2,3]],[34,[1]],
     [42,[1]],[46,[2,3]],[54,[2,3]],[58,[1]]]],
 [22671,[[0,[1]],[4,[2]],[13,[1]],[16,[2]],[25,[1]],[28,[2]],[37,[1]],
     [40,[2]],[49,[1]],[52,[2]]]],
 [22673,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],[22677,[[4,fail]]],
 [22678,[[0,[1,1,1,2]],[13,[1,1,1,2]],[25,[1,1,1,2]],[37,[1,1,1,2]],
     [49,[1,1,1,2]],[61,[1,1,1,2]],[73,[1,1,1,2]],[85,[1,1,1,2]],
     [97,[1,1,1,2]],[109,[1,1,1,2]]]],
 [22685,[[2,[2]],[6,[2]],[8,[1]],[10,[2]],[14,[2]],[18,[2]],[20,[1]],
     [22,[2]],[26,[2]],[30,[2]]]],
 [22694,[[0,[2,3]],[5,[1]],[13,[1]],[17,[2,3]],[25,[2,3]],[29,[1]],
     [37,[1]],[41,[2,3]],[49,[2,3]],[53,[1]]]],
 [22715,[[4,[2]],[10,[1]],[16,[2]],[22,[1]],[28,[2]],[34,[1]],[40,[2]],
     [46,[1]],[52,[2]],[58,[1]]]],
 [22723,[[1,[1,2,2]],[9,[1,2,2]],[25,[1,2,2]],[33,[1,2,2]],[49,[1,2,2]],
     [57,[1,2,2]],[73,[1,2,2]],[81,[1,2,2]],[97,[1,2,2]],[105,[1,2,2]]]]
  ,
 [22729,[[0,[1,2]],[1,[1,2]],[5,[1,2]],[9,[1,2]],[12,[1,2]],[13,[1,2]],
     [17,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [22730,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [22731,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[16,[1,2]],
     [17,[1,2]],[21,[1,2]],[25,[1,2]],[28,[1,2]]]],
 [22732,[[0,[1]],[4,[2]],[13,[1]],[16,[2]],[25,[1]],[28,[2]],[37,[1]],
     [40,[2]],[49,[1]],[52,[2]]]],
 [22733,[[0,[1]],[4,[1]],[12,[1]],[16,[1]],[24,[1]],[28,[1]],[36,[1]],
     [40,[1]],[48,[1]],[52,[1]]]],
 [22734,[[0,[1,2]],[4,[1,2]],[5,[1,2]],[9,[1,2]],[13,[1,2]],[16,[1,2]],
     [17,[1,2]],[21,[1,2]],[25,[1,2]],[28,[1,2]]]],
 [22735,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [22737,[[0,[1,2]],[4,[1,2]],[12,[1,2]],[16,[1,2]],[24,[1,2]],[28,[1,2]],
     [36,[1,2]],[40,[1,2]],[48,[1,2]],[52,[1,2]]]],
 [22738,[[0,[2]],[9,[1]],[12,[2]],[21,[1]],[24,[2]],[33,[1]],[36,[2]],
     [45,[1]],[48,[2]],[57,[1]]]],
 [22740,[[0,[2]],[6,[1]],[12,[2]],[18,[1]],[24,[2]],[30,[1]],[36,[2]],
     [42,[1]],[48,[2]],[54,[1]]]],
 [22747,[[0,[1]],[4,[1]],[5,[1]],[6,[1]],[10,[1]],[13,[1]],[16,[1]],
     [17,[1]],[18,[1]],[22,[1]]]],
 [22748,[[0,[1,2]],[1,[1,2]],[9,[1,2]],[10,[1,2]],[12,[1,2]],[13,[1,2]],
     [18,[1,2]],[21,[1,2]],[24,[1,2]],[25,[1,2]]]],
 [22749,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[10,[1]],[12,[1]],[17,[1]],
     [18,[1]],[21,[1]],[22,[1]]]],
 [22751,[[0,[1]],[1,[1]],[9,[1]],[12,[1]],[17,[1]],[24,[1]],[25,[1]],
     [33,[1]],[36,[1]],[41,[1]]]],
 [22752,[[0,[1]],[4,[1]],[9,[1]],[16,[1]],[17,[1]],[25,[1]],[28,[1]],
     [33,[1]],[40,[1]],[41,[1]]]],
 [22765,[[5,[1,1,1,2,2]],[6,[1,1,1,2,2]],[17,[1,1,1,2,2]],[18,[1,1,1,2,2]],
     [29,[1,1,1,2,2]],[30,[1,1,1,2,2]],[41,[1,1,1,2,2]],[42,[1,1,1,2,2]],
     [53,[1,1,1,2,2]],[54,[1,1,1,2,2]]]],[22774,[[0,fail]]],
 [22775,[[0,fail]]],[22776,[[0,fail]]],[22781,[[5,fail]]],[22782,[[1,fail]]],
 [22783,[[0,fail]]],
 [22793,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [22796,[[4,[1,2]],[8,[1,2]],[16,[1,2]],[20,[1,2]],[28,[1,2]],[32,[1,2]],
     [40,[1,2]],[44,[1,2]],[52,[1,2]],[56,[1,2]]]],[22806,[[8,fail]]],
 [22807,[[8,fail]]],
 [22812,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[13,[1]],[16,[1]],[17,[1]],
     [21,[1]],[25,[1]],[28,[1]]]],
 [22821,[[4,[2]],[6,[2]],[16,[2]],[18,[2]],[28,[2]],[30,[2]],[40,[2]],
     [42,[2]],[52,[2]],[54,[2]]]],
 [22822,[[0,[1,1,2]],[10,[1,1,2]],[12,[1,1,2]],[22,[1,1,2]],[24,[1,1,2]],
     [34,[1,1,2]],[36,[1,1,2]],[46,[1,1,2]],[48,[1,1,2]],[58,[1,1,2]]]],
 [22824,[[4,fail]]],[22831,[[4,fail]]],
 [22851,[[14,[1,2,2]],[22,[1,2,2]],[38,[1,2,2]],[46,[1,2,2]],[62,[1,2,2]],
     [70,[1,2,2]],[86,[1,2,2]],[94,[1,2,2]],[110,[1,2,2]],[118,[1,2,2]]] 
  ],
 [22859,[[0,[1]],[4,[1]],[5,[1]],[8,[1]],[13,[1]],[16,[1]],[17,[1]],
     [20,[1]],[25,[1]],[28,[1]]]],
 [22868,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [22887,[[0,[2]],[5,[2]],[8,[1]],[9,[2]],[13,[2]],[17,[2]],[20,[1]],
     [21,[2]],[25,[2]],[29,[2]]]],[22894,[[0,fail]]],[22895,[[0,fail]]],
 [22896,[[0,fail]]],[22901,[[5,fail]]],[22902,[[4,fail]]],[22903,[[0,fail]]],
 [22906,[[9,[1,1,1,2]],[21,[1,1,1,2]],[33,[1,1,1,2]],[45,[1,1,1,2]],
     [57,[1,1,1,2]],[69,[1,1,1,2]],[81,[1,1,1,2]],[93,[1,1,1,2]],
     [105,[1,1,1,2]],[117,[1,1,1,2]]]],[22913,[[8,fail]]],
 [22921,[[8,fail]]],[22922,[[20,fail]]],[22923,[[8,fail]]],
 [22936,[[0,[1,2,2,2]],[10,[1,2,2,2]],[14,[1,2,2,2]],[22,[1,2,2,2]],
     [26,[1,2,2,2]],[34,[1,2,2,2]],[38,[1,2,2,2]],[46,[1,2,2,2]],
     [50,[1,2,2,2]],[58,[1,2,2,2]]]],
 [22950,[[4,[1,2]],[6,[1,2]],[16,[1,2]],[18,[1,2]],[28,[1,2]],[30,[1,2]],
     [40,[1,2]],[42,[1,2]],[52,[1,2]],[54,[1,2]]]],[22960,[[4,fail]]],
 [22963,[[4,fail]]],
 [22977,[[5,[1]],[9,[2,3]],[17,[2,3]],[21,[1]],[29,[1]],[33,[2,3]],
     [41,[2,3]],[45,[1]],[53,[1]],[57,[2,3]]]],
 [22986,[[10,[1,1,2,1,2]],[18,[1,1,2,1,2]],[34,[1,1,2,1,2]],
     [42,[1,1,2,1,2]],[58,[1,1,2,1,2]],[66,[1,1,2,1,2]],[82,[1,1,2,1,2]],
     [90,[1,1,2,1,2]],[106,[1,1,2,1,2]],[114,[1,1,2,1,2]]]],
 [22989,[[10,[1,2,2]],[18,[1,2,2]],[34,[1,2,2]],[42,[1,2,2]],[58,[1,2,2]],
     [66,[1,2,2]],[82,[1,2,2]],[90,[1,2,2]],[106,[1,2,2]],[114,[1,2,2]]] 
  ],
 [23000,[[0,[1,1,1,2,2]],[9,[1,1,1,2,2]],[14,[1,1,1,2,2]],[21,[1,1,1,2,2]],
     [26,[1,1,1,2,2]],[33,[1,1,1,2,2]],[38,[1,1,1,2,2]],[45,[1,1,1,2,2]],
     [50,[1,1,1,2,2]],[57,[1,1,1,2,2]]]],
 [23005,[[0,[2,3]],[6,[1]],[14,[1]],[18,[2,3]],[26,[2,3]],[30,[1]],
     [38,[1]],[42,[2,3]],[50,[2,3]],[54,[1]]]],
 [23025,[[0,[1,2,2,2]],[9,[1,2,2,2]],[13,[1,2,2,2]],[21,[1,2,2,2]],
     [25,[1,2,2,2]],[33,[1,2,2,2]],[37,[1,2,2,2]],[45,[1,2,2,2]],
     [49,[1,2,2,2]],[57,[1,2,2,2]]]],
 [23030,[[2,[1,2]],[6,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[18,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[30,[1,2]]]],[23032,[[0,fail]]],
 [23033,[[0,fail]]],[23037,[[0,fail]]],[23038,[[0,fail]]],[23039,[[2,fail]]],
 [23040,[[2,fail]]],
 [23044,[[2,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [23048,[[4,[1]],[6,[1]],[14,[1]],[16,[1]],[22,[1]],[28,[1]],[30,[1]],
     [38,[1]],[40,[1]],[46,[1]]]],
 [23049,[[4,[1]],[8,[1]],[14,[1]],[20,[1]],[22,[1]],[30,[1]],[32,[1]],
     [38,[1]],[44,[1]],[46,[1]]]],
 [23050,[[1,[1]],[4,[1]],[5,[1]],[6,[1]],[10,[1]],[13,[1]],[16,[1]],
     [17,[1]],[18,[1]],[22,[1]]]],
 [23051,[[1,[1]],[2,[1]],[5,[1]],[6,[1]],[8,[1]],[13,[1]],[14,[1]],
     [17,[1]],[18,[1]],[20,[1]]]],
 [23052,[[2,[1,2]],[5,[1,2]],[8,[1,2]],[10,[1,2]],[13,[1,2]],[14,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[29,[1,2]]]],[23057,[[0,fail]]],
 [23058,[[0,fail]]],[23062,[[0,fail]]],[23063,[[0,fail]]],[23064,[[0,fail]]],
 [23065,[[2,fail]]],
 [23069,[[0,[1,2]],[12,[1,2]],[24,[1,2]],[36,[1,2]],[48,[1,2]],
     [60,[1,2]],[72,[1,2]],[84,[1,2]],[96,[1,2]],[108,[1,2]]]],
 [23076,[[8,[2,4]],[32,[2,4]],[56,[2,4]],[80,[2,4]],[104,[2,4]],
     [128,[2,4]],[152,[2,4]],[176,[2,4]],[200,[2,4]],[224,[2,4]]]],
 [23077,[[8,fail]]],[23078,[[8,fail]]],[23079,[[0,fail]]],
 [23086,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [23087,[[12,fail]]],[23088,[[4,fail]]],[23129,[[8,fail]]],[23131,[[4,fail]]],
 [23132,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [23133,[[12,[2,4]],[36,[2,4]],[60,[2,4]],[84,[2,4]],[108,[2,4]],
     [132,[2,4]],[156,[2,4]],[180,[2,4]],[204,[2,4]],[228,[2,4]]]],
 [23134,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [23135,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[46,[1,2]]]],
 [23136,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[46,[1,2]]]],
 [23140,[[0,[2,4]],[10,[2,4]],[20,[2,4]],[30,[2,4]],[40,[2,4]],
     [50,[2,4]],[60,[2,4]],[70,[2,4]],[80,[2,4]],[90,[2,4]]]],
 [23141,[[2,[1,2]],[4,[1,2]],[12,[1,2]],[14,[1,2]],[22,[1,2]],[24,[1,2]],
     [32,[1,2]],[34,[1,2]],[42,[1,2]],[44,[1,2]]]],
 [23143,[[6,[1,2]],[16,[1,2]],[26,[1,2]],[36,[1,2]],[46,[1,2]],
     [56,[1,2]],[66,[1,2]],[76,[1,2]],[86,[1,2]],[96,[1,2]]]],
 [23145,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23146,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [23150,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [23151,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [23152,[[2,[3]],[8,[3]],[14,[3]],[20,[3]],[26,[3]],[32,[3]],[38,[3]],
     [44,[3]],[50,[3]],[56,[3]]]],
 [23153,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [23156,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [23158,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [23159,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [23160,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [23163,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23165,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [23166,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [23173,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [23174,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [23175,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [23176,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23177,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [23178,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [23179,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [23183,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [23184,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [23185,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [23186,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [23190,[[2,[1,2]],[6,[1,2]],[16,[1,2]],[22,[1,2]],[26,[1,2]],[36,[1,2]],
     [42,[1,2]],[46,[1,2]],[56,[1,2]],[62,[1,2]]]],
 [23191,[[2,[1]],[6,[1]],[16,[1]],[22,[1]],[26,[1]],[36,[1]],[42,[1]],
     [46,[1]],[56,[1]],[62,[1]]]],
 [23192,[[3,[1]],[6,[1]],[18,[1]],[23,[1]],[26,[1]],[38,[1]],[43,[1]],
     [46,[1]],[58,[1]],[63,[1]]]],
 [23193,[[0,[1,1,2,1,2]],[10,[1,1,2,1,2]],[16,[1,1,2,1,2]],
     [20,[1,1,2,1,2]],[30,[1,1,2,1,2]],[36,[1,1,2,1,2]],[40,[1,1,2,1,2]],
     [50,[1,1,2,1,2]],[56,[1,1,2,1,2]],[60,[1,1,2,1,2]]]],
 [23194,[[0,[1,2,2,2]],[10,[1,2,2,2]],[16,[1,2,2,2]],[20,[1,2,2,2]],
     [30,[1,2,2,2]],[36,[1,2,2,2]],[40,[1,2,2,2]],[50,[1,2,2,2]],
     [56,[1,2,2,2]],[60,[1,2,2,2]]]],
 [23195,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [23199,[[2,[1,1,1,1,1,2]],[32,[1,1,1,1,1,2]],[38,[1,1,1,1,1,2]],
     [46,[1,1,1,1,1,2]],[62,[1,1,1,1,1,2]],[92,[1,1,1,1,1,2]],
     [98,[1,1,1,1,1,2]],[106,[1,1,1,1,1,2]],[122,[1,1,1,1,1,2]],
     [152,[1,1,1,1,1,2]]]],
 [23200,[[3,[1,1,1,1,1,1,2,2]],[6,[1,2]],[15,[1,1,1,1,1,1,2,2]],[36,[1,2]],
     [38,[1,1,1,1,1,1,2,2]],[43,[1,2]],[51,[1,1,1,1,1,1,2,2]],
     [63,[1,1,1,1,1,1,2,2]],[66,[1,2]],[75,[1,1,1,1,1,1,2,2]]]],
 [23201,[[6,[1]],[36,[1]],[43,[1]],[66,[1]],[96,[1]],[103,[1]],
     [126,[1]],[156,[1]],[163,[1]],[186,[1]]]],
 [23204,[[3,[1,2,3,2,2,2,2,3]],[16,[1,2,3,2,2,2,2,3]],[20,[1,2,3,2,2,2,2,3]]
      ,[32,[1]],[43,[1,2,3,2,2,2,2,3]],[46,[1,2,3,2,2,2,2,3]],
     [56,[1,2,3,2,2,2,2,3]],[63,[1,2,3,2,2,2,2,3]],[76,[1,2,3,2,2,2,2,3]],
     [80,[1,2,3,2,2,2,2,3]]]],
 [23205,[[2,[1,2,1,2,2]],[20,[1,2,1,2,2]],[32,[1,2,1,2,2]],
     [46,[1,2,1,2,2]],[50,[1,2,1,2,2]],[62,[1,2,1,2,2]],[80,[1,2,1,2,2]],
     [92,[1,2,1,2,2]],[106,[1,2,1,2,2]],[110,[1,2,1,2,2]]]],
 [23206,[[2,[1,1,2,2]],[6,[1,2]],[23,[1,1,2,2]],[26,[1,1,2,2]],
     [32,[1,1,2,2]],[36,[1,2]],[38,[1,1,2,2]],[43,[1,2]],[56,[1,1,2,2]],
     [62,[1,1,2,2]]]],
 [23211,[[18,[2,3,3]],[78,[2,3,3]],[138,[2,3,3]],[198,[2,3,3]]]],
 [23214,[[6,[1,2]],[36,[1,2]],[43,[1,2]],[66,[1,2]],[96,[1,2]],
     [103,[1,2]],[126,[1,2]],[156,[1,2]],[163,[1,2]],[186,[1,2]]]],
 [23217,[[6,[1,1,1,1,2,2,2,3]],[18,[1,1,1,1,2,2,2,3]],[26,[1,1,1,1,2,2,2,3]]
      ,[30,[1]],[42,[1,1,1,1,2,2,2,3]],[56,[1,1,1,1,2,2,2,3]],
     [66,[1,1,1,1,2,2,2,3]],[78,[1,1,1,1,2,2,2,3]],[86,[1,1,1,1,2,2,2,3]],
     [90,[1]]]],
 [23218,[[23,[2,3,3]],[83,[2,3,3]],[143,[2,3,3]],[203,[2,3,3]]]],
 [23223,[[0,[1,2,3,2,3]],[20,[1,2,3,2,3]],[32,[1,2,3,2,3]],
     [35,[1,2,3,2,3]],[43,[1,2,3,2,3]],[50,[1,2,3,2,3]],[62,[1,2,3,2,3]],
     [80,[1,2,3,2,3]],[92,[1,2,3,2,3]],[95,[1,2,3,2,3]]]],
 [23224,[[6,[2,2,2,3]],[20,[2,2,2,3]],[43,[2,2,2,3]],[50,[2,2,2,3]],
     [66,[2,2,2,3]],[80,[2,2,2,3]],[103,[2,2,2,3]],[110,[2,2,2,3]],
     [126,[2,2,2,3]],[140,[2,2,2,3]]]],
 [23227,[[0,[2,2,3,3]],[6,[3,5,4,4]],[18,[2,2,3,3]],[23,[4,4,6,6]],
     [26,[4,4,6,6]],[27,[1,2]],[30,[2,2,3,3]],[36,[3,5,4,4]],[42,[1,2]],
     [56,[4,4,6,6]]]],
 [23228,[[3,[5]],[16,[5]],[27,[1]],[36,[5]],[42,[1]],[46,[5]],[63,[5]],
     [76,[5]],[87,[1]],[96,[5]]]],
 [23244,[[2,[1,2]],[6,[1,2]],[16,[1,2]],[22,[1,2]],[26,[1,2]],[36,[1,2]],
     [42,[1,2]],[46,[1,2]],[56,[1,2]],[62,[1,2]]]],
 [23245,[[6,[3,4]],[26,[3,4]],[46,[3,4]],[66,[3,4]],[86,[3,4]],
     [106,[3,4]],[126,[3,4]],[146,[3,4]],[166,[3,4]],[186,[3,4]]]],
 [23246,[[6,[3,4]],[26,[3,4]],[46,[3,4]],[66,[3,4]],[86,[3,4]],
     [106,[3,4]],[126,[3,4]],[146,[3,4]],[166,[3,4]],[186,[3,4]]]],
 [23247,[[7,[1]],[27,[1]],[47,[1]],[67,[1]],[87,[1]],[107,[1]],
     [127,[1]],[147,[1]],[167,[1]],[187,[1]]]],
 [23248,[[2,[1]],[7,[1]],[10,[1]],[15,[1]],[22,[1]],[27,[1]],[30,[1]],
     [35,[1]],[42,[1]],[47,[1]]]],
 [23249,[[0,[1,2]],[6,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],[36,[1,2]],
     [40,[1,2]],[46,[1,2]],[56,[1,2]],[60,[1,2]]]],
 [23250,[[0,[1,2]],[6,[1,2]],[16,[1,2]],[20,[1,2]],[26,[1,2]],[36,[1,2]],
     [40,[1,2]],[46,[1,2]],[56,[1,2]],[60,[1,2]]]],
 [23251,[[7,[1]],[27,[1]],[47,[1]],[67,[1]],[87,[1]],[107,[1]],
     [127,[1]],[147,[1]],[167,[1]],[187,[1]]]],
 [23252,[[7,[2,2,3,3]],[14,[1,2]],[44,[1,2]],[46,[2,2,3,3]],
     [67,[2,2,3,3]],[74,[1,2]],[104,[1,2]],[106,[2,2,3,3]],
     [127,[2,2,3,3]],[134,[1,2]]]],
 [23253,[[2,[1,1,1,2,1,1,2,2]],[7,[1]],[15,[1,1,1,2,1,1,2,2]],
     [26,[1,1,1,2,1,1,2,2]],[27,[1]],[39,[1,1,1,2,1,1,2,2]],[47,[1]],
     [56,[1,1,1,2,1,1,2,2]],[62,[1,1,1,2,1,1,2,2]],[67,[1]]]],
 [23254,[[7,[1,1,1,2]],[10,[1,1,1,2]],[14,[1,2]],[16,[1]],[26,[1,1,1,2]],
     [40,[1,1,1,2]],[44,[1,2]],[46,[1]],[56,[1,1,1,2]],[67,[1,1,1,2]]]],
 [23255,[[4,[1,1,1,2]],[26,[4]],[34,[1,1,1,2]],[47,[1,1,1,2]],
     [64,[1,1,1,2]],[86,[4]],[94,[1,1,1,2]],[107,[1,1,1,2]],
     [124,[1,1,1,2]],[146,[4]]]],
 [23256,[[7,[1,1,2,2]],[26,[4]],[47,[1,1,2,2]],[67,[1,1,2,2]],[86,[4]],
     [107,[1,1,2,2]],[127,[1,1,2,2]],[146,[4]],[167,[1,1,2,2]],
     [187,[1,1,2,2]]]],
 [23259,[[7,[3,3,4,4]],[14,[1,2]],[44,[1,2]],[47,[3,3,4,4]],
     [67,[3,3,4,4]],[74,[1,2]],[104,[1,2]],[107,[3,3,4,4]],
     [127,[3,3,4,4]],[134,[1,2]]]],
 [23260,[[7,[1]],[27,[1]],[47,[1]],[67,[1]],[87,[1]],[107,[1]],
     [127,[1]],[147,[1]],[167,[1]],[187,[1]]]],
 [23261,[[4,[1,1,1,2]],[6,[1,2]],[22,[1,2]],[26,[1,2]],[34,[1,1,1,2]],
     [36,[1,2]],[47,[1,1,1,2]],[56,[1,2]],[64,[1,1,1,2]],[66,[1,2]]]],
 [23262,[[6,[1,2]],[7,[1,1,2,2]],[36,[1,2]],[42,[1,2]],[47,[1,1,2,2]],
     [66,[1,2]],[67,[1,1,2,2]],[96,[1,2]],[102,[1,2]],[107,[1,1,2,2]]]],
 [23263,[[0,[2,3,4,6]],[16,[2,3,4,6]],[27,[1]],[35,[2,3,4,6]],
     [46,[2,3,4,6]],[47,[2,3,4,6]],[60,[2,3,4,6]],[76,[2,3,4,6]],
     [87,[1]],[95,[2,3,4,6]]]],
 [23264,[[6,[3]],[27,[1]],[42,[3]],[66,[3]],[87,[1]],[102,[3]],
     [126,[3]],[147,[1]],[162,[3]],[186,[3]]]],
 [23265,[[4,[1,1,2,3]],[24,[1,1,2,3]],[27,[4]],[34,[1,1,2,3]],
     [54,[1,1,2,3]],[64,[1,1,2,3]],[84,[1,1,2,3]],[87,[4]],
     [94,[1,1,2,3]],[114,[1,1,2,3]]]],
 [23266,[[6,[1]],[7,[1,1,1,2]],[36,[1]],[42,[1]],[47,[1,1,1,2]],
     [66,[1]],[67,[1,1,1,2]],[96,[1]],[102,[1]],[107,[1,1,1,2]]]],
 [23267,[[6,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[27,[1,2]],[36,[1,1,2]],
     [40,[1,1,2]],[42,[1,1,2]],[55,[1,1,2]],[66,[1,1,2]],[67,[1,1,2]]]],
 [23271,[[6,[2,3,4,3]],[27,[1]],[47,[2,3,4,3]],[66,[2,3,4,3]],[87,[1]],
     [107,[2,3,4,3]],[126,[2,3,4,3]],[147,[1]],[167,[2,3,4,3]],
     [186,[2,3,4,3]]]],
 [23273,[[7,[1,1,2,2]],[24,[2]],[47,[1,1,2,2]],[67,[1,1,2,2]],[84,[2]],
     [107,[1,1,2,2]],[127,[1,1,2,2]],[144,[2]],[167,[1,1,2,2]],
     [187,[1,1,2,2]]]],
 [23275,[[7,[1,1,2,3]],[24,[2]],[26,[1,1,2,3]],[56,[1,1,2,3]],
     [67,[1,1,2,3]],[84,[2]],[86,[1,1,2,3]],[116,[1,1,2,3]],
     [127,[1,1,2,3]],[144,[2]]]],
 [23276,[[0,[2,2,4,4]],[16,[2,2,4,4]],[26,[2,2,4,4]],[27,[1]],
     [35,[2,2,4,4]],[46,[2,2,4,4]],[56,[2,2,4,4]],[62,[2,2,4,4]],
     [76,[2,2,4,4]],[86,[2,2,4,4]]]],
 [23277,[[6,[3,3,3,4]],[26,[3,3,3,4]],[27,[1]],[56,[3,3,3,4]],
     [66,[3,3,3,4]],[86,[3,3,3,4]],[87,[1]],[116,[3,3,3,4]],
     [126,[3,3,3,4]],[146,[3,3,3,4]]]],
 [23278,[[2,[1]],[16,[1]],[27,[1,2]],[46,[1]],[47,[1]],[62,[1]],
     [76,[1]],[87,[1,2]],[106,[1]],[107,[1]]]],
 [23281,[[6,[3]],[10,[3]],[27,[1,2]],[40,[3]],[51,[3]],[66,[3]],
     [70,[3]],[87,[1,2]],[100,[3]],[111,[3]]]],
 [23285,[[7,[1]],[19,[1,2]],[47,[1]],[59,[1,2]],[67,[1]],[99,[1,2]],
     [107,[1]],[127,[1]],[139,[1,2]],[167,[1]]]],
 [23293,[[6,[1,1,1,2]],[27,[1]],[35,[1,1,1,2]],[67,[1,1,1,2]],
     [75,[1,1,1,2]],[87,[1]],[115,[1,1,1,2]],[127,[1,1,1,2]],[147,[1]],
     [155,[1,1,1,2]]]],
 [23300,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [23304,[[12,[1]],[32,[1,2,2]],[42,[1]],[72,[1]],[92,[1,2,2]],[102,[1]],
     [132,[1]],[152,[1,2,2]],[162,[1]],[192,[1]]]],
 [23305,[[2,[1,1,2,2,2,1,2,3]],[12,[1,2]],[15,[1,1,2,2,2,1,2,3]],
     [18,[1,1,2,2,2,1,2,3]],[42,[1,2]],[48,[1,1,2,2,2,1,2,3]],
     [51,[1,1,2,2,2,1,2,3]],[62,[1,1,2,2,2,1,2,3]],[72,[1,2]],
     [75,[1,1,2,2,2,1,2,3]]]],
 [23309,[[8,[1,1,1,1,1,2,2,3]],[20,[1,1,1,1,1,2,2,3]],[22,[1,1,1,1,1,2,2,3]]
      ,[28,[1,1,1,1,1,2,2,3]],[32,[2,3]],[52,[1,1,1,1,1,2,2,3]],
     [58,[1,1,1,1,1,2,2,3]],[68,[1,1,1,1,1,2,2,3]],[80,[1,1,1,1,1,2,2,3]],
     [82,[1,1,1,1,1,2,2,3]]]],
 [23310,[[12,[1,2]],[32,[1,2]],[42,[1,2]],[72,[1,2]],[92,[1,2]],
     [102,[1,2]],[132,[1,2]],[152,[1,2]],[162,[1,2]],[192,[1,2]]]],
 [23311,[[8,[3,4]],[11,[3,4]],[12,[2]],[20,[3,4]],[26,[3,4]],[38,[3,4]],
     [42,[2]],[50,[3,4]],[56,[3,4]],[68,[3,4]]]],
 [23314,[[8,[1,2,2]],[38,[1,2,2]],[68,[1,2,2]],[98,[1,2,2]],[128,[1,2,2]],
     [158,[1,2,2]],[188,[1,2,2]],[218,[1,2,2]],[248,[1,2,2]]]],
 [23315,[[30,[1,1,1,2,2]],[90,[1,1,1,2,2]],[150,[1,1,1,2,2]],
     [210,[1,1,1,2,2]]]],
 [23317,[[0,[1]],[16,[1]],[22,[1]],[30,[1]],[31,[1]],[46,[1]],[52,[1]],
     [60,[1]],[76,[1]],[82,[1]]]],
 [23322,[[2,[1,1,2,2,3,3,1,2]],[8,[1,1,2,2,3,3,1,2]],[30,[1]],
     [32,[1,1,2,2,3,3,1,2]],[38,[1,1,2,2,3,3,1,2]],[42,[1,1,2,2,3,3,1,2]],
     [52,[1,1,2,2,3,3,1,2]],[62,[1,1,2,2,3,3,1,2]],[68,[1,1,2,2,3,3,1,2]],
     [90,[1]]]],
 [23325,[[12,[1,1,1,2,2,1,2]],[28,[1,1,1,2,2,1,2]],[58,[1,1,1,2,2,1,2]],
     [72,[1,1,1,2,2,1,2]],[88,[1,1,1,2,2,1,2]],[118,[1,1,1,2,2,1,2]],
     [132,[1,1,1,2,2,1,2]],[148,[1,1,1,2,2,1,2]],[178,[1,1,1,2,2,1,2]],
     [192,[1,1,1,2,2,1,2]]]],
 [23329,[[8,[1,2,1,2,2,2]],[28,[1,2,1,2,2,2]],[38,[1,2,1,2,2,2]],
     [58,[1,2,1,2,2,2]],[68,[1,2,1,2,2,2]],[88,[1,2,1,2,2,2]],
     [98,[1,2,1,2,2,2]],[118,[1,2,1,2,2,2]],[128,[1,2,1,2,2,2]],
     [148,[1,2,1,2,2,2]]]],
 [23333,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [23337,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [23349,[[6,[2,2,3]],[26,[2,2,3]],[46,[2,2,3]],[66,[2,2,3]],[86,[2,2,3]],
     [106,[2,2,3]],[126,[2,2,3]],[146,[2,2,3]],[166,[2,2,3]],
     [186,[2,2,3]]]],
 [23351,[[10,[3,4]],[30,[3,4]],[50,[3,4]],[70,[3,4]],[90,[3,4]],
     [110,[3,4]],[130,[3,4]],[150,[3,4]],[170,[3,4]],[190,[3,4]]]],
 [23352,[[10,[2,2,3]],[30,[2,2,3]],[50,[2,2,3]],[70,[2,2,3]],[90,[2,2,3]],
     [110,[2,2,3]],[130,[2,2,3]],[150,[2,2,3]],[170,[2,2,3]],
     [190,[2,2,3]]]],
 [23353,[[0,[1]],[6,[1]],[11,[1]],[15,[1]],[20,[1]],[26,[1]],[31,[1]],
     [35,[1]],[40,[1]],[46,[1]]]],
 [23354,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [23356,[[3,[1,1,1,1,1,1,1,2]],[8,[1,1,1,1,1,1,1,2]],[26,[2]],
     [38,[1,1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,1,2]],[51,[1,1,1,1,1,1,1,2]],
     [63,[1,1,1,1,1,1,1,2]],[68,[1,1,1,1,1,1,1,2]],[86,[2]],
     [98,[1,1,1,1,1,1,1,2]]]],
 [23359,[[26,[1,1,2]],[86,[1,1,2]],[146,[1,1,2]],[206,[1,1,2]]]],
 [23360,[[8,[1,1,2,2,2,2,1,2]],[20,[1,1,2,2,2,2,1,2]],[28,[1,1,2,2,2,2,1,2]]
      ,[30,[2]],[44,[1,1,2,2,2,2,1,2]],[58,[1,1,2,2,2,2,1,2]],
     [68,[1,1,2,2,2,2,1,2]],[80,[1,1,2,2,2,2,1,2]],[88,[1,1,2,2,2,2,1,2]],
     [90,[2]]]],
 [23367,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [23368,[[4,[2]],[10,[1]],[11,[1]],[19,[2]],[24,[2]],[34,[2]],[40,[1]],
     [46,[2]],[54,[2]],[55,[1]]]],
 [23373,[[6,[1,1,1,1,1,1,1,2]],[18,[1,1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,1,2]]
      ,[30,[2]],[50,[1,1,1,1,1,1,1,2]],[54,[1,1,1,1,1,1,1,2]],
     [66,[1,1,1,1,1,1,1,2]],[78,[1,1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,1,2]],
     [90,[2]]]],
 [23374,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [23375,[[4,[2,2,2,3]],[8,[2]],[10,[4,4,4,6]],[28,[2,2,2,3]],[31,[2]],
     [34,[2,2,2,3]],[38,[2]],[40,[4,4,4,6]],[46,[2]],[50,[2,2,2,3]]]],
 [23378,[[6,[1,1,2]],[48,[1,1,2]],[66,[1,1,2]],[108,[1,1,2]],[126,[1,1,2]],
     [168,[1,1,2]],[186,[1,1,2]],[228,[1,1,2]],[246,[1,1,2]]]],
 [23379,[[8,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]],[26,[1,2,1,2,3]],
     [28,[1,2,1,2,3]],[31,[2,2,3]],[38,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]],
     [46,[2,2,3]],[58,[1,2,1,2,3]],[68,[3,4,4,4,5,4,4,3,5,5,3,5,3,4,6]],
     [86,[1,2,1,2,3]],[88,[1,2,1,2,3]]]],
 [23380,[[30,[1]],[31,[1]],[90,[1]],[91,[1]],[150,[1]],[151,[1]],
     [210,[1]],[211,[1]]]],
 [23382,[[3,[1]],[4,[2]],[11,[2]],[18,[1]],[24,[2]],[34,[2]],[39,[2]],
     [46,[1]],[48,[1]],[54,[2]]]],
 [23383,[[0,[2,2,2,3]],[6,[2,2,2,3]],[11,[2]],[18,[4,4,4,6]],[20,[2]],
     [24,[2,2,2,3]],[26,[2]],[30,[2,2,2,3]],[48,[4,4,4,6]],[50,[2]]]],
 [23384,[[30,[1]],[90,[1]],[150,[1]],[210,[1]]]],
 [23400,[[0,[1,1,1,2,2]],[10,[1,1,1,2,2]],[16,[1,1,1,2,2]],
     [20,[1,1,1,2,2]],[30,[1,1,1,2,2]],[36,[1,1,1,2,2]],[40,[1,1,1,2,2]],
     [50,[1,1,1,2,2]],[56,[1,1,1,2,2]],[60,[1,1,1,2,2]]]],
 [23401,[[2,[1,2]],[12,[1,2]],[15,[1,2]],[22,[1,2]],[32,[1,2]],
     [35,[1,2]],[42,[1,2]],[52,[1,2]],[55,[1,2]],[62,[1,2]]]],
 [23403,[[2,[1]],[12,[1]],[15,[1]],[22,[1]],[32,[1]],[35,[1]],[42,[1]],
     [52,[1]],[55,[1]],[62,[1]]]],
 [23408,[[26,[2,3,3]],[86,[2,3,3]],[146,[2,3,3]],[206,[2,3,3]]]],
 [23418,[[4,[2,3]],[10,[2,3]],[12,[2,3]],[19,[2,3]],[24,[2,3]],
     [34,[2,3]],[40,[2,3]],[42,[2,3]],[54,[2,3]],[55,[2,3]]]],
 [23419,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [23426,[[10,[1]],[26,[1]],[40,[1]],[56,[1]],[70,[1]],[86,[1]],
     [100,[1]],[116,[1]],[130,[1]],[146,[1]]]],
 [23430,[[20,[2,2,3]],[50,[2,2,3]],[80,[2,2,3]],[110,[2,2,3]],
     [140,[2,2,3]],[170,[2,2,3]],[200,[2,2,3]],[230,[2,2,3]]]],
 [23432,[[12,[2,2,3]],[27,[2,2,3]],[42,[2,2,3]],[72,[2,2,3]],[87,[2,2,3]],
     [102,[2,2,3]],[132,[2,2,3]],[147,[2,2,3]],[162,[2,2,3]],
     [192,[2,2,3]]]],[23436,[[6,fail]]],
 [23438,[[6,[1,2,2]],[19,[1,2,2]],[36,[1,2,2]],[39,[1,2,2]],[59,[1,2,2]],
     [66,[1,2,2]],[79,[1,2,2]],[96,[1,2,2]],[99,[1,2,2]],[119,[1,2,2]]]]
  ,
 [23446,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [23450,[[10,[4]],[30,[4]],[50,[4]],[70,[4]],[90,[4]],[110,[4]],
     [130,[4]],[150,[4]],[170,[4]],[190,[4]]]],
 [23452,[[0,[1]],[11,[1]],[16,[1]],[20,[1]],[31,[1]],[36,[1]],[40,[1]],
     [51,[1]],[56,[1]],[60,[1]]]],
 [23453,[[10,[2,3,3]],[30,[2,3,3]],[50,[2,3,3]],[70,[2,3,3]],[90,[2,3,3]],
     [110,[2,3,3]],[130,[2,3,3]],[150,[2,3,3]],[170,[2,3,3]],
     [190,[2,3,3]]]],
 [23455,[[0,[1,1,1,2,2,2,2,2]],[15,[1,1,1,2,2,2,2,2]],[27,[1]],
     [30,[1,1,1,2,2,2,2,2]],[36,[1,1,1,2,2,2,2,2]],[51,[1,1,1,2,2,2,2,2]],
     [60,[1,1,1,2,2,2,2,2]],[75,[1,1,1,2,2,2,2,2]],[87,[1]],
     [90,[1,1,1,2,2,2,2,2]]]],
 [23463,[[10,[4]],[40,[4]],[70,[4]],[100,[4]],[130,[4]],[160,[4]],
     [190,[4]],[220,[4]],[250,[4]]]],
 [23465,[[0,[1]],[30,[1]],[36,[1]],[47,[1]],[60,[1]],[90,[1]],[96,[1]],
     [107,[1]],[120,[1]],[150,[1]]]],
 [23469,[[30,[1,2,2,2,3,3,2]],[90,[1,2,2,2,3,3,2]],[150,[1,2,2,2,3,3,2]],
     [210,[1,2,2,2,3,3,2]]]],
 [23477,[[30,[5,5,6]],[90,[5,5,6]],[150,[5,5,6]],[210,[5,5,6]]]],
 [23478,[[8,[1,1,1,1,1,1,2]],[38,[1,1,1,1,1,1,2]],[47,[1,1,1,1,1,1,2]],
     [68,[1,1,1,1,1,1,2]],[98,[1,1,1,1,1,1,2]],[107,[1,1,1,1,1,1,2]],
     [128,[1,1,1,1,1,1,2]],[158,[1,1,1,1,1,1,2]],[167,[1,1,1,1,1,1,2]],
     [188,[1,1,1,1,1,1,2]]]],
 [23481,[[0,[2,3,3,4,3]],[30,[2,3,3,4,3]],[31,[2,3,3,4,3]],
     [36,[2,3,3,4,3]],[60,[2,3,3,4,3]],[90,[2,3,3,4,3]],[91,[2,3,3,4,3]],
     [96,[2,3,3,4,3]],[120,[2,3,3,4,3]],[150,[2,3,3,4,3]]]],
 [23483,[[3,[1,1,1,1,2,2,1,2,3]],[16,[1,1,1,1,2,2,1,2,3]],
     [18,[1,1,1,1,2,2,1,2,3]],[27,[1,1,1,1,2,2,1,2,3]],
     [28,[1,1,1,1,2,2,1,2,3]],[48,[1,1,1,1,2,2,1,2,3]],
     [58,[1,1,1,1,2,2,1,2,3]],[63,[1,1,1,1,2,2,1,2,3]],
     [76,[1,1,1,1,2,2,1,2,3]],[78,[1,1,1,1,2,2,1,2,3]]]],
 [23499,[[10,[3,4]],[30,[3,4]],[50,[3,4]],[70,[3,4]],[90,[3,4]],
     [110,[3,4]],[130,[3,4]],[150,[3,4]],[170,[3,4]],[190,[3,4]]]],
 [23500,[[2,[1,2]],[12,[1,2]],[15,[1,2]],[22,[1,2]],[32,[1,2]],
     [35,[1,2]],[42,[1,2]],[52,[1,2]],[55,[1,2]],[62,[1,2]]]],
 [23501,[[10,[4]],[30,[4]],[50,[4]],[70,[4]],[90,[4]],[110,[4]],
     [130,[4]],[150,[4]],[170,[4]],[190,[4]]]],
 [23502,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [23504,[[4,[1,2]],[12,[1,2]],[30,[1]],[34,[1,2]],[42,[1,2]],[55,[1,2]],
     [64,[1,2]],[72,[1,2]],[90,[1]],[94,[1,2]]]],
 [23505,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [23506,[[8,[2,3,4,3]],[30,[1]],[50,[2,3,4,3]],[68,[2,3,4,3]],[90,[1]],
     [110,[2,3,4,3]],[128,[2,3,4,3]],[150,[1]],[170,[2,3,4,3]],
     [188,[2,3,4,3]]]],
 [23508,[[10,[1,2,2]],[12,[1,2,2]],[30,[1]],[42,[1,2,2]],[55,[1,2,2]],
     [70,[1,2,2]],[72,[1,2,2]],[90,[1]],[102,[1,2,2]],[115,[1,2,2]]]],
 [23509,[[2,[2,3,4]],[30,[1]],[32,[2,3,4]],[35,[2,3,4]],[50,[2,3,4]],
     [62,[2,3,4]],[90,[1]],[92,[2,3,4]],[95,[2,3,4]],[110,[2,3,4]]]],
 [23510,[[10,[1,1,1,2]],[24,[1,1,1,2]],[30,[4]],[54,[1,1,1,2]],
     [70,[1,1,1,2]],[84,[1,1,1,2]],[90,[4]],[114,[1,1,1,2]],
     [130,[1,1,1,2]],[144,[1,1,1,2]]]],
 [23511,[[2,[1,2]],[10,[1,1,1,2]],[22,[1,2]],[24,[1,1,1,2]],[32,[1,2]],
     [35,[1,2]],[52,[1,2]],[54,[1,1,1,2]],[62,[1,2]],[70,[1,1,1,2]]]],
 [23512,[[7,[1,1,2,2]],[30,[2]],[48,[1,1,2,2]],[67,[1,1,2,2]],[90,[2]],
     [108,[1,1,2,2]],[127,[1,1,2,2]],[150,[2]],[168,[1,1,2,2]],
     [187,[1,1,2,2]]]],
 [23514,[[7,[1,1,2,2]],[30,[4]],[48,[1,1,2,2]],[67,[1,1,2,2]],[90,[4]],
     [108,[1,1,2,2]],[127,[1,1,2,2]],[150,[4]],[168,[1,1,2,2]],
     [187,[1,1,2,2]]]],
 [23516,[[10,[1]],[12,[1]],[30,[1,2]],[42,[1]],[55,[1]],[70,[1]],
     [72,[1]],[90,[1,2]],[102,[1]],[115,[1]]]],
 [23517,[[4,[1,1,2,2]],[24,[1,1,2,2]],[30,[4]],[34,[1,1,2,2]],
     [54,[1,1,2,2]],[64,[1,1,2,2]],[84,[1,1,2,2]],[90,[4]],
     [94,[1,1,2,2]],[114,[1,1,2,2]]]],
 [23520,[[2,[1,1,1,2,1,1,2,2]],[10,[1]],[18,[1,1,1,2,1,1,2,2]],[30,[1]],
     [32,[1,1,1,2,1,1,2,2]],[42,[1,1,1,2,1,1,2,2]],[50,[1]],
     [54,[1,1,1,2,1,1,2,2]],[62,[1,1,1,2,1,1,2,2]],[70,[1]]]],
 [23521,[[10,[1,1,2,2]],[30,[4]],[48,[1,1,2,2]],[70,[1,1,2,2]],[90,[4]],
     [108,[1,1,2,2]],[130,[1,1,2,2]],[150,[4]],[168,[1,1,2,2]],
     [190,[1,1,2,2]]]],
 [23523,[[10,[1,1,2,2]],[12,[1,2]],[22,[1,2]],[48,[1,1,2,2]],[52,[1,2]],
     [70,[1,1,2,2]],[72,[1,2]],[82,[1,2]],[108,[1,1,2,2]],[112,[1,2]]]],
 [23525,[[2,[1,1,2,3]],[30,[2]],[32,[1,1,2,3]],[50,[1,1,2,3]],
     [62,[1,1,2,3]],[90,[2]],[92,[1,1,2,3]],[110,[1,1,2,3]],
     [122,[1,1,2,3]],[150,[2]]]],
 [23528,[[10,[1,1,1,2]],[15,[1]],[22,[1]],[50,[1,1,1,2]],[52,[1]],
     [70,[1,1,1,2]],[75,[1]],[82,[1]],[110,[1,1,1,2]],[112,[1]]]],
 [23529,[[4,[1,1,2,3]],[24,[1,1,2,3]],[30,[4]],[34,[1,1,2,3]],
     [54,[1,1,2,3]],[64,[1,1,2,3]],[84,[1,1,2,3]],[90,[4]],
     [94,[1,1,2,3]],[114,[1,1,2,3]]]],
 [23531,[[3,[1,2,2,2]],[15,[1,2,2,2]],[22,[1,2,2,2]],[30,[4]],
     [48,[1,2,2,2]],[52,[1,2,2,2]],[63,[1,2,2,2]],[75,[1,2,2,2]],
     [82,[1,2,2,2]],[90,[4]]]],
 [23535,[[7,[2,2,2,3]],[35,[1,1,1,2]],[50,[2,2,2,3]],[55,[1,1,1,2]],
     [87,[2,2,2,3]],[90,[2]],[95,[1,1,1,2]],[115,[1,1,1,2]],
     [155,[1,1,1,2]],[167,[2,2,2,3]]]],
 [23536,[[10,[1,2,2,2,1,2,2,2,1,2,2,3]],[30,[1]],
     [35,[1,2,2,2,1,2,2,2,1,2,2,3]],[70,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [75,[1,2,2,2,1,2,2,2,1,2,2,3]],[79,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [90,[1]],[119,[1,2,2,2,1,2,2,2,1,2,2,3]],[150,[1]],
     [155,[1,2,2,2,1,2,2,2,1,2,2,3]]]],
 [23543,[[10,[1]],[23,[1,2]],[50,[1]],[63,[1,2]],[70,[1]],[103,[1,2]],
     [110,[1]],[130,[1]],[143,[1,2]],[170,[1]]]],
 [23547,[[0,[1]],[6,[1]],[16,[1]],[20,[1]],[26,[1]],[36,[1]],[40,[1]],
     [46,[1]],[56,[1]],[60,[1]]]],
 [23556,[[11,[4]],[26,[4]],[56,[4]],[71,[4]],[86,[4]],[116,[4]],
     [131,[4]],[146,[4]],[176,[4]],[191,[4]]]],
 [23557,[[30,[2,3,3]],[90,[2,3,3]],[150,[2,3,3]],[210,[2,3,3]]]],
 [23559,[[0,[1]],[18,[1]],[30,[1]],[48,[1]],[60,[1]],[78,[1]],[90,[1]],
     [108,[1]],[120,[1]],[138,[1]]]],
 [23560,[[18,[2,3]],[48,[2,3]],[78,[2,3]],[108,[2,3]],[138,[2,3]],
     [168,[2,3]],[198,[2,3]],[228,[2,3]]]],
 [23562,[[16,[2,2,3]],[31,[2,2,3]],[46,[2,2,3]],[76,[2,2,3]],[91,[2,2,3]],
     [106,[2,2,3]],[136,[2,2,3]],[151,[2,2,3]],[166,[2,2,3]],
     [196,[2,2,3]]]],
 [23564,[[30,[1,2,2,3]],[90,[1,2,2,3]],[150,[1,2,2,3]],[210,[1,2,2,3]]]],
 [23573,[[8,[3,4]],[20,[3,4]],[38,[3,4]],[50,[3,4]],[68,[3,4]],
     [80,[3,4]],[98,[3,4]],[110,[3,4]],[128,[3,4]],[140,[3,4]]]],
 [23574,[[18,[1,2,2]],[26,[1,2,2]],[56,[1,2,2]],[78,[1,2,2]],[86,[1,2,2]],
     [116,[1,2,2]],[138,[1,2,2]],[146,[1,2,2]],[176,[1,2,2]],
     [198,[1,2,2]]]],
 [23575,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [23576,[[3,[2,3]],[4,[2,3]],[16,[2,3]],[18,[2,3]],[24,[2,3]],[34,[2,3]],
     [39,[2,3]],[46,[2,3]],[48,[2,3]],[54,[2,3]]]],
 [23578,[[6,[1,1,1,1,1,2,2]],[36,[1,1,1,1,1,2,2]],[66,[1,1,1,1,1,2,2]],
     [96,[1,1,1,1,1,2,2]],[126,[1,1,1,1,1,2,2]],[156,[1,1,1,1,1,2,2]],
     [186,[1,1,1,1,1,2,2]],[216,[1,1,1,1,1,2,2]],[246,[1,1,1,1,1,2,2]]]],
 [23579,[[8,fail]]],
 [23582,[[0,[1,1,1,2]],[8,[1,1,1,2]],[18,[1,1,1,2]],[19,[1,1,1,2]],
     [30,[1,1,1,2]],[38,[1,1,1,2]],[39,[1,1,1,2]],[48,[1,1,1,2]],
     [59,[1,1,1,2]],[60,[1,1,1,2]]]],
 [23583,[[0,[1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,2]],[18,[1,1,1,1,1,1,2]],
     [23,[1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,2]],[40,[1,1,1,1,1,1,2]],
     [43,[1,1,1,1,1,1,2]],[48,[1,1,1,1,1,1,2]],[58,[1,1,1,1,1,1,2]],
     [63,[1,1,1,1,1,1,2]]]],
 [23590,[[8,[1]],[28,[1]],[38,[1]],[58,[1]],[68,[1]],[88,[1]],[98,[1]],
     [118,[1]],[128,[1]],[148,[1]]]],
 [23596,[[0,[1,2,2,1,2,2,2,2]],[12,[1,2]],[15,[1,2,2,1,2,2,2,2]],
     [39,[1,2,2,1,2,2,2,2]],[42,[1,2]],[51,[1,2,2,1,2,2,2,2]],
     [60,[1,2,2,1,2,2,2,2]],[72,[1,2]],[75,[1,2,2,1,2,2,2,2]],
     [99,[1,2,2,1,2,2,2,2]]]],
 [23604,[[12,[1]],[16,[1]],[42,[1]],[46,[1]],[72,[1]],[76,[1]],
     [102,[1]],[106,[1]],[132,[1]],[136,[1]]]],
 [23608,[[6,[1,1,2,1,2]],[36,[1,1,2,1,2]],[40,[1,1,2,1,2]],
     [66,[1,1,2,1,2]],[96,[1,1,2,1,2]],[100,[1,1,2,1,2]],
     [126,[1,1,2,1,2]],[156,[1,1,2,1,2]],[160,[1,1,2,1,2]],
     [186,[1,1,2,1,2]]]],
 [23609,[[7,[1]],[16,[1]],[22,[1]],[31,[1]],[46,[1]],[52,[1]],[67,[1]],
     [76,[1]],[82,[1]],[91,[1]]]],
 [23613,[[6,[1,2,2,1,2,2,2,2]],[15,[1,2,2,1,2,2,2,2]],[16,[1,2]],
     [40,[1,2,2,1,2,2,2,2]],[46,[1,2]],[52,[1,2,2,1,2,2,2,2]],
     [66,[1,2,2,1,2,2,2,2]],[75,[1,2,2,1,2,2,2,2]],[76,[1,2]],
     [100,[1,2,2,1,2,2,2,2]]]],
 [23618,[[15,[1,1,2]],[36,[1,1,2]],[75,[1,1,2]],[96,[1,1,2]],[135,[1,1,2]],
     [156,[1,1,2]],[195,[1,1,2]],[216,[1,1,2]],[255,[1,1,2]]]],
 [23621,[[6,[1]],[12,[1]],[27,[1]],[36,[1]],[42,[1]],[51,[1]],[66,[1]],
     [72,[1]],[87,[1]],[96,[1]]]],
 [23622,[[15,[1,1,2,1,2]],[22,[1,1,2,1,2]],[52,[1,1,2,1,2]],
     [75,[1,1,2,1,2]],[82,[1,1,2,1,2]],[112,[1,1,2,1,2]],
     [135,[1,1,2,1,2]],[142,[1,1,2,1,2]],[172,[1,1,2,1,2]],
     [195,[1,1,2,1,2]]]],[23640,[[30,[2]],[90,[2]],[150,[2]],[210,[2]]]],
 [23641,[[0,[2,2,3,2,2,3,3,3]],[15,[2,2,3,2,2,3,3,3]],[27,[1]],
     [35,[2,2,3,2,2,3,3,3]],[50,[2,2,3,2,2,3,3,3]],[60,[2,2,3,2,2,3,3,3]],
     [75,[2,2,3,2,2,3,3,3]],[87,[1]],[95,[2,2,3,2,2,3,3,3]],
     [110,[2,2,3,2,2,3,3,3]]]],
 [23643,[[10,[1,1,2,2,2,2,2]],[50,[1,1,2,2,2,2,2]],[70,[1,1,2,2,2,2,2]],
     [110,[1,1,2,2,2,2,2]],[130,[1,1,2,2,2,2,2]],[170,[1,1,2,2,2,2,2]],
     [190,[1,1,2,2,2,2,2]],[230,[1,1,2,2,2,2,2]],[250,[1,1,2,2,2,2,2]]]],
 [23645,[[8,[1,2,2,2,2,2,3,2]],[20,[1,2,2,2,2,2,3,2]],[30,[3]],
     [40,[1,2,2,2,2,2,3,2]],[55,[1,2,2,2,2,2,3,2]],[68,[1,2,2,2,2,2,3,2]],
     [80,[1,2,2,2,2,2,3,2]],[90,[3]],[100,[1,2,2,2,2,2,3,2]],
     [115,[1,2,2,2,2,2,3,2]]]],
 [23646,[[20,[3,4]],[26,[3,4]],[56,[3,4]],[80,[3,4]],[86,[3,4]],
     [116,[3,4]],[140,[3,4]],[146,[3,4]],[176,[3,4]],[200,[3,4]]]],
 [23647,[[8,[3,4,5,4]],[11,[1,2,3,3,4,3]],[26,[1,2,3,3,4,3]],
     [38,[3,4,5,4]],[47,[3,4,5,4]],[56,[1,2,3,3,4,3]],[68,[3,4,5,4]],
     [71,[1,2,3,3,4,3]],[86,[1,2,3,3,4,3]],[98,[3,4,5,4]]]],
 [23648,[[15,[1,2,3]],[30,[1]],[75,[1,2,3]],[90,[1]],[135,[1,2,3]],
     [150,[1]],[195,[1,2,3]],[210,[1]],[255,[1,2,3]]]],
 [23650,[[15,[2]],[30,[2]],[75,[2]],[90,[2]],[135,[2]],[150,[2]],
     [195,[2]],[210,[2]],[255,[2]]]],
 [23651,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [23655,[[15,[1,2,2,2]],[30,[1,1,2,1,2]],[75,[1,2,2,2]],[90,[1,1,2,1,2]],
     [135,[1,2,2,2]],[150,[1,1,2,1,2]],[195,[1,2,2,2]],[210,[1,1,2,1,2]],
     [255,[1,2,2,2]]]],
 [23658,[[6,[1,1,1,1,2,3,4,3]],[15,[1,1,1,1,2,3,4,3]],[30,[3]],
     [40,[1,1,1,1,2,3,4,3]],[50,[1,1,1,1,2,3,4,3]],[66,[1,1,1,1,2,3,4,3]],
     [75,[1,1,1,1,2,3,4,3]],[90,[3]],[100,[1,1,1,1,2,3,4,3]],
     [110,[1,1,1,1,2,3,4,3]]]],
 [23664,[[8,[1,1,2,2,2]],[38,[1,1,2,2,2]],[47,[1,1,2,2,2]],
     [68,[1,1,2,2,2]],[98,[1,1,2,2,2]],[107,[1,1,2,2,2]],
     [128,[1,1,2,2,2]],[158,[1,1,2,2,2]],[167,[1,1,2,2,2]],
     [188,[1,1,2,2,2]]]],
 [23665,[[30,[1,1,2,2]],[90,[1,1,2,2]],[150,[1,1,2,2]],[210,[1,1,2,2]]]],
 [23685,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23686,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [23687,[[2,[1]],[10,[1]],[14,[1]],[22,[1]],[26,[1]],[34,[1]],[38,[1]],
     [46,[1]],[50,[1]],[58,[1]]]],
 [23688,[[8,[1,1,2]],[20,[1,1,2]],[32,[1,1,2]],[44,[1,1,2]],[56,[1,1,2]],
     [68,[1,1,2]],[80,[1,1,2]],[92,[1,1,2]],[104,[1,1,2]],[116,[1,1,2]]] 
  ],
 [23689,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [23691,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23697,[[0,[1,1,2]],[6,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[12,[1,1,2]],
     [18,[1,1,2]],[19,[1,1,2]],[22,[1,1,2]],[24,[1,1,2]],[30,[1,1,2]]]],
 [23699,[[0,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[18,[1,2]],[19,[1,2]],
     [24,[1,2]],[30,[1,2]],[31,[1,2]],[36,[1,2]]]],
 [23702,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23704,[[2,[1]],[7,[1]],[8,[1]],[10,[1]],[14,[1]],[19,[1]],[20,[1]],
     [22,[1]],[26,[1]],[31,[1]]]],
 [23706,[[2,[2]],[3,[1]],[7,[1]],[8,[2]],[10,[2]],[14,[2]],[15,[1]],
     [19,[1]],[20,[2]],[22,[2]]]],
 [23711,[[0,[1]],[3,[1]],[6,[1]],[10,[1]],[12,[1]],[15,[1]],[18,[1]],
     [22,[1]],[24,[1]],[27,[1]]]],
 [23712,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [23713,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],
 [23724,[[2,[2]],[8,[2]],[10,[1]],[14,[2]],[20,[2]],[22,[1]],[26,[2]],
     [32,[2]],[34,[1]],[38,[2]]]],
 [23729,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23730,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [23731,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [23732,[[3,[1]],[8,[1]],[15,[1]],[20,[1]],[27,[1]],[32,[1]],[39,[1]],
     [44,[1]],[51,[1]],[56,[1]]]],
 [23733,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23734,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23735,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23736,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [23737,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [23738,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23739,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23740,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [23741,[[0,[1]],[6,[1]],[7,[1]],[12,[1]],[18,[1]],[19,[1]],[24,[1]],
     [30,[1]],[31,[1]],[36,[1]]]],
 [23742,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23745,[[3,[1]],[6,[1]],[15,[1]],[18,[1]],[27,[1]],[30,[1]],[39,[1]],
     [42,[1]],[51,[1]],[54,[1]]]],
 [23746,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23748,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [23750,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [23751,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23752,[[3,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23753,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23754,[[3,[2]],[15,[2]],[27,[2]],[39,[2]],[51,[2]],[63,[2]],[75,[2]],
     [87,[2]],[99,[2]],[111,[2]]]],
 [23755,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [23756,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23757,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23759,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23761,[[2,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23763,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [56,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[111,[1,2]]]],
 [23764,[[3,[1,2]],[15,[1,2]],[27,[1,2]],[39,[1,2]],[51,[1,2]],
     [63,[1,2]],[75,[1,2]],[87,[1,2]],[99,[1,2]],[102,[1,2]]]],
 [23768,[[0,[1]],[15,[1]],[27,[1]],[39,[1]],[51,[1]],[63,[1]],[75,[1]],
     [87,[1]],[99,[1]],[111,[1]]]],
 [23769,[[3,[1]],[12,[1]],[27,[1]],[30,[1]],[36,[1]],[51,[1]],[66,[1]],
     [75,[1]],[84,[1]],[90,[1]]]],
 [23771,[[3,[1]],[14,[1]],[26,[1]],[27,[1]],[50,[1]],[51,[1]],[62,[1]],
     [68,[1]],[75,[1]],[86,[1]]]],
 [23772,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [23774,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [23775,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [23776,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [23787,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23789,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [23791,[[2,[2]],[4,[2]],[7,[1]],[8,[2]],[10,[2]],[14,[2]],[16,[2]],
     [19,[1]],[20,[2]],[22,[2]]]],
 [23796,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [23797,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [23798,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[23800,[[0,fail]]],
 [23801,[[0,fail]]],
 [23802,[[2,[1]],[7,[1]],[8,[1]],[14,[1]],[19,[1]],[20,[1]],[26,[1]],
     [31,[1]],[32,[1]],[38,[1]]]],
 [23803,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [23807,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [23808,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [23809,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [23814,[[2,[1,1,2]],[14,[1,1,2]],[26,[1,1,2]],[38,[1,1,2]],[50,[1,1,2]],
     [62,[1,1,2]],[74,[1,1,2]],[86,[1,1,2]],[98,[1,1,2]],[110,[1,1,2]]]]
  ,
 [23815,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [23828,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23830,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [23832,[[2,[2]],[4,[2]],[7,[1]],[10,[2]],[11,[1]],[14,[2]],[16,[2]],
     [19,[1]],[22,[2]],[23,[1]]]],
 [23837,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [23838,[[0,[2]],[2,[2]],[6,[2]],[12,[2]],[14,[2]],[18,[2]],[24,[2]],
     [26,[2]],[30,[2]],[36,[2]]]],
 [23850,[[2,[1]],[4,[2]],[10,[2]],[14,[1]],[16,[2]],[22,[2]],[26,[1]],
     [28,[2]],[34,[2]],[38,[1]]]],
 [23855,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [23856,[[8,[1,1,1,2]],[20,[1,1,1,2]],[32,[1,1,1,2]],[44,[1,1,1,2]],
     [56,[1,1,1,2]],[68,[1,1,1,2]],[80,[1,1,1,2]],[92,[1,1,1,2]],
     [104,[1,1,1,2]],[116,[1,1,1,2]]]],
 [23863,[[0,[2]],[6,[2]],[7,[2]],[12,[2]],[18,[2]],[19,[2]],[24,[2]],
     [30,[2]],[31,[2]],[36,[2]]]],
 [23868,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23870,[[2,[1]],[7,[1]],[8,[1]],[14,[1]],[19,[1]],[20,[1]],[26,[1]],
     [31,[1]],[32,[1]],[38,[1]]]],
 [23872,[[2,[2]],[3,[1]],[7,[1]],[8,[2]],[11,[1]],[14,[2]],[15,[1]],
     [19,[1]],[20,[2]],[23,[1]]]],
 [23877,[[0,[1,1,2]],[3,[1,1,2]],[6,[1,1,2]],[12,[1,1,2]],[15,[1,1,2]],
     [18,[1,1,2]],[24,[1,1,2]],[27,[1,1,2]],[30,[1,1,2]],[36,[1,1,2]]]],
 [23878,[[0,[2]],[3,[2]],[6,[2]],[12,[2]],[15,[2]],[18,[2]],[24,[2]],
     [27,[2]],[30,[2]],[36,[2]]]],[23881,[[6,fail]]],[23882,[[0,fail]]],
 [23890,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [23895,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [23896,[[8,[3]],[20,[3]],[32,[3]],[44,[3]],[56,[3]],[68,[3]],[80,[3]],
     [92,[3]],[104,[3]],[116,[3]]]],
 [23897,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [23898,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23899,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23900,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [23901,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [23902,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [23903,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23904,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [23907,[[6,[1]],[8,[1]],[18,[1]],[20,[1]],[30,[1]],[32,[1]],[42,[1]],
     [44,[1]],[54,[1]],[56,[1]]]],
 [23908,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [23909,[[4,[1]],[7,[1]],[8,[1]],[10,[1]],[16,[1]],[19,[1]],[20,[1]],
     [22,[1]],[28,[1]],[31,[1]]]],
 [23910,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23912,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23913,[[8,[3]],[20,[3]],[32,[3]],[44,[3]],[56,[3]],[68,[3]],[80,[3]],
     [92,[3]],[104,[3]],[116,[3]]]],
 [23914,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [23915,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23916,[[3,[2]],[4,[2]],[10,[2]],[15,[2]],[16,[2]],[22,[2]],[27,[2]],
     [28,[2]],[34,[2]],[39,[2]]]],
 [23917,[[0,[1]],[3,[1]],[6,[1]],[8,[1]],[12,[1]],[15,[1]],[18,[1]],
     [20,[1]],[24,[1]],[27,[1]]]],
 [23918,[[3,[2]],[4,[2]],[10,[2]],[15,[2]],[16,[2]],[22,[2]],[27,[2]],
     [28,[2]],[34,[2]],[39,[2]]]],
 [23919,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[116,[1,2]]]],
 [23920,[[8,[2,3]],[20,[2,3]],[32,[2,3]],[44,[2,3]],[56,[2,3]],
     [68,[2,3]],[80,[2,3]],[92,[2,3]],[104,[2,3]],[116,[2,3]]]],
 [23922,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23924,[[8,[1,2]],[20,[1,2]],[32,[1,2]],[44,[1,2]],[56,[1,2]],
     [68,[1,2]],[80,[1,2]],[92,[1,2]],[104,[1,2]],[106,[1,2]]]],
 [23926,[[8,[2]],[20,[2]],[32,[2]],[44,[2]],[56,[2]],[68,[2]],[80,[2]],
     [92,[2]],[104,[2]],[116,[2]]]],
 [23930,[[8,[1]],[20,[1]],[32,[1]],[44,[1]],[56,[1]],[68,[1]],[80,[1]],
     [92,[1]],[104,[1]],[116,[1]]]],
 [23931,[[6,[1]],[18,[1]],[20,[1]],[42,[1]],[44,[1]],[54,[1]],[60,[1]],
     [68,[1]],[78,[1]],[92,[1]]]],
 [23932,[[8,[1]],[16,[1]],[32,[1]],[34,[1]],[40,[1]],[56,[1]],[70,[1]],
     [80,[1]],[88,[1]],[94,[1]]]],
 [23934,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [23940,[[0,[1,1,1,2]],[6,[1,1,1,2]],[7,[1,1,1,2]],[10,[1,1,1,2]],
     [12,[1,1,1,2]],[18,[1,1,1,2]],[19,[1,1,1,2]],[22,[1,1,1,2]],
     [24,[1,1,1,2]],[30,[1,1,1,2]]]],
 [23942,[[0,[1]],[6,[1]],[7,[1]],[12,[1]],[18,[1]],[19,[1]],[24,[1]],
     [30,[1]],[31,[1]],[36,[1]]]],
 [23945,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23947,[[2,[1]],[7,[1]],[8,[1]],[10,[1]],[14,[1]],[19,[1]],[20,[1]],
     [22,[1]],[26,[1]],[31,[1]]]],
 [23949,[[2,[3]],[7,[1]],[8,[3]],[10,[2]],[14,[3]],[19,[1]],[20,[3]],
     [22,[2]],[26,[3]],[31,[1]]]],
 [23955,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [23956,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [23960,[[7,[1]],[14,[1]],[31,[1]],[32,[1]],[50,[1]],[55,[1]],[68,[1]],
     [79,[1]],[86,[1]],[103,[1]]]],
 [23961,[[7,[2,3]],[10,[2,3]],[19,[2,3]],[22,[2,3]],[31,[2,3]],
     [34,[2,3]],[43,[2,3]],[46,[2,3]],[55,[2,3]],[58,[2,3]]]],
 [23962,[[8,fail]]],
 [23967,[[2,[2]],[8,[2]],[10,[1]],[14,[2]],[20,[2]],[22,[1]],[26,[2]],
     [32,[2]],[34,[1]],[38,[2]]]],
 [23979,[[0,[3]],[6,[3]],[7,[3]],[12,[3]],[18,[3]],[19,[3]],[24,[3]],
     [30,[3]],[31,[3]],[36,[3]]]],
 [23982,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [23984,[[2,[2]],[7,[1]],[8,[2]],[11,[1]],[14,[2]],[19,[1]],[20,[2]],
     [23,[1]],[26,[2]],[31,[1]]]],
 [23986,[[2,[3]],[3,[1]],[7,[1]],[8,[3]],[11,[2]],[14,[3]],[15,[1]],
     [19,[1]],[20,[3]],[23,[2]]]],
 [23992,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [23993,[[0,[2]],[3,[1]],[6,[2]],[12,[2]],[15,[1]],[18,[2]],[24,[2]],
     [27,[1]],[30,[2]],[36,[2]]]],[23999,[[2,fail]]],
 [24004,[[2,[3]],[8,[3]],[11,[1]],[14,[3]],[20,[3]],[23,[1]],[26,[3]],
     [32,[3]],[35,[1]],[38,[3]]]],
 [24012,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [24013,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [24017,[[0,[2]],[3,[1]],[6,[2]],[7,[2]],[11,[1]],[12,[2]],[15,[1]],
     [18,[2]],[19,[2]],[23,[1]]]],
 [24018,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24019,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [24020,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24025,[[6,[1]],[7,[1]],[18,[1]],[19,[1]],[30,[1]],[31,[1]],[42,[1]],
     [43,[1]],[54,[1]],[55,[1]]]],
 [24028,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],
 [24029,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [24039,[[0,[2]],[6,[2]],[7,[1]],[12,[2]],[18,[2]],[19,[1]],[24,[2]],
     [30,[2]],[31,[1]],[36,[2]]]],
 [24045,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [24049,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [24051,[[0,[2]],[4,[2]],[6,[2]],[10,[2]],[11,[1]],[12,[2]],[16,[2]],
     [18,[2]],[22,[2]],[23,[1]]]],
 [24053,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [24055,[[4,[2,4]],[10,[2,4]],[16,[2,4]],[22,[2,4]],[28,[2,4]],
     [34,[2,4]],[40,[2,4]],[46,[2,4]],[52,[2,4]],[58,[2,4]]]],
 [24056,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [24061,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [24063,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],[24065,[[2,fail]]],
 [24066,[[2,fail]]],
 [24068,[[0,[1]],[6,[1]],[11,[1]],[12,[1]],[18,[1]],[23,[1]],[24,[1]],
     [30,[1]],[35,[1]],[36,[1]]]],
 [24073,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [24074,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [24075,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [24076,[[4,[1]],[10,[1]],[11,[1]],[16,[1]],[22,[1]],[23,[1]],[28,[1]],
     [34,[1]],[35,[1]],[40,[1]]]],
 [24085,[[0,[2]],[3,[1]],[6,[2]],[7,[2]],[11,[1]],[12,[2]],[15,[1]],
     [18,[2]],[19,[2]],[23,[1]]]],
 [24087,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24090,[[0,[1]],[7,[1]],[12,[1]],[19,[1]],[24,[1]],[31,[1]],[36,[1]],
     [43,[1]],[48,[1]],[55,[1]]]],
 [24092,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [24095,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],
 [24097,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [24107,[[0,[2]],[6,[2]],[7,[1]],[12,[2]],[18,[2]],[19,[1]],[24,[2]],
     [30,[2]],[31,[1]],[36,[2]]]],
 [24114,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [24119,[[0,[3]],[3,[1]],[6,[3]],[11,[2]],[12,[3]],[15,[1]],[18,[3]],
     [23,[2]],[24,[3]],[27,[1]]]],
 [24127,[[6,[1,1,1,2]],[18,[1,1,1,2]],[30,[1,1,1,2]],[42,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[78,[1,1,1,2]],[90,[1,1,1,2]],
     [102,[1,1,1,2]],[114,[1,1,1,2]]]],
 [24129,[[3,[1,2,2]],[4,[1,2,2]],[10,[1,2,2]],[15,[1,2,2]],[16,[1,2,2]],
     [22,[1,2,2]],[27,[1,2,2]],[28,[1,2,2]],[34,[1,2,2]],[39,[1,2,2]]]],
 [24130,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],[24134,[[4,fail]]],
 [24136,[[0,[1,2,2]],[11,[3,3,4]],[15,[1,2,2]],[23,[3,3,4]],[27,[1,2,2]],
     [35,[3,3,4]],[39,[1,2,2]],[47,[3,3,4]],[51,[1,2,2]],[59,[3,3,4]]]],
 [24141,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [24143,[[0,[1]],[11,[2]],[15,[1]],[23,[2]],[27,[1]],[35,[2]],[39,[1]],
     [47,[2]],[51,[1]],[59,[2]]]],
 [24147,[[4,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[19,[1,1,2]],
     [22,[1,1,2]],[28,[1,1,2]],[31,[1,1,2]],[34,[1,1,2]],[40,[1,1,2]]]],
 [24149,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [24151,[[0,[2]],[3,[1]],[6,[2]],[7,[2]],[12,[2]],[15,[1]],[18,[2]],
     [19,[2]],[24,[2]],[27,[1]]]],
 [24152,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24154,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24159,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [24161,[[3,[1]],[4,[1]],[10,[1]],[15,[1]],[16,[1]],[22,[1]],[27,[1]],
     [28,[1]],[34,[1]],[39,[1]]]],
 [24162,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],[24164,[[4,fail]]],[24166,[[4,fail]]],
 [24173,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [24180,[[4,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],
     [34,[1,1,2]],[40,[1,1,2]],[46,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]]]],
 [24183,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24184,[[4,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[19,[1,1,2]],
     [22,[1,1,2]],[28,[1,1,2]],[31,[1,1,2]],[34,[1,1,2]],[40,[1,1,2]]]],
 [24185,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24190,[[4,[1]],[6,[1]],[7,[1]],[10,[1]],[16,[1]],[18,[1]],[19,[1]],
     [22,[1]],[28,[1]],[30,[1]]]],
 [24192,[[3,[1,1,2]],[6,[1,1,2]],[15,[1,1,2]],[18,[1,1,2]],[27,[1,1,2]],
     [30,[1,1,2]],[39,[1,1,2]],[42,[1,1,2]],[51,[1,1,2]],[54,[1,1,2]]]],
 [24193,[[0,[2]],[3,[2]],[6,[2]],[12,[2]],[15,[2]],[18,[2]],[24,[2]],
     [27,[2]],[30,[2]],[36,[2]]]],
 [24194,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [24195,[[0,[1,2]],[4,[7,8]],[10,[4,5]],[16,[13,14]],[22,[4,5]],
     [28,[7,8]],[34,[4,5]],[40,[10,11]],[46,[4,5]],[52,[7,8]]]],
 [24197,[[18,fail]]],[24201,[[4,fail]]],[24209,[[6,fail]]],
 [24211,[[0,[2]],[4,[1]],[6,[2]],[7,[2]],[10,[1]],[11,[1]],[12,[2]],
     [16,[1]],[18,[2]],[19,[2]]]],
 [24212,[[0,[2]],[2,[1]],[6,[2]],[7,[2]],[8,[1]],[11,[1]],[12,[2]],
     [14,[1]],[18,[2]],[19,[2]]]],
 [24213,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [24215,[[4,[1,2]],[7,[1,2]],[10,[1,2]],[16,[1,2]],[19,[1,2]],[22,[1,2]],
     [28,[1,2]],[31,[1,2]],[34,[1,2]],[40,[1,2]]]],
 [24216,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [24221,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [24223,[[0,[2]],[6,[2]],[7,[1]],[12,[2]],[18,[2]],[19,[1]],[24,[2]],
     [30,[2]],[31,[1]],[36,[2]]]],
 [24233,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [24234,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [24235,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [24236,[[6,[2]],[11,[1]],[19,[2]],[23,[1]],[31,[2]],[35,[1]],[43,[2]],
     [47,[1]],[55,[2]],[59,[1]]]],
 [24242,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24243,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [24244,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24249,[[4,[1,1,2]],[7,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[19,[1,1,2]],
     [22,[1,1,2]],[28,[1,1,2]],[31,[1,1,2]],[34,[1,1,2]],[40,[1,1,2]]]],
 [24252,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [24253,[[3,[1]],[6,[1,1,2]],[15,[1]],[18,[1,1,2]],[27,[1]],[30,[1,1,2]],
     [39,[1]],[42,[1,1,2]],[51,[1]],[54,[1,1,2]]]],
 [24257,[[3,[1,2]],[7,[1,2]],[15,[1,2]],[19,[1,2]],[27,[1,2]],[31,[1,2]],
     [39,[1,2]],[43,[1,2]],[51,[1,2]],[55,[1,2]]]],[24260,[[4,fail]]],
 [24263,[[0,[3]],[6,[3]],[7,[1,2]],[12,[3]],[18,[3]],[19,[1,2]],
     [24,[3]],[30,[3]],[31,[1,2]],[36,[3]]]],[24268,[[6,fail]]],
 [24273,[[0,[2]],[4,[2]],[7,[1]],[10,[2]],[11,[1]],[12,[2]],[16,[2]],
     [19,[1]],[22,[2]],[23,[1]]]],
 [24275,[[0,[2]],[3,[1]],[6,[2]],[7,[1]],[11,[1]],[12,[2]],[15,[1]],
     [18,[2]],[19,[1]],[23,[1]]]],
 [24278,[[0,[1]],[3,[2]],[4,[2]],[6,[1]],[10,[2]],[11,[1]],[12,[1]],
     [15,[2]],[16,[2]],[18,[1]]]],
 [24285,[[0,[1]],[3,[2]],[6,[1]],[7,[2]],[11,[2]],[12,[1]],[15,[2]],
     [18,[1]],[19,[2]],[23,[2]]]],
 [24293,[[0,[2]],[4,[1]],[6,[2]],[10,[1]],[11,[2]],[15,[2]],[16,[1]],
     [19,[2]],[22,[1]],[23,[2]]]],
 [24294,[[0,[1]],[3,[2]],[4,[6]],[10,[1]],[11,[3]],[12,[4]],[15,[3]],
     [22,[1]],[23,[5]],[27,[6]]]],
 [24295,[[0,[4]],[4,[1]],[6,[1]],[7,[8]],[10,[2]],[11,[6]],[18,[1]],
     [19,[9]],[22,[3]],[23,[5]]]],
 [24298,[[0,[2]],[3,[1]],[6,[2]],[7,[1]],[11,[1]],[12,[2]],[15,[1]],
     [18,[2]],[19,[1]],[23,[1]]]],
 [24303,[[0,[3]],[3,[1]],[7,[1]],[8,[3]],[11,[2]],[14,[3]],[15,[1]],
     [19,[1]],[20,[3]],[23,[2]]]],
 [24304,[[0,[2]],[3,[1]],[6,[2]],[7,[1]],[8,[2]],[14,[2]],[15,[1]],
     [18,[2]],[19,[1]],[20,[2]]]],
 [24313,[[0,[1]],[2,[2]],[6,[1]],[7,[2]],[11,[2]],[12,[1]],[15,[2]],
     [18,[1]],[19,[2]],[23,[2]]]],
 [24315,[[0,[1]],[2,[1]],[3,[2]],[6,[4]],[7,[3]],[12,[1]],[14,[8]],
     [15,[4]],[19,[2]],[24,[1]]]],
 [24316,[[0,[2]],[3,[6]],[8,[1]],[11,[2]],[12,[3]],[14,[6]],[15,[6]],
     [20,[1]],[23,[8]],[27,[2]]]],
 [24320,[[0,[2]],[2,[1]],[6,[2]],[8,[1]],[11,[2]],[14,[1]],[15,[2]],
     [19,[2]],[20,[1]],[23,[2]]]],
 [24324,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24325,[[4,[2]],[10,[2]],[16,[2]],[22,[2]],[28,[2]],[34,[2]],[40,[2]],
     [46,[2]],[52,[2]],[58,[2]]]],
 [24326,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [24328,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24330,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24331,[[3,[1]],[4,[1]],[10,[1]],[15,[1]],[16,[1]],[22,[1]],[27,[1]],
     [28,[1]],[34,[1]],[39,[1]]]],
 [24332,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24334,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24336,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [24337,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [24338,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [24339,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [24340,[[4,[1]],[16,[1]],[18,[1]],[40,[1]],[42,[1]],[52,[1]],[58,[1]],
     [66,[1]],[76,[1]],[90,[1]]]],
 [24341,[[6,[1]],[14,[1]],[30,[1]],[32,[1]],[38,[1]],[54,[1]],[68,[1]],
     [78,[1]],[86,[1]],[92,[1]]]],
 [24348,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [58,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [24349,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [24350,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24355,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [24357,[[3,[2]],[4,[2]],[10,[2]],[15,[2]],[16,[2]],[22,[2]],[27,[2]],
     [28,[2]],[34,[2]],[39,[2]]]],
 [24358,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],[24360,[[4,fail]]],[24362,[[4,fail]]],
 [24369,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [24375,[[4,[1,2]],[7,[1,2]],[10,[1,2]],[16,[1,2]],[19,[1,2]],[22,[1,2]],
     [28,[1,2]],[31,[1,2]],[34,[1,2]],[40,[1,2]]]],
 [24379,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24380,[[3,[1]],[4,[2]],[10,[2]],[15,[1]],[16,[2]],[22,[2]],[27,[1]],
     [28,[2]],[34,[2]],[39,[1]]]],
 [24381,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24383,[[4,[2]],[7,[2]],[10,[2]],[16,[2]],[19,[2]],[22,[2]],[28,[2]],
     [31,[2]],[34,[2]],[40,[2]]]],
 [24386,[[4,[2,3]],[7,[2,3]],[10,[2,3]],[16,[2,3]],[19,[2,3]],[22,[2,3]],
     [28,[2,3]],[31,[2,3]],[34,[2,3]],[40,[2,3]]]],
 [24387,[[3,[1]],[7,[2]],[11,[1]],[15,[1]],[19,[2]],[23,[1]],[27,[1]],
     [31,[2]],[35,[1]],[39,[1]]]],
 [24388,[[4,[1]],[7,[1]],[10,[1]],[16,[1]],[19,[1]],[22,[1]],[28,[1]],
     [31,[1]],[34,[1]],[40,[1]]]],
 [24389,[[4,[1]],[7,[1]],[10,[1]],[16,[2]],[19,[1]],[28,[3]],[31,[1]],
     [34,[2]],[43,[1]],[52,[10]]]],
 [24390,[[4,[1]],[7,[1]],[8,[1]],[16,[1]],[19,[1]],[20,[1]],[22,[1]],
     [28,[1]],[31,[1]],[40,[1]]]],
 [24397,[[4,[1,2]],[7,[3]],[16,[1,2]],[19,[4,5]],[31,[3]],[34,[1,2]],
     [40,[2,4]],[43,[3]],[55,[3]],[58,[5,7]]]],
 [24398,[[4,[2]],[7,[2]],[10,[2]],[14,[2]],[19,[2]],[22,[2]],[26,[2]],
     [28,[2]],[31,[2]],[34,[2]]]],
 [24400,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [24415,[[0,[1]],[4,[2]],[10,[2]],[12,[1]],[16,[2]],[22,[2]],[24,[1]],
     [28,[2]],[34,[2]],[36,[1]]]],
 [24425,[[2,[1]],[3,[2]],[4,[2]],[8,[1]],[10,[2]],[11,[1]],[14,[1]],
     [15,[2]],[16,[2]],[20,[1]]]],
 [24432,[[2,[1]],[3,[2]],[7,[2]],[8,[1]],[11,[2]],[14,[1]],[15,[2]],
     [19,[2]],[20,[1]],[23,[2]]]],
 [24433,[[2,[2]],[4,[1]],[7,[2]],[10,[1]],[11,[2]],[15,[2]],[16,[1]],
     [19,[2]],[22,[1]],[23,[2]]]],
 [24434,[[2,[3]],[7,[6]],[8,[1]],[10,[7]],[11,[3]],[19,[2]],[20,[1]],
     [23,[3]],[26,[7]],[28,[2]]]],
 [24435,[[2,[1]],[3,[4]],[4,[1]],[7,[11]],[8,[2]],[15,[2]],[16,[1]],
     [19,[7]],[20,[3]],[22,[6]]]],[24450,[[8,fail]]],[24451,[[14,fail]]],
 [24458,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [24465,[[0,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [24468,[[0,[2]],[3,[1]],[8,[2]],[11,[1]],[14,[2]],[15,[1]],[20,[2]],
     [23,[1]],[26,[2]],[27,[1]]]],[24477,[[8,fail]]],
 [24479,[[0,[3]],[8,[3]],[11,[1]],[14,[3]],[20,[3]],[23,[1]],[26,[3]],
     [32,[3]],[35,[1]],[38,[3]]]],
 [24486,[[3,[1,1,2]],[4,[1,1,2]],[6,[1,1,2]],[10,[1,1,2]],[15,[1,1,2]],
     [16,[1,1,2]],[18,[1,1,2]],[22,[1,1,2]],[27,[1,1,2]],[28,[1,1,2]]]],
 [24487,[[0,[1]],[3,[1]],[6,[1]],[8,[1]],[14,[1]],[15,[1]],[18,[1]],
     [20,[1]],[26,[1]],[27,[1]]]],
 [24488,[[3,[2]],[4,[2]],[10,[2]],[15,[2]],[16,[2]],[22,[2]],[27,[2]],
     [28,[2]],[34,[2]],[39,[2]]]],
 [24498,[[0,[2]],[6,[1]],[8,[2]],[14,[2]],[18,[1]],[20,[2]],[26,[2]],
     [30,[1]],[32,[2]],[38,[2]]]],
 [24505,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [24510,[[3,[2]],[11,[1]],[15,[2]],[23,[1]],[27,[2]],[35,[1]],[39,[2]],
     [47,[1]],[51,[2]],[59,[1]]]],
 [24515,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [24516,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [24517,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [24522,[[0,[2]],[3,[2]],[6,[2]],[12,[2]],[15,[2]],[18,[2]],[24,[2]],
     [27,[2]],[30,[2]],[36,[2]]]],
 [24523,[[3,[1,1,2]],[4,[1,1,2]],[10,[1,1,2]],[15,[1,1,2]],[16,[1,1,2]],
     [22,[1,1,2]],[27,[1,1,2]],[28,[1,1,2]],[34,[1,1,2]],[39,[1,1,2]]]],
 [24525,[[0,[4,5]],[6,[10,11]],[12,[4,5]],[18,[7,8]],[24,[4,5]],
     [30,[16,17]],[36,[4,5]],[42,[7,8]],[48,[4,5]],[54,[10,11]]]],
 [24530,[[3,fail]]],[24538,[[4,fail]]],
 [24539,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [24542,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[15,[1,2]],[18,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [24544,[[0,[1]],[2,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[24,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],
 [24546,[[0,[1,2]],[3,[1,2]],[6,[1,2]],[12,[1,2]],[14,[1,2]],[15,[1,2]],
     [24,[1,2]],[27,[1,2]],[30,[1,2]],[32,[1,2]]]],
 [24547,[[0,[1,2]],[3,[3]],[12,[2,4]],[15,[3]],[27,[4,5]],[36,[1,2]],
     [39,[3]],[48,[3,6]],[51,[3]],[54,[1,2]]]],
 [24551,[[0,[2]],[6,[1]],[11,[1]],[15,[2]],[19,[1]],[23,[1]],[27,[2]],
     [31,[1]],[35,[1]],[39,[2]]]],
 [24552,[[0,[1]],[3,[1]],[6,[2]],[15,[1]],[18,[5]],[27,[1]],[39,[1]],
     [42,[4]],[51,[1]],[54,[4]]]],
 [24554,[[0,[1]],[3,[1]],[6,[1]],[12,[1]],[15,[1]],[18,[1]],[20,[1]],
     [27,[1]],[30,[1]],[36,[1]]]],[24555,[[4,fail]]],
 [24558,[[3,[2]],[7,[1]],[15,[2]],[19,[1]],[27,[2]],[31,[1]],[39,[2]],
     [43,[1]],[51,[2]],[55,[1]]]],[24561,[[3,fail]]],
 [24564,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],[24569,[[3,fail]]],
 [24570,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [24571,[[4,[2,4]],[16,[2,4]],[28,[2,4]],[40,[2,4]],[52,[2,4]],
     [64,[2,4]],[76,[2,4]],[88,[2,4]],[100,[2,4]],[112,[2,4]]]],
 [24572,[[2,fail]]],[24573,[[2,fail]]],[24580,[[2,fail]]],
 [24584,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[24585,[[0,fail]]],
 [24586,[[0,fail]]],[24593,[[2,fail]]],[24597,[[0,fail]]],[24598,[[0,fail]]],
 [24605,[[0,fail]]],
 [24613,[[0,[1]],[3,[1]],[6,[1]],[7,[1]],[11,[1]],[12,[1]],[15,[1]],
     [18,[1]],[19,[1]],[23,[1]]]],
 [24614,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [24615,[[2,[1]],[3,[1]],[7,[1]],[8,[1]],[11,[1]],[14,[1]],[15,[1]],
     [19,[1]],[20,[1]],[23,[1]]]],
 [24623,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [24624,[[0,[1]],[2,[1]],[6,[1]],[7,[1]],[11,[1]],[12,[1]],[15,[1]],
     [18,[1]],[19,[1]],[23,[1]]]],
 [24625,[[2,[1]],[4,[1]],[7,[1]],[10,[1]],[11,[1]],[15,[1]],[16,[1]],
     [19,[1]],[22,[1]],[23,[1]]]],
 [24656,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[11,[1]],[15,[1]],[16,[1]],
     [19,[1]],[22,[1]],[23,[1]]]],
 [24661,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[11,[1]],[14,[1]],[15,[1]],
     [19,[1]],[20,[1]],[23,[1]]]],
 [24665,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [24675,[[0,[1,2]],[10,[1,2]],[12,[1,2]],[20,[1,2]],[30,[1,2]],
     [32,[1,2]],[40,[1,2]],[50,[1,2]],[52,[1,2]],[60,[1,2]]]],
 [24676,[[0,[1,2]],[10,[1,2]],[12,[1,2]],[20,[1,2]],[30,[1,2]],
     [32,[1,2]],[40,[1,2]],[50,[1,2]],[52,[1,2]],[60,[1,2]]]],
 [24677,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [24678,[[0,[1]],[6,[2]],[10,[1]],[20,[1]],[26,[2]],[30,[1]],[40,[1]],
     [46,[2]],[50,[1]],[60,[1]]]],
 [24679,[[0,[1,2]],[6,[2]],[10,[1,2]],[20,[1,2]],[26,[2]],[30,[1,2]],
     [40,[1,2]],[46,[2]],[50,[1,2]],[60,[1,2]]]],
 [24680,[[0,[1]],[5,[1]],[8,[1]],[13,[1]],[20,[1]],[25,[1]],[28,[1]],
     [33,[1]],[40,[1]],[45,[1]]]],
 [24681,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [24682,[[5,[2]],[10,[2]],[25,[2]],[30,[2]],[45,[2]],[50,[2]],[65,[2]],
     [70,[2]],[85,[2]],[90,[2]]]],
 [24683,[[5,[2]],[10,[1,1,2]],[25,[2]],[30,[1,1,2]],[45,[2]],
     [50,[1,1,2]],[65,[2]],[70,[1,1,2]],[85,[2]],[90,[1,1,2]]]],
 [24684,[[0,[1,1,1,2,1,1,2,2]],[8,[1]],[16,[1,1,1,2,1,1,2,2]],[28,[1]],
     [30,[1,1,1,2,1,1,2,2]],[40,[1,1,1,2,1,1,2,2]],[48,[1]],
     [52,[1,1,1,2,1,1,2,2]],[60,[1,1,1,2,1,1,2,2]],[68,[1]]]],
 [24685,[[8,[2,2,3,3]],[12,[1,2]],[42,[1,2]],[48,[2,2,3,3]],
     [68,[2,2,3,3]],[72,[1,2]],[102,[1,2]],[108,[2,2,3,3]],
     [128,[2,2,3,3]],[132,[1,2]]]],
 [24686,[[0,[1,1,1,2]],[10,[1]],[12,[1,2]],[16,[1,1,1,2]],[30,[1,1,1,2]],
     [40,[1]],[42,[1,2]],[46,[1,1,1,2]],[48,[1,1,1,2]],[60,[1,1,1,2]]]],
 [24687,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [24688,[[8,[2]],[26,[2]],[48,[2]],[68,[2]],[86,[2]],[108,[2]],
     [128,[2]],[146,[2]],[168,[2]],[188,[2]]]],
 [24689,[[0,[1,1,1,2]],[26,[2]],[30,[1,1,1,2]],[33,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[86,[2]],[90,[1,1,1,2]],
     [93,[1,1,1,2]],[108,[1,1,1,2]]]],
 [24690,[[5,[3]],[16,[3]],[28,[1,2]],[46,[3]],[48,[3]],[65,[3]],
     [76,[3]],[88,[1,2]],[106,[3]],[108,[3]]]],
 [24693,[[2,[1,2]],[10,[1,2]],[28,[1]],[32,[1,2]],[40,[1,2]],[53,[1,2]],
     [62,[1,2]],[70,[1,2]],[88,[1]],[92,[1,2]]]],
 [24694,[[8,[1,1,2,2]],[25,[2]],[48,[1,1,2,2]],[68,[1,1,2,2]],[85,[2]],
     [108,[1,1,2,2]],[128,[1,1,2,2]],[145,[2]],[168,[1,1,2,2]],
     [188,[1,1,2,2]]]],
 [24696,[[8,[1,2,3,2]],[25,[2]],[48,[1,2,3,2]],[68,[1,2,3,2]],[85,[2]],
     [108,[1,2,3,2]],[128,[1,2,3,2]],[145,[2]],[168,[1,2,3,2]],
     [188,[1,2,3,2]]]],
 [24698,[[0,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],[20,[1,1,2]],[28,[1,2]],
     [46,[1,1,2]],[48,[1,1,2]],[50,[1,1,2]],[60,[1,1,2]],[72,[1,1,2]]]],
 [24699,[[8,[1,1,1,2]],[13,[1]],[20,[1]],[48,[1,1,1,2]],[50,[1]],
     [68,[1,1,1,2]],[73,[1]],[80,[1]],[108,[1,1,1,2]],[110,[1]]]],
 [24702,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [24703,[[6,[2,3,4,3]],[28,[1]],[48,[2,3,4,3]],[66,[2,3,4,3]],[88,[1]],
     [108,[2,3,4,3]],[126,[2,3,4,3]],[148,[1]],[168,[2,3,4,3]],
     [186,[2,3,4,3]]]],
 [24704,[[8,[4,5,6,5]],[25,[4,5,6,5]],[26,[4,5,6,5]],[28,[2,3]],
     [56,[4,5,6,5]],[68,[4,5,6,5]],[85,[4,5,6,5]],[86,[4,5,6,5]],
     [88,[2,3]],[116,[4,5,6,5]]]],
 [24707,[[6,[2,3]],[8,[1,1,2,2]],[30,[1,1,2]],[36,[2,3]],[48,[1,1,2,2]],
     [66,[2,3]],[68,[1,1,2,2]],[90,[1,1,2]],[96,[2,3]],[108,[1,1,2,2]]]]
  ,
 [24708,[[0,[1,2,2,2]],[17,[1,2,2,2]],[22,[1,2,2,2]],[26,[1,2,2,2]],
     [28,[3,4]],[32,[1,2,2,2]],[33,[1,2,2,2]],[52,[1,2,2,2]],
     [56,[1,2,2,2]],[62,[1,2,2,2]]]],
 [24710,[[8,[1,2,2]],[10,[1,2,2]],[28,[1]],[40,[1,2,2]],[53,[1,2,2]],
     [68,[1,2,2]],[70,[1,2,2]],[88,[1]],[100,[1,2,2]],[113,[1,2,2]]]],
 [24711,[[0,[2,3,4]],[28,[1]],[30,[2,3,4]],[33,[2,3,4]],[48,[2,3,4]],
     [60,[2,3,4]],[88,[1]],[90,[2,3,4]],[93,[2,3,4]],[108,[2,3,4]]]],
 [24712,[[8,[3,3,4,4]],[12,[1,2]],[42,[1,2]],[48,[3,3,4,4]],
     [68,[3,3,4,4]],[72,[1,2]],[102,[1,2]],[108,[3,3,4,4]],
     [128,[3,3,4,4]],[132,[1,2]]]],
 [24722,[[5,[2,2,2,3]],[33,[1,1,1,2]],[48,[2,2,2,3]],[53,[1,1,1,2]],
     [85,[2,2,2,3]],[88,[2]],[93,[1,1,1,2]],[113,[1,1,1,2]],
     [153,[1,1,1,2]],[165,[2,2,2,3]]]],
 [24723,[[8,[1]],[17,[1,2]],[48,[1]],[57,[1,2]],[68,[1]],[97,[1,2]],
     [108,[1]],[128,[1]],[137,[1,2]],[168,[1]]]],
 [24724,[[8,[1,2,2,2,1,2,2,2,1,2,2,3]],[28,[1]],
     [33,[1,2,2,2,1,2,2,2,1,2,2,3]],[68,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [73,[1,2,2,2,1,2,2,2,1,2,2,3]],[77,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [88,[1]],[117,[1,2,2,2,1,2,2,2,1,2,2,3]],[148,[1]],
     [153,[1,2,2,2,1,2,2,2,1,2,2,3]]]],
 [24729,[[0,[1]],[10,[1]],[12,[1]],[20,[1]],[30,[1]],[32,[1]],[40,[1]],
     [50,[1]],[52,[1]],[60,[1]]]],
 [24732,[[1,[1]],[21,[1]],[41,[1]],[61,[1]],[81,[1]],[101,[1]],
     [121,[1]],[141,[1]],[161,[1]],[181,[1]]]],
 [24733,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [24734,[[10,[2,2,3]],[30,[2,2,3]],[50,[2,2,3]],[70,[2,2,3]],[90,[2,2,3]],
     [110,[2,2,3]],[130,[2,2,3]],[150,[2,2,3]],[170,[2,2,3]],
     [190,[2,2,3]]]],
 [24735,[[10,[3,4]],[30,[3,4]],[50,[3,4]],[70,[3,4]],[90,[3,4]],
     [110,[3,4]],[130,[3,4]],[150,[3,4]],[170,[3,4]],[190,[3,4]]]],
 [24737,[[4,[1,1,1,1,1,1,2,2]],[12,[1,2]],[16,[1,1,1,1,1,1,2,2]],
     [20,[1,2]],[40,[1,1,1,1,1,1,2,2]],[50,[1,2]],[52,[1,1,1,1,1,1,2,2]],
     [64,[1,1,1,1,1,1,2,2]],[72,[1,2]],[76,[1,1,1,1,1,1,2,2]]]],
 [24738,[[9,[1,1,1,1,1,2]],[17,[1,1,1,1,1,2]],[24,[1,1,1,1,1,2]],
     [54,[1,1,1,1,1,2]],[69,[1,1,1,1,1,2]],[77,[1,1,1,1,1,2]],
     [84,[1,1,1,1,1,2]],[114,[1,1,1,1,1,2]],[129,[1,1,1,1,1,2]],
     [137,[1,1,1,1,1,2]]]],
 [24739,[[12,[1]],[20,[1]],[50,[1]],[72,[1]],[80,[1]],[110,[1]],
     [132,[1]],[140,[1]],[170,[1]],[192,[1]]]],
 [24743,[[10,[5]],[12,[1]],[17,[5]],[29,[1]],[40,[5]],[52,[5]],[70,[5]],
     [72,[1]],[77,[5]],[89,[1]]]],
 [24744,[[0,[4,4,6,6]],[12,[1,2]],[20,[3,5,4,4]],[26,[2,2,3,3]],
     [29,[1,2]],[30,[4,4,6,6]],[32,[4,4,6,6]],[37,[2,2,3,3]],
     [50,[3,5,4,4]],[56,[2,2,3,3]]]],
 [24745,[[0,[1,1,1,1,2,2,2,3]],[12,[1,1,1,1,2,2,2,3]],[25,[1]],
     [30,[1,1,1,1,2,2,2,3]],[37,[1,1,1,1,2,2,2,3]],[49,[1,1,1,1,2,2,2,3]],
     [60,[1,1,1,1,2,2,2,3]],[72,[1,1,1,1,2,2,2,3]],[85,[1]],
     [90,[1,1,1,1,2,2,2,3]]]],
 [24751,[[12,[1,2]],[20,[1,2]],[50,[1,2]],[72,[1,2]],[80,[1,2]],
     [110,[1,2]],[132,[1,2]],[140,[1,2]],[170,[1,2]],[192,[1,2]]]],
 [24756,[[30,[2,3,3]],[90,[2,3,3]],[150,[2,3,3]],[210,[2,3,3]]]],
 [24758,[[6,[1,2,2,2,2,2,2,2]],[17,[1,2,2,2,2,2,2,2]],[20,[1,2,2,2,2,2,2,2]]
      ,[30,[3]],[50,[1,2,2,2,2,2,2,2]],[52,[1,2,2,2,2,2,2,2]],
     [66,[1,2,2,2,2,2,2,2]],[77,[1,2,2,2,2,2,2,2]],[80,[1,2,2,2,2,2,2,2]],
     [90,[3]]]],
 [24760,[[6,[1,2,2]],[36,[1,2,2]],[66,[1,2,2]],[96,[1,2,2]],[126,[1,2,2]],
     [156,[1,2,2]],[186,[1,2,2]],[216,[1,2,2]],[246,[1,2,2]]]],
 [24761,[[4,[4,4,5]],[10,[4,4,5]],[32,[4,4,5]],[34,[4,4,5]],[40,[4,4,5]],
     [41,[4,4,5]],[50,[4,4,5]],[64,[4,4,5]],[70,[4,4,5]],[92,[4,4,5]]]],
 [24762,[[10,[2,3,5,3]],[40,[2,3,5,3]],[70,[2,3,5,3]],[100,[2,3,5,3]],
     [130,[2,3,5,3]],[160,[2,3,5,3]],[190,[2,3,5,3]],[220,[2,3,5,3]],
     [250,[2,3,5,3]]]],
 [24765,[[0,[1,1,2,2]],[12,[1,2]],[17,[1,1,2,2]],[20,[1,2]],
     [24,[1,1,2,2]],[30,[1,1,2,2]],[32,[1,1,2,2]],[50,[1,2]],
     [54,[1,1,2,2]],[60,[1,1,2,2]]]],
 [24766,[[6,[1,2,1,2,2]],[9,[1,2,1,2,2]],[24,[1,2,1,2,2]],[36,[1,2,1,2,2]],
     [54,[1,2,1,2,2]],[66,[1,2,1,2,2]],[69,[1,2,1,2,2]],[84,[1,2,1,2,2]],
     [96,[1,2,1,2,2]],[114,[1,2,1,2,2]]]],
 [24782,[[1,[2,2,3]],[21,[2,2,3]],[41,[2,2,3]],[61,[2,2,3]],[81,[2,2,3]],
     [101,[2,2,3]],[121,[2,2,3]],[141,[2,2,3]],[161,[2,2,3]],
     [181,[2,2,3]]]],
 [24784,[[1,[3,4]],[21,[3,4]],[41,[3,4]],[61,[3,4]],[81,[3,4]],
     [101,[3,4]],[121,[3,4]],[141,[3,4]],[161,[3,4]],[181,[3,4]]]],
 [24785,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [24787,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [24789,[[2,[1,1,2,2,2,1,2,3]],[8,[1,1,2,2,2,1,2,3]],[12,[1,2]],
     [38,[1,1,2,2,2,1,2,3]],[40,[1,1,2,2,2,1,2,3]],[42,[1,2]],
     [52,[1,1,2,2,2,1,2,3]],[62,[1,1,2,2,2,1,2,3]],[68,[1,1,2,2,2,1,2,3]],
     [72,[1,2]]]],
 [24790,[[12,[1]],[21,[1,2,2]],[42,[1]],[72,[1]],[81,[1,2,2]],[102,[1]],
     [132,[1]],[141,[1,2,2]],[162,[1]],[192,[1]]]],
 [24795,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [24797,[[1,[1,1,2,2,3,3,1,2]],[12,[1,1,2,2,3,3,1,2]],[18,[1,1,2,2,3,3,1,2]]
      ,[22,[1,1,2,2,3,3,1,2]],[25,[1]],[48,[1,1,2,2,3,3,1,2]],
     [52,[1,1,2,2,3,3,1,2]],[61,[1,1,2,2,3,3,1,2]],[72,[1,1,2,2,3,3,1,2]],
     [78,[1,1,2,2,3,3,1,2]]]],
 [24799,[[8,[1,2,2]],[38,[1,2,2]],[68,[1,2,2]],[98,[1,2,2]],[128,[1,2,2]],
     [158,[1,2,2]],[188,[1,2,2]],[218,[1,2,2]],[248,[1,2,2]]]],
 [24800,[[1,[1,1,1,1,1,1,2,2,3]],[16,[1,1,1,1,1,1,2,2,3]],
     [28,[1,1,1,1,1,1,2,2,3]],[38,[1,1,1,1,1,1,2,2,3]],
     [46,[1,1,1,1,1,1,2,2,3]],[58,[1,1,1,1,1,1,2,2,3]],
     [62,[1,1,1,1,1,1,2,2,3]],[76,[1,1,1,1,1,1,2,2,3]],
     [88,[1,1,1,1,1,1,2,2,3]],[98,[1,1,1,1,1,1,2,2,3]]]],
 [24810,[[2,[1,1,2,3,2,2,2,2]],[18,[1,1,2,3,2,2,2,2]],[28,[1,1,2,3,2,2,2,2]]
      ,[30,[1]],[32,[1,1,2,3,2,2,2,2]],[42,[1,1,2,3,2,2,2,2]],
     [58,[1,1,2,3,2,2,2,2]],[62,[1,1,2,3,2,2,2,2]],[78,[1,1,2,3,2,2,2,2]],
     [88,[1,1,2,3,2,2,2,2]]]],
 [24814,[[8,[1,2,1,2,2,2]],[28,[1,2,1,2,2,2]],[38,[1,2,1,2,2,2]],
     [58,[1,2,1,2,2,2]],[68,[1,2,1,2,2,2]],[88,[1,2,1,2,2,2]],
     [98,[1,2,1,2,2,2]],[118,[1,2,1,2,2,2]],[128,[1,2,1,2,2,2]],
     [148,[1,2,1,2,2,2]]]],
 [24817,[[0,[3,4]],[6,[3,4]],[12,[2]],[18,[3,4]],[30,[3,4]],[36,[3,4]],
     [42,[2]],[45,[3,4]],[48,[3,4]],[60,[3,4]]]],
 [24818,[[12,[1,2]],[21,[1,2]],[42,[1,2]],[72,[1,2]],[81,[1,2]],
     [102,[1,2]],[132,[1,2]],[141,[1,2]],[162,[1,2]],[192,[1,2]]]],
 [24827,[[1,[1,1,1,2]],[21,[1,1,1,2]],[22,[1,1,1,2]],[41,[1,1,1,2]],
     [52,[1,1,1,2]],[61,[1,1,1,2]],[81,[1,1,1,2]],[82,[1,1,1,2]],
     [101,[1,1,1,2]],[112,[1,1,1,2]]]],
 [24828,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [24829,[[2,[1,2,2]],[8,[1,2,2]],[13,[1,2,2]],[28,[1,2,2]],[32,[1,2,2]],
     [33,[1,2,2]],[38,[1,2,2]],[53,[1,2,2]],[58,[1,2,2]],[62,[1,2,2]]]],
 [24835,[[1,[3,4]],[21,[3,4]],[41,[3,4]],[61,[3,4]],[81,[3,4]],
     [101,[3,4]],[121,[3,4]],[141,[3,4]],[161,[3,4]],[181,[3,4]]]],
 [24836,[[0,[1,2]],[4,[1,2]],[14,[1,2]],[20,[1,2]],[24,[1,2]],[34,[1,2]],
     [40,[1,2]],[44,[1,2]],[54,[1,2]],[60,[1,2]]]],
 [24837,[[0,[1]],[4,[1]],[14,[1]],[20,[1]],[24,[1]],[34,[1]],[40,[1]],
     [44,[1]],[54,[1]],[60,[1]]]],
 [24838,[[10,[1]],[30,[1]],[50,[1]],[70,[1]],[90,[1]],[110,[1]],
     [130,[1]],[150,[1]],[170,[1]],[190,[1]]]],
 [24840,[[4,[1,1,1,1,2,2,2,3]],[16,[1,1,1,1,2,2,2,3]],[24,[1,1,1,1,2,2,2,3]]
      ,[28,[1]],[40,[1,1,1,1,2,2,2,3]],[54,[1,1,1,1,2,2,2,3]],
     [64,[1,1,1,1,2,2,2,3]],[76,[1,1,1,1,2,2,2,3]],[84,[1,1,1,1,2,2,2,3]],
     [88,[1]]]],
 [24843,[[0,[1,1,1,1,1,2]],[30,[1,1,1,1,1,2]],[36,[1,1,1,1,1,2]],
     [44,[1,1,1,1,1,2]],[60,[1,1,1,1,1,2]],[90,[1,1,1,1,1,2]],
     [96,[1,1,1,1,1,2]],[104,[1,1,1,1,1,2]],[120,[1,1,1,1,1,2]],
     [150,[1,1,1,1,1,2]]]],
 [24848,[[1,[1,1,1,1,1,1,2,2]],[4,[1,2]],[13,[1,1,1,1,1,1,2,2]],[34,[1,2]],
     [36,[1,1,1,1,1,1,2,2]],[41,[1,2]],[49,[1,1,1,1,1,1,2,2]],
     [61,[1,1,1,1,1,1,2,2]],[64,[1,2]],[73,[1,1,1,1,1,1,2,2]]]],
 [24849,[[4,[1]],[34,[1]],[41,[1]],[64,[1]],[94,[1]],[101,[1]],
     [124,[1]],[154,[1]],[161,[1]],[184,[1]]]],
 [24851,[[14,[3]],[21,[3]],[24,[3]],[54,[3]],[74,[3]],[81,[3]],[84,[3]],
     [114,[3]],[134,[3]],[141,[3]]]],
 [24860,[[8,[3]],[38,[3]],[44,[3]],[68,[3]],[98,[3]],[104,[3]],
     [128,[3]],[158,[3]],[164,[3]],[188,[3]]]],
 [24861,[[1,[1,2,3,2,2,2,2,3]],[14,[1,2,3,2,2,2,2,3]],[18,[1,2,3,2,2,2,2,3]]
      ,[30,[1]],[41,[1,2,3,2,2,2,2,3]],[44,[1,2,3,2,2,2,2,3]],
     [54,[1,2,3,2,2,2,2,3]],[61,[1,2,3,2,2,2,2,3]],[74,[1,2,3,2,2,2,2,3]],
     [78,[1,2,3,2,2,2,2,3]]]],
 [24864,[[14,[1,1,1,1,2,2,1,2,1,2,2]],[21,[1,1,1,1,2,2,1,2,1,2,2]],
     [28,[1,1,1,1,2,2,1,2,1,2,2]],[29,[1,1,1,1,2,2,1,2,1,2,2]],
     [58,[1,1,1,1,2,2,1,2,1,2,2]],[74,[1,1,1,1,2,2,1,2,1,2,2]],
     [81,[1,1,1,1,2,2,1,2,1,2,2]],[88,[1,1,1,1,2,2,1,2,1,2,2]],
     [89,[1,1,1,1,2,2,1,2,1,2,2]],[118,[1,1,1,1,2,2,1,2,1,2,2]]]],
 [24866,[[0,[1,2,1,2,2]],[18,[1,2,1,2,2]],[30,[1,2,1,2,2]],
     [44,[1,2,1,2,2]],[48,[1,2,1,2,2]],[60,[1,2,1,2,2]],[78,[1,2,1,2,2]],
     [90,[1,2,1,2,2]],[104,[1,2,1,2,2]],[108,[1,2,1,2,2]]]],
 [24867,[[0,[1,1,2,2]],[4,[1,2]],[21,[1,1,2,2]],[24,[1,1,2,2]],
     [30,[1,1,2,2]],[34,[1,2]],[36,[1,1,2,2]],[41,[1,2]],[54,[1,1,2,2]],
     [60,[1,1,2,2]]]],
 [24885,[[0,[1,2]],[6,[1,1,2]],[10,[1,2]],[20,[1,2]],[26,[1,1,2]],
     [30,[1,2]],[40,[1,2]],[46,[1,1,2]],[50,[1,2]],[60,[1,2]]]],
 [24886,[[4,[1]],[5,[2]],[14,[1]],[24,[1]],[25,[2]],[34,[1]],[44,[1]],
     [45,[2]],[54,[1]],[64,[1]]]],
 [24888,[[4,[1,2]],[5,[1,1,2]],[14,[1,2]],[24,[1,2]],[25,[1,1,2]],
     [34,[1,2]],[44,[1,2]],[45,[1,1,2]],[54,[1,2]],[64,[1,2]]]],
 [24890,[[4,[1,1,2,2,1,2,1,2]],[16,[1,1,2,2,1,2,1,2]],[20,[1,1,2,2,1,2,1,2]]
      ,[24,[1,1,2,2,1,2,1,2]],[26,[2]],[50,[1,1,2,2,1,2,1,2]],
     [54,[1,1,2,2,1,2,1,2]],[64,[1,1,2,2,1,2,1,2]],[76,[1,1,2,2,1,2,1,2]],
     [80,[1,1,2,2,1,2,1,2]]]],
 [24895,[[26,[1,1,2]],[86,[1,1,2]],[146,[1,1,2]],[206,[1,1,2]]]],
 [24898,[[0,[1,1,2,2,1,2,1,2]],[4,[1,1,2,2,1,2,1,2]],[25,[2]],
     [30,[1,1,2,2,1,2,1,2]],[34,[1,1,2,2,1,2,1,2]],[36,[1,1,2,2,1,2,1,2]],
     [49,[1,1,2,2,1,2,1,2]],[60,[1,1,2,2,1,2,1,2]],[64,[1,1,2,2,1,2,1,2]],
     [85,[2]]]],
 [24900,[[25,[1,1,2]],[85,[1,1,2]],[145,[1,1,2]],[205,[1,1,2]]]],
 [24901,[[10,[1,2,2,2]],[24,[1,2,2,2]],[26,[1,1,1,2]],[40,[1,2,2,2]],
     [54,[1,2,2,2]],[70,[1,2,2,2]],[84,[1,2,2,2]],[86,[1,1,1,2]],
     [100,[1,2,2,2]],[114,[1,2,2,2]]]],
 [24904,[[2,[1,2]],[32,[1,2]],[36,[1,2]],[44,[1,2]],[62,[1,2]],
     [92,[1,2]],[96,[1,2]],[104,[1,2]],[122,[1,2]],[152,[1,2]]]],
 [24908,[[14,[1]],[44,[1]],[74,[1]],[104,[1]],[134,[1]],[164,[1]],
     [194,[1]],[224,[1]],[254,[1]]]],
 [24910,[[4,[1,1,2]],[10,[1]],[14,[1]],[25,[1]],[26,[1]],[34,[1,1,2]],
     [40,[1]],[44,[1]],[49,[1,1,2]],[56,[1]]]],
 [24911,[[6,[1,1,1,2,2,2,2,2]],[10,[1,1,1,2,2,2,2,2]],[14,[1,2]],
     [40,[1,1,1,2,2,2,2,2]],[42,[1,1,1,2,2,2,2,2]],[44,[1,2]],
     [54,[1,1,1,2,2,2,2,2]],[66,[1,1,1,2,2,2,2,2]],[70,[1,1,1,2,2,2,2,2]],
     [74,[1,2]]]],
 [24917,[[0,[1,2,2,2,2]],[10,[1,2,2,2,2]],[16,[1,2,2,2,2]],
     [24,[1,2,2,2,2]],[30,[1,2,2,2,2]],[40,[1,2,2,2,2]],[46,[1,2,2,2,2]],
     [54,[1,2,2,2,2]],[60,[1,2,2,2,2]],[70,[1,2,2,2,2]]]],
 [24918,[[0,[1,2,2,2,2]],[6,[1,2,2,2,2]],[14,[1,2,2,2,2]],[24,[1,2,2,2,2]],
     [30,[1,2,2,2,2]],[36,[1,2,2,2,2]],[44,[1,2,2,2,2]],[54,[1,2,2,2,2]],
     [60,[1,2,2,2,2]],[66,[1,2,2,2,2]]]],[24920,[[10,fail]]],
 [24930,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [24935,[[0,[2]],[5,[2]],[20,[2]],[25,[2]],[40,[2]],[45,[2]],[60,[2]],
     [65,[2]],[80,[2]],[85,[2]]]],
 [24936,[[1,[1]],[21,[1]],[41,[1]],[61,[1]],[81,[1]],[101,[1]],
     [121,[1]],[141,[1]],[161,[1]],[181,[1]]]],
 [24937,[[1,[1]],[5,[1]],[6,[1]],[10,[1]],[21,[1]],[25,[1]],[26,[1]],
     [30,[1]],[41,[1]],[45,[1]]]],
 [24938,[[0,[2]],[5,[1,1,2]],[20,[2]],[25,[1,1,2]],[40,[2]],[45,[1,1,2]],
     [60,[2]],[65,[1,1,2]],[80,[2]],[85,[1,1,2]]]],
 [24940,[[0,[1,1,1,2]],[21,[2]],[30,[1,1,1,2]],[41,[1,1,1,2]],
     [60,[1,1,1,2]],[81,[2]],[90,[1,1,1,2]],[101,[1,1,1,2]],
     [120,[1,1,1,2]],[141,[2]]]],
 [24941,[[1,[2]],[10,[1,2]],[18,[2]],[40,[1,2]],[48,[2]],[61,[2]],
     [70,[1,2]],[78,[2]],[100,[1,2]],[108,[2]]]],
 [24942,[[1,[3]],[20,[2]],[41,[3]],[61,[3]],[80,[2]],[101,[3]],
     [121,[3]],[140,[2]],[161,[3]],[181,[3]]]],
 [24943,[[1,[3]],[21,[1]],[26,[1,1,2]],[41,[3]],[61,[3]],[81,[1]],
     [86,[1,1,2]],[101,[3]],[121,[3]],[141,[1]]]],
 [24944,[[1,[2,2,3,4]],[21,[1]],[22,[2,2,3,4]],[52,[2,2,3,4]],
     [61,[2,2,3,4]],[81,[1]],[82,[2,2,3,4]],[112,[2,2,3,4]],
     [121,[2,2,3,4]],[141,[1]]]],
 [24948,[[0,[1,1,1,2]],[8,[2,3]],[30,[1,1,1,2]],[38,[2,3]],[41,[1,1,1,2]],
     [60,[1,1,1,2]],[68,[2,3]],[90,[1,1,1,2]],[98,[2,3]],[101,[1,1,1,2]] 
    ]],
 [24949,[[1,[1]],[21,[1]],[25,[1]],[26,[1]],[41,[1]],[61,[1]],[81,[1]],
     [85,[1]],[86,[1]],[101,[1]]]],
 [24951,[[1,[2,3,4,3]],[21,[1]],[25,[1,1,2]],[37,[2,3,4,3]],
     [61,[2,3,4,3]],[81,[1]],[85,[1,1,2]],[97,[2,3,4,3]],[121,[2,3,4,3]],
     [141,[1]]]],
 [24953,[[0,[2,2,3,4]],[10,[3,4]],[40,[3,4]],[41,[2,2,3,4]],
     [60,[2,2,3,4]],[70,[3,4]],[100,[3,4]],[101,[2,2,3,4]],
     [120,[2,2,3,4]],[130,[3,4]]]],
 [24954,[[1,[1,1,1,2]],[8,[1,1,1,2]],[21,[1]],[38,[1,1,1,2]],
     [46,[1,1,1,2]],[61,[1,1,1,2]],[68,[1,1,1,2]],[81,[1]],
     [98,[1,1,1,2]],[106,[1,1,1,2]]]],
 [24957,[[0,[1,1,2,2]],[21,[3]],[41,[1,1,2,2]],[60,[1,1,2,2]],[81,[3]],
     [101,[1,1,2,2]],[120,[1,1,2,2]],[141,[3]],[161,[1,1,2,2]],
     [180,[1,1,2,2]]]],
 [24958,[[1,[1,1,2,2]],[21,[3]],[41,[1,1,2,2]],[61,[1,1,2,2]],[81,[3]],
     [101,[1,1,2,2]],[121,[1,1,2,2]],[141,[3]],[161,[1,1,2,2]],
     [181,[1,1,2,2]]]],
 [24959,[[0,[1,2,3,3]],[13,[7,8]],[20,[7,8]],[41,[1,2,3,3]],[50,[7,8]],
     [61,[1,2,3,3]],[73,[7,8]],[80,[7,8]],[101,[1,2,3,3]],[110,[7,8]]]],
 [24962,[[0,[1,1,2,2]],[21,[3]],[41,[1,1,2,2]],[60,[1,1,2,2]],[81,[3]],
     [101,[1,1,2,2]],[120,[1,1,2,2]],[141,[3]],[161,[1,1,2,2]],
     [180,[1,1,2,2]]]],
 [24964,[[1,[1,1,2,3]],[10,[1,1,2,3]],[21,[3]],[40,[1,1,2,3]],
     [48,[1,1,2,3]],[61,[1,1,2,3]],[70,[1,1,2,3]],[81,[3]],
     [100,[1,1,2,3]],[108,[1,1,2,3]]]],
 [24965,[[0,[3,3,3,5]],[20,[3,4]],[30,[3,3,3,5]],[41,[3,3,3,5]],
     [60,[3,3,3,5]],[80,[3,4]],[90,[3,3,3,5]],[101,[3,3,3,5]],
     [120,[3,3,3,5]],[140,[3,4]]]],
 [24967,[[0,[3,3,5,5]],[21,[3,4]],[30,[3,3,5,5]],[41,[3,3,5,5]],
     [60,[3,3,5,5]],[81,[3,4]],[90,[3,3,5,5]],[101,[3,3,5,5]],
     [120,[3,3,5,5]],[141,[3,4]]]],
 [24968,[[0,[1,1,1,2]],[18,[1,1,1,2]],[21,[2,3]],[30,[1,1,1,2]],
     [48,[1,1,1,2]],[60,[1,1,1,2]],[78,[1,1,1,2]],[81,[2,3]],
     [90,[1,1,1,2]],[108,[1,1,1,2]]]],
 [24977,[[1,[1,2,2,2,1,2,2,2,1,2,2,3]],[17,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [21,[1]],[57,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [66,[1,2,2,2,1,2,2,2,1,2,2,3]],[81,[1]],
     [97,[1,2,2,2,1,2,2,2,1,2,2,3]],[106,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [121,[1,2,2,2,1,2,2,2,1,2,2,3]],[141,[1]]]],
 [24979,[[0,[1]],[17,[1,2]],[41,[1]],[57,[1,2]],[61,[1]],[97,[1,2]],
     [101,[1]],[121,[1]],[137,[1,2]],[161,[1]]]],
 [24984,[[0,[1,2]],[4,[1,2]],[14,[1,2]],[20,[1,2]],[24,[1,2]],[34,[1,2]],
     [40,[1,2]],[44,[1,2]],[54,[1,2]],[60,[1,2]]]],
 [24985,[[4,[1,2]],[5,[2]],[14,[1,2]],[24,[1,2]],[25,[2]],[34,[1,2]],
     [44,[1,2]],[45,[2]],[54,[1,2]],[64,[1,2]]]],
 [24986,[[0,[1,1,2]],[5,[2]],[20,[1,1,2]],[25,[2]],[40,[1,1,2]],
     [45,[2]],[60,[1,1,2]],[65,[2]],[80,[1,1,2]],[85,[2]]]],
 [24988,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [24989,[[0,[1,2]],[14,[1,2]],[22,[1,2]],[25,[1]],[44,[1,2]],[52,[1,2]],
     [60,[1,2]],[74,[1,2]],[82,[1,2]],[85,[1]]]],
 [24990,[[5,[2,2,3,3]],[12,[1,2]],[42,[1,2]],[44,[2,2,3,3]],
     [65,[2,2,3,3]],[72,[1,2]],[102,[1,2]],[104,[2,2,3,3]],
     [125,[2,2,3,3]],[132,[1,2]]]],
 [24991,[[5,[2]],[25,[2]],[44,[2]],[65,[2]],[85,[2]],[104,[2]],
     [125,[2]],[145,[2]],[164,[2]],[185,[2]]]],
 [24992,[[2,[1,1,2,2]],[25,[2]],[45,[1,1,2,2]],[62,[1,1,2,2]],[85,[2]],
     [105,[1,1,2,2]],[122,[1,1,2,2]],[145,[2]],[165,[1,1,2,2]],
     [182,[1,1,2,2]]]],
 [24993,[[4,[1,2,2,2]],[5,[1,2,2,2]],[24,[4]],[34,[1,2,2,2]],
     [40,[1,2,2,2]],[53,[1,2,2,2]],[64,[1,2,2,2]],[65,[1,2,2,2]],
     [84,[4]],[94,[1,2,2,2]]]],
 [24995,[[0,[1,1,1,2,1,1,2,2]],[5,[1]],[13,[1,1,1,2,1,1,2,2]],
     [24,[1,1,1,2,1,1,2,2]],[25,[1]],[37,[1,1,1,2,1,1,2,2]],[45,[1]],
     [54,[1,1,1,2,1,1,2,2]],[60,[1,1,1,2,1,1,2,2]],[65,[1]]]],
 [24996,[[5,[1,1,1,2]],[8,[1,1,1,2]],[12,[1,2]],[14,[1]],[24,[1,1,1,2]],
     [38,[1,1,1,2]],[42,[1,2]],[44,[1]],[54,[1,1,1,2]],[65,[1,1,1,2]]]],
 [24997,[[5,[1,1,1,2]],[20,[1,1,1,2]],[24,[1,1,1,2]],[25,[2]],
     [54,[1,1,1,2]],[65,[1,1,1,2]],[80,[1,1,1,2]],[84,[1,1,1,2]],
     [85,[2]],[114,[1,1,1,2]]]],
 [24998,[[0,[2,2,2,3]],[14,[2,3]],[22,[2,3]],[45,[2,2,2,3]],[52,[2,3]],
     [62,[2,2,2,3]],[74,[2,3]],[82,[2,3]],[105,[2,2,2,3]],[112,[2,3]]]],
 [24999,[[0,[1,2,3,2]],[25,[2]],[44,[1,2,3,2]],[60,[1,2,3,2]],[85,[2]],
     [104,[1,2,3,2]],[120,[1,2,3,2]],[145,[2]],[164,[1,2,3,2]],
     [180,[1,2,3,2]]]],
 [25001,[[2,[1,1,2,2]],[22,[1,1,2,2]],[24,[4]],[32,[1,1,2,2]],
     [52,[1,1,2,2]],[62,[1,1,2,2]],[82,[1,1,2,2]],[84,[4]],
     [92,[1,1,2,2]],[112,[1,1,2,2]]]],
 [25002,[[0,[1]],[14,[1]],[25,[1,2]],[44,[1]],[45,[1]],[60,[1]],
     [74,[1]],[85,[1,2]],[104,[1]],[105,[1]]]],
 [25005,[[2,[1,1,1,2]],[24,[4]],[32,[1,1,1,2]],[45,[1,1,1,2]],
     [62,[1,1,1,2]],[84,[4]],[92,[1,1,1,2]],[105,[1,1,1,2]],
     [122,[1,1,1,2]],[144,[4]]]],
 [25006,[[5,[1,1,2,2]],[24,[4]],[45,[1,1,2,2]],[65,[1,1,2,2]],[84,[4]],
     [105,[1,1,2,2]],[125,[1,1,2,2]],[144,[4]],[165,[1,1,2,2]],
     [185,[1,1,2,2]]]],
 [25010,[[0,[2,2,2,3]],[14,[2,2,2,3]],[25,[1]],[42,[2,2,2,3]],
     [44,[2,2,2,3]],[60,[2,2,2,3]],[74,[2,2,2,3]],[85,[1]],
     [102,[2,2,2,3]],[104,[2,2,2,3]]]],
 [25012,[[0,[2,3,5,3]],[25,[1]],[34,[2,3,5,3]],[44,[2,3,5,3]],
     [64,[2,3,5,3]],[85,[1]],[94,[2,3,5,3]],[104,[2,3,5,3]],
     [124,[2,3,5,3]],[145,[1]]]],
 [25014,[[5,[3,3,4,4]],[12,[1,2]],[42,[1,2]],[45,[3,3,4,4]],
     [65,[3,3,4,4]],[72,[1,2]],[102,[1,2]],[105,[3,3,4,4]],
     [125,[3,3,4,4]],[132,[1,2]]]],
 [25015,[[5,[2,3,4]],[20,[2,3,4]],[24,[2,3,4]],[25,[1]],[54,[2,3,4]],
     [65,[2,3,4]],[80,[2,3,4]],[84,[2,3,4]],[85,[1]],[114,[2,3,4]]]],
 [25016,[[0,[1,2,2]],[14,[1,2,2]],[25,[1]],[44,[1,2,2]],[45,[1,2,2]],
     [60,[1,2,2]],[74,[1,2,2]],[85,[1]],[104,[1,2,2]],[105,[1,2,2]]]],
 [25025,[[5,[1]],[17,[1,2]],[45,[1]],[57,[1,2]],[65,[1]],[97,[1,2]],
     [105,[1]],[125,[1]],[137,[1,2]],[165,[1]]]],
 [25026,[[0,[1,1,1,2]],[20,[1,1,1,2]],[25,[2]],[60,[1,1,1,2]],
     [65,[2,2,2,3]],[69,[2,2,2,3]],[80,[1,1,1,2]],[120,[1,1,1,2]],
     [140,[1,1,1,2]],[145,[2]]]],
 [25032,[[10,[3,4]],[30,[3,4]],[50,[3,4]],[70,[3,4]],[90,[3,4]],
     [110,[3,4]],[130,[3,4]],[150,[3,4]],[170,[3,4]],[190,[3,4]]]],
 [25034,[[0,[1,1,2,2,3,3,1,2]],[6,[1,1,2,2,3,3,1,2]],[28,[1]],
     [30,[1,1,2,2,3,3,1,2]],[36,[1,1,2,2,3,3,1,2]],[40,[1,1,2,2,3,3,1,2]],
     [50,[1,1,2,2,3,3,1,2]],[60,[1,1,2,2,3,3,1,2]],[66,[1,1,2,2,3,3,1,2]],
     [88,[1]]]],
 [25037,[[10,[1]],[30,[1,2,2]],[40,[1]],[70,[1]],[90,[1,2,2]],[100,[1]],
     [130,[1]],[150,[1,2,2]],[160,[1]],[190,[1]]]],
 [25039,[[16,[1,2,2]],[46,[1,2,2]],[76,[1,2,2]],[106,[1,2,2]],
     [136,[1,2,2]],[166,[1,2,2]],[196,[1,2,2]],[226,[1,2,2]]]],
 [25042,[[0,[1,1,2,2,2,1,2,3]],[10,[1,2]],[13,[1,1,2,2,2,1,2,3]],
     [16,[1,1,2,2,2,1,2,3]],[40,[1,2]],[46,[1,1,2,2,2,1,2,3]],
     [49,[1,1,2,2,2,1,2,3]],[60,[1,1,2,2,2,1,2,3]],[70,[1,2]],
     [73,[1,1,2,2,2,1,2,3]]]],
 [25055,[[6,[1,1,1,1,1,2,2,3]],[18,[1,1,1,1,1,2,2,3]],[20,[1,1,1,1,1,2,2,3]]
      ,[26,[1,1,1,1,1,2,2,3]],[30,[2,3]],[50,[1,1,1,1,1,2,2,3]],
     [56,[1,1,1,1,1,2,2,3]],[66,[1,1,1,1,1,2,2,3]],[78,[1,1,1,1,1,2,2,3]],
     [80,[1,1,1,1,1,2,2,3]]]],
 [25059,[[16,[1,1,1,2]],[46,[1,1,1,2]],[76,[1,1,1,2]],[106,[1,1,1,2]],
     [136,[1,1,1,2]],[166,[1,1,1,2]],[196,[1,1,1,2]],[226,[1,1,1,2]]]],
 [25060,[[10,[1,2]],[30,[1,2]],[40,[1,2]],[70,[1,2]],[90,[1,2]],
     [100,[1,2]],[130,[1,2]],[150,[1,2]],[160,[1,2]],[190,[1,2]]]],
 [25061,[[6,[3,4]],[9,[3,4]],[10,[2]],[18,[3,4]],[24,[3,4]],[36,[3,4]],
     [40,[2]],[48,[3,4]],[54,[3,4]],[66,[3,4]]]],
 [25072,[[6,[1]],[16,[1]],[36,[1]],[46,[1]],[66,[1]],[76,[1]],[96,[1]],
     [106,[1]],[126,[1]],[136,[1]]]],
 [25073,[[0,[1,1,1,2]],[13,[1,1,1,2]],[30,[1,1,1,2]],[33,[1,1,1,2]],
     [53,[1,1,1,2]],[60,[1,1,1,2]],[73,[1,1,1,2]],[90,[1,1,1,2]],
     [93,[1,1,1,2]],[113,[1,1,1,2]]]],
 [25079,[[5,[1,1,2]],[10,[2]],[25,[1,1,2]],[30,[2]],[45,[1,1,2]],
     [50,[2]],[65,[1,1,2]],[70,[2]],[85,[1,1,2]],[90,[2]]]],
 [25081,[[6,[3]],[30,[2]],[45,[3]],[66,[3]],[90,[2]],[105,[3]],
     [126,[3]],[150,[2]],[165,[3]],[186,[3]]]],
 [25082,[[10,[1,1,1,2]],[16,[2,3]],[24,[1,1,1,2]],[46,[2,3]],
     [54,[1,1,1,2]],[70,[1,1,1,2]],[76,[2,3]],[84,[1,1,1,2]],[106,[2,3]],
     [114,[1,1,1,2]]]],
 [25083,[[10,[1,1,1,2]],[24,[1,1,1,2]],[30,[2]],[54,[1,1,1,2]],
     [70,[1,1,1,2]],[84,[1,1,1,2]],[90,[2]],[114,[1,1,1,2]],
     [130,[1,1,1,2]],[144,[1,1,1,2]]]],
 [25084,[[5,[3]],[25,[1,1,2]],[30,[1]],[44,[3]],[65,[3]],[85,[1,1,2]],
     [90,[1]],[104,[3]],[125,[3]],[145,[1,1,2]]]],
 [25085,[[10,[1]],[25,[1]],[26,[1]],[30,[1]],[50,[1]],[70,[1]],[85,[1]],
     [86,[1]],[90,[1]],[110,[1]]]],
 [25089,[[6,[2]],[14,[1,2]],[36,[2]],[44,[1,2]],[50,[2]],[66,[2]],
     [74,[1,2]],[96,[2]],[104,[1,2]],[110,[2]]]],
 [25090,[[2,[2,2,3,4]],[30,[1]],[32,[2,2,3,4]],[50,[2,2,3,4]],
     [62,[2,2,3,4]],[90,[1]],[92,[2,2,3,4]],[110,[2,2,3,4]],
     [122,[2,2,3,4]],[150,[1]]]],
 [25091,[[1,[1,2,2]],[14,[1,2,2]],[16,[1,2,2]],[22,[1,2,2]],[26,[1,2,2]],
     [30,[1]],[34,[1,2,2]],[46,[1,2,2]],[50,[1,2,2]],[52,[1,2,2]]]],
 [25092,[[1,[2,3,4,3]],[25,[1,1,2]],[30,[1]],[44,[2,3,4,3]],
     [61,[2,3,4,3]],[85,[1,1,2]],[90,[1]],[104,[2,3,4,3]],
     [121,[2,3,4,3]],[145,[1,1,2]]]],
 [25094,[[10,[1,1,2,3]],[14,[1,2]],[44,[1,2]],[50,[1,1,2,3]],
     [70,[1,1,2,3]],[74,[1,2]],[104,[1,2]],[110,[1,1,2,3]],
     [130,[1,1,2,3]],[134,[1,2]]]],
 [25095,[[10,[1,1,1,2]],[25,[1,1,1,2]],[26,[1,1,1,2]],[30,[1]],
     [56,[1,1,1,2]],[70,[1,1,1,2]],[85,[1,1,1,2]],[86,[1,1,1,2]],
     [90,[1]],[116,[1,1,1,2]]]],
 [25098,[[10,[1,1,2,2]],[14,[1,2]],[44,[1,2]],[50,[1,1,2,2]],
     [70,[1,1,2,2]],[74,[1,2]],[104,[1,2]],[110,[1,1,2,2]],
     [130,[1,1,2,2]],[134,[1,2]]]],
 [25099,[[5,[2,2,4,4]],[30,[2]],[45,[2,2,4,4]],[65,[2,2,4,4]],[90,[2]],
     [105,[2,2,4,4]],[125,[2,2,4,4]],[150,[2]],[165,[2,2,4,4]],
     [185,[2,2,4,4]]]],
 [25103,[[6,[2,2,3,3]],[30,[2]],[50,[2,2,3,3]],[66,[2,2,3,3]],[90,[2]],
     [110,[2,2,3,3]],[126,[2,2,3,3]],[150,[2]],[170,[2,2,3,3]],
     [186,[2,2,3,3]]]],
 [25104,[[10,[2,2,4,3]],[17,[2]],[22,[2]],[50,[2,2,4,3]],[52,[2]],
     [70,[2,2,4,3]],[77,[2]],[82,[2]],[110,[2,2,4,3]],[112,[2]]]],
 [25105,[[4,[2,2,2,3]],[16,[2,3]],[34,[2,2,2,3]],[45,[2,2,2,3]],
     [46,[2,3]],[64,[2,2,2,3]],[76,[2,3]],[94,[2,2,2,3]],[105,[2,2,2,3]],
     [106,[2,3]]]],
 [25106,[[6,[1,1,1,2]],[24,[1,1,1,2]],[30,[2,3]],[36,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[84,[1,1,1,2]],[90,[2,3]],
     [96,[1,1,1,2]],[114,[1,1,1,2]]]],
 [25107,[[6,[3,3,5,5]],[24,[3,3,5,5]],[30,[3,4]],[54,[3,3,5,5]],
     [66,[3,3,5,5]],[84,[3,3,5,5]],[90,[3,4]],[114,[3,3,5,5]],
     [126,[3,3,5,5]],[144,[3,3,5,5]]]],
 [25109,[[6,[3,3,3,5]],[24,[3,3,3,5]],[30,[3,4]],[54,[3,3,3,5]],
     [66,[3,3,3,5]],[84,[3,3,3,5]],[90,[3,4]],[114,[3,3,3,5]],
     [126,[3,3,3,5]],[144,[3,3,3,5]]]],
 [25119,[[5,[1,2,2,2,1,2,2,2,1,2,2,3]],[30,[1]],
     [45,[1,2,2,2,1,2,2,2,1,2,2,3]],[50,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [57,[1,2,2,2,1,2,2,2,1,2,2,3]],[90,[1]],
     [97,[1,2,2,2,1,2,2,2,1,2,2,3]],[125,[1,2,2,2,1,2,2,2,1,2,2,3]],
     [137,[1,2,2,2,1,2,2,2,1,2,2,3]],[150,[1]]]],
 [25120,[[5,[1]],[21,[2,4]],[25,[1]],[65,[1]],[70,[2,3]],[85,[1]],
     [101,[2,4]],[110,[2,3]],[125,[1]],[145,[1]]]],
 [25125,[[0,[1,1,1,2,3,2,2,2]],[16,[1,1,1,2,3,2,2,2]],[25,[2]],
     [40,[1,1,1,2,3,2,2,2]],[52,[1,1,1,2,3,2,2,2]],[60,[1,1,1,2,3,2,2,2]],
     [76,[1,1,1,2,3,2,2,2]],[85,[2]],[100,[1,1,1,2,3,2,2,2]],
     [112,[1,1,1,2,3,2,2,2]]]],
 [25126,[[30,[1,1,2]],[90,[1,1,2]],[150,[1,1,2]],[210,[1,1,2]]]],
 [25128,[[20,[1,1,2]],[80,[1,1,2]],[140,[1,1,2]],[200,[1,1,2]]]],
 [25130,[[25,[1,1,2]],[85,[1,1,2]],[145,[1,1,2]],[205,[1,1,2]]]],
 [25131,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [25133,[[1,[1,1,1,2,3,2,2,2]],[10,[1,1,1,2,3,2,2,2]],[25,[2]],
     [36,[1,1,1,2,3,2,2,2]],[45,[1,1,1,2,3,2,2,2]],[61,[1,1,1,2,3,2,2,2]],
     [70,[1,1,1,2,3,2,2,2]],[85,[2]],[96,[1,1,1,2,3,2,2,2]],
     [105,[1,1,1,2,3,2,2,2]]]],
 [25135,[[25,[1,1,2]],[85,[1,1,2]],[145,[1,1,2]],[205,[1,1,2]]]],
 [25136,[[10,[3]],[22,[3]],[52,[3]],[70,[3]],[82,[3]],[112,[3]],
     [130,[3]],[142,[3]],[172,[3]],[190,[3]]]],
 [25145,[[0,[1,1,2]],[10,[2,3,3]],[13,[1,1,2]],[25,[1,1,2]],[26,[2,2,4]],
     [40,[2,3,3]],[45,[1,1,2]],[56,[2,2,4]],[61,[1,1,2]],[70,[2,3,3]]]],
 [25146,[[5,[1,2,2,1,2,2,2,2]],[16,[1,2,2,1,2,2,2,2]],[30,[2]],
     [42,[1,2,2,1,2,2,2,2]],[50,[1,2,2,1,2,2,2,2]],[65,[1,2,2,1,2,2,2,2]],
     [76,[1,2,2,1,2,2,2,2]],[90,[2]],[102,[1,2,2,1,2,2,2,2]],
     [110,[1,2,2,1,2,2,2,2]]]],
 [25151,[[20,[2,2,3,3]],[80,[2,2,3,3]],[140,[2,2,3,3]],[200,[2,2,3,3]]]],
 [25152,[[5,[4]],[16,[4]],[46,[4]],[65,[4]],[76,[4]],[106,[4]],
     [125,[4]],[136,[4]],[166,[4]],[185,[4]]]],
 [25153,[[6,[4]],[36,[4]],[45,[4]],[66,[4]],[96,[4]],[105,[4]],
     [126,[4]],[156,[4]],[165,[4]],[186,[4]]]],
 [25154,[[30,[2,2,3,3]],[90,[2,2,3,3]],[150,[2,2,3,3]],[210,[2,2,3,3]]]],
 [25155,[[16,fail]]],
 [25170,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25171,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25172,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25173,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [25174,[[2,[2]],[14,[2]],[26,[2]],[38,[2]],[50,[2]],[62,[2]],[74,[2]],
     [86,[2]],[98,[2]],[110,[2]]]],
 [25175,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [25176,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [25177,[[1,[1]],[4,[1]],[13,[1]],[16,[1]],[25,[1]],[28,[1]],[37,[1]],
     [40,[1]],[49,[1]],[52,[1]]]],
 [25178,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25179,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25180,[[1,[2,3]],[14,[2,3]],[26,[2,3]],[38,[2,3]],[50,[2,3]],
     [62,[2,3]],[74,[2,3]],[86,[2,3]],[98,[2,3]],[110,[2,3]]]],
 [25181,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25183,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [25184,[[1,[1]],[2,[1]],[8,[1]],[13,[1]],[14,[1]],[20,[1]],[25,[1]],
     [26,[1]],[32,[1]],[37,[1]]]],
 [25187,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25188,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25189,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [25190,[[4,[1]],[6,[1]],[16,[1]],[18,[1]],[28,[1]],[30,[1]],[40,[1]],
     [42,[1]],[52,[1]],[54,[1]]]],
 [25192,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25193,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [25194,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25195,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25196,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25197,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25198,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25199,[[4,[2,3]],[16,[2,3]],[28,[2,3]],[40,[2,3]],[52,[2,3]],
     [64,[2,3]],[76,[2,3]],[88,[2,3]],[100,[2,3]],[112,[2,3]]]],
 [25200,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[112,[1,2]]]],
 [25204,[[4,[1,2]],[16,[1,2]],[28,[1,2]],[40,[1,2]],[52,[1,2]],
     [64,[1,2]],[76,[1,2]],[88,[1,2]],[100,[1,2]],[102,[1,2]]]],
 [25206,[[4,[2]],[16,[2]],[28,[2]],[40,[2]],[52,[2]],[64,[2]],[76,[2]],
     [88,[2]],[100,[2]],[112,[2]]]],
 [25207,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25209,[[4,[1]],[16,[1]],[28,[1]],[40,[1]],[52,[1]],[64,[1]],[76,[1]],
     [88,[1]],[100,[1]],[112,[1]]]],
 [25211,[[2,[1]],[14,[1]],[16,[1]],[38,[1]],[40,[1]],[50,[1]],[56,[1]],
     [64,[1]],[74,[1]],[88,[1]]]],
 [25212,[[4,[1]],[12,[1]],[28,[1]],[30,[1]],[36,[1]],[52,[1]],[66,[1]],
     [76,[1]],[84,[1]],[90,[1]]]],
 [25214,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [25218,[[0,[1]],[5,[1]],[6,[1]],[12,[1]],[17,[1]],[18,[1]],[24,[1]],
     [29,[1]],[30,[1]],[36,[1]]]],
 [25219,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[12,[1,2]],[17,[1,2]],[18,[1,2]],
     [24,[1,2]],[29,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [25220,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25225,[[0,[1]],[1,[1]],[6,[1]],[9,[1]],[12,[1]],[13,[1]],[18,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [25226,[[0,[1,2]],[2,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],[20,[1,2]],
     [24,[1,2]],[26,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [25228,[[0,[2]],[1,[1]],[5,[1]],[6,[2]],[9,[2]],[12,[2]],[13,[1]],
     [17,[1]],[18,[2]],[21,[2]]]],
 [25232,[[0,[1,1,2]],[2,[1,1,2]],[8,[1,1,2]],[9,[1,1,2]],[13,[1,1,2]],
     [14,[1,1,2]],[20,[1,1,2]],[21,[1,1,2]],[25,[1,1,2]],[26,[1,1,2]]]],
 [25233,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [25235,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [25236,[[0,[1]],[5,[1]],[8,[1]],[9,[1]],[14,[1]],[17,[1]],[20,[1]],
     [21,[1]],[26,[1]],[29,[1]]]],
 [25237,[[0,[1]],[9,[1]],[12,[1]],[21,[1]],[24,[1]],[33,[1]],[36,[1]],
     [45,[1]],[48,[1]],[57,[1]]]],
 [25240,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25246,[[0,[2]],[6,[2]],[9,[1]],[12,[2]],[18,[2]],[21,[1]],[24,[2]],
     [30,[2]],[33,[1]],[36,[2]]]],
 [25260,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25261,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [25262,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25267,[[1,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25270,[[0,[2]],[1,[1]],[4,[2]],[6,[2]],[10,[2]],[12,[2]],[13,[1]],
     [16,[2]],[18,[2]],[22,[2]]]],
 [25275,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [25278,[[0,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [25279,[[4,[1]],[10,[1]],[16,[1]],[22,[1]],[28,[1]],[34,[1]],[40,[1]],
     [46,[1]],[52,[1]],[58,[1]]]],
 [25282,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [25283,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],[25285,[[2,fail]]],
 [25286,[[2,fail]]],
 [25287,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [25288,[[0,[1]],[4,[1]],[6,[1]],[10,[1]],[12,[1]],[16,[1]],[18,[1]],
     [22,[1]],[24,[1]],[28,[1]]]],
 [25293,[[0,[1]],[1,[1]],[6,[1]],[12,[1]],[13,[1]],[18,[1]],[24,[1]],
     [25,[1]],[30,[1]],[36,[1]]]],
 [25294,[[0,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25295,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [25301,[[4,[2]],[5,[2]],[10,[2]],[16,[2]],[17,[2]],[22,[2]],[28,[2]],
     [29,[2]],[34,[2]],[40,[2]]]],
 [25302,[[0,[1]],[5,[1]],[6,[1]],[8,[1]],[12,[1]],[17,[1]],[18,[1]],
     [20,[1]],[24,[1]],[29,[1]]]],
 [25303,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25304,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [25308,[[0,[2]],[4,[2]],[10,[2]],[12,[2]],[16,[2]],[22,[2]],[24,[2]],
     [28,[2]],[34,[2]],[36,[2]]]],
 [25309,[[0,[1,1,2]],[4,[1,1,2]],[10,[1,1,2]],[12,[1,1,2]],[16,[1,1,2]],
     [22,[1,1,2]],[24,[1,1,2]],[28,[1,1,2]],[34,[1,1,2]],[36,[1,1,2]]]],
 [25312,[[0,[2]],[1,[1]],[5,[1]],[6,[2]],[8,[2]],[12,[2]],[13,[1]],
     [17,[1]],[18,[2]],[20,[2]]]],
 [25313,[[0,[1]],[8,[1]],[12,[1]],[20,[1]],[24,[1]],[32,[1]],[36,[1]],
     [44,[1]],[48,[1]],[56,[1]]]],
 [25314,[[6,[1,1,2]],[18,[1,1,2]],[30,[1,1,2]],[42,[1,1,2]],[54,[1,1,2]],
     [66,[1,1,2]],[78,[1,1,2]],[90,[1,1,2]],[102,[1,1,2]],[114,[1,1,2]]] 
  ],
 [25315,[[0,[1]],[4,[1]],[8,[1]],[10,[1]],[13,[1]],[16,[1]],[20,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [25316,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [25319,[[4,[1,1,2]],[5,[1,1,2]],[8,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],
     [17,[1,1,2]],[20,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],[29,[1,1,2]]]],
 [25322,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25328,[[0,[2]],[6,[2]],[8,[1]],[12,[2]],[18,[2]],[20,[1]],[24,[2]],
     [30,[2]],[32,[1]],[36,[2]]]],
 [25340,[[2,[1,1,2]],[14,[1,1,2]],[26,[1,1,2]],[38,[1,1,2]],[50,[1,1,2]],
     [62,[1,1,2]],[74,[1,1,2]],[86,[1,1,2]],[98,[1,1,2]],[110,[1,1,2]]]]
  ,
 [25343,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25345,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [25346,[[1,[1,1,1,2]],[14,[1,1,1,2]],[26,[1,1,1,2]],[38,[1,1,1,2]],
     [50,[1,1,1,2]],[62,[1,1,1,2]],[74,[1,1,1,2]],[86,[1,1,1,2]],
     [98,[1,1,1,2]],[110,[1,1,1,2]]]],
 [25356,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25357,[[0,[1]],[2,[2]],[5,[1]],[8,[2]],[9,[1]],[13,[1]],[14,[2]],
     [17,[1]],[20,[2]],[21,[1]]]],[25365,[[6,fail]]],[25367,[[6,fail]]],
 [25376,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [25382,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25384,[[1,[1]],[2,[1]],[13,[1]],[14,[1]],[25,[1]],[26,[1]],[37,[1]],
     [38,[1]],[49,[1]],[50,[1]]]],
 [25386,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [25387,[[1,[1,2]],[4,[1,2]],[10,[1,2]],[13,[1,2]],[16,[1,2]],[22,[1,2]],
     [25,[1,2]],[28,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [25389,[[1,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25395,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25396,[[0,[1]],[2,[2]],[4,[2]],[9,[1]],[10,[2]],[13,[1]],[14,[2]],
     [16,[2]],[21,[1]],[22,[2]]]],
 [25415,[[2,[1]],[4,[2]],[10,[2]],[14,[1]],[16,[2]],[22,[2]],[26,[1]],
     [28,[2]],[34,[2]],[38,[1]]]],
 [25419,[[0,[1,2]],[5,[1,2]],[6,[1,2]],[12,[1,2]],[17,[1,2]],[18,[1,2]],
     [24,[1,2]],[29,[1,2]],[30,[1,2]],[36,[1,2]]]],
 [25420,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25425,[[0,[2]],[4,[2]],[10,[2]],[13,[2]],[16,[2]],[22,[2]],[25,[2]],
     [28,[2]],[34,[2]],[37,[2]]]],
 [25426,[[0,[1,1,2]],[4,[1]],[12,[1,1,2]],[16,[1]],[24,[1,1,2]],
     [28,[1]],[36,[1,1,2]],[40,[1]],[48,[1,1,2]],[52,[1]]]],
 [25430,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [25432,[[0,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25433,[[4,[2]],[5,[2]],[10,[2]],[16,[2]],[17,[2]],[22,[2]],[28,[2]],
     [29,[2]],[34,[2]],[40,[2]]]],
 [25436,[[4,[1,1,2]],[5,[1,1,2]],[10,[1,1,2]],[16,[1,1,2]],[17,[1,1,2]],
     [22,[1,1,2]],[28,[1,1,2]],[29,[1,1,2]],[34,[1,1,2]],[40,[1,1,2]]]],
 [25438,[[4,[1,2,2]],[5,[1,2,2]],[10,[1,2,2]],[16,[1,2,2]],[17,[1,2,2]],
     [22,[1,2,2]],[28,[1,2,2]],[29,[1,2,2]],[34,[1,2,2]],[40,[1,2,2]]]],
 [25440,[[0,[2]],[5,[1]],[6,[2]],[12,[2]],[17,[1]],[18,[2]],[24,[2]],
     [29,[1]],[30,[2]],[36,[2]]]],
 [25441,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],[25442,[[10,fail]]],
 [25445,[[0,[2,4]],[6,[2,4]],[12,[2,4]],[18,[2,4]],[24,[2,4]],[30,[2,4]],
     [36,[2,4]],[42,[2,4]],[48,[2,4]],[54,[2,4]]]],[25447,[[4,fail]]],
 [25451,[[1,[1]],[5,[2]],[13,[1]],[17,[2]],[25,[1]],[29,[2]],[37,[1]],
     [41,[2]],[49,[1]],[53,[2]]]],[25455,[[4,fail]]],
 [25458,[[2,[1]],[5,[1]],[8,[1]],[14,[1]],[17,[1]],[20,[1]],[26,[1]],
     [29,[1]],[32,[1]],[38,[1]]]],
 [25463,[[2,[1,2]],[5,[1,2]],[8,[1,2]],[14,[1,2]],[17,[1,2]],[20,[1,2]],
     [26,[1,2]],[29,[1,2]],[32,[1,2]],[38,[1,2]]]],
 [25464,[[1,[1]],[2,[2]],[8,[2]],[13,[1]],[14,[2]],[20,[2]],[25,[1]],
     [26,[2]],[32,[2]],[37,[1]]]],
 [25467,[[2,[1]],[5,[1]],[8,[1]],[14,[1]],[17,[1]],[20,[1]],[26,[1]],
     [29,[1]],[32,[1]],[38,[1]]]],
 [25468,[[0,[1]],[5,[1]],[6,[1]],[12,[1]],[17,[1]],[18,[1]],[24,[1]],
     [29,[1]],[30,[1]],[36,[1]]]],
 [25469,[[2,[2]],[5,[2]],[8,[2]],[14,[2]],[17,[2]],[20,[2]],[26,[2]],
     [29,[2]],[32,[2]],[38,[2]]]],
 [25470,[[2,[1]],[5,[1]],[6,[1]],[8,[1]],[14,[1]],[17,[1]],[18,[1]],
     [20,[1]],[26,[1]],[29,[1]]]],
 [25472,[[0,[2]],[5,[2]],[8,[2]],[14,[2]],[17,[2]],[20,[2]],[26,[2]],
     [29,[2]],[32,[2]],[38,[2]]]],
 [25473,[[0,[2]],[5,[2]],[8,[2]],[14,[2]],[17,[2]],[20,[2]],[26,[2]],
     [29,[2]],[32,[2]],[38,[2]]]],
 [25474,[[0,[2]],[2,[2]],[8,[2]],[12,[2]],[14,[2]],[20,[2]],[24,[2]],
     [26,[2]],[32,[2]],[36,[2]]]],
 [25475,[[0,[1]],[5,[1]],[6,[1]],[8,[1]],[12,[1]],[17,[1]],[18,[1]],
     [20,[1]],[24,[1]],[29,[1]]]],
 [25476,[[0,[2]],[5,[1]],[6,[2]],[9,[1]],[12,[2]],[17,[1]],[18,[2]],
     [21,[1]],[24,[2]],[29,[1]]]],
 [25477,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [25478,[[0,[3]],[6,[3]],[12,[3]],[18,[3]],[24,[3]],[30,[3]],[36,[3]],
     [42,[3]],[48,[3]],[54,[3]]]],
 [25480,[[2,[1,2]],[5,[1,2]],[8,[1,2]],[14,[1,2]],[17,[1,2]],[20,[1,2]],
     [26,[1,2]],[29,[1,2]],[32,[1,2]],[38,[1,2]]]],
 [25484,[[0,[1,2]],[5,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],[17,[1,2]],
     [20,[1,2]],[29,[1,2]],[32,[1,2]],[36,[1,2]]]],
 [25487,[[1,[1]],[5,[2]],[9,[1]],[13,[1]],[17,[2]],[21,[1]],[25,[1]],
     [29,[2]],[33,[1]],[37,[1]]]],
 [25489,[[2,[1]],[5,[1]],[8,[1]],[14,[1]],[17,[1]],[20,[1]],[26,[1]],
     [29,[1]],[32,[1]],[38,[1]]]],
 [25491,[[2,[1]],[5,[1]],[8,[1]],[14,[2]],[17,[1]],[26,[3]],[29,[1]],
     [32,[2]],[41,[1]],[50,[10]]]],
 [25492,[[2,[1]],[5,[1]],[6,[1]],[14,[1]],[17,[1]],[18,[1]],[20,[1]],
     [26,[1]],[29,[1]],[38,[1]]]],
 [25494,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25495,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25497,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25499,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25500,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [25503,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25504,[[0,[2]],[12,[2]],[24,[2]],[36,[2]],[48,[2]],[60,[2]],[72,[2]],
     [84,[2]],[96,[2]],[108,[2]]]],
 [25505,[[0,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25506,[[1,[1]],[6,[1]],[13,[1]],[18,[1]],[25,[1]],[30,[1]],[37,[1]],
     [42,[1]],[49,[1]],[54,[1]]]],
 [25508,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25509,[[0,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25510,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25511,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25512,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25513,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25514,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25516,[[1,[2,3]],[13,[2,3]],[25,[2,3]],[37,[2,3]],[49,[2,3]],
     [61,[2,3]],[73,[2,3]],[85,[2,3]],[97,[2,3]],[109,[2,3]]]],
 [25517,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [61,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [25520,[[0,[1]],[12,[1]],[13,[1]],[36,[1]],[37,[1]],[48,[1]],[54,[1]],
     [61,[1]],[72,[1]],[85,[1]]]],
 [25521,[[1,[1]],[10,[1]],[25,[1]],[28,[1]],[34,[1]],[49,[1]],[64,[1]],
     [73,[1]],[82,[1]],[88,[1]]]],
 [25524,[[1,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25525,[[0,[1]],[13,[1]],[25,[1]],[37,[1]],[49,[1]],[61,[1]],[73,[1]],
     [85,[1]],[97,[1]],[109,[1]]]],
 [25528,[[1,[1,2]],[13,[1,2]],[25,[1,2]],[37,[1,2]],[49,[1,2]],
     [54,[1,2]],[73,[1,2]],[85,[1,2]],[97,[1,2]],[109,[1,2]]]],
 [25529,[[1,[2]],[13,[2]],[25,[2]],[37,[2]],[49,[2]],[61,[2]],[73,[2]],
     [85,[2]],[97,[2]],[109,[2]]]],
 [25533,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [25534,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25537,[[0,[2]],[2,[2]],[5,[1]],[6,[2]],[8,[2]],[12,[2]],[14,[2]],
     [17,[1]],[18,[2]],[20,[2]]]],
 [25538,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [25540,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [25541,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25546,[[0,[1,2]],[6,[1,2]],[12,[1,2]],[18,[1,2]],[24,[1,2]],[30,[1,2]],
     [36,[1,2]],[42,[1,2]],[48,[1,2]],[54,[1,2]]]],
 [25547,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],[25550,[[4,fail]]],[25551,[[4,fail]]],
 [25553,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [25554,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [25558,[[0,[1]],[5,[1]],[6,[1]],[12,[1]],[17,[1]],[18,[1]],[24,[1]],
     [29,[1]],[30,[1]],[36,[1]]]],
 [25560,[[2,[1]],[5,[1]],[8,[1]],[14,[1]],[17,[1]],[20,[1]],[26,[1]],
     [29,[1]],[32,[1]],[38,[1]]]],
 [25561,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [25566,[[1,[1,1,2]],[13,[1,1,2]],[25,[1,1,2]],[37,[1,1,2]],[49,[1,1,2]],
     [61,[1,1,2]],[73,[1,1,2]],[85,[1,1,2]],[97,[1,1,2]],[109,[1,1,2]]]]
  ,
 [25575,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25576,[[0,[2]],[2,[2]],[5,[1]],[8,[2]],[9,[1]],[13,[2]],[14,[2]],
     [17,[1]],[20,[2]],[21,[1]]]],
 [25595,[[1,[1]],[2,[2]],[8,[2]],[13,[1]],[14,[2]],[20,[2]],[25,[1]],
     [26,[2]],[32,[2]],[37,[1]]]],
 [25608,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25609,[[0,[3]],[4,[3]],[9,[1]],[10,[3]],[14,[3]],[16,[3]],[21,[1]],
     [22,[3]],[26,[3]],[28,[3]]]],
 [25613,[[4,[1,1,1,1,2]],[10,[1,1,1,1,2]],[16,[1,1,1,1,2]],
     [22,[1,1,1,1,2]],[28,[1,1,1,1,2]],[34,[1,1,1,1,2]],[40,[1,1,1,1,2]],
     [46,[1,1,1,1,2]],[52,[1,1,1,1,2]],[58,[1,1,1,1,2]]]],
 [25626,[[1,[2]],[9,[1]],[14,[2]],[21,[1]],[26,[2]],[33,[1]],[38,[2]],
     [45,[1]],[50,[2]],[57,[1]]]],
 [25628,[[1,[1]],[4,[2]],[10,[2]],[14,[1]],[16,[2]],[22,[2]],[26,[1]],
     [28,[2]],[34,[2]],[38,[1]]]],
 [25634,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [25640,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25641,[[0,[2]],[2,[2]],[8,[2]],[9,[1]],[13,[2]],[14,[2]],[20,[2]],
     [21,[1]],[25,[2]],[26,[2]]]],[25649,[[6,fail]]],[25651,[[6,fail]]],
 [25660,[[2,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [25664,[[0,[2]],[4,[2]],[10,[2]],[12,[2]],[16,[2]],[22,[2]],[24,[2]],
     [28,[2]],[34,[2]],[36,[2]]]],
 [25665,[[1,[1,2]],[4,[1,2]],[10,[1,2]],[13,[1,2]],[16,[1,2]],[22,[1,2]],
     [25,[1,2]],[28,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [25668,[[0,[2]],[4,[2]],[10,[2]],[12,[2]],[16,[2]],[22,[2]],[24,[2]],
     [28,[2]],[34,[2]],[36,[2]]]],
 [25669,[[0,[2]],[4,[2]],[10,[2]],[13,[2]],[16,[2]],[22,[2]],[25,[2]],
     [28,[2]],[34,[2]],[37,[2]]]],
 [25670,[[0,[2]],[4,[2]],[10,[2]],[13,[2]],[16,[2]],[22,[2]],[25,[2]],
     [28,[2]],[34,[2]],[37,[2]]]],
 [25671,[[1,[1]],[4,[1]],[6,[1]],[10,[1]],[13,[1]],[16,[1]],[18,[1]],
     [22,[1]],[25,[1]],[28,[1]]]],
 [25673,[[0,[1]],[1,[1]],[6,[1]],[12,[1]],[13,[1]],[18,[1]],[24,[1]],
     [25,[1]],[30,[1]],[36,[1]]]],
 [25674,[[0,[2]],[4,[2]],[10,[2]],[13,[2]],[16,[2]],[22,[2]],[25,[2]],
     [28,[2]],[34,[2]],[37,[2]]]],
 [25675,[[1,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25678,[[0,[2]],[1,[1]],[6,[2]],[9,[1]],[12,[2]],[13,[1]],[18,[2]],
     [21,[1]],[24,[2]],[25,[1]]]],
 [25679,[[0,[1]],[1,[1]],[6,[1]],[9,[1]],[12,[1]],[13,[1]],[18,[1]],
     [21,[1]],[24,[1]],[25,[1]]]],
 [25681,[[1,[1,2]],[4,[1,2]],[10,[1,2]],[13,[1,2]],[16,[1,2]],[22,[1,2]],
     [25,[1,2]],[28,[1,2]],[34,[1,2]],[37,[1,2]]]],
 [25685,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[12,[1,2]],[16,[1,2]],[22,[1,2]],
     [24,[1,2]],[25,[1,2]],[28,[1,2]],[30,[1,2]]]],
 [25689,[[1,[2]],[5,[1]],[9,[1]],[13,[2]],[17,[1]],[21,[1]],[25,[2]],
     [29,[1]],[33,[1]],[37,[2]]]],
 [25690,[[0,[1]],[4,[1]],[10,[1]],[13,[1]],[16,[1]],[22,[1]],[25,[1]],
     [28,[1]],[34,[1]],[37,[1]]]],
 [25693,[[1,[1]],[4,[1]],[10,[1]],[12,[1]],[13,[1]],[22,[1]],[25,[1]],
     [28,[1]],[30,[1]],[34,[1]]]],
 [25694,[[1,[1]],[4,[1]],[10,[2]],[13,[1]],[22,[5]],[25,[1]],[37,[1]],
     [46,[4]],[49,[1]],[58,[4]]]],
 [25699,[[0,[1]],[12,[1]],[24,[1]],[36,[1]],[48,[1]],[60,[1]],[72,[1]],
     [84,[1]],[96,[1]],[108,[1]]]],
 [25700,[[2,[1]],[8,[1]],[14,[1]],[20,[1]],[26,[1]],[32,[1]],[38,[1]],
     [44,[1]],[50,[1]],[56,[1]]]],
 [25701,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25708,[[0,[3]],[2,[3]],[8,[3]],[12,[3]],[14,[3]],[20,[3]],[24,[3]],
     [26,[3]],[32,[3]],[36,[3]]]],
 [25709,[[0,[1]],[2,[1]],[8,[1]],[12,[1]],[14,[1]],[20,[1]],[24,[1]],
     [26,[1]],[32,[1]],[36,[1]]]],
 [25713,[[0,[1,2]],[2,[3]],[8,[3]],[12,[1,2]],[14,[3]],[20,[3]],
     [24,[1,2]],[26,[3]],[32,[3]],[36,[1,2]]]],[25715,[[0,fail]]],
 [25719,[[0,[1,2]],[5,[1,2]],[12,[1,2]],[17,[1,2]],[24,[1,2]],[29,[1,2]],
     [36,[1,2]],[41,[1,2]],[48,[1,2]],[53,[1,2]]]],[25723,[[2,fail]]],
 [25726,[[0,[1]],[1,[2]],[2,[2]],[6,[1]],[8,[2]],[9,[1]],[12,[1]],
     [13,[2]],[14,[2]],[18,[1]]]],
 [25730,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25731,[[0,[2]],[2,[2]],[4,[1]],[8,[2]],[9,[1]],[10,[1]],[13,[2]],
     [14,[2]],[16,[1]],[20,[2]]]],
 [25742,[[0,[1]],[2,[1]],[6,[1]],[8,[1]],[12,[1]],[14,[1]],[18,[1]],
     [20,[1]],[24,[1]],[26,[1]]]],
 [25743,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [25747,[[1,[2]],[9,[1]],[13,[2]],[21,[1]],[25,[2]],[33,[1]],[37,[2]],
     [45,[1]],[49,[2]],[57,[1]]]],
 [25750,[[2,[1]],[4,[1]],[8,[1]],[10,[1]],[14,[1]],[16,[1]],[20,[1]],
     [22,[1]],[26,[1]],[28,[1]]]],
 [25760,[[0,[2]],[1,[1]],[5,[1]],[6,[2]],[9,[1]],[12,[2]],[13,[1]],
     [17,[1]],[18,[2]],[21,[1]]]],
 [25762,[[0,[2]],[1,[1]],[4,[2]],[9,[1]],[10,[2]],[12,[2]],[13,[1]],
     [16,[2]],[21,[1]],[22,[2]]]],
 [25765,[[0,[3]],[1,[1]],[5,[1]],[6,[3]],[9,[2]],[12,[3]],[13,[1]],
     [17,[1]],[18,[3]],[21,[2]]]],
 [25766,[[0,[3]],[1,[1]],[6,[3]],[9,[2]],[12,[3]],[13,[1]],[18,[3]],
     [21,[2]],[24,[3]],[25,[1]]]],
 [25772,[[0,[2]],[4,[1]],[5,[5]],[6,[5]],[13,[6]],[16,[1]],[17,[2]],
     [22,[3]],[24,[2]],[25,[4]]]],
 [25773,[[0,[1]],[1,[6]],[4,[2]],[9,[8]],[12,[1]],[13,[2]],[16,[3]],
     [18,[3]],[21,[6]],[24,[1]]]],
 [25776,[[0,[1]],[1,[2]],[5,[2]],[6,[1]],[9,[2]],[12,[1]],[13,[2]],
     [17,[2]],[18,[1]],[21,[2]]]],
 [25777,[[0,[2]],[4,[1]],[5,[2]],[9,[2]],[10,[1]],[13,[2]],[16,[1]],
     [17,[2]],[21,[2]],[22,[1]]]],
 [25782,[[0,[2]],[2,[2]],[5,[1]],[8,[2]],[9,[1]],[12,[2]],[14,[2]],
     [17,[1]],[20,[2]],[21,[1]]]],
 [25783,[[0,[2]],[1,[1]],[5,[1]],[6,[2]],[9,[1]],[12,[2]],[13,[1]],
     [17,[1]],[18,[2]],[21,[1]]]],
 [25790,[[0,[3]],[5,[1]],[6,[3]],[8,[2]],[12,[3]],[17,[1]],[18,[3]],
     [20,[2]],[24,[3]],[29,[1]]]],
 [25791,[[0,[3]],[1,[1]],[5,[1]],[6,[3]],[9,[2]],[12,[3]],[13,[1]],
     [17,[1]],[18,[3]],[21,[2]]]],
 [25802,[[0,[1]],[1,[2]],[5,[2]],[6,[1]],[9,[2]],[12,[1]],[13,[2]],
     [17,[2]],[18,[1]],[21,[2]]]],
 [25804,[[0,[2]],[2,[1]],[5,[2]],[8,[1]],[9,[2]],[13,[2]],[14,[1]],
     [17,[2]],[20,[1]],[21,[2]]]],
 [25806,[[0,[3]],[5,[6]],[6,[1]],[8,[7]],[9,[3]],[17,[2]],[18,[1]],
     [21,[3]],[24,[7]],[26,[2]]]],
 [25807,[[0,[1]],[1,[4]],[2,[1]],[5,[11]],[6,[2]],[13,[2]],[14,[1]],
     [17,[7]],[18,[3]],[20,[6]]]],
 [25809,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [25810,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25811,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25823,[[0,[1]],[2,[2]],[8,[2]],[12,[1]],[14,[2]],[20,[2]],[24,[1]],
     [26,[2]],[32,[2]],[36,[1]]]],
 [25835,[[0,[1,1,2]],[4,[1,1,2]],[10,[1,1,2]],[13,[1,1,2]],[16,[1,1,2]],
     [22,[1,1,2]],[25,[1,1,2]],[28,[1,1,2]],[34,[1,1,2]],[37,[1,1,2]]]],
 [25836,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [25839,[[4,[2]],[5,[2]],[10,[2]],[16,[2]],[17,[2]],[22,[2]],[28,[2]],
     [29,[2]],[34,[2]],[40,[2]]]],
 [25841,[[6,[1,1,1,2]],[18,[1,1,1,2]],[30,[1,1,1,2]],[42,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[78,[1,1,1,2]],[90,[1,1,1,2]],
     [102,[1,1,1,2]],[114,[1,1,1,2]]]],[25845,[[10,fail]]],
 [25846,[[4,fail]]],
 [25848,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [25860,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],
 [25862,[[0,[2]],[2,[2]],[8,[2]],[13,[2]],[14,[2]],[20,[2]],[25,[2]],
     [26,[2]],[32,[2]],[37,[2]]]],
 [25863,[[0,[1,1,2]],[4,[1,1,2]],[13,[1,1,2]],[16,[1,1,2]],[25,[1,1,2]],
     [28,[1,1,2]],[37,[1,1,2]],[40,[1,1,2]],[49,[1,1,2]],[52,[1,1,2]]]],
 [25868,[[0,[1,1,1,2]],[2,[1,1,1,2]],[8,[1,1,1,2]],[9,[1,1,1,2]],
     [13,[1,1,1,2]],[14,[1,1,1,2]],[20,[1,1,1,2]],[21,[1,1,1,2]],
     [25,[1,1,1,2]],[26,[1,1,1,2]]]],
 [25869,[[2,[1,2]],[4,[4,5]],[10,[10,11]],[16,[4,5]],[22,[7,8]],
     [28,[4,5]],[34,[16,17]],[40,[4,5]],[46,[7,8]],[52,[4,5]]]],
 [25874,[[0,fail]]],[25882,[[2,fail]]],
 [25885,[[6,[2]],[18,[2]],[30,[2]],[42,[2]],[54,[2]],[66,[2]],[78,[2]],
     [90,[2]],[102,[2]],[114,[2]]]],
 [25886,[[4,[2]],[5,[2]],[10,[2]],[16,[2]],[17,[2]],[22,[2]],[28,[2]],
     [29,[2]],[34,[2]],[40,[2]]]],
 [25887,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [25888,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [25889,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [25890,[[6,[3]],[18,[3]],[30,[3]],[42,[3]],[54,[3]],[66,[3]],[78,[3]],
     [90,[3]],[102,[3]],[114,[3]]]],
 [25891,[[6,[2,3]],[18,[2,3]],[30,[2,3]],[42,[2,3]],[54,[2,3]],
     [66,[2,3]],[78,[2,3]],[90,[2,3]],[102,[2,3]],[114,[2,3]]]],
 [25892,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [25894,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [25898,[[4,[1]],[16,[1]],[18,[1]],[40,[1]],[42,[1]],[52,[1]],[58,[1]],
     [66,[1]],[76,[1]],[90,[1]]]],
 [25899,[[1,[1]],[18,[1]],[20,[1]],[26,[1]],[42,[1]],[56,[1]],[66,[1]],
     [74,[1]],[80,[1]],[90,[1]]]],
 [25900,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25901,[[6,[1]],[18,[1]],[30,[1]],[42,[1]],[54,[1]],[66,[1]],[78,[1]],
     [90,[1]],[102,[1]],[114,[1]]]],
 [25904,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [66,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[104,[1,2]]]],
 [25906,[[6,[1,2]],[18,[1,2]],[30,[1,2]],[42,[1,2]],[54,[1,2]],
     [58,[1,2]],[78,[1,2]],[90,[1,2]],[102,[1,2]],[114,[1,2]]]],
 [25922,[[0,[2]],[4,[1]],[5,[2]],[9,[2]],[10,[1]],[13,[2]],[16,[1]],
     [17,[2]],[21,[2]],[22,[1]]]],
 [25923,[[0,[2]],[2,[1]],[5,[2]],[8,[1]],[9,[2]],[13,[2]],[14,[1]],
     [17,[2]],[20,[1]],[21,[2]]]],
 [25926,[[0,[1]],[2,[2]],[5,[4]],[9,[6]],[10,[1]],[14,[3]],[16,[4]],
     [17,[16]],[21,[7]],[22,[1]]]],
 [25928,[[0,[3]],[2,[1]],[4,[1]],[8,[5]],[9,[6]],[13,[3]],[14,[1]],
     [16,[6]],[21,[2]],[25,[8]]]],
 [25929,[[0,[1,1,2]],[5,[1,1,2]],[8,[1,1,2]],[14,[1,1,2]],[17,[1,1,2]],
     [20,[1,1,2]],[26,[1,1,2]],[29,[1,1,2]],[32,[1,1,2]],[38,[1,1,2]]]],
 [25930,[[0,[1,1,2]],[12,[1,1,2]],[24,[1,1,2]],[36,[1,1,2]],[48,[1,1,2]],
     [60,[1,1,2]],[72,[1,1,2]],[84,[1,1,2]],[96,[1,1,2]],[108,[1,1,2]]]]
  ,
 [25934,[[6,[1,1,1,2]],[18,[1,1,1,2]],[30,[1,1,1,2]],[42,[1,1,1,2]],
     [54,[1,1,1,2]],[66,[1,1,1,2]],[78,[1,1,1,2]],[90,[1,1,1,2]],
     [102,[1,1,1,2]],[114,[1,1,1,2]]]],[25936,[[8,fail]]],
 [25937,[[14,fail]]],
 [25939,[[0,[2]],[6,[2]],[12,[2]],[18,[2]],[24,[2]],[30,[2]],[36,[2]],
     [42,[2]],[48,[2]],[54,[2]]]],
 [25950,[[0,[2]],[8,[2]],[14,[2]],[20,[2]],[26,[2]],[32,[2]],[38,[2]],
     [44,[2]],[50,[2]],[56,[2]]]],
 [25951,[[4,[1,1,1,2]],[5,[1,1,1,2]],[8,[1,1,1,2]],[10,[1,1,1,2]],
     [16,[1,1,1,2]],[17,[1,1,1,2]],[20,[1,1,1,2]],[22,[1,1,1,2]],
     [28,[1,1,1,2]],[29,[1,1,1,2]]]],[25956,[[10,fail]]],[25960,[[4,fail]]],
 [25968,[[4,fail]]],
 [25978,[[0,[1]],[4,[2]],[10,[2]],[12,[1]],[16,[2]],[22,[2]],[24,[1]],
     [28,[2]],[34,[2]],[36,[1]]]],
 [25989,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [25995,[[0,[2]],[6,[2]],[8,[1]],[12,[2]],[18,[2]],[20,[1]],[24,[2]],
     [30,[2]],[32,[1]],[36,[2]]]],
 [26000,[[5,[1]],[12,[1]],[29,[1]],[30,[1]],[48,[1]],[53,[1]],[66,[1]],
     [77,[1]],[84,[1]],[101,[1]]]],
 [26002,[[5,[2,3]],[8,[2,3]],[17,[2,3]],[20,[2,3]],[29,[2,3]],[32,[2,3]],
     [41,[2,3]],[44,[2,3]],[53,[2,3]],[56,[2,3]]]],[26004,[[6,fail]]],
 [26012,[[0,[3]],[6,[3]],[9,[1]],[12,[3]],[18,[3]],[21,[1]],[24,[3]],
     [30,[3]],[33,[1]],[36,[3]]]],[26021,[[0,fail]]],
 [26024,[[0,[1]],[6,[1]],[12,[1]],[18,[1]],[24,[1]],[30,[1]],[36,[1]],
     [42,[1]],[48,[1]],[54,[1]]]],
 [26029,[[0,[3]],[6,[3]],[9,[1]],[12,[3]],[18,[3]],[21,[1]],[24,[3]],
     [30,[3]],[33,[1]],[36,[3]]]],[26031,[[0,fail]]],
 [26044,[[0,[2]],[6,[2]],[9,[1]],[12,[2]],[18,[2]],[21,[1]],[24,[2]],
     [30,[2]],[33,[1]],[36,[2]]]],[26046,[[0,fail]]],
 [26049,[[0,[1]],[13,[1]],[18,[1]],[36,[1]],[37,[1]],[54,[1]],[61,[1]],
     [72,[1]],[85,[1]],[90,[1]]]],
 [26050,[[0,[2,3]],[9,[2,3]],[13,[2,3]],[21,[2,3]],[25,[2,3]],[33,[2,3]],
     [37,[2,3]],[45,[2,3]],[49,[2,3]],[57,[2,3]]]],
 [26055,[[4,[1,2]],[10,[1,2]],[16,[1,2]],[22,[1,2]],[28,[1,2]],
     [34,[1,2]],[40,[1,2]],[46,[1,2]],[52,[1,2]],[58,[1,2]]]],
 [26056,[[6,[2,4]],[18,[2,4]],[30,[2,4]],[42,[2,4]],[54,[2,4]],
     [66,[2,4]],[78,[2,4]],[90,[2,4]],[102,[2,4]],[114,[2,4]]]],
 [26062,[[4,fail]]],[26063,[[0,fail]]],[26064,[[4,fail]]],
 [26069,[[2,[1,2]],[8,[1,2]],[14,[1,2]],[20,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[44,[1,2]],[50,[1,2]],[56,[1,2]]]],[26075,[[1,fail]]],
 [26076,[[1,fail]]],[26077,[[2,fail]]],[26087,[[0,fail]]],[26088,[[0,fail]]],
 [26089,[[0,fail]]],
 [26098,[[0,[1]],[1,[1]],[5,[1]],[6,[1]],[9,[1]],[12,[1]],[13,[1]],
     [17,[1]],[18,[1]],[21,[1]]]],
 [26099,[[0,[1,2]],[2,[1,2]],[6,[1,2]],[8,[1,2]],[12,[1,2]],[14,[1,2]],
     [18,[1,2]],[20,[1,2]],[24,[1,2]],[26,[1,2]]]],
 [26100,[[0,[1]],[2,[1]],[5,[1]],[8,[1]],[9,[1]],[13,[1]],[14,[1]],
     [17,[1]],[20,[1]],[21,[1]]]],
 [26108,[[0,[1,2]],[4,[1,2]],[6,[1,2]],[10,[1,2]],[12,[1,2]],[16,[1,2]],
     [18,[1,2]],[22,[1,2]],[24,[1,2]],[28,[1,2]]]],
 [26109,[[0,[1]],[1,[1]],[5,[1]],[6,[1]],[9,[1]],[12,[1]],[13,[1]],
     [17,[1]],[18,[1]],[21,[1]]]],
 [26110,[[0,[1]],[4,[1]],[5,[1]],[9,[1]],[10,[1]],[13,[1]],[16,[1]],
     [17,[1]],[21,[1]],[22,[1]]]],
 [26141,[[1,[1]],[4,[1]],[5,[1]],[9,[1]],[10,[1]],[13,[1]],[16,[1]],
     [17,[1]],[21,[1]],[22,[1]]]],
 [26146,[[1,[1]],[2,[1]],[5,[1]],[8,[1]],[9,[1]],[13,[1]],[14,[1]],
     [17,[1]],[20,[1]],[21,[1]]]],
 [26150,[[2,[1,2]],[4,[1,2]],[8,[1,2]],[10,[1,2]],[14,[1,2]],[16,[1,2]],
     [20,[1,2]],[22,[1,2]],[26,[1,2]],[28,[1,2]]]],
 [26174,[[12,[1]],[17,[1,2]],[42,[1]],[47,[1,2]],[72,[1]],[77,[1,2]],
     [102,[1]],[107,[1,2]],[132,[1]],[137,[1,2]]]],
 [26175,[[12,[1,2]],[17,[1]],[42,[1,2]],[47,[1]],[72,[1,2]],[77,[1]],
     [102,[1,2]],[107,[1]],[132,[1,2]],[137,[1]]]],
 [26182,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [26183,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [26185,[[7,[3,4]],[17,[3,4]],[37,[3,4]],[47,[3,4]],[67,[3,4]],
     [77,[3,4]],[97,[3,4]],[107,[3,4]],[127,[3,4]],[137,[3,4]]]],
 [26188,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],
     [57,[1,1,1,1,2]],[67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],
     [117,[1,1,1,1,2]],[127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [26190,[[7,[3,4]],[27,[3,4]],[37,[3,4]],[57,[3,4]],[67,[3,4]],
     [87,[3,4]],[97,[3,4]],[117,[3,4]],[127,[3,4]],[147,[3,4]]]],
 [26192,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],
     [57,[1,1,1,1,2]],[67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],
     [117,[1,1,1,1,2]],[127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [26194,[[2,[1,1,1,1,2]],[22,[1,1,1,1,2]],[32,[1,1,1,1,2]],
     [52,[1,1,1,1,2]],[62,[1,1,1,1,2]],[82,[1,1,1,1,2]],[92,[1,1,1,1,2]],
     [112,[1,1,1,1,2]],[122,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [26196,[[7,[1]],[12,[1,2]],[37,[1]],[42,[1,2]],[67,[1]],[72,[1,2]],
     [97,[1]],[102,[1,2]],[127,[1]],[132,[1,2]]]],
 [26197,[[7,[1,2]],[12,[1]],[37,[1,2]],[42,[1]],[67,[1,2]],[72,[1]],
     [97,[1,2]],[102,[1]],[127,[1,2]],[132,[1]]]],
 [26198,[[2,[3,4]],[22,[3,4]],[32,[3,4]],[52,[3,4]],[62,[3,4]],
     [82,[3,4]],[92,[3,4]],[112,[3,4]],[122,[3,4]],[142,[3,4]]]],
 [26199,[[0,[1,2]],[10,[1,2]],[12,[1,2]],[17,[1,2]],[20,[1,2]],
     [22,[1,2]],[30,[1,2]],[40,[1,2]],[42,[1,2]],[47,[1,2]]]],
 [26200,[[2,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[16,[1,2]],[26,[1,2]],
     [32,[1,2]],[36,[1,2]],[37,[1,2]],[42,[1,2]]]],
 [26226,[[12,[1,2]],[17,[1]],[42,[1,2]],[47,[1]],[72,[1,2]],[77,[1]],
     [102,[1,2]],[107,[1]],[132,[1,2]],[137,[1]]]],
 [26227,[[12,[1,2]],[17,[1,2]],[42,[1,2]],[47,[1,2]],[72,[1,2]],
     [77,[1,2]],[102,[1,2]],[107,[1,2]],[132,[1,2]],[137,[1,2]]]],
 [26234,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [26235,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [26237,[[7,[3,4]],[17,[3,4]],[37,[3,4]],[47,[3,4]],[67,[3,4]],
     [77,[3,4]],[97,[3,4]],[107,[3,4]],[127,[3,4]],[137,[3,4]]]],
 [26240,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],
     [57,[1,1,1,1,2]],[67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],
     [117,[1,1,1,1,2]],[127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [26242,[[7,[2,2,3]],[27,[2,2,3]],[37,[2,2,3]],[57,[2,2,3]],[67,[2,2,3]],
     [87,[2,2,3]],[97,[2,2,3]],[117,[2,2,3]],[127,[2,2,3]],[147,[2,2,3]] 
    ]],
 [26244,[[7,[1,1,2,2]],[27,[1,1,2,2]],[37,[1,1,2,2]],[57,[1,1,2,2]],
     [67,[1,1,2,2]],[87,[1,1,2,2]],[97,[1,1,2,2]],[117,[1,1,2,2]],
     [127,[1,1,2,2]],[147,[1,1,2,2]]]],
 [26246,[[2,[1,1,2,2]],[22,[1,1,2,2]],[32,[1,1,2,2]],[52,[1,1,2,2]],
     [62,[1,1,2,2]],[82,[1,1,2,2]],[92,[1,1,2,2]],[112,[1,1,2,2]],
     [122,[1,1,2,2]],[142,[1,1,2,2]]]],
 [26248,[[7,[1,2]],[12,[1]],[37,[1,2]],[42,[1]],[67,[1,2]],[72,[1]],
     [97,[1,2]],[102,[1]],[127,[1,2]],[132,[1]]]],
 [26249,[[7,[1,2]],[12,[1,2]],[37,[1,2]],[42,[1,2]],[67,[1,2]],
     [72,[1,2]],[97,[1,2]],[102,[1,2]],[127,[1,2]],[132,[1,2]]]],
 [26250,[[2,[3,4]],[22,[3,4]],[32,[3,4]],[52,[3,4]],[62,[3,4]],
     [82,[3,4]],[92,[3,4]],[112,[3,4]],[122,[3,4]],[142,[3,4]]]],
 [26251,[[0,[1]],[10,[1]],[12,[1]],[17,[1]],[20,[1]],[22,[1]],[30,[1]],
     [40,[1]],[42,[1]],[47,[1]]]],
 [26252,[[2,[1,2]],[6,[1,2]],[7,[1,2]],[12,[1,2]],[16,[1,2]],[26,[1,2]],
     [32,[1,2]],[36,[1,2]],[37,[1,2]],[42,[1,2]]]],
 [26278,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26282,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [26284,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [26286,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26287,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [26288,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26293,[[3,[1]],[8,[1]],[13,[1]],[16,[1]],[26,[1]],[28,[1]],[33,[1]],
     [38,[1]],[43,[1]],[46,[1]]]],
 [26298,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [26300,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26301,[[3,[1]],[23,[1]],[33,[1]],[53,[1]],[63,[1]],[83,[1]],[93,[1]],
     [113,[1]],[123,[1]],[143,[1]]]],
 [26302,[[1,[1]],[6,[1]],[11,[1]],[16,[1]],[18,[1]],[28,[1]],[31,[1]],
     [36,[1]],[41,[1]],[46,[1]]]],
 [26303,[[1,[1]],[3,[1]],[6,[1]],[8,[1]],[13,[1]],[18,[1]],[21,[1]],
     [26,[1]],[31,[1]],[33,[1]]]],
 [26328,[[11,[2]],[41,[2]],[71,[2]],[101,[2]],[131,[2]],[161,[2]],
     [191,[2]],[221,[2]],[251,[2]]]],
 [26334,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [26335,[[16,[3]],[46,[3]],[76,[3]],[106,[3]],[136,[3]],[166,[3]],
     [196,[3]],[226,[3]]]],
 [26336,[[1,[1,2]],[16,[1,2]],[31,[1,2]],[46,[1,2]],[61,[1,2]],
     [76,[1,2]],[91,[1,2]],[106,[1,2]],[121,[1,2]],[136,[1,2]]]],
 [26337,[[1,[1]],[5,[1]],[15,[1]],[16,[1]],[21,[1]],[25,[1]],[31,[1]],
     [35,[1]],[45,[1]],[46,[1]]]],
 [26338,[[5,[1,2]],[6,[1,2]],[11,[1,1,2]],[15,[1,2]],[21,[1,1,2]],
     [25,[1,2]],[35,[1,2]],[36,[1,2]],[41,[1,1,2]],[45,[1,2]]]],
 [26343,[[0,[1,1,1,2,2]],[7,[1,1,1,2,2]],[11,[1,1,1,2,2]],[17,[1,1,1,2,2]],
     [26,[1,1,1,2,2]],[27,[1,1,1,2,2]],[31,[1,1,1,2,2]],[37,[1,1,1,2,2]],
     [41,[1,1,1,2,2]],[47,[1,1,1,2,2]]]],
 [26350,[[6,[2]],[36,[2]],[66,[2]],[96,[2]],[126,[2]],[156,[2]],
     [186,[2]],[216,[2]],[246,[2]]]],
 [26351,[[0,[1,2]],[6,[1,1,2]],[10,[1,2]],[20,[1,2]],[21,[1,2]],
     [26,[1,1,2]],[30,[1,2]],[36,[1,1,2]],[40,[1,2]],[50,[1,2]]]],
 [26353,[[6,[3,4]],[16,[3,4]],[36,[3,4]],[46,[3,4]],[66,[3,4]],
     [76,[3,4]],[96,[3,4]],[106,[3,4]],[126,[3,4]],[136,[3,4]]]],
 [26377,[[11,[2]],[41,[2]],[71,[2]],[101,[2]],[131,[2]],[161,[2]],
     [191,[2]],[221,[2]],[251,[2]]]],
 [26383,[[7,[1]],[22,[1]],[37,[1]],[52,[1]],[67,[1]],[82,[1]],[97,[1]],
     [112,[1]],[127,[1]],[142,[1]]]],
 [26384,[[16,[1,2,3]],[46,[1,2,3]],[76,[1,2,3]],[106,[1,2,3]],
     [136,[1,2,3]],[166,[1,2,3]],[196,[1,2,3]],[226,[1,2,3]]]],
 [26385,[[1,[1,2]],[16,[1,2]],[31,[1,2]],[46,[1,2]],[61,[1,2]],
     [76,[1,2]],[91,[1,2]],[106,[1,2]],[121,[1,2]],[136,[1,2]]]],
 [26386,[[1,[1,2]],[5,[1,2]],[15,[1,2]],[16,[1,2]],[21,[1,2]],[25,[1,2]],
     [31,[1,2]],[35,[1,2]],[45,[1,2]],[46,[1,2]]]],
 [26387,[[5,[1,2]],[6,[1,2]],[11,[2]],[15,[1,2]],[21,[2]],[25,[1,2]],
     [35,[1,2]],[36,[1,2]],[41,[2]],[45,[1,2]]]],
 [26392,[[0,[1,2,2,2]],[7,[1,2,2,2]],[11,[1,2,2,2]],[17,[1,2,2,2]],
     [26,[1,2,2,2]],[27,[1,2,2,2]],[31,[1,2,2,2]],[37,[1,2,2,2]],
     [41,[1,2,2,2]],[47,[1,2,2,2]]]],
 [26399,[[6,[2]],[36,[2]],[66,[2]],[96,[2]],[126,[2]],[156,[2]],
     [186,[2]],[216,[2]],[246,[2]]]],
 [26400,[[0,[1,2]],[6,[2]],[10,[1,2]],[20,[1,2]],[21,[1,2]],[26,[2]],
     [30,[1,2]],[36,[2]],[40,[1,2]],[50,[1,2]]]],
 [26402,[[6,[3,4]],[16,[3,4]],[36,[3,4]],[46,[3,4]],[66,[3,4]],
     [76,[3,4]],[96,[3,4]],[106,[3,4]],[126,[3,4]],[136,[3,4]]]],
 [26425,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26433,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26434,[[3,[1]],[5,[1]],[15,[1]],[18,[1]],[23,[1]],[28,[1]],[33,[1]],
     [35,[1]],[45,[1]],[48,[1]]]],
 [26435,[[0,[1]],[5,[1]],[8,[1]],[13,[1]],[18,[1]],[20,[1]],[23,[1]],
     [25,[1]],[30,[1]],[35,[1]]]],
 [26438,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [26440,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [26442,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [26444,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [26447,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26448,[[3,[1]],[5,[1]],[8,[1]],[10,[1]],[15,[1]],[20,[1]],[23,[1]],
     [28,[1]],[33,[1]],[35,[1]]]],
 [26449,[[0,[1]],[5,[1]],[10,[1]],[13,[1]],[23,[1]],[25,[1]],[30,[1]],
     [35,[1]],[40,[1]],[43,[1]]]],
 [26450,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26472,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26476,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [26480,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26482,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26489,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [26491,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [26492,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [26494,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26495,[[3,[1]],[23,[1]],[33,[1]],[53,[1]],[63,[1]],[83,[1]],[93,[1]],
     [113,[1]],[123,[1]],[143,[1]]]],
 [26497,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26517,[[20,[2]],[50,[2]],[80,[2]],[110,[2]],[140,[2]],[170,[2]],
     [200,[2]],[230,[2]]]],
 [26518,[[5,[1,2]],[20,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [80,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[140,[1,2]]]],
 [26522,[[5,[1]],[20,[1]],[35,[1]],[50,[1]],[65,[1]],[80,[1]],[95,[1]],
     [110,[1]],[125,[1]],[140,[1]]]],
 [26526,[[10,[2,4]],[40,[2,4]],[70,[2,4]],[100,[2,4]],[130,[2,4]],
     [160,[2,4]],[190,[2,4]],[220,[2,4]],[250,[2,4]]]],
 [26527,[[0,[1,2,2,2]],[7,[1,2,2,2]],[15,[1,2,2,2]],[17,[1,2,2,2]],
     [25,[1,2,2,2]],[27,[1,2,2,2]],[30,[1,2,2,2]],[37,[1,2,2,2]],
     [45,[1,2,2,2]],[47,[1,2,2,2]]]],
 [26528,[[0,[1,2]],[5,[2]],[11,[1,2]],[15,[2]],[20,[1,2]],[21,[1,2]],
     [31,[1,2]],[35,[2]],[41,[1,2]],[45,[2]]]],
 [26538,[[0,[1]],[15,[1]],[30,[1]],[45,[1]],[60,[1]],[75,[1]],[90,[1]],
     [105,[1]],[120,[1]],[135,[1]]]],
 [26539,[[15,[2]],[45,[2]],[75,[2]],[105,[2]],[135,[2]],[165,[2]],
     [195,[2]],[225,[2]],[255,[2]]]],
 [26540,[[0,[1,2]],[15,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [75,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[135,[1,2]]]],
 [26541,[[0,[2]],[5,[1,2]],[6,[1,2]],[16,[1,2]],[20,[2]],[26,[1,2]],
     [30,[2]],[35,[1,2]],[36,[1,2]],[46,[1,2]]]],
 [26542,[[10,[3,4]],[20,[3,4]],[40,[3,4]],[50,[3,4]],[70,[3,4]],
     [80,[3,4]],[100,[3,4]],[110,[3,4]],[130,[3,4]],[140,[3,4]]]],
 [26543,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[45,[1,2]]]],
 [26562,[[20,[3]],[50,[3]],[80,[3]],[110,[3]],[140,[3]],[170,[3]],
     [200,[3]],[230,[3]]]],
 [26563,[[5,[1,2]],[20,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [80,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[140,[1,2]]]],
 [26567,[[5,[1,2]],[20,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [80,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[140,[1,2]]]],
 [26571,[[10,[3]],[40,[3]],[70,[3]],[100,[3]],[130,[3]],[160,[3]],
     [190,[3]],[220,[3]],[250,[3]]]],
 [26572,[[0,[1,1,2,1,2]],[7,[1,1,2,1,2]],[15,[1,1,2,1,2]],[17,[1,1,2,1,2]],
     [25,[1,1,2,1,2]],[27,[1,1,2,1,2]],[30,[1,1,2,1,2]],[37,[1,1,2,1,2]],
     [45,[1,1,2,1,2]],[47,[1,1,2,1,2]]]],
 [26573,[[0,[1]],[5,[2]],[11,[1]],[15,[2]],[20,[1]],[21,[1]],[31,[1]],
     [35,[2]],[41,[1]],[45,[2]]]],
 [26583,[[0,[1,2]],[15,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [75,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[135,[1,2]]]],
 [26584,[[15,[3]],[45,[3]],[75,[3]],[105,[3]],[135,[3]],[165,[3]],
     [195,[3]],[225,[3]],[255,[3]]]],
 [26585,[[0,[1,2]],[15,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [75,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[135,[1,2]]]],
 [26586,[[0,[2]],[5,[1]],[6,[1]],[16,[1]],[20,[2]],[26,[1]],[30,[2]],
     [35,[1]],[36,[1]],[46,[1]]]],
 [26587,[[10,[2,2,3]],[20,[2,2,3]],[40,[2,2,3]],[50,[2,2,3]],[70,[2,2,3]],
     [80,[2,2,3]],[100,[2,2,3]],[110,[2,2,3]],[130,[2,2,3]],[140,[2,2,3]] 
    ]],
 [26588,[[0,[1,2]],[6,[1,2]],[10,[1,2]],[15,[1,2]],[16,[1,2]],[26,[1,2]],
     [30,[1,2]],[36,[1,2]],[40,[1,2]],[45,[1,2]]]],
 [26607,[[2,[1,1,1,1,2,1,1,2]],[8,[1,1,1,1,2,1,1,2]],[13,[1]],
     [20,[1,1,1,1,2,1,1,2]],[26,[1,1,1,1,2,1,1,2]],[32,[1,1,1,1,2,1,1,2]],
     [38,[1,1,1,1,2,1,1,2]],[43,[1]],[50,[1,1,1,1,2,1,1,2]],
     [56,[1,1,1,1,2,1,1,2]]]],
 [26615,[[1,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[13,[1]],
     [18,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[43,[1]],[48,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [26628,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26629,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [26630,[[3,[1]],[22,[1]],[33,[1]],[52,[1]],[63,[1]],[82,[1]],[93,[1]],
     [112,[1]],[123,[1]],[142,[1]]]],
 [26649,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26650,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26657,[[1,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[13,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[43,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]]]],
 [26658,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26671,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[23,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[42,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [53,[1,1,1,1,1,1,1,2]]]],
 [26672,[[8,[1]],[12,[1]],[38,[1]],[42,[1]],[68,[1]],[72,[1]],[98,[1]],
     [102,[1]],[128,[1]],[132,[1]]]],
 [26673,[[3,[1]],[23,[1]],[33,[1]],[53,[1]],[63,[1]],[83,[1]],[93,[1]],
     [113,[1]],[123,[1]],[143,[1]]]],
 [26675,[[8,[1,2]],[18,[1,2]],[38,[1,2]],[48,[1,2]],[68,[1,2]],
     [78,[1,2]],[98,[1,2]],[108,[1,2]],[128,[1,2]],[138,[1,2]]]],
 [26692,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26699,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26700,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26702,[[8,[2]],[18,[2]],[38,[2]],[48,[2]],[68,[2]],[78,[2]],[98,[2]],
     [108,[2]],[128,[2]],[138,[2]]]],
 [26713,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [26715,[[3,[1]],[21,[1]],[33,[1]],[51,[1]],[63,[1]],[81,[1]],[93,[1]],
     [111,[1]],[123,[1]],[141,[1]]]],
 [26716,[[2,[1]],[12,[1]],[18,[1]],[22,[1]],[32,[1]],[42,[1]],[48,[1]],
     [52,[1]],[62,[1]],[72,[1]]]],
 [26717,[[2,[1,2]],[12,[1,2]],[18,[1,2]],[22,[1,2]],[32,[1,2]],
     [42,[1,2]],[48,[1,2]],[52,[1,2]],[62,[1,2]],[72,[1,2]]]],
 [26732,[[5,[1,1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,1,2]],[17,[1,2]],
     [23,[1,1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,1,2]],[35,[1,1,1,1,1,1,1,2]],
     [41,[1,1,1,1,1,1,1,2]],[47,[1,2]],[53,[1,1,1,1,1,1,1,2]],
     [58,[1,1,1,1,1,1,1,2]]]],
 [26733,[[13,[1]],[17,[1]],[43,[1]],[47,[1]],[73,[1]],[77,[1]],
     [103,[1]],[107,[1]],[133,[1]],[137,[1]]]],
 [26741,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26743,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26753,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [18,[1,1,1,1,2,1,1,2]],[23,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[48,[1,1,1,1,2,1,1,2]],
     [53,[1,1,1,1,2,1,1,2]]]],
 [26755,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26756,[[2,[1,2]],[23,[1,2]],[32,[1,2]],[53,[1,2]],[62,[1,2]],
     [83,[1,2]],[92,[1,2]],[113,[1,2]],[122,[1,2]],[143,[1,2]]]],
 [26758,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [26772,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [26781,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26782,[[1,[1]],[5,[1]],[11,[1]],[15,[1]],[18,[1]],[21,[1]],[23,[1]],
     [25,[1]],[31,[1]],[35,[1]]]],
 [26783,[[1,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [23,[1,2]],[25,[1,2]],[31,[1,2]],[35,[1,2]]]],
 [26795,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [26796,[[2,[3]],[23,[3]],[32,[3]],[53,[3]],[62,[3]],[83,[3]],[92,[3]],
     [113,[3]],[122,[3]],[143,[3]]]],
 [26797,[[0,[1,1,2]],[12,[1,1,2]],[20,[2,3,3]],[30,[1,1,2]],[42,[1,1,2]],
     [50,[2,3,3]],[60,[1,1,2]],[72,[1,1,2]],[80,[2,3,3]],[90,[1,1,2]]]],
 [26798,[[8,[3]],[18,[3]],[38,[3]],[48,[3]],[68,[3]],[78,[3]],[98,[3]],
     [108,[3]],[128,[3]],[138,[3]]]],
 [26812,[[13,[2]],[43,[2]],[73,[2]],[103,[2]],[133,[2]],[163,[2]],
     [193,[2]],[223,[2]],[253,[2]]]],
 [26818,[[7,[1]],[22,[1]],[37,[1]],[52,[1]],[67,[1]],[82,[1]],[97,[1]],
     [112,[1]],[127,[1]],[142,[1]]]],
 [26820,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [26822,[[8,[1,2]],[18,[1,2]],[38,[1,2]],[48,[1,2]],[68,[1,2]],
     [78,[1,2]],[98,[1,2]],[108,[1,2]],[128,[1,2]],[138,[1,2]]]],
 [26832,[[3,[1]],[18,[1]],[33,[1]],[48,[1]],[63,[1]],[78,[1]],[93,[1]],
     [108,[1]],[123,[1]],[138,[1]]]],
 [26834,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [26835,[[3,[1,2]],[20,[1,2]],[33,[1,2]],[50,[1,2]],[63,[1,2]],
     [80,[1,2]],[93,[1,2]],[110,[1,2]],[123,[1,2]],[140,[1,2]]]],
 [26850,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26858,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26860,[[5,[2]],[18,[2]],[20,[2]],[35,[2]],[48,[2]],[50,[2]],[65,[2]],
     [78,[2]],[80,[2]],[95,[2]]]],
 [26871,[[12,[1]],[13,[1]],[42,[1]],[43,[1]],[72,[1]],[73,[1]],
     [102,[1]],[103,[1]],[132,[1]],[133,[1]]]],
 [26873,[[2,[1,2]],[17,[1,2]],[23,[1,2]],[32,[1,2]],[47,[1,2]],
     [53,[1,2]],[62,[1,2]],[77,[1,2]],[83,[1,2]],[92,[1,2]]]],
 [26875,[[0,[1,2]],[2,[1]],[6,[1]],[10,[1,2]],[13,[1]],[16,[1]],
     [18,[1,2]],[20,[3]],[26,[1]],[30,[1,2]]]],
 [26882,[[11,[1,1,2]],[37,[1]],[77,[1]],[97,[1,1,2]],[131,[1]],
     [137,[1,1,2]],[157,[1]],[217,[1,1,2]],[251,[1,1,2]]]],
 [26888,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26889,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26890,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [26891,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [26892,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26894,[[1,[1,1,1,1,2]],[13,[1,2]],[18,[1,1,1,1,2]],[23,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[43,[1,2]],[48,[1,1,1,1,2]],[53,[1,1,1,1,2]],
     [61,[1,1,1,1,2]],[73,[1,2]]]],
 [26895,[[1,[1,1,1,2]],[2,[1,1,1,2]],[7,[1,1,1,2]],[8,[1,1,1,2]],
     [13,[2]],[18,[1,1,1,2]],[20,[1,1,1,2]],[25,[1,1,1,2]],
     [26,[1,1,1,2]],[31,[1,1,1,2]]]],
 [26896,[[5,[2]],[15,[2]],[25,[2]],[35,[2]],[45,[2]],[55,[2]],[65,[2]],
     [75,[2]],[85,[2]],[95,[2]]]],
 [26898,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [26899,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [26900,[[13,[3]],[43,[3]],[73,[3]],[103,[3]],[133,[3]],[163,[3]],
     [193,[3]],[223,[3]],[253,[3]]]],
 [26901,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26902,[[13,[2,4]],[43,[2,4]],[73,[2,4]],[103,[2,4]],[133,[2,4]],
     [163,[2,4]],[193,[2,4]],[223,[2,4]],[253,[2,4]]]],
 [26903,[[13,[3]],[43,[3]],[73,[3]],[103,[3]],[133,[3]],[163,[3]],
     [193,[3]],[223,[3]],[253,[3]]]],
 [26904,[[13,[2,4]],[43,[2,4]],[73,[2,4]],[103,[2,4]],[133,[2,4]],
     [163,[2,4]],[193,[2,4]],[223,[2,4]],[253,[2,4]]]],
 [26905,[[13,[3,4]],[43,[3,4]],[73,[3,4]],[103,[3,4]],[133,[3,4]],
     [163,[3,4]],[193,[3,4]],[223,[3,4]],[253,[3,4]]]],
 [26906,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [26907,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [26908,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [26909,[[8,[1,2]],[12,[1,2]],[38,[1,2]],[42,[1,2]],[68,[1,2]],
     [72,[1,2]],[98,[1,2]],[102,[1,2]],[128,[1,2]],[132,[1,2]]]],
 [26911,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26914,[[11,[2]],[23,[1]],[31,[3]],[51,[2]],[71,[3]],[83,[1]],[91,[2]],
     [111,[3]],[131,[2]],[143,[1]]]],
 [26915,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [26917,[[5,[1,2]],[30,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [90,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[150,[1,2]]]],
 [26920,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26921,[[13,[2,3]],[43,[2,3]],[73,[2,3]],[103,[2,3]],[133,[2,3]],
     [163,[2,3]],[193,[2,3]],[223,[2,3]],[253,[2,3]]]],
 [26923,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26924,[[8,[1,2,2,3]],[43,[3,4]],[68,[1,2,2,3]],[73,[1,2,2,3]],
     [128,[1,2,2,3]],[133,[3,4]],[163,[1,2,2,3]],[188,[1,2,2,3]],
     [223,[3,4]],[248,[1,2,2,3]]]],
 [26927,[[5,[1,1,1,1,2,1,1,2]],[11,[1,1,1,1,2,1,1,2]],[17,[1]],
     [23,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[35,[1,1,1,1,2,1,1,2]],
     [41,[1,1,1,1,2,1,1,2]],[47,[1]],[53,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [26929,[[3,[1,1,1,1,1,1,2,2]],[10,[1,1,1,1,1,1,2,2]],[16,[1]],
     [22,[1,1,1,1,1,1,2,2]],[28,[1,1,1,1,1,1,2,2]],[33,[1,1,1,1,1,1,2,2]],
     [40,[1,1,1,1,1,1,2,2]],[46,[1]],[52,[1,1,1,1,1,1,2,2]],
     [58,[1,1,1,1,1,1,2,2]]]],
 [26931,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26933,[[7,[1]],[18,[1]],[37,[1]],[48,[1]],[67,[1]],[78,[1]],[97,[1]],
     [108,[1]],[127,[1]],[138,[1]]]],
 [26942,[[3,[1,1,1,1,2]],[23,[1,1,1,1,2]],[33,[1,1,1,1,2]],
     [53,[1,1,1,1,2]],[63,[1,1,1,1,2]],[83,[1,1,1,1,2]],[93,[1,1,1,1,2]],
     [113,[1,1,1,1,2]],[123,[1,1,1,1,2]],[143,[1,1,1,1,2]]]],
 [26943,[[3,[1,1,1,1,2]],[23,[1,1,1,1,2]],[33,[1,1,1,1,2]],
     [53,[1,1,1,1,2]],[63,[1,1,1,1,2]],[83,[1,1,1,1,2]],[93,[1,1,1,1,2]],
     [113,[1,1,1,1,2]],[123,[1,1,1,1,2]],[143,[1,1,1,1,2]]]],
 [26945,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [26948,[[7,[1]],[18,[1]],[37,[1]],[48,[1]],[67,[1]],[78,[1]],[97,[1]],
     [108,[1]],[127,[1]],[138,[1]]]],
 [26966,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [26967,[[5,[2,3,3]],[25,[2,3,3]],[35,[2,3,3]],[55,[2,3,3]],[65,[2,3,3]],
     [85,[2,3,3]],[95,[2,3,3]],[115,[2,3,3]],[125,[2,3,3]],[145,[2,3,3]] 
    ]],
 [26968,[[7,[1]],[11,[1,1,2]],[18,[2,2,3]],[37,[1]],[41,[1,1,2]],
     [48,[2,2,3]],[67,[1]],[71,[1,1,2]],[78,[2,2,3]],[97,[1]]]],
 [26980,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [26981,[[0,[1,2]],[10,[1,2]],[20,[1,2]],[23,[1,2]],[30,[1,2]],
     [40,[1,2]],[50,[1,2]],[53,[1,2]],[60,[1,2]],[70,[1,2]]]],
 [26982,[[0,[1]],[10,[1]],[20,[1]],[23,[1]],[30,[1]],[40,[1]],[50,[1]],
     [53,[1]],[60,[1]],[70,[1]]]],
 [26983,[[7,[1]],[18,[1]],[37,[1]],[48,[1]],[67,[1]],[78,[1]],[97,[1]],
     [108,[1]],[127,[1]],[138,[1]]]],
 [26996,[[8,[1]],[23,[1]],[38,[1]],[53,[1]],[68,[1]],[83,[1]],[98,[1]],
     [113,[1]],[128,[1]],[143,[1]]]],
 [26999,[[13,[1,2,2]],[43,[1,2,2]],[73,[1,2,2]],[103,[1,2,2]],
     [133,[1,2,2]],[163,[1,2,2]],[193,[1,2,2]],[223,[1,2,2]],
     [253,[1,2,2]]]],
 [27000,[[13,[2,3]],[43,[2,3]],[73,[2,3]],[103,[2,3]],[133,[2,3]],
     [163,[2,3]],[193,[2,3]],[223,[2,3]],[253,[2,3]]]],
 [27014,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [27017,[[8,[1,2]],[18,[1,2]],[38,[1,2]],[48,[1,2]],[68,[1,2]],
     [78,[1,2]],[98,[1,2]],[108,[1,2]],[128,[1,2]],[138,[1,2]]]],
 [27031,[[3,[2,2,3,3]],[10,[2,2,3,3]],[16,[1]],[17,[1]],[22,[2,2,3,3]],
     [28,[2,2,3,3]],[33,[2,2,3,3]],[40,[2,2,3,3]],[46,[1]],[47,[1]]]],
 [27035,[[8,[2]],[11,[2]],[26,[2]],[38,[2]],[41,[2]],[56,[2]],[68,[2]],
     [71,[2]],[86,[2]],[98,[2]]]],
 [27036,[[8,[1,1,1,1,2]],[28,[1,1,1,1,2]],[38,[1,1,1,1,2]],
     [58,[1,1,1,1,2]],[68,[1,1,1,1,2]],[88,[1,1,1,1,2]],[98,[1,1,1,1,2]],
     [118,[1,1,1,1,2]],[128,[1,1,1,1,2]],[148,[1,1,1,1,2]]]],
 [27038,[[8,[2,3,4]],[28,[2,3,4]],[38,[2,3,4]],[58,[2,3,4]],[68,[2,3,4]],
     [88,[2,3,4]],[98,[2,3,4]],[118,[2,3,4]],[128,[2,3,4]],[148,[2,3,4]] 
    ]],
 [27042,[[8,[1,2]],[28,[1,2]],[38,[1,2]],[58,[1,2]],[68,[1,2]],
     [88,[1,2]],[98,[1,2]],[118,[1,2]],[128,[1,2]],[148,[1,2]]]],
 [27047,[[3,[1]],[8,[2,3]],[26,[1]],[33,[1]],[38,[2,3]],[56,[1]],
     [63,[1]],[68,[2,3]],[86,[1]],[93,[1]]]],
 [27050,[[1,[1,2]],[8,[1,2]],[12,[1,2]],[22,[1,2]],[26,[1,2]],[32,[1,2]],
     [38,[1,2]],[42,[1,2]],[52,[1,2]],[56,[1,2]]]],
 [27067,[[8,[2]],[18,[2]],[38,[2]],[48,[2]],[68,[2]],[78,[2]],[98,[2]],
     [108,[2]],[128,[2]],[138,[2]]]],
 [27072,[[7,[2,3,4]],[25,[2,3,4]],[37,[2,3,4]],[55,[2,3,4]],[67,[2,3,4]],
     [85,[2,3,4]],[97,[2,3,4]],[115,[2,3,4]],[127,[2,3,4]],[145,[2,3,4]] 
    ]],
 [27076,[[8,[2]],[38,[2]],[68,[2]],[98,[2]],[128,[2]],[158,[2]],
     [188,[2]],[218,[2]],[248,[2]]]],
 [27079,[[8,[3]],[38,[3]],[68,[3]],[98,[3]],[128,[3]],[158,[3]],
     [188,[3]],[218,[3]],[248,[3]]]],
 [27080,[[3,[1,2]],[6,[2,3]],[8,[1]],[16,[2,3]],[26,[2,3]],[33,[1,2]],
     [36,[2,3]],[38,[1]],[46,[2,3]],[56,[2,3]]]],
 [27082,[[3,[1]],[6,[2,3]],[8,[1,2]],[16,[2,3]],[26,[2,3]],[33,[1]],
     [36,[2,3]],[38,[1,2]],[46,[2,3]],[56,[2,3]]]],
 [27096,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [27098,[[1,[1,2]],[11,[1,2]],[18,[2,4]],[21,[1,2]],[31,[1,2]],
     [41,[1,2]],[48,[2,4]],[51,[1,2]],[61,[1,2]],[71,[1,2]]]],
 [27107,[[3,[2,3,4]],[23,[2,3,4]],[33,[2,3,4]],[53,[2,3,4]],[63,[2,3,4]],
     [83,[2,3,4]],[93,[2,3,4]],[113,[2,3,4]],[123,[2,3,4]],[143,[2,3,4]] 
    ]],
 [27110,[[3,[1]],[18,[1]],[33,[1]],[48,[1]],[63,[1]],[78,[1]],[93,[1]],
     [108,[1]],[123,[1]],[138,[1]]]],
 [27113,[[3,[3]],[18,[6]],[33,[3]],[48,[6]],[63,[3]],[78,[6]],[93,[3]],
     [108,[6]],[123,[3]],[138,[6]]]],
 [27125,[[16,[1,1,2]],[36,[1]],[76,[1]],[96,[1,1,2]],[136,[1,1,2]],
     [156,[1]],[196,[1]],[216,[1,1,2]]]],
 [27126,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [27139,[[0,[2,2,2,3]],[6,[2,2,2,3]],[12,[1,2]],[13,[1,2]],[18,[2,2,2,3]],
     [23,[2,2,2,3]],[30,[2,2,2,3]],[36,[2,2,2,3]],[42,[1,2]],[43,[1,2]] 
    ]],
 [27140,[[1,[1]],[12,[1]],[13,[1]],[16,[1]],[18,[1]],[31,[1]],[42,[1]],
     [43,[1]],[46,[1]],[48,[1]]]],
 [27141,[[0,[1,2]],[10,[1,2]],[16,[1,2]],[20,[1,2]],[23,[1,2]],
     [30,[1,2]],[40,[1,2]],[46,[1,2]],[50,[1,2]],[53,[1,2]]]],
 [27142,[[0,fail]]],
 [27143,[[1,[1,2]],[16,[1,2]],[18,[3]],[31,[1,2]],[46,[1,2]],[48,[3]],
     [61,[1,2]],[76,[1,2]],[78,[3]],[91,[1,2]]]],
 [27156,[[1,[1,2]],[15,[1,2]],[16,[1,2]],[25,[1,2]],[31,[1,2]],
     [45,[1,2]],[46,[1,2]],[55,[1,2]],[61,[1,2]],[75,[1,2]]]],
 [27158,[[10,[1]],[12,[1]],[40,[1]],[42,[1]],[70,[1]],[72,[1]],
     [100,[1]],[102,[1]],[130,[1]],[132,[1]]]],
 [27159,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27160,[[10,[4,5]],[40,[4,5]],[70,[4,5]],[100,[4,5]],[130,[4,5]],
     [160,[4,5]],[190,[4,5]],[220,[4,5]],[250,[4,5]]]],
 [27161,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [27162,[[13,[3,4]],[43,[3,4]],[73,[3,4]],[103,[3,4]],[133,[3,4]],
     [163,[3,4]],[193,[3,4]],[223,[3,4]],[253,[3,4]]]],
 [27163,[[6,[2,3]],[36,[2,3]],[66,[2,3]],[96,[2,3]],[126,[2,3]],
     [156,[2,3]],[186,[2,3]],[216,[2,3]],[246,[2,3]]]],
 [27164,[[3,[1]],[10,[2,4]],[26,[1]],[33,[1]],[40,[2,4]],[56,[1]],
     [63,[1]],[70,[2,4]],[86,[1]],[93,[1]]]],
 [27165,[[10,[4,5]],[40,[4,5]],[70,[4,5]],[100,[4,5]],[130,[4,5]],
     [160,[4,5]],[190,[4,5]],[220,[4,5]],[250,[4,5]]]],
 [27166,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [27167,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [27168,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [27169,[[8,[1,2]],[12,[1,2]],[38,[1,2]],[42,[1,2]],[68,[1,2]],
     [72,[1,2]],[98,[1,2]],[102,[1,2]],[128,[1,2]],[132,[1,2]]]],
 [27171,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [27174,[[2,[1,2]],[31,[1,2]],[33,[1,2]],[51,[1,2]],[63,[1,2]],
     [91,[1,2]],[93,[1,2]],[111,[1,2]],[123,[1,2]],[151,[1,2]]]],
 [27175,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [27177,[[10,[3,5]],[30,[3,5]],[50,[3,5]],[70,[3,5]],[90,[3,5]],
     [110,[3,5]],[130,[3,5]],[150,[3,5]],[170,[3,5]],[190,[3,5]]]],
 [27179,[[7,[1,1,2,2]],[43,[1,2]],[67,[1,1,2,2]],[73,[1,1,2,2]],
     [127,[1,1,2,2]],[133,[1,2]],[163,[1,1,2,2]],[187,[1,1,2,2]],
     [223,[1,2]],[247,[1,1,2,2]]]],
 [27180,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [27181,[[13,[4]],[43,[4]],[73,[4]],[103,[4]],[133,[4]],[163,[4]],
     [193,[4]],[223,[4]],[253,[4]]]],
 [27183,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [27185,[[1,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[18,[1,2]],[21,[1,2]],
     [23,[1,2]],[25,[1,2]],[31,[1,2]],[35,[1,2]]]],
 [27187,[[3,[1,1,1,1,2]],[5,[1,1,1,1,2]],[7,[1,1,1,1,2]],[15,[1,1,1,1,2]],
     [17,[1,1,1,1,2]],[25,[1,1,1,1,2]],[27,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [33,[1,1,1,1,2]],[35,[1,1,1,1,2]]]],
 [27190,[[3,[1,2]],[5,[1,2]],[7,[1,2]],[15,[1,2]],[17,[1,2]],[25,[1,2]],
     [27,[1,2]],[28,[1,2]],[33,[1,2]],[35,[1,2]]]],
 [27192,[[3,[1]],[5,[2]],[11,[1]],[15,[2]],[25,[2]],[28,[2]],[33,[1]],
     [35,[2]],[41,[1]],[45,[2]]]],
 [27213,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [27214,[[6,[1]],[18,[1]],[36,[1]],[48,[1]],[66,[1]],[78,[1]],[96,[1]],
     [108,[1]],[126,[1]],[138,[1]]]],
 [27216,[[6,[1]],[18,[1]],[36,[1]],[48,[1]],[66,[1]],[78,[1]],[96,[1]],
     [108,[1]],[126,[1]],[138,[1]]]],
 [27217,[[7,[2,4]],[8,[2,4]],[17,[2,4]],[27,[2,4]],[37,[2,4]],[38,[2,4]],
     [47,[2,4]],[57,[2,4]],[67,[2,4]],[68,[2,4]]]],
 [27218,[[7,[3]],[8,[3]],[17,[3]],[27,[3]],[37,[3]],[38,[3]],[47,[3]],
     [57,[3]],[67,[3]],[68,[3]]]],
 [27219,[[8,[2,4]],[11,[2,4]],[26,[2,4]],[38,[2,4]],[41,[2,4]],
     [56,[2,4]],[68,[2,4]],[71,[2,4]],[86,[2,4]],[98,[2,4]]]],
 [27221,[[8,[2]],[23,[1]],[38,[2]],[53,[1]],[68,[2]],[83,[1]],[98,[2]],
     [113,[1]],[128,[2]],[143,[1]]]],
 [27222,[[1,[1]],[11,[1]],[18,[2]],[21,[1]],[31,[1]],[41,[1]],[48,[2]],
     [51,[1]],[61,[1]],[71,[1]]]],
 [27224,[[1,[1,1,2]],[8,[3]],[18,[3,3,4]],[21,[1,1,2]],[31,[1,1,2]],
     [38,[3,4]],[48,[2,3,3,3,2,4]],[51,[1,1,2]],[61,[1,1,2]],[68,[3]]]],
 [27229,[[7,[1]],[18,[1,2]],[27,[1,2]],[47,[1]],[48,[1]],[67,[1,2]],
     [78,[1,2]],[87,[1]],[107,[1,2]],[108,[1]]]],
 [27232,[[1,[2]],[6,[2]],[8,[1]],[11,[1]],[15,[1]],[21,[1]],[23,[2]],
     [27,[1]],[30,[1]]]],
 [27233,[[5,[2,3,2,4]],[18,[1]],[25,[1]],[45,[2,3,2,4]],[48,[2,3,2,4]],
     [65,[1]],[78,[1]],[85,[2,3,2,4]],[105,[1]],[108,[2,3,2,4]]]],
 [27235,[[8,[1,2]],[11,[1,2]],[13,[1]],[31,[1]],[37,[1]],[38,[1]],
     [51,[1,2]],[68,[1,2]],[71,[1]],[73,[1,2]]]],
 [27236,[[8,[1]],[15,[2,4]],[35,[1]],[38,[2,3]],[55,[2,3]],[68,[1]],
     [75,[1]],[95,[2,4]],[98,[2,4]],[115,[1]]]],
 [27241,[[3,[1,1,1,1,1,1,2,2]],[10,[1,1,1,1,1,1,2,2]],[16,[1]],
     [22,[1,1,1,1,1,1,2,2]],[28,[1,1,1,1,1,1,2,2]],[33,[1,1,1,1,1,1,2,2]],
     [40,[1,1,1,1,1,1,2,2]],[46,[1]],[52,[1,1,1,1,1,1,2,2]],
     [58,[1,1,1,1,1,1,2,2]]]],
 [27245,[[8,[1,1,1,1,2]],[28,[1,1,1,1,2]],[38,[1,1,1,1,2]],
     [58,[1,1,1,1,2]],[68,[1,1,1,1,2]],[88,[1,1,1,1,2]],[98,[1,1,1,1,2]],
     [118,[1,1,1,1,2]],[128,[1,1,1,1,2]],[148,[1,1,1,1,2]]]],
 [27247,[[3,[1,1,1,1,2,1,1,2]],[8,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[33,[1,1,1,1,2,1,1,2]],
     [38,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [27250,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [27253,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],
 [27268,[[3,[1,1,1,1,2]],[5,[1,1,1,1,2]],[7,[1,1,1,1,2]],[15,[1,1,1,1,2]],
     [17,[1,1,1,1,2]],[25,[1,1,1,1,2]],[27,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [33,[1,1,1,1,2]],[35,[1,1,1,1,2]]]],
 [27275,[[6,[1,2]],[36,[1,2]],[66,[1,2]],[96,[1,2]],[126,[1,2]],
     [156,[1,2]],[186,[1,2]],[216,[1,2]],[246,[1,2]]]],
 [27276,[[3,[2]],[23,[2]],[33,[2]],[53,[2]],[63,[2]],[83,[2]],[93,[2]],
     [113,[2]],[123,[2]],[143,[2]]]],
 [27278,[[6,[2,2,3]],[16,[1,1,2]],[18,[1]],[36,[2,2,3]],[46,[1,1,2]],
     [48,[1]],[66,[2,2,3]],[76,[1,1,2]],[78,[1]],[96,[2,2,3]]]],
 [27295,[[10,[3]],[40,[3]],[70,[3]],[100,[3]],[130,[3]],[160,[3]],
     [190,[3]],[220,[3]],[250,[3]]]],
 [27296,[[3,[2,2,3,3]],[8,[2,2,3,3]],[15,[1]],[16,[1]],[21,[2,2,3,3]],
     [27,[2,2,3,3]],[33,[2,2,3,3]],[38,[2,2,3,3]],[45,[1]],[46,[1]]]],
 [27299,[[7,[2,3]],[22,[2,3]],[37,[2,3]],[52,[2,3]],[67,[2,3]],
     [82,[2,3]],[97,[2,3]],[112,[2,3]],[127,[2,3]],[142,[2,3]]]],
 [27302,[[8,[3]],[10,[3]],[25,[3]],[38,[3]],[40,[3]],[55,[3]],[68,[3]],
     [70,[3]],[85,[3]],[98,[3]]]],
 [27321,[[12,[1,1,2]],[42,[1,1,2]],[72,[1,1,2]],[102,[1,1,2]],
     [132,[1,1,2]],[162,[1,1,2]],[192,[1,1,2]],[222,[1,1,2]],
     [252,[1,1,2]]]],
 [27322,[[6,[2,3]],[36,[2,3]],[66,[2,3]],[96,[2,3]],[126,[2,3]],
     [156,[2,3]],[186,[2,3]],[216,[2,3]],[246,[2,3]]]],
 [27323,[[0,[1]],[23,[1]],[30,[1]],[53,[1]],[60,[1]],[83,[1]],[90,[1]],
     [113,[1]],[120,[1]],[143,[1]]]],
 [27325,[[6,[1]],[18,[1]],[36,[1]],[48,[1]],[66,[1]],[78,[1]],[96,[1]],
     [108,[1]],[126,[1]],[138,[1]]]],
 [27338,[[7,[2]],[8,[2]],[17,[2]],[27,[2]],[37,[2]],[38,[2]],[47,[2]],
     [57,[2]],[67,[2]],[68,[2]]]],
 [27342,[[3,[2]],[7,[2]],[17,[2]],[21,[1]],[27,[2]],[28,[1]],[33,[2]],
     [37,[2]],[47,[2]],[51,[1]]]],
 [27360,[[13,[2]],[43,[2]],[73,[2]],[103,[2]],[133,[2]],[163,[2]],
     [193,[2]],[223,[2]],[253,[2]]]],
 [27365,[[8,[2,3]],[38,[2,3]],[68,[2,3]],[98,[2,3]],[128,[2,3]],
     [158,[2,3]],[188,[2,3]],[218,[2,3]],[248,[2,3]]]],
 [27366,[[0,[1]],[23,[1]],[30,[1]],[53,[1]],[60,[1]],[83,[1]],[90,[1]],
     [113,[1]],[120,[1]],[143,[1]]]],
 [27367,[[6,[1,1,2]],[20,[1,1,2]],[36,[1,1,2]],[50,[1,1,2]],[66,[1,1,2]],
     [80,[1,1,2]],[96,[1,1,2]],[110,[1,1,2]],[126,[1,1,2]],[140,[1,1,2]] 
    ]],
 [27368,[[6,[3]],[12,[3]],[36,[3]],[42,[3]],[66,[3]],[72,[3]],[96,[3]],
     [102,[3]],[126,[3]],[132,[3]]]],
 [27384,[[8,[1,1,1,1,2]],[13,[1,1,1,1,2]],[27,[1,1,1,1,2]],
     [38,[1,1,1,1,2]],[43,[1,1,1,1,2]],[57,[1,1,1,1,2]],[68,[1,1,1,1,2]],
     [73,[1,1,1,1,2]],[87,[1,1,1,1,2]],[98,[1,1,1,1,2]]]],
 [27387,[[0,[1,1,2]],[13,[1,1,2]],[22,[1,1,2]],[28,[1,1,2]],[32,[1,1,2]],
     [43,[1,1,2]],[52,[1,1,2]],[58,[1,1,2]],[62,[1,1,2]],[73,[1,1,2]]]],
 [27401,[[8,[1,2,2,2]],[38,[1,2,2,2]],[68,[1,2,2,2]],[98,[1,2,2,2]],
     [128,[1,2,2,2]],[158,[1,2,2,2]],[188,[1,2,2,2]],[218,[1,2,2,2]],
     [248,[1,2,2,2]]]],
 [27405,[[3,[1]],[6,[1]],[16,[1]],[26,[1]],[33,[1]],[36,[1]],[46,[1]],
     [56,[1]],[63,[1]],[66,[1]]]],[27408,[[38,fail]]],[27411,[[33,fail]]],
 [27420,[[3,[1,2]],[23,[1,2]],[33,[1,2]],[53,[1,2]],[63,[1,2]],
     [83,[1,2]],[93,[1,2]],[113,[1,2]],[123,[1,2]],[143,[1,2]]]],
 [27422,[[8,[2,4]],[38,[2,4]],[68,[2,4]],[98,[2,4]],[128,[2,4]],
     [158,[2,4]],[188,[2,4]],[218,[2,4]],[248,[2,4]]]],
 [27425,[[6,[1]],[8,[2]],[16,[1]],[26,[1]],[36,[1]],[38,[2]],[46,[1]],
     [56,[1]],[66,[1]],[68,[2]]]],
 [27439,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [27440,[[3,[3,4]],[23,[3,4]],[33,[3,4]],[53,[3,4]],[63,[3,4]],
     [83,[3,4]],[93,[3,4]],[113,[3,4]],[123,[3,4]],[143,[3,4]]]],
 [27442,[[3,[1]],[18,[2]],[33,[1]],[48,[2]],[63,[1]],[78,[2]],[93,[1]],
     [108,[2]],[123,[1]],[138,[2]]]],
 [27455,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [27456,[[0,[1]],[15,[1]],[23,[1]],[30,[1]],[45,[1]],[53,[1]],[60,[1]],
     [75,[1]],[83,[1]],[90,[1]]]],
 [27458,[[8,[2]],[18,[1,2]],[38,[1,2]],[48,[2]],[68,[2]],[78,[1,2]],
     [98,[1,2]],[108,[2]],[128,[2]],[138,[1,2]]]],
 [27466,[[8,[1]],[15,[1]],[68,[1]],[73,[1]],[75,[1]],[77,[1]],[128,[1]],
     [135,[1]],[157,[1]],[188,[1]]]],
 [27467,[[15,[1,1,2]],[27,[1,1,2]],[43,[1,1,2]],[87,[1,1,2]],[95,[1,1,2]],
     [98,[1,1,2]],[103,[1,1,2]],[147,[1,1,2]],[163,[1,1,2]],[175,[1,1,2]] 
    ]],
 [27470,[[6,[1,1,2]],[32,[1]],[72,[1]],[92,[1,1,2]],[126,[1]],
     [132,[1,1,2]],[152,[1]],[212,[1,1,2]],[246,[1,1,2]],[252,[1,1,2]]]],
 [27472,[[2,[3]],[12,[4]],[18,[1]],[22,[3]],[32,[3]],[42,[4]],[48,[1]],
     [52,[3]],[62,[3]],[72,[4]]]],
 [27474,[[8,[1]],[27,[1]],[68,[1]],[72,[1]],[117,[1]],[128,[1]],
     [162,[1]],[188,[1]],[207,[1]],[248,[1]]]],
 [27475,[[7,[1]],[21,[1]],[27,[1]],[51,[1]],[67,[1]],[81,[1]],[87,[1]],
     [111,[1]],[127,[1]],[141,[1]]]],
 [27476,[[6,[2]],[18,[1]],[26,[3]],[46,[2]],[66,[3]],[78,[1]],[86,[2]],
     [106,[3]],[126,[2]],[138,[1]]]],
 [27478,[[8,[2,3]],[38,[2,3]],[68,[2,3]],[98,[2,3]],[128,[2,3]],
     [158,[2,3]],[188,[2,3]],[218,[2,3]],[248,[2,3]]]],
 [27479,[[0,[1,2]],[25,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [85,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[145,[1,2]]]],
 [27480,[[8,[1,2]],[38,[1,2]],[68,[1,2]],[98,[1,2]],[128,[1,2]],
     [158,[1,2]],[188,[1,2]],[218,[1,2]],[248,[1,2]]]],
 [27483,[[8,[1]],[38,[1]],[68,[1]],[98,[1]],[128,[1]],[158,[1]],
     [188,[1]],[218,[1]],[248,[1]]]],
 [27486,[[0,[1,2]],[10,[1,2]],[20,[1,2]],[23,[1,2]],[30,[1,2]],
     [40,[1,2]],[50,[1,2]],[53,[1,2]],[60,[1,2]],[70,[1,2]]]],
 [27487,[[3,[1,2]],[6,[2,4]],[8,[1,2]],[16,[2,4]],[26,[2,4]],[33,[1,2]],
     [36,[2,4]],[38,[1,2]],[46,[2,4]],[56,[2,4]]]],
 [27490,[[2,[1,1,1,2]],[22,[1,1,1,2]],[23,[1,1,1,2]],[42,[1,1,1,2]],
     [53,[1,1,1,2]],[62,[1,1,1,2]],[82,[1,1,1,2]],[83,[1,1,1,2]],
     [102,[1,1,1,2]],[113,[1,1,1,2]]]],
 [27498,[[0,[1,2,2,3]],[20,[1,2,2,2]],[23,[1,2,2,2]],[40,[1,2,2,2]],
     [53,[1,2,2,3]],[60,[1,2,2,3]],[80,[1,2,2,3]],[83,[1,2,2,3]],
     [100,[1,2,2,2]],[113,[1,2,2,2]]]],
 [27499,[[3,[1,1,1,2]],[12,[1,1,1,2]],[32,[1,1,1,2]],[33,[1,1,1,2]],
     [52,[1,1,1,2]],[63,[1,1,1,2]],[72,[1,1,1,2]],[92,[1,1,1,2]],
     [93,[1,1,1,2]],[112,[1,1,1,2]]]],
 [27500,[[2,[1,2]],[12,[1,2]],[18,[1,2]],[22,[1,2]],[32,[1,2]],
     [42,[1,2]],[48,[1,2]],[52,[1,2]],[62,[1,2]],[72,[1,2]]]],
 [27515,[[6,[1]],[18,[1,2]],[26,[1,2]],[46,[1]],[48,[1]],[66,[1,2]],
     [78,[1,2]],[86,[1]],[106,[1,2]],[108,[1]]]],
 [27517,[[8,[1]],[10,[1,2]],[16,[1,2]],[33,[1]],[36,[1]],[38,[1,2]],
     [50,[1]],[56,[1,2]],[68,[1]],[76,[1]]]],
 [27522,[[8,[2,3,2,4]],[12,[1]],[32,[2,3,2,4]],[38,[1]],[52,[1]],
     [68,[2,3,2,4]],[72,[2,3,2,4]],[92,[1]],[98,[1]],[112,[2,3,2,4]]]],
 [27523,[[0,[1,2]],[6,[1]],[18,[1]],[26,[1,2]],[40,[1]],[43,[1,2]],
     [46,[1]],[48,[1,2]],[66,[1,2]],[78,[1]]]],[27527,[[13,fail]]],
 [27604,[[12,[1,2]],[17,[1,2]],[42,[1,2]],[47,[1,2]],[72,[1,2]],
     [77,[1,2]],[102,[1,2]],[107,[1,2]],[132,[1,2]],[137,[1,2]]]],
 [27605,[[12,[1]],[17,[1,2]],[42,[1]],[47,[1,2]],[72,[1]],[77,[1,2]],
     [102,[1]],[107,[1,2]],[132,[1]],[137,[1,2]]]],
 [27612,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [27613,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27615,[[7,[2,2,3]],[17,[2,2,3]],[37,[2,2,3]],[47,[2,2,3]],[67,[2,2,3]],
     [77,[2,2,3]],[97,[2,2,3]],[107,[2,2,3]],[127,[2,2,3]],[137,[2,2,3]] 
    ]],
 [27618,[[7,[1,1,2,2]],[27,[1,1,2,2]],[37,[1,1,2,2]],[57,[1,1,2,2]],
     [67,[1,1,2,2]],[87,[1,1,2,2]],[97,[1,1,2,2]],[117,[1,1,2,2]],
     [127,[1,1,2,2]],[147,[1,1,2,2]]]],
 [27620,[[7,[3,4]],[27,[3,4]],[37,[3,4]],[57,[3,4]],[67,[3,4]],
     [87,[3,4]],[97,[3,4]],[117,[3,4]],[127,[3,4]],[147,[3,4]]]],
 [27622,[[7,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],
     [57,[1,1,1,1,2]],[67,[1,1,1,1,2]],[87,[1,1,1,1,2]],[97,[1,1,1,1,2]],
     [117,[1,1,1,1,2]],[127,[1,1,1,1,2]],[147,[1,1,1,1,2]]]],
 [27624,[[2,[1,1,1,1,2]],[22,[1,1,1,1,2]],[32,[1,1,1,1,2]],
     [52,[1,1,1,1,2]],[62,[1,1,1,1,2]],[82,[1,1,1,1,2]],[92,[1,1,1,1,2]],
     [112,[1,1,1,1,2]],[122,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [27626,[[7,[1,2]],[12,[1,2]],[37,[1,2]],[42,[1,2]],[67,[1,2]],
     [72,[1,2]],[97,[1,2]],[102,[1,2]],[127,[1,2]],[132,[1,2]]]],
 [27627,[[7,[1]],[12,[1,2]],[37,[1]],[42,[1,2]],[67,[1]],[72,[1,2]],
     [97,[1]],[102,[1,2]],[127,[1]],[132,[1,2]]]],
 [27628,[[2,[2,2,3]],[22,[2,2,3]],[32,[2,2,3]],[52,[2,2,3]],[62,[2,2,3]],
     [82,[2,2,3]],[92,[2,2,3]],[112,[2,2,3]],[122,[2,2,3]],[142,[2,2,3]] 
    ]],
 [27629,[[0,[1,2]],[10,[1,2]],[12,[1,2]],[17,[1,2]],[20,[1,2]],
     [22,[1,2]],[30,[1,2]],[40,[1,2]],[42,[1,2]],[47,[1,2]]]],
 [27630,[[2,[1]],[6,[1]],[7,[1]],[12,[1]],[16,[1]],[26,[1]],[32,[1]],
     [36,[1]],[37,[1]],[42,[1]]]],
 [27655,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [27660,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [27662,[[11,[1]],[16,[1,2]],[41,[1]],[46,[1,2]],[71,[1]],[76,[1,2]],
     [101,[1]],[106,[1,2]],[131,[1]],[136,[1,2]]]],
 [27663,[[11,[1,2]],[16,[1]],[41,[1,2]],[46,[1]],[71,[1,2]],[76,[1]],
     [101,[1,2]],[106,[1]],[131,[1,2]],[136,[1]]]],
 [27665,[[11,[3,4]],[21,[3,4]],[41,[3,4]],[51,[3,4]],[71,[3,4]],
     [81,[3,4]],[101,[3,4]],[111,[3,4]],[131,[3,4]],[141,[3,4]]]],
 [27671,[[0,[1,2]],[5,[1,2]],[15,[1,2]],[21,[1,2]],[25,[1,2]],[26,[1,2]],
     [31,[1,2]],[35,[1,2]],[45,[1,2]],[51,[1,2]]]],
 [27676,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [27677,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [27680,[[6,[3,4]],[16,[3,4]],[36,[3,4]],[46,[3,4]],[66,[3,4]],
     [76,[3,4]],[96,[3,4]],[106,[3,4]],[126,[3,4]],[136,[3,4]]]],
 [27681,[[1,[1,2]],[4,[1,2]],[6,[1,2]],[14,[1,2]],[24,[1,2]],[26,[1,2]],
     [31,[1,2]],[34,[1,2]],[36,[1,2]],[44,[1,2]]]],
 [27705,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [27710,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [27712,[[11,[1,2]],[16,[1]],[41,[1,2]],[46,[1]],[71,[1,2]],[76,[1]],
     [101,[1,2]],[106,[1]],[131,[1,2]],[136,[1]]]],
 [27713,[[11,[1,2]],[16,[1,2]],[41,[1,2]],[46,[1,2]],[71,[1,2]],
     [76,[1,2]],[101,[1,2]],[106,[1,2]],[131,[1,2]],[136,[1,2]]]],
 [27715,[[11,[2,2,3]],[21,[2,2,3]],[41,[2,2,3]],[51,[2,2,3]],[71,[2,2,3]],
     [81,[2,2,3]],[101,[2,2,3]],[111,[2,2,3]],[131,[2,2,3]],[141,[2,2,3]] 
    ]],
 [27721,[[0,[1,2]],[5,[1,2]],[15,[1,2]],[21,[1,2]],[25,[1,2]],[26,[1,2]],
     [31,[1,2]],[35,[1,2]],[45,[1,2]],[51,[1,2]]]],
 [27726,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [27727,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [27730,[[6,[3,4]],[16,[3,4]],[36,[3,4]],[46,[3,4]],[66,[3,4]],
     [76,[3,4]],[96,[3,4]],[106,[3,4]],[126,[3,4]],[136,[3,4]]]],
 [27731,[[1,[1]],[4,[1]],[6,[1]],[14,[1]],[24,[1]],[26,[1]],[31,[1]],
     [34,[1]],[36,[1]],[44,[1]]]],
 [27754,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [27762,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27764,[[6,[1]],[16,[1]],[36,[1]],[46,[1]],[66,[1]],[76,[1]],[96,[1]],
     [106,[1]],[126,[1]],[136,[1]]]],
 [27765,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [27770,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],
 [27776,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27778,[[6,[1]],[26,[1]],[36,[1]],[56,[1]],[66,[1]],[86,[1]],[96,[1]],
     [116,[1]],[126,[1]],[146,[1]]]],
 [27779,[[7,[1]],[17,[1]],[37,[1]],[47,[1]],[67,[1]],[77,[1]],[97,[1]],
     [107,[1]],[127,[1]],[137,[1]]]],
 [27780,[[1,[1]],[2,[1]],[6,[1]],[7,[1]],[12,[1]],[16,[1]],[21,[1]],
     [27,[1]],[31,[1]],[32,[1]]]],
 [27802,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [27810,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27812,[[0,[1]],[10,[1]],[12,[1]],[17,[1]],[22,[1]],[27,[1]],[30,[1]],
     [40,[1]],[42,[1]],[47,[1]]]],
 [27813,[[5,[1]],[25,[1]],[35,[1]],[55,[1]],[65,[1]],[85,[1]],[95,[1]],
     [115,[1]],[125,[1]],[145,[1]]]],
 [27816,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [27818,[[2,[1]],[7,[1]],[10,[1]],[15,[1]],[20,[1]],[22,[1]],[25,[1]],
     [27,[1]],[32,[1]],[37,[1]]]],
 [27820,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [27822,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [27824,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27826,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [27827,[[7,[1]],[17,[1]],[37,[1]],[47,[1]],[67,[1]],[77,[1]],[97,[1]],
     [107,[1]],[127,[1]],[137,[1]]]],
 [27828,[[0,[1]],[2,[1]],[12,[1]],[15,[1]],[20,[1]],[25,[1]],[30,[1]],
     [32,[1]],[42,[1]],[45,[1]]]],
 [27849,[[5,[1,2]],[20,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [80,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[140,[1,2]]]],
 [27854,[[20,[3]],[50,[3]],[80,[3]],[110,[3]],[140,[3]],[170,[3]],
     [200,[3]],[230,[3]]]],
 [27857,[[10,[2]],[40,[2]],[70,[2]],[100,[2]],[130,[2]],[160,[2]],
     [190,[2]],[220,[2]],[250,[2]]]],
 [27859,[[0,[1,1,1,2,2]],[10,[1,1,1,2,2]],[11,[1,1,1,2,2]],
     [15,[1,1,1,2,2]],[21,[1,1,1,2,2]],[25,[1,1,1,2,2]],[31,[1,1,1,2,2]],
     [40,[1,1,1,2,2]],[41,[1,1,1,2,2]],[45,[1,1,1,2,2]]]],
 [27860,[[0,[1]],[5,[1]],[9,[1]],[15,[1]],[19,[1]],[29,[1]],[30,[1]],
     [35,[1]],[39,[1]],[45,[1]]]],
 [27865,[[5,[3,4]],[25,[3,4]],[35,[3,4]],[55,[3,4]],[65,[3,4]],
     [85,[3,4]],[95,[3,4]],[115,[3,4]],[125,[3,4]],[145,[3,4]]]],
 [27867,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [27869,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [27870,[[15,[3]],[45,[3]],[75,[3]],[105,[3]],[135,[3]],[165,[3]],
     [195,[3]],[225,[3]],[255,[3]]]],
 [27871,[[0,[1,2]],[15,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [75,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[135,[1,2]]]],
 [27873,[[0,[1]],[4,[1]],[14,[1]],[15,[1]],[20,[1]],[24,[1]],[30,[1]],
     [34,[1]],[44,[1]],[45,[1]]]],
 [27874,[[4,[1,2]],[5,[1,2]],[10,[1,1,2]],[14,[1,2]],[20,[1,1,2]],
     [24,[1,2]],[34,[1,2]],[35,[1,2]],[40,[1,1,2]],[44,[1,2]]]],
 [27895,[[5,[1,2]],[20,[1,2]],[35,[1,2]],[50,[1,2]],[65,[1,2]],
     [80,[1,2]],[95,[1,2]],[110,[1,2]],[125,[1,2]],[140,[1,2]]]],
 [27900,[[20,[1,2,3]],[50,[1,2,3]],[80,[1,2,3]],[110,[1,2,3]],
     [140,[1,2,3]],[170,[1,2,3]],[200,[1,2,3]],[230,[1,2,3]]]],
 [27903,[[10,[2]],[40,[2]],[70,[2]],[100,[2]],[130,[2]],[160,[2]],
     [190,[2]],[220,[2]],[250,[2]]]],
 [27905,[[0,[1,2,2,2]],[10,[1,2,2,2]],[11,[1,2,2,2]],[15,[1,2,2,2]],
     [21,[1,2,2,2]],[25,[1,2,2,2]],[31,[1,2,2,2]],[40,[1,2,2,2]],
     [41,[1,2,2,2]],[45,[1,2,2,2]]]],
 [27906,[[0,[1,2]],[5,[1,2]],[9,[1,2]],[15,[1,2]],[19,[1,2]],[29,[1,2]],
     [30,[1,2]],[35,[1,2]],[39,[1,2]],[45,[1,2]]]],
 [27911,[[5,[3,4]],[25,[3,4]],[35,[3,4]],[55,[3,4]],[65,[3,4]],
     [85,[3,4]],[95,[3,4]],[115,[3,4]],[125,[3,4]],[145,[3,4]]]],
 [27913,[[11,[1]],[26,[1]],[41,[1]],[56,[1]],[71,[1]],[86,[1]],
     [101,[1]],[116,[1]],[131,[1]],[146,[1]]]],
 [27915,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [27916,[[15,[1,2,3]],[45,[1,2,3]],[75,[1,2,3]],[105,[1,2,3]],
     [135,[1,2,3]],[165,[1,2,3]],[195,[1,2,3]],[225,[1,2,3]],
     [255,[1,2,3]]]],
 [27917,[[0,[1,2]],[15,[1,2]],[30,[1,2]],[45,[1,2]],[60,[1,2]],
     [75,[1,2]],[90,[1,2]],[105,[1,2]],[120,[1,2]],[135,[1,2]]]],
 [27919,[[0,[1,2]],[4,[1,2]],[14,[1,2]],[15,[1,2]],[20,[1,2]],[24,[1,2]],
     [30,[1,2]],[34,[1,2]],[44,[1,2]],[45,[1,2]]]],
 [27920,[[4,[1,2]],[5,[1,2]],[10,[2]],[14,[1,2]],[20,[2]],[24,[1,2]],
     [34,[1,2]],[35,[1,2]],[40,[2]],[44,[1,2]]]],
 [27940,[[17,[1]],[20,[1]],[47,[1]],[50,[1]],[77,[1]],[80,[1]],
     [107,[1]],[110,[1]],[137,[1]],[140,[1]]]],
 [27945,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [27948,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [27956,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],
 [27961,[[5,[1]],[35,[1]],[65,[1]],[95,[1]],[125,[1]],[155,[1]],
     [185,[1]],[215,[1]],[245,[1]]]],
 [27962,[[12,[1]],[15,[1]],[42,[1]],[45,[1]],[72,[1]],[75,[1]],
     [102,[1]],[105,[1]],[132,[1]],[135,[1]]]],
 [27965,[[7,[1]],[17,[1]],[37,[1]],[47,[1]],[67,[1]],[77,[1]],[97,[1]],
     [107,[1]],[127,[1]],[137,[1]]]],
 [27984,[[14,[1]],[16,[1]],[44,[1]],[46,[1]],[74,[1]],[76,[1]],
     [104,[1]],[106,[1]],[134,[1]],[136,[1]]]],
 [27985,[[2,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[14,[1,2]],
     [20,[1,1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,1,2]],[32,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[44,[1,2]],[50,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]]]],
 [27992,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [27993,[[1,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [19,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[42,[1,2]],[49,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]]]],
 [28000,[[7,[1,2]],[27,[1,2]],[37,[1,2]],[57,[1,2]],[67,[1,2]],
     [87,[1,2]],[97,[1,2]],[117,[1,2]],[127,[1,2]],[147,[1,2]]]],
 [28006,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28007,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28009,[[7,[1,2]],[16,[1,2]],[37,[1,2]],[46,[1,2]],[67,[1,2]],
     [76,[1,2]],[97,[1,2]],[106,[1,2]],[127,[1,2]],[136,[1,2]]]],
 [28027,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28028,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28035,[[1,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[12,[1]],
     [19,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[42,[1]],[49,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [28043,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],
 [28049,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [17,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[47,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [28070,[[14,[1]],[44,[1]],[74,[1]],[104,[1]],[134,[1]],[164,[1]],
     [194,[1]],[224,[1]],[254,[1]]]],
 [28077,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28078,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28080,[[9,[2,3,3]],[19,[2,3,3]],[39,[2,3,3]],[49,[2,3,3]],[69,[2,3,3]],
     [79,[2,3,3]],[99,[2,3,3]],[109,[2,3,3]],[129,[2,3,3]],[139,[2,3,3]] 
    ]],
 [28085,[[7,[3]],[27,[3]],[37,[3]],[57,[3]],[67,[3]],[87,[3]],[97,[3]],
     [117,[3]],[127,[3]],[147,[3]]]],
 [28091,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28094,[[4,[1,2]],[7,[1,2]],[14,[1,2]],[24,[1,2]],[34,[1,2]],[37,[1,2]],
     [44,[1,2]],[54,[1,2]],[64,[1,2]],[67,[1,2]]]],
 [28095,[[4,[1]],[7,[1]],[14,[1]],[24,[1]],[34,[1]],[37,[1]],[44,[1]],
     [54,[1]],[64,[1]],[67,[1]]]],
 [28110,[[5,[1,1,1,1,2,1,1,2]],[11,[1,1,1,1,2,1,1,2]],[17,[1]],
     [22,[1,1,1,1,2,1,1,2]],[29,[1,1,1,1,2,1,1,2]],[35,[1,1,1,1,2,1,1,2]],
     [41,[1,1,1,1,2,1,1,2]],[47,[1]],[52,[1,1,1,1,2,1,1,2]],
     [59,[1,1,1,1,2,1,1,2]]]],
 [28117,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28118,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28126,[[7,[1]],[26,[1]],[37,[1]],[56,[1]],[67,[1]],[86,[1]],[97,[1]],
     [116,[1]],[127,[1]],[146,[1]]]],
 [28131,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [17,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[42,[1,2]],[47,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [28132,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28150,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28158,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28160,[[1,[1,1,1,1,2]],[9,[1,1,1,1,2]],[11,[1,1,1,1,2]],[12,[1,1,1,1,2]],
     [17,[1,1,1,1,2]],[19,[1,1,1,1,2]],[21,[1,1,1,1,2]],[29,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[39,[1,1,1,1,2]]]],
 [28161,[[1,[1,1,1,1,2]],[9,[1,1,1,1,2]],[11,[1,1,1,1,2]],[12,[1,1,1,1,2]],
     [17,[1,1,1,1,2]],[19,[1,1,1,1,2]],[21,[1,1,1,1,2]],[29,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[39,[1,1,1,1,2]]]],
 [28166,[[7,[1]],[26,[1]],[37,[1]],[56,[1]],[67,[1]],[86,[1]],[97,[1]],
     [116,[1]],[127,[1]],[146,[1]]]],
 [28171,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28172,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28175,[[7,[2]],[17,[2]],[37,[2]],[47,[2]],[67,[2]],[77,[2]],[97,[2]],
     [107,[2]],[127,[2]],[137,[2]]]],
 [28189,[[14,[2]],[44,[2]],[74,[2]],[104,[2]],[134,[2]],[164,[2]],
     [194,[2]],[224,[2]],[254,[2]]]],
 [28197,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28205,[[7,[1,2]],[27,[1,2]],[37,[1,2]],[57,[1,2]],[67,[1,2]],
     [87,[1,2]],[97,[1,2]],[117,[1,2]],[127,[1,2]],[147,[1,2]]]],
 [28211,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28214,[[7,[1]],[14,[1]],[37,[1]],[44,[1]],[67,[1]],[74,[1]],[97,[1]],
     [104,[1]],[127,[1]],[134,[1]]]],
 [28228,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28229,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28230,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28231,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28232,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28233,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28234,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [28235,[[12,[1,2]],[16,[1,2]],[42,[1,2]],[46,[1,2]],[72,[1,2]],
     [76,[1,2]],[102,[1,2]],[106,[1,2]],[132,[1,2]],[136,[1,2]]]],
 [28236,[[7,[1]],[10,[1]],[12,[1]],[14,[1]],[25,[1]],[37,[1]],[40,[1]],
     [42,[1]],[44,[1]],[55,[1]]]],
 [28238,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28239,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28240,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28241,[[10,[1]],[25,[1]],[40,[1]],[55,[1]],[70,[1]],[85,[1]],
     [100,[1]],[115,[1]],[130,[1]],[145,[1]]]],
 [28242,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [28244,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28245,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [28246,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28247,[[17,[3]],[47,[3]],[77,[3]],[107,[3]],[137,[3]],[167,[3]],
     [197,[3]],[227,[3]]]],
 [28249,[[12,[1,2]],[17,[1,2]],[42,[1,2]],[47,[1,2]],[72,[1,2]],
     [77,[1,2]],[102,[1,2]],[107,[1,2]],[132,[1,2]],[137,[1,2]]]],
 [28251,[[17,[2,4]],[47,[2,4]],[77,[2,4]],[107,[2,4]],[137,[2,4]],
     [167,[2,4]],[197,[2,4]],[227,[2,4]]]],
 [28253,[[4,[3]],[7,[1]],[14,[4]],[24,[3]],[34,[3]],[37,[1]],[44,[4]],
     [54,[3]],[64,[3]],[67,[1]]]],
 [28254,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28257,[[10,[3]],[30,[2]],[37,[1]],[50,[3]],[70,[2]],[90,[3]],[97,[1]],
     [110,[2]],[130,[3]],[150,[2]]]],
 [28258,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [28259,[[11,[1,1,2,2]],[47,[1,2]],[71,[1,1,2,2]],[77,[1,1,2,2]],
     [131,[1,1,2,2]],[137,[1,2]],[167,[1,1,2,2]],[191,[1,1,2,2]],
     [227,[1,2]],[251,[1,1,2,2]]]],
 [28260,[[14,[1]],[47,[1]],[59,[1]],[104,[1]],[107,[1]],[149,[1]],
     [167,[1]],[194,[1]],[227,[1]],[239,[1]]]],
 [28262,[[6,[1,2]],[35,[1,2]],[37,[1,2]],[55,[1,2]],[67,[1,2]],
     [95,[1,2]],[97,[1,2]],[115,[1,2]],[127,[1,2]],[155,[1,2]]]],
 [28263,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28265,[[7,[1]],[14,[2]],[44,[1]],[67,[3]],[74,[4]],[104,[1]],
     [127,[1]],[134,[2]],[164,[1]],[187,[2]]]],
 [28272,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28273,[[1,[2,2,2,3]],[7,[2,2,2,3]],[12,[1,2]],[14,[1,2]],[19,[2,2,2,3]],
     [25,[2,2,2,3]],[31,[2,2,2,3]],[37,[2,2,2,3]],[42,[1,2]],[44,[1,2]] 
    ]],
 [28280,[[7,[1,2]],[14,[1,2]],[29,[1,2]],[37,[1,2]],[44,[1,2]],
     [59,[1,2]],[67,[1,2]],[74,[1,2]],[89,[1,2]],[97,[1,2]]]],
 [28286,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28287,[[12,[1]],[14,[1]],[42,[1]],[44,[1]],[72,[1]],[74,[1]],
     [102,[1]],[104,[1]],[132,[1]],[134,[1]]]],
 [28289,[[7,[2]],[17,[1,2]],[37,[1,2]],[47,[2]],[67,[2]],[77,[1,2]],
     [97,[1,2]],[107,[2]],[127,[2]],[137,[1,2]]]],
 [28305,[[5,[1,1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,1,2]],[17,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[29,[1,1,1,1,1,1,1,2]],[35,[1,1,1,1,1,1,1,2]],
     [41,[1,1,1,1,1,1,1,2]],[47,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [59,[1,1,1,1,1,1,1,2]]]],
 [28307,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[16,[1,2]],
     [22,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[46,[1,2]],[52,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [28308,[[12,[1]],[16,[1]],[42,[1]],[46,[1]],[72,[1]],[76,[1]],
     [102,[1]],[106,[1]],[132,[1]],[136,[1]]]],
 [28316,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],
 [28322,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28325,[[7,[1]],[17,[1]],[37,[1]],[47,[1]],[67,[1]],[77,[1]],[97,[1]],
     [107,[1]],[127,[1]],[137,[1]]]],
 [28340,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [28342,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [28345,[[11,[2,3,3]],[19,[2,3,3]],[41,[2,3,3]],[49,[2,3,3]],[71,[2,3,3]],
     [79,[2,3,3]],[101,[2,3,3]],[109,[2,3,3]],[131,[2,3,3]],[139,[2,3,3]] 
    ]],
 [28351,[[5,[1,1,2]],[7,[1]],[25,[2,2,3]],[35,[1,1,2]],[37,[1]],
     [55,[2,2,3]],[65,[1,1,2]],[67,[1]],[85,[2,2,3]],[95,[1,1,2]]]],
 [28357,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28359,[[0,[1]],[4,[1]],[10,[1]],[14,[1]],[17,[1]],[20,[1]],[22,[1]],
     [24,[1]],[30,[1]],[34,[1]]]],
 [28360,[[0,[1,2]],[4,[1,2]],[10,[1,2]],[14,[1,2]],[17,[1,2]],[20,[1,2]],
     [22,[1,2]],[24,[1,2]],[30,[1,2]],[34,[1,2]]]],
 [28377,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [28385,[[7,[1]],[25,[1]],[37,[1]],[55,[1]],[67,[1]],[85,[1]],[97,[1]],
     [115,[1]],[127,[1]],[145,[1]]]],
 [28389,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [28391,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [28394,[[7,[1,2]],[17,[1,2]],[37,[1,2]],[47,[1,2]],[67,[1,2]],
     [77,[1,2]],[97,[1,2]],[107,[1,2]],[127,[1,2]],[137,[1,2]]]],
 [28409,[[4,[2,2,2,3]],[10,[2,2,2,3]],[16,[1,2]],[17,[1,2]],
     [22,[2,2,2,3]],[27,[2,2,2,3]],[34,[2,2,2,3]],[40,[2,2,2,3]],
     [46,[1,2]],[47,[1,2]]]],
 [28410,[[5,[1]],[16,[1]],[17,[1]],[20,[1]],[22,[1]],[35,[1]],[46,[1]],
     [47,[1]],[50,[1]],[52,[1]]]],
 [28418,[[5,[2]],[14,[2]],[27,[2]],[35,[2]],[44,[4]],[57,[2]],[74,[2]],
     [80,[2]],[87,[2]],[95,[4]]]],
 [28421,[[0,[1,1,2,1,2]],[20,[1,1,2,1,2]],[30,[1,1,2,1,2]],
     [50,[1,1,2,1,2]],[60,[1,1,2,1,2]],[80,[1,1,2,1,2]],[90,[1,1,2,1,2]],
     [110,[1,1,2,1,2]],[120,[1,1,2,1,2]],[140,[1,1,2,1,2]]]],
 [28424,[[5,[1]],[9,[1]],[20,[1]],[24,[1]],[35,[1]],[39,[1]],[50,[1]],
     [54,[1]],[65,[1]],[69,[1]]]],
 [28427,[[5,[1]],[17,[1]],[20,[1]],[35,[1]],[47,[1]],[50,[1]],[65,[1]],
     [77,[1]],[80,[1]],[95,[1]]]],
 [28442,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28444,[[1,[1,1,1,1,2]],[12,[1,1,1,1,2]],[19,[1,1,1,1,2]],
     [21,[1,1,1,1,2]],[31,[1,1,1,1,2]],[42,[1,1,1,1,2]],[49,[1,1,1,1,2]],
     [51,[1,1,1,1,2]],[61,[1,1,1,1,2]],[72,[1,1,1,1,2]]]],
 [28445,[[7,[1,1,1,1,2]],[9,[1,1,1,1,2]],[12,[1,1,1,1,2]],[25,[1,1,1,1,2]],
     [37,[1,1,1,1,2]],[39,[1,1,1,1,2]],[42,[1,1,1,1,2]],[55,[1,1,1,1,2]],
     [67,[1,1,1,1,2]],[69,[1,1,1,1,2]]]],
 [28450,[[0,[3]],[25,[3]],[31,[3]],[55,[3]],[61,[3]],[85,[3]],[91,[3]],
     [115,[3]],[121,[3]],[145,[3]]]],
 [28456,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28459,[[7,[1]],[12,[1]],[37,[1]],[42,[1]],[67,[1]],[72,[1]],[97,[1]],
     [102,[1]],[127,[1]],[132,[1]]]],
 [28473,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28481,[[4,[1]],[19,[1]],[27,[1]],[34,[1]],[49,[1]],[57,[1]],[64,[1]],
     [79,[1]],[87,[1]],[94,[1]]]],
 [28487,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28490,[[4,[2]],[17,[2]],[19,[2]],[34,[2]],[47,[2]],[49,[2]],[64,[2]],
     [77,[2]],[79,[2]],[94,[2]]]],
 [28502,[[10,[1,1,2]],[36,[1]],[76,[1]],[96,[1,1,2]],[130,[1]],
     [136,[1,1,2]],[156,[1]],[216,[1,1,2]],[250,[1,1,2]]]],
 [28504,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28505,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28507,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28508,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28509,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [28510,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [28512,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28513,[[7,[1]],[22,[1]],[37,[1]],[52,[1]],[67,[1]],[82,[1]],[97,[1]],
     [112,[1]],[127,[1]],[142,[1]]]],
 [28514,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28516,[[0,[1,1,1,1,2]],[12,[1,2]],[17,[1,1,1,1,2]],[22,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[42,[1,2]],[47,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [60,[1,1,1,1,2]],[72,[1,2]]]],
 [28517,[[0,[1,1,1,2]],[1,[1,1,1,2]],[6,[1,1,1,2]],[7,[1,1,1,2]],
     [12,[2]],[17,[1,1,1,2]],[19,[1,1,1,2]],[24,[1,1,1,2]],
     [25,[1,1,1,2]],[30,[1,1,1,2]]]],
 [28518,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28519,[[4,[2]],[14,[2]],[24,[2]],[34,[2]],[44,[2]],[54,[2]],[64,[2]],
     [74,[2]],[84,[2]],[94,[2]]]],
 [28521,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28522,[[12,[1,1,2,2]],[42,[1,2]],[49,[1,1,2,2]],[102,[1,1,2,2]],
     [109,[1,1,2,2]],[132,[1,2]],[169,[1,1,2,2]],[192,[1,1,2,2]],
     [222,[1,2]],[229,[1,1,2,2]]]],
 [28523,[[12,[1]],[31,[1]],[72,[1]],[76,[1]],[121,[1]],[132,[1]],
     [166,[1]],[192,[1]],[211,[1]],[252,[1]]]],
 [28525,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28526,[[10,[2]],[22,[1]],[30,[3]],[50,[2]],[70,[3]],[82,[1]],[90,[2]],
     [110,[3]],[130,[2]],[142,[1]]]],
 [28527,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28529,[[4,[1,2]],[29,[1,2]],[34,[1,2]],[49,[1,2]],[64,[1,2]],
     [89,[1,2]],[94,[1,2]],[109,[1,2]],[124,[1,2]],[149,[1,2]]]],
 [28530,[[11,[1]],[25,[1]],[31,[1]],[55,[1]],[71,[1]],[85,[1]],[91,[1]],
     [115,[1]],[131,[1]],[145,[1]]]],
 [28533,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28538,[[7,[1,1,2,2,3]],[37,[1,1,2,2,3]],[67,[1,1,2,2,3]],
     [97,[1,1,2,2,3]],[127,[1,1,2,2,3]],[157,[1,1,2,2,3]],
     [187,[1,1,2,2,3]],[217,[1,1,2,2,3]],[247,[1,1,2,2,3]]]],
 [28541,[[6,[1,2,2]],[36,[1,2,2]],[66,[1,2,2]],[96,[1,2,2]],[126,[1,2,2]],
     [156,[1,2,2]],[186,[1,2,2]],[216,[1,2,2]],[246,[1,2,2]]]],
 [28543,[[7,[2,2,2,3]],[37,[2,2,2,3]],[67,[2,2,2,3]],[97,[2,2,2,3]],
     [127,[2,2,2,3]],[157,[2,2,2,3]],[187,[2,2,2,3]],[217,[2,2,2,3]],
     [247,[2,2,2,3]]]],
 [28544,[[2,[1,1,2]],[6,[1,1,2]],[10,[1,1,2]],[21,[1,1,2]],[27,[1,1,2]],
     [32,[1,1,2]],[36,[1,1,2]],[40,[1,1,2]],[51,[1,1,2]],[57,[1,1,2]]]],
 [28545,[[0,[1]],[10,[1]],[15,[1]],[25,[1]],[30,[1]],[40,[1]],[45,[1]],
     [55,[1]],[60,[1]],[70,[1]]]],
 [28546,[[2,[1,1,1,1,2]],[7,[1,1,1,1,2]],[12,[1,2]],[24,[1,1,1,1,2]],
     [32,[1,1,1,1,2]],[37,[1,1,1,1,2]],[42,[1,2]],[54,[1,1,1,1,2]],
     [62,[1,1,1,1,2]],[67,[1,1,1,1,2]]]],
 [28549,[[7,[3]],[10,[1,2]],[25,[1,2]],[37,[3]],[40,[1,2]],[55,[1,2]],
     [67,[3]],[70,[1,2]],[85,[1,2]],[97,[3]]]],[28550,[[2,fail]]],
 [28558,[[7,[1,1,2,2,3,2,1,1,2,2,3,3]],[25,fail]]],
 [28563,[[1,[1,2]],[9,[1,2]],[11,[1,2]],[12,[1,2]],[17,[1,2]],[19,[1,2]],
     [21,[1,2]],[29,[1,2]],[31,[1,2]],[39,[1,2]]]],
 [28565,[[0,[1]],[5,[1]],[11,[1]],[15,[1]],[21,[1]],[22,[1]],[25,[1]],
     [27,[1]],[31,[1]],[35,[1]]]],
 [28566,[[0,[1,2]],[11,[1,2]],[21,[1,2]],[22,[3]],[31,[1,2]],[41,[1,2]],
     [51,[1,2]],[52,[3]],[61,[1,2]],[71,[1,2]]]],
 [28568,[[0,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [25,[1,2]],[27,[1,2]],[31,[1,2]],[35,[1,2]]]],
 [28570,[[0,[2]],[11,[2]],[21,[2]],[22,[4]],[31,[2]],[41,[2]],[51,[2]],
     [52,[4]],[61,[2]],[71,[2]]]],
 [28574,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28575,[[1,[2]],[6,[2]],[21,[4]],[31,[2]],[36,[2]],[51,[4]],[61,[2]],
     [66,[2]],[81,[4]],[91,[2]]]],[28590,[[1,fail]]],
 [28595,[[7,[2,4]],[9,[2,4]],[19,[2,4]],[29,[2,4]],[37,[2,4]],[39,[2,4]],
     [49,[2,4]],[59,[2,4]],[67,[2,4]],[69,[2,4]]]],
 [28596,[[7,[2]],[9,[2]],[19,[2]],[29,[2]],[37,[2]],[39,[2]],[49,[2]],
     [59,[2]],[67,[2]],[69,[2]]]],
 [28598,[[7,[1,2,2,3]],[9,[1,2,2,3]],[19,[1,2,2,3]],[24,[1,2,2,3]],
     [37,[1,2,2,3]],[39,[1,2,2,3]],[49,[1,2,2,3]],[54,[1,2,2,3]],
     [67,[1,2,2,3]],[69,[1,2,2,3]]]],
 [28602,[[7,[4,5,5]],[12,[7]],[19,[2,2,3]],[21,[11,12,12]],[42,[4,5,5]],
     [49,[4,5,5]],[51,[2,2,3]],[67,[2,2,3]],[72,[9,9,10]],[79,[2,2,3]]]]
  ,
 [28619,[[4,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [22,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[34,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[52,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [28625,[[2,[1,1,1,1,1,1,2,2]],[9,[1,1,1,1,1,1,2,2]],[15,[1]],
     [21,[1,1,1,1,1,1,2,2]],[27,[1,1,1,1,1,1,2,2]],[32,[1,1,1,1,1,1,2,2]],
     [39,[1,1,1,1,1,1,2,2]],[45,[1]],[51,[1,1,1,1,1,1,2,2]],
     [57,[1,1,1,1,1,1,2,2]]]],
 [28627,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28630,[[6,[1]],[17,[1]],[36,[1]],[47,[1]],[66,[1]],[77,[1]],[96,[1]],
     [107,[1]],[126,[1]],[137,[1]]]],
 [28646,[[0,[1,2]],[5,[1,2]],[11,[1,2]],[15,[1,2]],[21,[1,2]],[22,[1,2]],
     [25,[1,2]],[27,[1,2]],[31,[1,2]],[35,[1,2]]]],
 [28652,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28654,[[4,[2,3,3]],[24,[2,3,3]],[34,[2,3,3]],[54,[2,3,3]],[64,[2,3,3]],
     [84,[2,3,3]],[94,[2,3,3]],[114,[2,3,3]],[124,[2,3,3]],[144,[2,3,3]] 
    ]],
 [28655,[[6,[1]],[10,[1,1,2]],[17,[2,2,3]],[36,[1]],[40,[1,1,2]],
     [47,[2,2,3]],[66,[1]],[70,[1,1,2]],[77,[2,2,3]],[96,[1]]]],
 [28669,[[7,[1]],[22,[1]],[37,[1]],[52,[1]],[67,[1]],[82,[1]],[97,[1]],
     [112,[1]],[127,[1]],[142,[1]]]],
 [28673,[[7,[1,1,2,2,3]],[37,[1,1,2,2,3]],[67,[1,1,2,2,3]],
     [97,[1,1,2,2,3]],[127,[1,1,2,2,3]],[157,[1,1,2,2,3]],
     [187,[1,1,2,2,3]],[217,[1,1,2,2,3]],[247,[1,1,2,2,3]]]],
 [28674,[[2,[2,2,3,3]],[9,[2,2,3,3]],[15,[1]],[16,[1]],[21,[2,2,3,3]],
     [27,[2,2,3,3]],[32,[2,2,3,3]],[39,[2,2,3,3]],[45,[1]],[46,[1]]]],
 [28677,[[7,[1,1,1,1,2]],[9,[1,1,1,1,2]],[27,[1,1,1,1,2]],[37,[1,1,1,1,2]],
     [39,[1,1,1,1,2]],[57,[1,1,1,1,2]],[67,[1,1,1,1,2]],[69,[1,1,1,1,2]],
     [87,[1,1,1,1,2]],[97,[1,1,1,1,2]]]],
 [28679,[[7,[2]],[10,[2]],[25,[2]],[37,[2]],[40,[2]],[55,[2]],[67,[2]],
     [70,[2]],[85,[2]],[97,[2]]]],
 [28695,[[11,[1]],[26,[1]],[41,[1]],[56,[1]],[71,[1]],[86,[1]],
     [101,[1]],[116,[1]],[131,[1]],[146,[1]]]],
 [28698,[[12,[1,2,2]],[42,[1,2,2]],[72,[1,2,2]],[102,[1,2,2]],
     [132,[1,2,2]],[162,[1,2,2]],[192,[1,2,2]],[222,[1,2,2]],
     [252,[1,2,2]]]],
 [28699,[[12,[2,3]],[42,[2,3]],[72,[2,3]],[102,[2,3]],[132,[2,3]],
     [162,[2,3]],[192,[2,3]],[222,[2,3]],[252,[2,3]]]],
 [28700,[[6,[1,1,2]],[36,[1,1,2]],[66,[1,1,2]],[96,[1,1,2]],[126,[1,1,2]],
     [156,[1,1,2]],[186,[1,1,2]],[216,[1,1,2]],[246,[1,1,2]]]],
 [28716,[[7,[3]],[9,[3]],[19,[3]],[29,[3]],[37,[3]],[39,[3]],[49,[3]],
     [59,[3]],[67,[3]],[69,[3]]]],
 [28726,[[7,[1,1,1,2]],[19,[1,1,1,2]],[37,[1,1,1,2]],[39,[1,1,1,2]],
     [59,[1,1,1,2]],[67,[1,1,1,2]],[79,[1,1,1,2]],[97,[1,1,1,2]],
     [99,[1,1,1,2]],[119,[1,1,1,2]]]],
 [28731,[[5,[1,1,1,2]],[25,[1,1,1,2]],[27,[1,1,1,2]],[45,[1,1,1,2]],
     [57,[1,1,1,2]],[65,[1,1,1,2]],[85,[1,1,1,2]],[87,[1,1,1,2]],
     [105,[1,1,1,2]],[117,[1,1,1,2]]]],
 [28745,[[7,[2]],[17,[2]],[37,[2]],[47,[2]],[67,[2]],[77,[2]],[97,[2]],
     [107,[2]],[127,[2]],[137,[2]]]],
 [28762,[[7,[1]],[9,[1]],[14,[1]],[29,[1]],[37,[1]],[39,[1]],[44,[1]],
     [59,[1]],[67,[1]],[69,[1]]]],
 [28765,[[7,[1]],[10,[1,1,2]],[11,[2,2,3]],[20,[1,1,2]],[26,[2,2,3]],
     [37,[1]],[40,[1,1,2]],[41,[2,2,3]],[50,[1,1,2]],[56,[2,2,3]]]],
 [28777,[[20,[1,1,2]],[40,[1]],[80,[1]],[100,[1,1,2]],[140,[1,1,2]],
     [160,[1]],[200,[1]],[220,[1,1,2]]]],
 [28781,[[9,[1]],[24,[1]],[39,[1]],[54,[1]],[69,[1]],[84,[1]],[99,[1]],
     [114,[1]],[129,[1]],[144,[1]]]],
 [28784,[[7,[1]],[12,[1]],[37,[1]],[42,[1]],[67,[1]],[72,[1]],[97,[1]],
     [102,[1]],[127,[1]],[132,[1]]]],[28792,[[32,fail]]],
 [28797,[[27,fail]]],
 [28799,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [28802,[[0,[1,2]],[10,[1,2]],[17,[2,4]],[20,[1,2]],[30,[1,2]],
     [40,[1,2]],[47,[2,4]],[50,[1,2]],[60,[1,2]],[70,[1,2]]]],
 [28816,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28829,[[22,[2,2,3]],[31,[2,2,3]],[71,[2,2,3]],[82,[2,2,3]],[111,[2,2,3]],
     [142,[2,2,3]],[151,[2,2,3]],[191,[2,2,3]],[202,[2,2,3]],
     [231,[2,2,3]]]],
 [28833,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28834,[[0,[1,2]],[14,[1,2]],[15,[1,2]],[24,[1,2]],[30,[1,2]],
     [44,[1,2]],[45,[1,2]],[54,[1,2]],[60,[1,2]],[74,[1,2]]]],
 [28836,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28838,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [28840,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28841,[[1,[1,2]],[30,[1,2]],[32,[1,2]],[50,[1,2]],[62,[1,2]],
     [90,[1,2]],[92,[1,2]],[110,[1,2]],[122,[1,2]],[150,[1,2]]]],
 [28842,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [28844,[[9,[3,5]],[29,[3,5]],[49,[3,5]],[69,[3,5]],[89,[3,5]],
     [109,[3,5]],[129,[3,5]],[149,[3,5]],[169,[3,5]],[189,[3,5]]]],
 [28845,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [28847,[[6,[1,1,2,2]],[42,[1,2]],[66,[1,1,2,2]],[72,[1,1,2,2]],
     [126,[1,1,2,2]],[132,[1,2]],[162,[1,1,2,2]],[186,[1,1,2,2]],
     [222,[1,2]],[246,[1,1,2,2]]]],
 [28848,[[9,[1]],[42,[1]],[54,[1]],[99,[1]],[102,[1]],[144,[1]],
     [162,[1]],[189,[1]],[222,[1]],[234,[1]]]],
 [28850,[[0,[1]],[6,[3]],[7,[1,2]],[10,[1]],[12,[1]],[16,[1,2]],
     [20,[1]],[24,[1]],[26,[1,2]],[30,[1]]]],
 [28852,[[19,[1,1,2]],[39,[1]],[79,[1]],[99,[1,1,2]],[105,[1]],
     [139,[1,1,2]],[199,[1]],[219,[1,1,2]],[225,[1,1,2]]]],
 [28864,[[0,[1,2]],[4,[1,2]],[10,[1,2]],[14,[1,2]],[17,[1,2]],[20,[1,2]],
     [22,[1,2]],[24,[1,2]],[30,[1,2]],[34,[1,2]]]],
 [28878,[[4,[1,2]],[7,[1,2]],[14,[1,2]],[24,[1,2]],[34,[1,2]],[37,[1,2]],
     [44,[1,2]],[54,[1,2]],[64,[1,2]],[67,[1,2]]]],
 [28882,[[7,[1]],[10,[1,2]],[30,[1]],[37,[1,2]],[50,[1,2]],[67,[1]],
     [70,[1]],[90,[1,2]],[97,[1,2]],[110,[1]]]],
 [28883,[[6,[1]],[17,[1,2]],[26,[1,2]],[46,[1]],[47,[1]],[66,[1,2]],
     [77,[1,2]],[86,[1]],[106,[1,2]],[107,[1]]]],
 [28886,[[0,[2]],[5,[2]],[7,[1]],[10,[1]],[14,[1]],[20,[1]],[22,[2]],
     [26,[1]],[29,[1]]]],
 [28888,[[4,[2,3,2,4]],[17,[1]],[24,[1]],[44,[2,3,2,4]],[47,[2,3,2,4]],
     [64,[1]],[77,[1]],[84,[2,3,2,4]],[104,[1]],[107,[2,3,2,4]]]],
 [28914,[[17,fail]]],
 [28918,[[12,[1]],[17,[1]],[42,[1]],[47,[1]],[72,[1]],[77,[1]],
     [102,[1]],[107,[1]],[132,[1]],[137,[1]]]],[28923,[[12,fail]]],
 [28927,[[12,fail]]],
 [28932,[[7,[1]],[12,[1]],[37,[1]],[42,[1]],[67,[1]],[72,[1]],[97,[1]],
     [102,[1]],[127,[1]],[132,[1]]]],[28958,[[7,fail]]],
 [28981,[[11,[3]],[41,[3]],[71,[3]],[101,[3]],[131,[3]],[161,[3]],
     [191,[3]],[221,[3]],[251,[3]]]],
 [28982,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [28986,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [28988,[[16,[2]],[46,[2]],[76,[2]],[106,[2]],[136,[2]],[166,[2]],
     [196,[2]],[226,[2]]]],
 [28991,[[5,[1,2]],[6,[1,1,2]],[15,[1,2]],[16,[1,1,2]],[21,[1,2]],
     [25,[1,2]],[35,[1,2]],[36,[1,1,2]],[45,[1,2]],[46,[1,1,2]]]],
 [28992,[[5,[1]],[6,[1]],[11,[1]],[15,[1]],[25,[1]],[26,[1]],[35,[1]],
     [36,[1]],[41,[1]],[45,[1]]]],
 [29002,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [29003,[[6,[3]],[36,[3]],[66,[3]],[96,[3]],[126,[3]],[156,[3]],
     [186,[3]],[216,[3]],[246,[3]]]],
 [29004,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [29005,[[0,[1]],[10,[1]],[11,[1]],[20,[1]],[21,[1]],[26,[1]],[30,[1]],
     [40,[1]],[41,[1]],[50,[1]]]],
 [29006,[[1,[1,1,1,2,2]],[8,[1,1,1,2,2]],[11,[1,1,1,2,2]],[16,[1,1,1,2,2]],
     [18,[1,1,1,2,2]],[28,[1,1,1,2,2]],[31,[1,1,1,2,2]],[38,[1,1,1,2,2]],
     [41,[1,1,1,2,2]],[46,[1,1,1,2,2]]]],
 [29007,[[1,[3,4]],[21,[3,4]],[31,[3,4]],[51,[3,4]],[61,[3,4]],
     [81,[3,4]],[91,[3,4]],[111,[3,4]],[121,[3,4]],[141,[3,4]]]],
 [29031,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29032,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29038,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [29039,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [29053,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29054,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29080,[[11,[3]],[41,[3]],[71,[3]],[101,[3]],[131,[3]],[161,[3]],
     [191,[3]],[221,[3]],[251,[3]]]],
 [29081,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [29085,[[11,[1]],[26,[1]],[41,[1]],[56,[1]],[71,[1]],[86,[1]],
     [101,[1]],[116,[1]],[131,[1]],[146,[1]]]],
 [29087,[[16,[1,1,2]],[46,[1,1,2]],[76,[1,1,2]],[106,[1,1,2]],
     [136,[1,1,2]],[166,[1,1,2]],[196,[1,1,2]],[226,[1,1,2]]]],
 [29090,[[5,[1]],[6,[2]],[15,[1]],[16,[2]],[21,[1]],[25,[1]],[35,[1]],
     [36,[2]],[45,[1]],[46,[2]]]],
 [29091,[[5,[1,2]],[6,[1,2]],[11,[1,2]],[15,[1,2]],[25,[1,2]],[26,[1,2]],
     [35,[1,2]],[36,[1,2]],[41,[1,2]],[45,[1,2]]]],
 [29101,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [29102,[[6,[3]],[36,[3]],[66,[3]],[96,[3]],[126,[3]],[156,[3]],
     [186,[3]],[216,[3]],[246,[3]]]],
 [29103,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [29104,[[0,[1,2]],[10,[1,2]],[11,[1,2]],[20,[1,2]],[21,[1,2]],
     [26,[1,2]],[30,[1,2]],[40,[1,2]],[41,[1,2]],[50,[1,2]]]],
 [29105,[[1,[1,1,2,1,2]],[8,[1,1,2,1,2]],[11,[1,1,2,1,2]],[16,[1,1,2,1,2]],
     [18,[1,1,2,1,2]],[28,[1,1,2,1,2]],[31,[1,1,2,1,2]],[38,[1,1,2,1,2]],
     [41,[1,1,2,1,2]],[46,[1,1,2,1,2]]]],
 [29106,[[1,[2,2,3]],[21,[2,2,3]],[31,[2,2,3]],[51,[2,2,3]],[61,[2,2,3]],
     [81,[2,2,3]],[91,[2,2,3]],[111,[2,2,3]],[121,[2,2,3]],[141,[2,2,3]] 
    ]],
 [29128,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29129,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29139,[[5,[1]],[25,[1]],[35,[1]],[55,[1]],[65,[1]],[85,[1]],[95,[1]],
     [115,[1]],[125,[1]],[145,[1]]]],
 [29142,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [29144,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [29146,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [29148,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [29150,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29151,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29152,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [29175,[[10,[1,2]],[20,[1]],[40,[1,2]],[50,[1]],[70,[1,2]],[80,[1]],
     [100,[1,2]],[110,[1]],[130,[1,2]],[140,[1]]]],
 [29176,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [29180,[[10,[1]],[20,[1,2]],[40,[1]],[50,[1,2]],[70,[1]],[80,[1,2]],
     [100,[1]],[110,[1,2]],[130,[1]],[140,[1,2]]]],
 [29182,[[5,[1,1,1,1,2]],[25,[1,1,1,1,2]],[35,[1,1,1,1,2]],
     [55,[1,1,1,1,2]],[65,[1,1,1,1,2]],[85,[1,1,1,1,2]],[95,[1,1,1,1,2]],
     [115,[1,1,1,1,2]],[125,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [29183,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],
     [110,[1,1,1,1,2]],[120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],
 [29193,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [29195,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [29196,[[5,[1]],[15,[1,2]],[35,[1]],[45,[1,2]],[65,[1]],[75,[1,2]],
     [95,[1]],[105,[1,2]],[125,[1]],[135,[1,2]]]],
 [29197,[[5,[1,2]],[15,[1]],[35,[1,2]],[45,[1]],[65,[1,2]],[75,[1]],
     [95,[1,2]],[105,[1]],[125,[1,2]],[135,[1]]]],
 [29198,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [29221,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29222,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29232,[[0,[1]],[20,[1]],[30,[1]],[50,[1]],[60,[1]],[80,[1]],[90,[1]],
     [110,[1]],[120,[1]],[140,[1]]]],
 [29243,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29244,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29245,[[5,[1]],[15,[1]],[35,[1]],[45,[1]],[65,[1]],[75,[1]],[95,[1]],
     [105,[1]],[125,[1]],[135,[1]]]],
 [29246,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [29266,[[10,[1,2]],[20,[1,2]],[40,[1,2]],[50,[1,2]],[70,[1,2]],
     [80,[1,2]],[100,[1,2]],[110,[1,2]],[130,[1,2]],[140,[1,2]]]],
 [29267,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [29271,[[10,[1,2]],[20,[1]],[40,[1,2]],[50,[1]],[70,[1,2]],[80,[1]],
     [100,[1,2]],[110,[1]],[130,[1,2]],[140,[1]]]],
 [29273,[[5,[1,1,1,1,2]],[25,[1,1,1,1,2]],[35,[1,1,1,1,2]],
     [55,[1,1,1,1,2]],[65,[1,1,1,1,2]],[85,[1,1,1,1,2]],[95,[1,1,1,1,2]],
     [115,[1,1,1,1,2]],[125,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [29274,[[0,[1,1,2,2]],[20,[1,1,2,2]],[30,[1,1,2,2]],[50,[1,1,2,2]],
     [60,[1,1,2,2]],[80,[1,1,2,2]],[90,[1,1,2,2]],[110,[1,1,2,2]],
     [120,[1,1,2,2]],[140,[1,1,2,2]]]],
 [29284,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [29286,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [29287,[[5,[1,2]],[15,[1]],[35,[1,2]],[45,[1]],[65,[1,2]],[75,[1]],
     [95,[1,2]],[105,[1]],[125,[1,2]],[135,[1]]]],
 [29288,[[5,[1,2]],[15,[1,2]],[35,[1,2]],[45,[1,2]],[65,[1,2]],
     [75,[1,2]],[95,[1,2]],[105,[1,2]],[125,[1,2]],[135,[1,2]]]],
 [29289,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [29310,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29318,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [29328,[[8,[1]],[27,[1]],[38,[1]],[57,[1]],[68,[1]],[87,[1]],[98,[1]],
     [117,[1]],[128,[1]],[147,[1]]]],
 [29332,[[7,[1,2]],[12,[1]],[37,[1,2]],[42,[1]],[67,[1,2]],[72,[1]],
     [97,[1,2]],[102,[1]],[127,[1,2]],[132,[1]]]],
 [29333,[[7,[1]],[12,[1,2]],[37,[1]],[42,[1,2]],[67,[1]],[72,[1,2]],
     [97,[1]],[102,[1,2]],[127,[1]],[132,[1,2]]]],
 [29334,[[6,[1]],[26,[1]],[36,[1]],[56,[1]],[66,[1]],[86,[1]],[96,[1]],
     [116,[1]],[126,[1]],[146,[1]]]],
 [29335,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],[29340,[[12,fail]]],[29343,[[7,fail]]],
 [29353,[[12,[1,2]],[17,[1]],[42,[1,2]],[47,[1]],[72,[1,2]],[77,[1]],
     [102,[1,2]],[107,[1]],[132,[1,2]],[137,[1]]]],
 [29354,[[12,[1]],[17,[1,2]],[42,[1]],[47,[1,2]],[72,[1]],[77,[1,2]],
     [102,[1]],[107,[1,2]],[132,[1]],[137,[1,2]]]],
 [29362,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [29376,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29379,[[8,[1]],[18,[1]],[38,[1]],[48,[1]],[68,[1]],[78,[1]],[98,[1]],
     [108,[1]],[128,[1]],[138,[1]]]],[29380,[[17,fail]]],
 [29382,[[12,fail]]],
 [29395,[[2,[1,1,1,1,2,1,1,2]],[8,[1,1,1,1,2,1,1,2]],[12,[1]],
     [20,[1,1,1,1,2,1,1,2]],[26,[1,1,1,1,2,1,1,2]],[32,[1,1,1,1,2,1,1,2]],
     [38,[1,1,1,1,2,1,1,2]],[42,[1]],[50,[1,1,1,1,2,1,1,2]],
     [56,[1,1,1,1,2,1,1,2]]]],
 [29396,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [29403,[[2,[1,1,1,1,2]],[22,[1,1,1,1,2]],[32,[1,1,1,1,2]],
     [52,[1,1,1,1,2]],[62,[1,1,1,1,2]],[82,[1,1,1,1,2]],[92,[1,1,1,1,2]],
     [112,[1,1,1,1,2]],[122,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [29404,[[2,[1,1,1,1,2]],[22,[1,1,1,1,2]],[32,[1,1,1,1,2]],
     [52,[1,1,1,1,2]],[62,[1,1,1,1,2]],[82,[1,1,1,1,2]],[92,[1,1,1,1,2]],
     [112,[1,1,1,1,2]],[122,[1,1,1,1,2]],[142,[1,1,1,1,2]]]],
 [29417,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29418,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[12,[1]],
     [18,[1,1,1,1,2,1,1,2]],[22,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[42,[1]],[48,[1,1,1,1,2,1,1,2]],
     [52,[1,1,1,1,2,1,1,2]]]],
 [29437,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [29452,[[5,[1]],[25,[1]],[35,[1]],[55,[1]],[65,[1]],[85,[1]],[95,[1]],
     [115,[1]],[125,[1]],[145,[1]]]],
 [29458,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29459,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],[29464,[[17,fail]]],
 [29476,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29477,[[5,[1,1,1,1,2,1,1,2]],[11,[1,1,1,1,2,1,1,2]],[17,[1]],
     [23,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[35,[1,1,1,1,2,1,1,2]],
     [41,[1,1,1,1,2,1,1,2]],[47,[1]],[53,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [29483,[[1,[1,1,1,1,1,1,2,2]],[7,[1,1,1,1,1,1,2,2]],[13,[1]],
     [17,[1,1,1,1,1,1,2,2]],[25,[1,1,1,1,1,1,2,2]],[31,[1,1,1,1,1,1,2,2]],
     [37,[1,1,1,1,1,1,2,2]],[43,[1]],[47,[1,1,1,1,1,1,2,2]],
     [55,[1,1,1,1,1,1,2,2]]]],
 [29497,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29498,[[7,[1,2]],[37,[1,2]],[67,[1,2]],[97,[1,2]],[127,[1,2]],
     [157,[1,2]],[187,[1,2]],[217,[1,2]],[247,[1,2]]]],
 [29499,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29515,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [29516,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [29536,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [29537,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29538,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [29547,[[7,fail]]],
 [29554,[[12,[1,2]],[17,[1,2]],[42,[1,2]],[47,[1,2]],[72,[1,2]],
     [77,[1,2]],[102,[1,2]],[107,[1,2]],[132,[1,2]],[137,[1,2]]]],
 [29555,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29556,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29557,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29558,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29559,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29560,[[5,[1]],[10,[1]],[22,[1]],[25,[1]],[35,[1]],[40,[1]],[52,[1]],
     [55,[1]],[65,[1]],[70,[1]]]],
 [29561,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29562,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29564,[[12,[2,3]],[42,[2,3]],[72,[2,3]],[102,[2,3]],[132,[2,3]],
     [162,[2,3]],[192,[2,3]],[222,[2,3]],[252,[2,3]]]],
 [29565,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29566,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29567,[[5,[1]],[13,[1]],[20,[1]],[28,[1]],[35,[1]],[43,[1]],[50,[1]],
     [58,[1]],[65,[1]],[73,[1]]]],
 [29568,[[8,[2]],[23,[2]],[38,[2]],[53,[2]],[68,[2]],[83,[2]],[98,[2]],
     [113,[2]],[128,[2]],[143,[2]]]],
 [29569,[[5,[2,3]],[8,[2,3]],[23,[2,3]],[25,[2,3]],[35,[2,3]],[38,[2,3]],
     [53,[2,3]],[55,[2,3]],[65,[2,3]],[68,[2,3]]]],
 [29570,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29571,[[8,[2]],[23,[2]],[38,[2]],[53,[2]],[68,[2]],[83,[2]],[98,[2]],
     [113,[2]],[128,[2]],[143,[2]]]],
 [29572,[[12,[2]],[42,[2]],[72,[2]],[102,[2]],[132,[2]],[162,[2]],
     [192,[2]],[222,[2]],[252,[2]]]],
 [29573,[[2,[1,1,1,1,2]],[12,[1,2]],[18,[1,1,1,1,2]],[22,[1,1,1,1,2]],
     [32,[1,1,1,1,2]],[42,[1,2]],[48,[1,1,1,1,2]],[52,[1,1,1,1,2]],
     [62,[1,1,1,1,2]],[72,[1,2]]]],
 [29575,[[5,[1]],[12,[1,2]],[20,[1]],[35,[1]],[42,[1,2]],[50,[1]],
     [65,[1]],[72,[1,2]],[80,[1]],[95,[1]]]],
 [29576,[[0,[1,1,1,2]],[2,[1,1,1,2]],[6,[1,1,1,2]],[8,[1,1,1,2]],
     [12,[2]],[18,[1,1,1,2]],[20,[1,1,1,2]],[22,[1,1,1,2]],
     [26,[1,1,1,2]],[30,[1,1,1,2]]]],
 [29577,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29579,[[8,[1,2,2,2]],[28,[1,2]],[48,[1,2,2,2]],[68,[1,2,2,2]],
     [88,[1,2]],[108,[1,2,2,2]],[128,[1,2,2,2]],[148,[1,2]],
     [168,[1,2,2,2]],[188,[1,2,2,2]]]],
 [29580,[[12,[1,2]],[23,[1]],[42,[1,2]],[43,[1]],[72,[1,2]],[83,[1]],
     [102,[1,2]],[103,[1]],[132,[1,2]],[143,[1]]]],
 [29583,[[12,[1,2,2,2]],[42,[1,2]],[72,[1,2,2,2]],[102,[1,2,2,2]],
     [132,[1,2]],[162,[1,2,2,2]],[192,[1,2,2,2]],[222,[1,2]],
     [252,[1,2,2,2]]]],
 [29584,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29586,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29588,[[11,[2]],[26,[2]],[31,[2]],[56,[2]],[71,[2]],[86,[2]],[91,[2]],
     [116,[2]],[131,[2]],[146,[2]]]],
 [29589,[[12,[1]],[35,[1]],[72,[1]],[80,[1]],[125,[1]],[132,[1]],
     [170,[1]],[192,[1]],[215,[1]],[252,[1]]]],
 [29591,[[12,[1,2]],[42,[2]],[72,[1,2]],[102,[1,2]],[132,[2]],[162,[1,2]],
     [192,[1,2]],[222,[2]],[252,[1,2]]]],
 [29592,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [29593,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29594,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [29595,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [29596,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [29598,[[12,[1]],[13,[1]],[17,[2,3]],[42,[1]],[43,[1]],[47,[2,3]],
     [72,[1]],[73,[1]],[77,[2,3]],[102,[1]]]],
 [29600,[[11,[1,2,2,3]],[31,[1,2]],[51,[1,2,2,3]],[71,[1,2,2,3]],
     [91,[1,2]],[111,[1,2,2,3]],[131,[1,2,2,3]],[151,[1,2]],
     [171,[1,2,2,3]],[191,[1,2,2,3]]]],
 [29602,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29603,[[11,[1]],[17,[1,2]],[41,[1]],[47,[1,2]],[71,[1]],[77,[1,2]],
     [101,[1]],[107,[1,2]],[131,[1]],[137,[1,2]]]],
 [29604,[[7,[1,1,1,1,2]],[11,[1,1,1,1,2]],[17,[1,2]],[27,[1,1,1,1,2]],
     [37,[1,1,1,1,2]],[41,[1,1,1,1,2]],[47,[1,2]],[57,[1,1,1,1,2]],
     [67,[1,1,1,1,2]],[71,[1,1,1,1,2]]]],
 [29605,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29606,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [29607,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [29608,[[17,[1,2]],[47,[1,2]],[77,[1,2]],[107,[1,2]],[137,[1,2]],
     [167,[1,2]],[197,[1,2]],[227,[1,2]]]],
 [29609,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29610,[[3,[1]],[11,[1]],[18,[1]],[26,[1]],[33,[1]],[41,[1]],[48,[1]],
     [56,[1]],[63,[1]],[71,[1]]]],
 [29611,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [29612,[[7,[1,2]],[15,[1,2]],[37,[1,2]],[45,[1,2]],[67,[1,2]],
     [75,[1,2]],[97,[1,2]],[105,[1,2]],[127,[1,2]],[135,[1,2]]]],
 [29613,[[6,[1]],[12,[1,2]],[21,[1]],[36,[1]],[42,[1,2]],[51,[1]],
     [66,[1]],[72,[1,2]],[81,[1]],[96,[1]]]],
 [29614,[[6,[2,3]],[8,[2,3]],[23,[2,3]],[26,[2,3]],[36,[2,3]],[38,[2,3]],
     [53,[2,3]],[56,[2,3]],[66,[2,3]],[68,[2,3]]]],
 [29615,[[8,[1]],[12,[1]],[17,[2,3]],[18,[1]],[38,[1]],[42,[1]],
     [47,[2,3]],[48,[1]],[68,[1]],[72,[1]]]],
 [29618,[[17,[1,2,2,2]],[47,[1,2]],[77,[1,2,2,2]],[107,[1,2,2,2]],
     [137,[1,2]],[167,[1,2,2,2]],[197,[1,2,2,2]],[227,[1,2]]]],
 [29619,[[17,[1,2]],[18,[1]],[38,[1]],[47,[1,2]],[77,[1,2]],[78,[1]],
     [98,[1]],[107,[1,2]],[137,[1,2]],[138,[1]]]],
 [29622,[[17,[1,2,2,3]],[47,[1,2]],[77,[1,2,2,3]],[107,[1,2,2,3]],
     [137,[1,2]],[167,[1,2,2,3]],[197,[1,2,2,3]],[227,[1,2]]]],
 [29623,[[38,[1,2]],[102,[1,2]],[131,[1,2]],[132,[1,2]]]],
 [29624,[[11,[1]],[47,[1]],[56,[1]],[101,[1]],[107,[1]],[146,[1]],
     [167,[1]],[191,[1]],[227,[1]],[236,[1]]]],
 [29625,[[11,[1]],[47,[1]],[56,[1]],[101,[1]],[107,[1]],[146,[1]],
     [167,[1]],[191,[1]],[227,[1]],[236,[1]]]],
 [29627,[[17,[2]],[47,[2]],[77,[2]],[107,[2]],[137,[2]],[167,[2]],
     [197,[2]],[227,[2]]]],
 [29637,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [29640,[[7,[1]],[28,[1]],[37,[1]],[58,[1]],[67,[1]],[88,[1]],[97,[1]],
     [118,[1]],[127,[1]],[148,[1]]]],
 [29648,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29649,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29666,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29669,[[2,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [22,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[32,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[52,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [29681,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[12,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[22,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[42,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [52,[1,1,1,1,1,1,1,2]]]],
 [29683,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29684,[[6,[1]],[12,[1,2]],[36,[1]],[42,[1,2]],[66,[1]],[72,[1,2]],
     [96,[1]],[102,[1,2]],[126,[1]],[132,[1,2]]]],
 [29700,[[11,[1]],[26,[1]],[41,[1]],[56,[1]],[71,[1]],[86,[1]],
     [101,[1]],[116,[1]],[131,[1]],[146,[1]]]],
 [29702,[[13,[1,1,2]],[43,[1,1,2]],[73,[1,1,2]],[103,[1,1,2]],
     [133,[1,1,2]],[163,[1,1,2]],[193,[1,1,2]],[223,[1,1,2]],
     [253,[1,1,2]]]],
 [29704,[[7,[1,2,2]],[37,[1,2,2]],[67,[1,2,2]],[97,[1,2,2]],[127,[1,2,2]],
     [157,[1,2,2]],[187,[1,2,2]],[217,[1,2,2]],[247,[1,2,2]]]],
 [29705,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [29711,[[7,[1,2,2]],[27,[1,2,2]],[37,[1,2,2]],[57,[1,2,2]],[67,[1,2,2]],
     [87,[1,2,2]],[97,[1,2,2]],[117,[1,2,2]],[127,[1,2,2]],[147,[1,2,2]] 
    ]],
 [29715,[[3,[1,1,2]],[18,[1,1,2]],[33,[1,1,2]],[48,[1,1,2]],[63,[1,1,2]],
     [78,[1,1,2]],[93,[1,1,2]],[108,[1,1,2]],[123,[1,1,2]],[138,[1,1,2]] 
    ]],
 [29717,[[3,[2]],[18,[2]],[33,[2]],[48,[2]],[63,[2]],[78,[2]],[93,[2]],
     [108,[2]],[123,[2]],[138,[2]]]],
 [29718,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29721,[[1,[1,1,1,2]],[12,[1,1,1,2]],[31,[1,1,1,2]],[42,[1,1,1,2]],
     [61,[1,1,1,2]],[72,[1,1,1,2]],[91,[1,1,1,2]],[102,[1,1,1,2]],
     [121,[1,1,1,2]],[132,[1,1,1,2]]]],[29726,[[12,fail]]],
 [29739,[[11,[2]],[21,[1]],[26,[1]],[41,[2]],[51,[1]],[56,[1]],[71,[2]],
     [81,[1]],[86,[1]],[101,[2]]]],
 [29744,[[5,[1]],[15,[1]],[27,[1]],[35,[1]],[45,[1]],[57,[1]],[65,[1]],
     [75,[1]],[87,[1]],[95,[1]]]],
 [29749,[[5,[1]],[22,[1]],[35,[1]],[52,[1]],[65,[1]],[82,[1]],[95,[1]],
     [112,[1]],[125,[1]],[142,[1]]]],
 [29750,[[5,[1]],[20,[1]],[35,[1]],[50,[1]],[65,[1]],[80,[1]],[95,[1]],
     [110,[1]],[125,[1]],[140,[1]]]],
 [29751,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29754,[[12,[1,1,1,1,2,2,1,1,1,2]],[32,[1,1,2,1,2]],
     [52,[1,1,1,1,2,2,1,1,1,2]],[72,[1,1,1,1,2,2,1,1,1,2]],
     [92,[1,1,2,1,2]],[112,[1,1,1,1,2,2,1,1,1,2]],
     [132,[1,1,1,1,2,2,1,1,1,2]],[152,[1,1,2,1,2]],
     [172,[1,1,1,1,2,2,1,1,1,2]],[192,[1,1,1,1,2,2,1,1,1,2]]]],
 [29760,[[5,[2,3,4,3]],[11,[1,1,1,1,2,1,2,3]],[21,[1,2]],
     [27,[1,1,1,1,2,1,2,3]],[33,[1,1,1,1,2,1,2,3]],[35,[1,1,1,1,2,1,2,3]],
     [41,[2,3,2,3,3,3,3,5]],[45,[1,1,1,1,2,1,2,3]],[53,[1,1,1,1,2,1,2,3]],
     [57,[1,1,1,1,2,1,2,3]]]],
 [29761,[[21,[1]],[41,[1]],[81,[1]],[101,[1]],[141,[1]],[161,[1]],
     [201,[1]],[221,[1]]]],
 [29780,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29782,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29783,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29809,[[0,[1,2,2]],[16,[1,2,2]],[17,[1,2,2]],[27,[1,2,2]],[31,[1,2,2]],
     [46,[1,2,2]],[47,[1,2,2]],[57,[1,2,2]],[61,[1,2,2]],[76,[1,2,2]]]],
 [29813,[[7,[3]],[37,[3]],[67,[3]],[97,[3]],[127,[3]],[157,[3]],
     [187,[3]],[217,[3]],[247,[3]]]],
 [29814,[[7,[1]],[22,[1]],[37,[1]],[52,[1]],[67,[1]],[82,[1]],[97,[1]],
     [112,[1]],[127,[1]],[142,[1]]]],
 [29816,[[1,[1,1,1,2]],[16,[1,1,1,2]],[22,[2,3]],[31,[1,1,1,2]],
     [46,[1,1,1,2]],[52,[2,3]],[61,[1,1,1,2]],[76,[1,1,1,2]],[82,[2,3]],
     [91,[1,1,1,2]]]],
 [29822,[[6,[1,1,1,1,1,2,2,2]],[10,[1,1,1,1,1,2,2,2]],[16,[1,1,1,1,1,2,2,2]]
      ,[18,[1,1,1,1,1,2,2,2]],[22,[4]],[30,[1,1,1,1,1,2,2,2]],
     [46,[2,2,2,2,2,4,4,4]],[52,[3,3,3,3,3,4,4,4]],[58,[1,1,1,1,1,2,2,2]],
     [66,[1,1,1,1,1,2,2,2]]]],
 [29830,[[2,[1,2]],[22,[1,2]],[32,[1,2]],[52,[1,2]],[62,[1,2]],
     [82,[1,2]],[92,[1,2]],[112,[1,2]],[122,[1,2]],[142,[1,2]]]],
 [29842,[[0,[1,1,1,1,2]],[17,[1,1,1,1,2]],[22,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[47,[1,1,1,1,2]],[52,[1,1,1,1,2]],[60,[1,1,1,1,2]],
     [77,[1,1,1,1,2]],[82,[1,1,1,1,2]],[90,[1,1,1,1,2]]]],
 [29844,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29848,[[17,[2]],[47,[1]],[77,[2]],[107,[1]],[137,[2]],[167,[1]],
     [197,[2]],[227,[1]]]],
 [29854,[[1,[1,1,1,2,2,2,1,2]],[5,[1,1,1,2,2,2,1,2]],[13,[2,4,3,3]],
     [17,[3]],[25,[1,1,1,2,2,2,1,2]],[41,[1,1,1,2,2,2,1,2]],
     [43,[1,1,1,2,2,2,1,2]],[47,[2,3,3,4,3,3,3,3]],[53,[1,1,1,2,2,2,1,2]],
     [61,[1,1,1,2,2,2,1,2]]]],
 [29860,[[1,[1]],[7,[1]],[21,[1]],[22,[1]],[31,[1]],[37,[1]],[51,[1]],
     [52,[1]],[61,[1]],[67,[1]]]],
 [29866,[[7,[3,3,4,4]],[13,[1,2,2,2]],[28,[1,2,2,2]],[37,[3,3,4,4]],
     [43,[1,2,2,2]],[58,[1,2,2,2]],[67,[3,3,4,4]],[73,[1,2,2,2]],
     [88,[1,2,2,2]],[97,[3,3,4,4]]]],
 [29872,[[7,[2,3]],[12,[1]],[13,[1]],[37,[2,3]],[42,[1]],[43,[1]],
     [67,[2,3]],[72,[1]],[73,[1]],[97,[2,3]]]],
 [29873,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [29877,[[2,[1,1,1,2,2,2,1,2]],[7,[2,3,3,4,3,3,3,3]],[13,[1,1,1,2,2,2,1,2]],
     [15,[1,1,1,2,2,2,1,2]],[31,[1,1,1,2,2,2,1,2]],[37,[3]],
     [43,[2,4,3,3]],[51,[1,1,1,2,2,2,1,2]],[55,[1,1,1,2,2,2,1,2]],
     [63,[1,1,1,2,2,2,1,2]]]],
 [29883,[[7,[1]],[37,[2]],[67,[1]],[97,[2]],[127,[1]],[157,[2]],
     [187,[1]],[217,[2]],[247,[1]]]],
 [29893,[[5,[1]],[25,[1]],[35,[1]],[55,[1]],[65,[1]],[85,[1]],[95,[1]],
     [115,[1]],[125,[1]],[145,[1]]]],
 [29898,[[5,[1]],[15,[1]],[27,[1]],[35,[1]],[45,[1]],[57,[1]],[65,[1]],
     [75,[1]],[87,[1]],[95,[1]]]],[29899,[[11,fail]]],
 [29900,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [29901,[[0,[2]],[15,[4]],[25,[2]],[30,[2]],[45,[4]],[55,[2]],[60,[2]],
     [75,[4]],[85,[2]],[90,[2]]]],
 [29911,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],[29914,[[0,fail]]],
 [29919,[[7,[1,1,2,2,2,1,1,2,3,2]],[27,[1,1,1,2,2]],
     [47,[1,1,2,2,2,1,1,2,3,2]],[67,[1,1,2,2,2,1,1,2,3,2]],
     [87,[1,1,1,2,2]],[107,[1,1,2,2,2,1,1,2,3,2]],
     [127,[1,1,2,2,2,1,1,2,3,2]],[147,[1,1,1,2,2]],
     [167,[1,1,2,2,2,1,1,2,3,2]],[187,[1,1,2,2,2,1,1,2,3,2]]]],
 [29920,[[6,[1,2,2]],[17,[1,2,2]],[36,[1,2,2]],[47,[1,2,2]],[66,[1,2,2]],
     [77,[1,2,2]],[96,[1,2,2]],[107,[1,2,2]],[126,[1,2,2]],[137,[1,2,2]] 
    ]],
 [29924,[[7,[1,1,1,2]],[12,[1,1,1,2]],[37,[1,1,1,2]],[42,[1,1,1,2]],
     [67,[1,1,1,2]],[72,[1,1,1,2]],[97,[1,1,1,2]],[102,[1,1,1,2]],
     [127,[1,1,1,2]],[132,[1,1,1,2]]]],
 [29925,[[3,[2,2,3,3]],[18,[2,2,3,3]],[27,[1,1,1,2]],[33,[2,2,3,3]],
     [48,[2,2,3,3]],[57,[1,1,1,2]],[63,[2,2,3,3]],[78,[2,2,3,3]],
     [87,[1,1,1,2]],[93,[2,2,3,3]]]],
 [29928,[[12,[3,4]],[42,[3,4]],[72,[3,4]],[102,[3,4]],[132,[3,4]],
     [162,[3,4]],[192,[3,4]],[222,[3,4]],[252,[3,4]]]],
 [29937,[[11,[1]],[31,[1]],[51,[1]],[71,[1]],[91,[1]],[111,[1]],
     [131,[1]],[151,[1]],[171,[1]],[191,[1]]]],
 [29939,[[7,[1,2,2]],[27,[1,2,2]],[47,[1,2,2]],[67,[1,2,2]],[87,[1,2,2]],
     [107,[1,2,2]],[127,[1,2,2]],[147,[1,2,2]],[167,[1,2,2]],
     [187,[1,2,2]]]],
 [29940,[[6,[1,1,1,2]],[27,[1,1,1,2]],[47,[1,1,1,2]],[67,[1,1,1,2]],
     [87,[1,1,1,2]],[107,[1,1,1,2]],[127,[1,1,1,2]],[147,[1,1,1,2]],
     [167,[1,1,1,2]],[187,[1,1,1,2]]]],
 [29953,[[6,[1,2]],[36,[1,2]],[66,[1,2]],[96,[1,2]],[126,[1,2]],
     [156,[1,2]],[186,[1,2]],[216,[1,2]],[246,[1,2]]]],
 [29954,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29974,[[5,[1,1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,1,2]],[17,[1,2]],
     [23,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[35,[1,1,1,1,1,1,1,2]],
     [41,[1,1,1,1,1,1,1,2]],[47,[1,2]],[53,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [29977,[[3,[1,1,1,1,1,1,1,2]],[7,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [37,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [57,[1,1,1,1,1,1,1,2]]]],
 [29978,[[7,[1,2]],[15,[1]],[37,[1,2]],[45,[1]],[67,[1,2]],[75,[1]],
     [97,[1,2]],[105,[1]],[127,[1,2]],[135,[1]]]],
 [29979,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [29998,[[7,[1,2]],[27,[1,2]],[37,[1,2]],[57,[1,2]],[67,[1,2]],
     [87,[1,2]],[97,[1,2]],[117,[1,2]],[127,[1,2]],[147,[1,2]]]],
 [30003,[[2,[1]],[7,[1]],[13,[1]],[21,[1]],[28,[1]],[32,[1]],[37,[1]],
     [43,[1]],[51,[1]],[58,[1]]]],
 [30005,[[2,[1,2,2]],[13,[3,3,4]],[28,[3,3,4]],[32,[1,2,2]],[43,[3,3,4]],
     [58,[3,3,4]],[62,[1,2,2]],[73,[3,3,4]],[88,[3,3,4]],[92,[1,2,2]]]],
 [30021,[[8,[1,1,2]],[23,[1,1,2]],[38,[1,1,2]],[53,[1,1,2]],[68,[1,1,2]],
     [83,[1,1,2]],[98,[1,1,2]],[113,[1,1,2]],[128,[1,1,2]],[143,[1,1,2]] 
    ]],
 [30025,[[6,[2,3]],[36,[2,3]],[66,[2,3]],[96,[2,3]],[126,[2,3]],
     [156,[2,3]],[186,[2,3]],[216,[2,3]],[246,[2,3]]]],
 [30026,[[12,[2,3]],[42,[2,3]],[72,[2,3]],[102,[2,3]],[132,[2,3]],
     [162,[2,3]],[192,[2,3]],[222,[2,3]],[252,[2,3]]]],[30038,[[17,fail]]],
 [30064,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [30067,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30069,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [30087,[[3,[2,2,2,3]],[7,[2,2,2,3]],[15,[1,2]],[17,[1,2]],[21,[2,2,2,3]],
     [27,[2,2,2,3]],[33,[2,2,2,3]],[37,[2,2,2,3]],[45,[1,2]],[47,[1,2]] 
    ]],
 [30088,[[7,[2,3]],[15,[1]],[17,[1]],[23,[2,3]],[38,[2,3]],[45,[1]],
     [47,[1]],[53,[2,3]],[68,[2,3]],[75,[1]]]],
 [30107,[[7,[2,3]],[37,[2,3]],[67,[2,3]],[97,[2,3]],[127,[2,3]],
     [157,[2,3]],[187,[2,3]],[217,[2,3]],[247,[2,3]]]],[30119,[[7,fail]]],
 [30125,[[3,[2]],[18,[2]],[33,[2]],[48,[2]],[63,[2]],[78,[2]],[93,[2]],
     [108,[2]],[123,[2]],[138,[2]]]],
 [30126,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [30142,[[7,[1,2]],[37,[1,2]],[67,[1,2]],[97,[1,2]],[127,[1,2]],
     [157,[1,2]],[187,[1,2]],[217,[1,2]],[247,[1,2]]]],
 [30143,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [30157,[[0,[2,3,4,3]],[6,[1,1,1,1,2,1,2,3]],[16,[1,2]],
     [22,[1,1,1,1,2,1,2,3]],[28,[1,1,1,1,2,1,2,3]],[30,[1,1,1,1,2,1,2,3]],
     [36,[2,3,2,3,3,3,3,5]],[40,[1,1,1,1,2,1,2,3]],[48,[1,1,1,1,2,1,2,3]],
     [52,[1,1,1,1,2,1,2,3]]]],
 [30158,[[16,[1]],[36,[1]],[76,[1]],[96,[1]],[136,[1]],[156,[1]],
     [196,[1]],[216,[1]]]],
 [30159,[[7,[1,2]],[12,[1,2]],[37,[1,2]],[42,[1,2]],[67,[1,2]],
     [72,[1,2]],[97,[1,2]],[102,[1,2]],[127,[1,2]],[132,[1,2]]]],
 [30162,[[7,[2,3]],[8,[1]],[12,[1]],[18,[1]],[37,[2,3]],[38,[1]],
     [42,[1]],[48,[1]],[67,[2,3]],[68,[1]]]],
 [30164,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [30166,[[7,[1,2]],[18,[1]],[37,[1,2]],[38,[1]],[67,[1,2]],[78,[1]],
     [97,[1,2]],[98,[1]],[127,[1,2]],[138,[1]]]],
 [30167,[[6,[2]],[21,[2]],[26,[2]],[51,[2]],[66,[2]],[81,[2]],[86,[2]],
     [111,[2]],[126,[2]],[141,[2]]]],
 [30168,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [30174,[[7,[1,2]],[37,[1,2]],[67,[1,2]],[97,[1,2]],[127,[1,2]],
     [157,[1,2]],[187,[1,2]],[217,[1,2]],[247,[1,2]]]],
 [30175,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [30176,[[8,[1,2,2,2]],[28,[1,2]],[48,[1,2,2,2]],[68,[1,2,2,2]],
     [88,[1,2]],[108,[1,2,2,2]],[128,[1,2,2,2]],[148,[1,2]],
     [168,[1,2,2,2]],[188,[1,2,2,2]]]],
 [30178,[[12,[1,2]],[42,[1,2]],[72,[1,2]],[102,[1,2]],[132,[1,2]],
     [162,[1,2]],[192,[1,2]],[222,[1,2]],[252,[1,2]]]],
 [30179,[[2,[1,2]],[31,[1,2]],[33,[1,2]],[51,[1,2]],[63,[1,2]],
     [91,[1,2]],[93,[1,2]],[111,[1,2]],[123,[1,2]],[151,[1,2]]]],
 [30180,[[12,[1,2,2,2]],[42,[1,2]],[72,[1,2,2,2]],[102,[1,2,2,2]],
     [132,[1,2]],[162,[1,2,2,2]],[192,[1,2,2,2]],[222,[1,2]],
     [252,[1,2,2,2]]]],
 [30182,[[6,[1]],[42,[1]],[51,[1]],[96,[1]],[102,[1]],[141,[1]],
     [162,[1]],[186,[1]],[222,[1]],[231,[1]]]],
 [30184,[[12,[1,2]],[13,[1]],[33,[1]],[42,[1,2]],[72,[1,2]],[73,[1]],
     [93,[1]],[102,[1,2]],[132,[1,2]],[133,[1]]]],
 [30186,[[0,[2,3]],[31,[2,3]],[33,[2,3]],[51,[2,3]],[63,[2,3]],
     [91,[2,3]],[93,[2,3]],[111,[2,3]],[123,[2,3]],[151,[2,3]]]],
 [30187,[[6,[1]],[42,[1]],[51,[1]],[96,[1]],[102,[1]],[141,[1]],
     [162,[1]],[186,[1]],[222,[1]],[231,[1]]]],
 [30188,[[12,[1,2,2,3]],[42,[1,2]],[72,[1,2,2,3]],[102,[1,2,2,3]],
     [132,[1,2]],[162,[1,2,2,3]],[192,[1,2,2,3]],[222,[1,2]],
     [252,[1,2,2,3]]]],
 [30189,[[33,[1,2]],[97,[1,2]],[126,[1,2]],[127,[1,2]]]],
 [30202,[[12,[1,1,1,2]],[32,[1,1,1,2]],[52,[1,1,1,2]],[72,[1,1,1,2]],
     [92,[1,1,1,2]],[112,[1,1,1,2]],[132,[1,1,1,2]],[152,[1,1,1,2]],
     [172,[1,1,1,2]],[192,[1,1,1,2]]]],
 [30208,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [30214,[[12,[1,1,1,2]],[32,[1,1,1,2]],[52,[1,1,1,2]],[72,[1,1,1,2]],
     [92,[1,1,1,2]],[112,[1,1,1,2]],[132,[1,1,1,2]],[152,[1,1,1,2]],
     [172,[1,1,1,2]],[192,[1,1,1,2]]]],
 [30219,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [30221,[[1,[1,2,2]],[22,[1,2,2]],[42,[1,2,2]],[62,[1,2,2]],[82,[1,2,2]],
     [102,[1,2,2]],[122,[1,2,2]],[142,[1,2,2]],[162,[1,2,2]],
     [182,[1,2,2]]]],
 [30226,[[2,[1,1,1,2]],[22,[1,1,1,2]],[42,[1,1,1,2]],[62,[1,1,1,2]],
     [82,[1,1,1,2]],[102,[1,1,1,2]],[122,[1,1,1,2]],[142,[1,1,1,2]],
     [162,[1,1,1,2]],[182,[1,1,1,2]]]],[30286,[[2,fail]]],
 [30306,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30311,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30313,[[11,[1,2]],[16,[1,2]],[41,[1,2]],[46,[1,2]],[71,[1,2]],
     [76,[1,2]],[101,[1,2]],[106,[1,2]],[131,[1,2]],[136,[1,2]]]],
 [30314,[[11,[1]],[16,[1,2]],[41,[1]],[46,[1,2]],[71,[1]],[76,[1,2]],
     [101,[1]],[106,[1,2]],[131,[1]],[136,[1,2]]]],
 [30316,[[11,[3,4]],[21,[3,4]],[41,[3,4]],[51,[3,4]],[71,[3,4]],
     [81,[3,4]],[101,[3,4]],[111,[3,4]],[131,[3,4]],[141,[3,4]]]],
 [30322,[[0,[1]],[5,[1]],[15,[1]],[21,[1]],[25,[1]],[26,[1]],[31,[1]],
     [35,[1]],[45,[1]],[51,[1]]]],
 [30327,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [30328,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [30331,[[6,[2,2,3]],[16,[2,2,3]],[36,[2,2,3]],[46,[2,2,3]],[66,[2,2,3]],
     [76,[2,2,3]],[96,[2,2,3]],[106,[2,2,3]],[126,[2,2,3]],[136,[2,2,3]] 
    ]],
 [30332,[[1,[1,2]],[4,[1,2]],[6,[1,2]],[14,[1,2]],[24,[1,2]],[26,[1,2]],
     [31,[1,2]],[34,[1,2]],[36,[1,2]],[44,[1,2]]]],
 [30355,[[11,[1,2,3]],[41,[1,2,3]],[71,[1,2,3]],[101,[1,2,3]],
     [131,[1,2,3]],[161,[1,2,3]],[191,[1,2,3]],[221,[1,2,3]],
     [251,[1,2,3]]]],
 [30356,[[8,[1]],[23,[1]],[38,[1]],[53,[1]],[68,[1]],[83,[1]],[98,[1]],
     [113,[1]],[128,[1]],[143,[1]]]],
 [30360,[[11,[1,2]],[26,[1,2]],[41,[1,2]],[56,[1,2]],[71,[1,2]],
     [86,[1,2]],[101,[1,2]],[116,[1,2]],[131,[1,2]],[146,[1,2]]]],
 [30362,[[16,[2]],[46,[2]],[76,[2]],[106,[2]],[136,[2]],[166,[2]],
     [196,[2]],[226,[2]]]],
 [30365,[[5,[1,2]],[6,[2]],[15,[1,2]],[16,[2]],[21,[1,2]],[25,[1,2]],
     [35,[1,2]],[36,[2]],[45,[1,2]],[46,[2]]]],
 [30366,[[5,[1,2]],[6,[1,2]],[11,[1,2]],[15,[1,2]],[25,[1,2]],[26,[1,2]],
     [35,[1,2]],[36,[1,2]],[41,[1,2]],[45,[1,2]]]],
 [30376,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [30377,[[6,[1,2,3]],[36,[1,2,3]],[66,[1,2,3]],[96,[1,2,3]],[126,[1,2,3]],
     [156,[1,2,3]],[186,[1,2,3]],[216,[1,2,3]],[246,[1,2,3]]]],
 [30378,[[3,[1]],[18,[1]],[33,[1]],[48,[1]],[63,[1]],[78,[1]],[93,[1]],
     [108,[1]],[123,[1]],[138,[1]]]],
 [30379,[[0,[1,2]],[10,[1,2]],[11,[1,2]],[20,[1,2]],[21,[1,2]],
     [26,[1,2]],[30,[1,2]],[40,[1,2]],[41,[1,2]],[50,[1,2]]]],
 [30380,[[1,[1,2,2,2]],[8,[1,2,2,2]],[11,[1,2,2,2]],[16,[1,2,2,2]],
     [18,[1,2,2,2]],[28,[1,2,2,2]],[31,[1,2,2,2]],[38,[1,2,2,2]],
     [41,[1,2,2,2]],[46,[1,2,2,2]]]],
 [30381,[[1,[3,4]],[21,[3,4]],[31,[3,4]],[51,[3,4]],[61,[3,4]],
     [81,[3,4]],[91,[3,4]],[111,[3,4]],[121,[3,4]],[141,[3,4]]]],
 [30404,[[5,[1,1,1,1,2]],[25,[1,1,1,1,2]],[35,[1,1,1,1,2]],
     [55,[1,1,1,1,2]],[65,[1,1,1,1,2]],[85,[1,1,1,1,2]],[95,[1,1,1,1,2]],
     [115,[1,1,1,1,2]],[125,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [30408,[[15,[1,2]],[20,[1]],[45,[1,2]],[50,[1]],[75,[1,2]],[80,[1]],
     [105,[1,2]],[110,[1]],[135,[1,2]],[140,[1]]]],
 [30410,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [30412,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],
     [110,[1,1,1,1,2]],[120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],
 [30413,[[5,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[19,[1,2]],[29,[1,2]],
     [35,[1,2]],[39,[1,2]],[40,[1,2]],[45,[1,2]]]],
 [30414,[[5,[3,4]],[25,[3,4]],[35,[3,4]],[55,[3,4]],[65,[3,4]],
     [85,[3,4]],[95,[3,4]],[115,[3,4]],[125,[3,4]],[145,[3,4]]]],
 [30417,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [30419,[[3,[1,2]],[13,[1,2]],[15,[1,2]],[20,[1,2]],[23,[1,2]],
     [25,[1,2]],[33,[1,2]],[43,[1,2]],[45,[1,2]],[50,[1,2]]]],
 [30421,[[15,[1]],[20,[1,2]],[45,[1]],[50,[1,2]],[75,[1]],[80,[1,2]],
     [105,[1]],[110,[1,2]],[135,[1]],[140,[1,2]]]],
 [30423,[[10,[1]],[15,[1,2]],[40,[1]],[45,[1,2]],[70,[1]],[75,[1,2]],
     [100,[1]],[105,[1,2]],[130,[1]],[135,[1,2]]]],
 [30424,[[10,[1,2]],[15,[1]],[40,[1,2]],[45,[1]],[70,[1,2]],[75,[1]],
     [100,[1,2]],[105,[1]],[130,[1,2]],[135,[1]]]],
 [30426,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],
     [110,[1,1,1,1,2]],[120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],
 [30427,[[10,[3,4]],[20,[3,4]],[40,[3,4]],[50,[3,4]],[70,[3,4]],
     [80,[3,4]],[100,[3,4]],[110,[3,4]],[130,[3,4]],[140,[3,4]]]],
 [30429,[[0,[3,4]],[20,[3,4]],[30,[3,4]],[50,[3,4]],[60,[3,4]],
     [80,[3,4]],[90,[3,4]],[110,[3,4]],[120,[3,4]],[140,[3,4]]]],
 [30451,[[5,[1,1,1,1,2]],[25,[1,1,1,1,2]],[35,[1,1,1,1,2]],
     [55,[1,1,1,1,2]],[65,[1,1,1,1,2]],[85,[1,1,1,1,2]],[95,[1,1,1,1,2]],
     [115,[1,1,1,1,2]],[125,[1,1,1,1,2]],[145,[1,1,1,1,2]]]],
 [30455,[[15,[1,2]],[20,[1,2]],[45,[1,2]],[50,[1,2]],[75,[1,2]],
     [80,[1,2]],[105,[1,2]],[110,[1,2]],[135,[1,2]],[140,[1,2]]]],
 [30457,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [30459,[[0,[1,1,2,2]],[20,[1,1,2,2]],[30,[1,1,2,2]],[50,[1,1,2,2]],
     [60,[1,1,2,2]],[80,[1,1,2,2]],[90,[1,1,2,2]],[110,[1,1,2,2]],
     [120,[1,1,2,2]],[140,[1,1,2,2]]]],
 [30460,[[5,[1,2]],[9,[1,2]],[10,[1,2]],[15,[1,2]],[19,[1,2]],[29,[1,2]],
     [35,[1,2]],[39,[1,2]],[40,[1,2]],[45,[1,2]]]],
 [30461,[[5,[2,2,3]],[25,[2,2,3]],[35,[2,2,3]],[55,[2,2,3]],[65,[2,2,3]],
     [85,[2,2,3]],[95,[2,2,3]],[115,[2,2,3]],[125,[2,2,3]],[145,[2,2,3]] 
    ]],
 [30464,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30466,[[3,[1]],[13,[1]],[15,[1]],[20,[1]],[23,[1]],[25,[1]],[33,[1]],
     [43,[1]],[45,[1]],[50,[1]]]],
 [30468,[[15,[1,2]],[20,[1]],[45,[1,2]],[50,[1]],[75,[1,2]],[80,[1]],
     [105,[1,2]],[110,[1]],[135,[1,2]],[140,[1]]]],
 [30470,[[10,[1,2]],[15,[1]],[40,[1,2]],[45,[1]],[70,[1,2]],[75,[1]],
     [100,[1,2]],[105,[1]],[130,[1,2]],[135,[1]]]],
 [30471,[[10,[1,2]],[15,[1,2]],[40,[1,2]],[45,[1,2]],[70,[1,2]],
     [75,[1,2]],[100,[1,2]],[105,[1,2]],[130,[1,2]],[135,[1,2]]]],
 [30473,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[30,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[60,[1,1,1,1,2]],[80,[1,1,1,1,2]],[90,[1,1,1,1,2]],
     [110,[1,1,1,1,2]],[120,[1,1,1,1,2]],[140,[1,1,1,1,2]]]],
 [30474,[[10,[2,2,3]],[20,[2,2,3]],[40,[2,2,3]],[50,[2,2,3]],[70,[2,2,3]],
     [80,[2,2,3]],[100,[2,2,3]],[110,[2,2,3]],[130,[2,2,3]],[140,[2,2,3]] 
    ]],
 [30476,[[0,[3,4]],[20,[3,4]],[30,[3,4]],[50,[3,4]],[60,[3,4]],
     [80,[3,4]],[90,[3,4]],[110,[3,4]],[120,[3,4]],[140,[3,4]]]],
 [30501,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30503,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30506,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [30507,[[0,[1]],[20,[1]],[30,[1]],[50,[1]],[60,[1]],[80,[1]],[90,[1]],
     [110,[1]],[120,[1]],[140,[1]]]],
 [30512,[[0,[1]],[5,[1]],[10,[1]],[16,[1]],[20,[1]],[21,[1]],[25,[1]],
     [26,[1]],[31,[1]],[35,[1]]]],
 [30517,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [30520,[[5,[1]],[15,[1]],[35,[1]],[45,[1]],[65,[1]],[75,[1]],[95,[1]],
     [105,[1]],[125,[1]],[135,[1]]]],
 [30521,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [30522,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [30541,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [30546,[[10,[1]],[16,[1]],[40,[1]],[46,[1]],[70,[1]],[76,[1]],
     [100,[1]],[106,[1]],[130,[1]],[136,[1]]]],
 [30548,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30551,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [30562,[[5,[1]],[11,[1]],[35,[1]],[41,[1]],[65,[1]],[71,[1]],[95,[1]],
     [101,[1]],[125,[1]],[131,[1]]]],
 [30563,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30567,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [30586,[[1,[1,1,1,1,1,1,2,2]],[8,[1,1,1,1,1,1,2,2]],[14,[1]],
     [20,[1,1,1,1,1,1,2,2]],[26,[1,1,1,1,1,1,2,2]],[31,[1,1,1,1,1,1,2,2]],
     [38,[1,1,1,1,1,1,2,2]],[44,[1]],[50,[1,1,1,1,1,1,2,2]],
     [56,[1,1,1,1,1,1,2,2]]]],
 [30590,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30592,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30594,[[1,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[13,[1]],
     [19,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[43,[1]],[49,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [30595,[[10,[1]],[21,[1]],[40,[1]],[51,[1]],[70,[1]],[81,[1]],
     [100,[1]],[111,[1]],[130,[1]],[141,[1]]]],
 [30606,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [30633,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30635,[[13,[1]],[15,[1]],[43,[1]],[45,[1]],[73,[1]],[75,[1]],
     [103,[1]],[105,[1]],[133,[1]],[135,[1]]]],
 [30636,[[1,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[13,[1,2]],
     [19,[1,1,1,1,1,1,1,2]],[25,[1,1,1,1,1,1,1,2]],[31,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[43,[1,2]],[49,[1,1,1,1,1,1,1,2]],
     [55,[1,1,1,1,1,1,1,2]]]],
 [30638,[[11,[1]],[21,[1]],[41,[1]],[51,[1]],[71,[1]],[81,[1]],
     [101,[1]],[111,[1]],[131,[1]],[141,[1]]]],
 [30649,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [30650,[[0,[1,1,1,1,1,1,1,2]],[6,[1,1,1,1,1,1,1,2]],[11,[1,2]],
     [18,[1,1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,1,2]],[30,[1,1,1,1,1,1,1,2]],
     [36,[1,1,1,1,1,1,1,2]],[41,[1,2]],[48,[1,1,1,1,1,1,1,2]],
     [54,[1,1,1,1,1,1,1,2]]]],
 [30654,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [30675,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30677,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [30680,[[9,[2,2,3]],[19,[1,1,2]],[21,[1]],[39,[2,2,3]],[49,[1,1,2]],
     [51,[1]],[69,[2,2,3]],[79,[1,1,2]],[81,[1]],[99,[2,2,3]]]],
 [30681,[[3,[2,3,3]],[25,[2,3,3]],[33,[2,3,3]],[55,[2,3,3]],[63,[2,3,3]],
     [85,[2,3,3]],[93,[2,3,3]],[115,[2,3,3]],[123,[2,3,3]],[145,[2,3,3]] 
    ]],
 [30691,[[9,[1,2]],[39,[1,2]],[69,[1,2]],[99,[1,2]],[129,[1,2]],
     [159,[1,2]],[189,[1,2]],[219,[1,2]],[249,[1,2]]]],
 [30695,[[1,[1]],[4,[1]],[6,[1]],[8,[1]],[14,[1]],[18,[1]],[24,[1]],
     [28,[1]],[31,[1]],[34,[1]]]],
 [30696,[[1,[1,2]],[4,[1,2]],[6,[1,2]],[8,[1,2]],[14,[1,2]],[18,[1,2]],
     [24,[1,2]],[28,[1,2]],[31,[1,2]],[34,[1,2]]]],
 [30711,[[5,[1,1,1,1,1,1,1,2]],[11,[1,1,1,1,1,1,1,2]],[16,[1,2]],
     [23,[1,1,1,1,1,1,1,2]],[29,[1,1,1,1,1,1,1,2]],[35,[1,1,1,1,1,1,1,2]],
     [41,[1,1,1,1,1,1,1,2]],[46,[1,2]],[53,[1,1,1,1,1,1,1,2]],
     [59,[1,1,1,1,1,1,1,2]]]],
 [30716,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30718,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30719,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30732,[[0,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[11,[1]],
     [18,[1,1,1,1,2,1,1,2]],[24,[1,1,1,1,2,1,1,2]],[30,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[41,[1]],[48,[1,1,1,1,2,1,1,2]],
     [54,[1,1,1,1,2,1,1,2]]]],
 [30737,[[1,[1]],[20,[1]],[31,[1]],[50,[1]],[61,[1]],[80,[1]],[91,[1]],
     [110,[1]],[121,[1]],[140,[1]]]],
 [30756,[[14,[1,2]],[44,[1,2]],[74,[1,2]],[104,[1,2]],[134,[1,2]],
     [164,[1,2]],[194,[1,2]],[224,[1,2]],[254,[1,2]]]],
 [30759,[[13,[1]],[43,[1]],[73,[1]],[103,[1]],[133,[1]],[163,[1]],
     [193,[1]],[223,[1]],[253,[1]]]],
 [30761,[[5,[1,2]],[6,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [25,[1,2]],[29,[1,2]],[35,[1,2]],[36,[1,2]]]],
 [30762,[[5,[1]],[6,[1]],[9,[1]],[11,[1]],[15,[1]],[19,[1]],[25,[1]],
     [29,[1]],[35,[1]],[36,[1]]]],
 [30772,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [30773,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [30776,[[8,[2,3,3]],[18,[2,3,3]],[38,[2,3,3]],[48,[2,3,3]],[68,[2,3,3]],
     [78,[2,3,3]],[98,[2,3,3]],[108,[2,3,3]],[128,[2,3,3]],[138,[2,3,3]] 
    ]],
 [30777,[[1,[2,2,3]],[20,[1]],[24,[1,1,2]],[31,[2,2,3]],[50,[1]],
     [54,[1,1,2]],[61,[2,2,3]],[80,[1]],[84,[1,1,2]],[91,[2,2,3]]]],
 [30790,[[14,[1,2,2]],[44,[1,2,2]],[74,[1,2,2]],[104,[1,2,2]],
     [134,[1,2,2]],[164,[1,2,2]],[194,[1,2,2]],[224,[1,2,2]],
     [254,[1,2,2]]]],
 [30795,[[14,[2,3]],[44,[2,3]],[74,[2,3]],[104,[2,3]],[134,[2,3]],
     [164,[2,3]],[194,[2,3]],[224,[2,3]],[254,[2,3]]]],
 [30797,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [30799,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [30808,[[20,[1,1,2]],[50,[1,1,2]],[80,[1,1,2]],[110,[1,1,2]],
     [140,[1,1,2]],[170,[1,1,2]],[200,[1,1,2]],[230,[1,1,2]]]],
 [30811,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [30813,[[3,[1]],[18,[1]],[33,[1]],[48,[1]],[63,[1]],[78,[1]],[93,[1]],
     [108,[1]],[123,[1]],[138,[1]]]],
 [30831,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [30833,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30835,[[6,[1,1,1,1,2]],[11,[1,1,1,1,2]],[16,[1,2]],[28,[1,1,1,1,2]],
     [36,[1,1,1,1,2]],[41,[1,1,1,1,2]],[46,[1,2]],[58,[1,1,1,1,2]],
     [66,[1,1,1,1,2]],[71,[1,1,1,1,2]]]],
 [30842,[[4,[1]],[14,[1]],[19,[1]],[29,[1]],[34,[1]],[44,[1]],[49,[1]],
     [59,[1]],[64,[1]],[74,[1]]]],
 [30866,[[8,[2,2,3]],[36,[2,2,3]],[48,[2,2,3]],[88,[2,2,3]],[96,[2,2,3]],
     [128,[2,2,3]],[156,[2,2,3]],[168,[2,2,3]],[208,[2,2,3]],
     [216,[2,2,3]]]],
 [30869,[[8,[1]],[23,[1]],[38,[1]],[53,[1]],[68,[1]],[83,[1]],[98,[1]],
     [113,[1]],[128,[1]],[143,[1]]]],
 [30870,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [30874,[[1,[2,2,3,3]],[6,[2,2,3,3]],[13,[1]],[14,[1]],[19,[2,2,3,3]],
     [25,[2,2,3,3]],[31,[2,2,3,3]],[36,[2,2,3,3]],[43,[1]],[44,[1]]]],
 [30875,[[9,[1,2]],[11,[2,4]],[19,[1,2]],[29,[1,2]],[39,[1,2]],
     [41,[2,4]],[49,[1,2]],[59,[1,2]],[69,[1,2]],[71,[2,4]]]],
 [30879,[[0,[1,1,2]],[8,[1,1,2]],[19,[1,1,2]],[23,[1,1,2]],[26,[1,1,2]],
     [31,[1,1,2]],[38,[1,1,2]],[49,[1,1,2]],[53,[1,1,2]],[56,[1,1,2]]]],
 [30886,[[11,[3]],[41,[3]],[71,[3]],[101,[3]],[131,[3]],[161,[3]],
     [191,[3]],[221,[3]],[251,[3]]]],
 [30906,[[5,[1,1,1,1,2,1,1,2]],[11,[1,1,1,1,2,1,1,2]],[16,[1]],
     [23,[1,1,1,1,2,1,1,2]],[29,[1,1,1,1,2,1,1,2]],[35,[1,1,1,1,2,1,1,2]],
     [41,[1,1,1,1,2,1,1,2]],[46,[1]],[53,[1,1,1,1,2,1,1,2]],
     [59,[1,1,1,1,2,1,1,2]]]],
 [30908,[[4,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [21,[1,1,1,1,2,1,1,2]],[28,[1,1,1,1,2,1,1,2]],[34,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[51,[1,1,1,1,2,1,1,2]],
     [58,[1,1,1,1,2,1,1,2]]]],
 [30921,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [30922,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [30927,[[1,[1]],[21,[1]],[31,[1]],[51,[1]],[61,[1]],[81,[1]],[91,[1]],
     [111,[1]],[121,[1]],[141,[1]]]],
 [30941,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30943,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [30946,[[11,[2]],[19,[2]],[41,[2]],[49,[2]],[71,[2]],[79,[2]],
     [101,[2]],[109,[2]],[131,[2]],[139,[2]]]],
 [30957,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [30960,[[0,[1,1,1,1,2]],[8,[1,1,1,1,2]],[10,[1,1,1,1,2]],[11,[1,1,1,1,2]],
     [16,[1,1,1,1,2]],[18,[1,1,1,1,2]],[20,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[38,[1,1,1,1,2]]]],
 [30961,[[0,[1,1,1,1,2]],[8,[1,1,1,1,2]],[10,[1,1,1,1,2]],[11,[1,1,1,1,2]],
     [16,[1,1,1,1,2]],[18,[1,1,1,1,2]],[20,[1,1,1,1,2]],[28,[1,1,1,1,2]],
     [30,[1,1,1,1,2]],[38,[1,1,1,1,2]]]],
 [30962,[[1,[1]],[19,[1]],[31,[1]],[49,[1]],[61,[1]],[79,[1]],[91,[1]],
     [109,[1]],[121,[1]],[139,[1]]]],
 [30975,[[8,[1,2]],[23,[1,2]],[38,[1,2]],[53,[1,2]],[68,[1,2]],
     [83,[1,2]],[98,[1,2]],[113,[1,2]],[128,[1,2]],[143,[1,2]]]],
 [30977,[[13,[2]],[43,[2]],[73,[2]],[103,[2]],[133,[2]],[163,[2]],
     [193,[2]],[223,[2]],[253,[2]]]],
 [30980,[[11,[1,2]],[19,[1,2]],[41,[1,2]],[49,[1,2]],[71,[1,2]],
     [79,[1,2]],[101,[1,2]],[109,[1,2]],[131,[1,2]],[139,[1,2]]]],
 [30991,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [30996,[[1,[1]],[19,[1]],[31,[1]],[49,[1]],[61,[1]],[79,[1]],[91,[1]],
     [109,[1]],[121,[1]],[139,[1]]]],
 [31010,[[4,[1,1,1,2]],[5,[1,1,1,2]],[10,[1,1,1,2]],[11,[1,1,1,2]],
     [16,[2]],[21,[1,1,1,2]],[23,[1,1,1,2]],[28,[1,1,1,2]],
     [29,[1,1,1,2]],[34,[1,1,1,2]]]],
 [31011,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31014,[[5,[1,2]],[14,[1,2]],[15,[1,2]],[29,[1,2]],[35,[1,2]],
     [44,[1,2]],[45,[1,2]],[59,[1,2]],[65,[1,2]],[74,[1,2]]]],
 [31015,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31016,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31017,[[4,[1,1,1,1,2]],[16,[1,2]],[21,[1,1,1,1,2]],[26,[1,1,1,1,2]],
     [34,[1,1,1,1,2]],[46,[1,2]],[51,[1,1,1,1,2]],[56,[1,1,1,1,2]],
     [64,[1,1,1,1,2]],[76,[1,2]]]],
 [31018,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31019,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31020,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31021,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31022,[[0,[1]],[20,[1]],[30,[1]],[50,[1]],[60,[1]],[80,[1]],[90,[1]],
     [110,[1]],[120,[1]],[140,[1]]]],
 [31023,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [31024,[[11,[1,2]],[15,[1,2]],[41,[1,2]],[45,[1,2]],[71,[1,2]],
     [75,[1,2]],[101,[1,2]],[105,[1,2]],[131,[1,2]],[135,[1,2]]]],
 [31025,[[5,[1]],[9,[1]],[20,[1]],[24,[1]],[35,[1]],[39,[1]],[50,[1]],
     [54,[1]],[65,[1]],[69,[1]]]],
 [31026,[[0,[1]],[15,[1]],[20,[1]],[21,[1]],[30,[1]],[45,[1]],[50,[1]],
     [51,[1]],[60,[1]],[75,[1]]]],
 [31028,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31031,[[16,[1,1,2,2]],[46,[1,2]],[53,[1,1,2,2]],[106,[1,1,2,2]],
     [113,[1,1,2,2]],[136,[1,2]],[173,[1,1,2,2]],[196,[1,1,2,2]],
     [226,[1,2]],[233,[1,1,2,2]]]],
 [31032,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31033,[[10,[3,5]],[30,[3,5]],[50,[3,5]],[70,[3,5]],[90,[3,5]],
     [110,[3,5]],[130,[3,5]],[150,[3,5]],[170,[3,5]],[190,[3,5]]]],
 [31036,[[9,[1,2]],[26,[1,2]],[29,[1,2]],[56,[1,2]],[69,[1,2]],
     [86,[1,2]],[89,[1,2]],[116,[1,2]],[129,[1,2]],[146,[1,2]]]],
 [31037,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31038,[[16,[1]],[35,[1]],[76,[1]],[80,[1]],[125,[1]],[136,[1]],
     [170,[1]],[196,[1]],[215,[1]]]],
 [31040,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31041,[[8,[1]],[28,[1]],[48,[1]],[68,[1]],[88,[1]],[108,[1]],
     [128,[1]],[148,[1]],[168,[1]],[188,[1]]]],
 [31042,[[13,[1,2]],[43,[1,2]],[73,[1,2]],[103,[1,2]],[133,[1,2]],
     [163,[1,2]],[193,[1,2]],[223,[1,2]],[253,[1,2]]]],
 [31045,[[6,[2]],[21,[2]],[36,[2]],[51,[2]],[66,[2]],[81,[2]],[96,[2]],
     [111,[2]],[126,[2]],[141,[2]]]],
 [31049,[[19,[1,2,2]],[49,[1,2,2]],[79,[1,2,2]],[109,[1,2,2]],
     [139,[1,2,2]],[169,[1,2,2]],[199,[1,2,2]],[229,[1,2,2]]]],
 [31056,[[6,[1]],[36,[1]],[66,[1]],[96,[1]],[126,[1]],[156,[1]],
     [186,[1]],[216,[1]],[246,[1]]]],
 [31059,[[0,[2]],[10,[2]],[20,[2]],[21,[2]],[30,[2]],[40,[2]],[50,[2]],
     [51,[2]],[60,[2]],[70,[2]]]],
 [31061,[[0,[3]],[10,[3]],[20,[3]],[21,[3]],[30,[3]],[40,[3]],[50,[3]],
     [51,[3]],[60,[3]],[70,[3]]]],
 [31074,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31075,[[6,[1,2]],[21,[1,2]],[36,[1,2]],[51,[1,2]],[66,[1,2]],
     [81,[1,2]],[96,[1,2]],[111,[1,2]],[126,[1,2]],[141,[1,2]]]],
 [31077,[[5,[2]],[15,[2]],[25,[2]],[35,[2]],[45,[2]],[55,[2]],[65,[2]],
     [75,[2]],[85,[2]],[95,[2]]]],
 [31078,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31079,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31080,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31081,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31082,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31083,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31084,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31085,[[6,[1]],[36,[1]],[66,[1]],[96,[1]],[126,[1]],[156,[1]],
     [186,[1]],[216,[1]],[246,[1]]]],
 [31086,[[15,[1,2]],[45,[1,2]],[75,[1,2]],[105,[1,2]],[135,[1,2]],
     [165,[1,2]],[195,[1,2]],[225,[1,2]],[255,[1,2]]]],
 [31087,[[11,[1,2]],[15,[1,2]],[41,[1,2]],[45,[1,2]],[71,[1,2]],
     [75,[1,2]],[101,[1,2]],[105,[1,2]],[131,[1,2]],[135,[1,2]]]],
 [31088,[[6,[1]],[9,[1]],[11,[1]],[13,[1]],[24,[1]],[36,[1]],[39,[1]],
     [41,[1]],[43,[1]],[54,[1]]]],
 [31089,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [31091,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31095,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31096,[[10,[1,2]],[25,[1,2]],[30,[1,2]],[55,[1,2]],[70,[1,2]],
     [85,[1,2]],[90,[1,2]],[115,[1,2]],[130,[1,2]],[145,[1,2]]]],
 [31099,[[9,[3]],[29,[2]],[36,[1]],[49,[3]],[69,[2]],[89,[3]],[96,[1]],
     [109,[2]],[129,[3]],[149,[2]]]],
 [31100,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31101,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31102,[[10,[1,1,2,2]],[46,[1,2]],[70,[1,1,2,2]],[76,[1,1,2,2]],
     [130,[1,1,2,2]],[136,[1,2]],[166,[1,1,2,2]],[190,[1,1,2,2]],
     [226,[1,2]],[250,[1,1,2,2]]]],
 [31103,[[13,[1]],[46,[1]],[58,[1]],[103,[1]],[106,[1]],[148,[1]],
     [166,[1]],[193,[1]],[226,[1]],[238,[1]]]],
 [31104,[[4,[1]],[28,[1]],[34,[1]],[48,[1]],[64,[1]],[88,[1]],[94,[1]],
     [108,[1]],[124,[1]],[148,[1]]]],
 [31106,[[10,[2]],[11,[2]],[25,[2]],[40,[2]],[41,[2]],[55,[2]],[70,[2]],
     [71,[2]],[85,[2]],[100,[2]]]],
 [31117,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31118,[[0,[2,2,2,3]],[6,[2,2,2,3]],[11,[1,2]],[13,[1,2]],[18,[2,2,2,3]],
     [24,[2,2,2,3]],[30,[2,2,2,3]],[36,[2,2,2,3]],[41,[1,2]],[43,[1,2]] 
    ]],
 [31122,[[1,[1]],[10,[1]],[25,[1]],[31,[1]],[40,[1]],[55,[1]],[61,[1]],
     [70,[1]],[85,[1]],[91,[1]]]],
 [31124,[[23,[1,1,2]],[43,[1]],[83,[1]],[103,[1,1,2]],[109,[1]],
     [143,[1,1,2]],[203,[1]],[223,[1,1,2]],[229,[1,1,2]]]],
 [31135,[[4,[2]],[19,[2]],[21,[2]],[34,[2]],[49,[2]],[51,[2]],[64,[2]],
     [79,[2]],[81,[2]],[94,[2]]]],
 [31139,[[19,[1,1,2,2,3]],[49,[1,1,2,2,3]],[79,[1,1,2,2,3]],
     [109,[1,1,2,2,3]],[139,[1,1,2,2,3]],[169,[1,1,2,2,3]],
     [199,[1,1,2,2,3]],[229,[1,1,2,2,3]]]],
 [31143,[[0,[1,1,1,1,2]],[20,[1,1,1,1,2]],[21,[1,1,1,1,2]],
     [31,[1,1,1,1,2]],[50,[1,1,1,1,2]],[51,[1,1,1,1,2]],[61,[1,1,1,1,2]],
     [80,[1,1,1,1,2]],[81,[1,1,1,1,2]],[91,[1,1,1,1,2]]]],
 [31144,[[19,[1,1,2,2,3]],[49,[1,1,2,2,3]],[79,[1,1,2,2,3]],
     [109,[1,1,2,2,3]],[139,[1,1,2,2,3]],[169,[1,1,2,2,3]],
     [199,[1,1,2,2,3]],[229,[1,1,2,2,3]]]],
 [31146,[[4,[1]],[19,[1]],[34,[1]],[49,[1]],[64,[1]],[79,[1]],[94,[1]],
     [109,[1]],[124,[1]],[139,[1]]]],
 [31150,[[6,[3]],[8,[1,2]],[18,[1,2]],[28,[1,2]],[36,[3]],[38,[1,2]],
     [48,[1,2]],[58,[1,2]],[66,[3]],[68,[1,2]]]],
 [31164,[[5,[1,2]],[6,[1,2]],[9,[1,2]],[11,[1,2]],[15,[1,2]],[19,[1,2]],
     [25,[1,2]],[29,[1,2]],[35,[1,2]],[36,[1,2]]]],
 [31165,[[11,[1,2]],[21,[1,2]],[41,[1,2]],[51,[1,2]],[71,[1,2]],
     [81,[1,2]],[101,[1,2]],[111,[1,2]],[131,[1,2]],[141,[1,2]]]],
 [31166,[[5,[1,2]],[15,[1,2]],[21,[1,2]],[25,[1,2]],[35,[1,2]],
     [45,[1,2]],[51,[1,2]],[55,[1,2]],[65,[1,2]],[75,[1,2]]]],
 [31167,[[4,[1,2]],[19,[1,2]],[21,[3]],[34,[1,2]],[49,[1,2]],[51,[3]],
     [64,[1,2]],[79,[1,2]],[81,[3]],[94,[1,2]]]],
 [31168,[[11,[1]],[18,[1]],[41,[1]],[48,[1]],[71,[1]],[78,[1]],
     [101,[1]],[108,[1]],[131,[1]],[138,[1]]]],
 [31169,[[5,[1,2]],[15,[1,2]],[21,[1,2]],[25,[1,2]],[35,[1,2]],
     [45,[1,2]],[51,[1,2]],[55,[1,2]],[65,[1,2]],[75,[1,2]]]],
 [31170,[[11,[1]],[18,[1]],[41,[1]],[48,[1]],[71,[1]],[78,[1]],
     [101,[1]],[108,[1]],[131,[1]],[138,[1]]]],
 [31171,[[3,[1,2]],[5,[1]],[9,[1]],[13,[1,2]],[16,[1]],[19,[1]],
     [21,[1,2]],[23,[3]],[29,[1]],[33,[1,2]]]],
 [31172,[[6,[1]],[21,[1]],[36,[1]],[51,[1]],[66,[1]],[81,[1]],[96,[1]],
     [111,[1]],[126,[1]],[141,[1]]]],
 [31173,[[11,[2]],[21,[1,2]],[41,[1,2]],[51,[2]],[71,[2]],[81,[1,2]],
     [101,[1,2]],[111,[2]],[131,[2]],[141,[1,2]]]],
 [31175,[[9,[1]],[11,[1]],[24,[1]],[39,[1]],[41,[1]],[54,[1]],[69,[1]],
     [71,[1]],[84,[1]],[99,[1]]]],
 [31176,[[3,[2,2,3]],[9,[1,1,2]],[18,[2,2,3]],[19,[1,1,2]],[21,[1]],
     [33,[2,2,3]],[39,[1,1,2]],[48,[2,2,3]],[49,[1,1,2]],[51,[1]]]],
 [31180,[[11,[2,3,2,4]],[15,[1]],[35,[2,3,2,4]],[41,[1]],[55,[1]],
     [71,[2,3,2,4]],[75,[2,3,2,4]],[95,[1]],[101,[1]],[115,[2,3,2,4]]]],
 [31186,[[11,[1]],[13,[1,2]],[33,[1]],[41,[1,2]],[53,[1,2]],[71,[1]],
     [73,[1]],[93,[1,2]],[101,[1,2]],[113,[1]]]],
 [31187,[[9,[1]],[21,[1,2]],[29,[1,2]],[49,[1]],[51,[1]],[69,[1,2]],
     [81,[1,2]],[89,[1]],[109,[1,2]],[111,[1]]]],
 [31201,[[11,[2,4]],[41,[2,4]],[71,[2,4]],[101,[2,4]],[131,[2,4]],
     [161,[2,4]],[191,[2,4]],[221,[2,4]],[251,[2,4]]]],
 [31220,[[4,[1,1,1,1,1,1,1,2]],[10,[1,1,1,1,1,1,1,2]],[16,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[28,[1,1,1,1,1,1,1,2]],[34,[1,1,1,1,1,1,1,2]],
     [40,[1,1,1,1,1,1,1,2]],[46,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [58,[1,1,1,1,1,1,1,2]]]],
 [31224,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31226,[[3,[1,1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,1,2]],[15,[1,2]],
     [21,[1,1,1,1,1,1,1,2]],[26,[1,1,1,1,1,1,1,2]],[33,[1,1,1,1,1,1,1,2]],
     [39,[1,1,1,1,1,1,1,2]],[45,[1,2]],[51,[1,1,1,1,1,1,1,2]],
     [56,[1,1,1,1,1,1,1,2]]]],
 [31227,[[11,[1]],[15,[1]],[41,[1]],[45,[1]],[71,[1]],[75,[1]],
     [101,[1]],[105,[1]],[131,[1]],[135,[1]]]],
 [31232,[[0,[1,2]],[21,[1,2]],[30,[1,2]],[51,[1,2]],[60,[1,2]],
     [81,[1,2]],[90,[1,2]],[111,[1,2]],[120,[1,2]],[141,[1,2]]]],
 [31245,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31247,[[5,[1]],[15,[1]],[21,[1]],[25,[1]],[35,[1]],[45,[1]],[51,[1]],
     [55,[1]],[65,[1]],[75,[1]]]],
 [31251,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [31255,[[10,[2,3,3]],[18,[2,3,3]],[40,[2,3,3]],[48,[2,3,3]],[70,[2,3,3]],
     [78,[2,3,3]],[100,[2,3,3]],[108,[2,3,3]],[130,[2,3,3]],[138,[2,3,3]] 
    ]],
 [31257,[[0,[3]],[21,[3]],[30,[3]],[51,[3]],[60,[3]],[81,[3]],[90,[3]],
     [111,[3]],[120,[3]],[141,[3]]]],[31271,[[3,fail]]],
 [31274,[[19,[2,2,2,3]],[49,[2,2,2,3]],[79,[2,2,2,3]],[109,[2,2,2,3]],
     [139,[2,2,2,3]],[169,[2,2,2,3]],[199,[2,2,2,3]],[229,[2,2,2,3]]]],
 [31275,[[3,[2,2,2,3]],[9,[2,2,2,3]],[15,[1,2]],[16,[1,2]],[21,[2,2,2,3]],
     [26,[2,2,2,3]],[33,[2,2,2,3]],[39,[2,2,2,3]],[45,[1,2]],[46,[1,2]] 
    ]],
 [31276,[[4,[1]],[15,[1]],[16,[1]],[19,[1]],[21,[1]],[34,[1]],[45,[1]],
     [46,[1]],[49,[1]],[51,[1]]]],[31285,[[10,fail]]],
 [31299,[[11,[2]],[41,[2]],[71,[2]],[101,[2]],[131,[2]],[161,[2]],
     [191,[2]],[221,[2]],[251,[2]]]],
 [31304,[[1,[1,2]],[18,[1,2]],[31,[1,2]],[48,[1,2]],[61,[1,2]],
     [78,[1,2]],[91,[1,2]],[108,[1,2]],[121,[1,2]],[138,[1,2]]]],
 [31321,[[5,[3]],[15,[4]],[21,[1]],[25,[3]],[35,[3]],[45,[4]],[51,[1]],
     [55,[3]],[65,[3]],[75,[4]]]],
 [31342,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31345,[[0,[1,1,1,1,2]],[11,[1,1,1,1,2]],[18,[1,1,1,1,2]],
     [20,[1,1,1,1,2]],[30,[1,1,1,1,2]],[41,[1,1,1,1,2]],[48,[1,1,1,1,2]],
     [50,[1,1,1,1,2]],[60,[1,1,1,1,2]],[71,[1,1,1,1,2]]]],
 [31346,[[6,[1,1,1,1,2]],[8,[1,1,1,1,2]],[11,[1,1,1,1,2]],[24,[1,1,1,1,2]],
     [36,[1,1,1,1,2]],[38,[1,1,1,1,2]],[41,[1,1,1,1,2]],[54,[1,1,1,1,2]],
     [66,[1,1,1,1,2]],[68,[1,1,1,1,2]]]],
 [31347,[[0,[3]],[18,[3]],[30,[3]],[48,[3]],[60,[3]],[78,[3]],[90,[3]],
     [108,[3]],[120,[3]],[138,[3]]]],
 [31361,[[15,[1]],[16,[1]],[45,[1]],[46,[1]],[75,[1]],[76,[1]],
     [105,[1]],[106,[1]],[135,[1]],[136,[1]]]],
 [31365,[[8,[2,2,3]],[10,[9,9,10]],[16,[4,5,5]],[38,[4,5,5]],[40,[2,2,3]],
     [46,[16,16,17]],[51,[2,2,3]],[68,[2,2,3]],[70,[4,5,5]],[76,[4,5,5]] 
    ]],
 [31366,[[8,[4]],[23,[2]],[28,[2]],[38,[4]],[53,[2]],[58,[2]],[68,[4]],
     [83,[2]],[88,[2]],[98,[4]]]],
 [31377,[[14,[1,1,2]],[40,[1]],[80,[1]],[100,[1,1,2]],[134,[1]],
     [140,[1,1,2]],[160,[1]],[220,[1,1,2]],[254,[1,1,2]]]],
 [31381,[[6,[1]],[36,[1]],[66,[1]],[96,[1]],[126,[1]],[156,[1]],
     [186,[1]],[216,[1]],[246,[1]]]],
 [31382,[[9,[1,1,2,1,2]],[24,[1,1,2,1,2]],[39,[1,1,2,1,2]],
     [54,[1,1,2,1,2]],[69,[1,1,2,1,2]],[84,[1,1,2,1,2]],[99,[1,1,2,1,2]],
     [114,[1,1,2,1,2]],[129,[1,1,2,1,2]],[144,[1,1,2,1,2]]]],
 [31384,[[0,[1,2,2,3]],[10,[1,2,2,3]],[20,[1,2,2,3]],[21,[1,2,2,3]],
     [30,[1,2,2,3]],[40,[1,2,2,3]],[50,[1,2,2,3]],[51,[1,2,2,3]],
     [60,[1,2,2,3]],[70,[1,2,2,3]]]],[31391,[[26,fail]]],
 [31395,[[26,fail]]],
 [31399,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31404,[[0,[1,2]],[15,[1,2]],[21,[1,2]],[30,[1,2]],[45,[1,2]],
     [51,[1,2]],[60,[1,2]],[75,[1,2]],[81,[1,2]],[90,[1,2]]]],
 [31417,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31418,[[3,[1,2]],[18,[1,2]],[33,[1,2]],[48,[1,2]],[63,[1,2]],
     [78,[1,2]],[93,[1,2]],[108,[1,2]],[123,[1,2]],[138,[1,2]]]],
 [31419,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31422,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31424,[[11,[1,1,2,2]],[41,[1,2]],[48,[1,1,2,2]],[101,[1,1,2,2]],
     [108,[1,1,2,2]],[131,[1,2]],[168,[1,1,2,2]],[191,[1,1,2,2]],
     [221,[1,2]],[228,[1,1,2,2]]]],
 [31426,[[11,[1]],[30,[1]],[71,[1]],[75,[1]],[120,[1]],[131,[1]],
     [165,[1]],[191,[1]],[210,[1]],[251,[1]]]],
 [31428,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31429,[[9,[2]],[21,[1]],[29,[3]],[49,[2]],[69,[3]],[81,[1]],[89,[2]],
     [109,[3]],[129,[2]],[141,[1]]]],
 [31430,[[11,[1]],[15,[1]],[45,[3]],[51,[2]],[75,[1]],[105,[2]],
     [111,[1]],[135,[1]],[165,[5]],[171,[4]]]],
 [31431,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31433,[[4,[1,2]],[21,[1,2]],[24,[1,2]],[51,[1,2]],[64,[1,2]],
     [81,[1,2]],[84,[1,2]],[111,[1,2]],[124,[1,2]],[141,[1,2]]]],
 [31437,[[1,[2]],[9,[2]],[15,[2]],[31,[2]],[39,[4]],[45,[2]],[61,[2]],
     [75,[4]],[91,[2]],[99,[2]]]],
 [31451,[[6,[4]],[8,[2]],[18,[2]],[28,[2]],[36,[4]],[38,[2]],[48,[2]],
     [58,[2]],[66,[4]],[68,[2]]]],
 [31454,[[19,[1,1,2]],[39,[1]],[79,[1]],[99,[1,1,2]],[139,[1,1,2]],
     [159,[1]],[199,[1]],[219,[1,1,2]]]],
 [31465,[[0,[1,2]],[8,[1,2]],[10,[1,2]],[11,[1,2]],[16,[1,2]],[18,[1,2]],
     [20,[1,2]],[28,[1,2]],[30,[1,2]],[38,[1,2]]]],
 [31466,[[0,[2,4]],[10,[2,4]],[20,[2,4]],[21,[2,4]],[30,[2,4]],
     [40,[2,4]],[50,[2,4]],[51,[2,4]],[60,[2,4]],[70,[2,4]]]],
 [31479,[[1,[1,2]],[4,[1,2]],[6,[1,2]],[8,[1,2]],[14,[1,2]],[18,[1,2]],
     [24,[1,2]],[28,[1,2]],[31,[1,2]],[34,[1,2]]]],[31488,[[4,fail]]],
 [31494,[[1,[1,1,1,2]],[14,[1,1,1,2]],[31,[1,1,1,2]],[34,[1,1,1,2]],
     [54,[1,1,1,2]],[61,[1,1,1,2]],[74,[1,1,1,2]],[91,[1,1,1,2]],
     [94,[1,1,1,2]],[114,[1,1,1,2]]]],
 [31501,[[0,[1,1,1,2]],[20,[1,1,1,2]],[21,[1,1,1,2]],[40,[1,1,1,2]],
     [51,[1,1,1,2]],[60,[1,1,1,2]],[80,[1,1,1,2]],[81,[1,1,1,2]],
     [100,[1,1,1,2]],[111,[1,1,1,2]]]],[31542,[[16,fail]]],
 [31545,[[21,fail]]],
 [31547,[[11,[1]],[16,[1]],[41,[1]],[46,[1]],[71,[1]],[76,[1]],
     [101,[1]],[106,[1]],[131,[1]],[136,[1]]]],
 [31551,[[16,[1]],[21,[1]],[46,[1]],[51,[1]],[76,[1]],[81,[1]],
     [106,[1]],[111,[1]],[136,[1]],[141,[1]]]],[31553,[[11,fail]]],
 [31565,[[16,fail]]],
 [31581,[[11,[1,1,2]],[41,[1,1,2]],[71,[1,1,2]],[101,[1,1,2]],
     [131,[1,1,2]],[161,[1,1,2]],[191,[1,1,2]],[221,[1,1,2]],
     [251,[1,1,2]]]],
 [31587,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [31588,[[16,[3]],[46,[3]],[76,[3]],[106,[3]],[136,[3]],[166,[3]],
     [196,[3]],[226,[3]]]],
 [31589,[[1,[1]],[16,[1]],[31,[1]],[46,[1]],[61,[1]],[76,[1]],[91,[1]],
     [106,[1]],[121,[1]],[136,[1]]]],
 [31590,[[1,[1,2]],[5,[1,2]],[15,[1,2]],[16,[1,2]],[21,[1,2]],[25,[1,2]],
     [31,[1,2]],[35,[1,2]],[45,[1,2]],[46,[1,2]]]],
 [31591,[[5,[1]],[6,[1]],[11,[2]],[15,[1]],[21,[2]],[25,[1]],[35,[1]],
     [36,[1]],[41,[2]],[45,[1]]]],
 [31596,[[0,[1,1,2,1,2]],[7,[1,1,2,1,2]],[11,[1,1,2,1,2]],[17,[1,1,2,1,2]],
     [26,[1,1,2,1,2]],[27,[1,1,2,1,2]],[31,[1,1,2,1,2]],[37,[1,1,2,1,2]],
     [41,[1,1,2,1,2]],[47,[1,1,2,1,2]]]],
 [31603,[[6,[1,1,2]],[36,[1,1,2]],[66,[1,1,2]],[96,[1,1,2]],[126,[1,1,2]],
     [156,[1,1,2]],[186,[1,1,2]],[216,[1,1,2]],[246,[1,1,2]]]],
 [31604,[[0,[1]],[6,[2]],[10,[1]],[20,[1]],[21,[1]],[26,[2]],[30,[1]],
     [36,[2]],[40,[1]],[50,[1]]]],
 [31606,[[6,[2,2,3]],[16,[2,2,3]],[36,[2,2,3]],[46,[2,2,3]],[66,[2,2,3]],
     [76,[2,2,3]],[96,[2,2,3]],[106,[2,2,3]],[126,[2,2,3]],[136,[2,2,3]] 
    ]],
 [31635,[[10,[3]],[40,[3]],[70,[3]],[100,[3]],[130,[3]],[160,[3]],
     [190,[3]],[220,[3]],[250,[3]]]],
 [31636,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [31639,[[0,[1,1,2]],[5,[1,2]],[9,[1,2]],[19,[1,2]],[20,[1,1,2]],
     [29,[1,2]],[30,[1,1,2]],[35,[1,2]],[39,[1,2]],[49,[1,2]]]],
 [31642,[[10,[1,2]],[25,[1,2]],[40,[1,2]],[55,[1,2]],[70,[1,2]],
     [85,[1,2]],[100,[1,2]],[115,[1,2]],[130,[1,2]],[145,[1,2]]]],
 [31644,[[10,[3,4]],[20,[3,4]],[40,[3,4]],[50,[3,4]],[70,[3,4]],
     [80,[3,4]],[100,[3,4]],[110,[3,4]],[130,[3,4]],[140,[3,4]]]],
 [31646,[[20,[2]],[50,[2]],[80,[2]],[110,[2]],[140,[2]],[170,[2]],
     [200,[2]],[230,[2]]]],
 [31648,[[15,[2]],[45,[2]],[75,[2]],[105,[2]],[135,[2]],[165,[2]],
     [195,[2]],[225,[2]],[255,[2]]]],
 [31652,[[4,[1,2]],[5,[1,1,2]],[14,[1,2]],[15,[1,1,2]],[20,[1,2]],
     [24,[1,2]],[34,[1,2]],[35,[1,1,2]],[44,[1,2]],[45,[1,1,2]]]],
 [31653,[[4,[1]],[5,[1]],[10,[1]],[14,[1]],[24,[1]],[25,[1]],[34,[1]],
     [35,[1]],[40,[1]],[44,[1]]]],
 [31654,[[0,[1,1,1,2,2]],[2,[1,1,1,2,2]],[12,[1,1,1,2,2]],[15,[1,1,1,2,2]],
     [22,[1,1,1,2,2]],[25,[1,1,1,2,2]],[30,[1,1,1,2,2]],[32,[1,1,1,2,2]],
     [42,[1,1,1,2,2]],[45,[1,1,1,2,2]]]],
 [31680,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [31682,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31683,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31693,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [31695,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [31696,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [31728,[[10,[3]],[40,[3]],[70,[3]],[100,[3]],[130,[3]],[160,[3]],
     [190,[3]],[220,[3]],[250,[3]]]],
 [31729,[[7,[1,2]],[22,[1,2]],[37,[1,2]],[52,[1,2]],[67,[1,2]],
     [82,[1,2]],[97,[1,2]],[112,[1,2]],[127,[1,2]],[142,[1,2]]]],
 [31732,[[0,[2]],[5,[1]],[9,[1]],[19,[1]],[20,[2]],[29,[1]],[30,[2]],
     [35,[1]],[39,[1]],[49,[1]]]],
 [31735,[[10,[1]],[25,[1]],[40,[1]],[55,[1]],[70,[1]],[85,[1]],
     [100,[1]],[115,[1]],[130,[1]],[145,[1]]]],
 [31737,[[10,[2,2,3]],[20,[2,2,3]],[40,[2,2,3]],[50,[2,2,3]],[70,[2,2,3]],
     [80,[2,2,3]],[100,[2,2,3]],[110,[2,2,3]],[130,[2,2,3]],[140,[2,2,3]] 
    ]],
 [31739,[[20,[1,1,2]],[50,[1,1,2]],[80,[1,1,2]],[110,[1,1,2]],
     [140,[1,1,2]],[170,[1,1,2]],[200,[1,1,2]],[230,[1,1,2]]]],
 [31741,[[15,[1,1,2]],[45,[1,1,2]],[75,[1,1,2]],[105,[1,1,2]],
     [135,[1,1,2]],[165,[1,1,2]],[195,[1,1,2]],[225,[1,1,2]],
     [255,[1,1,2]]]],
 [31745,[[4,[1]],[5,[2]],[14,[1]],[15,[2]],[20,[1]],[24,[1]],[34,[1]],
     [35,[2]],[44,[1]],[45,[2]]]],
 [31746,[[4,[1,2]],[5,[1,2]],[10,[1,2]],[14,[1,2]],[24,[1,2]],[25,[1,2]],
     [34,[1,2]],[35,[1,2]],[40,[1,2]],[44,[1,2]]]],
 [31747,[[0,[1,1,2,1,2]],[2,[1,1,2,1,2]],[12,[1,1,2,1,2]],[15,[1,1,2,1,2]],
     [22,[1,1,2,1,2]],[25,[1,1,2,1,2]],[30,[1,1,2,1,2]],[32,[1,1,2,1,2]],
     [42,[1,1,2,1,2]],[45,[1,1,2,1,2]]]],
 [31766,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],
 [31771,[[10,[1]],[40,[1]],[70,[1]],[100,[1]],[130,[1]],[160,[1]],
     [190,[1]],[220,[1]],[250,[1]]]],
 [31773,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [31774,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31787,[[5,[1]],[35,[1]],[65,[1]],[95,[1]],[125,[1]],[155,[1]],
     [185,[1]],[215,[1]],[245,[1]]]],
 [31788,[[15,[1]],[45,[1]],[75,[1]],[105,[1]],[135,[1]],[165,[1]],
     [195,[1]],[225,[1]],[255,[1]]]],
 [31817,[[10,[1,2]],[40,[1,2]],[70,[1,2]],[100,[1,2]],[130,[1,2]],
     [160,[1,2]],[190,[1,2]],[220,[1,2]],[250,[1,2]]]],
 [31818,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31820,[[9,[1]],[19,[1]],[39,[1]],[49,[1]],[69,[1]],[79,[1]],[99,[1]],
     [109,[1]],[129,[1]],[139,[1]]]],
 [31826,[[7,[1]],[27,[1]],[37,[1]],[57,[1]],[67,[1]],[87,[1]],[97,[1]],
     [117,[1]],[127,[1]],[147,[1]]]],[31848,[[6,fail]]],
 [31860,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [31874,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],[31886,[[11,fail]]],[31890,[[6,fail]]],
 [31895,[[1,[1,1,1,1,2,1,1,2]],[6,[1,1,1,1,2,1,1,2]],[14,[1]],
     [20,[1,1,1,1,2,1,1,2]],[26,[1,1,1,1,2,1,1,2]],[32,[1,1,1,1,2,1,1,2]],
     [36,[1,1,1,1,2,1,1,2]],[44,[1]],[50,[1,1,1,1,2,1,1,2]],
     [56,[1,1,1,1,2,1,1,2]]]],
 [31902,[[9,[1]],[39,[1]],[69,[1]],[99,[1]],[129,[1]],[159,[1]],
     [189,[1]],[219,[1]],[249,[1]]]],
 [31903,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [31904,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [31918,[[0,[1,1,1,1,1,1,2,2]],[6,[1,1,1,1,1,1,2,2]],[12,[1]],
     [16,[1,1,1,1,1,1,2,2]],[24,[1,1,1,1,1,1,2,2]],[30,[1,1,1,1,1,1,2,2]],
     [36,[1,1,1,1,1,1,2,2]],[42,[1]],[46,[1,1,1,1,1,1,2,2]],
     [54,[1,1,1,1,1,1,2,2]]]],
 [31941,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [31943,[[11,[1,2]],[16,[1]],[41,[1,2]],[46,[1]],[71,[1,2]],[76,[1]],
     [101,[1,2]],[106,[1]],[131,[1,2]],[136,[1]]]],
 [31944,[[11,[1]],[16,[1,2]],[41,[1]],[46,[1,2]],[71,[1]],[76,[1,2]],
     [101,[1]],[106,[1,2]],[131,[1]],[136,[1,2]]]],
 [31958,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],[31965,[[16,fail]]],
 [31968,[[11,fail]]],
 [31977,[[5,[1,1,1,1,1,1,2,2]],[11,[1,1,1,1,1,1,2,2]],[17,[1]],
     [21,[1,1,1,1,1,1,2,2]],[29,[1,1,1,1,1,1,2,2]],[35,[1,1,1,1,1,1,2,2]],
     [41,[1,1,1,1,1,1,2,2]],[47,[1]],[51,[1,1,1,1,1,1,2,2]],
     [59,[1,1,1,1,1,1,2,2]]]],
 [31983,[[1,[1,1,1,1,2,1,1,2]],[7,[1,1,1,1,2,1,1,2]],[11,[1]],
     [19,[1,1,1,1,2,1,1,2]],[25,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [37,[1,1,1,1,2,1,1,2]],[41,[1]],[49,[1,1,1,1,2,1,1,2]],
     [55,[1,1,1,1,2,1,1,2]]]],
 [31984,[[14,[1]],[44,[1]],[74,[1]],[104,[1]],[134,[1]],[164,[1]],
     [194,[1]],[224,[1]],[254,[1]]]],
 [31997,[[1,[1,1,1,1,2]],[21,[1,1,1,1,2]],[31,[1,1,1,1,2]],
     [51,[1,1,1,1,2]],[61,[1,1,1,1,2]],[81,[1,1,1,1,2]],[91,[1,1,1,1,2]],
     [111,[1,1,1,1,2]],[121,[1,1,1,1,2]],[141,[1,1,1,1,2]]]],
 [31998,[[1,[1,1,1,1,2]],[21,[1,1,1,1,2]],[31,[1,1,1,1,2]],
     [51,[1,1,1,1,2]],[61,[1,1,1,1,2]],[81,[1,1,1,1,2]],[91,[1,1,1,1,2]],
     [111,[1,1,1,1,2]],[121,[1,1,1,1,2]],[141,[1,1,1,1,2]]]],
 [32016,[[14,[1,1,2]],[44,[1,1,2]],[74,[1,1,2]],[104,[1,1,2]],
     [134,[1,1,2]],[164,[1,1,2]],[194,[1,1,2]],[224,[1,1,2]],
     [254,[1,1,2]]]],
 [32020,[[20,[1,2,2]],[50,[1,2,2]],[80,[1,2,2]],[110,[1,2,2]],
     [140,[1,2,2]],[170,[1,2,2]],[200,[1,2,2]],[230,[1,2,2]]]],
 [32022,[[4,[1,2]],[19,[1,2]],[34,[1,2]],[49,[1,2]],[64,[1,2]],
     [79,[1,2]],[94,[1,2]],[109,[1,2]],[124,[1,2]],[139,[1,2]]]],
 [32023,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [32024,[[4,[1]],[19,[1]],[34,[1]],[49,[1]],[64,[1]],[79,[1]],[94,[1]],
     [109,[1]],[124,[1]],[139,[1]]]],
 [32026,[[9,[1]],[19,[1]],[39,[1]],[49,[1]],[69,[1]],[79,[1]],[99,[1]],
     [109,[1]],[129,[1]],[139,[1]]]],
 [32031,[[0,[1,1,1,2]],[20,[1,1,1,2]],[31,[1,1,1,2]],[50,[1,1,1,2]],
     [61,[1,1,1,2]],[80,[1,1,1,2]],[91,[1,1,1,2]],[110,[1,1,1,2]],
     [121,[1,1,1,2]],[140,[1,1,1,2]]]],
 [32035,[[20,[1]],[50,[1]],[80,[1]],[110,[1]],[140,[1]],[170,[1]],
     [200,[1]],[230,[1]]]],[32045,[[16,fail]]],
 [32055,[[17,[1]],[47,[1]],[77,[1]],[107,[1]],[137,[1]],[167,[1]],
     [197,[1]],[227,[1]]]],
 [32056,[[6,[1,1,1,1,2]],[26,[1,1,1,1,2]],[36,[1,1,1,1,2]],
     [56,[1,1,1,1,2]],[66,[1,1,1,1,2]],[86,[1,1,1,1,2]],[96,[1,1,1,1,2]],
     [116,[1,1,1,1,2]],[126,[1,1,1,1,2]],[146,[1,1,1,1,2]]]],
 [32058,[[6,[1,2]],[26,[1,2]],[36,[1,2]],[56,[1,2]],[66,[1,2]],
     [86,[1,2]],[96,[1,2]],[116,[1,2]],[126,[1,2]],[146,[1,2]]]],
 [32060,[[11,[2,3]],[16,[1]],[17,[1]],[41,[2,3]],[46,[1]],[47,[1]],
     [71,[2,3]],[76,[1]],[77,[1]],[101,[2,3]]]],
 [32061,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32073,[[6,[2,3,4]],[26,[2,3,4]],[36,[2,3,4]],[56,[2,3,4]],[66,[2,3,4]],
     [86,[2,3,4]],[96,[2,3,4]],[116,[2,3,4]],[126,[2,3,4]],[146,[2,3,4]] 
    ]],
 [32076,[[0,[2,2,3,3]],[6,[2,2,3,3]],[12,[1]],[14,[1]],[16,[2,2,3,3]],
     [24,[2,2,3,3]],[30,[2,2,3,3]],[36,[2,2,3,3]],[42,[1]],[44,[1]]]],
 [32078,[[16,fail]]],
 [32081,[[6,[1,1,1,2,2,2,1,2]],[11,[2,3,3,4,3,3,3,3]],[17,[1,1,1,2,2,2,1,2]]
      ,[19,[1,1,1,2,2,2,1,2]],[35,[1,1,1,2,2,2,1,2]],[41,[3]],
     [47,[2,4,3,3]],[55,[1,1,1,2,2,2,1,2]],[59,[1,1,1,2,2,2,1,2]],
     [67,[1,1,1,2,2,2,1,2]]]],
 [32085,[[11,[1]],[41,[2]],[71,[1]],[101,[2]],[131,[1]],[161,[2]],
     [191,[1]],[221,[2]],[251,[1]]]],
 [32098,[[5,[1]],[6,[1]],[20,[1]],[25,[1]],[35,[1]],[36,[1]],[50,[1]],
     [55,[1]],[65,[1]],[66,[1]]]],
 [32105,[[6,[1]],[36,[1]],[66,[1]],[96,[1]],[126,[1]],[156,[1]],
     [186,[1]],[216,[1]],[246,[1]]]],
 [32109,[[6,[1,1,2]],[36,[1,1,2]],[66,[1,1,2]],[96,[1,1,2]],[126,[1,1,2]],
     [156,[1,1,2]],[186,[1,1,2]],[216,[1,1,2]],[246,[1,1,2]]]],
 [32111,[[1,[2,3,4]],[21,[2,3,4]],[31,[2,3,4]],[51,[2,3,4]],[61,[2,3,4]],
     [81,[2,3,4]],[91,[2,3,4]],[111,[2,3,4]],[121,[2,3,4]],[141,[2,3,4]] 
    ]],
 [32115,[[6,[3,3,4]],[14,[1,2,2]],[29,[1,2,2]],[36,[3,3,4]],[44,[1,2,2]],
     [59,[1,2,2]],[66,[3,3,4]],[74,[1,2,2]],[89,[1,2,2]],[96,[3,3,4]]]],
 [32120,[[2,[1,1,1,1,1,2,2,2]],[6,[3,3,3,3,3,4,4,4]],[14,[2,2,2,2,2,4,4,4]],
     [30,[1,1,1,1,1,2,2,2]],[36,[4]],[42,[1,1,1,1,1,2,2,2]],
     [44,[1,1,1,1,1,2,2,2]],[50,[1,1,1,1,1,2,2,2]],[54,[1,1,1,1,1,2,2,2]],
     [62,[1,1,1,1,1,2,2,2]]]],
 [32128,[[6,[3,3,4]],[36,[6,7,7]],[66,[3,3,4]],[96,[6,7,7]],[126,[3,3,4]],
     [156,[6,7,7]],[186,[3,3,4]],[216,[6,7,7]],[246,[3,3,4]]]],
 [32134,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],[32154,[[21,fail]]],
 [32157,[[16,fail]]],
 [32166,[[6,[1,1,1,1,2]],[26,[1,1,1,1,2]],[36,[1,1,1,1,2]],
     [56,[1,1,1,1,2]],[66,[1,1,1,1,2]],[86,[1,1,1,1,2]],[96,[1,1,1,1,2]],
     [116,[1,1,1,1,2]],[126,[1,1,1,1,2]],[146,[1,1,1,1,2]]]],
 [32168,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32169,[[4,[1,1,1,1,2,1,1,2]],[10,[1,1,1,1,2,1,1,2]],[16,[1]],
     [22,[1,1,1,1,2,1,1,2]],[26,[1,1,1,1,2,1,1,2]],[34,[1,1,1,1,2,1,1,2]],
     [40,[1,1,1,1,2,1,1,2]],[46,[1]],[52,[1,1,1,1,2,1,1,2]],
     [56,[1,1,1,1,2,1,1,2]]]],
 [32181,[[0,[1,1,1,1,1,1,2,2]],[6,[1,1,1,1,1,1,2,2]],[12,[1]],
     [16,[1,1,1,1,1,1,2,2]],[24,[1,1,1,1,1,1,2,2]],[30,[1,1,1,1,1,1,2,2]],
     [36,[1,1,1,1,1,1,2,2]],[42,[1]],[46,[1,1,1,1,1,1,2,2]],
     [54,[1,1,1,1,1,1,2,2]]]],
 [32202,[[11,[2]],[41,[2]],[71,[2]],[101,[2]],[131,[2]],[161,[2]],
     [191,[2]],[221,[2]],[251,[2]]]],
 [32203,[[11,[2]],[41,[2]],[71,[2]],[101,[2]],[131,[2]],[161,[2]],
     [191,[2]],[221,[2]],[251,[2]]]],
 [32213,[[25,[1]],[55,[1]],[85,[1]],[115,[1]],[145,[1]],[175,[1]],
     [205,[1]],[235,[1]]]],
 [32218,[[1,[1]],[31,[1]],[61,[1]],[91,[1]],[121,[1]],[151,[1]],
     [181,[1]],[211,[1]],[241,[1]]]],[32222,[[21,fail]]],[32231,[[6,fail]]],
 [32236,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32239,[[6,[1]],[9,[1]],[21,[1]],[29,[1]],[36,[1]],[39,[1]],[51,[1]],
     [59,[1]],[66,[1]],[69,[1]]]],
 [32242,[[4,[1,1,1,1,2]],[21,[1,1,1,1,2]],[26,[1,1,1,1,2]],
     [34,[1,1,1,1,2]],[51,[1,1,1,1,2]],[56,[1,1,1,1,2]],[64,[1,1,1,1,2]],
     [81,[1,1,1,1,2]],[86,[1,1,1,1,2]],[94,[1,1,1,1,2]]]],
 [32244,[[0,[2,2,3]],[17,[2,2,3]],[21,[4,5,5]],[32,[2,2,3]],[47,[2,2,3]],
     [51,[4,5,5]],[62,[2,2,3]],[77,[2,2,3]],[81,[4,5,5]],[92,[2,2,3]]]],
 [32247,[[16,[1,1,1,2]],[46,[1,1,1,2]],[76,[1,1,1,2]],[106,[1,1,1,2]],
     [136,[1,1,1,2]],[166,[1,1,1,2]],[196,[1,1,1,2]],[226,[1,1,1,2]]]],
 [32251,[[1,[1,1,1,1,1,1,2]],[9,[1,1,1,1,1,1,2]],[24,[1,1,1,1,1,1,2]],
     [32,[1,1,1,1,1,1,2]],[39,[1,1,1,1,1,1,2]],[54,[1,1,1,1,1,1,2]],
     [62,[1,1,1,1,1,1,2]],[69,[1,1,1,1,1,1,2]],[84,[1,1,1,1,1,1,2]],
     [92,[1,1,1,1,1,1,2]]]],
 [32256,[[21,[2]],[51,[1]],[81,[2]],[111,[1]],[141,[2]],[171,[1]],
     [201,[2]],[231,[1]]]],
 [32260,[[5,[1,1,1,2,2,2,1,2]],[9,[1,1,1,2,2,2,1,2]],[17,[2,4,3,3]],
     [21,[3]],[29,[1,1,1,2,2,2,1,2]],[45,[1,1,1,2,2,2,1,2]],
     [47,[1,1,1,2,2,2,1,2]],[51,[2,3,3,4,3,3,3,3]],[57,[1,1,1,2,2,2,1,2]],
     [65,[1,1,1,2,2,2,1,2]]]],
 [32267,[[7,[1]],[37,[1]],[67,[1]],[97,[1]],[127,[1]],[157,[1]],
     [187,[1]],[217,[1]],[247,[1]]]],
 [32268,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32299,[[11,[1,2]],[16,[1,2]],[41,[1,2]],[46,[1,2]],[71,[1,2]],
     [76,[1,2]],[101,[1,2]],[106,[1,2]],[131,[1,2]],[136,[1,2]]]],
 [32300,[[4,[1,2]],[19,[1,2]],[34,[1,2]],[49,[1,2]],[64,[1,2]],
     [79,[1,2]],[94,[1,2]],[109,[1,2]],[124,[1,2]],[139,[1,2]]]],
 [32302,[[9,[1,2,2,3]],[29,[1,2]],[49,[1,2,2,3]],[69,[1,2,2,3]],
     [89,[1,2]],[109,[1,2,2,3]],[129,[1,2,2,3]],[149,[1,2]],
     [169,[1,2,2,3]],[189,[1,2,2,3]]]],
 [32303,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32304,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32305,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32306,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32307,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32308,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32309,[[11,[3]],[41,[3]],[71,[3]],[101,[3]],[131,[3]],[161,[3]],
     [191,[3]],[221,[3]],[251,[3]]]],
 [32310,[[4,[1]],[19,[1]],[34,[1]],[49,[1]],[64,[1]],[79,[1]],[94,[1]],
     [109,[1]],[124,[1]],[139,[1]]]],
 [32311,[[4,[1]],[9,[1]],[21,[1]],[24,[1]],[34,[1]],[39,[1]],[51,[1]],
     [54,[1]],[64,[1]],[69,[1]]]],
 [32312,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32313,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32314,[[1,[1]],[16,[1]],[31,[1]],[46,[1]],[61,[1]],[76,[1]],[91,[1]],
     [106,[1]],[121,[1]],[136,[1]]]],
 [32316,[[11,[2,3]],[41,[2,3]],[71,[2,3]],[101,[2,3]],[131,[2,3]],
     [161,[2,3]],[191,[2,3]],[221,[2,3]],[251,[2,3]]]],
 [32317,[[1,[2,3]],[12,[2,3]],[16,[2,3]],[22,[2,3]],[31,[2,3]],
     [42,[2,3]],[46,[2,3]],[52,[2,3]],[61,[2,3]],[72,[2,3]]]],
 [32318,[[11,[1,2,2,3]],[41,[1,2]],[71,[1,2,2,3]],[101,[1,2,2,3]],
     [131,[1,2]],[161,[1,2,2,3]],[191,[1,2,2,3]],[221,[1,2]],
     [251,[1,2,2,3]]]],
 [32320,[[11,[1,2]],[22,[1]],[41,[1,2]],[42,[1]],[71,[1,2]],[82,[1]],
     [101,[1,2]],[102,[1]],[131,[1,2]],[142,[1]]]],
 [32324,[[11,[1,2,2,2]],[41,[1,2]],[71,[1,2,2,2]],[101,[1,2,2,2]],
     [131,[1,2]],[161,[1,2,2,2]],[191,[1,2,2,2]],[221,[1,2]],
     [251,[1,2,2,2]]]],
 [32325,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32326,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32328,[[11,[1,2]],[41,[1,2]],[71,[1,2]],[101,[1,2]],[131,[1,2]],
     [161,[1,2]],[191,[1,2]],[221,[1,2]],[251,[1,2]]]],
 [32329,[[4,[1,2]],[22,[1,2]],[24,[1,2]],[52,[1,2]],[64,[1,2]],
     [82,[1,2]],[84,[1,2]],[112,[1,2]],[124,[1,2]],[142,[1,2]]]],
 [32330,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32331,[[16,[2,3]],[46,[2,3]],[76,[2,3]],[106,[2,3]],[136,[2,3]],
     [166,[2,3]],[196,[2,3]],[226,[2,3]]]],
 [32333,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32334,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [32335,[[10,[1,2]],[25,[1,2]],[40,[1,2]],[55,[1,2]],[70,[1,2]],
     [85,[1,2]],[100,[1,2]],[115,[1,2]],[130,[1,2]],[145,[1,2]]]],
 [32336,[[10,[1,2]],[25,[1,2]],[40,[1,2]],[55,[1,2]],[70,[1,2]],
     [85,[1,2]],[100,[1,2]],[115,[1,2]],[130,[1,2]],[145,[1,2]]]],
 [32337,[[7,[2,3]],[11,[2,3]],[17,[2,3]],[26,[2,3]],[37,[2,3]],
     [41,[2,3]],[47,[2,3]],[56,[2,3]],[67,[2,3]],[71,[2,3]]]],
 [32338,[[12,[1]],[42,[1]],[72,[1]],[102,[1]],[132,[1]],[162,[1]],
     [192,[1]],[222,[1]],[252,[1]]]],
 [32339,[[11,[1]],[26,[1]],[41,[1]],[56,[1]],[71,[1]],[86,[1]],
     [101,[1]],[116,[1]],[131,[1]],[146,[1]]]],
 [32340,[[10,[1]],[25,[1]],[40,[1]],[55,[1]],[70,[1]],[85,[1]],
     [100,[1]],[115,[1]],[130,[1]],[145,[1]]]],
 [32342,[[11,[1]],[12,[1]],[16,[2,3]],[41,[1]],[42,[1]],[46,[2,3]],
     [71,[1]],[72,[1]],[76,[2,3]],[101,[1]]]],
 [32344,[[16,[3]],[46,[3]],[76,[3]],[106,[3]],[136,[3]],[166,[3]],
     [196,[3]],[226,[3]]]],
 [32345,[[10,[1,2,2,3]],[30,[1,2]],[50,[1,2,2,3]],[70,[1,2,2,3]],
     [90,[1,2]],[110,[1,2,2,3]],[130,[1,2,2,3]],[150,[1,2]],
     [170,[1,2,2,3]],[190,[1,2,2,3]]]],
 [32347,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [32349,[[16,[1,2]],[46,[1,2]],[76,[1,2]],[106,[1,2]],[136,[1,2]],
     [166,[1,2]],[196,[1,2]],[226,[1,2]]]],
 [32351,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [32352,[[16,[1,2,2,2]],[46,[1,2]],[76,[1,2,2,2]],[106,[1,2,2,2]],
     [136,[1,2]],[166,[1,2,2,2]],[196,[1,2,2,2]],[226,[1,2]]]],
 [32353,[[16,[1,2]],[17,[1]],[37,[1]],[46,[1,2]],[76,[1,2]],[77,[1]],
     [97,[1]],[106,[1,2]],[136,[1,2]],[137,[1]]]],
 [32356,[[6,[1,2]],[35,[1,2]],[37,[1,2]],[55,[1,2]],[67,[1,2]],
     [95,[1,2]],[97,[1,2]],[115,[1,2]],[127,[1,2]],[155,[1,2]]]],
 [32357,[[16,[1,2,2,3]],[46,[1,2]],[76,[1,2,2,3]],[106,[1,2,2,3]],
     [136,[1,2]],[166,[1,2,2,3]],[196,[1,2,2,3]],[226,[1,2]]]],
 [32358,[[37,[1,2]],[101,[1,2]],[130,[1,2]],[131,[1,2]]]],
 [32359,[[16,[1]],[46,[1]],[76,[1]],[106,[1]],[136,[1]],[166,[1]],
     [196,[1]],[226,[1]]]],
 [32360,[[4,[1]],[9,[1]],[19,[2]],[34,[1]],[39,[1]],[49,[2]],[64,[1]],
     [69,[1]],[79,[2]],[94,[1]]]],
 [32372,[[1,[1,1,1,1,2]],[6,[1,1,1,1,2]],[25,[1,1,1,1,2]],[31,[1,1,1,1,2]],
     [36,[1,1,1,1,2]],[55,[1,1,1,1,2]],[61,[1,1,1,1,2]],[66,[1,1,1,1,2]],
     [85,[1,1,1,1,2]],[91,[1,1,1,1,2]]]],
 [32377,[[1,[1,1,1,1,2,1,2,3]],[7,[1,1,1,1,2,1,2,3]],[15,[1,1,1,1,2,1,2,3]],
     [19,[2,3,2,3,3,3,3,5]],[25,[1,1,1,1,2,1,2,3]],[27,[1,1,1,1,2,1,2,3]],
     [31,[1,1,1,1,2,1,2,3]],[39,[1,2]],[49,[1,1,1,1,2,1,2,3]],
     [55,[2,3,4,3]]]],
 [32378,[[19,[1]],[39,[1]],[79,[1]],[99,[1]],[139,[1]],[159,[1]],
     [199,[1]],[219,[1]]]],
 [32385,[[15,[1]],[55,[1]],[75,[1]],[115,[1]],[135,[1]],[175,[1]],
     [195,[1]],[235,[1]],[255,[1]]]],
 [32397,[[1,[1,1,1,2]],[16,[1,1,1,2]],[31,[1,1,1,2]],[46,[1,1,1,2]],
     [61,[1,1,1,2]],[76,[1,1,1,2]],[91,[1,1,1,2]],[106,[1,1,1,2]],
     [121,[1,1,1,2]],[136,[1,1,1,2]]]],
 [32398,[[0,[1,2,2]],[15,[1,2,2]],[21,[2,4,4]],[30,[1,2,2]],[45,[1,2,2]],
     [51,[2,4,4]],[60,[1,2,2]],[75,[1,2,2]],[81,[2,4,4]],[90,[1,2,2]]]],
 [32399,[[35,fail]]],
 [32405,[[9,[1]],[29,[1]],[49,[1]],[69,[1]],[89,[1]],[109,[1]],
     [129,[1]],[149,[1]],[169,[1]],[189,[1]]]],
 [32433,[[9,[1]],[29,[1]],[49,[1]],[69,[1]],[89,[1]],[109,[1]],
     [129,[1]],[149,[1]],[169,[1]],[189,[1]]]],
 [32440,[[5,[1]],[25,[1]],[45,[1]],[65,[1]],[85,[1]],[105,[1]],
     [125,[1]],[145,[1]],[165,[1]],[185,[1]]]],
 [32456,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [32457,[[2,[1]],[22,[1]],[32,[1]],[52,[1]],[62,[1]],[82,[1]],[92,[1]],
     [112,[1]],[122,[1]],[142,[1]]]],[32466,[[21,fail]]],
 [32470,[[11,[1]],[41,[1]],[71,[1]],[101,[1]],[131,[1]],[161,[1]],
     [191,[1]],[221,[1]],[251,[1]]]],
 [32474,[[5,[1,1,1,1,1,1,2,2]],[11,[1,1,1,1,1,1,2,2]],[17,[1]],
     [21,[1,1,1,1,1,1,2,2]],[29,[1,1,1,1,1,1,2,2]],[35,[1,1,1,1,1,1,2,2]],
     [41,[1,1,1,1,1,1,2,2]],[47,[1]],[51,[1,1,1,1,1,1,2,2]],
     [59,[1,1,1,1,1,1,2,2]]]],
 [32477,[[1,[1,1,1,1,2,1,1,2]],[9,[1,1,1,1,2,1,1,2]],[15,[1]],
     [21,[1,1,1,1,2,1,1,2]],[27,[1,1,1,1,2,1,1,2]],[31,[1,1,1,1,2,1,1,2]],
     [39,[1,1,1,1,2,1,1,2]],[45,[1]],[51,[1,1,1,1,2,1,1,2]],
     [57,[1,1,1,1,2,1,1,2]]]],
 [32495,[[10,[1]],[25,[1]],[40,[1]],[55,[1]],[70,[1]],[85,[1]],
     [100,[1]],[115,[1]],[130,[1]],[145,[1]]]],
 [32505,[[10,[2]],[20,[1]],[25,[1]],[40,[2]],[50,[1]],[55,[1]],[70,[2]],
     [80,[1]],[85,[1]],[100,[2]]]],
 [32516,[[4,[2,3,4,3]],[10,[1,1,1,1,2,1,2,3]],[20,[1,2]],
     [26,[1,1,1,1,2,1,2,3]],[32,[1,1,1,1,2,1,2,3]],[34,[1,1,1,1,2,1,2,3]],
     [40,[2,3,2,3,3,3,3,5]],[44,[1,1,1,1,2,1,2,3]],[52,[1,1,1,1,2,1,2,3]],
     [56,[1,1,1,1,2,1,2,3]]]],
 [32517,[[20,[1]],[40,[1]],[80,[1]],[100,[1]],[140,[1]],[160,[1]],
     [200,[1]],[220,[1]]]],
 [32518,[[4,[1]],[44,[1]],[64,[1]],[104,[1]],[124,[1]],[164,[1]],
     [184,[1]],[224,[1]],[244,[1]]]],
 [32523,[[12,[1,1,2]],[42,[1,1,2]],[72,[1,1,2]],[102,[1,1,2]],
     [132,[1,1,2]],[162,[1,1,2]],[192,[1,1,2]],[222,[1,1,2]],
     [252,[1,1,2]]]],
 [32525,[[6,[1,2,2]],[36,[1,2,2]],[66,[1,2,2]],[96,[1,2,2]],[126,[1,2,2]],
     [156,[1,2,2]],[186,[1,2,2]],[216,[1,2,2]],[246,[1,2,2]]]],
 [32527,[[10,[1]],[20,[1]],[40,[1]],[50,[1]],[70,[1]],[80,[1]],
     [100,[1]],[110,[1]],[130,[1]],[140,[1]]]],
 [32529,[[6,[1,1,1,2]],[26,[1,1,1,2]],[36,[1,1,1,2]],[56,[1,1,1,2]],
     [66,[1,1,1,2]],[86,[1,1,1,2]],[96,[1,1,1,2]],[116,[1,1,1,2]],
     [126,[1,1,1,2]],[146,[1,1,1,2]]]],[32537,[[11,fail]]],
 [32587,[[1,[2,2,3,3]],[9,[2,2,3,3]],[15,[1]],[17,[1]],[21,[2,2,3,3]],
     [27,[2,2,3,3]],[31,[2,2,3,3]],[39,[2,2,3,3]],[45,[1]],[47,[1]]]],
 [32588,[[5,[1,1,1,1,1,1,2]],[20,[1,1,1,1,1,1,2]],[27,[1,1,1,1,1,1,2]],
     [35,[1,1,1,1,1,1,2]],[50,[1,1,1,1,1,1,2]],[57,[1,1,1,1,1,1,2]],
     [65,[1,1,1,1,1,1,2]],[80,[1,1,1,1,1,1,2]],[87,[1,1,1,1,1,1,2]],
     [95,[1,1,1,1,1,1,2]]]],
 [32596,[[0,[1,1,2,1,1,2,3,2]],[10,[1]],[14,[1,1,2,1,1,2,3,2]],
     [20,[1,1,2,1,1,2,3,2]],[22,[1,1,2,1,1,2,3,2]],[26,[2,3,3,4,4,4,3,3]],
     [34,[1,1,2,1,1,2,3,2]],[50,[2,2,3,2,2,3,4,3]],[56,[2,2,4,4,3,3,4,4]],