# YangBaxter, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST( "yangbaxter02.tst");

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:18-22
gap> rg := SmallRing(8,10);;
gap> StructureDescription(AdditiveGroupOfRing(rg));
"C4 x C2"

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:35-42
gap> rg := SmallRing(8,11);;
gap> IsJacobsonRadical(rg);
true
gap> rg := SmallRing(8,20);;
gap> IsJacobsonRadical(rg);
false

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:61-71
gap> cs := SmallCycleSet(4,13);;
gap> yb := CycleSet2YB(cs);;
gap> Permutations(yb);
[ [ (3,4), (1,3,2,4), (1,4,2,3), (1,2) ], 
  [ (2,4), (1,4,3,2), (1,2,3,4), (1,3) ] ]
gap> Evaluate(yb, [1,2]);
[ 2, 4 ]
gap> Evaluate(yb, [1,3]); 
[ 4, 2 ]

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:87-92
gap> yb := LyubashenkoYB(4, (1,2),(3,4));
<A set-theoretical solution of size 4>
gap> Permutations(last);
[ [ (1,2), (1,2), (1,2), (1,2) ], [ (3,4), (3,4), (3,4), (3,4) ] ]

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:104-113
gap> cs := SmallCycleSet(4,13);;
gap> yb := CycleSet2YB(cs);;
gap> DehornoyClass(yb);
2
gap> cs := SmallCycleSet(4,19);;
gap> yb := CycleSet2YB(cs);;
gap> DehornoyClass(yb);
4

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:126-151
gap> cs := SmallCycleSet(4,13);;
gap> yb := CycleSet2YB(cs);;
gap> Permutations(yb);
[ [ (3,4), (1,3,2,4), (1,4,2,3), (1,2) ], 
  [ (2,4), (1,4,3,2), (1,2,3,4), (1,3) ] ]
gap> field := FunctionField(Rationals, 1);;
gap> q := IndeterminatesOfFunctionField(field)[1];;
gap> G := DehornoyRepresentationOfStructureGroup(yb, q);;
gap> x1 := G.1;;
gap> x2 := G.2;;
gap> x3 := G.3;;
gap> x4 := G.4;;
gap> x1*x2=x2*x4;
true
gap> x1*x3=x4*x2;
true
gap> x1*x4=x3*x3;
true
gap> x2*x1=x3*x4;
true
gap> x2*x2=x4*x1;
true
gap> x3*x1=x4*x3;
true

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:164-172
gap> cs := SmallCycleSet(5,10);;
gap> IdCycleSet(cs);
[ 5, 10 ]
gap> cs := SmallCycleSet(4,3);;
gap> yb := CycleSet2YB(cs);;
gap> IdYB(yb);
[ 4, 3 ]

# doc/_Chapter_Algebraic_Properties_of_Braces.xml:193-204
gap> yb := SmallIYB(5,86);;
gap> gr := LinearRepresentationOfStructureGroup(yb);;
gap> gens := GeneratorsOfGroup(gr);;
gap> Display(gens[1]);
[ [  0,  1,  0,  0,  0,  1 ],
  [  1,  0,  0,  0,  0,  0 ],
  [  0,  0,  0,  0,  1,  0 ],
  [  0,  0,  1,  0,  0,  0 ],
  [  0,  0,  0,  1,  0,  0 ],
  [  0,  0,  0,  0,  0,  1 ] ]
gap> STOP_TEST("yangbaxter02.tst", 1 );
