# gap> LoadPackage( "ToricVarieties" );
# true
# gap> sigma := Cone( [[ 15,-1 ],[0,1]] );
# <A cone in |R^2>
# gap> C15 := ToricVariety( sigma );
# polymake: used package cddlib
#   Implementation of the double description method of Motzkin et al.
#   Copyright by Komei Fukuda.
#   http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html
# 
# <An affine normal toric variety of dimension 2>
# gap> TorusInvariantDivisorGroup(C15);
# <A free left module of rank 2 on free generators>
# gap> ClassGroup(C15);
# <A left module presented by 2 relations for 2 generators>
# gap> Display(ByASmallerPresentation(last));
# Z/< 15 > 
# gap> PicardGroup(C15);
# <A zero left module>
# gap> CartierTorusInvariantDivisorGroup(C15);
# <A free left submodule given by 2 generators>
# gap> Display(last);
# [ [  15,   0 ],
#   [  -1,   1 ] ]
# 
# A left submodule generated by the 2 rows of the above matrix
# gap> ImageSubobject(MapFromCharacterToPrincipalDivisor(C15));
# <A free left submodule given by 2 generators>
# gap> Display(last);
# [ [  15,   0 ],
#   [  -1,   1 ] ]
# 
# A left submodule generated by the 2 rows of the above matrix
# gap> IsSmooth(C15);
# false


LoadPackage( "ToricVarieties" );
sigma := Cone( [[ 15,-1 ],[0,1]] );
C15 := ToricVariety( sigma );
TorusInvariantDivisorGroup(C15);
ClassGroup(C15);
Display(ByASmallerPresentation(last));
PicardGroup(C15);
CartierTorusInvariantDivisorGroup(C15);
Display(last);
ImageSubobject(MapFromCharacterToPrincipalDivisor(C15));
Display(last);
IsSmooth(C15);