/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.concurrency;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public final class RunnableErrorForwarder {
    private final Thread thread = Thread.currentThread();
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicReference<Throwable> error = new AtomicReference();

    public Runnable wrap(final Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable cannot be null");
        this.counter.incrementAndGet();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Error | RuntimeException e2) {
                    RunnableErrorForwarder.this.error.compareAndSet(null, e2);
                    throw e2;
                }
                finally {
                    RunnableErrorForwarder.this.counter.decrementAndGet();
                    LockSupport.unpark(RunnableErrorForwarder.this.thread);
                }
            }
        };
    }

    public void await() {
        this.awaitTerminationOfAllRunnables();
        Throwable error2 = this.error.get();
        if (error2 != null) {
            if (error2 instanceof RuntimeException) {
                throw (RuntimeException)error2;
            }
            if (error2 instanceof ThreadDeath) {
                throw new IllegalStateException(error2);
            }
            if (error2 instanceof Error) {
                throw (Error)error2;
            }
            throw new IllegalStateException(error2);
        }
    }

    private void awaitTerminationOfAllRunnables() {
        if (!this.thread.equals(Thread.currentThread())) {
            throw new IllegalStateException("wrong caller thread, expected " + this.thread + " and not " + Thread.currentThread());
        }
        boolean interrupted = false;
        while (this.counter.get() > 0) {
            LockSupport.park();
            if (!Thread.interrupted()) continue;
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

