/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    public static String read(File checksumFile) throws IOException {
        String checksum;
        block16: {
            checksum = "";
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(checksumFile), StandardCharsets.UTF_8), 512);){
                String line;
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block16;
                } while ((line = line.trim()).length() <= 0);
                checksum = line;
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        return ChecksumUtils.calc(new FileInputStream(dataFile), algos);
    }

    public static Map<String, Object> calc(byte[] dataBytes, Collection<String> algos) throws IOException {
        return ChecksumUtils.calc(new ByteArrayInputStream(dataBytes), algos);
    }

    private static Map<String, Object> calc(InputStream data2, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String string2 : algos) {
            try {
                digests.put(string2, MessageDigest.getInstance(string2));
            }
            catch (NoSuchAlgorithmException e2) {
                results.put(string2, e2);
            }
        }
        Throwable throwable = null;
        try (InputStream in = data2;){
            int read2;
            byte[] buffer2 = new byte[32768];
            block12: while ((read2 = in.read(buffer2)) >= 0) {
                Iterator iterator = digests.values().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block12;
                    MessageDigest digest = (MessageDigest)iterator.next();
                    digest.update(buffer2, 0, read2);
                }
                break;
            }
        }
        catch (Throwable buffer2) {
            Throwable throwable2 = buffer2;
            throw buffer2;
        }
        for (Map.Entry entry : digests.entrySet()) {
            byte[] bytes2 = ((MessageDigest)entry.getValue()).digest();
            results.put((String)entry.getKey(), ChecksumUtils.toHexString(bytes2));
        }
        return results;
    }

    public static String toHexString(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        StringBuilder buffer2 = new StringBuilder(bytes2.length * 2);
        for (byte aByte : bytes2) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer2.append('0');
            }
            buffer2.append(Integer.toHexString(b));
        }
        return buffer2.toString();
    }
}

