/* tracker-remote.c generated by valac 0.56.0, the Vala compiler
 * generated from tracker-remote.vala, do not modify */

/*
 * Copyright (C) 2016 Carlos Garnacho <carlosg@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-remote-soup3.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "libtracker-sparql/tracker-connection.h"
#include <glib-object.h>
#include <libsoup/soup.h>
#include "libtracker-sparql/remote/tracker-remote-statement.h"

#define TRACKER_REMOTE_CONNECTION_XML_TYPE "application/sparql-results+xml"
#define TRACKER_REMOTE_CONNECTION_JSON_TYPE "application/sparql-results+json"
#define TRACKER_REMOTE_CONNECTION_TTL_TYPE "text/turtle"
#define TRACKER_REMOTE_CONNECTION_TRIG_TYPE "application/trig"
#define TRACKER_REMOTE_CONNECTION_USER_AGENT "Tracker/" PACKAGE_VERSION " (https://gitlab.gnome.org/GNOME/tracker/issues/; tracker-list@lists.g" \
"nome.org) Tracker/" PACKAGE_VERSION

enum  {
	TRACKER_REMOTE_CONNECTION_0_PROPERTY,
	TRACKER_REMOTE_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_remote_connection_properties[TRACKER_REMOTE_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _soup_message_headers_unref0(var) ((var == NULL) ? NULL : (var = (soup_message_headers_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _TrackerRemoteConnectionQueryAsyncData TrackerRemoteConnectionQueryAsyncData;
typedef struct _TrackerRemoteConnectionCloseAsyncData TrackerRemoteConnectionCloseAsyncData;
typedef struct _TrackerRemoteConnectionSerializeAsyncData TrackerRemoteConnectionSerializeAsyncData;

struct _TrackerRemoteConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	GBytes* body;
	SoupSession* _tmp1_;
	SoupMessage* _tmp2_;
	GBytes* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	SoupMessage* _tmp5_;
	GBytes* _tmp6_;
	gsize _tmp7_;
	guint8* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	TrackerSparqlCursor* _tmp10_;
	GError* _inner_error0_;
};

struct _TrackerRemoteConnectionCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteConnection* self;
	gboolean result;
};

struct _TrackerRemoteConnectionSerializeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerRemoteConnection* self;
	TrackerSerializeFlags flags;
	TrackerRdfFormat format;
	gchar* sparql;
	GCancellable* cancellable;
	GInputStream* result;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	GInputStream* _tmp1_;
	SoupSession* _tmp2_;
	GInputStream* _tmp3_;
	GInputStream* _tmp4_;
	GError* _inner_error0_;
};

static gpointer tracker_remote_connection_parent_class = NULL;

static SoupMessage* tracker_remote_connection_create_describe_request (TrackerRemoteConnection* self,
                                                                const gchar* sparql,
                                                                TrackerRdfFormat format);
static SoupMessage* tracker_remote_connection_create_request (TrackerRemoteConnection* self,
                                                       const gchar* sparql);
static TrackerSparqlCursor* tracker_remote_connection_create_cursor (TrackerRemoteConnection* self,
                                                              SoupMessage* message,
                                                              const gchar* document,
                                                              GError** error);
static TrackerSparqlCursor* tracker_remote_connection_real_query (TrackerSparqlConnection* base,
                                                           const gchar* sparql,
                                                           GCancellable* cancellable,
                                                           GError** error);
static void tracker_remote_connection_real_query_async_data_free (gpointer _data);
static void tracker_remote_connection_real_query_async (TrackerSparqlConnection* base,
                                                 const gchar* sparql,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_);
static void tracker_remote_connection_query_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static TrackerSparqlStatement* tracker_remote_connection_real_query_statement (TrackerSparqlConnection* base,
                                                                        const gchar* sparql,
                                                                        GCancellable* cancellable,
                                                                        GError** error);
static void tracker_remote_connection_real_close (TrackerSparqlConnection* base);
static void tracker_remote_connection_real_close_async_data_free (gpointer _data);
static void tracker_remote_connection_real_close_async (TrackerSparqlConnection* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean tracker_remote_connection_real_close_async_co (TrackerRemoteConnectionCloseAsyncData* _data_);
static void tracker_remote_connection_real_serialize_async_data_free (gpointer _data);
static void tracker_remote_connection_real_serialize_async (TrackerSparqlConnection* base,
                                                     TrackerSerializeFlags flags,
                                                     TrackerRdfFormat format,
                                                     const gchar* sparql,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_remote_connection_real_serialize_async_co (TrackerRemoteConnectionSerializeAsyncData* _data_);
static void tracker_remote_connection_serialize_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void tracker_remote_connection_finalize (GObject * obj);
static GType tracker_remote_connection_get_type_once (void);

TrackerRemoteConnection*
tracker_remote_connection_construct (GType object_type,
                                     const gchar* base_uri)
{
	TrackerRemoteConnection * self = NULL;
	gchar* _tmp0_;
	SoupSession* _tmp1_;
#line 35 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (base_uri != NULL, NULL);
#line 36 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) g_object_new (object_type, NULL);
#line 37 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = g_strdup (base_uri);
#line 37 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 37 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self->_base_uri = _tmp0_;
#line 38 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = soup_session_new ();
#line 38 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 38 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self->_session = _tmp1_;
#line 35 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return self;
#line 185 "tracker-remote.c"
}

TrackerRemoteConnection*
tracker_remote_connection_new (const gchar* base_uri)
{
#line 35 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return tracker_remote_connection_construct (TRACKER_REMOTE_TYPE_CONNECTION, base_uri);
#line 193 "tracker-remote.c"
}

static gpointer
_soup_message_headers_ref0 (gpointer self)
{
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return self ? soup_message_headers_ref (self) : NULL;
#line 201 "tracker-remote.c"
}

static SoupMessage*
tracker_remote_connection_create_describe_request (TrackerRemoteConnection* self,
                                                   const gchar* sparql,
                                                   TrackerRdfFormat format)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupMessage* message = NULL;
	const gchar* _tmp7_;
	SoupMessage* _tmp8_;
	SoupMessageHeaders* headers = NULL;
	SoupMessage* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	SoupMessageHeaders* _tmp11_;
	SoupMessageHeaders* _tmp12_;
	SoupMessage* result;
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = self->_base_uri;
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = g_strconcat (_tmp0_, "?query=", NULL);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = _tmp1_;
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp3_ = g_uri_escape_string (sparql, NULL, FALSE);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp4_ = _tmp3_;
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp6_ = _tmp5_;
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_tmp4_);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_tmp2_);
#line 42 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	uri = _tmp6_;
#line 43 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp7_ = uri;
#line 43 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp8_ = soup_message_new ("GET", _tmp7_);
#line 43 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	message = _tmp8_;
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp9_ = message;
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp10_ = soup_message_get_request_headers (_tmp9_);
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp11_ = _soup_message_headers_ref0 (_tmp10_);
#line 47 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	headers = _tmp11_;
#line 50 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp12_ = headers;
#line 50 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_message_headers_append (_tmp12_, "User-Agent", TRACKER_REMOTE_CONNECTION_USER_AGENT);
#line 52 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (format == TRACKER_RDF_FORMAT_TURTLE) {
#line 270 "tracker-remote.c"
		SoupMessageHeaders* _tmp13_;
#line 53 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp13_ = headers;
#line 53 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		soup_message_headers_append (_tmp13_, "Accept", TRACKER_REMOTE_CONNECTION_TTL_TYPE);
#line 276 "tracker-remote.c"
	} else {
#line 54 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		if (format == TRACKER_RDF_FORMAT_TRIG) {
#line 280 "tracker-remote.c"
			SoupMessageHeaders* _tmp14_;
#line 55 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp14_ = headers;
#line 55 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			soup_message_headers_append (_tmp14_, "Accept", TRACKER_REMOTE_CONNECTION_TRIG_TYPE);
#line 286 "tracker-remote.c"
		}
	}
#line 57 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = message;
#line 57 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_soup_message_headers_unref0 (headers);
#line 57 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (uri);
#line 57 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 297 "tracker-remote.c"
}

static SoupMessage*
tracker_remote_connection_create_request (TrackerRemoteConnection* self,
                                          const gchar* sparql)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp7_;
	SoupMessageHeaders* headers = NULL;
	SoupMessageHeaders* _tmp8_;
	SoupMessageHeaders* _tmp9_;
	SoupMessage* result;
#line 60 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = self->_base_uri;
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = g_strconcat (_tmp0_, "?query=", NULL);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = _tmp1_;
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp3_ = g_uri_escape_string (sparql, NULL, FALSE);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp4_ = _tmp3_;
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp6_ = _tmp5_;
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_tmp4_);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_tmp2_);
#line 61 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	uri = _tmp6_;
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp7_ = soup_message_new ("GET", uri);
#line 62 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	message = _tmp7_;
#line 66 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp8_ = soup_message_get_request_headers (message);
#line 66 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp9_ = _soup_message_headers_ref0 (_tmp8_);
#line 66 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	headers = _tmp9_;
#line 69 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_message_headers_append (headers, "User-Agent", TRACKER_REMOTE_CONNECTION_USER_AGENT);
#line 70 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_JSON_TYPE);
#line 71 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_message_headers_append (headers, "Accept", TRACKER_REMOTE_CONNECTION_XML_TYPE);
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = message;
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_soup_message_headers_unref0 (headers);
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (uri);
#line 73 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 366 "tracker-remote.c"
}

static TrackerSparqlCursor*
tracker_remote_connection_create_cursor (TrackerRemoteConnection* self,
                                         SoupMessage* message,
                                         const gchar* document,
                                         GError** error)
{
	SoupStatus status_code = 0;
	SoupMessageHeaders* headers = NULL;
	SoupMessageHeaders* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	gchar* content_type = NULL;
	SoupMessageHeaders* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	glong length = 0L;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (message != NULL, NULL);
#line 76 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 81 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	status_code = soup_message_get_status (message);
#line 82 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = soup_message_get_response_headers (message);
#line 82 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = _soup_message_headers_ref0 (_tmp0_);
#line 82 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	headers = _tmp1_;
#line 85 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (status_code != SOUP_STATUS_OK) {
#line 405 "tracker-remote.c"
		GError* _tmp2_;
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp2_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unhandled status code %u, document is: %s", (guint) status_code, document);
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_inner_error0_ = _tmp2_;
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_soup_message_headers_unref0 (headers);
#line 86 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 417 "tracker-remote.c"
	}
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp3_ = headers;
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp4_ = soup_message_headers_get_content_type (_tmp3_, NULL);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 90 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	content_type = _tmp5_;
#line 91 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp6_ = strlen (document);
#line 91 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp7_ = _tmp6_;
#line 91 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	length = (glong) _tmp7_;
#line 93 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp8_ = content_type;
#line 93 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (g_strcmp0 (_tmp8_, TRACKER_REMOTE_CONNECTION_JSON_TYPE) == 0) {
#line 437 "tracker-remote.c"
		TrackerRemoteJsonCursor* _tmp9_ = NULL;
		TrackerRemoteJsonCursor* _tmp10_;
		TrackerRemoteJsonCursor* _tmp11_;
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp10_ = tracker_remote_json_cursor_new (document, length, &_inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp9_ = _tmp10_;
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_soup_message_headers_unref0 (headers);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			return NULL;
#line 455 "tracker-remote.c"
		}
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp11_ = _tmp9_;
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp9_ = NULL;
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		result = (TrackerSparqlCursor*) _tmp11_;
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (_tmp9_);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_free0 (content_type);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_soup_message_headers_unref0 (headers);
#line 94 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return result;
#line 471 "tracker-remote.c"
	} else {
		const gchar* _tmp12_;
#line 95 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp12_ = content_type;
#line 95 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		if (g_strcmp0 (_tmp12_, TRACKER_REMOTE_CONNECTION_XML_TYPE) == 0) {
#line 478 "tracker-remote.c"
			TrackerRemoteXmlCursor* _tmp13_ = NULL;
			TrackerRemoteXmlCursor* _tmp14_;
			TrackerRemoteXmlCursor* _tmp15_;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp14_ = tracker_remote_xml_cursor_new (document, length, &_inner_error0_);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp13_ = _tmp14_;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
				g_propagate_error (error, _inner_error0_);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
				_g_free0 (content_type);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
				_soup_message_headers_unref0 (headers);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
				return NULL;
#line 496 "tracker-remote.c"
			}
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp15_ = _tmp13_;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp13_ = NULL;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			result = (TrackerSparqlCursor*) _tmp15_;
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_g_object_unref0 (_tmp13_);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_soup_message_headers_unref0 (headers);
#line 96 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			return result;
#line 512 "tracker-remote.c"
		} else {
			const gchar* _tmp16_;
			GError* _tmp17_;
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp16_ = content_type;
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_tmp17_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Unknown content type '%s', document is: %s", _tmp16_, document);
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_inner_error0_ = _tmp17_;
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error0_);
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_g_free0 (content_type);
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			_soup_message_headers_unref0 (headers);
#line 98 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			return NULL;
#line 530 "tracker-remote.c"
		}
	}
}

static TrackerSparqlCursor*
tracker_remote_connection_real_query (TrackerSparqlConnection* base,
                                      const gchar* sparql,
                                      GCancellable* cancellable,
                                      GError** error)
{
	TrackerRemoteConnection * self;
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	GBytes* body = NULL;
	SoupSession* _tmp1_;
	SoupMessage* _tmp2_;
	GBytes* _tmp3_;
	gchar* data = NULL;
	GBytes* _tmp4_;
	gsize _tmp5_ = 0;
	guint8* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp12_ = FALSE;
	TrackerSparqlCursor* _tmp14_ = NULL;
	SoupMessage* _tmp15_;
	const gchar* _tmp16_;
	TrackerSparqlCursor* _tmp17_;
	TrackerSparqlCursor* _tmp18_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 102 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 102 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = tracker_remote_connection_create_request (self, sparql);
#line 103 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	message = _tmp0_;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = self->_session;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = message;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp3_ = soup_session_send_and_read (_tmp1_, _tmp2_, NULL, &_inner_error0_);
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	body = _tmp3_;
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 109 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 587 "tracker-remote.c"
	}
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp4_ = body;
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp6_ = g_bytes_get_data (_tmp4_, &_tmp5_);
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
#line 110 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	data = _tmp7_;
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp9_ = data;
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_tmp9_ == NULL) {
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp8_ = TRUE;
#line 603 "tracker-remote.c"
	} else {
		const gchar* _tmp10_;
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp10_ = data;
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
#line 610 "tracker-remote.c"
	}
#line 113 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_tmp8_) {
#line 614 "tracker-remote.c"
		GError* _tmp11_;
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp11_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Empty response");
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_inner_error0_ = _tmp11_;
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_free0 (data);
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_bytes_unref0 (body);
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 114 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 630 "tracker-remote.c"
	}
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (cancellable != NULL) {
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp12_ = g_cancellable_is_cancelled (cancellable);
#line 636 "tracker-remote.c"
	} else {
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp12_ = FALSE;
#line 640 "tracker-remote.c"
	}
#line 116 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_tmp12_) {
#line 644 "tracker-remote.c"
		GError* _tmp13_;
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_tmp13_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_inner_error0_ = _tmp13_;
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_free0 (data);
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_bytes_unref0 (body);
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 117 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 660 "tracker-remote.c"
	}
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp15_ = message;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp16_ = data;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp17_ = tracker_remote_connection_create_cursor (self, _tmp15_, (const gchar*) _tmp16_, &_inner_error0_);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp14_ = _tmp17_;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_propagate_error (error, _inner_error0_);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_free0 (data);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_bytes_unref0 (body);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (message);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 682 "tracker-remote.c"
	}
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp18_ = _tmp14_;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp14_ = NULL;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = _tmp18_;
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_tmp14_);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (data);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_bytes_unref0 (body);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (message);
#line 119 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 700 "tracker-remote.c"
}

static void
tracker_remote_connection_real_query_async_data_free (gpointer _data)
{
	TrackerRemoteConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_slice_free (TrackerRemoteConnectionQueryAsyncData, _data_);
#line 718 "tracker-remote.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return self ? g_object_ref (self) : NULL;
#line 726 "tracker-remote.c"
}

static void
tracker_remote_connection_real_query_async (TrackerSparqlConnection* base,
                                            const gchar* sparql,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerRemoteConnection * self;
	TrackerRemoteConnectionQueryAsyncData* _data_;
	TrackerRemoteConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_if_fail (sparql != NULL);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_slice_new0 (TrackerRemoteConnectionQueryAsyncData);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_connection_real_query_async_data_free);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->self = _tmp0_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = g_strdup (sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->sparql = _tmp1_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->cancellable = _tmp2_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 769 "tracker-remote.c"
}

static TrackerSparqlCursor*
tracker_remote_connection_query_finish (TrackerSparqlConnection* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	TrackerSparqlCursor* result;
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (NULL == _data_) {
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 785 "tracker-remote.c"
	}
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = _data_->result;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->result = NULL;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 793 "tracker-remote.c"
}

static void
tracker_remote_connection_query_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerRemoteConnectionQueryAsyncData* _data_;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = _user_data_;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_source_object_ = source_object;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_res_ = _res_;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_real_query_async_co (_data_);
#line 810 "tracker-remote.c"
}

static gboolean
tracker_remote_connection_real_query_async_co (TrackerRemoteConnectionQueryAsyncData* _data_)
{
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	switch (_data_->_state_) {
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		case 0:
#line 820 "tracker-remote.c"
		goto _state_0;
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		case 1:
#line 824 "tracker-remote.c"
		goto _state_1;
		default:
#line 122 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_assert_not_reached ();
#line 829 "tracker-remote.c"
	}
	_state_0:
#line 123 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp0_ = tracker_remote_connection_create_request (_data_->self, _data_->sparql);
#line 123 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->message = _data_->_tmp0_;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp1_ = _data_->self->_session;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp2_ = _data_->message;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_state_ = 1;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_session_send_and_read_async (_data_->_tmp1_, _data_->_tmp2_, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_remote_connection_query_async_ready, _data_);
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return FALSE;
#line 846 "tracker-remote.c"
	_state_1:
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp3_ = soup_session_send_and_read_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->body = _data_->_tmp3_;
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 129 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return FALSE;
#line 862 "tracker-remote.c"
	}
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp5_ = _data_->message;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp6_ = _data_->body;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp7_ = 0;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp8_ = g_bytes_get_data (_data_->_tmp6_, &_data_->_tmp7_);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp9_ = tracker_remote_connection_create_cursor (_data_->self, _data_->_tmp5_, (const gchar*) _data_->_tmp8_, &_data_->_inner_error0_);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp4_ = _data_->_tmp9_;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_bytes_unref0 (_data_->body);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return FALSE;
#line 888 "tracker-remote.c"
	}
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp10_ = _data_->_tmp4_;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp4_ = NULL;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->result = _data_->_tmp10_;
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp4_);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_bytes_unref0 (_data_->body);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->message);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_data_->_state_ != 0) {
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 910 "tracker-remote.c"
		}
	}
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_object_unref (_data_->_async_result);
#line 130 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return FALSE;
#line 917 "tracker-remote.c"
}

static TrackerSparqlStatement*
tracker_remote_connection_real_query_statement (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                GCancellable* cancellable,
                                                GError** error)
{
	TrackerRemoteConnection * self;
	TrackerRemoteStatement* _tmp0_ = NULL;
	TrackerRemoteStatement* _tmp1_;
	TrackerRemoteStatement* _tmp2_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlStatement* result;
#line 134 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 134 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = tracker_remote_statement_new ((TrackerSparqlConnection*) self, sparql, &_inner_error0_);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = _tmp1_;
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_propagate_error (error, _inner_error0_);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			return NULL;
#line 948 "tracker-remote.c"
		} else {
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_clear_error (&_inner_error0_);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			return NULL;
#line 956 "tracker-remote.c"
		}
	}
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = _tmp0_;
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = NULL;
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = (TrackerSparqlStatement*) _tmp2_;
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_tmp0_);
#line 135 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 969 "tracker-remote.c"
}

static void
tracker_remote_connection_real_close (TrackerSparqlConnection* base)
{
	TrackerRemoteConnection * self;
#line 138 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 978 "tracker-remote.c"
}

static void
tracker_remote_connection_real_close_async_data_free (gpointer _data)
{
	TrackerRemoteConnectionCloseAsyncData* _data_;
	_data_ = _data;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_slice_free (TrackerRemoteConnectionCloseAsyncData, _data_);
#line 990 "tracker-remote.c"
}

static void
tracker_remote_connection_real_close_async (TrackerSparqlConnection* base,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerRemoteConnection * self;
	TrackerRemoteConnectionCloseAsyncData* _data_;
	TrackerRemoteConnection* _tmp0_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_slice_new0 (TrackerRemoteConnectionCloseAsyncData);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_connection_real_close_async_data_free);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->self = _tmp0_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_real_close_async_co (_data_);
#line 1015 "tracker-remote.c"
}

static gboolean
tracker_remote_connection_close_finish (TrackerSparqlConnection* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	gboolean result;
	TrackerRemoteConnectionCloseAsyncData* _data_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (NULL == _data_) {
#line 1029 "tracker-remote.c"
		gboolean _tmp0_ = FALSE;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return _tmp0_;
#line 1033 "tracker-remote.c"
	}
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = _data_->result;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 1039 "tracker-remote.c"
}

static gboolean
tracker_remote_connection_real_close_async_co (TrackerRemoteConnectionCloseAsyncData* _data_)
{
#line 141 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	switch (_data_->_state_) {
#line 141 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		case 0:
#line 1049 "tracker-remote.c"
		goto _state_0;
		default:
#line 141 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_assert_not_reached ();
#line 1054 "tracker-remote.c"
	}
	_state_0:
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->result = TRUE;
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_data_->_state_ != 0) {
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1067 "tracker-remote.c"
		}
	}
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_object_unref (_data_->_async_result);
#line 142 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return FALSE;
#line 1074 "tracker-remote.c"
}

static void
tracker_remote_connection_real_serialize_async_data_free (gpointer _data)
{
	TrackerRemoteConnectionSerializeAsyncData* _data_;
	_data_ = _data;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->result);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_slice_free (TrackerRemoteConnectionSerializeAsyncData, _data_);
#line 1092 "tracker-remote.c"
}

static void
tracker_remote_connection_real_serialize_async (TrackerSparqlConnection* base,
                                                TrackerSerializeFlags flags,
                                                TrackerRdfFormat format,
                                                const gchar* sparql,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerRemoteConnection * self;
	TrackerRemoteConnectionSerializeAsyncData* _data_;
	TrackerRemoteConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_return_if_fail (sparql != NULL);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = (TrackerRemoteConnection*) base;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_slice_new0 (TrackerRemoteConnectionSerializeAsyncData);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_remote_connection_real_serialize_async_data_free);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->self = _tmp0_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->flags = flags;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->format = format;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp1_ = g_strdup (sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (_data_->sparql);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->sparql = _tmp1_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->cancellable = _tmp2_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_real_serialize_async_co (_data_);
#line 1141 "tracker-remote.c"
}

static GInputStream*
tracker_remote_connection_serialize_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GInputStream* result;
	TrackerRemoteConnectionSerializeAsyncData* _data_;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (NULL == _data_) {
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return NULL;
#line 1157 "tracker-remote.c"
	}
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	result = _data_->result;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->result = NULL;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return result;
#line 1165 "tracker-remote.c"
}

static void
tracker_remote_connection_serialize_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerRemoteConnectionSerializeAsyncData* _data_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_ = _user_data_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_source_object_ = source_object;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_res_ = _res_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_real_serialize_async_co (_data_);
#line 1182 "tracker-remote.c"
}

static gboolean
tracker_remote_connection_real_serialize_async_co (TrackerRemoteConnectionSerializeAsyncData* _data_)
{
#line 145 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	switch (_data_->_state_) {
#line 145 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		case 0:
#line 1192 "tracker-remote.c"
		goto _state_0;
#line 145 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		case 1:
#line 1196 "tracker-remote.c"
		goto _state_1;
		default:
#line 145 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_assert_not_reached ();
#line 1201 "tracker-remote.c"
	}
	_state_0:
#line 146 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp0_ = tracker_remote_connection_create_describe_request (_data_->self, _data_->sparql, _data_->format);
#line 146 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->message = _data_->_tmp0_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp2_ = _data_->self->_session;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_state_ = 1;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	soup_session_send_async (_data_->_tmp2_, _data_->message, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_remote_connection_serialize_async_ready, _data_);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return FALSE;
#line 1216 "tracker-remote.c"
	_state_1:
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp3_ = soup_session_send_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp1_ = _data_->_tmp3_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		_g_object_unref0 (_data_->message);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		g_object_unref (_data_->_async_result);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		return FALSE;
#line 1232 "tracker-remote.c"
	}
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp4_ = _data_->_tmp1_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->_tmp1_ = NULL;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_data_->result = _data_->_tmp4_;
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->_tmp1_);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (_data_->message);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	if (_data_->_state_ != 0) {
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1252 "tracker-remote.c"
		}
	}
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	g_object_unref (_data_->_async_result);
#line 150 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	return FALSE;
#line 1259 "tracker-remote.c"
}

static void
tracker_remote_connection_class_init (TrackerRemoteConnectionClass * klass,
                                      gpointer klass_data)
{
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	tracker_remote_connection_parent_class = g_type_class_peek_parent (klass);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_remote_connection_real_query;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_connection_real_query_async;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_remote_connection_query_finish;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->query_statement = (TrackerSparqlStatement* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_remote_connection_real_query_statement;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->close = (void (*) (TrackerSparqlConnection*)) tracker_remote_connection_real_close;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->close_async = (void (*) (TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) tracker_remote_connection_real_close_async;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->close_finish = (gboolean (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_remote_connection_close_finish;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->serialize_async = (void (*) (TrackerSparqlConnection*, TrackerSerializeFlags, TrackerRdfFormat, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_remote_connection_real_serialize_async;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	((TrackerSparqlConnectionClass *) klass)->serialize_finish = (GInputStream* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_remote_connection_serialize_finish;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_remote_connection_finalize;
#line 1288 "tracker-remote.c"
}

static void
tracker_remote_connection_instance_init (TrackerRemoteConnection * self,
                                         gpointer klass)
{
}

static void
tracker_remote_connection_finalize (GObject * obj)
{
	TrackerRemoteConnection * self;
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_REMOTE_TYPE_CONNECTION, TrackerRemoteConnection);
#line 26 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_object_unref0 (self->_session);
#line 27 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	_g_free0 (self->_base_uri);
#line 24 "../tracker/src/libtracker-sparql/remote/tracker-remote.vala"
	G_OBJECT_CLASS (tracker_remote_connection_parent_class)->finalize (obj);
#line 1309 "tracker-remote.c"
}

static GType
tracker_remote_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerRemoteConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_remote_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerRemoteConnection), 0, (GInstanceInitFunc) tracker_remote_connection_instance_init, NULL };
	GType tracker_remote_connection_type_id;
	tracker_remote_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerRemoteConnection", &g_define_type_info, 0);
	return tracker_remote_connection_type_id;
}

GType
tracker_remote_connection_get_type (void)
{
	static volatile gsize tracker_remote_connection_type_id__once = 0;
	if (g_once_init_enter (&tracker_remote_connection_type_id__once)) {
		GType tracker_remote_connection_type_id;
		tracker_remote_connection_type_id = tracker_remote_connection_get_type_once ();
		g_once_init_leave (&tracker_remote_connection_type_id__once, tracker_remote_connection_type_id);
	}
	return tracker_remote_connection_type_id__once;
}

