/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 254 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 33 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 144 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 36 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 41 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qtimezone.sip"
#include <qtimezone.h>
#line 44 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 24 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 47 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qcalendar.sip"
#include <qcalendar.h>
#line 50 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
#line 258 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
#include <QHash>
#line 53 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"


PyDoc_STRVAR(doc_QDateTime_toPyDateTime, "toPyDateTime(self) -> datetime.datetime");

extern "C" {static PyObject *meth_QDateTime_toPyDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toPyDateTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 361 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        // Convert to a Python datetime object.
        sipDateDef py_date;
        QDate qd = sipCpp->date();
        
        py_date.pd_year = qd.year();
        py_date.pd_month = qd.month();
        py_date.pd_day = qd.day();
        
        sipTimeDef py_time;
        QTime qt = sipCpp->time();
        
        py_time.pt_hour = qt.hour();
        py_time.pt_minute = qt.minute();
        py_time.pt_second = qt.second();
        py_time.pt_microsecond = qt.msec() * 1000;
        
        sipRes = sipFromDateTime(&py_date, &py_time);
#line 89 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toPyDateTime, doc_QDateTime_toPyDateTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QDateTime_isNull(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_isNull, doc_QDateTime_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QDateTime_isValid(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_isValid, doc_QDateTime_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_date, "date(self) -> QDate");

extern "C" {static PyObject *meth_QDateTime_date(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_date(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QDate*sipRes;

            sipRes = new  ::QDate(sipCpp->date());

            return sipConvertFromNewType(sipRes,sipType_QDate,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_date, doc_QDateTime_date);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_time, "time(self) -> QTime");

extern "C" {static PyObject *meth_QDateTime_time(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_time(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QTime*sipRes;

            sipRes = new  ::QTime(sipCpp->time());

            return sipConvertFromNewType(sipRes,sipType_QTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_time, doc_QDateTime_time);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_timeSpec, "timeSpec(self) -> Qt.TimeSpec");

extern "C" {static PyObject *meth_QDateTime_timeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_timeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::Qt::TimeSpec sipRes;

            sipRes = sipCpp->timeSpec();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qt_TimeSpec);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_timeSpec, doc_QDateTime_timeSpec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setTimeSpec, "setTimeSpec(self, Qt.TimeSpec)");

extern "C" {static PyObject *meth_QDateTime_setTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTimeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::TimeSpec a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_TimeSpec, &a0))
        {
            sipCpp->setTimeSpec(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTimeSpec, doc_QDateTime_setTimeSpec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toString, "toString(self, format: Qt.DateFormat = Qt.TextDate) -> str\n"
"toString(self, str, cal: QCalendar = QCalendar()) -> str");

extern "C" {static PyObject *meth_QDateTime_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::DateFormat a0 = Qt::TextDate;
        const  ::QDateTime *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_DateFormat, &a0))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->toString(a0));

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    {
        const  ::QString* a0;
        int a0State = 0;
         ::QCalendar a1def = QCalendar();
         ::QCalendar* a1 = &a1def;
        const  ::QDateTime *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J9", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QString, &a0, &a0State, sipType_QCalendar, &a1))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->toString(*a0,*a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toString, doc_QDateTime_toString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_addDays, "addDays(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_addDays(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addDays(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->addDays(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addDays, doc_QDateTime_addDays);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_addMonths, "addMonths(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_addMonths(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMonths(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->addMonths(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addMonths, doc_QDateTime_addMonths);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_addYears, "addYears(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_addYears(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addYears(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->addYears(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addYears, doc_QDateTime_addYears);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_addSecs, "addSecs(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_addSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addSecs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->addSecs(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addSecs, doc_QDateTime_addSecs);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_addMSecs, "addMSecs(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_addMSecs(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_addMSecs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->addMSecs(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_addMSecs, doc_QDateTime_addMSecs);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toTimeSpec, "toTimeSpec(self, Qt.TimeSpec) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_toTimeSpec(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTimeSpec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Qt::TimeSpec a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QDateTime, &sipCpp, sipType_Qt_TimeSpec, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->toTimeSpec(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toTimeSpec, doc_QDateTime_toTimeSpec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toLocalTime, "toLocalTime(self) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_toLocalTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toLocalTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->toLocalTime());

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toLocalTime, doc_QDateTime_toLocalTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toUTC, "toUTC(self) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_toUTC(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toUTC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->toUTC());

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toUTC, doc_QDateTime_toUTC);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_daysTo, "daysTo(self, Union[QDateTime, datetime.datetime]) -> int");

extern "C" {static PyObject *meth_QDateTime_daysTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_daysTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->daysTo(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_daysTo, doc_QDateTime_daysTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_secsTo, "secsTo(self, Union[QDateTime, datetime.datetime]) -> int");

extern "C" {static PyObject *meth_QDateTime_secsTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_secsTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->secsTo(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_secsTo, doc_QDateTime_secsTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_currentDateTime, "currentDateTime() -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_currentDateTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentDateTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::currentDateTime());

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_currentDateTime, doc_QDateTime_currentDateTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_fromString, "fromString(str, format: Qt.DateFormat = Qt.TextDate) -> QDateTime\n"
"fromString(str, str, cal: QCalendar = QCalendar()) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_fromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;
         ::Qt::DateFormat a1 = Qt::TextDate;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|E", &sipSelf, sipType_QString, &a0, &a0State, sipType_Qt_DateFormat, &a1))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromString(*a0,a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    {
        const  ::QString* a0;
        int a0State = 0;
        const  ::QString* a1;
        int a1State = 0;
         ::QCalendar a2def = QCalendar();
         ::QCalendar* a2 = &a2def;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_cal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1J1|J9", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QCalendar, &a2))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromString(*a0,*a1,*a2));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_fromString, doc_QDateTime_fromString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toMSecsSinceEpoch, "toMSecsSinceEpoch(self) -> int");

extern "C" {static PyObject *meth_QDateTime_toMSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toMSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->toMSecsSinceEpoch();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toMSecsSinceEpoch, doc_QDateTime_toMSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setMSecsSinceEpoch, "setMSecsSinceEpoch(self, int)");

extern "C" {static PyObject *meth_QDateTime_setMSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setMSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            sipCpp->setMSecsSinceEpoch(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setMSecsSinceEpoch, doc_QDateTime_setMSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_msecsTo, "msecsTo(self, Union[QDateTime, datetime.datetime]) -> int");

extern "C" {static PyObject *meth_QDateTime_msecsTo(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_msecsTo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0, &a0State))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->msecsTo(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_msecsTo, doc_QDateTime_msecsTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_currentDateTimeUtc, "currentDateTimeUtc() -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_currentDateTimeUtc(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentDateTimeUtc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::currentDateTimeUtc());

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_currentDateTimeUtc, doc_QDateTime_currentDateTimeUtc);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_currentMSecsSinceEpoch, "currentMSecsSinceEpoch() -> int");

extern "C" {static PyObject *meth_QDateTime_currentMSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentMSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
             ::qint64 sipRes;

            sipRes =  ::QDateTime::currentMSecsSinceEpoch();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_currentMSecsSinceEpoch, doc_QDateTime_currentMSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_swap, "swap(self, QDateTime)");

extern "C" {static PyObject *meth_QDateTime_swap(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDateTime* a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDateTime, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_swap, doc_QDateTime_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_offsetFromUtc, "offsetFromUtc(self) -> int");

extern "C" {static PyObject *meth_QDateTime_offsetFromUtc(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_offsetFromUtc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->offsetFromUtc();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_offsetFromUtc, doc_QDateTime_offsetFromUtc);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_timeZone, "timeZone(self) -> QTimeZone");

extern "C" {static PyObject *meth_QDateTime_timeZone(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_timeZone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QTimeZone*sipRes;

            sipRes = new  ::QTimeZone(sipCpp->timeZone());

            return sipConvertFromNewType(sipRes,sipType_QTimeZone,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_timeZone, doc_QDateTime_timeZone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_timeZoneAbbreviation, "timeZoneAbbreviation(self) -> str");

extern "C" {static PyObject *meth_QDateTime_timeZoneAbbreviation(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_timeZoneAbbreviation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::QString*sipRes;

            sipRes = new  ::QString(sipCpp->timeZoneAbbreviation());

            return sipConvertFromNewType(sipRes,sipType_QString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_timeZoneAbbreviation, doc_QDateTime_timeZoneAbbreviation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_isDaylightTime, "isDaylightTime(self) -> bool");

extern "C" {static PyObject *meth_QDateTime_isDaylightTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_isDaylightTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isDaylightTime();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_isDaylightTime, doc_QDateTime_isDaylightTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setOffsetFromUtc, "setOffsetFromUtc(self, int)");

extern "C" {static PyObject *meth_QDateTime_setOffsetFromUtc(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setOffsetFromUtc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            sipCpp->setOffsetFromUtc(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setOffsetFromUtc, doc_QDateTime_setOffsetFromUtc);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setTimeZone, "setTimeZone(self, QTimeZone)");

extern "C" {static PyObject *meth_QDateTime_setTimeZone(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTimeZone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QTimeZone* a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QTimeZone, &a0))
        {
            sipCpp->setTimeZone(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTimeZone, doc_QDateTime_setTimeZone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toOffsetFromUtc, "toOffsetFromUtc(self, int) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_toOffsetFromUtc(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toOffsetFromUtc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->toOffsetFromUtc(a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toOffsetFromUtc, doc_QDateTime_toOffsetFromUtc);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toTimeZone, "toTimeZone(self, QTimeZone) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_toTimeZone(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toTimeZone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QTimeZone* a0;
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QTimeZone, &a0))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime(sipCpp->toTimeZone(*a0));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toTimeZone, doc_QDateTime_toTimeZone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_fromMSecsSinceEpoch, "fromMSecsSinceEpoch(int, QTimeZone) -> QDateTime\n"
"fromMSecsSinceEpoch(int, spec: Qt.TimeSpec = Qt.LocalTime, offsetSeconds: int = 0) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_fromMSecsSinceEpoch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromMSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
        const  ::QTimeZone* a1;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "CnJ9", &sipSelf, &a0, sipType_QTimeZone, &a1))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromMSecsSinceEpoch(a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    {
         ::qint64 a0;
         ::Qt::TimeSpec a1 = Qt::LocalTime;
        int a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_spec,
            sipName_offsetSeconds,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Cn|Ei", &sipSelf, &a0, sipType_Qt_TimeSpec, &a1, &a2))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromMSecsSinceEpoch(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_fromMSecsSinceEpoch, doc_QDateTime_fromMSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_toSecsSinceEpoch, "toSecsSinceEpoch(self) -> int");

extern "C" {static PyObject *meth_QDateTime_toSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_toSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDateTime, &sipCpp))
        {
             ::qint64 sipRes;

            sipRes = sipCpp->toSecsSinceEpoch();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_toSecsSinceEpoch, doc_QDateTime_toSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setSecsSinceEpoch, "setSecsSinceEpoch(self, int)");

extern "C" {static PyObject *meth_QDateTime_setSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QDateTime, &sipCpp, &a0))
        {
            sipCpp->setSecsSinceEpoch(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setSecsSinceEpoch, doc_QDateTime_setSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_fromSecsSinceEpoch, "fromSecsSinceEpoch(int, spec: Qt.TimeSpec = Qt.LocalTime, offsetSeconds: int = 0) -> QDateTime\n"
"fromSecsSinceEpoch(int, QTimeZone) -> QDateTime");

extern "C" {static PyObject *meth_QDateTime_fromSecsSinceEpoch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDateTime_fromSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qint64 a0;
         ::Qt::TimeSpec a1 = Qt::LocalTime;
        int a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_spec,
            sipName_offsetSeconds,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Cn|Ei", &sipSelf, &a0, sipType_Qt_TimeSpec, &a1, &a2))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromSecsSinceEpoch(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    {
         ::qint64 a0;
        const  ::QTimeZone* a1;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "CnJ9", &sipSelf, &a0, sipType_QTimeZone, &a1))
        {
             ::QDateTime*sipRes;

            sipRes = new  ::QDateTime( ::QDateTime::fromSecsSinceEpoch(a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QDateTime,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_fromSecsSinceEpoch, doc_QDateTime_fromSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_currentSecsSinceEpoch, "currentSecsSinceEpoch() -> int");

extern "C" {static PyObject *meth_QDateTime_currentSecsSinceEpoch(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_currentSecsSinceEpoch(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
             ::qint64 sipRes;

            sipRes =  ::QDateTime::currentSecsSinceEpoch();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_currentSecsSinceEpoch, doc_QDateTime_currentSecsSinceEpoch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setDate, "setDate(self, Union[QDate, datetime.date])");

extern "C" {static PyObject *meth_QDateTime_setDate(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QDate* a0;
        int a0State = 0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QDate, &a0, &a0State))
        {
            sipCpp->setDate(*a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setDate, doc_QDateTime_setDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDateTime_setTime, "setTime(self, Union[QTime, datetime.time])");

extern "C" {static PyObject *meth_QDateTime_setTime(PyObject *, PyObject *);}
static PyObject *meth_QDateTime_setTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QTime* a0;
        int a0State = 0;
         ::QDateTime *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDateTime, &sipCpp, sipType_QTime, &a0, &a0State))
        {
            sipCpp->setTime(*a0);
            sipReleaseType(a0, sipType_QTime, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDateTime, sipName_setTime, doc_QDateTime_setTime);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QDateTime___eq__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDateTime___ne__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDateTime___lt__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___lt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, lt_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDateTime___le__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___le__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, le_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDateTime___gt__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___gt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, gt_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QDateTime___ge__(PyObject *,PyObject *);}
static PyObject *slot_QDateTime___ge__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QDateTime, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ge_slot, sipType_QDateTime, sipSelf, sipArg);
}


extern "C" {static int slot_QDateTime___bool__(PyObject *);}
static int slot_QDateTime___bool__(PyObject *sipSelf)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 383 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        sipRes = !sipCpp->isNull();
#line 1527 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static Py_hash_t slot_QDateTime___hash__(PyObject *);}
static Py_hash_t slot_QDateTime___hash__(PyObject *sipSelf)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 356 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        sipRes = qHash(sipCpp->toString(Qt::ISODate));
#line 1552 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QDateTime___repr__(PyObject *);}
static PyObject *slot_QDateTime___repr__(PyObject *sipSelf)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QDateTime));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 320 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        if (sipCpp->isNull())
        {
            sipRes = PyUnicode_FromString("PyQt6.QtCore.QDateTime()");
        }
        else
        {
            QDate qd = sipCpp->date();
            QTime qt = sipCpp->time();
        
            sipRes = PyUnicode_FromFormat(
                    "PyQt6.QtCore.QDateTime(%i, %i, %i, %i, %i",
                    qd.year(), qd.month(), qd.day(), qt.hour(), qt.minute());
        
            if (qt.second() || qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
            {
                qpycore_Unicode_ConcatAndDel(&sipRes,
                        PyUnicode_FromFormat(", %i", qt.second()));
        
                if (qt.msec() || sipCpp->timeSpec() != Qt::LocalTime)
                {
                    qpycore_Unicode_ConcatAndDel(&sipRes,
                            PyUnicode_FromFormat(", %i", qt.msec()));
        
                    if (sipCpp->timeSpec() != Qt::LocalTime)
                        qpycore_Unicode_ConcatAndDel(&sipRes,
                                PyUnicode_FromFormat(", PyQt6.QtCore.Qt.TimeSpec(%i)",
                                        (int)sipCpp->timeSpec()));
                }
            }
        
            qpycore_Unicode_ConcatAndDel(&sipRes, PyUnicode_FromString(")"));
        }
#line 1608 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDateTime(void *, int);}
static void release_QDateTime(void *sipCppV, int)
{
    delete reinterpret_cast< ::QDateTime *>(sipCppV);
}


extern "C" {static PyObject *pickle_QDateTime(void *);}
static PyObject *pickle_QDateTime(void *sipCppV)
{
     ::QDateTime *sipCpp = reinterpret_cast< ::QDateTime *>(sipCppV);
    PyObject *sipRes;

#line 295 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
    QDate qd = sipCpp->date();
    QTime qt = sipCpp->time();
    
    sipRes = Py_BuildValue("iiiiiiii", qd.year(), qd.month(), qd.day(),
            qt.hour(), qt.minute(), qt.second(), qt.msec(),
            (int)sipCpp->timeSpec());
#line 1639 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

    return sipRes;
}


extern "C" {static void *array_QDateTime(Py_ssize_t);}
static void *array_QDateTime(Py_ssize_t sipNrElem)
{
    return new  ::QDateTime[sipNrElem];
}


extern "C" {static void assign_QDateTime(void *, Py_ssize_t, void *);}
static void assign_QDateTime(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QDateTime *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QDateTime *>(sipSrc);
}


extern "C" {static void *copy_QDateTime(const void *, Py_ssize_t);}
static void *copy_QDateTime(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QDateTime(reinterpret_cast<const  ::QDateTime *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDateTime(sipSimpleWrapper *);}
static void dealloc_QDateTime(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QDateTime(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QDateTime(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QDateTime(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QDateTime *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QDateTime();

            return sipCpp;
        }
    }

    {
        const  ::QDateTime* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QDateTime, &a0, &a0State))
        {
            sipCpp = new  ::QDateTime(*a0);
            sipReleaseType(const_cast< ::QDateTime *>(a0), sipType_QDateTime, a0State);

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;
        int a3;
        int a4;
        int a5 = 0;
        int a6 = 0;
        int a7 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_second,
            sipName_msec,
            sipName_timeSpec,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiiii|iii", &a0, &a1, &a2, &a3, &a4, &a5, &a6, &a7))
        {
#line 308 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
        // This ctor is mainly supplied to allow pickling.
        QDate qd(a0, a1, a2);
        QTime qt(a3, a4, a5, a6);
        
        sipCpp = new QDateTime(qd, qt, (Qt::TimeSpec)a7);
#line 1732 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"

            return sipCpp;
        }
    }

    {
         ::QDate* a0;
        int a0State = 0;
         ::QTime* a1;
        int a1State = 0;
         ::Qt::TimeSpec a2 = Qt::LocalTime;
        int a3 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_spec,
            sipName_offsetSeconds,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1|Ei", sipType_QDate, &a0, &a0State, sipType_QTime, &a1, &a1State, sipType_Qt_TimeSpec, &a2, &a3))
        {
            sipCpp = new  ::QDateTime(*a0,*a1,a2,a3);
            sipReleaseType(a0, sipType_QDate, a0State);
            sipReleaseType(a1, sipType_QTime, a1State);

            return sipCpp;
        }
    }

    {
         ::QDate* a0;
        int a0State = 0;
         ::QTime* a1;
        int a1State = 0;
        const  ::QTimeZone* a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1J1J9", sipType_QDate, &a0, &a0State, sipType_QTime, &a1, &a1State, sipType_QTimeZone, &a2))
        {
            sipCpp = new  ::QDateTime(*a0,*a1,*a2);
            sipReleaseType(a0, sipType_QDate, a0State);
            sipReleaseType(a1, sipType_QTime, a1State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QDateTime(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QDateTime(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QDateTime **sipCppPtr = reinterpret_cast< ::QDateTime **>(sipCppPtrV);

#line 262 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qdatetime.sip"
// Allow a Python datetime object whenever a QDateTime is expected.

if (sipIsErr == NULL)
    return (sipGetDateTime(sipPy, 0, 0) ||
            sipCanConvertToType(sipPy, sipType_QDateTime, SIP_NO_CONVERTORS));

sipDateDef py_date;
sipTimeDef py_time;

if (sipGetDateTime(sipPy, &py_date, &py_time))
{
    QDate qdate(py_date.pd_year,
                py_date.pd_month,
                py_date.pd_day);

    QTime qtime(py_time.pt_hour,
                py_time.pt_minute,
                py_time.pt_second,
                py_time.pt_microsecond / 1000);

    QDateTime *qdt = new QDateTime(qdate, qtime);

    *sipCppPtr = qdt;

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QDateTime *>(sipConvertToType(sipPy, sipType_QDateTime, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 1820 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQDateTime.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QDateTime[] = {
    {(void *)slot_QDateTime___eq__, eq_slot},
    {(void *)slot_QDateTime___ne__, ne_slot},
    {(void *)slot_QDateTime___lt__, lt_slot},
    {(void *)slot_QDateTime___le__, le_slot},
    {(void *)slot_QDateTime___gt__, gt_slot},
    {(void *)slot_QDateTime___ge__, ge_slot},
    {(void *)slot_QDateTime___bool__, bool_slot},
    {(void *)slot_QDateTime___hash__, hash_slot},
    {(void *)slot_QDateTime___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QDateTime[] = {
    {sipName_addDays, meth_QDateTime_addDays, METH_VARARGS, doc_QDateTime_addDays},
    {sipName_addMSecs, meth_QDateTime_addMSecs, METH_VARARGS, doc_QDateTime_addMSecs},
    {sipName_addMonths, meth_QDateTime_addMonths, METH_VARARGS, doc_QDateTime_addMonths},
    {sipName_addSecs, meth_QDateTime_addSecs, METH_VARARGS, doc_QDateTime_addSecs},
    {sipName_addYears, meth_QDateTime_addYears, METH_VARARGS, doc_QDateTime_addYears},
    {sipName_currentDateTime, meth_QDateTime_currentDateTime, METH_VARARGS, doc_QDateTime_currentDateTime},
    {sipName_currentDateTimeUtc, meth_QDateTime_currentDateTimeUtc, METH_VARARGS, doc_QDateTime_currentDateTimeUtc},
    {sipName_currentMSecsSinceEpoch, meth_QDateTime_currentMSecsSinceEpoch, METH_VARARGS, doc_QDateTime_currentMSecsSinceEpoch},
    {sipName_currentSecsSinceEpoch, meth_QDateTime_currentSecsSinceEpoch, METH_VARARGS, doc_QDateTime_currentSecsSinceEpoch},
    {sipName_date, meth_QDateTime_date, METH_VARARGS, doc_QDateTime_date},
    {sipName_daysTo, meth_QDateTime_daysTo, METH_VARARGS, doc_QDateTime_daysTo},
    {sipName_fromMSecsSinceEpoch, SIP_MLMETH_CAST(meth_QDateTime_fromMSecsSinceEpoch), METH_VARARGS|METH_KEYWORDS, doc_QDateTime_fromMSecsSinceEpoch},
    {sipName_fromSecsSinceEpoch, SIP_MLMETH_CAST(meth_QDateTime_fromSecsSinceEpoch), METH_VARARGS|METH_KEYWORDS, doc_QDateTime_fromSecsSinceEpoch},
    {sipName_fromString, SIP_MLMETH_CAST(meth_QDateTime_fromString), METH_VARARGS|METH_KEYWORDS, doc_QDateTime_fromString},
    {sipName_isDaylightTime, meth_QDateTime_isDaylightTime, METH_VARARGS, doc_QDateTime_isDaylightTime},
    {sipName_isNull, meth_QDateTime_isNull, METH_VARARGS, doc_QDateTime_isNull},
    {sipName_isValid, meth_QDateTime_isValid, METH_VARARGS, doc_QDateTime_isValid},
    {sipName_msecsTo, meth_QDateTime_msecsTo, METH_VARARGS, doc_QDateTime_msecsTo},
    {sipName_offsetFromUtc, meth_QDateTime_offsetFromUtc, METH_VARARGS, doc_QDateTime_offsetFromUtc},
    {sipName_secsTo, meth_QDateTime_secsTo, METH_VARARGS, doc_QDateTime_secsTo},
    {sipName_setDate, meth_QDateTime_setDate, METH_VARARGS, doc_QDateTime_setDate},
    {sipName_setMSecsSinceEpoch, meth_QDateTime_setMSecsSinceEpoch, METH_VARARGS, doc_QDateTime_setMSecsSinceEpoch},
    {sipName_setOffsetFromUtc, meth_QDateTime_setOffsetFromUtc, METH_VARARGS, doc_QDateTime_setOffsetFromUtc},
    {sipName_setSecsSinceEpoch, meth_QDateTime_setSecsSinceEpoch, METH_VARARGS, doc_QDateTime_setSecsSinceEpoch},
    {sipName_setTime, meth_QDateTime_setTime, METH_VARARGS, doc_QDateTime_setTime},
    {sipName_setTimeSpec, meth_QDateTime_setTimeSpec, METH_VARARGS, doc_QDateTime_setTimeSpec},
    {sipName_setTimeZone, meth_QDateTime_setTimeZone, METH_VARARGS, doc_QDateTime_setTimeZone},
    {sipName_swap, meth_QDateTime_swap, METH_VARARGS, doc_QDateTime_swap},
    {sipName_time, meth_QDateTime_time, METH_VARARGS, doc_QDateTime_time},
    {sipName_timeSpec, meth_QDateTime_timeSpec, METH_VARARGS, doc_QDateTime_timeSpec},
    {sipName_timeZone, meth_QDateTime_timeZone, METH_VARARGS, doc_QDateTime_timeZone},
    {sipName_timeZoneAbbreviation, meth_QDateTime_timeZoneAbbreviation, METH_VARARGS, doc_QDateTime_timeZoneAbbreviation},
    {sipName_toLocalTime, meth_QDateTime_toLocalTime, METH_VARARGS, doc_QDateTime_toLocalTime},
    {sipName_toMSecsSinceEpoch, meth_QDateTime_toMSecsSinceEpoch, METH_VARARGS, doc_QDateTime_toMSecsSinceEpoch},
    {sipName_toOffsetFromUtc, meth_QDateTime_toOffsetFromUtc, METH_VARARGS, doc_QDateTime_toOffsetFromUtc},
    {sipName_toPyDateTime, meth_QDateTime_toPyDateTime, METH_VARARGS, doc_QDateTime_toPyDateTime},
    {sipName_toSecsSinceEpoch, meth_QDateTime_toSecsSinceEpoch, METH_VARARGS, doc_QDateTime_toSecsSinceEpoch},
    {sipName_toString, SIP_MLMETH_CAST(meth_QDateTime_toString), METH_VARARGS|METH_KEYWORDS, doc_QDateTime_toString},
    {sipName_toTimeSpec, meth_QDateTime_toTimeSpec, METH_VARARGS, doc_QDateTime_toTimeSpec},
    {sipName_toTimeZone, meth_QDateTime_toTimeZone, METH_VARARGS, doc_QDateTime_toTimeZone},
    {sipName_toUTC, meth_QDateTime_toUTC, METH_VARARGS, doc_QDateTime_toUTC}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QDateTime[] = {
    {sipName_First, static_cast<int>(::QDateTime::YearRange::First)},
    {sipName_Last, static_cast<int>(::QDateTime::YearRange::Last)},
    {0, 0}
};

PyDoc_STRVAR(doc_QDateTime, "\1QDateTime()\n"
"QDateTime(Union[QDateTime, datetime.datetime])\n"
"QDateTime(int, int, int, int, int, second: int = 0, msec: int = 0, timeSpec: int = 0)\n"
"QDateTime(Union[QDate, datetime.date], Union[QTime, datetime.time], spec: Qt.TimeSpec = Qt.LocalTime, offsetSeconds: int = 0)\n"
"QDateTime(Union[QDate, datetime.date], Union[QTime, datetime.time], QTimeZone)");


sipClassTypeDef sipTypeDef_QtCore_QDateTime = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QDateTime,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_QDateTime,
        {0, 0, 1},
        41, methods_QDateTime,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QDateTime, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QDateTime,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QDateTime,
    init_type_QDateTime,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QDateTime,
    assign_QDateTime,
    array_QDateTime,
    copy_QDateTime,
    release_QDateTime,
    SIP_NULLPTR,
    convertTo_QDateTime,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QDateTime,
    SIP_NULLPTR,
    SIP_NULLPTR
};
