/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.alignment;
import org.openoffice.xmerge.converter.xml.conversionAlgorithm;
import org.openoffice.xmerge.converter.xml.horizSize;
import org.openoffice.xmerge.converter.xml.lineHeight;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParaStyle
extends Style
implements Cloneable {
    private static final int TEXT_INDENT = 4;
    private static final int LINE_HEIGHT = 5;
    private static final int TEXT_ALIGN = 6;
    private static final int NR_PROPERTIES = 7;
    private boolean[] isSet = new boolean[7];
    private int[] value = new int[7];
    private final String[] attrName = new String[]{"fo:margin-left", "fo:margin-right", "fo:margin-top", "fo:margin-bottom", "fo:text-indent", "fo:line-height", "fo:text-align"};
    private final Class<?>[] algor = new Class[]{horizSize.class, horizSize.class, horizSize.class, horizSize.class, horizSize.class, lineHeight.class, alignment.class};
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUST = 3;
    public static final int ALIGN_LEFT = 4;
    public static final int LH_PCT = 0x40000000;
    private static final int LH_VALUEMASK = 0xFFFFFF;
    private static String[] ignored = new String[]{"style:font-name", "fo:font-size", "fo:font-weight", "fo:color", "fo:language", "fo:country", "style:font-name-asian", "style:font-size-asian", "style:language-asian", "style:country-asian", "style:font-name-complex", "style:font-size-complex", "style:language-complex", "style:country-complex", "style:text-autospace", "style:punctuation-wrap", "style:line-break", "fo:keep-with-next", "fo:font-style", "text:number-lines", "text:line-number"};

    public ParaStyle(Node node, StyleCatalog sc) {
        super(node, sc);
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                NamedNodeMap childAttrNodes;
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (!nodeName.equals("style:properties") || (childAttrNodes = child.getAttributes()) == null) continue;
                int nChildAttrNodes = childAttrNodes.getLength();
                for (int j = 0; j < nChildAttrNodes; ++j) {
                    Node attr = childAttrNodes.item(j);
                    this.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
            }
        }
    }

    public ParaStyle(String name, String familyName, String parentName, String[] attribs, String[] values, StyleCatalog sc) {
        super(name, familyName, parentName, sc);
        if (attribs != null) {
            for (int i = 0; i < attribs.length; ++i) {
                this.setAttribute(attribs[i], values[i]);
            }
        }
    }

    public ParaStyle(String name, String familyName, String parentName, int[] attribs, String[] values, StyleCatalog lookup) {
        super(name, familyName, parentName, lookup);
        if (attribs != null) {
            for (int i = 0; i < attribs.length; ++i) {
                this.setAttribute(attribs[i], values[i]);
            }
        }
    }

    private boolean isIgnored(String attribute) {
        for (int i = 0; i < ignored.length; ++i) {
            if (!ignored[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private void setAttribute(String attr, String value) {
        for (int i = 0; i < 7; ++i) {
            if (!attr.equals(this.attrName[i])) continue;
            this.setAttribute(i, value);
            return;
        }
        if (!this.isIgnored(attr)) {
            Debug.log(1, "ParaStyle Unhandled: " + attr + "=" + value);
        }
    }

    private void setAttribute(int attr, String value) {
        this.isSet[attr] = true;
        try {
            this.value[attr] = ((conversionAlgorithm)this.algor[attr].newInstance()).I(value);
        }
        catch (Exception e) {
            Debug.log(2, "Instantiation error", e);
        }
    }

    @Override
    public Style getResolved() {
        ParaStyle resolved = null;
        try {
            resolved = (ParaStyle)this.clone();
        }
        catch (Exception e) {
            Debug.log(2, "Can't clone", e);
        }
        ParaStyle parentStyle = null;
        if (this.sc != null) {
            if (this.parent != null) {
                parentStyle = (ParaStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (parentStyle == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    parentStyle = (ParaStyle)parentStyle.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                parentStyle = (ParaStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (parentStyle != null) {
            parentStyle = (ParaStyle)parentStyle.getResolved();
            for (int i = 0; i < 7; ++i) {
                if (this.isSet[i] || !parentStyle.isSet[i]) continue;
                resolved.isSet[i] = true;
                resolved.value[i] = parentStyle.value[i];
            }
        }
        return resolved;
    }

    private static String toCSV(String value) {
        if (value != null) {
            return "\"" + value + "\",";
        }
        return "\"\",";
    }

    private static String toLastCSV(String value) {
        if (value != null) {
            return "\"" + value + "\"";
        }
        return "\"\"";
    }

    public static void dumpHdr() {
        System.out.println(ParaStyle.toCSV("Name") + ParaStyle.toCSV("Family") + ParaStyle.toCSV("parent") + ParaStyle.toCSV("left mgn") + ParaStyle.toCSV("right mgn") + ParaStyle.toCSV("top mgn") + ParaStyle.toCSV("bottom mgn") + ParaStyle.toCSV("txt indent") + ParaStyle.toCSV("line height") + ParaStyle.toLastCSV("txt align"));
    }

    public void dumpCSV() {
        String attributes = "";
        for (int index = 0; index <= 6; ++index) {
            attributes = this.isSet[index] ? attributes + ParaStyle.toCSV("" + this.value[index]) : attributes + ParaStyle.toCSV(null);
        }
        System.out.println(ParaStyle.toCSV(this.name) + ParaStyle.toCSV(this.family) + ParaStyle.toCSV(this.parent) + attributes + ParaStyle.toLastCSV(null));
    }

    @Override
    public Node createNode(Document parentDoc, String name) {
        Element node = parentDoc.createElement(name);
        this.writeAttributes(node);
        return node;
    }

    @Override
    public boolean isSubset(Style style) {
        if (!super.isSubset(style)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(style.getClass())) {
            return false;
        }
        ParaStyle ps = (ParaStyle)style;
        for (int i = 0; i < 7; ++i) {
            int diff;
            if (!ps.isSet[i] || !(i < 6 ? (diff = this.value[i] > ps.value[i] ? this.value[i] - ps.value[i] : ps.value[i] - this.value[i]) > 32 : (i != 6 || this.value[i] != 0 || ps.value[i] != 4) && this.value[i] != ps.value[i])) continue;
            return false;
        }
        return true;
    }

    private void writeAttributes(Element node) {
        double temp;
        for (int i = 0; i <= 4; ++i) {
            if (!this.isSet[i]) continue;
            temp = (double)this.value[i] / 100.0;
            String stringVal = Double.toString(temp) + "mm";
            node.setAttribute(this.attrName[i], stringVal);
        }
        if (this.isSet[5]) {
            String stringVal;
            if ((this.value[5] & 0x40000000) != 0) {
                stringVal = Integer.toString(this.value[5] & 0xFFFFFF) + "%";
            } else {
                temp = (double)(this.value[5] & 0xFFFFFF) / 100.0;
                stringVal = Double.toString(temp) + "mm";
            }
            node.setAttribute(this.attrName[5], stringVal);
        }
        if (this.isSet[6]) {
            String val;
            switch (this.value[6]) {
                case 1: {
                    val = "end";
                    break;
                }
                case 2: {
                    val = "center";
                    break;
                }
                case 3: {
                    val = "justify";
                    break;
                }
                case 4: {
                    val = "left";
                    break;
                }
                default: {
                    val = "unknown";
                }
            }
            node.setAttribute(this.attrName[6], val);
        }
    }
}

