/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;

public class DEGTBehavior
extends AbsGTBehavior {
    private static final int DVNum = 2;
    public double MIN_FACTOR = 0.5;
    public double MAX_FACTOR = 0.5;
    public double CR = 0.9;

    @Override
    public void setMemPoints(SearchPoint pbest, BasicPoint pcurrent, BasicPoint pold) {
        this.pbest_t = pbest;
    }

    private void crossoverAndMutation(int index, double[] trialVector, double[] globalVector, BasicPoint[] differenceVectors) {
        double delta = 0.0;
        for (int i = 0; i < differenceVectors.length; ++i) {
            delta += (i % 2 == 0 ? 1.0 : -1.0) * differenceVectors[i].getLocation()[index];
        }
        trialVector[index] = globalVector[index] + RandomGenerator.doubleRangeRandom(this.MIN_FACTOR, this.MAX_FACTOR) * delta;
    }

    @Override
    public void generateBehavior(SearchPoint trailPoint, ProblemEncoder problemEncoder) {
        int index;
        BasicPoint[] referPoints = this.getReferPoints();
        int DIMENSION = problemEncoder.getDesignSpace().getDimension();
        int guaranteeIndex = RandomGenerator.intRangeRandom(0, DIMENSION - 1);
        double[] trailVector = trailPoint.getLocation();
        double[] locaclVector = this.pbest_t.getLocation();
        double[] globalVector = this.socialLib.getGbest().getLocation();
        for (index = 0; index < guaranteeIndex; ++index) {
            if (this.CR <= RandomGenerator.doubleZeroOneRandom()) {
                trailVector[index] = locaclVector[index];
                continue;
            }
            this.crossoverAndMutation(index, trailVector, globalVector, referPoints);
        }
        this.crossoverAndMutation(guaranteeIndex, trailVector, globalVector, referPoints);
        for (index = guaranteeIndex + 1; index < DIMENSION; ++index) {
            if (this.CR <= RandomGenerator.doubleZeroOneRandom()) {
                trailVector[index] = locaclVector[index];
                continue;
            }
            this.crossoverAndMutation(index, trailVector, globalVector, referPoints);
        }
    }

    @Override
    public void testBehavior(SearchPoint trailPoint, IGoodnessCompareEngine qualityComparator) {
        Library.replace(qualityComparator, trailPoint, this.pbest_t);
    }

    private SearchPoint[] getReferPoints() {
        SearchPoint[] referPoints = new SearchPoint[4];
        for (int i = 0; i < referPoints.length; ++i) {
            referPoints[i] = this.socialLib.getRandomPoint();
        }
        return referPoints;
    }
}

