/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "photos-mpris-player.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2.Player
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MprisPlayer
 * @title: MprisPlayer
 * @short_description: Generated C code for the org.mpris.MediaPlayer2.Player D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.mpris.MediaPlayer2.Player ---- */

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_player_method_info_seek_IN_ARG_Offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_player_method_info_seek_IN_ARG_pointers[] =
{
  &_mpris_player_method_info_seek_IN_ARG_Offset.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_seek =
{
  {
    -1,
    (gchar *) "Seek",
    (GDBusArgInfo **) &_mpris_player_method_info_seek_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-seek",
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_player_method_info_set_position_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_player_method_info_set_position_IN_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_player_method_info_set_position_IN_ARG_pointers[] =
{
  &_mpris_player_method_info_set_position_IN_ARG_TrackId.parent_struct,
  &_mpris_player_method_info_set_position_IN_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_set_position =
{
  {
    -1,
    (gchar *) "SetPosition",
    (GDBusArgInfo **) &_mpris_player_method_info_set_position_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-position",
  FALSE
};

static const _ExtendedGDBusArgInfo _mpris_player_method_info_open_uri_IN_ARG_Uri =
{
  {
    -1,
    (gchar *) "Uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_player_method_info_open_uri_IN_ARG_pointers[] =
{
  &_mpris_player_method_info_open_uri_IN_ARG_Uri.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mpris_player_method_info_open_uri =
{
  {
    -1,
    (gchar *) "OpenUri",
    (GDBusArgInfo **) &_mpris_player_method_info_open_uri_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-uri",
  FALSE
};

static const GDBusMethodInfo * const _mpris_player_method_info_pointers[] =
{
  &_mpris_player_method_info_next.parent_struct,
  &_mpris_player_method_info_previous.parent_struct,
  &_mpris_player_method_info_pause.parent_struct,
  &_mpris_player_method_info_play_pause.parent_struct,
  &_mpris_player_method_info_stop.parent_struct,
  &_mpris_player_method_info_play.parent_struct,
  &_mpris_player_method_info_seek.parent_struct,
  &_mpris_player_method_info_set_position.parent_struct,
  &_mpris_player_method_info_open_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mpris_player_signal_info_seeked_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mpris_player_signal_info_seeked_ARG_pointers[] =
{
  &_mpris_player_signal_info_seeked_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mpris_player_signal_info_seeked =
{
  {
    -1,
    (gchar *) "Seeked",
    (GDBusArgInfo **) &_mpris_player_signal_info_seeked_ARG_pointers,
    NULL
  },
  "seeked"
};

static const GDBusSignalInfo * const _mpris_player_signal_info_pointers[] =
{
  &_mpris_player_signal_info_seeked.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _mpris_player_property_playback_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_playback_status_annotation_info_pointers[] =
{
  &_mpris_player_property_playback_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_playback_status =
{
  {
    -1,
    (gchar *) "PlaybackStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_playback_status_annotation_info_pointers
  },
  "playback-status",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_loop_status_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_loop_status_annotation_info_pointers[] =
{
  &_mpris_player_property_loop_status_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_loop_status =
{
  {
    -1,
    (gchar *) "LoopStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_loop_status_annotation_info_pointers
  },
  "loop-status",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_rate_annotation_info_pointers[] =
{
  &_mpris_player_property_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_rate =
{
  {
    -1,
    (gchar *) "Rate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_rate_annotation_info_pointers
  },
  "rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_shuffle_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_shuffle_annotation_info_pointers[] =
{
  &_mpris_player_property_shuffle_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_shuffle_annotation_info_pointers
  },
  "shuffle",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_metadata_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_metadata_annotation_info_pointers[] =
{
  &_mpris_player_property_metadata_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_metadata_annotation_info_pointers
  },
  "metadata",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_volume_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_volume_annotation_info_pointers[] =
{
  &_mpris_player_property_volume_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_volume_annotation_info_pointers
  },
  "volume",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_position_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_position_annotation_info_pointers[] =
{
  &_mpris_player_property_position_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_position_annotation_info_pointers
  },
  "position",
  FALSE,
  FALSE
};

static const GDBusAnnotationInfo _mpris_player_property_minimum_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_minimum_rate_annotation_info_pointers[] =
{
  &_mpris_player_property_minimum_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_minimum_rate =
{
  {
    -1,
    (gchar *) "MinimumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_minimum_rate_annotation_info_pointers
  },
  "minimum-rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_maximum_rate_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_maximum_rate_annotation_info_pointers[] =
{
  &_mpris_player_property_maximum_rate_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_maximum_rate =
{
  {
    -1,
    (gchar *) "MaximumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_maximum_rate_annotation_info_pointers
  },
  "maximum-rate",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_go_next_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_go_next_annotation_info_pointers[] =
{
  &_mpris_player_property_can_go_next_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_go_next =
{
  {
    -1,
    (gchar *) "CanGoNext",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_go_next_annotation_info_pointers
  },
  "can-go-next",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_go_previous_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_go_previous_annotation_info_pointers[] =
{
  &_mpris_player_property_can_go_previous_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_go_previous =
{
  {
    -1,
    (gchar *) "CanGoPrevious",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_go_previous_annotation_info_pointers
  },
  "can-go-previous",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_play_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_play_annotation_info_pointers[] =
{
  &_mpris_player_property_can_play_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_play =
{
  {
    -1,
    (gchar *) "CanPlay",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_play_annotation_info_pointers
  },
  "can-play",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_pause_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_pause_annotation_info_pointers[] =
{
  &_mpris_player_property_can_pause_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_pause =
{
  {
    -1,
    (gchar *) "CanPause",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_pause_annotation_info_pointers
  },
  "can-pause",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_seek_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "true",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_seek_annotation_info_pointers[] =
{
  &_mpris_player_property_can_seek_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_seek =
{
  {
    -1,
    (gchar *) "CanSeek",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_seek_annotation_info_pointers
  },
  "can-seek",
  FALSE,
  TRUE
};

static const GDBusAnnotationInfo _mpris_player_property_can_control_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.Property.EmitsChangedSignal",
  (gchar *) "false",
  NULL
};

static const GDBusAnnotationInfo * const _mpris_player_property_can_control_annotation_info_pointers[] =
{
  &_mpris_player_property_can_control_annotation_info_0,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mpris_player_property_info_can_control =
{
  {
    -1,
    (gchar *) "CanControl",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    (GDBusAnnotationInfo **) &_mpris_player_property_can_control_annotation_info_pointers
  },
  "can-control",
  FALSE,
  FALSE
};

static const GDBusPropertyInfo * const _mpris_player_property_info_pointers[] =
{
  &_mpris_player_property_info_playback_status.parent_struct,
  &_mpris_player_property_info_loop_status.parent_struct,
  &_mpris_player_property_info_rate.parent_struct,
  &_mpris_player_property_info_shuffle.parent_struct,
  &_mpris_player_property_info_metadata.parent_struct,
  &_mpris_player_property_info_volume.parent_struct,
  &_mpris_player_property_info_position.parent_struct,
  &_mpris_player_property_info_minimum_rate.parent_struct,
  &_mpris_player_property_info_maximum_rate.parent_struct,
  &_mpris_player_property_info_can_go_next.parent_struct,
  &_mpris_player_property_info_can_go_previous.parent_struct,
  &_mpris_player_property_info_can_play.parent_struct,
  &_mpris_player_property_info_can_pause.parent_struct,
  &_mpris_player_property_info_can_seek.parent_struct,
  &_mpris_player_property_info_can_control.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mpris_player_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2.Player",
    (GDBusMethodInfo **) &_mpris_player_method_info_pointers,
    (GDBusSignalInfo **) &_mpris_player_signal_info_pointers,
    (GDBusPropertyInfo **) &_mpris_player_property_info_pointers,
    NULL
  },
  "player",
};


/**
 * mpris_player_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mpris_player_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct;
}

/**
 * mpris_player_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MprisPlayer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mpris_player_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "playback-status");
  g_object_class_override_property (klass, property_id_begin++, "loop-status");
  g_object_class_override_property (klass, property_id_begin++, "rate");
  g_object_class_override_property (klass, property_id_begin++, "shuffle");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  g_object_class_override_property (klass, property_id_begin++, "position");
  g_object_class_override_property (klass, property_id_begin++, "minimum-rate");
  g_object_class_override_property (klass, property_id_begin++, "maximum-rate");
  g_object_class_override_property (klass, property_id_begin++, "can-go-next");
  g_object_class_override_property (klass, property_id_begin++, "can-go-previous");
  g_object_class_override_property (klass, property_id_begin++, "can-play");
  g_object_class_override_property (klass, property_id_begin++, "can-pause");
  g_object_class_override_property (klass, property_id_begin++, "can-seek");
  g_object_class_override_property (klass, property_id_begin++, "can-control");
  return property_id_begin - 1;
}



/**
 * MprisPlayer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

/**
 * MprisPlayerIface:
 * @parent_iface: The parent interface.
 * @handle_next: Handler for the #MprisPlayer::handle-next signal.
 * @handle_open_uri: Handler for the #MprisPlayer::handle-open-uri signal.
 * @handle_pause: Handler for the #MprisPlayer::handle-pause signal.
 * @handle_play: Handler for the #MprisPlayer::handle-play signal.
 * @handle_play_pause: Handler for the #MprisPlayer::handle-play-pause signal.
 * @handle_previous: Handler for the #MprisPlayer::handle-previous signal.
 * @handle_seek: Handler for the #MprisPlayer::handle-seek signal.
 * @handle_set_position: Handler for the #MprisPlayer::handle-set-position signal.
 * @handle_stop: Handler for the #MprisPlayer::handle-stop signal.
 * @get_can_control: Getter for the #MprisPlayer:can-control property.
 * @get_can_go_next: Getter for the #MprisPlayer:can-go-next property.
 * @get_can_go_previous: Getter for the #MprisPlayer:can-go-previous property.
 * @get_can_pause: Getter for the #MprisPlayer:can-pause property.
 * @get_can_play: Getter for the #MprisPlayer:can-play property.
 * @get_can_seek: Getter for the #MprisPlayer:can-seek property.
 * @get_loop_status: Getter for the #MprisPlayer:loop-status property.
 * @get_maximum_rate: Getter for the #MprisPlayer:maximum-rate property.
 * @get_metadata: Getter for the #MprisPlayer:metadata property.
 * @get_minimum_rate: Getter for the #MprisPlayer:minimum-rate property.
 * @get_playback_status: Getter for the #MprisPlayer:playback-status property.
 * @get_position: Getter for the #MprisPlayer:position property.
 * @get_rate: Getter for the #MprisPlayer:rate property.
 * @get_shuffle: Getter for the #MprisPlayer:shuffle property.
 * @get_volume: Getter for the #MprisPlayer:volume property.
 * @seeked: Handler for the #MprisPlayer::seeked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

typedef MprisPlayerIface MprisPlayerInterface;
G_DEFINE_INTERFACE (MprisPlayer, mpris_player, G_TYPE_OBJECT)

static void
mpris_player_default_init (MprisPlayerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MprisPlayer::handle-next:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-previous:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-pause:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-play-pause:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-stop:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-play:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MprisPlayer::handle-seek:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Offset: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_seek() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-seek",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_seek),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64);

  /**
   * MprisPlayer::handle-set-position:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   * @arg_Position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_set_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_set_position),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT64);

  /**
   * MprisPlayer::handle-open-uri:
   * @object: A #MprisPlayer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Uri: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mpris_player_complete_open_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, handle_open_uri),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * MprisPlayer::seeked:
   * @object: A #MprisPlayer.
   * @arg_Position: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("seeked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MprisPlayerIface, seeked),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_INT64);

  /* GObject properties for D-Bus properties: */
  /**
   * MprisPlayer:playback-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playback-status", "PlaybackStatus", "PlaybackStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:loop-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("loop-status", "LoopStatus", "LoopStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("rate", "Rate", "Rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:shuffle:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("shuffle", "Shuffle", "Shuffle", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("metadata", "Metadata", "Metadata", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("volume", "Volume", "Volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("position", "Position", "Position", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:minimum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("minimum-rate", "MinimumRate", "MinimumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:maximum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("maximum-rate", "MaximumRate", "MaximumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-go-next:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-next", "CanGoNext", "CanGoNext", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-go-previous:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-previous", "CanGoPrevious", "CanGoPrevious", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-play:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-play", "CanPlay", "CanPlay", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-pause:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-pause", "CanPause", "CanPause", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-seek:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-seek", "CanSeek", "CanSeek", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MprisPlayer:can-control:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-control", "CanControl", "CanControl", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mpris_player_get_playback_status: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mpris_player_dup_playback_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mpris_player_get_playback_status (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_playback_status (object);
}

/**
 * mpris_player_dup_playback_status: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mpris_player_dup_playback_status (MprisPlayer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playback-status", &value, NULL);
  return value;
}

/**
 * mpris_player_set_playback_status: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_playback_status (MprisPlayer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playback-status", value, NULL);
}

/**
 * mpris_player_get_loop_status: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mpris_player_dup_loop_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mpris_player_get_loop_status (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_loop_status (object);
}

/**
 * mpris_player_dup_loop_status: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mpris_player_dup_loop_status (MprisPlayer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "loop-status", &value, NULL);
  return value;
}

/**
 * mpris_player_set_loop_status: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
mpris_player_set_loop_status (MprisPlayer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "loop-status", value, NULL);
}

/**
 * mpris_player_get_rate: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
mpris_player_get_rate (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_rate (object);
}

/**
 * mpris_player_set_rate: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
mpris_player_set_rate (MprisPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "rate", value, NULL);
}

/**
 * mpris_player_get_shuffle: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_shuffle (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_shuffle (object);
}

/**
 * mpris_player_set_shuffle: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
mpris_player_set_shuffle (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "shuffle", value, NULL);
}

/**
 * mpris_player_get_metadata: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mpris_player_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mpris_player_get_metadata (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_metadata (object);
}

/**
 * mpris_player_dup_metadata: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mpris_player_dup_metadata (MprisPlayer *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * mpris_player_set_metadata: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_metadata (MprisPlayer *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * mpris_player_get_volume: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
mpris_player_get_volume (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_volume (object);
}

/**
 * mpris_player_set_volume: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
mpris_player_set_volume (MprisPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * mpris_player_get_position: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
mpris_player_get_position (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_position (object);
}

/**
 * mpris_player_set_position: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_position (MprisPlayer *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "position", value, NULL);
}

/**
 * mpris_player_get_minimum_rate: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
mpris_player_get_minimum_rate (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_minimum_rate (object);
}

/**
 * mpris_player_set_minimum_rate: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_minimum_rate (MprisPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "minimum-rate", value, NULL);
}

/**
 * mpris_player_get_maximum_rate: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
mpris_player_get_maximum_rate (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_maximum_rate (object);
}

/**
 * mpris_player_set_maximum_rate: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_maximum_rate (MprisPlayer *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "maximum-rate", value, NULL);
}

/**
 * mpris_player_get_can_go_next: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_go_next (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_go_next (object);
}

/**
 * mpris_player_set_can_go_next: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_go_next (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-next", value, NULL);
}

/**
 * mpris_player_get_can_go_previous: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_go_previous (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_go_previous (object);
}

/**
 * mpris_player_set_can_go_previous: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_go_previous (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-previous", value, NULL);
}

/**
 * mpris_player_get_can_play: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_play (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_play (object);
}

/**
 * mpris_player_set_can_play: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_play (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-play", value, NULL);
}

/**
 * mpris_player_get_can_pause: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_pause (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_pause (object);
}

/**
 * mpris_player_set_can_pause: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_pause (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-pause", value, NULL);
}

/**
 * mpris_player_get_can_seek: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_seek (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_seek (object);
}

/**
 * mpris_player_set_can_seek: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_seek (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-seek", value, NULL);
}

/**
 * mpris_player_get_can_control: (skip)
 * @object: A #MprisPlayer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mpris_player_get_can_control (MprisPlayer *object)
{
  return MPRIS_PLAYER_GET_IFACE (object)->get_can_control (object);
}

/**
 * mpris_player_set_can_control: (skip)
 * @object: A #MprisPlayer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mpris_player_set_can_control (MprisPlayer *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-control", value, NULL);
}

/**
 * mpris_player_emit_seeked:
 * @object: A #MprisPlayer.
 * @arg_Position: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> D-Bus signal.
 */
void
mpris_player_emit_seeked (
    MprisPlayer *object,
    gint64 arg_Position)
{
  g_signal_emit_by_name (object, "seeked", arg_Position);
}

/**
 * mpris_player_call_next:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_next_finish() to get the result of the operation.
 *
 * See mpris_player_call_next_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_next (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_next_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_next_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_next_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_next_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_previous:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_previous_finish() to get the result of the operation.
 *
 * See mpris_player_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_previous (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_previous_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_previous_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_previous_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_previous_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_pause:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_pause_finish() to get the result of the operation.
 *
 * See mpris_player_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_pause (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_pause_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_pause_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_pause_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_pause_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_play_pause:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_play_pause_finish() to get the result of the operation.
 *
 * See mpris_player_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_play_pause (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_play_pause_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_play_pause_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_play_pause_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_play_pause_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_stop:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_stop_finish() to get the result of the operation.
 *
 * See mpris_player_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_stop (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_stop_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_stop_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_stop_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_stop_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_play:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_play_finish() to get the result of the operation.
 *
 * See mpris_player_call_play_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_play (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_play_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_play_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_play_sync:
 * @proxy: A #MprisPlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_play_sync (
    MprisPlayer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_seek:
 * @proxy: A #MprisPlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_seek_finish() to get the result of the operation.
 *
 * See mpris_player_call_seek_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_seek (
    MprisPlayer *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_seek_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_seek().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_seek().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_seek_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_seek_sync:
 * @proxy: A #MprisPlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_seek() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_seek_sync (
    MprisPlayer *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_set_position:
 * @proxy: A #MprisPlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_set_position_finish() to get the result of the operation.
 *
 * See mpris_player_call_set_position_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_set_position (
    MprisPlayer *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_set_position_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_set_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_set_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_set_position_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_set_position_sync:
 * @proxy: A #MprisPlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_set_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_set_position_sync (
    MprisPlayer *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_open_uri:
 * @proxy: A #MprisPlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_call_open_uri_finish() to get the result of the operation.
 *
 * See mpris_player_call_open_uri_sync() for the synchronous, blocking version of this method.
 */
void
mpris_player_call_open_uri (
    MprisPlayer *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mpris_player_call_open_uri_finish:
 * @proxy: A #MprisPlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_call_open_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mpris_player_call_open_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_open_uri_finish (
    MprisPlayer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_call_open_uri_sync:
 * @proxy: A #MprisPlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mpris_player_call_open_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mpris_player_call_open_uri_sync (
    MprisPlayer *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mpris_player_complete_next:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_next (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_previous:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_previous (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_pause:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_pause (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_play_pause:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_play_pause (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_stop:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_stop (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_play:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_play (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_seek:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_seek (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_set_position:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_set_position (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mpris_player_complete_open_uri:
 * @object: A #MprisPlayer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mpris_player_complete_open_uri (
    MprisPlayer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MprisPlayerProxy:
 *
 * The #MprisPlayerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MprisPlayerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MprisPlayerProxy.
 */

struct _MprisPlayerProxyPrivate
{
  GData *qdata;
};

static void mpris_player_proxy_iface_init (MprisPlayerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MprisPlayerProxy, mpris_player_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MprisPlayerProxy)
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_PLAYER, mpris_player_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MprisPlayerProxy, mpris_player_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_PLAYER, mpris_player_proxy_iface_init))

#endif
static void
mpris_player_proxy_finalize (GObject *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mpris_player_proxy_parent_class)->finalize (object);
}

static void
mpris_player_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mpris_player_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2.Player: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mpris_player_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2.Player", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mpris_player_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mpris_player_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MPRIS_TYPE_PLAYER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MPRIS_TYPE_PLAYER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mpris_player_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
mpris_player_proxy_get_playback_status (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlaybackStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mpris_player_proxy_get_loop_status (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoopStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
mpris_player_proxy_get_rate (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Rate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_shuffle (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shuffle");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mpris_player_proxy_get_metadata (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gdouble 
mpris_player_proxy_get_volume (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
mpris_player_proxy_get_position (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Position");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
mpris_player_proxy_get_minimum_rate (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MinimumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
mpris_player_proxy_get_maximum_rate (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MaximumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_go_next (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoNext");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_go_previous (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoPrevious");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_play (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPlay");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_pause (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPause");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_seek (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSeek");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
mpris_player_proxy_get_can_control (MprisPlayer *object)
{
  MprisPlayerProxy *proxy = MPRIS_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanControl");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mpris_player_proxy_init (MprisPlayerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mpris_player_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MPRIS_TYPE_PLAYER_PROXY, MprisPlayerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mpris_player_interface_info ());
}

static void
mpris_player_proxy_class_init (MprisPlayerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mpris_player_proxy_finalize;
  gobject_class->get_property = mpris_player_proxy_get_property;
  gobject_class->set_property = mpris_player_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mpris_player_proxy_g_signal;
  proxy_class->g_properties_changed = mpris_player_proxy_g_properties_changed;

  mpris_player_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MprisPlayerProxyPrivate));
#endif
}

static void
mpris_player_proxy_iface_init (MprisPlayerIface *iface)
{
  iface->get_playback_status = mpris_player_proxy_get_playback_status;
  iface->get_loop_status = mpris_player_proxy_get_loop_status;
  iface->get_rate = mpris_player_proxy_get_rate;
  iface->get_shuffle = mpris_player_proxy_get_shuffle;
  iface->get_metadata = mpris_player_proxy_get_metadata;
  iface->get_volume = mpris_player_proxy_get_volume;
  iface->get_position = mpris_player_proxy_get_position;
  iface->get_minimum_rate = mpris_player_proxy_get_minimum_rate;
  iface->get_maximum_rate = mpris_player_proxy_get_maximum_rate;
  iface->get_can_go_next = mpris_player_proxy_get_can_go_next;
  iface->get_can_go_previous = mpris_player_proxy_get_can_go_previous;
  iface->get_can_play = mpris_player_proxy_get_can_play;
  iface->get_can_pause = mpris_player_proxy_get_can_pause;
  iface->get_can_seek = mpris_player_proxy_get_can_seek;
  iface->get_can_control = mpris_player_proxy_get_can_control;
}

/**
 * mpris_player_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_proxy_new_finish() to get the result of the operation.
 *
 * See mpris_player_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mpris_player_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MPRIS_TYPE_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * mpris_player_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mpris_player_proxy_new().
 *
 * Returns: (transfer full) (type MprisPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisPlayer *
mpris_player_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MPRIS_PLAYER (ret);
  else
    return NULL;
}

/**
 * mpris_player_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mpris_player_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MprisPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisPlayer *
mpris_player_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MPRIS_TYPE_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return MPRIS_PLAYER (ret);
  else
    return NULL;
}


/**
 * mpris_player_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mpris_player_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mpris_player_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mpris_player_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mpris_player_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MPRIS_TYPE_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * mpris_player_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mpris_player_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mpris_player_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MprisPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisPlayer *
mpris_player_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MPRIS_PLAYER (ret);
  else
    return NULL;
}

/**
 * mpris_player_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mpris_player_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mpris_player_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MprisPlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
MprisPlayer *
mpris_player_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MPRIS_TYPE_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return MPRIS_PLAYER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MprisPlayerSkeleton:
 *
 * The #MprisPlayerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MprisPlayerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MprisPlayerSkeleton.
 */

struct _MprisPlayerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mpris_player_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MPRIS_TYPE_PLAYER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MPRIS_TYPE_PLAYER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mpris_player_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mpris_player_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mpris_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mpris_player_skeleton_vtable =
{
  _mpris_player_skeleton_handle_method_call,
  _mpris_player_skeleton_handle_get_property,
  _mpris_player_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mpris_player_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mpris_player_interface_info ();
}

static GDBusInterfaceVTable *
mpris_player_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mpris_player_skeleton_vtable;
}

static GVariant *
mpris_player_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_mpris_player_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mpris_player_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mpris_player_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mpris_player_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mpris_player_emit_changed (gpointer user_data);

static void
mpris_player_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mpris_player_emit_changed (skeleton);
}

static void
_mpris_player_on_signal_seeked (
    MprisPlayer *object,
    gint64 arg_Position)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(x)",
                   arg_Position));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", "Seeked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mpris_player_skeleton_iface_init (MprisPlayerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MprisPlayerSkeleton, mpris_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MprisPlayerSkeleton)
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_PLAYER, mpris_player_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MprisPlayerSkeleton, mpris_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MPRIS_TYPE_PLAYER, mpris_player_skeleton_iface_init))

#endif
static void
mpris_player_skeleton_finalize (GObject *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  guint n;
  for (n = 0; n < 15; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mpris_player_skeleton_parent_class)->finalize (object);
}

static void
mpris_player_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mpris_player_emit_changed (gpointer user_data)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.Player",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mpris_player_schedule_emit_changed (MprisPlayerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mpris_player_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mpris_player_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mpris_player_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mpris_player_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _mpris_player_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mpris_player_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mpris_player_skeleton_init (MprisPlayerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mpris_player_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MPRIS_TYPE_PLAYER_SKELETON, MprisPlayerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 15);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_BOOLEAN);
}

static const gchar *
mpris_player_skeleton_get_playback_status (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mpris_player_skeleton_get_loop_status (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
mpris_player_skeleton_get_rate (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_shuffle (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mpris_player_skeleton_get_metadata (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
mpris_player_skeleton_get_volume (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
mpris_player_skeleton_get_position (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int64 (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
mpris_player_skeleton_get_minimum_rate (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
mpris_player_skeleton_get_maximum_rate (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_go_next (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_go_previous (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_play (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_pause (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_seek (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
mpris_player_skeleton_get_can_control (MprisPlayer *object)
{
  MprisPlayerSkeleton *skeleton = MPRIS_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mpris_player_skeleton_class_init (MprisPlayerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mpris_player_skeleton_finalize;
  gobject_class->get_property = mpris_player_skeleton_get_property;
  gobject_class->set_property = mpris_player_skeleton_set_property;
  gobject_class->notify       = mpris_player_skeleton_notify;


  mpris_player_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mpris_player_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mpris_player_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mpris_player_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mpris_player_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MprisPlayerSkeletonPrivate));
#endif
}

static void
mpris_player_skeleton_iface_init (MprisPlayerIface *iface)
{
  iface->seeked = _mpris_player_on_signal_seeked;
  iface->get_playback_status = mpris_player_skeleton_get_playback_status;
  iface->get_loop_status = mpris_player_skeleton_get_loop_status;
  iface->get_rate = mpris_player_skeleton_get_rate;
  iface->get_shuffle = mpris_player_skeleton_get_shuffle;
  iface->get_metadata = mpris_player_skeleton_get_metadata;
  iface->get_volume = mpris_player_skeleton_get_volume;
  iface->get_position = mpris_player_skeleton_get_position;
  iface->get_minimum_rate = mpris_player_skeleton_get_minimum_rate;
  iface->get_maximum_rate = mpris_player_skeleton_get_maximum_rate;
  iface->get_can_go_next = mpris_player_skeleton_get_can_go_next;
  iface->get_can_go_previous = mpris_player_skeleton_get_can_go_previous;
  iface->get_can_play = mpris_player_skeleton_get_can_play;
  iface->get_can_pause = mpris_player_skeleton_get_can_pause;
  iface->get_can_seek = mpris_player_skeleton_get_can_seek;
  iface->get_can_control = mpris_player_skeleton_get_can_control;
}

/**
 * mpris_player_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 *
 * Returns: (transfer full) (type MprisPlayerSkeleton): The skeleton object.
 */
MprisPlayer *
mpris_player_skeleton_new (void)
{
  return MPRIS_PLAYER (g_object_new (MPRIS_TYPE_PLAYER_SKELETON, NULL));
}

