/* alarm-setup-dialog.c generated by valac 0.56.0, the Vala compiler
 * generated from alarm-setup-dialog.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Zander Brown <zbrown@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>

#define CLOCKS_ALARM_DELETE_ALARM 2
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_ALARM_TYPE_DURATION (clocks_alarm_duration_get_type ())
#define CLOCKS_ALARM_DURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration))
#define CLOCKS_ALARM_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDurationClass))
#define CLOCKS_ALARM_IS_DURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_DURATION))
#define CLOCKS_ALARM_IS_DURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_DURATION))
#define CLOCKS_ALARM_DURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDurationClass))

typedef struct _ClocksAlarmDuration ClocksAlarmDuration;
typedef struct _ClocksAlarmDurationClass ClocksAlarmDurationClass;
typedef struct _ClocksAlarmDurationPrivate ClocksAlarmDurationPrivate;
enum  {
	CLOCKS_ALARM_DURATION_0_PROPERTY,
	CLOCKS_ALARM_DURATION_MINUTES_PROPERTY,
	CLOCKS_ALARM_DURATION_LABEL_PROPERTY,
	CLOCKS_ALARM_DURATION_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_duration_properties[CLOCKS_ALARM_DURATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define CLOCKS_ALARM_TYPE_DURATION_MODEL (clocks_alarm_duration_model_get_type ())
#define CLOCKS_ALARM_DURATION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_DURATION_MODEL, ClocksAlarmDurationModel))
#define CLOCKS_ALARM_DURATION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_DURATION_MODEL, ClocksAlarmDurationModelClass))
#define CLOCKS_ALARM_IS_DURATION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_DURATION_MODEL))
#define CLOCKS_ALARM_IS_DURATION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_DURATION_MODEL))
#define CLOCKS_ALARM_DURATION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_DURATION_MODEL, ClocksAlarmDurationModelClass))

typedef struct _ClocksAlarmDurationModel ClocksAlarmDurationModel;
typedef struct _ClocksAlarmDurationModelClass ClocksAlarmDurationModelClass;
typedef struct _ClocksAlarmDurationModelPrivate ClocksAlarmDurationModelPrivate;
enum  {
	CLOCKS_ALARM_DURATION_MODEL_0_PROPERTY,
	CLOCKS_ALARM_DURATION_MODEL_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_duration_model_properties[CLOCKS_ALARM_DURATION_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_ALARM_TYPE_SETUP_DIALOG (clocks_alarm_setup_dialog_get_type ())
#define CLOCKS_ALARM_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog))
#define CLOCKS_ALARM_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))
#define CLOCKS_ALARM_IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))

typedef struct _ClocksAlarmSetupDialog ClocksAlarmSetupDialog;
typedef struct _ClocksAlarmSetupDialogClass ClocksAlarmSetupDialogClass;
typedef struct _ClocksAlarmSetupDialogPrivate ClocksAlarmSetupDialogPrivate;
typedef enum  {
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR
} ClocksUtilsWallClockFormat;

#define CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT (clocks_utils_wall_clock_format_get_type ())

#define CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON (clocks_am_pm_toggle_button_get_type ())
#define CLOCKS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))

typedef struct _ClocksAmPmToggleButton ClocksAmPmToggleButton;
typedef struct _ClocksAmPmToggleButtonClass ClocksAmPmToggleButtonClass;

#define CLOCKS_ALARM_TYPE_DAY_PICKER_ROW (clocks_alarm_day_picker_row_get_type ())
#define CLOCKS_ALARM_DAY_PICKER_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow))
#define CLOCKS_ALARM_DAY_PICKER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRowClass))
#define CLOCKS_ALARM_IS_DAY_PICKER_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW))
#define CLOCKS_ALARM_IS_DAY_PICKER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW))
#define CLOCKS_ALARM_DAY_PICKER_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRowClass))

typedef struct _ClocksAlarmDayPickerRow ClocksAlarmDayPickerRow;
typedef struct _ClocksAlarmDayPickerRowClass ClocksAlarmDayPickerRowClass;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
enum  {
	CLOCKS_ALARM_SETUP_DIALOG_0_PROPERTY,
	CLOCKS_ALARM_SETUP_DIALOG_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_setup_dialog_properties[CLOCKS_ALARM_SETUP_DIALOG_NUM_PROPERTIES];

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_ALARM_TYPE_ALARM_TIME (clocks_alarm_alarm_time_get_type ())
typedef struct _ClocksAlarmAlarmTime ClocksAlarmAlarmTime;
typedef enum  {
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM,
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM
} ClocksAmPmToggleButtonAmPm;

#define CLOCKS_AM_PM_TOGGLE_BUTTON_TYPE_AM_PM (clocks_am_pm_toggle_button_am_pm_get_type ())
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))

struct _ClocksAlarmDuration {
	GObject parent_instance;
	ClocksAlarmDurationPrivate * priv;
};

struct _ClocksAlarmDurationClass {
	GObjectClass parent_class;
};

struct _ClocksAlarmDurationPrivate {
	gint _minutes;
	gchar* _label;
};

struct _ClocksAlarmDurationModel {
	GObject parent_instance;
	ClocksAlarmDurationModelPrivate * priv;
};

struct _ClocksAlarmDurationModelClass {
	GObjectClass parent_class;
};

struct _ClocksAlarmDurationModelPrivate {
	ClocksAlarmDuration* store[6];
};

struct _ClocksAlarmSetupDialog {
	GtkDialog parent_instance;
	ClocksAlarmSetupDialogPrivate * priv;
};

struct _ClocksAlarmSetupDialogClass {
	GtkDialogClass parent_class;
};

struct _ClocksAlarmSetupDialogPrivate {
	ClocksUtilsWallClockFormat format;
	GtkBox* time_box;
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkEntry* name_entry;
	AdwComboRow* snooze_duration;
	AdwComboRow* ring_duration;
	ClocksAmPmToggleButton* am_pm_button;
	ClocksAlarmDayPickerRow* repeats;
	AdwBin* am_pm_bin;
	GtkRevealer* label_revealer;
	GtkButton* delete_button;
	GList* other_alarms;
	ClocksAlarmDurationModel* duration_model;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksAlarmAlarmTime {
	gint hour;
	gint minute;
};

static gint ClocksAlarmDuration_private_offset;
static gpointer clocks_alarm_duration_parent_class = NULL;
static gint ClocksAlarmDurationModel_private_offset;
static gpointer clocks_alarm_duration_model_parent_class = NULL;
static GListModelInterface * clocks_alarm_duration_model_g_list_model_parent_iface = NULL;
static gint ClocksAlarmSetupDialog_private_offset;
static gpointer clocks_alarm_setup_dialog_parent_class = NULL;

VALA_EXTERN GType clocks_alarm_duration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmDuration, g_object_unref)
VALA_EXTERN ClocksAlarmDuration* clocks_alarm_duration_new (gint minutes,
                                                const gchar* label);
VALA_EXTERN ClocksAlarmDuration* clocks_alarm_duration_construct (GType object_type,
                                                      gint minutes,
                                                      const gchar* label);
VALA_EXTERN void clocks_alarm_duration_set_minutes (ClocksAlarmDuration* self,
                                        gint value);
VALA_EXTERN void clocks_alarm_duration_set_label (ClocksAlarmDuration* self,
                                      const gchar* value);
VALA_EXTERN gint clocks_alarm_duration_get_minutes (ClocksAlarmDuration* self);
VALA_EXTERN const gchar* clocks_alarm_duration_get_label (ClocksAlarmDuration* self);
static void clocks_alarm_duration_finalize (GObject * obj);
static GType clocks_alarm_duration_get_type_once (void);
static void _vala_clocks_alarm_duration_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_clocks_alarm_duration_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN GType clocks_alarm_duration_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmDurationModel, g_object_unref)
static GType clocks_alarm_duration_model_real_get_item_type (GListModel* base);
static guint clocks_alarm_duration_model_real_get_n_items (GListModel* base);
static GObject* clocks_alarm_duration_model_real_get_item (GListModel* base,
                                                    guint n);
VALA_EXTERN gint clocks_alarm_duration_model_find_by_duration (ClocksAlarmDurationModel* self,
                                                   gint minutes);
VALA_EXTERN ClocksAlarmDurationModel* clocks_alarm_duration_model_new (void);
VALA_EXTERN ClocksAlarmDurationModel* clocks_alarm_duration_model_construct (GType object_type);
static GObject * clocks_alarm_duration_model_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void clocks_alarm_duration_model_finalize (GObject * obj);
static GType clocks_alarm_duration_model_get_type_once (void);
VALA_EXTERN GType clocks_alarm_setup_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmSetupDialog, g_object_unref)
VALA_EXTERN GType clocks_utils_wall_clock_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_am_pm_toggle_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAmPmToggleButton, g_object_unref)
VALA_EXTERN GType clocks_alarm_day_picker_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmDayPickerRow, g_object_unref)
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (GtkWindow* parent,
                                                       ClocksAlarmItem* alarm,
                                                       GListModel* all_alarms);
VALA_EXTERN ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type,
                                                             GtkWindow* parent,
                                                             ClocksAlarmItem* alarm,
                                                             GListModel* all_alarms);
static gchar* clocks_alarm_setup_dialog_duration_label (ClocksAlarmDuration* item);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
VALA_EXTERN ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self);
VALA_EXTERN ClocksAmPmToggleButton* clocks_am_pm_toggle_button_new (void);
VALA_EXTERN ClocksAmPmToggleButton* clocks_am_pm_toggle_button_construct (GType object_type);
static void __lambda56_ (ClocksAlarmSetupDialog* self);
static void clocks_alarm_setup_dialog_avoid_duplicate_alarm (ClocksAlarmSetupDialog* self);
static void ___lambda56__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN void clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self,
                                               ClocksAlarmItem* alarm);
VALA_EXTERN gpointer clocks_utils_weekdays_ref (gpointer instance);
VALA_EXTERN void clocks_utils_weekdays_unref (gpointer instance);
VALA_EXTERN GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void clocks_utils_value_set_weekdays (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void clocks_utils_value_take_weekdays (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer clocks_utils_value_get_weekdays (const GValue* value);
VALA_EXTERN GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWeekdays, clocks_utils_weekdays_unref)
VALA_EXTERN GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
VALA_EXTERN GType clocks_alarm_alarm_time_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksAlarmAlarmTime* clocks_alarm_alarm_time_dup (const ClocksAlarmAlarmTime* self);
VALA_EXTERN void clocks_alarm_alarm_time_free (ClocksAlarmAlarmTime* self);
VALA_EXTERN void clocks_alarm_item_get_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * result);
VALA_EXTERN ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self);
VALA_EXTERN gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
VALA_EXTERN gint clocks_alarm_item_get_ring_minutes (ClocksAlarmItem* self);
VALA_EXTERN gint clocks_alarm_item_get_snooze_minutes (ClocksAlarmItem* self);
VALA_EXTERN GType clocks_am_pm_toggle_button_am_pm_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void clocks_am_pm_toggle_button_set_choice (ClocksAmPmToggleButton* self,
                                            ClocksAmPmToggleButtonAmPm value);
VALA_EXTERN void clocks_alarm_day_picker_row_load (ClocksAlarmDayPickerRow* self,
                                       ClocksUtilsWeekdays* current_days);
VALA_EXTERN void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self,
                                               ClocksAlarmItem* alarm);
VALA_EXTERN ClocksAmPmToggleButtonAmPm clocks_am_pm_toggle_button_get_choice (ClocksAmPmToggleButton* self);
VALA_EXTERN ClocksUtilsWeekdays* clocks_alarm_day_picker_row_store (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_content_item_set_name (ClocksContentItem* self,
                                   const gchar* value);
VALA_EXTERN void clocks_alarm_item_set_time (ClocksAlarmItem* self,
                                 ClocksAlarmAlarmTime * value);
VALA_EXTERN void clocks_alarm_item_set_days (ClocksAlarmItem* self,
                                 ClocksUtilsWeekdays* value);
VALA_EXTERN void clocks_alarm_item_set_snooze_minutes (ClocksAlarmItem* self,
                                           gint value);
VALA_EXTERN void clocks_alarm_item_set_ring_minutes (ClocksAlarmItem* self,
                                         gint value);
VALA_EXTERN void clocks_alarm_item_reset (ClocksAlarmItem* self);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_new (const gchar* id);
VALA_EXTERN ClocksAlarmItem* clocks_alarm_item_construct (GType object_type,
                                              const gchar* id);
VALA_EXTERN gboolean clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self,
                                                  GList* alarms);
static void clocks_alarm_setup_dialog_days_changed (ClocksAlarmSetupDialog* self);
static void _clocks_alarm_setup_dialog_days_changed_clocks_alarm_day_picker_row_days_changed (ClocksAlarmDayPickerRow* _sender,
                                                                                       gpointer self);
static void clocks_alarm_setup_dialog_entry_changed (ClocksAlarmSetupDialog* self,
                                              GtkEditable* editable);
static void _clocks_alarm_setup_dialog_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                    gpointer self);
static void clocks_alarm_setup_dialog_spinbuttons_changed (ClocksAlarmSetupDialog* self,
                                                    GtkEditable* editable);
static void _clocks_alarm_setup_dialog_spinbuttons_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                          gpointer self);
static gboolean clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self,
                                                       GtkSpinButton* spin_button);
static gboolean _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                               gpointer self);
static void clocks_alarm_setup_dialog_delete (ClocksAlarmSetupDialog* self);
static void _clocks_alarm_setup_dialog_delete_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void clocks_alarm_setup_dialog_finalize (GObject * obj);
static GType clocks_alarm_setup_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
clocks_alarm_duration_get_instance_private (ClocksAlarmDuration* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmDuration_private_offset);
}

ClocksAlarmDuration*
clocks_alarm_duration_construct (GType object_type,
                                 gint minutes,
                                 const gchar* label)
{
	ClocksAlarmDuration * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (ClocksAlarmDuration*) g_object_new (object_type, NULL);
	clocks_alarm_duration_set_minutes (self, minutes);
	clocks_alarm_duration_set_label (self, label);
	return self;
}

ClocksAlarmDuration*
clocks_alarm_duration_new (gint minutes,
                           const gchar* label)
{
	return clocks_alarm_duration_construct (CLOCKS_ALARM_TYPE_DURATION, minutes, label);
}

gint
clocks_alarm_duration_get_minutes (ClocksAlarmDuration* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_minutes;
	return result;
}

void
clocks_alarm_duration_set_minutes (ClocksAlarmDuration* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_duration_get_minutes (self);
	if (old_value != value) {
		self->priv->_minutes = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_duration_properties[CLOCKS_ALARM_DURATION_MINUTES_PROPERTY]);
	}
}

const gchar*
clocks_alarm_duration_get_label (ClocksAlarmDuration* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
clocks_alarm_duration_set_label (ClocksAlarmDuration* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_alarm_duration_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_alarm_duration_properties[CLOCKS_ALARM_DURATION_LABEL_PROPERTY]);
	}
}

static void
clocks_alarm_duration_class_init (ClocksAlarmDurationClass * klass,
                                  gpointer klass_data)
{
	clocks_alarm_duration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmDuration_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_duration_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_duration_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_duration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DURATION_MINUTES_PROPERTY, clocks_alarm_duration_properties[CLOCKS_ALARM_DURATION_MINUTES_PROPERTY] = g_param_spec_int ("minutes", "minutes", "minutes", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DURATION_LABEL_PROPERTY, clocks_alarm_duration_properties[CLOCKS_ALARM_DURATION_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
clocks_alarm_duration_instance_init (ClocksAlarmDuration * self,
                                     gpointer klass)
{
	self->priv = clocks_alarm_duration_get_instance_private (self);
	self->priv->_minutes = 0;
}

static void
clocks_alarm_duration_finalize (GObject * obj)
{
	ClocksAlarmDuration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
	_g_free0 (self->priv->_label);
	G_OBJECT_CLASS (clocks_alarm_duration_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_duration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmDurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_duration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmDuration), 0, (GInstanceInitFunc) clocks_alarm_duration_instance_init, NULL };
	GType clocks_alarm_duration_type_id;
	clocks_alarm_duration_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmDuration", &g_define_type_info, 0);
	ClocksAlarmDuration_private_offset = g_type_add_instance_private (clocks_alarm_duration_type_id, sizeof (ClocksAlarmDurationPrivate));
	return clocks_alarm_duration_type_id;
}

GType
clocks_alarm_duration_get_type (void)
{
	static volatile gsize clocks_alarm_duration_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_duration_type_id__once)) {
		GType clocks_alarm_duration_type_id;
		clocks_alarm_duration_type_id = clocks_alarm_duration_get_type_once ();
		g_once_init_leave (&clocks_alarm_duration_type_id__once, clocks_alarm_duration_type_id);
	}
	return clocks_alarm_duration_type_id__once;
}

static void
_vala_clocks_alarm_duration_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ClocksAlarmDuration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
	switch (property_id) {
		case CLOCKS_ALARM_DURATION_MINUTES_PROPERTY:
		g_value_set_int (value, clocks_alarm_duration_get_minutes (self));
		break;
		case CLOCKS_ALARM_DURATION_LABEL_PROPERTY:
		g_value_set_string (value, clocks_alarm_duration_get_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_alarm_duration_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ClocksAlarmDuration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
	switch (property_id) {
		case CLOCKS_ALARM_DURATION_MINUTES_PROPERTY:
		clocks_alarm_duration_set_minutes (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_DURATION_LABEL_PROPERTY:
		clocks_alarm_duration_set_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
clocks_alarm_duration_model_get_instance_private (ClocksAlarmDurationModel* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmDurationModel_private_offset);
}

static GType
clocks_alarm_duration_model_real_get_item_type (GListModel* base)
{
	ClocksAlarmDurationModel * self;
	GType result;
	self = (ClocksAlarmDurationModel*) base;
	result = CLOCKS_ALARM_TYPE_DURATION;
	return result;
}

static guint
clocks_alarm_duration_model_real_get_n_items (GListModel* base)
{
	ClocksAlarmDurationModel * self;
	guint result;
	self = (ClocksAlarmDurationModel*) base;
	result = (guint) 6;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject*
clocks_alarm_duration_model_real_get_item (GListModel* base,
                                           guint n)
{
	ClocksAlarmDurationModel * self;
	ClocksAlarmDuration* _tmp0_;
	GObject* _tmp1_;
	GObject* result;
	self = (ClocksAlarmDurationModel*) base;
	if (n > ((guint) 5)) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->store[n];
	_tmp1_ = _g_object_ref0 ((GObject*) _tmp0_);
	result = _tmp1_;
	return result;
}

gint
clocks_alarm_duration_model_find_by_duration (ClocksAlarmDurationModel* self,
                                              gint minutes)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ClocksAlarmDuration* d = NULL;
				GObject* _tmp2_;
				ClocksAlarmDuration* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) self))) {
					break;
				}
				_tmp2_ = g_list_model_get_item ((GListModel*) self, (guint) i);
				d = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
				_tmp3_ = d;
				_tmp4_ = clocks_alarm_duration_get_minutes (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == minutes) {
					result = i;
					_g_object_unref0 (d);
					return result;
				}
				_g_object_unref0 (d);
			}
		}
	}
	result = -1;
	return result;
}

ClocksAlarmDurationModel*
clocks_alarm_duration_model_construct (GType object_type)
{
	ClocksAlarmDurationModel * self = NULL;
	self = (ClocksAlarmDurationModel*) g_object_new (object_type, NULL);
	return self;
}

ClocksAlarmDurationModel*
clocks_alarm_duration_model_new (void)
{
	return clocks_alarm_duration_model_construct (CLOCKS_ALARM_TYPE_DURATION_MODEL);
}

static GObject *
clocks_alarm_duration_model_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksAlarmDurationModel * self;
	ClocksAlarmDuration* _tmp0_;
	ClocksAlarmDuration* _tmp1_;
	ClocksAlarmDuration* _tmp2_;
	ClocksAlarmDuration* _tmp3_;
	ClocksAlarmDuration* _tmp4_;
	ClocksAlarmDuration* _tmp5_;
	parent_class = G_OBJECT_CLASS (clocks_alarm_duration_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_DURATION_MODEL, ClocksAlarmDurationModel);
	_tmp0_ = clocks_alarm_duration_new (1, _ ("1 minute"));
	_g_object_unref0 (self->priv->store[0]);
	self->priv->store[0] = _tmp0_;
	_tmp1_ = clocks_alarm_duration_new (5, _ ("5 minutes"));
	_g_object_unref0 (self->priv->store[1]);
	self->priv->store[1] = _tmp1_;
	_tmp2_ = clocks_alarm_duration_new (10, _ ("10 minutes"));
	_g_object_unref0 (self->priv->store[2]);
	self->priv->store[2] = _tmp2_;
	_tmp3_ = clocks_alarm_duration_new (15, _ ("15 minutes"));
	_g_object_unref0 (self->priv->store[3]);
	self->priv->store[3] = _tmp3_;
	_tmp4_ = clocks_alarm_duration_new (20, _ ("20 minutes"));
	_g_object_unref0 (self->priv->store[4]);
	self->priv->store[4] = _tmp4_;
	_tmp5_ = clocks_alarm_duration_new (30, _ ("30 minutes"));
	_g_object_unref0 (self->priv->store[5]);
	self->priv->store[5] = _tmp5_;
	return obj;
}

static void
clocks_alarm_duration_model_class_init (ClocksAlarmDurationModelClass * klass,
                                        gpointer klass_data)
{
	clocks_alarm_duration_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmDurationModel_private_offset);
	G_OBJECT_CLASS (klass)->constructor = clocks_alarm_duration_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_duration_model_finalize;
}

static void
clocks_alarm_duration_model_g_list_model_interface_init (GListModelInterface * iface,
                                                         gpointer iface_data)
{
	clocks_alarm_duration_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) clocks_alarm_duration_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) clocks_alarm_duration_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) clocks_alarm_duration_model_real_get_item;
}

static void
clocks_alarm_duration_model_instance_init (ClocksAlarmDurationModel * self,
                                           gpointer klass)
{
	self->priv = clocks_alarm_duration_model_get_instance_private (self);
}

static void
clocks_alarm_duration_model_finalize (GObject * obj)
{
	ClocksAlarmDurationModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_DURATION_MODEL, ClocksAlarmDurationModel);
	_vala_array_destroy (self->priv->store, 6, (GDestroyNotify) g_object_unref);
	G_OBJECT_CLASS (clocks_alarm_duration_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_duration_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmDurationModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_duration_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmDurationModel), 0, (GInstanceInitFunc) clocks_alarm_duration_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) clocks_alarm_duration_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_alarm_duration_model_type_id;
	clocks_alarm_duration_model_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmDurationModel", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_alarm_duration_model_type_id, g_list_model_get_type (), &g_list_model_info);
	ClocksAlarmDurationModel_private_offset = g_type_add_instance_private (clocks_alarm_duration_model_type_id, sizeof (ClocksAlarmDurationModelPrivate));
	return clocks_alarm_duration_model_type_id;
}

GType
clocks_alarm_duration_model_get_type (void)
{
	static volatile gsize clocks_alarm_duration_model_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_duration_model_type_id__once)) {
		GType clocks_alarm_duration_model_type_id;
		clocks_alarm_duration_model_type_id = clocks_alarm_duration_model_get_type_once ();
		g_once_init_leave (&clocks_alarm_duration_model_type_id__once, clocks_alarm_duration_model_type_id);
	}
	return clocks_alarm_duration_model_type_id__once;
}

static inline gpointer
clocks_alarm_setup_dialog_get_instance_private (ClocksAlarmSetupDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmSetupDialog_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda56_ (ClocksAlarmSetupDialog* self)
{
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}

static void
___lambda56__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda56_ ((ClocksAlarmSetupDialog*) self);
}

ClocksAlarmSetupDialog*
clocks_alarm_setup_dialog_construct (GType object_type,
                                     GtkWindow* parent,
                                     ClocksAlarmItem* alarm,
                                     GListModel* all_alarms)
{
	ClocksAlarmSetupDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	guint n = 0U;
	ClocksAlarmDurationModel* _tmp7_;
	GtkCClosureExpression* expression = NULL;
	GtkExpression** _tmp8_;
	GtkCClosureExpression* _tmp9_;
	AdwComboRow* _tmp10_;
	GtkCClosureExpression* _tmp11_;
	AdwComboRow* _tmp12_;
	ClocksAlarmDurationModel* _tmp13_;
	AdwComboRow* _tmp14_;
	GtkCClosureExpression* _tmp15_;
	AdwComboRow* _tmp16_;
	ClocksAlarmDurationModel* _tmp17_;
	GtkBox* _tmp18_;
	ClocksUtilsWallClock* _tmp19_;
	ClocksUtilsWallClock* _tmp20_;
	ClocksUtilsWallClockFormat _tmp21_;
	ClocksUtilsWallClockFormat _tmp22_;
	ClocksAmPmToggleButton* _tmp23_;
	ClocksAmPmToggleButton* _tmp24_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (all_alarms != NULL, NULL);
	if (alarm != NULL) {
		_tmp0_ = _ ("Edit Alarm");
	} else {
		_tmp0_ = _ ("New Alarm");
	}
	self = (ClocksAlarmSetupDialog*) g_object_new (object_type, "transient-for", parent, "title", _tmp0_, "use-header-bar", 1, NULL);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	if (alarm != NULL) {
		gtk_dialog_add_button ((GtkDialog*) self, _ ("Done"), (gint) GTK_RESPONSE_OK);
	} else {
		gtk_dialog_add_button ((GtkDialog*) self, _ ("Add"), (gint) GTK_RESPONSE_OK);
	}
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	_tmp1_ = self->priv->delete_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, alarm != NULL);
	(self->priv->other_alarms == NULL) ? NULL : (self->priv->other_alarms = (_g_list_free__g_object_unref0_ (self->priv->other_alarms), NULL));
	self->priv->other_alarms = NULL;
	n = g_list_model_get_n_items (all_alarms);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ClocksAlarmItem* item = NULL;
				GObject* _tmp4_;
				ClocksAlarmItem* _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((guint) i) < n)) {
					break;
				}
				_tmp4_ = g_list_model_get_object (all_alarms, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
				_tmp5_ = item;
				if (alarm != _tmp5_) {
					GObject* _tmp6_;
					_tmp6_ = g_list_model_get_object (all_alarms, (guint) i);
					self->priv->other_alarms = g_list_prepend (self->priv->other_alarms, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp7_ = clocks_alarm_duration_model_new ();
	_g_object_unref0 (self->priv->duration_model);
	self->priv->duration_model = _tmp7_;
	_tmp8_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp9_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp8_, (GCallback) clocks_alarm_setup_dialog_duration_label, NULL, NULL);
	expression = _tmp9_;
	_tmp10_ = self->priv->snooze_duration;
	_tmp11_ = expression;
	adw_combo_row_set_expression (_tmp10_, (GtkExpression*) _tmp11_);
	_tmp12_ = self->priv->snooze_duration;
	_tmp13_ = self->priv->duration_model;
	adw_combo_row_set_model (_tmp12_, (GListModel*) _tmp13_);
	_tmp14_ = self->priv->ring_duration;
	_tmp15_ = expression;
	adw_combo_row_set_expression (_tmp14_, (GtkExpression*) _tmp15_);
	_tmp16_ = self->priv->ring_duration;
	_tmp17_ = self->priv->duration_model;
	adw_combo_row_set_model (_tmp16_, (GListModel*) _tmp17_);
	_tmp18_ = self->priv->time_box;
	gtk_widget_set_direction ((GtkWidget*) _tmp18_, GTK_TEXT_DIR_LTR);
	_tmp19_ = clocks_utils_wall_clock_get_default ();
	_tmp20_ = _tmp19_;
	_tmp21_ = clocks_utils_wall_clock_get_format (_tmp20_);
	_tmp22_ = _tmp21_;
	self->priv->format = _tmp22_;
	_g_object_unref0 (_tmp20_);
	_tmp23_ = clocks_am_pm_toggle_button_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->am_pm_button);
	self->priv->am_pm_button = _tmp23_;
	_tmp24_ = self->priv->am_pm_button;
	g_signal_connect_object ((GtkButton*) _tmp24_, "clicked", (GCallback) ___lambda56__gtk_button_clicked, self, 0);
	if (self->priv->format == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR) {
		GtkSpinButton* _tmp25_;
		AdwBin* _tmp26_;
		_tmp25_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp25_, (gdouble) 0, (gdouble) 23);
		_tmp26_ = self->priv->am_pm_bin;
		gtk_widget_hide ((GtkWidget*) _tmp26_);
	} else {
		GtkSpinButton* _tmp27_;
		ClocksAmPmToggleButton* _tmp28_;
		ClocksAmPmToggleButton* _tmp29_;
		ClocksAmPmToggleButton* _tmp30_;
		ClocksAmPmToggleButton* _tmp31_;
		AdwBin* _tmp32_;
		AdwBin* _tmp33_;
		ClocksAmPmToggleButton* _tmp34_;
		_tmp27_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp27_, (gdouble) 1, (gdouble) 12);
		_tmp28_ = self->priv->am_pm_button;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, FALSE);
		_tmp29_ = self->priv->am_pm_button;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp29_, FALSE);
		_tmp30_ = self->priv->am_pm_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
		_tmp31_ = self->priv->am_pm_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_CENTER);
		_tmp32_ = self->priv->am_pm_bin;
		gtk_widget_show ((GtkWidget*) _tmp32_);
		_tmp33_ = self->priv->am_pm_bin;
		_tmp34_ = self->priv->am_pm_button;
		adw_bin_set_child (_tmp33_, (GtkWidget*) _tmp34_);
	}
	clocks_alarm_setup_dialog_set_from_alarm (self, alarm);
	_gtk_expression_unref0 (expression);
	return self;
}

ClocksAlarmSetupDialog*
clocks_alarm_setup_dialog_new (GtkWindow* parent,
                               ClocksAlarmItem* alarm,
                               GListModel* all_alarms)
{
	return clocks_alarm_setup_dialog_construct (CLOCKS_ALARM_TYPE_SETUP_DIALOG, parent, alarm, all_alarms);
}

static gchar*
clocks_alarm_setup_dialog_duration_label (ClocksAlarmDuration* item)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = clocks_alarm_duration_get_label (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self,
                                          ClocksAlarmItem* alarm)
{
	gchar* name = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	gint snooze_minutes = 0;
	gint ring_minutes = 0;
	ClocksUtilsWeekdays* days = NULL;
	AdwComboRow* _tmp25_;
	ClocksAlarmDurationModel* _tmp26_;
	AdwComboRow* _tmp27_;
	ClocksAlarmDurationModel* _tmp28_;
	GtkSpinButton* _tmp29_;
	GtkSpinButton* _tmp30_;
	GtkEntry* _tmp31_;
	const gchar* _tmp32_;
	ClocksUtilsWeekdays* _tmp33_;
	g_return_if_fail (self != NULL);
	if (alarm == NULL) {
		ClocksUtilsWallClock* wc = NULL;
		ClocksUtilsWallClock* _tmp0_;
		gchar* _tmp1_;
		ClocksUtilsWallClock* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		ClocksUtilsWallClock* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		_tmp0_ = clocks_utils_wall_clock_get_default ();
		wc = _tmp0_;
		_tmp1_ = g_strdup ("");
		_g_free0 (name);
		name = _tmp1_;
		_tmp2_ = wc;
		_tmp3_ = clocks_utils_wall_clock_get_date_time (_tmp2_);
		_tmp4_ = _tmp3_;
		hour = g_date_time_get_hour (_tmp4_);
		_tmp5_ = wc;
		_tmp6_ = clocks_utils_wall_clock_get_date_time (_tmp5_);
		_tmp7_ = _tmp6_;
		minute = g_date_time_get_minute (_tmp7_);
		days = NULL;
		active = TRUE;
		ring_minutes = 5;
		snooze_minutes = 10;
		_g_object_unref0 (wc);
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		ClocksAlarmAlarmTime _tmp11_ = {0};
		ClocksAlarmAlarmTime _tmp12_;
		ClocksAlarmAlarmTime _tmp13_ = {0};
		ClocksAlarmAlarmTime _tmp14_;
		ClocksUtilsWeekdays* _tmp15_;
		ClocksUtilsWeekdays* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp8_ = clocks_content_item_get_name ((ClocksContentItem*) G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (name);
		name = _tmp10_;
		clocks_alarm_item_get_time (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem), &_tmp11_);
		_tmp12_ = _tmp11_;
		hour = _tmp12_.hour;
		clocks_alarm_item_get_time (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem), &_tmp13_);
		_tmp14_ = _tmp13_;
		minute = _tmp14_.minute;
		_tmp15_ = clocks_alarm_item_get_days (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
		_tmp16_ = _tmp15_;
		days = _tmp16_;
		_tmp17_ = clocks_alarm_item_get_active (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
		_tmp18_ = _tmp17_;
		active = _tmp18_;
		_tmp19_ = clocks_alarm_item_get_ring_minutes (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
		_tmp20_ = _tmp19_;
		ring_minutes = _tmp20_;
		_tmp21_ = clocks_alarm_item_get_snooze_minutes (G_TYPE_CHECK_INSTANCE_CAST (alarm, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
		_tmp22_ = _tmp21_;
		snooze_minutes = _tmp22_;
	}
	if (self->priv->format == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		if (hour < 12) {
			ClocksAmPmToggleButton* _tmp23_;
			_tmp23_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp23_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM);
		} else {
			ClocksAmPmToggleButton* _tmp24_;
			_tmp24_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp24_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM);
			hour -= 12;
		}
		if (hour == 0) {
			hour = 12;
		}
	}
	_tmp25_ = self->priv->ring_duration;
	_tmp26_ = self->priv->duration_model;
	adw_combo_row_set_selected (_tmp25_, (guint) clocks_alarm_duration_model_find_by_duration (_tmp26_, ring_minutes));
	_tmp27_ = self->priv->snooze_duration;
	_tmp28_ = self->priv->duration_model;
	adw_combo_row_set_selected (_tmp27_, (guint) clocks_alarm_duration_model_find_by_duration (_tmp28_, snooze_minutes));
	_tmp29_ = self->priv->h_spinbutton;
	gtk_spin_button_set_value (_tmp29_, (gdouble) hour);
	_tmp30_ = self->priv->m_spinbutton;
	gtk_spin_button_set_value (_tmp30_, (gdouble) minute);
	_tmp31_ = self->priv->name_entry;
	_tmp32_ = name;
	gtk_editable_set_text ((GtkEditable*) _tmp31_, (const gchar*) _tmp32_);
	_tmp33_ = days;
	if (_tmp33_ != NULL) {
		ClocksAlarmDayPickerRow* _tmp34_;
		ClocksUtilsWeekdays* _tmp35_;
		_tmp34_ = self->priv->repeats;
		_tmp35_ = days;
		clocks_alarm_day_picker_row_load (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays));
	}
	_g_free0 (name);
}

void
clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self,
                                          ClocksAlarmItem* alarm)
{
	gchar* name = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint hour = 0;
	GtkSpinButton* _tmp3_;
	gint minute = 0;
	GtkSpinButton* _tmp4_;
	ClocksAlarmDuration* snooze_item = NULL;
	ClocksAlarmDurationModel* _tmp5_;
	AdwComboRow* _tmp6_;
	GObject* _tmp7_;
	ClocksAlarmDuration* ring_item = NULL;
	ClocksAlarmDurationModel* _tmp8_;
	AdwComboRow* _tmp9_;
	GObject* _tmp10_;
	ClocksAlarmAlarmTime time = {0};
	ClocksAlarmAlarmTime _tmp16_ = {0};
	ClocksUtilsWeekdays* days = NULL;
	ClocksAlarmDayPickerRow* _tmp17_;
	ClocksUtilsWeekdays* _tmp18_;
	const gchar* _tmp19_;
	ClocksAlarmAlarmTime _tmp20_;
	ClocksAlarmDuration* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	ClocksAlarmDuration* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_tmp0_ = self->priv->name_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->h_spinbutton;
	hour = gtk_spin_button_get_value_as_int (_tmp3_);
	_tmp4_ = self->priv->m_spinbutton;
	minute = gtk_spin_button_get_value_as_int (_tmp4_);
	_tmp5_ = self->priv->duration_model;
	_tmp6_ = self->priv->snooze_duration;
	_tmp7_ = g_list_model_get_item ((GListModel*) _tmp5_, adw_combo_row_get_selected (_tmp6_));
	snooze_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
	_tmp8_ = self->priv->duration_model;
	_tmp9_ = self->priv->ring_duration;
	_tmp10_ = g_list_model_get_item ((GListModel*) _tmp8_, adw_combo_row_get_selected (_tmp9_));
	ring_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, CLOCKS_ALARM_TYPE_DURATION, ClocksAlarmDuration);
	if (self->priv->format == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		ClocksAmPmToggleButtonAmPm choice = 0;
		ClocksAmPmToggleButton* _tmp11_;
		ClocksAmPmToggleButtonAmPm _tmp12_;
		ClocksAmPmToggleButtonAmPm _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = self->priv->am_pm_button;
		_tmp12_ = clocks_am_pm_toggle_button_get_choice (_tmp11_);
		_tmp13_ = _tmp12_;
		choice = _tmp13_;
		if (choice == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM) {
			_tmp14_ = hour == 12;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			hour = 0;
		} else {
			gboolean _tmp15_ = FALSE;
			if (choice == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM) {
				_tmp15_ = hour != 12;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				hour += 12;
			}
		}
	}
	_tmp16_.hour = hour;
	_tmp16_.minute = minute;
	time = _tmp16_;
	_tmp17_ = self->priv->repeats;
	_tmp18_ = clocks_alarm_day_picker_row_store (_tmp17_);
	days = _tmp18_;
	g_object_freeze_notify ((GObject*) alarm);
	_tmp19_ = name;
	clocks_content_item_set_name ((ClocksContentItem*) alarm, _tmp19_);
	_tmp20_ = time;
	clocks_alarm_item_set_time (alarm, &_tmp20_);
	clocks_alarm_item_set_days (alarm, days);
	_tmp21_ = snooze_item;
	_tmp22_ = clocks_alarm_duration_get_minutes (_tmp21_);
	_tmp23_ = _tmp22_;
	clocks_alarm_item_set_snooze_minutes (alarm, _tmp23_);
	_tmp24_ = ring_item;
	_tmp25_ = clocks_alarm_duration_get_minutes (_tmp24_);
	_tmp26_ = _tmp25_;
	clocks_alarm_item_set_ring_minutes (alarm, _tmp26_);
	clocks_alarm_item_reset (alarm);
	g_object_thaw_notify ((GObject*) alarm);
	_clocks_utils_weekdays_unref0 (days);
	_g_object_unref0 (ring_item);
	_g_object_unref0 (snooze_item);
	_g_free0 (name);
}

static void
clocks_alarm_setup_dialog_avoid_duplicate_alarm (ClocksAlarmSetupDialog* self)
{
	ClocksAlarmItem* alarm = NULL;
	ClocksAlarmItem* _tmp0_;
	gboolean duplicate = FALSE;
	GList* _tmp1_;
	GtkRevealer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_item_new (NULL);
	alarm = _tmp0_;
	clocks_alarm_setup_dialog_apply_to_alarm (self, alarm);
	_tmp1_ = self->priv->other_alarms;
	duplicate = clocks_alarm_item_check_duplicate_alarm (alarm, _tmp1_);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, !duplicate);
	_tmp2_ = self->priv->label_revealer;
	gtk_revealer_set_reveal_child (_tmp2_, duplicate);
	_g_object_unref0 (alarm);
}

static void
clocks_alarm_setup_dialog_days_changed (ClocksAlarmSetupDialog* self)
{
	g_return_if_fail (self != NULL);
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}

static void
_clocks_alarm_setup_dialog_days_changed_clocks_alarm_day_picker_row_days_changed (ClocksAlarmDayPickerRow* _sender,
                                                                                  gpointer self)
{
	clocks_alarm_setup_dialog_days_changed ((ClocksAlarmSetupDialog*) self);
}

static void
clocks_alarm_setup_dialog_entry_changed (ClocksAlarmSetupDialog* self,
                                         GtkEditable* editable)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}

static void
_clocks_alarm_setup_dialog_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self)
{
	clocks_alarm_setup_dialog_entry_changed ((ClocksAlarmSetupDialog*) self, _sender);
}

static void
clocks_alarm_setup_dialog_spinbuttons_changed (ClocksAlarmSetupDialog* self,
                                               GtkEditable* editable)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}

static void
_clocks_alarm_setup_dialog_spinbuttons_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                     gpointer self)
{
	clocks_alarm_setup_dialog_spinbuttons_changed ((ClocksAlarmSetupDialog*) self, _sender);
}

static gboolean
clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self,
                                              GtkSpinButton* spin_button)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%02i", gtk_spin_button_get_value_as_int (spin_button));
	_tmp1_ = _tmp0_;
	gtk_editable_set_text ((GtkEditable*) spin_button, _tmp1_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
_clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                      gpointer self)
{
	gboolean result;
	result = clocks_alarm_setup_dialog_show_leading_zeros ((ClocksAlarmSetupDialog*) self, _sender);
	return result;
}

static void
clocks_alarm_setup_dialog_delete (ClocksAlarmSetupDialog* self)
{
	g_return_if_fail (self != NULL);
	gtk_dialog_response ((GtkDialog*) self, CLOCKS_ALARM_DELETE_ALARM);
}

static void
_clocks_alarm_setup_dialog_delete_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	clocks_alarm_setup_dialog_delete ((ClocksAlarmSetupDialog*) self);
}

static void
clocks_alarm_setup_dialog_class_init (ClocksAlarmSetupDialogClass * klass,
                                      gpointer klass_data)
{
	clocks_alarm_setup_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmSetupDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_setup_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/alarm-setup-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_box", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, time_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_spinbutton", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, h_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_spinbutton", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, m_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "snooze_duration", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, snooze_duration));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ring_duration", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, ring_duration));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "repeats", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, repeats));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "am_pm_bin", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, am_pm_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_revealer", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, label_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, delete_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "days_changed", G_CALLBACK(_clocks_alarm_setup_dialog_days_changed_clocks_alarm_day_picker_row_days_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "entry_changed", G_CALLBACK(_clocks_alarm_setup_dialog_entry_changed_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "spinbuttons_changed", G_CALLBACK(_clocks_alarm_setup_dialog_spinbuttons_changed_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_leading_zeros", G_CALLBACK(_clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete", G_CALLBACK(_clocks_alarm_setup_dialog_delete_gtk_button_clicked));
	g_type_ensure (CLOCKS_ALARM_TYPE_DAY_PICKER_ROW);
	g_type_ensure (CLOCKS_ALARM_TYPE_DURATION);
}

static void
clocks_alarm_setup_dialog_instance_init (ClocksAlarmSetupDialog * self,
                                         gpointer klass)
{
	self->priv = clocks_alarm_setup_dialog_get_instance_private (self);
	g_type_ensure (CLOCKS_ALARM_TYPE_DAY_PICKER_ROW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_alarm_setup_dialog_finalize (GObject * obj)
{
	ClocksAlarmSetupDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog);
	_g_object_unref0 (self->priv->am_pm_button);
	(self->priv->other_alarms == NULL) ? NULL : (self->priv->other_alarms = (_g_list_free__g_object_unref0_ (self->priv->other_alarms), NULL));
	_g_object_unref0 (self->priv->duration_model);
	G_OBJECT_CLASS (clocks_alarm_setup_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_setup_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmSetupDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_setup_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmSetupDialog), 0, (GInstanceInitFunc) clocks_alarm_setup_dialog_instance_init, NULL };
	GType clocks_alarm_setup_dialog_type_id;
	clocks_alarm_setup_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ClocksAlarmSetupDialog", &g_define_type_info, 0);
	ClocksAlarmSetupDialog_private_offset = g_type_add_instance_private (clocks_alarm_setup_dialog_type_id, sizeof (ClocksAlarmSetupDialogPrivate));
	return clocks_alarm_setup_dialog_type_id;
}

GType
clocks_alarm_setup_dialog_get_type (void)
{
	static volatile gsize clocks_alarm_setup_dialog_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_setup_dialog_type_id__once)) {
		GType clocks_alarm_setup_dialog_type_id;
		clocks_alarm_setup_dialog_type_id = clocks_alarm_setup_dialog_get_type_once ();
		g_once_init_leave (&clocks_alarm_setup_dialog_type_id__once, clocks_alarm_setup_dialog_type_id);
	}
	return clocks_alarm_setup_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

