/* gcalc-parser.c generated by valac 0.56.0, the Vala compiler
 * generated from gcalc-parser.vala, do not modify */

/* gcalc-gexpresion.vala
 *
 * Copyright (C) 2018  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include "gcalc.h"

enum  {
	GCALC_PARSER_0_PROPERTY,
	GCALC_PARSER_NUM_PROPERTIES
};
static GParamSpec* gcalc_parser_properties[GCALC_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_scanner_destroy0(var) ((var == NULL) ? NULL : (var = (g_scanner_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GCalcParserPrivate {
	GCalcMathExpression* current;
	GCalcMathExpression* current_parent;
	GCalcMathExpression* top_parent;
	GCalcEquation* eq;
	GRegex* rg;
	gboolean enable_parameter;
	GeeArrayList* expected;
	GScanner* scanner;
};

static gint GCalcParser_private_offset;
static gpointer gcalc_parser_parent_class = NULL;

static void gcalc_parser_add_constant (GCalcParser* self,
                                GCalcMathConstant* c);
VALA_EXTERN GCalcVariable* gcalc_variable_new (const gchar* name);
VALA_EXTERN GCalcVariable* gcalc_variable_construct (GType object_type,
                                         const gchar* name);
static void gcalc_parser_process_term_operator (GCalcParser* self,
                                         GCalcMathOperator* op,
                                         GCalcEquation* eq,
                                         GError** error);
static void gcalc_parser_process_operator (GCalcParser* self,
                                    GCalcMathOperator* opp,
                                    GCalcEquation* eq,
                                    GError** error);
static GObject * gcalc_parser_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void gcalc_parser_finalize (GObject * obj);
static GType gcalc_parser_get_type_once (void);

static inline gpointer
gcalc_parser_get_instance_private (GCalcParser* self)
{
	return G_STRUCT_MEMBER_P (self, GCalcParser_private_offset);
}

static GType
gcalc_parser_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GCALC_PARSER_TOKEN_TYPE_NONE, "GCALC_PARSER_TOKEN_TYPE_NONE", "none"}, {GCALC_PARSER_TOKEN_TYPE_EOF, "GCALC_PARSER_TOKEN_TYPE_EOF", "eof"}, {GCALC_PARSER_TOKEN_TYPE_IDENTIFIER, "GCALC_PARSER_TOKEN_TYPE_IDENTIFIER", "identifier"}, {GCALC_PARSER_TOKEN_TYPE_INTEGER_LITERAL, "GCALC_PARSER_TOKEN_TYPE_INTEGER_LITERAL", "integer-literal"}, {GCALC_PARSER_TOKEN_TYPE_REAL_LITERAL, "GCALC_PARSER_TOKEN_TYPE_REAL_LITERAL", "real-literal"}, {GCALC_PARSER_TOKEN_TYPE_STAR, "GCALC_PARSER_TOKEN_TYPE_STAR", "star"}, {GCALC_PARSER_TOKEN_TYPE_PLUS, "GCALC_PARSER_TOKEN_TYPE_PLUS", "plus"}, {GCALC_PARSER_TOKEN_TYPE_DIV, "GCALC_PARSER_TOKEN_TYPE_DIV", "div"}, {GCALC_PARSER_TOKEN_TYPE_MINUS, "GCALC_PARSER_TOKEN_TYPE_MINUS", "minus"}, {GCALC_PARSER_TOKEN_TYPE_ASSIGN, "GCALC_PARSER_TOKEN_TYPE_ASSIGN", "assign"}, {GCALC_PARSER_TOKEN_TYPE_OPEN_PARENS, "GCALC_PARSER_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {GCALC_PARSER_TOKEN_TYPE_CLOSE_PARENS, "GCALC_PARSER_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {GCALC_PARSER_TOKEN_TYPE_CARRET, "GCALC_PARSER_TOKEN_TYPE_CARRET", "carret"}, {GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACE, "GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACKET, "GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {GCALC_PARSER_TOKEN_TYPE_OPEN_BRACE, "GCALC_PARSER_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {GCALC_PARSER_TOKEN_TYPE_OPEN_BRACKET, "GCALC_PARSER_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {GCALC_PARSER_TOKEN_TYPE_STRING_LITERAL, "GCALC_PARSER_TOKEN_TYPE_STRING_LITERAL", "string-literal"}, {GCALC_PARSER_TOKEN_TYPE_OP_AND, "GCALC_PARSER_TOKEN_TYPE_OP_AND", "op-and"}, {GCALC_PARSER_TOKEN_TYPE_OP_COALESCING, "GCALC_PARSER_TOKEN_TYPE_OP_COALESCING", "op-coalescing"}, {GCALC_PARSER_TOKEN_TYPE_OP_DEC, "GCALC_PARSER_TOKEN_TYPE_OP_DEC", "op-dec"}, {GCALC_PARSER_TOKEN_TYPE_OP_EQ, "GCALC_PARSER_TOKEN_TYPE_OP_EQ", "op-eq"}, {GCALC_PARSER_TOKEN_TYPE_OP_GE, "GCALC_PARSER_TOKEN_TYPE_OP_GE", "op-ge"}, {GCALC_PARSER_TOKEN_TYPE_OP_GT, "GCALC_PARSER_TOKEN_TYPE_OP_GT", "op-gt"}, {GCALC_PARSER_TOKEN_TYPE_OP_INC, "GCALC_PARSER_TOKEN_TYPE_OP_INC", "op-inc"}, {GCALC_PARSER_TOKEN_TYPE_OP_LE, "GCALC_PARSER_TOKEN_TYPE_OP_LE", "op-le"}, {GCALC_PARSER_TOKEN_TYPE_OP_LT, "GCALC_PARSER_TOKEN_TYPE_OP_LT", "op-lt"}, {GCALC_PARSER_TOKEN_TYPE_OP_NE, "GCALC_PARSER_TOKEN_TYPE_OP_NE", "op-ne"}, {GCALC_PARSER_TOKEN_TYPE_OP_NEG, "GCALC_PARSER_TOKEN_TYPE_OP_NEG", "op-neg"}, {GCALC_PARSER_TOKEN_TYPE_OP_OR, "GCALC_PARSER_TOKEN_TYPE_OP_OR", "op-or"}, {GCALC_PARSER_TOKEN_TYPE_OP_PTR, "GCALC_PARSER_TOKEN_TYPE_OP_PTR", "op-ptr"}, {GCALC_PARSER_TOKEN_TYPE_OP_SHIFT_LEFT, "GCALC_PARSER_TOKEN_TYPE_OP_SHIFT_LEFT", "op-shift-left"}, {GCALC_PARSER_TOKEN_TYPE_SEMICOLON, "GCALC_PARSER_TOKEN_TYPE_SEMICOLON", "semicolon"}, {GCALC_PARSER_TOKEN_TYPE_TILDE, "GCALC_PARSER_TOKEN_TYPE_TILDE", "tilde"}, {GCALC_PARSER_TOKEN_TYPE_COLON, "GCALC_PARSER_TOKEN_TYPE_COLON", "colon"}, {GCALC_PARSER_TOKEN_TYPE_COMMA, "GCALC_PARSER_TOKEN_TYPE_COMMA", "comma"}, {GCALC_PARSER_TOKEN_TYPE_DOUBLE_COLON, "GCALC_PARSER_TOKEN_TYPE_DOUBLE_COLON", "double-colon"}, {GCALC_PARSER_TOKEN_TYPE_DOT, "GCALC_PARSER_TOKEN_TYPE_DOT", "dot"}, {GCALC_PARSER_TOKEN_TYPE_ELLIPSIS, "GCALC_PARSER_TOKEN_TYPE_ELLIPSIS", "ellipsis"}, {GCALC_PARSER_TOKEN_TYPE_INTERR, "GCALC_PARSER_TOKEN_TYPE_INTERR", "interr"}, {GCALC_PARSER_TOKEN_TYPE_HASH, "GCALC_PARSER_TOKEN_TYPE_HASH", "hash"}, {GCALC_PARSER_TOKEN_TYPE_CURRENCY_SYMBOL, "GCALC_PARSER_TOKEN_TYPE_CURRENCY_SYMBOL", "currency-symbol"}, {0, NULL, NULL}};
	GType gcalc_parser_token_type_type_id;
	gcalc_parser_token_type_type_id = g_enum_register_static ("GCalcParserTokenType", values);
	return gcalc_parser_token_type_type_id;
}

GType
gcalc_parser_token_type_get_type (void)
{
	static volatile gsize gcalc_parser_token_type_type_id__once = 0;
	if (g_once_init_enter (&gcalc_parser_token_type_type_id__once)) {
		GType gcalc_parser_token_type_type_id;
		gcalc_parser_token_type_type_id = gcalc_parser_token_type_get_type_once ();
		g_once_init_leave (&gcalc_parser_token_type_type_id__once, gcalc_parser_token_type_type_id);
	}
	return gcalc_parser_token_type_type_id__once;
}

/**
   * Creates a {@link MathEquation} and adds it to given
   * {@link MathEquationManager} including all Variables and
   * parameters found in the parser expression.
   */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

void
gcalc_parser_parse (GCalcParser* self,
                    const gchar* str,
                    GCalcMathEquationManager* eqman,
                    GError** error)
{
	GCalcParserTokenType token = 0;
	GCalcEquation* _tmp0_;
	GScanner* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GCalcExpressionContainer* _tmp368_;
	GCalcExpressionContainer* _tmp369_;
	GCalcEquation* _tmp370_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	g_return_if_fail (eqman != NULL);
	token = GCALC_PARSER_TOKEN_TYPE_NONE;
	_tmp0_ = gcalc_equation_new ();
	_g_object_unref0 (self->priv->eq);
	self->priv->eq = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp2_ = strlen (str);
	_tmp3_ = _tmp2_;
	g_scanner_input_text (_tmp1_, str, (guint) _tmp3_);
	_g_object_unref0 (self->priv->current);
	self->priv->current = NULL;
	_g_object_unref0 (self->priv->current_parent);
	self->priv->current_parent = NULL;
	_g_object_unref0 (self->priv->top_parent);
	self->priv->top_parent = NULL;
	self->priv->enable_parameter = FALSE;
	while (TRUE) {
		gchar* n = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		if (!(token != GCALC_PARSER_TOKEN_TYPE_EOF)) {
			break;
		}
		token = gcalc_parser_read_token (self);
		if (token == GCALC_PARSER_TOKEN_TYPE_EOF) {
			break;
		}
		_tmp4_ = gcalc_parser_token_to_string (self);
		n = _tmp4_;
		_tmp6_ = self->priv->expected;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != 0) {
			GeeArrayList* _tmp9_;
			_tmp9_ = self->priv->expected;
			_tmp5_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp9_, (gpointer) ((gintptr) token));
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GError* _tmp10_;
			_tmp10_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression"));
			_inner_error0_ = _tmp10_;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (n);
			return;
		}
		switch (token) {
			case GCALC_PARSER_TOKEN_TYPE_IDENTIFIER:
			{
				GRegex* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = self->priv->rg;
				_tmp12_ = n;
				if (g_regex_match (_tmp11_, _tmp12_, G_REGEX_MATCH_ANCHORED, NULL)) {
					gchar* cxn = NULL;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gdouble v = 0.0;
					const gchar* _tmp15_;
					GCalcConstant* cx = NULL;
					GCalcConstant* _tmp16_;
					GCalcConstant* _tmp17_;
					_tmp13_ = n;
					_tmp14_ = string_replace (_tmp13_, "i", "");
					cxn = _tmp14_;
					_tmp15_ = cxn;
					v = double_parse (_tmp15_);
					_tmp16_ = gcalc_constant_new_complex ((gdouble) 0, v);
					cx = _tmp16_;
					_tmp17_ = cx;
					gcalc_parser_add_constant (self, (GCalcMathConstant*) _tmp17_);
					_g_object_unref0 (cx);
					_g_free0 (cxn);
				} else {
					GCalcMathExpression* sfunc = NULL;
					GCalcExpressionContainer* _tmp18_;
					GCalcExpressionContainer* _tmp19_;
					const gchar* _tmp20_;
					GCalcMathExpression* _tmp21_;
					GCalcMathExpression* _tmp22_;
					_tmp18_ = gcalc_math_equation_manager_get_functions (eqman);
					_tmp19_ = _tmp18_;
					_tmp20_ = n;
					_tmp21_ = gcalc_expression_container_find_named (_tmp19_, _tmp20_);
					sfunc = _tmp21_;
					_tmp22_ = sfunc;
					if (_tmp22_ != NULL) {
						GCalcMathExpression* _tmp23_;
						GObject* _tmp24_;
						GObject* _tmp25_;
						GCalcMathExpression* _tmp26_;
						GCalcMathExpression* _tmp27_;
						_tmp23_ = sfunc;
						_tmp24_ = g_object_new (G_TYPE_FROM_INSTANCE ((GObject*) _tmp23_), NULL);
						_tmp25_ = G_IS_INITIALLY_UNOWNED (_tmp24_) ? g_object_ref_sink (_tmp24_) : _tmp24_;
						_tmp26_ = GCALC_IS_MATH_EXPRESSION (_tmp25_) ? ((GCalcMathExpression*) _tmp25_) : NULL;
						if (_tmp26_ == NULL) {
							_g_object_unref0 (_tmp25_);
						}
						_g_object_unref0 (sfunc);
						sfunc = _tmp26_;
						_tmp27_ = self->priv->current;
						if (_tmp27_ == NULL) {
							GCalcPolynomial* exp = NULL;
							GCalcPolynomial* _tmp28_;
							GCalcEquation* _tmp29_;
							GCalcExpressionContainer* _tmp30_;
							GCalcExpressionContainer* _tmp31_;
							GCalcPolynomial* _tmp32_;
							GCalcTerm* t = NULL;
							GCalcTerm* _tmp33_;
							GCalcPolynomial* _tmp34_;
							GCalcExpressionContainer* _tmp35_;
							GCalcExpressionContainer* _tmp36_;
							GCalcTerm* _tmp37_;
							GCalcTerm* _tmp38_;
							GCalcExpressionContainer* _tmp39_;
							GCalcExpressionContainer* _tmp40_;
							GCalcMathExpression* _tmp41_;
							GCalcMathExpression* _tmp42_;
							GCalcMathExpression* _tmp43_;
							GCalcTerm* _tmp44_;
							GCalcMathExpression* _tmp45_;
							GCalcPolynomial* _tmp46_;
							GCalcMathExpression* _tmp47_;
							GeeArrayList* _tmp48_;
							GeeArrayList* _tmp49_;
							_tmp28_ = gcalc_polynomial_new ();
							exp = _tmp28_;
							_tmp29_ = self->priv->eq;
							_tmp30_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = exp;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (GCalcMathExpression*) _tmp32_);
							_tmp33_ = gcalc_term_new ();
							t = _tmp33_;
							_tmp34_ = exp;
							_tmp35_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = t;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (GCalcMathExpression*) _tmp37_);
							_tmp38_ = t;
							_tmp39_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = sfunc;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
							_tmp42_ = sfunc;
							_tmp43_ = _g_object_ref0 (_tmp42_);
							_g_object_unref0 (self->priv->current);
							self->priv->current = _tmp43_;
							_tmp44_ = t;
							_tmp45_ = _g_object_ref0 ((GCalcMathExpression*) _tmp44_);
							_g_object_unref0 (self->priv->current_parent);
							self->priv->current_parent = _tmp45_;
							_tmp46_ = exp;
							_tmp47_ = _g_object_ref0 ((GCalcMathExpression*) _tmp46_);
							_g_object_unref0 (self->priv->top_parent);
							self->priv->top_parent = _tmp47_;
							_tmp48_ = self->priv->expected;
							gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp48_);
							_tmp49_ = self->priv->expected;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (gpointer) ((gintptr) GCALC_PARSER_TOKEN_TYPE_OPEN_PARENS));
							_g_object_unref0 (t);
							_g_object_unref0 (exp);
						} else {
							gboolean _tmp50_ = FALSE;
							gboolean _tmp51_ = FALSE;
							GCalcMathExpression* _tmp52_;
							_tmp52_ = self->priv->current;
							if (GCALC_IS_MATH_OPERATOR (_tmp52_)) {
								GCalcMathExpression* _tmp53_;
								_tmp53_ = self->priv->current_parent;
								_tmp51_ = GCALC_IS_MATH_TERM (_tmp53_);
							} else {
								_tmp51_ = FALSE;
							}
							if (_tmp51_) {
								GCalcMathExpression* _tmp54_;
								_tmp54_ = self->priv->top_parent;
								_tmp50_ = GCALC_IS_MATH_POLYNOMIAL (_tmp54_);
							} else {
								_tmp50_ = FALSE;
							}
							if (_tmp50_) {
								GCalcMathExpression* _tmp55_;
								GCalcExpressionContainer* _tmp56_;
								GCalcExpressionContainer* _tmp57_;
								GCalcMathExpression* _tmp58_;
								GCalcMathExpression* _tmp59_;
								GCalcMathExpression* _tmp60_;
								GeeArrayList* _tmp61_;
								_tmp55_ = self->priv->current_parent;
								_tmp56_ = gcalc_math_expression_get_expressions (_tmp55_);
								_tmp57_ = _tmp56_;
								_tmp58_ = sfunc;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp58_);
								_tmp59_ = sfunc;
								_tmp60_ = _g_object_ref0 (_tmp59_);
								_g_object_unref0 (self->priv->current);
								self->priv->current = _tmp60_;
								_tmp61_ = self->priv->expected;
								gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp61_);
							} else {
								gboolean _tmp62_ = FALSE;
								GCalcMathExpression* _tmp63_;
								_tmp63_ = self->priv->current;
								if (GCALC_IS_MATH_TERM (_tmp63_)) {
									GCalcMathExpression* _tmp64_;
									_tmp64_ = self->priv->current_parent;
									_tmp62_ = GCALC_IS_MATH_POLYNOMIAL (_tmp64_);
								} else {
									_tmp62_ = FALSE;
								}
								if (_tmp62_) {
									GCalcMathExpression* _tmp65_;
									GCalcExpressionContainer* _tmp66_;
									GCalcExpressionContainer* _tmp67_;
									GCalcMathExpression* _tmp68_;
									GCalcMathExpression* _tmp69_;
									GCalcMathExpression* _tmp70_;
									GCalcMathExpression* _tmp71_;
									GCalcMathExpression* _tmp72_;
									GCalcMathExpression* _tmp73_;
									GCalcMathExpression* _tmp74_;
									GCalcMathExpression* _tmp75_;
									GCalcMathExpression* _tmp76_;
									GeeArrayList* _tmp77_;
									_tmp65_ = self->priv->current;
									_tmp66_ = gcalc_math_expression_get_expressions (_tmp65_);
									_tmp67_ = _tmp66_;
									_tmp68_ = sfunc;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
									_tmp69_ = self->priv->current;
									_tmp70_ = _g_object_ref0 (_tmp69_);
									_g_object_unref0 (self->priv->current_parent);
									self->priv->current_parent = _tmp70_;
									_tmp71_ = sfunc;
									_tmp72_ = _g_object_ref0 (_tmp71_);
									_g_object_unref0 (self->priv->current);
									self->priv->current = _tmp72_;
									_tmp73_ = self->priv->current_parent;
									_tmp74_ = gcalc_math_expression_get_parent (_tmp73_);
									_tmp75_ = _tmp74_;
									_tmp76_ = _g_object_ref0 (_tmp75_);
									_g_object_unref0 (self->priv->top_parent);
									self->priv->top_parent = _tmp76_;
									_tmp77_ = self->priv->expected;
									gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
								}
							}
						}
					} else {
						gboolean _tmp78_ = FALSE;
						const gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						gboolean _tmp82_;
						_tmp79_ = n;
						_tmp80_ = g_utf8_strdown (_tmp79_, (gssize) -1);
						_tmp81_ = _tmp80_;
						_tmp82_ = g_strcmp0 (_tmp81_, "def") == 0;
						_g_free0 (_tmp81_);
						if (_tmp82_) {
							GCalcMathExpression* _tmp83_;
							_tmp83_ = self->priv->current;
							_tmp78_ = _tmp83_ == NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
						} else {
							gboolean _tmp84_ = FALSE;
							const gchar* _tmp85_;
							gchar* _tmp86_;
							gchar* _tmp87_;
							gboolean _tmp88_;
							_tmp85_ = n;
							_tmp86_ = g_utf8_strdown (_tmp85_, (gssize) -1);
							_tmp87_ = _tmp86_;
							_tmp88_ = g_strcmp0 (_tmp87_, "def") == 0;
							_g_free0 (_tmp87_);
							if (_tmp88_) {
								GCalcMathExpression* _tmp89_;
								_tmp89_ = self->priv->current;
								_tmp84_ = GCALC_IS_MATH_FUNCTION (_tmp89_);
							} else {
								_tmp84_ = FALSE;
							}
							if (_tmp84_) {
								GError* _tmp90_;
								_tmp90_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected function definition expression"));
								_inner_error0_ = _tmp90_;
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (sfunc);
								_g_free0 (n);
								return;
							} else {
								GCalcMathExpression* v = NULL;
								const gchar* _tmp91_;
								GCalcVariable* _tmp92_;
								GCalcMathExpression* _tmp93_;
								GCalcMathVariable* sv = NULL;
								const gchar* _tmp97_;
								GCalcMathVariable* _tmp98_;
								GCalcMathVariable* _tmp99_;
								GCalcMathVariable* _tmp100_;
								GCalcMathExpression* _tmp116_;
								_tmp91_ = n;
								_tmp92_ = gcalc_variable_new (_tmp91_);
								_tmp93_ = GCALC_IS_MATH_EXPRESSION (_tmp92_) ? ((GCalcMathExpression*) _tmp92_) : NULL;
								if (_tmp93_ == NULL) {
									_g_object_unref0 (_tmp92_);
								}
								v = _tmp93_;
								if (self->priv->enable_parameter) {
									const gchar* _tmp94_;
									GCalcParameter* _tmp95_;
									GCalcMathExpression* _tmp96_;
									_tmp94_ = n;
									_tmp95_ = gcalc_parameter_new (_tmp94_);
									_tmp96_ = GCALC_IS_MATH_EXPRESSION (_tmp95_) ? ((GCalcMathExpression*) _tmp95_) : NULL;
									if (_tmp96_ == NULL) {
										_g_object_unref0 (_tmp95_);
									}
									_g_object_unref0 (v);
									v = _tmp96_;
									self->priv->enable_parameter = FALSE;
								}
								_tmp97_ = n;
								_tmp98_ = gcalc_math_equation_manager_find_variable (eqman, _tmp97_);
								_tmp99_ = GCALC_IS_MATH_VARIABLE (_tmp98_) ? ((GCalcMathVariable*) _tmp98_) : NULL;
								if (_tmp99_ == NULL) {
									_g_object_unref0 (_tmp98_);
								}
								sv = _tmp99_;
								_tmp100_ = sv;
								if (_tmp100_ == NULL) {
									GCalcEquation* _tmp101_;
									GCalcExpressionHashMap* _tmp102_;
									GCalcExpressionHashMap* _tmp103_;
									const gchar* _tmp104_;
									GCalcMathExpression* _tmp105_;
									GCalcMathVariable* _tmp106_;
									GCalcMathVariable* _tmp107_;
									_tmp101_ = self->priv->eq;
									_tmp102_ = gcalc_math_equation_get_variables ((GCalcMathEquation*) _tmp101_);
									_tmp103_ = _tmp102_;
									_tmp104_ = n;
									_tmp105_ = gcalc_expression_hash_map_find_named (_tmp103_, _tmp104_);
									_tmp106_ = GCALC_IS_MATH_VARIABLE (_tmp105_) ? ((GCalcMathVariable*) _tmp105_) : NULL;
									if (_tmp106_ == NULL) {
										_g_object_unref0 (_tmp105_);
									}
									_g_object_unref0 (sv);
									sv = _tmp106_;
									_tmp107_ = sv;
									if (_tmp107_ == NULL) {
										GCalcEquation* _tmp108_;
										GCalcExpressionHashMap* _tmp109_;
										GCalcExpressionHashMap* _tmp110_;
										GCalcMathExpression* _tmp111_;
										_tmp108_ = self->priv->eq;
										_tmp109_ = gcalc_math_equation_get_variables ((GCalcMathEquation*) _tmp108_);
										_tmp110_ = _tmp109_;
										_tmp111_ = v;
										gcalc_expression_hash_map_add (_tmp110_, _tmp111_);
									} else {
										GCalcMathExpression* _tmp112_;
										GCalcMathVariable* _tmp113_;
										_tmp112_ = v;
										_tmp113_ = sv;
										gcalc_math_variable_set_bind (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GCALC_TYPE_MATH_VARIABLE, GCalcMathVariable), _tmp113_);
									}
								} else {
									GCalcMathExpression* _tmp114_;
									GCalcMathVariable* _tmp115_;
									_tmp114_ = v;
									_tmp115_ = sv;
									gcalc_math_variable_set_bind (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, GCALC_TYPE_MATH_VARIABLE, GCalcMathVariable), _tmp115_);
								}
								_tmp116_ = self->priv->current;
								if (_tmp116_ == NULL) {
									GCalcPolynomial* exp = NULL;
									GCalcPolynomial* _tmp117_;
									GCalcEquation* _tmp118_;
									GCalcExpressionContainer* _tmp119_;
									GCalcExpressionContainer* _tmp120_;
									GCalcPolynomial* _tmp121_;
									GCalcTerm* t = NULL;
									GCalcTerm* _tmp122_;
									GCalcPolynomial* _tmp123_;
									GCalcExpressionContainer* _tmp124_;
									GCalcExpressionContainer* _tmp125_;
									GCalcTerm* _tmp126_;
									GCalcTerm* _tmp127_;
									GCalcExpressionContainer* _tmp128_;
									GCalcExpressionContainer* _tmp129_;
									GCalcMathExpression* _tmp130_;
									GCalcMathExpression* _tmp131_;
									GCalcMathExpression* _tmp132_;
									GCalcMathExpression* _tmp133_;
									GCalcMathExpression* _tmp134_;
									GCalcMathExpression* _tmp135_;
									GCalcMathExpression* _tmp136_;
									GCalcMathExpression* _tmp137_;
									GCalcMathExpression* _tmp138_;
									GCalcMathExpression* _tmp139_;
									GCalcMathExpression* _tmp140_;
									GeeArrayList* _tmp141_;
									_tmp117_ = gcalc_polynomial_new ();
									exp = _tmp117_;
									_tmp118_ = self->priv->eq;
									_tmp119_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp118_);
									_tmp120_ = _tmp119_;
									_tmp121_ = exp;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, (GCalcMathExpression*) _tmp121_);
									_tmp122_ = gcalc_term_new ();
									t = _tmp122_;
									_tmp123_ = exp;
									_tmp124_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp123_);
									_tmp125_ = _tmp124_;
									_tmp126_ = t;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp125_, (GCalcMathExpression*) _tmp126_);
									_tmp127_ = t;
									_tmp128_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp127_);
									_tmp129_ = _tmp128_;
									_tmp130_ = v;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp129_, _tmp130_);
									_tmp131_ = v;
									_tmp132_ = _g_object_ref0 (_tmp131_);
									_g_object_unref0 (self->priv->current);
									self->priv->current = _tmp132_;
									_tmp133_ = v;
									_tmp134_ = gcalc_math_expression_get_parent (_tmp133_);
									_tmp135_ = _tmp134_;
									_tmp136_ = _g_object_ref0 (_tmp135_);
									_g_object_unref0 (self->priv->current_parent);
									self->priv->current_parent = _tmp136_;
									_tmp137_ = self->priv->current_parent;
									_tmp138_ = gcalc_math_expression_get_parent (_tmp137_);
									_tmp139_ = _tmp138_;
									_tmp140_ = _g_object_ref0 (_tmp139_);
									_g_object_unref0 (self->priv->top_parent);
									self->priv->top_parent = _tmp140_;
									_tmp141_ = self->priv->expected;
									gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp141_);
									_g_object_unref0 (t);
									_g_object_unref0 (exp);
								} else {
									gboolean _tmp142_ = FALSE;
									gboolean _tmp143_ = FALSE;
									GCalcMathExpression* _tmp144_;
									_tmp144_ = self->priv->current;
									if (GCALC_IS_MATH_OPERATOR (_tmp144_)) {
										GCalcMathExpression* _tmp145_;
										_tmp145_ = self->priv->current_parent;
										_tmp143_ = GCALC_IS_MATH_TERM (_tmp145_);
									} else {
										_tmp143_ = FALSE;
									}
									if (_tmp143_) {
										GCalcMathExpression* _tmp146_;
										_tmp146_ = self->priv->top_parent;
										_tmp142_ = GCALC_IS_MATH_POLYNOMIAL (_tmp146_);
									} else {
										_tmp142_ = FALSE;
									}
									if (_tmp142_) {
										GCalcMathExpression* _tmp147_;
										GCalcExpressionContainer* _tmp148_;
										GCalcExpressionContainer* _tmp149_;
										GCalcMathExpression* _tmp150_;
										GCalcMathExpression* _tmp151_;
										GCalcMathExpression* _tmp152_;
										GeeArrayList* _tmp153_;
										_tmp147_ = self->priv->current_parent;
										_tmp148_ = gcalc_math_expression_get_expressions (_tmp147_);
										_tmp149_ = _tmp148_;
										_tmp150_ = v;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp149_, _tmp150_);
										_tmp151_ = v;
										_tmp152_ = _g_object_ref0 (_tmp151_);
										_g_object_unref0 (self->priv->current);
										self->priv->current = _tmp152_;
										_tmp153_ = self->priv->expected;
										gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp153_);
									} else {
										GCalcMathExpression* _tmp154_;
										_tmp154_ = self->priv->current;
										if (GCALC_IS_MATH_TERM (_tmp154_)) {
											GCalcMathExpression* _tmp155_;
											GCalcExpressionContainer* _tmp156_;
											GCalcExpressionContainer* _tmp157_;
											GCalcMathExpression* _tmp158_;
											GCalcMathExpression* _tmp159_;
											GCalcMathExpression* _tmp160_;
											GCalcMathExpression* _tmp161_;
											GCalcMathExpression* _tmp162_;
											GCalcMathExpression* _tmp163_;
											GCalcMathExpression* _tmp164_;
											GCalcMathExpression* _tmp165_;
											GCalcMathExpression* _tmp166_;
											GCalcMathExpression* _tmp167_;
											GCalcMathExpression* _tmp168_;
											GeeArrayList* _tmp169_;
											_tmp155_ = self->priv->current;
											_tmp156_ = gcalc_math_expression_get_expressions (_tmp155_);
											_tmp157_ = _tmp156_;
											_tmp158_ = v;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp157_, _tmp158_);
											_tmp159_ = v;
											_tmp160_ = _g_object_ref0 (_tmp159_);
											_g_object_unref0 (self->priv->current);
											self->priv->current = _tmp160_;
											_tmp161_ = v;
											_tmp162_ = gcalc_math_expression_get_parent (_tmp161_);
											_tmp163_ = _tmp162_;
											_tmp164_ = _g_object_ref0 (_tmp163_);
											_g_object_unref0 (self->priv->current_parent);
											self->priv->current_parent = _tmp164_;
											_tmp165_ = self->priv->current_parent;
											_tmp166_ = gcalc_math_expression_get_parent (_tmp165_);
											_tmp167_ = _tmp166_;
											_tmp168_ = _g_object_ref0 (_tmp167_);
											_g_object_unref0 (self->priv->top_parent);
											self->priv->top_parent = _tmp168_;
											_tmp169_ = self->priv->expected;
											gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp169_);
										}
									}
								}
								_g_object_unref0 (sv);
								_g_object_unref0 (v);
							}
						}
					}
					_g_object_unref0 (sfunc);
				}
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_INTEGER_LITERAL:
			case GCALC_PARSER_TOKEN_TYPE_REAL_LITERAL:
			{
				gdouble res = 0.0;
				const gchar* _tmp170_;
				gdouble _tmp171_ = 0.0;
				gboolean _tmp172_;
				GCalcConstant* cexp = NULL;
				const gchar* _tmp174_;
				GCalcConstant* _tmp175_;
				GCalcConstant* _tmp176_;
				res = (gdouble) 0;
				_tmp170_ = n;
				_tmp172_ = double_try_parse (_tmp170_, &_tmp171_, NULL);
				res = _tmp171_;
				if (!_tmp172_) {
					GError* _tmp173_;
					_tmp173_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression for a constant"));
					_inner_error0_ = _tmp173_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (n);
					return;
				}
				_tmp174_ = n;
				_tmp175_ = gcalc_constant_new_double (double_parse (_tmp174_));
				cexp = _tmp175_;
				_tmp176_ = cexp;
				gcalc_parser_add_constant (self, (GCalcMathConstant*) _tmp176_);
				_g_object_unref0 (cexp);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_STAR:
			{
				GCalcMultiply* op = NULL;
				GCalcMultiply* _tmp177_;
				GCalcMultiply* _tmp178_;
				GCalcEquation* _tmp179_;
				_tmp177_ = gcalc_multiply_new ();
				op = _tmp177_;
				_tmp178_ = op;
				_tmp179_ = self->priv->eq;
				gcalc_parser_process_term_operator (self, (GCalcMathOperator*) _tmp178_, _tmp179_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (op);
					_g_free0 (n);
					return;
				}
				_g_object_unref0 (op);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_PLUS:
			{
				GCalcPlus* opp = NULL;
				GCalcPlus* _tmp180_;
				GCalcPlus* _tmp181_;
				GCalcEquation* _tmp182_;
				_tmp180_ = gcalc_plus_new ();
				opp = _tmp180_;
				_tmp181_ = opp;
				_tmp182_ = self->priv->eq;
				gcalc_parser_process_operator (self, (GCalcMathOperator*) _tmp181_, _tmp182_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (opp);
					_g_free0 (n);
					return;
				}
				_g_object_unref0 (opp);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_DIV:
			{
				GCalcDivision* op = NULL;
				GCalcDivision* _tmp183_;
				GCalcDivision* _tmp184_;
				GCalcEquation* _tmp185_;
				_tmp183_ = gcalc_division_new ();
				op = _tmp183_;
				_tmp184_ = op;
				_tmp185_ = self->priv->eq;
				gcalc_parser_process_term_operator (self, (GCalcMathOperator*) _tmp184_, _tmp185_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (op);
					_g_free0 (n);
					return;
				}
				_g_object_unref0 (op);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_MINUS:
			{
				GCalcMinus* opp = NULL;
				GCalcMinus* _tmp186_;
				GCalcMinus* _tmp187_;
				GCalcEquation* _tmp188_;
				_tmp186_ = gcalc_minus_new ();
				opp = _tmp186_;
				_tmp187_ = opp;
				_tmp188_ = self->priv->eq;
				gcalc_parser_process_operator (self, (GCalcMathOperator*) _tmp187_, _tmp188_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (opp);
					_g_free0 (n);
					return;
				}
				_g_object_unref0 (opp);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_ASSIGN:
			{
				GCalcMathExpression* _tmp189_;
				_tmp189_ = self->priv->current;
				if (_tmp189_ == NULL) {
					GError* _tmp190_;
					_tmp190_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression for an assignment"));
					_inner_error0_ = _tmp190_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (n);
					return;
				} else {
					GCalcMathExpression* _tmp191_;
					_tmp191_ = self->priv->current;
					if (GCALC_IS_MATH_POLYNOMIAL (_tmp191_)) {
						GError* _tmp192_;
						_tmp192_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression: can't set a value to a polynomial"));
						_inner_error0_ = _tmp192_;
						g_propagate_error (error, _inner_error0_);
						_g_free0 (n);
						return;
					} else {
						GCalcMathExpression* _tmp193_;
						_tmp193_ = self->priv->current;
						if (GCALC_IS_MATH_VARIABLE (_tmp193_)) {
							gboolean removed = FALSE;
							GCalcMathExpression* _tmp194_;
							GCalcMathExpression* _tmp195_;
							GCalcMathExpression* _tmp196_;
							GCalcAssign* expa = NULL;
							GCalcAssign* _tmp229_;
							GCalcEquation* _tmp230_;
							GCalcExpressionContainer* _tmp231_;
							GCalcExpressionContainer* _tmp232_;
							GCalcAssign* _tmp233_;
							GCalcAssign* _tmp234_;
							GCalcExpressionContainer* _tmp235_;
							GCalcExpressionContainer* _tmp236_;
							GCalcMathExpression* _tmp237_;
							GCalcPolynomial* exp = NULL;
							GCalcPolynomial* _tmp238_;
							GCalcAssign* _tmp239_;
							GCalcExpressionContainer* _tmp240_;
							GCalcExpressionContainer* _tmp241_;
							GCalcPolynomial* _tmp242_;
							GCalcTerm* t = NULL;
							GCalcTerm* _tmp243_;
							GCalcPolynomial* _tmp244_;
							GCalcExpressionContainer* _tmp245_;
							GCalcExpressionContainer* _tmp246_;
							GCalcTerm* _tmp247_;
							GCalcTerm* _tmp248_;
							GCalcMathExpression* _tmp249_;
							GCalcTerm* _tmp250_;
							GCalcMathExpression* _tmp251_;
							GCalcPolynomial* _tmp252_;
							GCalcMathExpression* _tmp253_;
							GeeArrayList* _tmp254_;
							removed = FALSE;
							_tmp194_ = self->priv->current;
							_tmp195_ = gcalc_math_expression_get_parent (_tmp194_);
							_tmp196_ = _tmp195_;
							if (_tmp196_ != NULL) {
								GCalcMathExpression* _tmp197_;
								GCalcMathExpression* _tmp198_;
								GCalcMathExpression* _tmp199_;
								_tmp197_ = self->priv->current;
								_tmp198_ = gcalc_math_expression_get_parent (_tmp197_);
								_tmp199_ = _tmp198_;
								if (GCALC_IS_MATH_TERM (_tmp199_)) {
									GCalcMathExpression* t = NULL;
									GCalcMathExpression* _tmp200_;
									GCalcMathExpression* _tmp201_;
									GCalcMathExpression* _tmp202_;
									GCalcMathExpression* _tmp203_;
									GCalcMathExpression* _tmp204_;
									GCalcMathExpression* _tmp205_;
									GCalcMathExpression* _tmp206_;
									_tmp200_ = self->priv->current;
									_tmp201_ = gcalc_math_expression_get_parent (_tmp200_);
									_tmp202_ = _tmp201_;
									_tmp203_ = _g_object_ref0 (_tmp202_);
									t = _tmp203_;
									_tmp204_ = t;
									_tmp205_ = gcalc_math_expression_get_parent (_tmp204_);
									_tmp206_ = _tmp205_;
									if (_tmp206_ != NULL) {
										GCalcMathExpression* _tmp207_;
										GCalcMathExpression* _tmp208_;
										GCalcMathExpression* _tmp209_;
										_tmp207_ = t;
										_tmp208_ = gcalc_math_expression_get_parent (_tmp207_);
										_tmp209_ = _tmp208_;
										if (GCALC_IS_MATH_POLYNOMIAL (_tmp209_)) {
											GCalcMathExpression* p = NULL;
											GCalcMathExpression* _tmp210_;
											GCalcMathExpression* _tmp211_;
											GCalcMathExpression* _tmp212_;
											GCalcMathExpression* _tmp213_;
											GCalcMathExpression* _tmp214_;
											GCalcMathExpression* _tmp215_;
											GCalcMathExpression* _tmp216_;
											_tmp210_ = t;
											_tmp211_ = gcalc_math_expression_get_parent (_tmp210_);
											_tmp212_ = _tmp211_;
											_tmp213_ = _g_object_ref0 (_tmp212_);
											p = _tmp213_;
											_tmp214_ = p;
											_tmp215_ = gcalc_math_expression_get_parent (_tmp214_);
											_tmp216_ = _tmp215_;
											if (_tmp216_ != NULL) {
												GCalcMathExpression* _tmp217_;
												GCalcMathExpression* _tmp218_;
												GCalcMathExpression* _tmp219_;
												_tmp217_ = p;
												_tmp218_ = gcalc_math_expression_get_parent (_tmp217_);
												_tmp219_ = _tmp218_;
												if (GCALC_IS_MATH_EQUATION (_tmp219_)) {
													GCalcEquation* _tmp220_;
													GCalcExpressionContainer* _tmp221_;
													GCalcExpressionContainer* _tmp222_;
													GCalcMathExpression* _tmp223_;
													GCalcMathExpression* _tmp224_;
													GCalcExpressionContainer* _tmp225_;
													GCalcExpressionContainer* _tmp226_;
													GCalcMathExpression* _tmp227_;
													_tmp220_ = self->priv->eq;
													_tmp221_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp220_);
													_tmp222_ = _tmp221_;
													_tmp223_ = p;
													gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp222_, _tmp223_);
													_tmp224_ = p;
													_tmp225_ = gcalc_math_expression_get_expressions (_tmp224_);
													_tmp226_ = _tmp225_;
													_tmp227_ = t;
													gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp226_, _tmp227_);
													removed = TRUE;
												}
											}
											_g_object_unref0 (p);
										}
									}
									_g_object_unref0 (t);
								}
							}
							if (!removed) {
								GError* _tmp228_;
								_tmp228_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_EXPRESSION_ERROR, _ ("Found an unexpected expression for an assignment. Assignment should be" \
" done on variables"));
								_inner_error0_ = _tmp228_;
								g_propagate_error (error, _inner_error0_);
								_g_free0 (n);
								return;
							}
							_tmp229_ = gcalc_assign_new ();
							expa = _tmp229_;
							_tmp230_ = self->priv->eq;
							_tmp231_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp230_);
							_tmp232_ = _tmp231_;
							_tmp233_ = expa;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp232_, (GCalcMathExpression*) _tmp233_);
							_tmp234_ = expa;
							_tmp235_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp234_);
							_tmp236_ = _tmp235_;
							_tmp237_ = self->priv->current;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp236_, _tmp237_);
							_tmp238_ = gcalc_polynomial_new ();
							exp = _tmp238_;
							_tmp239_ = expa;
							_tmp240_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp239_);
							_tmp241_ = _tmp240_;
							_tmp242_ = exp;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp241_, (GCalcMathExpression*) _tmp242_);
							_tmp243_ = gcalc_term_new ();
							t = _tmp243_;
							_tmp244_ = exp;
							_tmp245_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp244_);
							_tmp246_ = _tmp245_;
							_tmp247_ = t;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp246_, (GCalcMathExpression*) _tmp247_);
							_tmp248_ = t;
							_tmp249_ = _g_object_ref0 ((GCalcMathExpression*) _tmp248_);
							_g_object_unref0 (self->priv->current);
							self->priv->current = _tmp249_;
							_tmp250_ = t;
							_tmp251_ = _g_object_ref0 ((GCalcMathExpression*) _tmp250_);
							_g_object_unref0 (self->priv->current_parent);
							self->priv->current_parent = _tmp251_;
							_tmp252_ = exp;
							_tmp253_ = _g_object_ref0 ((GCalcMathExpression*) _tmp252_);
							_g_object_unref0 (self->priv->top_parent);
							self->priv->top_parent = _tmp253_;
							_tmp254_ = self->priv->expected;
							gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp254_);
							_g_object_unref0 (t);
							_g_object_unref0 (exp);
							_g_object_unref0 (expa);
						}
					}
				}
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_OPEN_PARENS:
			{
				GCalcMathExpression* _tmp255_;
				_tmp255_ = self->priv->current;
				if (_tmp255_ == NULL) {
					GCalcPolynomial* exp = NULL;
					GCalcPolynomial* _tmp256_;
					GCalcEquation* _tmp257_;
					GCalcExpressionContainer* _tmp258_;
					GCalcExpressionContainer* _tmp259_;
					GCalcPolynomial* _tmp260_;
					GCalcTerm* t = NULL;
					GCalcTerm* _tmp261_;
					GCalcPolynomial* _tmp262_;
					GCalcExpressionContainer* _tmp263_;
					GCalcExpressionContainer* _tmp264_;
					GCalcTerm* _tmp265_;
					GCalcGroup* g = NULL;
					GCalcGroup* _tmp266_;
					GCalcTerm* _tmp267_;
					GCalcExpressionContainer* _tmp268_;
					GCalcExpressionContainer* _tmp269_;
					GCalcGroup* _tmp270_;
					GCalcPolynomial* exp2 = NULL;
					GCalcPolynomial* _tmp271_;
					GCalcTerm* t2 = NULL;
					GCalcTerm* _tmp272_;
					GCalcPolynomial* _tmp273_;
					GCalcExpressionContainer* _tmp274_;
					GCalcExpressionContainer* _tmp275_;
					GCalcTerm* _tmp276_;
					GCalcGroup* _tmp277_;
					GCalcExpressionContainer* _tmp278_;
					GCalcExpressionContainer* _tmp279_;
					GCalcPolynomial* _tmp280_;
					GCalcTerm* _tmp281_;
					GCalcMathExpression* _tmp282_;
					GCalcPolynomial* _tmp283_;
					GCalcMathExpression* _tmp284_;
					GCalcGroup* _tmp285_;
					GCalcMathExpression* _tmp286_;
					_tmp256_ = gcalc_polynomial_new ();
					exp = _tmp256_;
					_tmp257_ = self->priv->eq;
					_tmp258_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = exp;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp259_, (GCalcMathExpression*) _tmp260_);
					_tmp261_ = gcalc_term_new ();
					t = _tmp261_;
					_tmp262_ = exp;
					_tmp263_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = t;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp264_, (GCalcMathExpression*) _tmp265_);
					_tmp266_ = gcalc_group_new ();
					g = _tmp266_;
					_tmp267_ = t;
					_tmp268_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp267_);
					_tmp269_ = _tmp268_;
					_tmp270_ = g;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp269_, (GCalcMathExpression*) _tmp270_);
					_tmp271_ = gcalc_polynomial_new ();
					exp2 = _tmp271_;
					_tmp272_ = gcalc_term_new ();
					t2 = _tmp272_;
					_tmp273_ = exp2;
					_tmp274_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = t2;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp275_, (GCalcMathExpression*) _tmp276_);
					_tmp277_ = g;
					_tmp278_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = exp2;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp279_, (GCalcMathExpression*) _tmp280_);
					_tmp281_ = t2;
					_tmp282_ = _g_object_ref0 ((GCalcMathExpression*) _tmp281_);
					_g_object_unref0 (self->priv->current);
					self->priv->current = _tmp282_;
					_tmp283_ = exp2;
					_tmp284_ = _g_object_ref0 ((GCalcMathExpression*) _tmp283_);
					_g_object_unref0 (self->priv->current_parent);
					self->priv->current_parent = _tmp284_;
					_tmp285_ = g;
					_tmp286_ = _g_object_ref0 ((GCalcMathExpression*) _tmp285_);
					_g_object_unref0 (self->priv->top_parent);
					self->priv->top_parent = _tmp286_;
					_g_object_unref0 (t2);
					_g_object_unref0 (exp2);
					_g_object_unref0 (g);
					_g_object_unref0 (t);
					_g_object_unref0 (exp);
				} else {
					GCalcMathExpression* _tmp287_;
					_tmp287_ = self->priv->current;
					if (GCALC_IS_MATH_FUNCTION (_tmp287_)) {
						GCalcPolynomial* fexp = NULL;
						GCalcPolynomial* _tmp288_;
						GCalcTerm* t = NULL;
						GCalcTerm* _tmp289_;
						GCalcPolynomial* _tmp290_;
						GCalcExpressionContainer* _tmp291_;
						GCalcExpressionContainer* _tmp292_;
						GCalcTerm* _tmp293_;
						GCalcMathExpression* _tmp294_;
						GCalcExpressionContainer* _tmp295_;
						GCalcExpressionContainer* _tmp296_;
						GCalcPolynomial* _tmp297_;
						GCalcMathExpression* _tmp298_;
						GCalcMathExpression* _tmp299_;
						GCalcTerm* _tmp300_;
						GCalcMathExpression* _tmp301_;
						GCalcPolynomial* _tmp302_;
						GCalcMathExpression* _tmp303_;
						GeeArrayList* _tmp304_;
						_tmp288_ = gcalc_polynomial_new ();
						fexp = _tmp288_;
						_tmp289_ = gcalc_term_new ();
						t = _tmp289_;
						_tmp290_ = fexp;
						_tmp291_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp290_);
						_tmp292_ = _tmp291_;
						_tmp293_ = t;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp292_, (GCalcMathExpression*) _tmp293_);
						_tmp294_ = self->priv->current;
						_tmp295_ = gcalc_math_expression_get_expressions (_tmp294_);
						_tmp296_ = _tmp295_;
						_tmp297_ = fexp;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp296_, (GCalcMathExpression*) _tmp297_);
						_tmp298_ = self->priv->current;
						_tmp299_ = _g_object_ref0 (_tmp298_);
						_g_object_unref0 (self->priv->top_parent);
						self->priv->top_parent = _tmp299_;
						_tmp300_ = t;
						_tmp301_ = _g_object_ref0 ((GCalcMathExpression*) _tmp300_);
						_g_object_unref0 (self->priv->current);
						self->priv->current = _tmp301_;
						_tmp302_ = fexp;
						_tmp303_ = _g_object_ref0 ((GCalcMathExpression*) _tmp302_);
						_g_object_unref0 (self->priv->current_parent);
						self->priv->current_parent = _tmp303_;
						_tmp304_ = self->priv->expected;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp304_);
						_g_object_unref0 (t);
						_g_object_unref0 (fexp);
					} else {
						gboolean _tmp305_ = FALSE;
						gboolean _tmp306_ = FALSE;
						GCalcMathExpression* _tmp307_;
						_tmp307_ = self->priv->current;
						if (GCALC_IS_MATH_OPERATOR (_tmp307_)) {
							GCalcMathExpression* _tmp308_;
							_tmp308_ = self->priv->current_parent;
							_tmp306_ = GCALC_IS_MATH_TERM (_tmp308_);
						} else {
							_tmp306_ = FALSE;
						}
						if (_tmp306_) {
							GCalcMathExpression* _tmp309_;
							_tmp309_ = self->priv->top_parent;
							_tmp305_ = GCALC_IS_MATH_POLYNOMIAL (_tmp309_);
						} else {
							_tmp305_ = FALSE;
						}
						if (_tmp305_) {
							GCalcGroup* g = NULL;
							GCalcGroup* _tmp310_;
							GCalcMathExpression* _tmp311_;
							GCalcExpressionContainer* _tmp312_;
							GCalcExpressionContainer* _tmp313_;
							GCalcGroup* _tmp314_;
							GCalcPolynomial* exp = NULL;
							GCalcPolynomial* _tmp315_;
							GCalcGroup* _tmp316_;
							GCalcExpressionContainer* _tmp317_;
							GCalcExpressionContainer* _tmp318_;
							GCalcPolynomial* _tmp319_;
							GCalcTerm* t = NULL;
							GCalcTerm* _tmp320_;
							GCalcPolynomial* _tmp321_;
							GCalcExpressionContainer* _tmp322_;
							GCalcExpressionContainer* _tmp323_;
							GCalcTerm* _tmp324_;
							GCalcTerm* _tmp325_;
							GCalcMathExpression* _tmp326_;
							GCalcPolynomial* _tmp327_;
							GCalcMathExpression* _tmp328_;
							GCalcGroup* _tmp329_;
							GCalcMathExpression* _tmp330_;
							_tmp310_ = gcalc_group_new ();
							g = _tmp310_;
							_tmp311_ = self->priv->current_parent;
							_tmp312_ = gcalc_math_expression_get_expressions (_tmp311_);
							_tmp313_ = _tmp312_;
							_tmp314_ = g;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp313_, (GCalcMathExpression*) _tmp314_);
							_tmp315_ = gcalc_polynomial_new ();
							exp = _tmp315_;
							_tmp316_ = g;
							_tmp317_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp316_);
							_tmp318_ = _tmp317_;
							_tmp319_ = exp;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp318_, (GCalcMathExpression*) _tmp319_);
							_tmp320_ = gcalc_term_new ();
							t = _tmp320_;
							_tmp321_ = exp;
							_tmp322_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp321_);
							_tmp323_ = _tmp322_;
							_tmp324_ = t;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp323_, (GCalcMathExpression*) _tmp324_);
							_tmp325_ = t;
							_tmp326_ = _g_object_ref0 ((GCalcMathExpression*) _tmp325_);
							_g_object_unref0 (self->priv->current);
							self->priv->current = _tmp326_;
							_tmp327_ = exp;
							_tmp328_ = _g_object_ref0 ((GCalcMathExpression*) _tmp327_);
							_g_object_unref0 (self->priv->current_parent);
							self->priv->current_parent = _tmp328_;
							_tmp329_ = g;
							_tmp330_ = _g_object_ref0 ((GCalcMathExpression*) _tmp329_);
							_g_object_unref0 (self->priv->top_parent);
							self->priv->top_parent = _tmp330_;
							_g_object_unref0 (t);
							_g_object_unref0 (exp);
							_g_object_unref0 (g);
						}
					}
				}
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_CLOSE_PARENS:
			{
				GCalcMathExpression* _tmp331_;
				gboolean foundp = FALSE;
				GCalcMathExpression* par = NULL;
				GCalcMathExpression* _tmp333_;
				GCalcMathExpression* _tmp334_;
				_tmp331_ = self->priv->current;
				if (_tmp331_ == NULL) {
					GError* _tmp332_;
					_tmp332_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression while closing parenthesis"));
					_inner_error0_ = _tmp332_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (n);
					return;
				}
				foundp = FALSE;
				_tmp333_ = self->priv->current;
				_tmp334_ = _g_object_ref0 (_tmp333_);
				par = _tmp334_;
				while (TRUE) {
					GCalcMathExpression* _tmp335_;
					GCalcMathExpression* _tmp336_;
					GCalcMathExpression* _tmp341_;
					GCalcMathExpression* _tmp346_;
					GCalcMathExpression* _tmp347_;
					GCalcMathExpression* _tmp348_;
					GCalcMathExpression* _tmp349_;
					_tmp335_ = par;
					if (!(_tmp335_ != NULL)) {
						break;
					}
					_tmp336_ = par;
					if (GCALC_IS_MATH_GROUP (_tmp336_)) {
						GCalcMathExpression* _tmp337_;
						gboolean _tmp338_;
						gboolean _tmp339_;
						_tmp337_ = par;
						_tmp338_ = gcalc_math_group_get_closed (G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, GCALC_TYPE_MATH_GROUP, GCalcMathGroup));
						_tmp339_ = _tmp338_;
						if (!_tmp339_) {
							GCalcMathExpression* _tmp340_;
							foundp = TRUE;
							_tmp340_ = par;
							gcalc_math_group_set_closed (G_TYPE_CHECK_INSTANCE_CAST (_tmp340_, GCALC_TYPE_MATH_GROUP, GCalcMathGroup), TRUE);
							break;
						}
					}
					_tmp341_ = par;
					if (GCALC_IS_MATH_FUNCTION (_tmp341_)) {
						GCalcMathExpression* _tmp342_;
						gboolean _tmp343_;
						gboolean _tmp344_;
						_tmp342_ = par;
						_tmp343_ = gcalc_math_function_get_closed (G_TYPE_CHECK_INSTANCE_CAST (_tmp342_, GCALC_TYPE_MATH_FUNCTION, GCalcMathFunction));
						_tmp344_ = _tmp343_;
						if (!_tmp344_) {
							GCalcMathExpression* _tmp345_;
							foundp = TRUE;
							_tmp345_ = par;
							gcalc_math_function_set_closed (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, GCALC_TYPE_MATH_FUNCTION, GCalcMathFunction), TRUE);
							break;
						}
					}
					_tmp346_ = par;
					_tmp347_ = gcalc_math_expression_get_parent (_tmp346_);
					_tmp348_ = _tmp347_;
					_tmp349_ = _g_object_ref0 (_tmp348_);
					_g_object_unref0 (par);
					par = _tmp349_;
				}
				if (foundp) {
					GCalcMathExpression* _tmp350_;
					GCalcMathExpression* _tmp351_;
					GCalcMathExpression* _tmp352_;
					GCalcMathExpression* _tmp353_;
					GCalcMathExpression* _tmp354_;
					GCalcMathExpression* _tmp355_;
					GCalcMathExpression* _tmp356_;
					GCalcMathExpression* _tmp357_;
					GCalcMathExpression* _tmp358_;
					GCalcMathExpression* _tmp359_;
					_tmp350_ = par;
					_tmp351_ = _g_object_ref0 (_tmp350_);
					_g_object_unref0 (self->priv->current);
					self->priv->current = _tmp351_;
					_tmp352_ = par;
					_tmp353_ = gcalc_math_expression_get_parent (_tmp352_);
					_tmp354_ = _tmp353_;
					_tmp355_ = _g_object_ref0 (_tmp354_);
					_g_object_unref0 (self->priv->current_parent);
					self->priv->current_parent = _tmp355_;
					_tmp356_ = self->priv->current_parent;
					_tmp357_ = gcalc_math_expression_get_parent (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = _g_object_ref0 (_tmp358_);
					_g_object_unref0 (self->priv->top_parent);
					self->priv->top_parent = _tmp359_;
				}
				_g_object_unref0 (par);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_CARRET:
			{
				GCalcPow* op = NULL;
				GCalcPow* _tmp360_;
				GCalcMathExpression* _tmp361_;
				_tmp360_ = gcalc_pow_new ();
				op = _tmp360_;
				_tmp361_ = self->priv->current;
				if (_tmp361_ == NULL) {
					GError* _tmp362_;
					_tmp362_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression trying power expression"));
					_inner_error0_ = _tmp362_;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (op);
					_g_free0 (n);
					return;
				} else {
					GCalcPow* _tmp363_;
					GCalcEquation* _tmp364_;
					_tmp363_ = op;
					_tmp364_ = self->priv->eq;
					gcalc_parser_process_term_operator (self, (GCalcMathOperator*) _tmp363_, _tmp364_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (op);
						_g_free0 (n);
						return;
					}
				}
				_g_object_unref0 (op);
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACE:
			case GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACKET:
			case GCALC_PARSER_TOKEN_TYPE_OPEN_BRACE:
			case GCALC_PARSER_TOKEN_TYPE_OPEN_BRACKET:
			{
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_STRING_LITERAL:
			{
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_OP_AND:
			case GCALC_PARSER_TOKEN_TYPE_OP_COALESCING:
			case GCALC_PARSER_TOKEN_TYPE_OP_DEC:
			case GCALC_PARSER_TOKEN_TYPE_OP_EQ:
			case GCALC_PARSER_TOKEN_TYPE_OP_GE:
			case GCALC_PARSER_TOKEN_TYPE_OP_GT:
			case GCALC_PARSER_TOKEN_TYPE_OP_INC:
			case GCALC_PARSER_TOKEN_TYPE_OP_LE:
			case GCALC_PARSER_TOKEN_TYPE_OP_LT:
			case GCALC_PARSER_TOKEN_TYPE_OP_NE:
			case GCALC_PARSER_TOKEN_TYPE_OP_NEG:
			case GCALC_PARSER_TOKEN_TYPE_OP_OR:
			case GCALC_PARSER_TOKEN_TYPE_OP_PTR:
			case GCALC_PARSER_TOKEN_TYPE_OP_SHIFT_LEFT:
			case GCALC_PARSER_TOKEN_TYPE_SEMICOLON:
			case GCALC_PARSER_TOKEN_TYPE_TILDE:
			case GCALC_PARSER_TOKEN_TYPE_COLON:
			case GCALC_PARSER_TOKEN_TYPE_COMMA:
			case GCALC_PARSER_TOKEN_TYPE_DOUBLE_COLON:
			case GCALC_PARSER_TOKEN_TYPE_DOT:
			case GCALC_PARSER_TOKEN_TYPE_ELLIPSIS:
			case GCALC_PARSER_TOKEN_TYPE_INTERR:
			case GCALC_PARSER_TOKEN_TYPE_HASH:
			{
				GEnumValue* _tmp365_;
				GError* _tmp366_;
				_tmp365_ = g_enum_get_value (g_type_class_ref (GCALC_PARSER_TYPE_TOKEN_TYPE), token);
				_tmp366_ = g_error_new (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression: '%s'"), (_tmp365_ != NULL) ? _tmp365_->value_name : NULL);
				_inner_error0_ = _tmp366_;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (n);
				return;
			}
			case GCALC_PARSER_TOKEN_TYPE_CURRENCY_SYMBOL:
			{
				self->priv->enable_parameter = TRUE;
				break;
			}
			case GCALC_PARSER_TOKEN_TYPE_EOF:
			{
				GError* _tmp367_;
				_tmp367_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected end of file"));
				_inner_error0_ = _tmp367_;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (n);
				return;
			}
			case GCALC_PARSER_TOKEN_TYPE_NONE:
			{
				break;
			}
			default:
			break;
		}
		_g_free0 (n);
	}
	_tmp368_ = gcalc_math_equation_manager_get_equations (eqman);
	_tmp369_ = _tmp368_;
	_tmp370_ = self->priv->eq;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp369_, (GCalcMathExpression*) _tmp370_);
}

static void
gcalc_parser_process_operator (GCalcParser* self,
                               GCalcMathOperator* opp,
                               GCalcEquation* eq,
                               GError** error)
{
	GCalcMathExpression* _tmp0_;
	GCalcMathExpression* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (opp != NULL);
	g_return_if_fail (eq != NULL);
	_tmp0_ = self->priv->current;
	if (GCALC_IS_MATH_BINARY_OPERATOR (_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression for a plus operator"));
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->priv->current;
	if (_tmp2_ == NULL) {
		GCalcPolynomial* exp = NULL;
		GCalcPolynomial* _tmp3_;
		GCalcTerm* t = NULL;
		GCalcTerm* _tmp4_;
		GCalcTerm* _tmp5_;
		GCalcExpressionContainer* _tmp6_;
		GCalcExpressionContainer* _tmp7_;
		GCalcPolynomial* _tmp8_;
		GCalcExpressionContainer* _tmp9_;
		GCalcExpressionContainer* _tmp10_;
		GCalcTerm* _tmp11_;
		GCalcMathExpression* _tmp12_;
		GCalcTerm* _tmp13_;
		GCalcMathExpression* _tmp14_;
		GCalcPolynomial* _tmp15_;
		GCalcMathExpression* _tmp16_;
		GCalcExpressionContainer* _tmp17_;
		GCalcExpressionContainer* _tmp18_;
		GCalcPolynomial* _tmp19_;
		GeeArrayList* _tmp20_;
		_tmp3_ = gcalc_polynomial_new ();
		exp = _tmp3_;
		_tmp4_ = gcalc_term_new ();
		t = _tmp4_;
		_tmp5_ = t;
		_tmp6_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp5_);
		_tmp7_ = _tmp6_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (GCalcMathExpression*) opp);
		_tmp8_ = exp;
		_tmp9_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = t;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (GCalcMathExpression*) _tmp11_);
		_tmp12_ = _g_object_ref0 ((GCalcMathExpression*) opp);
		_g_object_unref0 (self->priv->current);
		self->priv->current = _tmp12_;
		_tmp13_ = t;
		_tmp14_ = _g_object_ref0 ((GCalcMathExpression*) _tmp13_);
		_g_object_unref0 (self->priv->current_parent);
		self->priv->current_parent = _tmp14_;
		_tmp15_ = exp;
		_tmp16_ = _g_object_ref0 ((GCalcMathExpression*) _tmp15_);
		_g_object_unref0 (self->priv->top_parent);
		self->priv->top_parent = _tmp16_;
		_tmp17_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) eq);
		_tmp18_ = _tmp17_;
		_tmp19_ = exp;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (GCalcMathExpression*) _tmp19_);
		_tmp20_ = self->priv->expected;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp20_);
		_g_object_unref0 (t);
		_g_object_unref0 (exp);
	} else {
		gboolean _tmp21_ = FALSE;
		GCalcMathExpression* _tmp22_;
		_tmp22_ = self->priv->current_parent;
		if (GCALC_IS_MATH_POLYNOMIAL (_tmp22_)) {
			GCalcMathExpression* _tmp23_;
			_tmp23_ = self->priv->current;
			_tmp21_ = GCALC_IS_MATH_TERM (_tmp23_);
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GCalcMathExpression* _tmp24_;
			GCalcExpressionContainer* _tmp25_;
			GCalcExpressionContainer* _tmp26_;
			GCalcMathExpression* _tmp27_;
			GCalcMathExpression* _tmp28_;
			GCalcMathExpression* _tmp29_;
			GCalcMathExpression* _tmp30_;
			GCalcMathExpression* _tmp31_;
			GeeArrayList* _tmp32_;
			_tmp24_ = self->priv->current;
			_tmp25_ = gcalc_math_expression_get_expressions (_tmp24_);
			_tmp26_ = _tmp25_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (GCalcMathExpression*) opp);
			_tmp27_ = self->priv->current_parent;
			_tmp28_ = _g_object_ref0 (_tmp27_);
			_g_object_unref0 (self->priv->top_parent);
			self->priv->top_parent = _tmp28_;
			_tmp29_ = self->priv->current;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			_g_object_unref0 (self->priv->current_parent);
			self->priv->current_parent = _tmp30_;
			_tmp31_ = _g_object_ref0 ((GCalcMathExpression*) opp);
			_g_object_unref0 (self->priv->current);
			self->priv->current = _tmp31_;
			_tmp32_ = self->priv->expected;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp32_);
		} else {
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_ = FALSE;
			GCalcMathExpression* _tmp36_;
			_tmp36_ = self->priv->current;
			if (GCALC_IS_MATH_CONSTANT (_tmp36_)) {
				_tmp35_ = TRUE;
			} else {
				GCalcMathExpression* _tmp37_;
				_tmp37_ = self->priv->current;
				_tmp35_ = GCALC_IS_MATH_VARIABLE (_tmp37_);
			}
			if (_tmp35_) {
				GCalcMathExpression* _tmp38_;
				_tmp38_ = self->priv->current_parent;
				_tmp34_ = GCALC_IS_MATH_TERM (_tmp38_);
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				GCalcMathExpression* _tmp39_;
				_tmp39_ = self->priv->top_parent;
				_tmp33_ = GCALC_IS_MATH_POLYNOMIAL (_tmp39_);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				GCalcTerm* t = NULL;
				GCalcTerm* _tmp40_;
				GCalcTerm* _tmp41_;
				GCalcExpressionContainer* _tmp42_;
				GCalcExpressionContainer* _tmp43_;
				GCalcMathExpression* _tmp44_;
				GCalcExpressionContainer* _tmp45_;
				GCalcExpressionContainer* _tmp46_;
				GCalcTerm* _tmp47_;
				GCalcMathExpression* _tmp48_;
				GCalcTerm* _tmp49_;
				GCalcMathExpression* _tmp50_;
				GeeArrayList* _tmp51_;
				_tmp40_ = gcalc_term_new ();
				t = _tmp40_;
				_tmp41_ = t;
				_tmp42_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp41_);
				_tmp43_ = _tmp42_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, (GCalcMathExpression*) opp);
				_tmp44_ = self->priv->top_parent;
				_tmp45_ = gcalc_math_expression_get_expressions (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = t;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (GCalcMathExpression*) _tmp47_);
				_tmp48_ = _g_object_ref0 ((GCalcMathExpression*) opp);
				_g_object_unref0 (self->priv->current);
				self->priv->current = _tmp48_;
				_tmp49_ = t;
				_tmp50_ = _g_object_ref0 ((GCalcMathExpression*) _tmp49_);
				_g_object_unref0 (self->priv->current_parent);
				self->priv->current_parent = _tmp50_;
				_tmp51_ = self->priv->expected;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp51_);
				_g_object_unref0 (t);
			} else {
				gboolean _tmp52_ = FALSE;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				GCalcMathExpression* _tmp55_;
				_tmp55_ = self->priv->current;
				if (GCALC_IS_MATH_GROUP (_tmp55_)) {
					_tmp54_ = TRUE;
				} else {
					GCalcMathExpression* _tmp56_;
					_tmp56_ = self->priv->current;
					_tmp54_ = GCALC_IS_MATH_FUNCTION (_tmp56_);
				}
				if (_tmp54_) {
					GCalcMathExpression* _tmp57_;
					_tmp57_ = self->priv->current_parent;
					_tmp53_ = GCALC_IS_MATH_TERM (_tmp57_);
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					GCalcMathExpression* _tmp58_;
					_tmp58_ = self->priv->top_parent;
					_tmp52_ = GCALC_IS_MATH_POLYNOMIAL (_tmp58_);
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					GCalcTerm* t = NULL;
					GCalcTerm* _tmp59_;
					GCalcTerm* _tmp60_;
					GCalcExpressionContainer* _tmp61_;
					GCalcExpressionContainer* _tmp62_;
					GCalcMathExpression* _tmp63_;
					GCalcExpressionContainer* _tmp64_;
					GCalcExpressionContainer* _tmp65_;
					GCalcTerm* _tmp66_;
					GCalcMathExpression* _tmp67_;
					GCalcTerm* _tmp68_;
					GCalcMathExpression* _tmp69_;
					GCalcMathExpression* _tmp70_;
					GCalcMathExpression* _tmp71_;
					GCalcMathExpression* _tmp72_;
					GCalcMathExpression* _tmp73_;
					GeeArrayList* _tmp74_;
					_tmp59_ = gcalc_term_new ();
					t = _tmp59_;
					_tmp60_ = t;
					_tmp61_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp60_);
					_tmp62_ = _tmp61_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, (GCalcMathExpression*) opp);
					_tmp63_ = self->priv->top_parent;
					_tmp64_ = gcalc_math_expression_get_expressions (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = t;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, (GCalcMathExpression*) _tmp66_);
					_tmp67_ = _g_object_ref0 ((GCalcMathExpression*) opp);
					_g_object_unref0 (self->priv->current);
					self->priv->current = _tmp67_;
					_tmp68_ = t;
					_tmp69_ = _g_object_ref0 ((GCalcMathExpression*) _tmp68_);
					_g_object_unref0 (self->priv->current_parent);
					self->priv->current_parent = _tmp69_;
					_tmp70_ = self->priv->current_parent;
					_tmp71_ = gcalc_math_expression_get_parent (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = _g_object_ref0 (_tmp72_);
					_g_object_unref0 (self->priv->top_parent);
					self->priv->top_parent = _tmp73_;
					_tmp74_ = self->priv->expected;
					gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp74_);
					_g_object_unref0 (t);
				} else {
					gboolean _tmp75_ = FALSE;
					GCalcMathExpression* _tmp76_;
					_tmp76_ = self->priv->current;
					if (GCALC_IS_MATH_VARIABLE (_tmp76_)) {
						GCalcMathExpression* _tmp77_;
						_tmp77_ = self->priv->current_parent;
						_tmp75_ = _tmp77_ == NULL;
					} else {
						_tmp75_ = FALSE;
					}
					if (_tmp75_) {
						GCalcPolynomial* exp = NULL;
						GCalcPolynomial* _tmp78_;
						GCalcExpressionContainer* _tmp79_;
						GCalcExpressionContainer* _tmp80_;
						GCalcPolynomial* _tmp81_;
						GCalcTerm* t = NULL;
						GCalcTerm* _tmp82_;
						GCalcPolynomial* _tmp83_;
						GCalcExpressionContainer* _tmp84_;
						GCalcExpressionContainer* _tmp85_;
						GCalcTerm* _tmp86_;
						GCalcTerm* _tmp87_;
						GCalcExpressionContainer* _tmp88_;
						GCalcExpressionContainer* _tmp89_;
						GCalcMathExpression* _tmp90_;
						GCalcTerm* t2 = NULL;
						GCalcTerm* _tmp91_;
						GCalcPolynomial* _tmp92_;
						GCalcExpressionContainer* _tmp93_;
						GCalcExpressionContainer* _tmp94_;
						GCalcTerm* _tmp95_;
						GCalcTerm* _tmp96_;
						GCalcExpressionContainer* _tmp97_;
						GCalcExpressionContainer* _tmp98_;
						GCalcMathExpression* _tmp99_;
						GCalcTerm* _tmp100_;
						GCalcMathExpression* _tmp101_;
						GCalcPolynomial* _tmp102_;
						GCalcMathExpression* _tmp103_;
						GeeArrayList* _tmp104_;
						_tmp78_ = gcalc_polynomial_new ();
						exp = _tmp78_;
						_tmp79_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) eq);
						_tmp80_ = _tmp79_;
						_tmp81_ = exp;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp80_, (GCalcMathExpression*) _tmp81_);
						_tmp82_ = gcalc_term_new ();
						t = _tmp82_;
						_tmp83_ = exp;
						_tmp84_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp83_);
						_tmp85_ = _tmp84_;
						_tmp86_ = t;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, (GCalcMathExpression*) _tmp86_);
						_tmp87_ = t;
						_tmp88_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = self->priv->current;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp90_);
						_tmp91_ = gcalc_term_new ();
						t2 = _tmp91_;
						_tmp92_ = exp;
						_tmp93_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp92_);
						_tmp94_ = _tmp93_;
						_tmp95_ = t2;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, (GCalcMathExpression*) _tmp95_);
						_tmp96_ = t2;
						_tmp97_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp96_);
						_tmp98_ = _tmp97_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, (GCalcMathExpression*) opp);
						_tmp99_ = _g_object_ref0 ((GCalcMathExpression*) opp);
						_g_object_unref0 (self->priv->current);
						self->priv->current = _tmp99_;
						_tmp100_ = t2;
						_tmp101_ = _g_object_ref0 ((GCalcMathExpression*) _tmp100_);
						_g_object_unref0 (self->priv->current_parent);
						self->priv->current_parent = _tmp101_;
						_tmp102_ = exp;
						_tmp103_ = _g_object_ref0 ((GCalcMathExpression*) _tmp102_);
						_g_object_unref0 (self->priv->top_parent);
						self->priv->top_parent = _tmp103_;
						_tmp104_ = self->priv->expected;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp104_);
						_g_object_unref0 (t2);
						_g_object_unref0 (t);
						_g_object_unref0 (exp);
					}
				}
			}
		}
	}
}

static void
gcalc_parser_process_term_operator (GCalcParser* self,
                                    GCalcMathOperator* op,
                                    GCalcEquation* eq,
                                    GError** error)
{
	GCalcMathExpression* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GCalcMathExpression* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (eq != NULL);
	_tmp0_ = self->priv->current;
	if (GCALC_IS_MATH_OPERATOR (_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GCALC_PARSER_ERROR, GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, _ ("Found an unexpected expression for a multiply operator"));
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp7_ = self->priv->current;
	if (GCALC_IS_MATH_CONSTANT (_tmp7_)) {
		_tmp6_ = TRUE;
	} else {
		GCalcMathExpression* _tmp8_;
		_tmp8_ = self->priv->current;
		_tmp6_ = GCALC_IS_MATH_VARIABLE (_tmp8_);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		GCalcMathExpression* _tmp9_;
		_tmp9_ = self->priv->current;
		_tmp5_ = GCALC_IS_MATH_GROUP (_tmp9_);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		GCalcMathExpression* _tmp10_;
		_tmp10_ = self->priv->current;
		_tmp4_ = GCALC_IS_MATH_FUNCTION (_tmp10_);
	}
	if (_tmp4_) {
		GCalcMathExpression* _tmp11_;
		_tmp11_ = self->priv->current_parent;
		_tmp3_ = GCALC_IS_MATH_TERM (_tmp11_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GCalcMathExpression* _tmp12_;
		_tmp12_ = self->priv->top_parent;
		_tmp2_ = GCALC_IS_MATH_POLYNOMIAL (_tmp12_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GCalcMathExpression* _tmp13_;
		GCalcExpressionContainer* _tmp14_;
		GCalcExpressionContainer* _tmp15_;
		GCalcMathExpression* _tmp16_;
		GeeArrayList* _tmp17_;
		_tmp13_ = self->priv->current_parent;
		_tmp14_ = gcalc_math_expression_get_expressions (_tmp13_);
		_tmp15_ = _tmp14_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (GCalcMathExpression*) op);
		_tmp16_ = _g_object_ref0 ((GCalcMathExpression*) op);
		_g_object_unref0 (self->priv->current);
		self->priv->current = _tmp16_;
		_tmp17_ = self->priv->expected;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp17_);
	} else {
		gboolean _tmp18_ = FALSE;
		GCalcMathExpression* _tmp19_;
		_tmp19_ = self->priv->current;
		if (GCALC_IS_MATH_VARIABLE (_tmp19_)) {
			GCalcMathExpression* _tmp20_;
			_tmp20_ = self->priv->current_parent;
			_tmp18_ = _tmp20_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GCalcPolynomial* exp = NULL;
			GCalcPolynomial* _tmp21_;
			GCalcExpressionContainer* _tmp22_;
			GCalcExpressionContainer* _tmp23_;
			GCalcPolynomial* _tmp24_;
			GCalcTerm* t = NULL;
			GCalcTerm* _tmp25_;
			GCalcPolynomial* _tmp26_;
			GCalcExpressionContainer* _tmp27_;
			GCalcExpressionContainer* _tmp28_;
			GCalcTerm* _tmp29_;
			GCalcTerm* _tmp30_;
			GCalcExpressionContainer* _tmp31_;
			GCalcExpressionContainer* _tmp32_;
			GCalcMathExpression* _tmp33_;
			GCalcTerm* _tmp34_;
			GCalcExpressionContainer* _tmp35_;
			GCalcExpressionContainer* _tmp36_;
			GCalcMathExpression* _tmp37_;
			GCalcTerm* _tmp38_;
			GCalcMathExpression* _tmp39_;
			GCalcPolynomial* _tmp40_;
			GCalcMathExpression* _tmp41_;
			GeeArrayList* _tmp42_;
			_tmp21_ = gcalc_polynomial_new ();
			exp = _tmp21_;
			_tmp22_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) eq);
			_tmp23_ = _tmp22_;
			_tmp24_ = exp;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, (GCalcMathExpression*) _tmp24_);
			_tmp25_ = gcalc_term_new ();
			t = _tmp25_;
			_tmp26_ = exp;
			_tmp27_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = t;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (GCalcMathExpression*) _tmp29_);
			_tmp30_ = t;
			_tmp31_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->current;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
			_tmp34_ = t;
			_tmp35_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (GCalcMathExpression*) op);
			_tmp37_ = _g_object_ref0 ((GCalcMathExpression*) op);
			_g_object_unref0 (self->priv->current);
			self->priv->current = _tmp37_;
			_tmp38_ = t;
			_tmp39_ = _g_object_ref0 ((GCalcMathExpression*) _tmp38_);
			_g_object_unref0 (self->priv->current_parent);
			self->priv->current_parent = _tmp39_;
			_tmp40_ = exp;
			_tmp41_ = _g_object_ref0 ((GCalcMathExpression*) _tmp40_);
			_g_object_unref0 (self->priv->top_parent);
			self->priv->top_parent = _tmp41_;
			_tmp42_ = self->priv->expected;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp42_);
			_g_object_unref0 (t);
			_g_object_unref0 (exp);
		}
	}
}

static void
gcalc_parser_add_constant (GCalcParser* self,
                           GCalcMathConstant* c)
{
	GCalcMathExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_ == NULL) {
		GCalcPolynomial* exp = NULL;
		GCalcPolynomial* _tmp1_;
		GCalcEquation* _tmp2_;
		GCalcExpressionContainer* _tmp3_;
		GCalcExpressionContainer* _tmp4_;
		GCalcPolynomial* _tmp5_;
		GCalcTerm* t = NULL;
		GCalcTerm* _tmp6_;
		GCalcPolynomial* _tmp7_;
		GCalcExpressionContainer* _tmp8_;
		GCalcExpressionContainer* _tmp9_;
		GCalcTerm* _tmp10_;
		GCalcTerm* _tmp11_;
		GCalcExpressionContainer* _tmp12_;
		GCalcExpressionContainer* _tmp13_;
		GCalcMathExpression* _tmp14_;
		GCalcTerm* _tmp15_;
		GCalcMathExpression* _tmp16_;
		GCalcPolynomial* _tmp17_;
		GCalcMathExpression* _tmp18_;
		_tmp1_ = gcalc_polynomial_new ();
		exp = _tmp1_;
		_tmp2_ = self->priv->eq;
		_tmp3_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = exp;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (GCalcMathExpression*) _tmp5_);
		_tmp6_ = gcalc_term_new ();
		t = _tmp6_;
		_tmp7_ = exp;
		_tmp8_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = t;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (GCalcMathExpression*) _tmp10_);
		_tmp11_ = t;
		_tmp12_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (GCalcMathExpression*) c);
		_tmp14_ = _g_object_ref0 ((GCalcMathExpression*) c);
		_g_object_unref0 (self->priv->current);
		self->priv->current = _tmp14_;
		_tmp15_ = t;
		_tmp16_ = _g_object_ref0 ((GCalcMathExpression*) _tmp15_);
		_g_object_unref0 (self->priv->current_parent);
		self->priv->current_parent = _tmp16_;
		_tmp17_ = exp;
		_tmp18_ = _g_object_ref0 ((GCalcMathExpression*) _tmp17_);
		_g_object_unref0 (self->priv->top_parent);
		self->priv->top_parent = _tmp18_;
		_g_object_unref0 (t);
		_g_object_unref0 (exp);
	} else {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		GCalcMathExpression* _tmp22_;
		_tmp22_ = self->priv->current;
		if (GCALC_IS_MATH_OPERATOR (_tmp22_)) {
			_tmp21_ = TRUE;
		} else {
			GCalcMathExpression* _tmp23_;
			_tmp23_ = self->priv->current;
			_tmp21_ = GCALC_IS_MATH_TERM (_tmp23_);
		}
		if (_tmp21_) {
			GCalcMathExpression* _tmp24_;
			_tmp24_ = self->priv->current_parent;
			_tmp20_ = GCALC_IS_MATH_TERM (_tmp24_);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GCalcMathExpression* _tmp25_;
			_tmp25_ = self->priv->top_parent;
			_tmp19_ = GCALC_IS_MATH_POLYNOMIAL (_tmp25_);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GCalcMathExpression* _tmp26_;
			GCalcExpressionContainer* _tmp27_;
			GCalcExpressionContainer* _tmp28_;
			GeeArrayList* _tmp29_;
			GCalcMathExpression* _tmp30_;
			_tmp26_ = self->priv->current_parent;
			_tmp27_ = gcalc_math_expression_get_expressions (_tmp26_);
			_tmp28_ = _tmp27_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (GCalcMathExpression*) c);
			_tmp29_ = self->priv->expected;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp29_);
			_tmp30_ = _g_object_ref0 ((GCalcMathExpression*) c);
			_g_object_unref0 (self->priv->current);
			self->priv->current = _tmp30_;
		} else {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			GCalcMathExpression* _tmp33_;
			_tmp33_ = self->priv->current;
			if (GCALC_IS_MATH_TERM (_tmp33_)) {
				GCalcMathExpression* _tmp34_;
				_tmp34_ = self->priv->current_parent;
				_tmp32_ = GCALC_IS_MATH_POLYNOMIAL (_tmp34_);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				gboolean _tmp35_ = FALSE;
				GCalcMathExpression* _tmp36_;
				_tmp36_ = self->priv->top_parent;
				if (GCALC_IS_MATH_GROUP (_tmp36_)) {
					_tmp35_ = TRUE;
				} else {
					GCalcMathExpression* _tmp37_;
					_tmp37_ = self->priv->top_parent;
					_tmp35_ = GCALC_IS_MATH_FUNCTION (_tmp37_);
				}
				_tmp31_ = _tmp35_;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				GCalcMathExpression* _tmp38_;
				GCalcExpressionContainer* _tmp39_;
				GCalcExpressionContainer* _tmp40_;
				GCalcMathExpression* _tmp41_;
				GCalcMathExpression* _tmp42_;
				GCalcMathExpression* _tmp43_;
				GCalcMathExpression* _tmp44_;
				GCalcMathExpression* _tmp45_;
				GeeArrayList* _tmp46_;
				_tmp38_ = self->priv->current;
				_tmp39_ = gcalc_math_expression_get_expressions (_tmp38_);
				_tmp40_ = _tmp39_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, (GCalcMathExpression*) c);
				_tmp41_ = self->priv->current_parent;
				_tmp42_ = _g_object_ref0 (_tmp41_);
				_g_object_unref0 (self->priv->top_parent);
				self->priv->top_parent = _tmp42_;
				_tmp43_ = self->priv->current;
				_tmp44_ = _g_object_ref0 (_tmp43_);
				_g_object_unref0 (self->priv->current_parent);
				self->priv->current_parent = _tmp44_;
				_tmp45_ = _g_object_ref0 ((GCalcMathExpression*) c);
				_g_object_unref0 (self->priv->current);
				self->priv->current = _tmp45_;
				_tmp46_ = self->priv->expected;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp46_);
			}
		}
	}
}

/**
   * Reads a token at a given position
   */
GCalcParserTokenType
gcalc_parser_read_token (GCalcParser* self)
{
	GTokenType t = 0;
	GScanner* _tmp0_;
	GCalcParserTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->scanner;
	t = g_scanner_get_next_token (_tmp0_);
	switch (t) {
		case G_TOKEN_IDENTIFIER:
		{
			result = GCALC_PARSER_TOKEN_TYPE_IDENTIFIER;
			return result;
		}
		case G_TOKEN_INT:
		{
			result = GCALC_PARSER_TOKEN_TYPE_INTEGER_LITERAL;
			return result;
		}
		case G_TOKEN_FLOAT:
		{
			result = GCALC_PARSER_TOKEN_TYPE_REAL_LITERAL;
			return result;
		}
		case G_TOKEN_STRING:
		{
			result = GCALC_PARSER_TOKEN_TYPE_STRING_LITERAL;
			return result;
		}
		case G_TOKEN_EOF:
		{
			result = GCALC_PARSER_TOKEN_TYPE_EOF;
			return result;
		}
		case G_TOKEN_CHAR:
		{
			guchar v = '\0';
			GScanner* _tmp1_;
			_tmp1_ = self->priv->scanner;
			v = g_scanner_cur_value (_tmp1_).v_char;
			if (g_ascii_isalpha ((gchar) v)) {
				result = GCALC_PARSER_TOKEN_TYPE_IDENTIFIER;
				return result;
			}
			switch (v) {
				case '*':
				{
					result = GCALC_PARSER_TOKEN_TYPE_STAR;
					return result;
				}
				case '/':
				{
					result = GCALC_PARSER_TOKEN_TYPE_DIV;
					return result;
				}
				case '+':
				{
					result = GCALC_PARSER_TOKEN_TYPE_PLUS;
					return result;
				}
				case '-':
				{
					result = GCALC_PARSER_TOKEN_TYPE_MINUS;
					return result;
				}
				case '^':
				{
					result = GCALC_PARSER_TOKEN_TYPE_CARRET;
					return result;
				}
				case ')':
				{
					result = GCALC_PARSER_TOKEN_TYPE_CLOSE_PARENS;
					return result;
				}
				case '(':
				{
					result = GCALC_PARSER_TOKEN_TYPE_OPEN_PARENS;
					return result;
				}
				case '=':
				{
					result = GCALC_PARSER_TOKEN_TYPE_ASSIGN;
					return result;
				}
				case '{':
				{
					result = GCALC_PARSER_TOKEN_TYPE_OPEN_BRACE;
					return result;
				}
				case '}':
				{
					result = GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACE;
					return result;
				}
				case '[':
				{
					result = GCALC_PARSER_TOKEN_TYPE_OPEN_BRACKET;
					return result;
				}
				case ']':
				{
					result = GCALC_PARSER_TOKEN_TYPE_CLOSE_BRACKET;
					return result;
				}
				case '$':
				{
					result = GCALC_PARSER_TOKEN_TYPE_CURRENCY_SYMBOL;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case G_TOKEN_RIGHT_PAREN:
		case G_TOKEN_LEFT_PAREN:
		case G_TOKEN_LEFT_BRACE:
		case G_TOKEN_LEFT_CURLY:
		case G_TOKEN_OCTAL:
		case G_TOKEN_COMMENT_MULTI:
		case G_TOKEN_COMMA:
		case G_TOKEN_IDENTIFIER_NULL:
		case G_TOKEN_LAST:
		case G_TOKEN_RIGHT_BRACE:
		case G_TOKEN_NONE:
		case G_TOKEN_SYMBOL:
		case G_TOKEN_BINARY:
		case G_TOKEN_COMMENT_SINGLE:
		case G_TOKEN_RIGHT_CURLY:
		case G_TOKEN_HEX:
		case G_TOKEN_EQUAL_SIGN:
		case G_TOKEN_ERROR:
		{
			break;
		}
		default:
		break;
	}
	result = GCALC_PARSER_TOKEN_TYPE_NONE;
	return result;
}

/**
   * Creates a string representation of the current {@link TokenType}
   */
gchar*
gcalc_parser_token_to_string (GCalcParser* self)
{
	GTokenType t = 0;
	GScanner* _tmp0_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	t = g_scanner_cur_token (_tmp0_);
	switch (t) {
		case G_TOKEN_IDENTIFIER:
		{
			GScanner* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->scanner;
			_tmp2_ = g_scanner_cur_value (_tmp1_).v_identifier;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case G_TOKEN_INT:
		{
			GScanner* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->scanner;
			_tmp5_ = g_strdup_printf ("%lu", g_scanner_cur_value (_tmp4_).v_int);
			result = _tmp5_;
			return result;
		}
		case G_TOKEN_FLOAT:
		{
			GScanner* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->priv->scanner;
			_tmp7_ = g_strdup_printf ("%g", g_scanner_cur_value (_tmp6_).v_float);
			result = _tmp7_;
			return result;
		}
		case G_TOKEN_EOF:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("");
			result = _tmp8_;
			return result;
		}
		case G_TOKEN_CHAR:
		{
			GString* str = NULL;
			GString* _tmp9_;
			GString* _tmp10_;
			GScanner* _tmp11_;
			GString* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp9_ = g_string_new ("");
			str = _tmp9_;
			_tmp10_ = str;
			_tmp11_ = self->priv->scanner;
			g_string_append_c (_tmp10_, (gchar) g_scanner_cur_value (_tmp11_).v_char);
			_tmp12_ = str;
			_tmp13_ = _tmp12_->str;
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			_g_string_free0 (str);
			return result;
		}
		case G_TOKEN_STRING:
		{
			GScanner* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = self->priv->scanner;
			_tmp16_ = g_scanner_cur_value (_tmp15_).v_string;
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			return result;
		}
		case G_TOKEN_RIGHT_PAREN:
		case G_TOKEN_LEFT_PAREN:
		case G_TOKEN_LEFT_BRACE:
		case G_TOKEN_LEFT_CURLY:
		case G_TOKEN_OCTAL:
		case G_TOKEN_COMMENT_MULTI:
		case G_TOKEN_COMMA:
		case G_TOKEN_IDENTIFIER_NULL:
		case G_TOKEN_LAST:
		case G_TOKEN_RIGHT_BRACE:
		case G_TOKEN_NONE:
		case G_TOKEN_SYMBOL:
		case G_TOKEN_BINARY:
		case G_TOKEN_COMMENT_SINGLE:
		case G_TOKEN_RIGHT_CURLY:
		case G_TOKEN_HEX:
		case G_TOKEN_EQUAL_SIGN:
		case G_TOKEN_ERROR:
		{
			break;
		}
		default:
		break;
	}
	_tmp18_ = g_strdup ("");
	result = _tmp18_;
	return result;
}

GCalcParser*
gcalc_parser_construct (GType object_type)
{
	GCalcParser * self = NULL;
	self = (GCalcParser*) g_object_new (object_type, NULL);
	return self;
}

GCalcParser*
gcalc_parser_new (void)
{
	return gcalc_parser_construct (GCALC_TYPE_PARSER);
}

static GObject *
gcalc_parser_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GCalcParser * self;
	GScanner* _tmp0_;
	GScanner* _tmp1_;
	GScanner* _tmp2_;
	GScannerConfig* _tmp3_;
	GScanner* _tmp4_;
	GScannerConfig* _tmp5_;
	GScanner* _tmp6_;
	GScannerConfig* _tmp7_;
	GScanner* _tmp8_;
	GScannerConfig* _tmp9_;
	GScanner* _tmp10_;
	GScannerConfig* _tmp11_;
	GScanner* _tmp12_;
	GScannerConfig* _tmp13_;
	GScanner* _tmp14_;
	GScannerConfig* _tmp15_;
	GScanner* _tmp16_;
	GScannerConfig* _tmp17_;
	GScanner* _tmp18_;
	GScannerConfig* _tmp19_;
	GScanner* _tmp20_;
	GScannerConfig* _tmp21_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (gcalc_parser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCALC_TYPE_PARSER, GCalcParser);
	_tmp0_ = g_scanner_new (NULL);
	_g_scanner_destroy0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp1_->input_name = "GCalc";
	_tmp2_ = self->priv->scanner;
	_tmp3_ = _tmp2_->config;
	(*_tmp3_).cpair_comment_single = "\n";
	_tmp4_ = self->priv->scanner;
	_tmp5_ = _tmp4_->config;
	(*_tmp5_).skip_comment_multi = FALSE;
	_tmp6_ = self->priv->scanner;
	_tmp7_ = _tmp6_->config;
	(*_tmp7_).skip_comment_single = FALSE;
	_tmp8_ = self->priv->scanner;
	_tmp9_ = _tmp8_->config;
	(*_tmp9_).char_2_token = FALSE;
	_tmp10_ = self->priv->scanner;
	_tmp11_ = _tmp10_->config;
	(*_tmp11_).scan_binary = FALSE;
	_tmp12_ = self->priv->scanner;
	_tmp13_ = _tmp12_->config;
	(*_tmp13_).scan_octal = FALSE;
	_tmp14_ = self->priv->scanner;
	_tmp15_ = _tmp14_->config;
	(*_tmp15_).scan_float = FALSE;
	_tmp16_ = self->priv->scanner;
	_tmp17_ = _tmp16_->config;
	(*_tmp17_).scan_hex = FALSE;
	_tmp18_ = self->priv->scanner;
	_tmp19_ = _tmp18_->config;
	(*_tmp19_).scan_hex_dollar = FALSE;
	_tmp20_ = self->priv->scanner;
	_tmp21_ = _tmp20_->config;
	(*_tmp21_).numbers_2_int = FALSE;
	{
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_;
		GRegex* _tmp24_;
		_tmp23_ = g_regex_new ("^i\\d", G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
		_tmp22_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp24_ = _tmp22_;
		_tmp22_ = NULL;
		_g_regex_unref0 (self->priv->rg);
		self->priv->rg = _tmp24_;
		_g_regex_unref0 (_tmp22_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_message ("gcalc-parser.vala:51: Error on compile regular expression: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
gcalc_parser_class_init (GCalcParserClass * klass,
                         gpointer klass_data)
{
	gcalc_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GCalcParser_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gcalc_parser_constructor;
	G_OBJECT_CLASS (klass)->finalize = gcalc_parser_finalize;
}

static void
gcalc_parser_instance_init (GCalcParser * self,
                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = gcalc_parser_get_instance_private (self);
	self->priv->current = NULL;
	self->priv->current_parent = NULL;
	self->priv->top_parent = NULL;
	self->priv->eq = NULL;
	self->priv->enable_parameter = FALSE;
	_tmp0_ = gee_array_list_new (GCALC_PARSER_TYPE_TOKEN_TYPE, NULL, NULL, NULL, NULL, NULL);
	self->priv->expected = _tmp0_;
}

static void
gcalc_parser_finalize (GObject * obj)
{
	GCalcParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCALC_TYPE_PARSER, GCalcParser);
	_g_object_unref0 (self->priv->current);
	_g_object_unref0 (self->priv->current_parent);
	_g_object_unref0 (self->priv->top_parent);
	_g_object_unref0 (self->priv->eq);
	_g_regex_unref0 (self->priv->rg);
	_g_object_unref0 (self->priv->expected);
	_g_scanner_destroy0 (self->priv->scanner);
	G_OBJECT_CLASS (gcalc_parser_parent_class)->finalize (obj);
}

/**
 * Takes a string an create a tree of {@link MathExpression} objects representing
 * a math equation.
 */
static GType
gcalc_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GCalcParser), 0, (GInstanceInitFunc) gcalc_parser_instance_init, NULL };
	GType gcalc_parser_type_id;
	gcalc_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "GCalcParser", &g_define_type_info, 0);
	GCalcParser_private_offset = g_type_add_instance_private (gcalc_parser_type_id, sizeof (GCalcParserPrivate));
	return gcalc_parser_type_id;
}

GType
gcalc_parser_get_type (void)
{
	static volatile gsize gcalc_parser_type_id__once = 0;
	if (g_once_init_enter (&gcalc_parser_type_id__once)) {
		GType gcalc_parser_type_id;
		gcalc_parser_type_id = gcalc_parser_get_type_once ();
		g_once_init_leave (&gcalc_parser_type_id__once, gcalc_parser_type_id);
	}
	return gcalc_parser_type_id__once;
}

GQuark
gcalc_parser_error_quark (void)
{
	return g_quark_from_static_string ("gcalc-parser-error-quark");
}

static GType
gcalc_parser_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR, "GCALC_PARSER_ERROR_INVALID_TOKEN_ERROR", "invalid-token-error"}, {GCALC_PARSER_ERROR_INVALID_EXPRESSION_ERROR, "GCALC_PARSER_ERROR_INVALID_EXPRESSION_ERROR", "invalid-expression-error"}, {0, NULL, NULL}};
	GType gcalc_parser_error_type_id;
	gcalc_parser_error_type_id = g_enum_register_static ("GCalcParserError", values);
	return gcalc_parser_error_type_id;
}

GType
gcalc_parser_error_get_type (void)
{
	static volatile gsize gcalc_parser_error_type_id__once = 0;
	if (g_once_init_enter (&gcalc_parser_error_type_id__once)) {
		GType gcalc_parser_error_type_id;
		gcalc_parser_error_type_id = gcalc_parser_error_get_type_once ();
		g_once_init_leave (&gcalc_parser_error_type_id__once, gcalc_parser_error_type_id);
	}
	return gcalc_parser_error_type_id__once;
}

