
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "qztools_wrapper.h"

// inner classes

// Extra includes
#include <qbytearray.h>
#include <qfontmetrics.h>
#include <qicon.h>
#include <qkeysequence.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qregion.h>
#include <qurl.h>
#include <qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QzTools_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QzTools >()))
        return -1;

    ::QzTools *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QzTools()
            cptr = new ::QzTools();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QzTools >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QzToolsFunc_actionShortcut(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.actionShortcut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_actionShortcut_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_actionShortcut_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:actionShortcut", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
        } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[3])))) {
                overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_actionShortcut_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_shortcutRtl = Shiboken::String::createStaticString("shortcutRtl");
            if (PyDict_Contains(kwds, key_shortcutRtl)) {
                value = PyDict_GetItem(kwds, key_shortcutRtl);
                if (value && pyArgs[2]) {
                    errInfo = key_shortcutRtl;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_actionShortcut_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[2]))))
                        goto Sbk_QzToolsFunc_actionShortcut_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_shortcutRtl);
            }
            static PyObject *const key_fallbackRtl = Shiboken::String::createStaticString("fallbackRtl");
            if (PyDict_Contains(kwds, key_fallbackRtl)) {
                value = PyDict_GetItem(kwds, key_fallbackRtl);
                if (value && pyArgs[3]) {
                    errInfo = key_fallbackRtl;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_actionShortcut_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[3]))))
                        goto Sbk_QzToolsFunc_actionShortcut_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fallbackRtl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_actionShortcut_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QKeySequence cppArg1_local;
        ::QKeySequence *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeySequence cppArg2_local = QKeySequence();
        ::QKeySequence *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QKeySequence cppArg3_local = QKeySequence();
        ::QKeySequence *cppArg3 = &cppArg3_local;
        if (pythonToCpp[3]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);
        }

        if (!PyErr_Occurred()) {
            // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            QKeySequence cppResult = ::QzTools::actionShortcut(*cppArg0, *cppArg1, *cppArg2, *cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_actionShortcut_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_alignTextToWidth(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.alignTextToWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "alignTextToWidth", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::alignTextToWidth(QString,QString,QFontMetrics,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // alignTextToWidth(QString,QString,QFontMetrics,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_alignTextToWidth_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QFontMetrics cppArg2_local = ::QFontMetrics(::QFont());
        ::QFontMetrics *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // alignTextToWidth(QString,QString,QFontMetrics,int)
            QString cppResult = ::QzTools::alignTextToWidth(cppArg0, cppArg1, *cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_alignTextToWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_applyDirectionToPage(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.applyDirectionToPage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::applyDirectionToPage(QString&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // applyDirectionToPage(QString&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_applyDirectionToPage_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // applyDirectionToPage(QString&)
            QString cppResult = ::QzTools::applyDirectionToPage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_applyDirectionToPage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_centerWidgetOnScreen(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.centerWidgetOnScreen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::centerWidgetOnScreen(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // centerWidgetOnScreen(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_centerWidgetOnScreen_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // centerWidgetOnScreen(QWidget*)
            ::QzTools::centerWidgetOnScreen(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QzToolsFunc_centerWidgetOnScreen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_centerWidgetToParent(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.centerWidgetToParent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "centerWidgetToParent", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::centerWidgetToParent(QWidget*,QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // centerWidgetToParent(QWidget*,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_centerWidgetToParent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // centerWidgetToParent(QWidget*,QWidget*)
            ::QzTools::centerWidgetToParent(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QzToolsFunc_centerWidgetToParent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_containsSpace(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.containsSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::containsSpace(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // containsSpace(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_containsSpace_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // containsSpace(QString)
            bool cppResult = ::QzTools::containsSpace(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_containsSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_copyRecursively(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.copyRecursively";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "copyRecursively", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::copyRecursively(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // copyRecursively(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_copyRecursively_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // copyRecursively(QString,QString)
            bool cppResult = ::QzTools::copyRecursively(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_copyRecursively_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_cpuArchitecture(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.cpuArchitecture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cpuArchitecture()
            QString cppResult = ::QzTools::cpuArchitecture();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QzToolsFunc_createPixmapForSite(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.createPixmapForSite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createPixmapForSite", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::createPixmapForSite(QIcon,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // createPixmapForSite(QIcon,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_createPixmapForSite_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createPixmapForSite(QIcon,QString,QString)
            QPixmap cppResult = ::QzTools::createPixmapForSite(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_createPixmapForSite_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_dpiAwarePixmap(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.dpiAwarePixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::dpiAwarePixmap(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // dpiAwarePixmap(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_dpiAwarePixmap_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dpiAwarePixmap(QString)
            QPixmap cppResult = ::QzTools::dpiAwarePixmap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_dpiAwarePixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_ensureUniqueFilename(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.ensureUniqueFilename";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:ensureUniqueFilename", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::ensureUniqueFilename(QString,QString)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // ensureUniqueFilename(QString,QString)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // ensureUniqueFilename(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_appendFormat = Shiboken::String::createStaticString("appendFormat");
            if (PyDict_Contains(kwds, key_appendFormat)) {
                value = PyDict_GetItem(kwds, key_appendFormat);
                if (value && pyArgs[1]) {
                    errInfo = key_appendFormat;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_appendFormat);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_ensureUniqueFilename_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QSL("(%1)");
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // ensureUniqueFilename(QString,QString)
            QString cppResult = ::QzTools::ensureUniqueFilename(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_ensureUniqueFilename_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_escapeSqlGlobString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.escapeSqlGlobString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::escapeSqlGlobString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // escapeSqlGlobString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_escapeSqlGlobString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // escapeSqlGlobString(QString)
            QString cppResult = ::QzTools::escapeSqlGlobString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_escapeSqlGlobString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_fileSizeToString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.fileSizeToString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::fileSizeToString(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // fileSizeToString(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_fileSizeToString_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fileSizeToString(qint64)
            QString cppResult = ::QzTools::fileSizeToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_fileSizeToString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_filterCharsFromFilename(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.filterCharsFromFilename";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::filterCharsFromFilename(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // filterCharsFromFilename(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_filterCharsFromFilename_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // filterCharsFromFilename(QString)
            QString cppResult = ::QzTools::filterCharsFromFilename(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_filterCharsFromFilename_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_fromPunycode(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.fromPunycode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::fromPunycode(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromPunycode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_fromPunycode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromPunycode(QString)
            QString cppResult = ::QzTools::fromPunycode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_fromPunycode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_getExistingDirectory(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.getExistingDirectory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:getExistingDirectory", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    } else if ((pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[4])))) {
                        overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[2]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[3]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[4]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[4]))))
                        goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_getExistingDirectory_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<QFileDialog::Option> cppArg4 = QFileDialog::ShowDirsOnly;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            QString cppResult = ::QzTools::getExistingDirectory(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_getExistingDirectory_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_getFileNameFromUrl(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.getFileNameFromUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::getFileNameFromUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // getFileNameFromUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_getFileNameFromUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // getFileNameFromUrl(QUrl)
            QString cppResult = ::QzTools::getFileNameFromUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_getFileNameFromUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_getOpenFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.getOpenFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if ((pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if ((pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if ((pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_getOpenFileName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[2]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[3]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[4]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[5]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[6]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6]))))
                        goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_getOpenFileName_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = {};
        if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            QString retval_ = QzTools::getOpenFileName(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg5));
            // TEMPLATE - return_for_QFileDialog - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_getOpenFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_getOpenFileNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.getOpenFileNames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileNames", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if ((pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if ((pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if ((pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[2]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[3]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[4]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[5]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[6]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6]))))
                        goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_getOpenFileNames_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = {};
        if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            QStringList retval_ = QzTools::getOpenFileNames(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg5));
            // TEMPLATE - return_for_QFileDialog - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_getOpenFileNames_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_getSaveFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.getSaveFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getSaveFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if ((pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if ((pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if ((pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if ((pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6])))) {
                                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_getSaveFileName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[2]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[3]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[4]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[5]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[6]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[6]))))
                        goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_QzToolsFunc_getSaveFileName_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = {};
        if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            QString retval_ = QzTools::getSaveFileName(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg5));
            // TEMPLATE - return_for_QFileDialog - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_getSaveFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_iconFromFileName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.iconFromFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::iconFromFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // iconFromFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_iconFromFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // iconFromFileName(QString)
            QIcon cppResult = ::QzTools::iconFromFileName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_iconFromFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_isUtf8(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.isUtf8";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::isUtf8(const char*)
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // isUtf8(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_isUtf8_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isUtf8(const char*)
            bool cppResult = ::QzTools::isUtf8(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_isUtf8_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_lastPathForFileDialog(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.lastPathForFileDialog";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "lastPathForFileDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::lastPathForFileDialog(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // lastPathForFileDialog(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_lastPathForFileDialog_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // lastPathForFileDialog(QString,QString)
            QString cppResult = ::QzTools::lastPathForFileDialog(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_lastPathForFileDialog_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_matchDomain(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.matchDomain";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "matchDomain", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::matchDomain(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // matchDomain(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_matchDomain_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // matchDomain(QString,QString)
            bool cppResult = ::QzTools::matchDomain(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_matchDomain_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_operatingSystem(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.operatingSystem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operatingSystem()
            QString cppResult = ::QzTools::operatingSystem();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QzToolsFunc_operatingSystemLong(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.operatingSystemLong";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operatingSystemLong()
            QString cppResult = ::QzTools::operatingSystemLong();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QzToolsFunc_paintDropIndicator(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.paintDropIndicator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "paintDropIndicator", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::paintDropIndicator(QWidget*,QRect)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // paintDropIndicator(QWidget*,QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_paintDropIndicator_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // paintDropIndicator(QWidget*,QRect)
            ::QzTools::paintDropIndicator(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QzToolsFunc_paintDropIndicator_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_pixmapFromByteArray(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.pixmapFromByteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapFromByteArray(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapFromByteArray(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_pixmapFromByteArray_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pixmapFromByteArray(QByteArray)
            QPixmap cppResult = ::QzTools::pixmapFromByteArray(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_pixmapFromByteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_pixmapToByteArray(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.pixmapToByteArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapToByteArray(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapToByteArray(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_pixmapToByteArray_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pixmapToByteArray(QPixmap)
            QByteArray cppResult = ::QzTools::pixmapToByteArray(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_pixmapToByteArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_pixmapToDataUrl(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.pixmapToDataUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapToDataUrl(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapToDataUrl(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_pixmapToDataUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pixmapToDataUrl(QPixmap)
            QUrl cppResult = ::QzTools::pixmapToDataUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_pixmapToDataUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_readAllFileByteContents(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.readAllFileByteContents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::readAllFileByteContents(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // readAllFileByteContents(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_readAllFileByteContents_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readAllFileByteContents(QString)
            QByteArray cppResult = ::QzTools::readAllFileByteContents(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_readAllFileByteContents_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_readAllFileContents(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.readAllFileContents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::readAllFileContents(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // readAllFileContents(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_readAllFileContents_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readAllFileContents(QString)
            QString cppResult = ::QzTools::readAllFileContents(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_readAllFileContents_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_removeRecursively(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.removeRecursively";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::removeRecursively(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeRecursively(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_removeRecursively_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeRecursively(QString)
            bool cppResult = ::QzTools::removeRecursively(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_removeRecursively_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_resolveFromPath(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.resolveFromPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::resolveFromPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // resolveFromPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_resolveFromPath_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resolveFromPath(QString)
            QString cppResult = ::QzTools::resolveFromPath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_resolveFromPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_roundedRect(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.roundedRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "roundedRect", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::roundedRect(QRect,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // roundedRect(QRect,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_roundedRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // roundedRect(QRect,int)
            QRegion cppResult = ::QzTools::roundedRect(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_roundedRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_samePartOfStrings(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.samePartOfStrings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "samePartOfStrings", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::samePartOfStrings(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // samePartOfStrings(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_samePartOfStrings_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // samePartOfStrings(QString,QString)
            QString cppResult = ::QzTools::samePartOfStrings(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_samePartOfStrings_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_saveLastPathForFileDialog(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.saveLastPathForFileDialog";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "saveLastPathForFileDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::saveLastPathForFileDialog(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // saveLastPathForFileDialog(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_saveLastPathForFileDialog_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // saveLastPathForFileDialog(QString,QString)
            ::QzTools::saveLastPathForFileDialog(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QzToolsFunc_saveLastPathForFileDialog_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_setWmClass(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.setWmClass";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setWmClass", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::setWmClass(QString,const QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setWmClass(QString,const QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_setWmClass_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setWmClass(QString,const QWidget*)
            ::QzTools::setWmClass(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QzToolsFunc_setWmClass_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_splitCommandArguments(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.splitCommandArguments";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::splitCommandArguments(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // splitCommandArguments(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_splitCommandArguments_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // splitCommandArguments(QString)
            QStringList cppResult = ::QzTools::splitCommandArguments(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_splitCommandArguments_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_startExternalProcess(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.startExternalProcess";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "startExternalProcess", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::startExternalProcess(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // startExternalProcess(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_startExternalProcess_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // startExternalProcess(QString,QString)
            bool cppResult = ::QzTools::startExternalProcess(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_startExternalProcess_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_truncatedText(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.truncatedText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "truncatedText", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QzTools::truncatedText(QString,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // truncatedText(QString,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_truncatedText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // truncatedText(QString,int)
            QString cppResult = ::QzTools::truncatedText(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_truncatedText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QzToolsFunc_urlEncodeQueryString(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzTools.urlEncodeQueryString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::urlEncodeQueryString(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // urlEncodeQueryString(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QzToolsFunc_urlEncodeQueryString_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // urlEncodeQueryString(QUrl)
            QString cppResult = ::QzTools::urlEncodeQueryString(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QzToolsFunc_urlEncodeQueryString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QzTools_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QzTools_methods[] = {
    {"actionShortcut", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_actionShortcut), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"alignTextToWidth", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_alignTextToWidth), METH_VARARGS|METH_STATIC},
    {"applyDirectionToPage", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_applyDirectionToPage), METH_O|METH_STATIC},
    {"centerWidgetOnScreen", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_centerWidgetOnScreen), METH_O|METH_STATIC},
    {"centerWidgetToParent", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_centerWidgetToParent), METH_VARARGS|METH_STATIC},
    {"containsSpace", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_containsSpace), METH_O|METH_STATIC},
    {"copyRecursively", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_copyRecursively), METH_VARARGS|METH_STATIC},
    {"cpuArchitecture", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_cpuArchitecture), METH_NOARGS|METH_STATIC},
    {"createPixmapForSite", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_createPixmapForSite), METH_VARARGS|METH_STATIC},
    {"dpiAwarePixmap", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_dpiAwarePixmap), METH_O|METH_STATIC},
    {"ensureUniqueFilename", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_ensureUniqueFilename), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"escapeSqlGlobString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_escapeSqlGlobString), METH_O|METH_STATIC},
    {"fileSizeToString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_fileSizeToString), METH_O|METH_STATIC},
    {"filterCharsFromFilename", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_filterCharsFromFilename), METH_O|METH_STATIC},
    {"fromPunycode", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_fromPunycode), METH_O|METH_STATIC},
    {"getExistingDirectory", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getExistingDirectory), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getFileNameFromUrl", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getFileNameFromUrl), METH_O|METH_STATIC},
    {"getOpenFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getOpenFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getOpenFileNames", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getOpenFileNames), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getSaveFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getSaveFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"iconFromFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_iconFromFileName), METH_O|METH_STATIC},
    {"isUtf8", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_isUtf8), METH_O|METH_STATIC},
    {"lastPathForFileDialog", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_lastPathForFileDialog), METH_VARARGS|METH_STATIC},
    {"matchDomain", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_matchDomain), METH_VARARGS|METH_STATIC},
    {"operatingSystem", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_operatingSystem), METH_NOARGS|METH_STATIC},
    {"operatingSystemLong", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_operatingSystemLong), METH_NOARGS|METH_STATIC},
    {"paintDropIndicator", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_paintDropIndicator), METH_VARARGS|METH_STATIC},
    {"pixmapFromByteArray", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapFromByteArray), METH_O|METH_STATIC},
    {"pixmapToByteArray", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapToByteArray), METH_O|METH_STATIC},
    {"pixmapToDataUrl", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapToDataUrl), METH_O|METH_STATIC},
    {"readAllFileByteContents", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_readAllFileByteContents), METH_O|METH_STATIC},
    {"readAllFileContents", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_readAllFileContents), METH_O|METH_STATIC},
    {"removeRecursively", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_removeRecursively), METH_O|METH_STATIC},
    {"resolveFromPath", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_resolveFromPath), METH_O|METH_STATIC},
    {"roundedRect", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_roundedRect), METH_VARARGS|METH_STATIC},
    {"samePartOfStrings", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_samePartOfStrings), METH_VARARGS|METH_STATIC},
    {"saveLastPathForFileDialog", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_saveLastPathForFileDialog), METH_VARARGS|METH_STATIC},
    {"setWmClass", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_setWmClass), METH_VARARGS|METH_STATIC},
    {"splitCommandArguments", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_splitCommandArguments), METH_O|METH_STATIC},
    {"startExternalProcess", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_startExternalProcess), METH_VARARGS|METH_STATIC},
    {"truncatedText", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_truncatedText), METH_VARARGS|METH_STATIC},
    {"urlEncodeQueryString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_urlEncodeQueryString), METH_O|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QzTools_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QzTools_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QzTools_Type = nullptr;
static SbkObjectType *Sbk_QzTools_TypeF(void)
{
    return _Sbk_QzTools_Type;
}

static PyType_Slot Sbk_QzTools_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QzTools_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QzTools_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QzTools_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QzTools_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QzTools_spec = {
    "1:PyFalkon.QzTools",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QzTools_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QzTools_PythonToCpp_QzTools_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QzTools_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QzTools_PythonToCpp_QzTools_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QzTools_TypeF())))
        return QzTools_PythonToCpp_QzTools_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QzTools_PTR_CppToPython_QzTools(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QzTools *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QzTools_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QzTools_SignatureStrings[] = {
    "PyFalkon.QzTools(self)",
    "PyFalkon.QzTools.actionShortcut(shortcut:PySide2.QtGui.QKeySequence,fallBack:PySide2.QtGui.QKeySequence,shortcutRtl:PySide2.QtGui.QKeySequence=QKeySequence(),fallbackRtl:PySide2.QtGui.QKeySequence=QKeySequence())->PySide2.QtGui.QKeySequence",
    "PyFalkon.QzTools.alignTextToWidth(string:QString,text:QString,metrics:PySide2.QtGui.QFontMetrics,width:int)->QString",
    "PyFalkon.QzTools.applyDirectionToPage(pageContents:QString)->QString",
    "PyFalkon.QzTools.centerWidgetOnScreen(w:PySide2.QtWidgets.QWidget)",
    "PyFalkon.QzTools.centerWidgetToParent(w:PySide2.QtWidgets.QWidget,parent:PySide2.QtWidgets.QWidget)",
    "PyFalkon.QzTools.containsSpace(str:QString)->bool",
    "PyFalkon.QzTools.copyRecursively(sourcePath:QString,targetPath:QString)->bool",
    "PyFalkon.QzTools.cpuArchitecture()->QString",
    "PyFalkon.QzTools.createPixmapForSite(icon:PySide2.QtGui.QIcon,title:QString,url:QString)->PySide2.QtGui.QPixmap",
    "PyFalkon.QzTools.dpiAwarePixmap(path:QString)->PySide2.QtGui.QPixmap",
    R"CPP(PyFalkon.QzTools.ensureUniqueFilename(name:QString,appendFormat:QString=QSL("(%1)"))->QString)CPP",
    "PyFalkon.QzTools.escapeSqlGlobString(urlString:QString)->QString",
    "PyFalkon.QzTools.fileSizeToString(size:qint64)->QString",
    "PyFalkon.QzTools.filterCharsFromFilename(name:QString)->QString",
    "PyFalkon.QzTools.fromPunycode(str:QString)->QString",
    "PyFalkon.QzTools.getExistingDirectory(name:QString,parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.ShowDirsOnly)->QString",
    "PyFalkon.QzTools.getFileNameFromUrl(url:PySide2.QtCore.QUrl)->QString",
    "PyFalkon.QzTools.getOpenFileName(name:QString,parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options={})->QString",
    "PyFalkon.QzTools.getOpenFileNames(name:QString,parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options={})->QStringList",
    "PyFalkon.QzTools.getSaveFileName(name:QString,parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options={})->QString",
    "PyFalkon.QzTools.iconFromFileName(fileName:QString)->PySide2.QtGui.QIcon",
    "PyFalkon.QzTools.isUtf8(string:char*)->bool",
    "PyFalkon.QzTools.lastPathForFileDialog(dialogName:QString,fallbackPath:QString)->QString",
    "PyFalkon.QzTools.matchDomain(pattern:QString,domain:QString)->bool",
    "PyFalkon.QzTools.operatingSystem()->QString",
    "PyFalkon.QzTools.operatingSystemLong()->QString",
    "PyFalkon.QzTools.paintDropIndicator(widget:PySide2.QtWidgets.QWidget,r:PySide2.QtCore.QRect)",
    "PyFalkon.QzTools.pixmapFromByteArray(data:PySide2.QtCore.QByteArray)->PySide2.QtGui.QPixmap",
    "PyFalkon.QzTools.pixmapToByteArray(pix:PySide2.QtGui.QPixmap)->PySide2.QtCore.QByteArray",
    "PyFalkon.QzTools.pixmapToDataUrl(pix:PySide2.QtGui.QPixmap)->PySide2.QtCore.QUrl",
    "PyFalkon.QzTools.readAllFileByteContents(filename:QString)->PySide2.QtCore.QByteArray",
    "PyFalkon.QzTools.readAllFileContents(filename:QString)->QString",
    "PyFalkon.QzTools.removeRecursively(filePath:QString)->bool",
    "PyFalkon.QzTools.resolveFromPath(name:QString)->QString",
    "PyFalkon.QzTools.roundedRect(rect:PySide2.QtCore.QRect,radius:int)->PySide2.QtGui.QRegion",
    "PyFalkon.QzTools.samePartOfStrings(one:QString,other:QString)->QString",
    "PyFalkon.QzTools.saveLastPathForFileDialog(dialogName:QString,path:QString)",
    "PyFalkon.QzTools.setWmClass(name:QString,widget:PySide2.QtWidgets.QWidget)",
    "PyFalkon.QzTools.splitCommandArguments(command:QString)->QStringList",
    "PyFalkon.QzTools.startExternalProcess(executable:QString,args:QString)->bool",
    "PyFalkon.QzTools.truncatedText(text:QString,size:int)->QString",
    "PyFalkon.QzTools.urlEncodeQueryString(url:PySide2.QtCore.QUrl)->QString",
    nullptr}; // Sentinel

void init_QzTools(PyObject *module)
{
    _Sbk_QzTools_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QzTools",
        "QzTools*",
        &Sbk_QzTools_spec,
        &Shiboken::callCppDestructor< ::QzTools >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QzTools_Type);
    InitSignatureStrings(pyType, QzTools_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QzTools_Type), Sbk_QzTools_PropertyStrings);
    SbkPyFalkonTypes[SBK_QZTOOLS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QzTools_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QzTools_TypeF(),
        QzTools_PythonToCpp_QzTools_PTR,
        is_QzTools_PythonToCpp_QzTools_PTR_Convertible,
        QzTools_PTR_CppToPython_QzTools);

    Shiboken::Conversions::registerConverterName(converter, "QzTools");
    Shiboken::Conversions::registerConverterName(converter, "QzTools*");
    Shiboken::Conversions::registerConverterName(converter, "QzTools&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QzTools).name());



}
