// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega32.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega32
// +build avr,atmega32

// Device information for the ATmega32.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega32"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset  and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_TIMER2_COMP  = 4  // Timer/Counter2 Compare Match
	IRQ_TIMER2_OVF   = 5  // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 6  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 7  // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 8  // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 9  // Timer/Counter1 Overflow
	IRQ_TIMER0_COMP  = 10 // Timer/Counter0 Compare Match
	IRQ_TIMER0_OVF   = 11 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 12 // Serial Transfer Complete
	IRQ_USART_RXC    = 13 // USART, Rx Complete
	IRQ_USART_UDRE   = 14 // USART Data Register Empty
	IRQ_USART_TXC    = 15 // USART, Tx Complete
	IRQ_ADC          = 16 // ADC Conversion Complete
	IRQ_EE_RDY       = 17 // EEPROM Ready
	IRQ_ANA_COMP     = 18 // Analog Comparator
	IRQ_TWI          = 19 // 2-wire Serial Interface
	IRQ_SPM_RDY      = 20 // Store Program Memory Ready
	IRQ_max          = 20 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_TIMER2_COMP
//go:interrupt
func interruptTIMER2_COMP() {
	callHandlers(IRQ_TIMER2_COMP)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMP
//go:interrupt
func interruptTIMER0_COMP() {
	callHandlers(IRQ_TIMER0_COMP)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART_RXC
//go:interrupt
func interruptUSART_RXC() {
	callHandlers(IRQ_USART_RXC)
}

//export __vector_USART_UDRE
//go:interrupt
func interruptUSART_UDRE() {
	callHandlers(IRQ_USART_UDRE)
}

//export __vector_USART_TXC
//go:interrupt
func interruptUSART_TXC() {
	callHandlers(IRQ_USART_TXC)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_SPM_RDY
//go:interrupt
func interruptSPM_RDY() {
	callHandlers(IRQ_SPM_RDY)
}

// Peripherals.
var (
	// Fuses
	HIGH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// JTAG Interface
	OCDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	MCUCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))

	// External Interrupts
	GICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5a)))
	MCUCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))

	// Timer/Counter, 8-bit
	TCCR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	TCNT0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))
	OCR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	TIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x59)))
	TIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x58)))

	// Timer/Counter, 8-bit Async
	TCCR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	OCR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))
	ASSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))

	// Timer/Counter, 16-bit
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))

	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))

	// USART
	UDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	UCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	UCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	UCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))

	// Analog Comparator
	SFIOR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// Bootloader
	SPMCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// Two Wire Serial Interface
	TWBR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	TWCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	TWSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	TWDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	TWAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
)

// Bitfields for FUSE: Fuses
const (
	// HIGH
	HIGH_OCDEN       = 0x80 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN      = 0x40 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_CKOPT       = 0x10 // Oscillator options
	HIGH_CKOPT_Msk   = 0x10 // Oscillator options
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_BODLEVEL      = 0x80 // Brownout detector trigger level
	LOW_BODLEVEL_Msk  = 0x80 // Brownout detector trigger level
	LOW_BODEN         = 0x40 // Brown-out detection enabled
	LOW_BODEN_Msk     = 0x40 // Brown-out detection enabled
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for JTAG: JTAG Interface
const (
	// OCDR: On-Chip Debug Related Register in I/O Memory
	OCDR_OCDR0    = 0x1  // On-Chip Debug Register Bits
	OCDR_OCDR1    = 0x2  // On-Chip Debug Register Bits
	OCDR_OCDR2    = 0x4  // On-Chip Debug Register Bits
	OCDR_OCDR3    = 0x8  // On-Chip Debug Register Bits
	OCDR_OCDR4    = 0x10 // On-Chip Debug Register Bits
	OCDR_OCDR5    = 0x20 // On-Chip Debug Register Bits
	OCDR_OCDR6    = 0x40 // On-Chip Debug Register Bits
	OCDR_OCDR7    = 0x80 // On-Chip Debug Register Bits
	OCDR_OCDR_Msk = 0xff // On-Chip Debug Register Bits

	// MCUCSR: MCU Control And Status Register
	MCUCSR_JTD       = 0x80 // JTAG Interface Disable
	MCUCSR_JTD_Msk   = 0x80 // JTAG Interface Disable
	MCUCSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUCSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUCSR_ISC2      = 0x40 // Interrupt Sense Control 2
	MCUCSR_ISC2_Msk  = 0x40 // Interrupt Sense Control 2
	MCUCSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUCSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUCSR_BORF      = 0x4  // Brown-out Reset Flag
	MCUCSR_BORF_Msk  = 0x4  // Brown-out Reset Flag
	MCUCSR_EXTRF     = 0x2  // External Reset Flag
	MCUCSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUCSR_PORF      = 0x1  // Power-on reset flag
	MCUCSR_PORF_Msk  = 0x1  // Power-on reset flag
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EERIE     = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4 // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4 // EEPROM Master Write Enable
	EECR_EEWE      = 0x2 // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2 // EEPROM Write Enable
	EECR_EERE      = 0x1 // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1 // EEPROM Read Enable
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDTOE     = 0x10 // RW
	WDTCR_WDTOE_Msk = 0x10 // RW
	WDTCR_WDE       = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk   = 0x8  // Watch Dog Enable
	WDTCR_WDP0      = 0x1  // Watch Dog Timer Prescaler bits
	WDTCR_WDP1      = 0x2  // Watch Dog Timer Prescaler bits
	WDTCR_WDP2      = 0x4  // Watch Dog Timer Prescaler bits
	WDTCR_WDP_Msk   = 0x7  // Watch Dog Timer Prescaler bits
)

// Bitfields for EXINT: External Interrupts
const (
	// GICR: General Interrupt Control Register
	GICR_INT0      = 0x40 // External Interrupt Request 0 Enable
	GICR_INT0_Msk  = 0x40 // External Interrupt Request 0 Enable
	GICR_INT1      = 0x80 // External Interrupt Request 1 Enable
	GICR_INT1_Msk  = 0x80 // External Interrupt Request 1 Enable
	GICR_INT2      = 0x20 // External Interrupt Request 2 Enable
	GICR_INT2_Msk  = 0x20 // External Interrupt Request 2 Enable
	GICR_IVSEL     = 0x2  // Interrupt Vector Select
	GICR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	GICR_IVCE      = 0x1  // Interrupt Vector Change Enable
	GICR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// GIFR: General Interrupt Flag Register
	GIFR_INTF0     = 0x40 // External Interrupt Flags
	GIFR_INTF1     = 0x80 // External Interrupt Flags
	GIFR_INTF_Msk  = 0xc0 // External Interrupt Flags
	GIFR_INTF2     = 0x20 // External Interrupt Flag 2
	GIFR_INTF2_Msk = 0x20 // External Interrupt Flag 2

	// MCUCR: General Interrupt Control Register
	MCUCR_ISC10    = 0x4  // Interrupt Sense Control 1 Bits
	MCUCR_ISC11    = 0x8  // Interrupt Sense Control 1 Bits
	MCUCR_ISC1_Msk = 0xc  // Interrupt Sense Control 1 Bits
	MCUCR_ISC00    = 0x1  // Interrupt Sense Control 0 Bits
	MCUCR_ISC01    = 0x2  // Interrupt Sense Control 0 Bits
	MCUCR_ISC0_Msk = 0x3  // Interrupt Sense Control 0 Bits
	MCUCR_SE       = 0x80 // Sleep Enable
	MCUCR_SE_Msk   = 0x80 // Sleep Enable
	MCUCR_SM0      = 0x10 // Sleep Mode Select
	MCUCR_SM1      = 0x20 // Sleep Mode Select
	MCUCR_SM2      = 0x40 // Sleep Mode Select
	MCUCR_SM_Msk   = 0x70 // Sleep Mode Select
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0: Timer/Counter Control Register
	TCCR0_FOC0      = 0x80 // Force Output Compare
	TCCR0_FOC0_Msk  = 0x80 // Force Output Compare
	TCCR0_WGM00     = 0x40 // Waveform Generation Mode
	TCCR0_WGM00_Msk = 0x40 // Waveform Generation Mode
	TCCR0_COM00     = 0x10 // Compare Match Output Modes
	TCCR0_COM01     = 0x20 // Compare Match Output Modes
	TCCR0_COM0_Msk  = 0x30 // Compare Match Output Modes
	TCCR0_WGM01     = 0x8  // Waveform Generation Mode 1
	TCCR0_WGM01_Msk = 0x8  // Waveform Generation Mode 1
	TCCR0_CS00      = 0x1  // Clock Selects
	TCCR0_CS01      = 0x2  // Clock Selects
	TCCR0_CS02      = 0x4  // Clock Selects
	TCCR0_CS0_Msk   = 0x7  // Clock Selects

	// TIMSK: Timer/Counter Interrupt Mask Register
	TIMSK_OCIE0      = 0x2  // Timer/Counter0 Output Compare Match Interrupt register
	TIMSK_OCIE0_Msk  = 0x2  // Timer/Counter0 Output Compare Match Interrupt register
	TIMSK_TOIE0      = 0x1  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_TOIE0_Msk  = 0x1  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_OCIE2      = 0x80 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK_OCIE2_Msk  = 0x80 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK_TOIE2      = 0x40 // Timer/Counter2 Overflow Interrupt Enable
	TIMSK_TOIE2_Msk  = 0x40 // Timer/Counter2 Overflow Interrupt Enable
	TIMSK_TICIE1     = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK_TICIE1_Msk = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK_OCIE1A     = 0x10 // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK_OCIE1A_Msk = 0x10 // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK_OCIE1B     = 0x8  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK_OCIE1B_Msk = 0x8  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK_TOIE1      = 0x4  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK_TOIE1_Msk  = 0x4  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR: Timer/Counter Interrupt Flag register
	TIFR_OCF0      = 0x2  // Output Compare Flag 0
	TIFR_OCF0_Msk  = 0x2  // Output Compare Flag 0
	TIFR_TOV0      = 0x1  // Timer/Counter0 Overflow Flag
	TIFR_TOV0_Msk  = 0x1  // Timer/Counter0 Overflow Flag
	TIFR_OCF2      = 0x80 // Output Compare Flag 2
	TIFR_OCF2_Msk  = 0x80 // Output Compare Flag 2
	TIFR_TOV2      = 0x40 // Timer/Counter2 Overflow Flag
	TIFR_TOV2_Msk  = 0x40 // Timer/Counter2 Overflow Flag
	TIFR_ICF1      = 0x20 // Input Capture Flag 1
	TIFR_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR_OCF1A     = 0x10 // Output Compare Flag 1A
	TIFR_OCF1A_Msk = 0x10 // Output Compare Flag 1A
	TIFR_OCF1B     = 0x8  // Output Compare Flag 1B
	TIFR_OCF1B_Msk = 0x8  // Output Compare Flag 1B
	TIFR_TOV1      = 0x4  // Timer/Counter1 Overflow Flag
	TIFR_TOV1_Msk  = 0x4  // Timer/Counter1 Overflow Flag
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TCCR2: Timer/Counter2 Control Register
	TCCR2_FOC2      = 0x80 // Force Output Compare
	TCCR2_FOC2_Msk  = 0x80 // Force Output Compare
	TCCR2_WGM20     = 0x40 // Pulse Width Modulator Enable
	TCCR2_WGM20_Msk = 0x40 // Pulse Width Modulator Enable
	TCCR2_COM20     = 0x10 // Compare Output Mode bits
	TCCR2_COM21     = 0x20 // Compare Output Mode bits
	TCCR2_COM2_Msk  = 0x30 // Compare Output Mode bits
	TCCR2_WGM21     = 0x8  // Clear Timer/Counter2 on Compare Match
	TCCR2_WGM21_Msk = 0x8  // Clear Timer/Counter2 on Compare Match
	TCCR2_CS20      = 0x1  // Clock Select bits
	TCCR2_CS21      = 0x2  // Clock Select bits
	TCCR2_CS22      = 0x4  // Clock Select bits
	TCCR2_CS2_Msk   = 0x7  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_AS2        = 0x8 // Asynchronous Timer/counter2
	ASSR_AS2_Msk    = 0x8 // Asynchronous Timer/counter2
	ASSR_TCN2UB     = 0x4 // Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk = 0x4 // Timer/Counter2 Update Busy
	ASSR_OCR2UB     = 0x2 // Output Compare Register2 Update Busy
	ASSR_OCR2UB_Msk = 0x2 // Output Compare Register2 Update Busy
	ASSR_TCR2UB     = 0x1 // Timer/counter Control Register2 Update Busy
	ASSR_TCR2UB_Msk = 0x1 // Timer/counter Control Register2 Update Busy
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_FOC1A     = 0x8  // Force Output Compare 1A
	TCCR1A_FOC1A_Msk = 0x8  // Force Output Compare 1A
	TCCR1A_FOC1B     = 0x4  // Force Output Compare 1B
	TCCR1A_FOC1B_Msk = 0x4  // Force Output Compare 1B
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects
)

// Bitfields for USART: USART
const (
	// UCSRA: USART Control and Status Register A
	UCSRA_RXC      = 0x80 // USART Receive Complete
	UCSRA_RXC_Msk  = 0x80 // USART Receive Complete
	UCSRA_TXC      = 0x40 // USART Transmitt Complete
	UCSRA_TXC_Msk  = 0x40 // USART Transmitt Complete
	UCSRA_UDRE     = 0x20 // USART Data Register Empty
	UCSRA_UDRE_Msk = 0x20 // USART Data Register Empty
	UCSRA_FE       = 0x10 // Framing Error
	UCSRA_FE_Msk   = 0x10 // Framing Error
	UCSRA_DOR      = 0x8  // Data overRun
	UCSRA_DOR_Msk  = 0x8  // Data overRun
	UCSRA_UPE      = 0x4  // Parity Error
	UCSRA_UPE_Msk  = 0x4  // Parity Error
	UCSRA_U2X      = 0x2  // Double the USART transmission speed
	UCSRA_U2X_Msk  = 0x2  // Double the USART transmission speed
	UCSRA_MPCM     = 0x1  // Multi-processor Communication Mode
	UCSRA_MPCM_Msk = 0x1  // Multi-processor Communication Mode

	// UCSRB: USART Control and Status Register B
	UCSRB_RXCIE     = 0x80 // RX Complete Interrupt Enable
	UCSRB_RXCIE_Msk = 0x80 // RX Complete Interrupt Enable
	UCSRB_TXCIE     = 0x40 // TX Complete Interrupt Enable
	UCSRB_TXCIE_Msk = 0x40 // TX Complete Interrupt Enable
	UCSRB_UDRIE     = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_UDRIE_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_RXEN      = 0x10 // Receiver Enable
	UCSRB_RXEN_Msk  = 0x10 // Receiver Enable
	UCSRB_TXEN      = 0x8  // Transmitter Enable
	UCSRB_TXEN_Msk  = 0x8  // Transmitter Enable
	UCSRB_UCSZ2     = 0x4  // Character Size
	UCSRB_UCSZ2_Msk = 0x4  // Character Size
	UCSRB_RXB8      = 0x2  // Receive Data Bit 8
	UCSRB_RXB8_Msk  = 0x2  // Receive Data Bit 8
	UCSRB_TXB8      = 0x1  // Transmit Data Bit 8
	UCSRB_TXB8_Msk  = 0x1  // Transmit Data Bit 8

	// UCSRC: USART Control and Status Register C
	UCSRC_URSEL     = 0x80 // Register Select
	UCSRC_URSEL_Msk = 0x80 // Register Select
	UCSRC_UMSEL     = 0x40 // USART Mode Select
	UCSRC_UMSEL_Msk = 0x40 // USART Mode Select
	UCSRC_UPM0      = 0x10 // Parity Mode Bits
	UCSRC_UPM1      = 0x20 // Parity Mode Bits
	UCSRC_UPM_Msk   = 0x30 // Parity Mode Bits
	UCSRC_USBS      = 0x8  // Stop Bit Select
	UCSRC_USBS_Msk  = 0x8  // Stop Bit Select
	UCSRC_UCSZ0     = 0x2  // Character Size
	UCSRC_UCSZ1     = 0x4  // Character Size
	UCSRC_UCSZ_Msk  = 0x6  // Character Size
	UCSRC_UCPOL     = 0x1  // Clock Polarity
	UCSRC_UCPOL_Msk = 0x1  // Clock Polarity
)

// Bitfields for AC: Analog Comparator
const (
	// SFIOR: Special Function IO Register
	SFIOR_ADTS0     = 0x20 // ADC Auto Trigger Source
	SFIOR_ADTS1     = 0x40 // ADC Auto Trigger Source
	SFIOR_ADTS2     = 0x80 // ADC Auto Trigger Source
	SFIOR_ADTS_Msk  = 0xe0 // ADC Auto Trigger Source
	SFIOR_ACME      = 0x8  // Analog Comparator Multiplexer Enable
	SFIOR_ACME_Msk  = 0x8  // Analog Comparator Multiplexer Enable
	SFIOR_PUD       = 0x4  // Pull-up disable
	SFIOR_PUD_Msk   = 0x4  // Pull-up disable
	SFIOR_PSR2      = 0x2  // Prescaler Reset Timer/Counter2
	SFIOR_PSR2_Msk  = 0x2  // Prescaler Reset Timer/Counter2
	SFIOR_PSR10     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	SFIOR_PSR10_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0

	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC Prescaler Select Bits
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCR: Store Program Memory Control Register
	SPMCR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCR_RWWSRE     = 0x10 // Read While Write secion read enable
	SPMCR_RWWSRE_Msk = 0x10 // Read While Write secion read enable
	SPMCR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCR_PGWRT      = 0x4  // Page Write
	SPMCR_PGWRT_Msk  = 0x4  // Page Write
	SPMCR_PGERS      = 0x2  // Page Erase
	SPMCR_PGERS_Msk  = 0x2  // Page Erase
	SPMCR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler bits
	TWSR_TWPS1    = 0x2  // TWI Prescaler bits
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler bits

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI address bits
	TWAR_TWA1      = 0x4  // TWI address bits
	TWAR_TWA2      = 0x8  // TWI address bits
	TWAR_TWA3      = 0x10 // TWI address bits
	TWAR_TWA4      = 0x20 // TWI address bits
	TWAR_TWA5      = 0x40 // TWI address bits
	TWAR_TWA6      = 0x80 // TWI address bits
	TWAR_TWA_Msk   = 0xfe // TWI address bits
	TWAR_TWGCE     = 0x1  // TWI general call recognition enable bit
	TWAR_TWGCE_Msk = 0x1  // TWI general call recognition enable bit
)
