/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ECDH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.KeyPairECDSA;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;

public abstract class DHECN
extends KeyExchange {
    private static final int SSH_MSG_KEX_ECDH_INIT = 30;
    private static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    private int state;
    byte[] Q_C;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    byte[] e;
    private Buffer buf;
    private Packet packet;
    private ECDH ecdh;
    protected String sha_name;
    protected int key_size;

    @Override
    public void init(Session session, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        Class<?> clazz;
        this.session = session;
        this.V_S = byArray;
        this.V_C = byArray2;
        this.I_S = byArray3;
        this.I_C = byArray4;
        try {
            clazz = Class.forName(session.getConfig(this.sha_name));
            this.sha = (HASH)clazz.newInstance();
            this.sha.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        this.packet.reset();
        this.buf.putByte((byte)30);
        try {
            clazz = Class.forName(session.getConfig("ecdh-sha2-nistp"));
            this.ecdh = (ECDH)clazz.newInstance();
            this.ecdh.init(this.key_size);
            this.Q_C = this.ecdh.getQ();
            this.buf.putString(this.Q_C);
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
        if (byArray == null) {
            return;
        }
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEX_ECDH_INIT sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEX_ECDH_REPLY");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer buffer) throws Exception {
        switch (this.state) {
            case 31: {
                int n = buffer.getInt();
                n = buffer.getByte();
                n = buffer.getByte();
                if (n != 31) {
                    System.err.println("type: must be 31 " + n);
                    return false;
                }
                this.K_S = buffer.getString();
                byte[] byArray = buffer.getString();
                byte[][] byArray2 = KeyPairECDSA.fromPoint(byArray);
                if (!this.ecdh.validate(byArray2[0], byArray2[1])) {
                    return false;
                }
                this.K = this.ecdh.getSecret(byArray2[0], byArray2[1]);
                this.K = this.normalize(this.K);
                byte[] byArray3 = buffer.getString();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putString(this.Q_C);
                this.buf.putString(byArray);
                this.buf.putMPInt(this.K);
                byte[] byArray4 = new byte[this.buf.getLength()];
                this.buf.getByte(byArray4);
                this.sha.update(byArray4, 0, byArray4.length);
                this.H = this.sha.digest();
                int n2 = 0;
                n = 0;
                n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                String string = Util.byte2str(this.K_S, n2, n);
                boolean bl = this.verify(string, this.K_S, n2 += n, byArray3);
                this.state = 0;
                return bl;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

