/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.SceneGraphObject;

public class DepthComponentFloatState
extends NodeComponentState {
    private int height;
    private int width;

    public DepthComponentFloatState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        float[] fArray = new float[this.width * this.height];
        ((DepthComponentFloat)this.node).getDepthData(fArray);
        for (int i = 0; i < fArray.length; ++i) {
            dataOutput.writeFloat(fArray[i]);
        }
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        float[] fArray = new float[this.width * this.height];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = dataInput.readFloat();
        }
        ((DepthComponentFloat)this.node).setDepthData(fArray);
    }

    @Override
    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeInt(this.width);
        dataOutput.writeInt(this.height);
    }

    @Override
    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.width = dataInput.readInt();
        this.height = dataInput.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.width), new Integer(this.height)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new DepthComponentFloat(this.width, this.height);
    }
}

