/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.set.hash.TLongHashSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.VehicleRouter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class GeneralRouter
implements VehicleRouter {
    private static final float CAR_SHORTEST_DEFAULT_SPEED = 15.277779f;
    public static final String USE_SHORTEST_WAY = "short_way";
    public static final String AVOID_FERRIES = "avoid_ferries";
    public static final String AVOID_TOLL = "avoid_toll";
    public static final String AVOID_MOTORWAY = "avoid_motorway";
    public static final String AVOID_UNPAVED = "avoid_unpaved";
    public static final String PREFER_MOTORWAYS = "prefer_motorway";
    private final RouteAttributeContext[] objectAttributes;
    public final Map<String, String> attributes;
    private final Map<String, RoutingParameter> parameters;
    private final Map<String, Integer> universalRules;
    private final List<String> universalRulesById;
    private final Map<String, BitSet> tagRuleMask;
    private final ArrayList<Object> ruleToValue;
    private boolean shortestRoute;
    private Map<BinaryMapRouteReaderAdapter.RouteRegion, Map<Integer, Integer>> regionConvert = new LinkedHashMap<BinaryMapRouteReaderAdapter.RouteRegion, Map<Integer, Integer>>();
    private boolean restrictionsAware = true;
    private float leftTurn;
    private float roundaboutTurn;
    private float rightTurn;
    private float minDefaultSpeed = 10.0f;
    private float maxDefaultSpeed = 10.0f;
    private TLongHashSet impassableRoads;

    public GeneralRouter(GeneralRouterProfile profile, Map<String, String> attributes) {
        this.attributes = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> next : attributes.entrySet()) {
            this.addAttribute(next.getKey(), next.getValue());
        }
        this.objectAttributes = new RouteAttributeContext[RouteDataObjectAttribute.values().length];
        for (int i = 0; i < this.objectAttributes.length; ++i) {
            this.objectAttributes[i] = new RouteAttributeContext();
        }
        this.universalRules = new LinkedHashMap<String, Integer>();
        this.universalRulesById = new ArrayList<String>();
        this.tagRuleMask = new LinkedHashMap<String, BitSet>();
        this.ruleToValue = new ArrayList();
        this.parameters = new LinkedHashMap<String, RoutingParameter>();
    }

    public GeneralRouter(GeneralRouter parent, Map<String, String> params) {
        this.attributes = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> next : parent.attributes.entrySet()) {
            this.addAttribute(next.getKey(), next.getValue());
        }
        this.universalRules = parent.universalRules;
        this.universalRulesById = parent.universalRulesById;
        this.tagRuleMask = parent.tagRuleMask;
        this.ruleToValue = parent.ruleToValue;
        this.parameters = parent.parameters;
        this.objectAttributes = new RouteAttributeContext[RouteDataObjectAttribute.values().length];
        for (int i = 0; i < this.objectAttributes.length; ++i) {
            this.objectAttributes[i] = new RouteAttributeContext(parent.objectAttributes[i], params);
        }
        boolean bl = this.shortestRoute = params.containsKey(USE_SHORTEST_WAY) && GeneralRouter.parseSilentBoolean(params.get(USE_SHORTEST_WAY), false);
        if (this.shortestRoute) {
            this.maxDefaultSpeed = Math.min(15.277779f, this.maxDefaultSpeed);
        }
    }

    public Map<String, RoutingParameter> getParameters() {
        return this.parameters;
    }

    public void addAttribute(String k, String v) {
        this.attributes.put(k, v);
        if (k.equals("restrictionsAware")) {
            this.restrictionsAware = GeneralRouter.parseSilentBoolean(v, this.restrictionsAware);
        } else if (k.equals("leftTurn")) {
            this.leftTurn = GeneralRouter.parseSilentFloat(v, this.leftTurn);
        } else if (k.equals("rightTurn")) {
            this.rightTurn = GeneralRouter.parseSilentFloat(v, this.rightTurn);
        } else if (k.equals("roundaboutTurn")) {
            this.roundaboutTurn = GeneralRouter.parseSilentFloat(v, this.roundaboutTurn);
        } else if (k.equals("minDefaultSpeed")) {
            this.minDefaultSpeed = GeneralRouter.parseSilentFloat(v, this.minDefaultSpeed * 3.6f) / 3.6f;
        } else if (k.equals("maxDefaultSpeed")) {
            this.maxDefaultSpeed = GeneralRouter.parseSilentFloat(v, this.maxDefaultSpeed * 3.6f) / 3.6f;
        }
    }

    public RouteAttributeContext getObjContext(RouteDataObjectAttribute a) {
        return this.objectAttributes[a.ordinal()];
    }

    public void registerBooleanParameter(String id2, String name, String description) {
        RoutingParameter rp = new RoutingParameter();
        rp.name = name;
        rp.description = description;
        rp.id = id2;
        rp.type = RoutingParameterType.BOOLEAN;
        this.parameters.put(rp.id, rp);
    }

    public void registerNumericParameter(String id2, String name, String description, Double[] vls, String[] vlsDescriptions) {
        RoutingParameter rp = new RoutingParameter();
        rp.name = name;
        rp.description = description;
        rp.id = id2;
        RoutingParameter.access$402(rp, vls);
        RoutingParameter.access$502(rp, vlsDescriptions);
        rp.type = RoutingParameterType.NUMERIC;
        this.parameters.put(rp.id, rp);
    }

    @Override
    public boolean acceptLine(RouteDataObject way) {
        int res = this.getObjContext(RouteDataObjectAttribute.ACCESS).evaluateInt(way, 0);
        if (this.impassableRoads != null && this.impassableRoads.contains(way.id)) {
            return false;
        }
        return res >= 0;
    }

    public long[] getImpassableRoadIds() {
        if (this.impassableRoads == null) {
            return new long[0];
        }
        return this.impassableRoads.toArray();
    }

    private int registerTagValueAttribute(String tag, String value) {
        String key = tag + "$" + value;
        if (this.universalRules.containsKey(key)) {
            return this.universalRules.get(key);
        }
        int id2 = this.universalRules.size();
        this.universalRulesById.add(key);
        this.universalRules.put(key, id2);
        if (!this.tagRuleMask.containsKey(tag)) {
            this.tagRuleMask.put(tag, new BitSet());
        }
        this.tagRuleMask.get(tag).set(id2);
        return id2;
    }

    private Object parseValue(String value, String type) {
        float vl = -1.0f;
        value = value.trim();
        if ("speed".equals(type)) {
            vl = RouteDataObject.parseSpeed(value, vl);
        } else if ("weight".equals(type)) {
            vl = RouteDataObject.parseWeightInTon(value, vl);
        } else if ("length".equals(type)) {
            vl = RouteDataObject.parseLength(value, vl);
        } else {
            int i = Algorithms.findFirstNumberEndIndex(value);
            if (i > 0) {
                return Float.valueOf(Float.parseFloat(value.substring(0, i)));
            }
        }
        if (vl == -1.0f) {
            return null;
        }
        return Float.valueOf(vl);
    }

    private Object parseValueFromTag(int id2, String type) {
        while (this.ruleToValue.size() <= id2) {
            this.ruleToValue.add(null);
        }
        Object res = this.ruleToValue.get(id2);
        if (res == null) {
            String v = this.universalRulesById.get(id2);
            String value = v.substring(v.indexOf(36) + 1);
            res = this.parseValue(value, type);
            if (res == null) {
                res = "";
            }
            this.ruleToValue.set(id2, res);
        }
        if ("".equals(res)) {
            return null;
        }
        return res;
    }

    @Override
    public GeneralRouter build(Map<String, String> params) {
        return new GeneralRouter(this, params);
    }

    @Override
    public boolean restrictionsAware() {
        return this.restrictionsAware;
    }

    @Override
    public float defineObstacle(RouteDataObject road, int point) {
        int[] pointTypes = road.getPointTypes(point);
        if (pointTypes != null) {
            return this.getObjContext(RouteDataObjectAttribute.OBSTACLES).evaluateFloat(road.region, pointTypes, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public float defineRoutingObstacle(RouteDataObject road, int point) {
        int[] pointTypes = road.getPointTypes(point);
        if (pointTypes != null) {
            return this.getObjContext(RouteDataObjectAttribute.ROUTING_OBSTACLES).evaluateFloat(road.region, pointTypes, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public int isOneWay(RouteDataObject road) {
        return this.getObjContext(RouteDataObjectAttribute.ONEWAY).evaluateInt(road, 0);
    }

    @Override
    public float getPenaltyTransition(RouteDataObject road) {
        return this.getObjContext(RouteDataObjectAttribute.PENALTY_TRANSITION).evaluateInt(road, 0);
    }

    @Override
    public float defineRoutingSpeed(RouteDataObject road) {
        return Math.min(this.defineVehicleSpeed(road), this.maxDefaultSpeed);
    }

    @Override
    public float defineVehicleSpeed(RouteDataObject road) {
        return this.getObjContext(RouteDataObjectAttribute.ROAD_SPEED).evaluateFloat(road, this.getMinDefaultSpeed());
    }

    @Override
    public float defineSpeedPriority(RouteDataObject road) {
        return this.getObjContext(RouteDataObjectAttribute.ROAD_PRIORITIES).evaluateFloat(road, 1.0f);
    }

    @Override
    public float getMinDefaultSpeed() {
        return this.minDefaultSpeed;
    }

    @Override
    public float getMaxDefaultSpeed() {
        return this.maxDefaultSpeed;
    }

    public double getLeftTurn() {
        return this.leftTurn;
    }

    public double getRightTurn() {
        return this.rightTurn;
    }

    public double getRoundaboutTurn() {
        return this.roundaboutTurn;
    }

    @Override
    public double calculateTurnTime(BinaryRoutePlanner.RouteSegment segment, int segmentEnd, BinaryRoutePlanner.RouteSegment prev, int prevSegmentEnd) {
        double rt;
        float ts = this.getPenaltyTransition(segment.getRoad());
        float prevTs = this.getPenaltyTransition(prev.getRoad());
        if (prevTs != ts && ts > prevTs) {
            return ts - prevTs;
        }
        if (segment.getRoad().roundabout() && !prev.getRoad().roundabout() && (rt = this.getRoundaboutTurn()) > 0.0) {
            return rt;
        }
        if (this.getLeftTurn() > 0.0 || this.getRightTurn() > 0.0) {
            double a2;
            double a1 = segment.getRoad().directionRoute(segment.getSegmentStart(), segment.getSegmentStart() < segmentEnd);
            double diff = Math.abs(MapUtils.alignAngleDifference(a1 - (a2 = prev.getRoad().directionRoute(prevSegmentEnd, prevSegmentEnd < prev.getSegmentStart())) - Math.PI));
            if (diff > 2.0943951023931953) {
                return this.getLeftTurn();
            }
            if (diff > 1.5707963267948966) {
                return this.getRightTurn();
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public boolean containsAttribute(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    @Override
    public String getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    private static boolean parseSilentBoolean(String t, boolean v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Boolean.parseBoolean(t);
    }

    private static float parseSilentFloat(String t, float v) {
        if (t == null || t.length() == 0) {
            return v;
        }
        return Float.parseFloat(t);
    }

    public void printRules(PrintStream out) {
        for (int i = 0; i < RouteDataObjectAttribute.values().length; ++i) {
            out.println((Object)RouteDataObjectAttribute.values()[i]);
            this.objectAttributes[i].printRules(out);
        }
    }

    public void addImpassableRoads(Set<Long> impassableRoads) {
        if (impassableRoads != null && !impassableRoads.isEmpty()) {
            if (this.impassableRoads == null) {
                this.impassableRoads = new TLongHashSet();
            }
            this.impassableRoads.addAll(impassableRoads);
        }
    }

    public class RouteAttributeEvalRule {
        protected List<String> parameters = new ArrayList<String>();
        protected List<String> tagValueCondDefTag = new ArrayList<String>();
        protected List<String> tagValueCondDefValue = new ArrayList<String>();
        protected List<Boolean> tagValueCondDefNot = new ArrayList<Boolean>();
        protected String selectValueDef = null;
        protected Object selectValue = null;
        protected String selectType = null;
        protected BitSet filterTypes = new BitSet();
        protected BitSet filterNotTypes = new BitSet();
        protected BitSet evalFilterTypes = new BitSet();
        protected Set<String> onlyTags = new LinkedHashSet<String>();
        protected Set<String> onlyNotTags = new LinkedHashSet<String>();
        protected List<RouteAttributeExpression> expressions = new ArrayList<RouteAttributeExpression>();

        public RouteAttributeExpression[] getExpressions() {
            return this.expressions.toArray(new RouteAttributeExpression[this.expressions.size()]);
        }

        public String[] getParameters() {
            return this.parameters.toArray(new String[this.parameters.size()]);
        }

        public String[] getTagValueCondDefTag() {
            return this.tagValueCondDefTag.toArray(new String[this.tagValueCondDefTag.size()]);
        }

        public String[] getTagValueCondDefValue() {
            return this.tagValueCondDefValue.toArray(new String[this.tagValueCondDefValue.size()]);
        }

        public boolean[] getTagValueCondDefNot() {
            boolean[] r = new boolean[this.tagValueCondDefNot.size()];
            for (int i = 0; i < r.length; ++i) {
                r[i] = this.tagValueCondDefNot.get(i);
            }
            return r;
        }

        public void registerSelectValue(String value, String type) {
            this.selectType = type;
            this.selectValueDef = value;
            if (value.startsWith(":") || value.startsWith("$")) {
                this.selectValue = value;
            } else {
                this.selectValue = GeneralRouter.this.parseValue(value, type);
                if (this.selectValue == null) {
                    System.err.println("Routing.xml select value '" + value + "' was not registered");
                }
            }
        }

        public void printRule(PrintStream out) {
            String key;
            int k;
            out.print(" Select " + this.selectValue + " if ");
            for (k = 0; k < this.filterTypes.size(); ++k) {
                if (!this.filterTypes.get(k)) continue;
                key = (String)GeneralRouter.this.universalRulesById.get(k);
                out.print(key + " ");
            }
            if (this.filterNotTypes.size() > 0) {
                out.print(" ifnot ");
            }
            for (k = 0; k < this.filterNotTypes.size(); ++k) {
                if (!this.filterNotTypes.get(k)) continue;
                key = (String)GeneralRouter.this.universalRulesById.get(k);
                out.print(key + " ");
            }
            for (k = 0; k < this.parameters.size(); ++k) {
                out.print(" param=" + this.parameters.get(k));
            }
            if (this.onlyTags.size() > 0) {
                out.print(" match tag = " + this.onlyTags);
            }
            if (this.onlyNotTags.size() > 0) {
                out.print(" not match tag = " + this.onlyNotTags);
            }
            if (this.expressions.size() > 0) {
                out.println(" subexpressions " + this.expressions.size());
            }
            out.println();
        }

        public void registerAndTagValueCondition(String tag, String value, boolean not) {
            this.tagValueCondDefTag.add(tag);
            this.tagValueCondDefValue.add(value);
            this.tagValueCondDefNot.add(not);
            if (value == null) {
                if (not) {
                    this.onlyNotTags.add(tag);
                } else {
                    this.onlyTags.add(tag);
                }
            } else {
                int vtype = GeneralRouter.this.registerTagValueAttribute(tag, value);
                if (not) {
                    this.filterNotTypes.set(vtype);
                } else {
                    this.filterTypes.set(vtype);
                }
            }
        }

        public void registerLessCondition(String value1, String value2, String valueType) {
            this.expressions.add(new RouteAttributeExpression(new String[]{value1, value2}, valueType, 1));
        }

        public void registerGreatCondition(String value1, String value2, String valueType) {
            this.expressions.add(new RouteAttributeExpression(new String[]{value1, value2}, valueType, 2));
        }

        public void registerAndParamCondition(String param, boolean not) {
            param = not ? "-" + param : param;
            this.parameters.add(param);
        }

        public Object eval(BitSet types, ParameterContext paramContext) {
            if (this.matches(types, paramContext)) {
                return this.calcSelectValue(types, paramContext);
            }
            return null;
        }

        protected Object calcSelectValue(BitSet types, ParameterContext paramContext) {
            if (this.selectValue instanceof String && this.selectValue.toString().startsWith("$")) {
                BitSet mask = (BitSet)GeneralRouter.this.tagRuleMask.get(this.selectValue.toString().substring(1));
                if (mask != null && mask.intersects(types)) {
                    BitSet findBit = new BitSet(mask.size());
                    findBit.or(mask);
                    findBit.and(types);
                    int value = findBit.nextSetBit(0);
                    return GeneralRouter.this.parseValueFromTag(value, this.selectType);
                }
            } else if (this.selectValue instanceof String && this.selectValue.toString().startsWith(":")) {
                String p = ((String)this.selectValue).substring(1);
                if (paramContext != null && paramContext.vars.containsKey(p)) {
                    this.selectValue = GeneralRouter.this.parseValue((String)paramContext.vars.get(p), this.selectType);
                } else {
                    return null;
                }
            }
            return this.selectValue;
        }

        public boolean matches(BitSet types, ParameterContext paramContext) {
            if (!this.checkAllTypesShouldBePresent(types)) {
                return false;
            }
            if (!this.checkAllTypesShouldNotBePresent(types)) {
                return false;
            }
            if (!this.checkFreeTags(types)) {
                return false;
            }
            if (!this.checkNotFreeTags(types)) {
                return false;
            }
            return this.checkExpressions(types, paramContext);
        }

        private boolean checkExpressions(BitSet types, ParameterContext paramContext) {
            for (RouteAttributeExpression e : this.expressions) {
                if (e.matches(types, paramContext)) continue;
                return false;
            }
            return true;
        }

        private boolean checkFreeTags(BitSet types) {
            for (String ts : this.onlyTags) {
                BitSet b = (BitSet)GeneralRouter.this.tagRuleMask.get(ts);
                if (b != null && b.intersects(types)) continue;
                return false;
            }
            return true;
        }

        private boolean checkNotFreeTags(BitSet types) {
            for (String ts : this.onlyNotTags) {
                BitSet b = (BitSet)GeneralRouter.this.tagRuleMask.get(ts);
                if (b == null || !b.intersects(types)) continue;
                return false;
            }
            return true;
        }

        private boolean checkAllTypesShouldNotBePresent(BitSet types) {
            return !this.filterNotTypes.intersects(types);
        }

        private boolean checkAllTypesShouldBePresent(BitSet types) {
            this.evalFilterTypes.or(this.filterTypes);
            this.evalFilterTypes.and(types);
            return this.evalFilterTypes.equals(this.filterTypes);
        }
    }

    public class RouteAttributeExpression {
        public static final int LESS_EXPRESSION = 1;
        public static final int GREAT_EXPRESSION = 2;
        private String[] values;
        private int expressionType;
        private String valueType;
        private Number[] cacheValues;

        public RouteAttributeExpression(String[] vs, String valueType, int expressionId) {
            this.expressionType = expressionId;
            this.values = vs;
            if (vs.length < 2) {
                throw new IllegalStateException("Expression should have at least 2 arguments");
            }
            this.cacheValues = new Number[vs.length];
            this.valueType = valueType;
            for (int i = 0; i < vs.length; ++i) {
                Object o;
                if (vs[i].startsWith("$") || vs[i].startsWith(":") || !((o = GeneralRouter.this.parseValue(vs[i], valueType)) instanceof Number)) continue;
                this.cacheValues[i] = (Number)o;
            }
        }

        public boolean matches(BitSet types, ParameterContext paramContext) {
            double f1 = this.calculateExprValue(0, types, paramContext);
            double f2 = this.calculateExprValue(1, types, paramContext);
            if (Double.isNaN(f1) || Double.isNaN(f2)) {
                return false;
            }
            if (this.expressionType == 1) {
                return f1 <= f2;
            }
            if (this.expressionType == 2) {
                return f1 >= f2;
            }
            return false;
        }

        private double calculateExprValue(int id2, BitSet types, ParameterContext paramContext) {
            String value = this.values[id2];
            Number cacheValue = this.cacheValues[id2];
            if (cacheValue != null) {
                return cacheValue.doubleValue();
            }
            Object o = null;
            if (value instanceof String && value.toString().startsWith("$")) {
                BitSet mask = (BitSet)GeneralRouter.this.tagRuleMask.get(value.toString().substring(1));
                if (mask != null && mask.intersects(types)) {
                    BitSet findBit = new BitSet(mask.size());
                    findBit.or(mask);
                    findBit.and(types);
                    int v = findBit.nextSetBit(0);
                    o = GeneralRouter.this.parseValueFromTag(v, this.valueType);
                }
            } else if (value instanceof String && value.toString().startsWith(":")) {
                String p = value.substring(1);
                if (paramContext != null && paramContext.vars.containsKey(p)) {
                    o = GeneralRouter.this.parseValue((String)paramContext.vars.get(p), this.valueType);
                }
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            return Double.NaN;
        }
    }

    public class RouteAttributeContext {
        List<RouteAttributeEvalRule> rules = new ArrayList<RouteAttributeEvalRule>();
        ParameterContext paramContext = null;

        public RouteAttributeContext() {
        }

        public RouteAttributeContext(RouteAttributeContext original, Map<String, String> params) {
            if (params != null) {
                this.paramContext = new ParameterContext();
                this.paramContext.vars = params;
            }
            for (RouteAttributeEvalRule rt : original.rules) {
                if (!this.checkParameter(rt)) continue;
                this.rules.add(rt);
            }
        }

        public RouteAttributeEvalRule[] getRules() {
            return this.rules.toArray(new RouteAttributeEvalRule[this.rules.size()]);
        }

        public String[] getParamKeys() {
            if (this.paramContext == null) {
                return new String[0];
            }
            return this.paramContext.vars.keySet().toArray(new String[this.paramContext.vars.size()]);
        }

        public String[] getParamValues() {
            if (this.paramContext == null) {
                return new String[0];
            }
            return this.paramContext.vars.values().toArray(new String[this.paramContext.vars.size()]);
        }

        private Object evaluate(RouteDataObject ro) {
            return this.evaluate(this.convert(ro.region, ro.types));
        }

        public void printRules(PrintStream out) {
            for (RouteAttributeEvalRule r : this.rules) {
                r.printRule(out);
            }
        }

        public RouteAttributeEvalRule registerNewRule(String selectValue, String selectType) {
            RouteAttributeEvalRule ev = new RouteAttributeEvalRule();
            ev.registerSelectValue(selectValue, selectType);
            this.rules.add(ev);
            return ev;
        }

        public RouteAttributeEvalRule getLastRule() {
            return this.rules.get(this.rules.size() - 1);
        }

        private Object evaluate(BitSet types) {
            for (int k = 0; k < this.rules.size(); ++k) {
                RouteAttributeEvalRule r = this.rules.get(k);
                Object o = r.eval(types, this.paramContext);
                if (o == null) continue;
                return o;
            }
            return null;
        }

        private boolean checkParameter(RouteAttributeEvalRule r) {
            if (this.paramContext != null && r.parameters.size() > 0) {
                for (String p : r.parameters) {
                    boolean not = false;
                    if (p.startsWith("-")) {
                        not = true;
                        p = p.substring(1);
                    }
                    boolean val = this.paramContext.vars.containsKey(p);
                    if (not && val) {
                        return false;
                    }
                    if (not || val) continue;
                    return false;
                }
            }
            return true;
        }

        public int evaluateInt(RouteDataObject ro, int defValue) {
            Object o = this.evaluate(ro);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).intValue();
        }

        public int evaluateInt(BinaryMapRouteReaderAdapter.RouteRegion region, int[] types, int defValue) {
            Object o = this.evaluate(this.convert(region, types));
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).intValue();
        }

        public float evaluateFloat(RouteDataObject ro, float defValue) {
            Object o = this.evaluate(ro);
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).floatValue();
        }

        public float evaluateFloat(BinaryMapRouteReaderAdapter.RouteRegion region, int[] types, float defValue) {
            Object o = this.evaluate(this.convert(region, types));
            if (!(o instanceof Number)) {
                return defValue;
            }
            return ((Number)o).floatValue();
        }

        private BitSet convert(BinaryMapRouteReaderAdapter.RouteRegion reg, int[] types) {
            BitSet b = new BitSet(GeneralRouter.this.universalRules.size());
            HashMap<Integer, Integer> map = (HashMap<Integer, Integer>)GeneralRouter.this.regionConvert.get(reg);
            if (map == null) {
                map = new HashMap<Integer, Integer>();
                GeneralRouter.this.regionConvert.put(reg, map);
            }
            for (int k = 0; k < types.length; ++k) {
                Integer nid = (Integer)map.get(types[k]);
                if (nid == null) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule r = reg.quickGetEncodingRule(types[k]);
                    nid = GeneralRouter.this.registerTagValueAttribute(r.getTag(), r.getValue());
                    map.put(types[k], nid);
                }
                b.set(nid);
            }
            return b;
        }
    }

    private class ParameterContext {
        private Map<String, String> vars;

        private ParameterContext() {
        }
    }

    public static class RoutingParameter {
        private String id;
        private String name;
        private String description;
        private RoutingParameterType type;
        private Object[] possibleValues;
        private String[] possibleValueDescriptions;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public RoutingParameterType getType() {
            return this.type;
        }

        public String[] getPossibleValueDescriptions() {
            return this.possibleValueDescriptions;
        }

        public Object[] getPossibleValues() {
            return this.possibleValues;
        }

        static /* synthetic */ Object[] access$402(RoutingParameter x0, Object[] x1) {
            x0.possibleValues = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(RoutingParameter x0, String[] x1) {
            x0.possibleValueDescriptions = x1;
            return x1;
        }
    }

    public static enum RoutingParameterType {
        NUMERIC,
        BOOLEAN,
        SYMBOLIC;

    }

    public static enum GeneralRouterProfile {
        CAR,
        PEDESTRIAN,
        BICYCLE;

    }

    public static enum RouteDataObjectAttribute {
        ROAD_SPEED("speed"),
        ROAD_PRIORITIES("priority"),
        ACCESS("access"),
        OBSTACLES("obstacle_time"),
        ROUTING_OBSTACLES("obstacle"),
        ONEWAY("oneway"),
        PENALTY_TRANSITION("penalty_transition");

        public final String nm;

        private RouteDataObjectAttribute(String name) {
            this.nm = name;
        }

        public static RouteDataObjectAttribute getValueOf(String s) {
            for (RouteDataObjectAttribute a : RouteDataObjectAttribute.values()) {
                if (!a.nm.equals(s)) continue;
                return a;
            }
            return null;
        }
    }
}

