/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.Ellipsoid;
import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.ProjMath;

public class UTMPoint {
    public double northing;
    public double easting;
    public int zone_number;
    public char zone_letter;

    public UTMPoint() {
    }

    public UTMPoint(LatLonPoint llpoint) {
        this(llpoint, Ellipsoid.WGS_84);
    }

    public UTMPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        this();
        UTMPoint.LLtoUTM(llpoint, ellip, this);
    }

    public UTMPoint(double northing, double easting, int zone_number, char zone_letter) {
        this.northing = northing;
        this.easting = easting;
        this.zone_number = zone_number;
        this.zone_letter = this.checkZone(zone_letter);
    }

    protected char checkZone(char zone) {
        if ((zone = Character.toUpperCase(zone)) != 'N' && zone != 'S') {
            throw new NumberFormatException("Invalid UTMPoint zone letter: " + zone);
        }
        return zone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UTMPoint) {
            UTMPoint pnt = (UTMPoint)obj;
            return this.northing == pnt.northing && this.easting == pnt.easting && this.zone_number == pnt.zone_number && this.zone_letter == pnt.zone_letter;
        }
        return false;
    }

    public LatLonPoint toLatLonPoint() {
        return UTMPoint.UTMtoLL(this, Ellipsoid.WGS_84, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip) {
        return UTMPoint.UTMtoLL(this, ellip, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(this, ellip, llpoint);
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint) {
        return UTMPoint.LLtoUTM(llpoint, Ellipsoid.WGS_84, new UTMPoint());
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint, UTMPoint utmpoint) {
        return UTMPoint.LLtoUTM(llpoint, Ellipsoid.WGS_84, utmpoint);
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint, Ellipsoid ellip, UTMPoint utmpoint) {
        int zoneNumber = UTMPoint.getZoneNumber(llpoint.getY(), llpoint.getX());
        boolean isnorthern = llpoint.getLatitude() >= 0.0f;
        return UTMPoint.LLtoUTM(llpoint, ellip, utmpoint, zoneNumber, isnorthern);
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint, Ellipsoid ellip, UTMPoint utmPoint, int zoneNumber, boolean isNorthern) {
        double a = ellip.radius;
        double k0 = 0.9996;
        double eccSquared = ellip.eccsq;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double eccSquared2 = eccSquared * eccSquared;
        double eccSquared3 = eccSquared2 * eccSquared;
        double LatRad = llpoint.getRadLat();
        double LongRad = llpoint.getRadLon();
        double LongOrigin = (zoneNumber - 1) * 6 - 180 + 3;
        double LongOriginRad = Math.toRadians(LongOrigin);
        double tanLatRad = Math.tan(LatRad);
        double sinLatRad = Math.sin(LatRad);
        double cosLatRad = Math.cos(LatRad);
        double N = a / Math.sqrt(1.0 - eccSquared * sinLatRad * sinLatRad);
        double T = tanLatRad * tanLatRad;
        double C = eccPrimeSquared * cosLatRad * cosLatRad;
        double A = cosLatRad * (LongRad - LongOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared2 / 64.0 - 5.0 * eccSquared3 / 256.0) * LatRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared2 / 32.0 + 45.0 * eccSquared3 / 1024.0) * Math.sin(2.0 * LatRad) + (15.0 * eccSquared2 / 256.0 + 45.0 * eccSquared3 / 1024.0) * Math.sin(4.0 * LatRad) - 35.0 * eccSquared3 / 3072.0 * Math.sin(6.0 * LatRad));
        double UTMEasting = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        double UTMNorthing = k0 * (M + N * Math.tan(LatRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
        if (!isNorthern) {
            UTMNorthing += 1.0E7;
        }
        if (utmPoint == null) {
            utmPoint = new UTMPoint();
        }
        utmPoint.northing = UTMNorthing;
        utmPoint.easting = UTMEasting;
        utmPoint.zone_number = zoneNumber;
        utmPoint.zone_letter = (char)(isNorthern ? 78 : 83);
        return utmPoint;
    }

    protected char getLetterDesignator(double lat) {
        char letterDesignator = 'N';
        if (lat < 0.0) {
            letterDesignator = 'S';
        }
        return letterDesignator;
    }

    public static LatLonPoint UTMtoLL(UTMPoint utm_point, Ellipsoid ellip, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(ellip, utm_point.northing, utm_point.easting, utm_point.zone_number, utm_point.zone_letter, llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, double UTMNorthing, double UTMEasting, String UTMZone, LatLonPoint llpoint) {
        if (UTMZone == null || UTMZone.length() == 0) {
            return null;
        }
        int ZoneNumber = 1;
        char ZoneLetter = 'N';
        int ln = UTMZone.length() - 1;
        if (ln > 0 && !Character.isLetter(ZoneLetter = (char)UTMZone.charAt(ln))) {
            ZoneLetter = 'N';
            ++ln;
        }
        try {
            ZoneNumber = Integer.parseInt(UTMZone.substring(0, ln));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return UTMPoint.UTMtoLL(ellip, UTMNorthing, UTMEasting, ZoneNumber, ZoneLetter, llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, double UTMNorthing, double UTMEasting, int ZoneNumber, boolean isNorthern, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(ellip, UTMNorthing, UTMEasting, ZoneNumber, isNorthern ? (char)'N' : 'S', llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, double UTMNorthing, double UTMEasting, int zoneNumber, char zoneLetter, LatLonPoint llpoint) {
        if (zoneNumber < 0 || zoneNumber > 60) {
            return null;
        }
        double k0 = 0.9996;
        double a = ellip.radius;
        double eccSquared = ellip.eccsq;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        double x = UTMEasting - 500000.0;
        double y = UTMNorthing;
        if (zoneLetter == 'S') {
            y -= 1.0E7;
        }
        double LongOrigin = (zoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        lat = ProjMath.radToDeg(lat);
        double lon = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        lon = LongOrigin + ProjMath.radToDeg(lon);
        if (llpoint != null) {
            llpoint.setLatLon(lat, lon);
            return llpoint;
        }
        return new LatLonPoint(lat, lon);
    }

    private static int getZoneNumber(double lat, double lon) {
        int zoneNumber = (int)((lon + 180.0) / 6.0) + 1;
        if (lon == 180.0) {
            zoneNumber = 60;
        }
        if (lat >= 56.0 && lat < 64.0 && lon >= 3.0 && lon < 12.0) {
            zoneNumber = 32;
        }
        if (lat >= 72.0 && lat < 84.0) {
            if (lon >= 0.0 && lon < 9.0) {
                zoneNumber = 31;
            } else if (lon >= 9.0 && lon < 21.0) {
                zoneNumber = 33;
            } else if (lon >= 21.0 && lon < 33.0) {
                zoneNumber = 35;
            } else if (lon >= 33.0 && lon < 42.0) {
                zoneNumber = 37;
            }
        }
        return zoneNumber;
    }

    public String toString() {
        return "Zone_number=" + this.zone_number + ", Hemisphere=" + this.zone_letter + ", Northing=" + this.northing + ", Easting=" + this.easting;
    }
}

