/*
 * Decompiled with CFR 0.152.
 */
package mediathek.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import mediathek.tool.Functions;
import mediathek.tool.OperatingSystemType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetFile {
    public static final String PFAD_HILFETEXT_GEO = "/mediathek/file/hilfetext_geo.txt";
    public static final String PFAD_HILFETEXT_BLACKLIST = "/mediathek/file/hilfetext_blacklist.txt";
    public static final String PFAD_HILFETEXT_BEENDEN = "/mediathek/file/hilfetext_beenden.txt";
    public static final String PFAD_HILFETEXT_PRGRAMME = "/mediathek/file/hilfetext_pset.txt";
    public static final String PFAD_HILFETEXT_STANDARD_PSET = "hilfetext_standardPset.txt";
    public static final String PFAD_HILFETEXT_EDIT_DOWNLOAD_PROG = "hilfetext_editDownloadProg.txt";
    public static final String PFAD_HILFETEXT_RESET = "hilfetext_reset.txt";
    public static final String PFAD_HILFETEXT_RESET_SET = "hilfetext_reset_set.txt";
    public static final String PFAD_HILFETEXT_DIALOG_ADD_ABO = "hilfetext_dialog_add_abo.txt";
    private static final String PFAD_PSET_LINUX = "/mediathek/file/pset_linux.xml";
    private static final String PFAD_PSET_WINDOWS = "/mediathek/file/pset_windows.xml";
    private static final String PFAD_PSET_MAC = "/mediathek/file/pset_mac.xml";
    private static final Logger logger = LogManager.getLogger();

    public String getHilfeSuchen(String pfad) {
        StringBuilder ret = new StringBuilder();
        try (InputStream is = Objects.requireNonNull(this.getClass().getResource(pfad)).openStream();
             InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(in);){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                ret.append('\n').append(strLine);
            }
        }
        catch (IOException ex) {
            logger.error("getHilfeSuchen()", (Throwable)ex);
        }
        return ret.toString();
    }

    public static InputStreamReader getLocalPsetTemplate() {
        String pfad = switch (Functions.getOs()) {
            case OperatingSystemType.LINUX -> PFAD_PSET_LINUX;
            case OperatingSystemType.MAC -> PFAD_PSET_MAC;
            default -> PFAD_PSET_WINDOWS;
        };
        try {
            return new InputStreamReader(Objects.requireNonNull(GetFile.class.getResource(pfad)).openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            logger.error("getLocalPsetTemplate()", (Throwable)ex);
            return null;
        }
    }
}

