/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Comparator;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DonutChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Canvas chartCanvas;
    private GraphicsContext chartCtx;
    private Canvas legendCanvas;
    private GraphicsContext legendCtx;
    private ListChangeListener<ChartData> chartDataListener;
    private ChartDataEventListener chartEventListener;
    private double centerX;
    private double centerY;
    private double innerRadius;
    private double outerRadius;
    private Tooltip selectionTooltip;
    private EventHandler<MouseEvent> clickHandler;
    private EventHandler<MouseEvent> moveHandler;

    public DonutChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartEventListener = e -> this.redraw();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.chartDataListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartDataEventListener(this.chartEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartDataEventListener(this.chartEventListener));
            }
            this.drawChart();
            this.drawLegend();
        };
        this.clickHandler = e -> {
            double x = e.getX();
            double y = e.getY();
            double startAngle = 90.0;
            double angle = 0.0;
            Object dataList = switch (this.tile.getItemSorting()) {
                case Tile.ItemSorting.ASCENDING -> this.tile.getChartData().stream().sorted(Comparator.comparingDouble(ChartData::getValue)).collect(Collectors.toList());
                case Tile.ItemSorting.DESCENDING -> this.tile.getChartData().stream().sorted(Comparator.comparingDouble(ChartData::getValue).reversed()).collect(Collectors.toList());
                default -> this.tile.getChartData();
            };
            int noOfItems = dataList.size();
            double sum = dataList.stream().mapToDouble(ChartData::getValue).sum();
            double stepSize = 360.0 / sum;
            double barWidth = this.chartCanvas.getWidth() * 0.1;
            double ri = this.outerRadius - barWidth * 0.5;
            double ro = this.outerRadius + barWidth * 0.5;
            for (int i = 0; i < noOfItems; ++i) {
                ChartData data = (ChartData)dataList.get(i);
                double value = data.getValue();
                boolean hit = Helper.isInRingSegment(x, y, this.centerX, this.centerY, ro, ri, startAngle -= angle, angle = value * stepSize);
                if (!hit) continue;
                String tooltipText = data.getName() + "\n" + String.format(this.locale, this.formatString, value);
                Point2D popupLocation = new Point2D(e.getScreenX() - this.selectionTooltip.getWidth() * 0.5, e.getScreenY() - this.size * 0.025 - this.selectionTooltip.getHeight());
                this.selectionTooltip.setText(tooltipText);
                this.selectionTooltip.setX(popupLocation.getX());
                this.selectionTooltip.setY(popupLocation.getY());
                this.selectionTooltip.show(this.tile.getScene().getWindow());
                this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, data));
                break;
            }
        };
        this.moveHandler = e -> this.selectionTooltip.hide();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.chartCanvas = new Canvas(this.size * 0.9, this.tile.isTextVisible() ? this.height - this.size * 0.28 : this.height - this.size * 0.205);
        this.chartCtx = this.chartCanvas.getGraphicsContext2D();
        this.legendCanvas = new Canvas(this.size * 0.225, this.tile.isTextVisible() ? this.height - this.size * 0.28 : this.height - this.size * 0.205);
        this.legendCtx = this.legendCanvas.getGraphicsContext2D();
        this.selectionTooltip = new Tooltip("");
        this.selectionTooltip.setWidth(60.0);
        this.selectionTooltip.setHeight(48.0);
        Tooltip.install((Node)this.chartCanvas, (Tooltip)this.selectionTooltip);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.legendCanvas, this.text, this.chartCanvas});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
        this.chartCanvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        this.chartCanvas.addEventHandler(MouseEvent.MOUSE_MOVED, this.moveHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            double chartCanvasWidth = this.width - this.size * 0.1;
            double chartCanvasHeight = this.tile.isTextVisible() ? this.height - this.size * 0.28 : this.height - this.size * 0.205;
            double chartCanvasSize = chartCanvasWidth < chartCanvasHeight ? chartCanvasWidth : chartCanvasHeight;
            double legendCanvasWidth = this.width * 0.225;
            double legendCanvasHeight = chartCanvasSize;
            this.chartCanvas.setWidth(chartCanvasSize);
            this.chartCanvas.setHeight(chartCanvasSize);
            this.legendCanvas.setWidth(legendCanvasWidth);
            this.legendCanvas.setHeight(legendCanvasHeight);
        } else if (TileEvent.EventType.DATA.name().equals(EVENT_TYPE)) {
            this.drawChart();
        } else if (TileEvent.EventType.RECALC.name().equals(EVENT_TYPE)) {
            this.drawChart();
        }
    }

    @Override
    public void dispose() {
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        this.chartCanvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        this.chartCanvas.removeEventHandler(MouseEvent.MOUSE_MOVED, this.moveHandler);
        super.dispose();
    }

    private void drawChart() {
        Object dataList = switch (this.tile.getItemSorting()) {
            case Tile.ItemSorting.ASCENDING -> this.tile.getChartData().stream().sorted(Comparator.comparingDouble(ChartData::getValue)).collect(Collectors.toList());
            case Tile.ItemSorting.DESCENDING -> this.tile.getChartData().stream().sorted(Comparator.comparingDouble(ChartData::getValue).reversed()).collect(Collectors.toList());
            default -> this.tile.getChartData();
        };
        double canvasSize = this.chartCanvas.getWidth();
        int noOfItems = dataList.size();
        double center = canvasSize * 0.5;
        double barWidth = canvasSize * 0.09;
        double sum = dataList.stream().mapToDouble(ChartData::getValue).sum();
        double stepSize = 360.0 / sum;
        double angle = 0.0;
        double startAngle = 90.0;
        double xy = canvasSize * 0.15;
        double wh = canvasSize * 0.7;
        Color textColor = this.tile.getTextColor();
        this.centerX = xy + wh * 0.5;
        this.centerY = xy + wh * 0.5;
        this.innerRadius = canvasSize * 0.225;
        this.outerRadius = canvasSize * 0.45;
        this.chartCtx.clearRect(0.0, 0.0, canvasSize, canvasSize);
        this.chartCtx.setLineCap(StrokeLineCap.BUTT);
        this.chartCtx.setFill((Paint)textColor);
        this.chartCtx.setTextBaseline(VPos.CENTER);
        this.chartCtx.setTextAlign(TextAlignment.CENTER);
        if (this.tile.isValueVisible()) {
            this.chartCtx.setFont(Fonts.latoRegular(canvasSize * 0.15));
            this.chartCtx.fillText(String.format(Locale.US, "%.0f", sum), center, center, canvasSize * 0.4);
        }
        this.chartCtx.setFont(Fonts.latoRegular(barWidth * 0.5));
        for (int i = 0; i < noOfItems; ++i) {
            ChartData data = (ChartData)dataList.get(i);
            double value = data.getValue();
            angle = value * stepSize;
            this.chartCtx.setLineWidth(barWidth);
            this.chartCtx.setStroke((Paint)data.getFillColor());
            this.chartCtx.strokeArc(xy, xy, wh, wh, startAngle -= angle, -angle, ArcType.OPEN);
            double radValue = Math.toRadians(startAngle - angle * 0.5);
            double cosValue = Math.cos(radValue);
            double sinValue = Math.sin(radValue);
            double x = this.innerRadius * cosValue;
            double y = -this.innerRadius * sinValue;
            if (this.tile.isPercentageVisible()) {
                this.chartCtx.setFill((Paint)textColor);
                this.chartCtx.fillText(String.format(Locale.US, "%.0f%%", value / sum * 100.0), center + x, center + y, barWidth);
            }
            if (!(angle > 10.0)) continue;
            x = this.outerRadius * cosValue;
            y = -this.outerRadius * sinValue;
            this.chartCtx.setFill((Paint)data.getTextColor());
            if (this.tile.getShortenNumbers()) {
                this.chartCtx.fillText(Helper.shortenNumber((long)value), center + x, center + y, barWidth);
                continue;
            }
            this.chartCtx.fillText(String.format(Locale.US, "%.0f", value), center + x, center + y, barWidth);
        }
    }

    private void drawLegend() {
        ObservableList<ChartData> dataList = this.tile.getChartData();
        double canvasWidth = this.legendCanvas.getWidth();
        double canvasHeight = this.legendCanvas.getHeight();
        int noOfItems = dataList.size();
        Color textColor = this.tile.getTextColor();
        double stepSize = canvasHeight * 0.9 / (double)(noOfItems + 1);
        this.legendCtx.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
        this.legendCtx.setTextAlign(TextAlignment.LEFT);
        this.legendCtx.setTextBaseline(VPos.CENTER);
        this.legendCtx.setFont(Fonts.latoRegular(canvasHeight * 0.05));
        for (int i = 0; i < noOfItems; ++i) {
            ChartData data = (ChartData)dataList.get(i);
            this.legendCtx.setFill((Paint)data.getFillColor());
            this.legendCtx.fillOval(0.0, (double)(i + 1) * stepSize, this.size * 0.0375, this.size * 0.0375);
            this.legendCtx.setFill((Paint)textColor);
            this.legendCtx.fillText(data.getName(), this.size * 0.05, (double)(i + 1) * stepSize + canvasHeight * 0.025);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double chartCanvasWidth = this.contentBounds.getWidth();
        double chartCanvasHeight = this.contentBounds.getHeight();
        double chartCanvasSize = chartCanvasWidth < chartCanvasHeight ? chartCanvasWidth : chartCanvasHeight;
        double legendCanvasWidth = this.width * 0.225;
        double legendCanvasHeight = chartCanvasSize;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.legendCanvas.setWidth(legendCanvasWidth);
            this.legendCanvas.setHeight(legendCanvasHeight);
            this.legendCanvas.relocate(this.contentBounds.getX(), this.contentBounds.getY());
            this.legendCanvas.setVisible(this.width > this.height * 1.2);
            this.chartCanvas.setWidth(chartCanvasSize);
            this.chartCanvas.setHeight(chartCanvasSize);
            if (this.width > this.height * 1.5) {
                this.chartCanvas.relocate((this.width - chartCanvasSize) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartCanvasSize) * 0.5);
            } else if (this.width > this.height * 1.2) {
                this.chartCanvas.relocate(this.width - this.size * 0.05 - chartCanvasSize, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartCanvasSize) * 0.5);
            } else {
                this.chartCanvas.relocate((this.width - chartCanvasSize) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartCanvasSize) * 0.5);
            }
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.drawLegend();
        this.drawChart();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

