/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi.internal;

import java.net.URL;
import java.util.StringTokenizer;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.osgi.internal.OSGiBundleLibrary;
import org.jruby.embed.osgi.utils.OSGiFileLocator;
import org.jruby.platform.Platform;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LibrarySearcher;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadServiceResource;
import org.osgi.framework.Bundle;

public class OSGiLoadService
extends LoadService {
    public static final String OSGI_BUNDLE_CLASSPATH_SCHEME = "osgibundle:/";
    public static final RubyInstanceConfig.LoadServiceCreator OSGI_DEFAULT = runtime2 -> new OSGiLoadService(runtime2);

    public OSGiLoadService(Ruby runtime2) {
        super(runtime2);
    }

    protected LibrarySearcher.FoundLibrary searchForRequire(String searchFile) {
        String[] fileHolder = new String[]{searchFile};
        LoadService.SuffixType suffixType = LibrarySearcher.getSuffixTypeForRequire(fileHolder);
        String baseName = fileHolder[0];
        LibrarySearcher.FoundLibrary[] library2 = new LibrarySearcher.FoundLibrary[]{null};
        char found = this.librarySearcher.findLibraryForRequire(baseName, library2);
        if (found != '\u0000') {
            return library2[0];
        }
        return this.findLibraryWithClassloaders(searchFile, suffixType);
    }

    @Override
    protected LibrarySearcher.FoundLibrary searchForLoad(String searchFile) {
        String[] fileHolder = new String[]{searchFile};
        LoadService.SuffixType suffixType = LibrarySearcher.getSuffixTypeForLoad(fileHolder);
        String baseName = fileHolder[0];
        LibrarySearcher.FoundLibrary[] library2 = new LibrarySearcher.FoundLibrary[]{null};
        char found = this.librarySearcher.findLibraryForRequire(baseName, library2);
        if (found != '\u0000') {
            return library2[0];
        }
        return this.findLibraryWithClassloaders(searchFile, suffixType);
    }

    @Override
    protected LoadServiceResource findFileInClasspath(String name2) {
        if (name2.startsWith(OSGI_BUNDLE_CLASSPATH_SCHEME)) {
            URL url;
            name2 = this.cleanupFindName(name2);
            StringTokenizer tokenizer = new StringTokenizer(name2, "/", false);
            tokenizer.nextToken();
            String symname = tokenizer.nextToken();
            StringBuilder sb = new StringBuilder();
            if (!tokenizer.hasMoreTokens()) {
                sb.append('/');
            } else {
                while (tokenizer.hasMoreTokens()) {
                    sb.append('/');
                    sb.append(tokenizer.nextToken());
                }
            }
            Bundle bundle = OSGiFileLocator.getBundle(symname);
            if (bundle != null && (url = bundle.getEntry(sb.toString())) != null) {
                return new LoadServiceResource(OSGiFileLocator.getLocalURL(url), name2);
            }
        }
        return super.findFileInClasspath(name2);
    }

    @Override
    protected LibrarySearcher.FoundLibrary createLibrary(String baseName, String loadName, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = loadName;
        if (file2.startsWith(OSGI_BUNDLE_CLASSPATH_SCHEME)) {
            file2 = this.cleanupFindName(file2);
            StringTokenizer tokenizer = new StringTokenizer(file2, "/", false);
            tokenizer.nextToken();
            String symname = tokenizer.nextToken();
            Bundle bundle = OSGiFileLocator.getBundle(symname);
            if (bundle != null) {
                return new LibrarySearcher.FoundLibrary(baseName, loadName, new OSGiBundleLibrary(bundle));
            }
        }
        return new LibrarySearcher.FoundLibrary(baseName, loadName, super.createLibrary(baseName, loadName, resource2));
    }

    private String cleanupFindName(String name2) {
        if (name2.endsWith(".jar")) {
            return name2.substring(0, name2.length() - ".jar".length());
        }
        if (name2.endsWith(".class")) {
            return name2.substring(0, name2.length() - ".class".length());
        }
        return name2;
    }

    @Override
    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        String path2 = foundResource.getAbsolutePath();
        if (Platform.IS_WINDOWS) {
            path2 = path2.replace('\\', '/');
        }
        return path2;
    }

    @Override
    @Deprecated
    protected Library findLibraryBySearchState(LoadService.SearchState state2) {
        Library library2 = super.findLibraryBySearchState(state2);
        if (library2 == null && (library2 = this.findLibraryWithClassloaders(state2, state2.searchFile, state2.suffixType)) != null) {
            state2.library = library2;
        }
        return library2;
    }

    @Override
    @Deprecated
    protected Library createLibrary(LoadService.SearchState state2, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = state2.loadName;
        if (file2.startsWith(OSGI_BUNDLE_CLASSPATH_SCHEME)) {
            file2 = this.cleanupFindName(file2);
            StringTokenizer tokenizer = new StringTokenizer(file2, "/", false);
            tokenizer.nextToken();
            String symname = tokenizer.nextToken();
            Bundle bundle = OSGiFileLocator.getBundle(symname);
            if (bundle != null) {
                return new OSGiBundleLibrary(bundle);
            }
        }
        return super.createLibrary(state2, resource2);
    }
}

