/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.tools.Utils;

public class TextAnalyzer {
    private boolean quotesStarted;
    private boolean esc;
    private final StringBuilder s = new StringBuilder(200);
    private String valueStops = "\n\r\t";
    private int pos = 0;
    private final String data;
    private final int n;

    public TextAnalyzer(String text) {
        this.data = Utils.strip(text);
        this.n = this.data.length();
        if (this.data.indexOf(13) == -1 && this.data.indexOf(10) == -1) {
            this.valueStops = this.valueStops + " ";
        }
    }

    public Map<String, String> getFreeParsedTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        while (true) {
            this.skipEmpty();
            if (this.pos == this.n) break;
            String k = this.parseString("\n\r\t= ");
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            this.skipSign();
            if (this.pos == this.n) {
                tags.clear();
                break;
            }
            String v = this.parseString(this.valueStops);
            tags.put(k, v);
        }
        return tags;
    }

    public String parseString(String stopChars) {
        char[] stop = stopChars.toCharArray();
        Arrays.sort(stop);
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (this.esc) {
                this.esc = false;
                this.s.append(c);
            } else if (c == '\\') {
                this.esc = true;
            } else if (c == '\"' && !this.quotesStarted) {
                if (!this.s.toString().trim().isEmpty()) {
                    this.s.append(c);
                } else {
                    this.s.delete(0, this.s.length());
                    this.quotesStarted = true;
                }
            } else {
                if (c == '\"' && this.quotesStarted) {
                    this.quotesStarted = false;
                    ++this.pos;
                    break;
                }
                if (!this.quotesStarted && Arrays.binarySearch(stop, c) >= 0) {
                    ++this.pos;
                    break;
                }
                if (c >= ' ') {
                    this.s.append(c);
                }
            }
            ++this.pos;
        }
        String res = this.s.toString();
        this.s.delete(0, this.s.length());
        return res.trim();
    }

    private void skipSign() {
        boolean signFound = false;
        while (this.pos < this.n) {
            char c = this.data.charAt(this.pos);
            if (c == '\t' || c == '\n' || c == ' ') {
                ++this.pos;
                continue;
            }
            if (c != '=' || signFound) break;
            signFound = true;
            ++this.pos;
        }
    }

    private void skipEmpty() {
        char c;
        while (this.pos < this.n && ((c = this.data.charAt(this.pos)) == '\t' || c == '\n' || c == '\r' || c == ' ')) {
            ++this.pos;
        }
    }
}

