/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Optional;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.tools.I18n;

public class XmlStreamParsingException
extends XMLStreamException {
    public XmlStreamParsingException(String msg, Location location) {
        super(msg);
        this.location = location;
    }

    public XmlStreamParsingException(String msg, Location location, Throwable th) {
        super(msg, th);
        this.location = location;
    }

    @Override
    public String getMessage() {
        String msg = Optional.ofNullable(super.getMessage()).orElseGet(() -> this.getClass().getName());
        if (this.getLocation() == null) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg).append(' ').append(I18n.tr("(at line {0}, column {1})", this.getLocation().getLineNumber(), this.getLocation().getColumnNumber()));
        int offset = this.getLocation().getCharacterOffset();
        if (offset > -1) {
            sb.append(". ").append(I18n.tr("{0} bytes have been read", offset));
        }
        return sb.toString();
    }
}

