/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util.imagery;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.openstreetmap.josm.gui.util.imagery.UVMapping;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;

public class CameraPlane {
    static final double PANORAMA_FOV = Math.toRadians(110.0);
    private static final byte YAW_DIRECTION = -1;
    private final int width;
    private final int height;
    private final Vector3D[][] vectors;
    private Vector3D rotation;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;

    public CameraPlane(int width, int height) {
        this(width, height, (double)width / 2.0 / Math.tan(PANORAMA_FOV / 2.0));
    }

    private CameraPlane(int width, int height, double distance) {
        this.width = width;
        this.height = height;
        this.rotation = new Vector3D(Vector3D.VectorType.RPA, distance, 0.0, 0.0);
        this.vectors = new Vector3D[width][height];
        IntStream.range(0, this.height).parallel().forEach(y -> IntStream.range(0, this.width).parallel().forEach(x -> {
            this.vectors[x][y] = this.getVector3D((double)x, (double)y);
        }));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Nullable
    public Point getPoint(Vector3D vector) {
        Vector3D rotatedVector = this.rotate(vector);
        if (rotatedVector.getZ() < 0.0) {
            return null;
        }
        long x = Math.round(rotatedVector.getX() / rotatedVector.getZ() * this.rotation.getRadialDistance() + (double)this.width / 2.0);
        long y = Math.round(rotatedVector.getY() / rotatedVector.getZ() * this.rotation.getRadialDistance() + (double)this.height / 2.0);
        try {
            return new Point(Math.toIntExact(x), Math.toIntExact(y));
        }
        catch (ArithmeticException e) {
            return new Point((int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, x)), (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, y)));
        }
    }

    public Vector3D getVector3D(Point p) {
        return this.getVector3D(p.x, p.y);
    }

    public Vector3D getVector3D(int x, int y) {
        Vector3D res;
        try {
            res = this.rotate(this.vectors[x][y]);
        }
        catch (Exception e) {
            res = Vector3D.DEFAULT_VECTOR_3D;
        }
        return res;
    }

    public Vector3D getVector3D(double x, double y) {
        return new Vector3D(x - (double)this.width / 2.0, y - (double)this.height / 2.0, this.rotation.getRadialDistance()).normalize();
    }

    public void setRotation(Point p) {
        this.setRotation(this.getVector3D(p));
    }

    public void setRotationFromDelta(Point from, Point to) {
        if (from.x < 0 || from.y < 0 || to.x < 0 || to.y < 0 || from.x > this.vectors.length - 1 || from.y > this.vectors[from.x].length - 1 || to.x > this.vectors.length - 1 || to.y > this.vectors[to.x].length - 1) {
            return;
        }
        Vector3D f1 = this.vectors[from.x][from.y];
        Vector3D t1 = this.vectors[to.x][to.y];
        double deltaPolarAngle = f1.getPolarAngle() - t1.getPolarAngle();
        double deltaAzimuthalAngle = t1.getAzimuthalAngle() - f1.getAzimuthalAngle();
        double polarAngle = this.rotation.getPolarAngle() + deltaPolarAngle;
        double azimuthalAngle = this.rotation.getAzimuthalAngle() + deltaAzimuthalAngle;
        this.setRotation(azimuthalAngle, polarAngle);
    }

    public void setRotation(Vector3D vec) {
        this.setRotation(vec.getPolarAngle(), vec.getAzimuthalAngle());
    }

    public synchronized Vector3D getRotation() {
        return this.rotation;
    }

    synchronized void setRotation(double azimuthalAngle, double polarAngle) {
        if (polarAngle < 0.0) {
            polarAngle += Math.PI * 2;
        } else if (polarAngle > Math.PI * 2) {
            polarAngle -= Math.PI * 2;
        }
        if (azimuthalAngle > 1.5707963267948966) {
            azimuthalAngle = 1.5707963267948966;
        } else if (azimuthalAngle < -1.5707963267948966) {
            azimuthalAngle = -1.5707963267948966;
        }
        this.rotation = new Vector3D(Vector3D.VectorType.RPA, this.rotation.getRadialDistance(), polarAngle, azimuthalAngle);
    }

    private Vector3D rotate(Vector3D vec) {
        boolean gamma = false;
        double sinAlpha = Math.sin(0.0);
        double cosAlpha = Math.cos(0.0);
        double cosGamma = this.rotation.getAzimuthalAngleCos();
        double sinGamma = this.rotation.getAzimuthalAngleSin();
        double cosBeta = this.rotation.getPolarAngleCos();
        double sinBeta = this.rotation.getPolarAngleSin();
        double x = vec.getX();
        double y = -1.0 * vec.getY();
        double z = vec.getZ();
        double vecX = y * (cosAlpha * sinBeta * sinGamma - sinAlpha * cosGamma) + z * (cosAlpha * sinBeta * cosGamma + sinAlpha * sinGamma) + x * cosAlpha * cosBeta;
        double vecY = y * (sinAlpha * sinBeta * sinGamma + cosAlpha * cosGamma) + z * (sinAlpha * sinBeta * cosGamma - cosAlpha * sinGamma) + x * sinAlpha * cosBeta;
        double vecZ = y * cosBeta * sinGamma + z * cosBeta * cosGamma - x * sinBeta;
        return new Vector3D(vecX, -1.0 * vecY, vecZ);
    }

    public void mapping(BufferedImage sourceImage, BufferedImage targetImage, Rectangle visibleRect) {
        DataBuffer sourceBuffer = sourceImage.getRaster().getDataBuffer();
        DataBuffer targetBuffer = targetImage.getRaster().getDataBuffer();
        if (sourceBuffer.getDataType() == 0 && targetBuffer.getDataType() == 0) {
            boolean targetHasAlphaChannel;
            byte[] sourceImageBuffer = ((DataBufferByte)sourceImage.getRaster().getDataBuffer()).getData();
            byte[] targetImageBuffer = ((DataBufferByte)targetImage.getRaster().getDataBuffer()).getData();
            boolean sourceHasAlphaChannel = sourceImage.getAlphaRaster() != null;
            boolean bl = targetHasAlphaChannel = targetImage.getAlphaRaster() != null;
            if (sourceHasAlphaChannel && targetHasAlphaChannel) {
                int pixelLength = 4;
                IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                    Point2D.Double p = this.mapPoint(x, y);
                    int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                    int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                    int sourceOffset = (ty * sourceImage.getWidth() + tx) * 4;
                    int targetOffset = (y * targetImage.getWidth() + x) * 4;
                    byte a = sourceImageBuffer[sourceOffset];
                    byte b = sourceImageBuffer[sourceOffset + 1];
                    byte g = sourceImageBuffer[sourceOffset + 2];
                    byte r = sourceImageBuffer[sourceOffset + 3];
                    targetImageBuffer[targetOffset] = a;
                    targetImageBuffer[targetOffset + 1] = b;
                    targetImageBuffer[targetOffset + 2] = g;
                    targetImageBuffer[targetOffset + 3] = r;
                }));
            } else if (sourceHasAlphaChannel) {
                int sourcePixelLength = 4;
                int targetPixelLength = 3;
                IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                    Point2D.Double p = this.mapPoint(x, y);
                    int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                    int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                    int sourceOffset = (ty * sourceImage.getWidth() + tx) * 4;
                    int targetOffset = (y * targetImage.getWidth() + x) * 3;
                    byte b = sourceImageBuffer[sourceOffset + 1];
                    byte g = sourceImageBuffer[sourceOffset + 2];
                    byte r = sourceImageBuffer[sourceOffset + 3];
                    targetImageBuffer[targetOffset] = b;
                    targetImageBuffer[targetOffset + 1] = g;
                    targetImageBuffer[targetOffset + 2] = r;
                }));
            } else if (targetHasAlphaChannel) {
                int sourcePixelLength = 3;
                int targetPixelLength = 4;
                IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                    Point2D.Double p = this.mapPoint(x, y);
                    int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                    int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                    int sourceOffset = (ty * sourceImage.getWidth() + tx) * 3;
                    int targetOffset = (y * targetImage.getWidth() + x) * 4;
                    int a = -1;
                    byte b = sourceImageBuffer[sourceOffset];
                    byte g = sourceImageBuffer[sourceOffset + 1];
                    byte r = sourceImageBuffer[sourceOffset + 2];
                    targetImageBuffer[targetOffset] = a;
                    targetImageBuffer[targetOffset + 1] = b;
                    targetImageBuffer[targetOffset + 2] = g;
                    targetImageBuffer[targetOffset + 3] = r;
                }));
            } else {
                int pixelLength = 3;
                IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                    Point2D.Double p = this.mapPoint(x, y);
                    int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                    int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                    int sourceOffset = (ty * sourceImage.getWidth() + tx) * 3;
                    int targetOffset = (y * targetImage.getWidth() + x) * 3;
                    byte b = sourceImageBuffer[sourceOffset];
                    byte g = sourceImageBuffer[sourceOffset + 1];
                    byte r = sourceImageBuffer[sourceOffset + 2];
                    targetImageBuffer[targetOffset] = b;
                    targetImageBuffer[targetOffset + 1] = g;
                    targetImageBuffer[targetOffset + 2] = r;
                }));
            }
        } else if (sourceBuffer.getDataType() == 3 && targetBuffer.getDataType() == 3) {
            int[] sourceImageBuffer = ((DataBufferInt)sourceImage.getRaster().getDataBuffer()).getData();
            int[] targetImageBuffer = ((DataBufferInt)targetImage.getRaster().getDataBuffer()).getData();
            IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                int color;
                Point2D.Double p = this.mapPoint(x, y);
                int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                targetImageBuffer[y * targetImage.getWidth() + x] = color = sourceImageBuffer[ty * sourceImage.getWidth() + tx];
            }));
        } else if (sourceBuffer.getDataType() == 5 && targetBuffer.getDataType() == 5) {
            double[] sourceImageBuffer = ((DataBufferDouble)sourceImage.getRaster().getDataBuffer()).getData();
            double[] targetImageBuffer = ((DataBufferDouble)targetImage.getRaster().getDataBuffer()).getData();
            IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).forEach(x -> {
                double color;
                Point2D.Double p = this.mapPoint(x, y);
                int tx = (int)(p.x * (double)(sourceImage.getWidth() - 1));
                int ty = (int)(p.y * (double)(sourceImage.getHeight() - 1));
                targetImageBuffer[y * targetImage.getWidth() + x] = color = sourceImageBuffer[ty * sourceImage.getWidth() + tx];
            }));
        } else {
            IntStream.range(visibleRect.y, visibleRect.y + visibleRect.height).parallel().forEach(y -> IntStream.range(visibleRect.x, visibleRect.x + visibleRect.width).parallel().forEach(x -> {
                Point2D.Double p = this.mapPoint(x, y);
                targetImage.setRGB(x, y, sourceImage.getRGB((int)(p.x * (double)(sourceImage.getWidth() - 1)), (int)(p.y * (double)(sourceImage.getHeight() - 1))));
            }));
        }
    }

    public final Point2D.Double mapPoint(int x, int y) {
        Vector3D vec = this.getVector3D(x, y);
        return UVMapping.getTextureCoordinate(vec);
    }

    public final Point2D.Double mapPoint(double x, double y) {
        Vector3D vec = this.getVector3D(x, y);
        return UVMapping.getTextureCoordinate(vec);
    }
}

