/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.tools.Logging;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private WeakReference<JComponent> lastComponent;

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        super.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread()) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.") && !st.getClassName().startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if ("repaint".equals(st.getMethodName())) {
                    repaint = true;
                    fromSwing = false;
                }
                if (!"read".equals(st.getMethodName()) || !"javax.swing.JEditorPane".equals(st.getClassName())) continue;
                return;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            CheckThreadViolationRepaintManager.violationFound(c, stackTrace);
        }
    }

    protected static void violationFound(JComponent c, StackTraceElement[] stackTrace) {
        Logging.error("");
        Logging.error("EDT violation detected");
        Logging.error(c.toString());
        for (StackTraceElement st : stackTrace) {
            Logging.error("\tat " + st);
        }
    }
}

