/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.LayerDetails;
import org.openstreetmap.josm.io.imagery.WMSImagery;

public class WMSLayerTree {
    private final MutableTreeNode treeRootNode = new DefaultMutableTreeNode();
    private final DefaultTreeModel treeData = new DefaultTreeModel(this.treeRootNode);
    private final JTree layerTree = new JTree(this.treeData);
    private final List<LayerDetails> selectedLayers = new LinkedList<LayerDetails>();
    private LatLon checkBounds;

    public MutableTreeNode getTreeRootNode() {
        return this.treeRootNode;
    }

    public JTree getLayerTree() {
        return this.layerTree;
    }

    public List<LayerDetails> getSelectedLayers() {
        return this.selectedLayers;
    }

    public WMSLayerTree() {
        this.layerTree.setCellRenderer(new LayerTreeCellRenderer());
        this.layerTree.addTreeSelectionListener(new WMSTreeSelectionListener());
    }

    public void setCheckBounds(LatLon checkBounds) {
        this.checkBounds = checkBounds;
    }

    void addLayersToTreeData(MutableTreeNode parent, Collection<LayerDetails> layers) {
        for (LayerDetails layerDetails : (LayerDetails[])layers.stream().filter(l -> this.checkBounds == null || l.getBounds() == null || l.getBounds().contains(this.checkBounds)).sorted(Comparator.comparing(LayerDetails::toString).reversed()).toArray(LayerDetails[]::new)) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(layerDetails);
            this.addLayersToTreeData(treeNode, layerDetails.getChildren());
            this.treeData.insertNodeInto(treeNode, parent, 0);
        }
    }

    public void updateTree(WMSImagery wms) {
        while (this.treeRootNode.getChildCount() > 0) {
            this.treeRootNode.remove(0);
        }
        this.treeRootNode.setUserObject(wms.buildRootUrl());
        this.updateTreeList(wms.getLayers());
    }

    public void updateTreeList(Collection<LayerDetails> layers) {
        this.addLayersToTreeData(this.getTreeRootNode(), layers);
        this.treeData.nodeStructureChanged(this.getTreeRootNode());
        this.getLayerTree().expandRow(0);
        this.getLayerTree().expandRow(1);
    }

    private class WMSTreeSelectionListener
    implements TreeSelectionListener {
        private WMSTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] selectionRows = WMSLayerTree.this.layerTree.getSelectionPaths();
            if (selectionRows == null) {
                return;
            }
            WMSLayerTree.this.selectedLayers.clear();
            for (TreePath i : selectionRows) {
                LayerDetails detail;
                Object userObject = ((DefaultMutableTreeNode)i.getLastPathComponent()).getUserObject();
                if (!(userObject instanceof LayerDetails) || !(detail = (LayerDetails)userObject).isSelectable()) continue;
                WMSLayerTree.this.selectedLayers.add(detail);
            }
            WMSLayerTree.this.layerTree.firePropertyChange("selectedLayers", false, true);
        }
    }

    private static class LayerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LayerTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof LayerDetails) {
                LayerDetails ld = (LayerDetails)userObject;
                this.setEnabled(ld.isSelectable());
            }
            return this;
        }
    }
}

