/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.I18n;

public class OsmPrivilegesPanel
extends VerticallyScrollablePanel {
    private final JCheckBox cbWriteApi = new JCheckBox();
    private final JCheckBox cbWriteGpx = new JCheckBox();
    private final JCheckBox cbReadGpx = new JCheckBox();
    private final JCheckBox cbWritePrefs = new JCheckBox();
    private final JCheckBox cbReadPrefs = new JCheckBox();
    private final JCheckBox cbModifyNotes = new JCheckBox();

    public OsmPrivilegesPanel() {
        this.build();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)this.cbWriteApi, gc);
        this.cbWriteApi.setText(I18n.tr("Allow to upload map data", new Object[0]));
        this.cbWriteApi.setToolTipText(I18n.tr("Select to grant JOSM the right to upload map data on your behalf", new Object[0]));
        this.cbWriteApi.setSelected(true);
        gc.gridy = 1;
        this.add((Component)this.cbWriteGpx, gc);
        this.cbWriteGpx.setText(I18n.tr("Allow to upload GPS traces", new Object[0]));
        this.cbWriteGpx.setToolTipText(I18n.tr("Select to grant JOSM the right to upload GPS traces on your behalf", new Object[0]));
        this.cbWriteGpx.setSelected(true);
        gc.gridy = 2;
        this.add((Component)this.cbReadGpx, gc);
        this.cbReadGpx.setText(I18n.tr("Allow to download your private GPS traces", new Object[0]));
        this.cbReadGpx.setToolTipText(I18n.tr("Select to grant JOSM the right to download your private GPS traces into JOSM layers", new Object[0]));
        this.cbReadGpx.setSelected(true);
        gc.gridy = 3;
        this.add((Component)this.cbReadPrefs, gc);
        this.cbReadPrefs.setText(I18n.tr("Allow to read your preferences", new Object[0]));
        this.cbReadPrefs.setToolTipText(I18n.tr("Select to grant JOSM the right to read your server preferences", new Object[0]));
        this.cbReadPrefs.setSelected(true);
        gc.gridy = 4;
        this.add((Component)this.cbWritePrefs, gc);
        this.cbWritePrefs.setText(I18n.tr("Allow to write your preferences", new Object[0]));
        this.cbWritePrefs.setToolTipText(I18n.tr("Select to grant JOSM the right to write your server preferences", new Object[0]));
        this.cbWritePrefs.setSelected(true);
        gc.gridy = 5;
        this.add((Component)this.cbModifyNotes, gc);
        this.cbModifyNotes.setText(I18n.tr("Allow modifications of notes", new Object[0]));
        this.cbModifyNotes.setToolTipText(I18n.tr("Select to grant JOSM the right to modify notes on your behalf", new Object[0]));
        this.cbModifyNotes.setSelected(true);
        gc.gridy = 6;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)new JPanel(), gc);
    }

    public OsmPrivileges getPrivileges() {
        OsmPrivileges privileges = new OsmPrivileges();
        privileges.setAllowWriteApi(this.cbWriteApi.isSelected());
        privileges.setAllowWriteGpx(this.cbWriteGpx.isSelected());
        privileges.setAllowReadGpx(this.cbReadGpx.isSelected());
        privileges.setAllowWritePrefs(this.cbWritePrefs.isSelected());
        privileges.setAllowReadPrefs(this.cbReadPrefs.isSelected());
        privileges.setAllowModifyNotes(this.cbModifyNotes.isSelected());
        return privileges;
    }
}

