/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class AreaElement
extends StyleElement {
    private static final IntegerProperty DEFAULT_FILL_ALPHA = new IntegerProperty("mappaint.fillalpha", 50);
    public Color color;
    public MapImage fillImage;
    public Float extent;
    public Float extentThreshold;

    protected AreaElement(Cascade c, Color color, MapImage fillImage, Float extent, Float extentThreshold) {
        super(c, 1.0f);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.color = color;
        this.fillImage = fillImage;
        this.extent = extent;
        this.extentThreshold = extentThreshold;
    }

    public static AreaElement create(Environment env) {
        Color color;
        Cascade c = env.getCascade();
        MapImage fillImage = null;
        MapPaintStyles.IconReference iconRef = c.get("fill-image", null, MapPaintStyles.IconReference.class);
        if (iconRef != null) {
            fillImage = new MapImage(iconRef.iconName, iconRef.source, false);
            Image img = fillImage.getImage(false);
            img = HiDPISupport.getBaseImage(img);
            try {
                color = new Color(((BufferedImage)img).getRGB(img.getWidth(null) / 2, img.getHeight(null) / 2));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw BugReport.intercept(e).put("env.osm", env.osm).put("iconRef", iconRef).put("fillImage", fillImage).put("img", img);
            }
            fillImage.alpha = Utils.clamp(Config.getPref().getInt("mappaint.fill-image-alpha", 255), 0, 255);
            Integer pAlpha = ColorHelper.float2int(c.get("fill-opacity", null, Float.TYPE));
            if (pAlpha != null) {
                fillImage.alpha = pAlpha;
            }
        } else {
            color = c.get("fill-color", null, Color.class);
            if (color != null) {
                float defaultOpacity = ColorHelper.int2float(DEFAULT_FILL_ALPHA.get()).floatValue();
                float opacity = c.get("fill-opacity", Float.valueOf(defaultOpacity), Float.class).floatValue();
                color = ColorHelper.alphaMultiply(color, opacity);
            }
        }
        if (color != null) {
            Float extent = c.get("fill-extent", null, Float.TYPE);
            Float extentThreshold = c.get("fill-extent-threshold", null, Float.TYPE);
            return new AreaElement(c, color, fillImage, extent, extentThreshold);
        }
        return null;
    }

    @Override
    public void paintPrimitive(IPrimitive osm, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        Color myColor = this.color;
        if (osm instanceof IWay) {
            if (this.color != null) {
                if (selected) {
                    myColor = paintSettings.getSelectedColor(this.color.getAlpha());
                } else if (outermember) {
                    myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
                }
            }
            painter.drawArea((IWay)osm, myColor, this.fillImage, this.extent, this.extentThreshold, painter.isInactiveMode() || osm.isDisabled());
        } else if (osm instanceof Relation) {
            if (this.color != null && (selected || outermember)) {
                myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
            }
            painter.drawArea((Relation)osm, myColor, this.fillImage, this.extent, this.extentThreshold, painter.isInactiveMode() || osm.isDisabled());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AreaElement that = (AreaElement)obj;
        return Objects.equals(this.color, that.color) && Objects.equals(this.fillImage, that.fillImage) && Objects.equals(this.extent, that.extent) && Objects.equals(this.extentThreshold, that.extentThreshold);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.fillImage, this.extent, this.extentThreshold);
    }

    @Override
    public String toString() {
        return "AreaElemStyle{" + super.toString() + "color=" + ColorHelper.color2html(this.color) + " fillImage=[" + this.fillImage + "] extent=[" + this.extent + "] extentThreshold=[" + this.extentThreshold + "]}";
    }
}

